#   Copyright (C) 2002-2003 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002-2003 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from tempfile import *
import tempfile
from os import *
from wave import *

class OBBCSoundTorturer:
    def __init__(self, filePrefix = mktemp()):
        self.fileName = filePrefix


    def CreateOrchestraFile(self, orchestra):
        self.inputText = "; Orchestra file"
        songInstrList = orchestra.Get()
        for i in songInstrList:
            self.inputText += "\n                instr %d" % (i+1)
            self.inputText += "\n        asig    soundin     \"" + songInstrList[i] + "\""
            self.inputText += "\n        aout  = asig"
            self.inputText += "\n                out         aout"
            self.inputText += "\n                endin\n"

        file(self.fileName + ".orc", 'w+').write(self.inputText)


    def CreateScoreFile(self, score, orchestra, tempo):
        self.inputText = "; Score file\n;%s%8s%11s" % ( "p1", "p2", "p3" )
        score.printScore()
        instrs = score.Get()
        songInstrList = orchestra.Get()
        for i in instrs:
            for j in instrs[i]:
                beat = 1.0*tempo/1000.0
                wavefile = open(songInstrList[i], 'r')
                duration = (1.0*wavefile.getnframes())/(1.0*wavefile.getframerate())
                wavefile.close()
                formatstring = "\n%s %10.3f %10.3f"
                self.inputText += formatstring %( " i%d" %( i+1 ), j*beat, duration )

        file(self.fileName + ".sco", 'w+').write(self.inputText + "\n")
        print self.inputText


    def createWaveFile(self):

        # TODO : plug a big random value in sufix
        targetWave = tempfile.mktemp() + ".wav"

        cmd = "csound -o '%s' -W '%s.orc' '%s.sco' 2>/dev/null 1>&2"
        cmd = cmd  % ( targetWave, self.fileName, self.fileName )
        print cmd
        system(cmd)
        self.PurgeFiles()
        if access(targetWave, R_OK):
            return targetWave
        else:
            raise Exception("wav file %s not found." % (targetWave))


    def PurgeFiles(self):
        if access(self.fileName + ".orc", R_OK):
            remove(self.fileName + ".orc")

        if access(self.fileName + ".sco", R_OK):
            remove(self.fileName + ".sco")

