#!/usr/bin/python

#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from qt import *
from OBBWidget import OBBWidget
from PixmapSet import *
from OBBFuncts import *

FONT_MAP = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ !"/?&*()-+=,.;:\''

ORIGIN = QPoint(0, 0)

class OBBText(OBBWidget):
    def __init__( self,
                  pixmapSet,
                  parent=None,
                  x=0,
                  y=0,
                  charWidth=23,
                  nbChar=17 ):
        self.charWidth = charWidth
        self.nbChar = nbChar
        OBBWidget.__init__(self, pixmapSet, parent, x, y)
        self.scrollOffset = 0
        #self.curText  = "          welcome to obb!" + " " * 10
        #self.curText += "this is version 0.1" + " " * 5 +":)" + " "  * 10
        #self.curText += "how do you like it so far ?" + " " * 10

        self.testText = """
        welcome to obb !
        this is version 0.1
        it's our 1st public release  :)
        let's get started...
        the green buttons with the weird shape on the right are the hit buttons
        the diamond shaped ones on the left are the command buttons
        you can click play now
        the red flashing lights are indicating the progess
        they are on under the hit button that is queried for it's state
        click on a hit button now, it should be brighter
        this means that the button will return a sound
        you always work a full cycle in advance of what you ear
        how do you like it so far?
        please visite our website : http://openbeatbox.org
        that's all for now
        click on the power button when you are ready to quit


        OBB : it's not our fault, we don't sell fuses!
        """
        
        self.curText = " "*17 + self.testText.replace('\n', '')
        #print self.testText

    def addSubWidget(self, widget):
        raise NotImplementedError()


    def updateMask(self):
        statePix = self.pixmapSet.getState(DISABLED)
        self.rect = QRect( self.pos,
                           QSize( self.charWidth * self.nbChar,
                                  statePix.height() ) )
        self.region =  QRegion(self.rect)
        self.curBoundingRect = self.region.boundingRect()
        
    def curPixmap(self, rect):
        neededPix = []
        for letter in self.curText.upper():
            neededPix.append(FONT_MAP.index(letter))
            
        statePix = self.pixmapSet.getState(self.curState)
        size = self.curBoundingRect.size()
        optimization = statePix.optimization()

        pixmap = QPixmap( size,
                          statePix.depth(),
                          optimization )
        mask = QBitmap( size,
                        1,
                        optimization )

        fontMask = statePix.mask()

        blited = 0
        for pixId in neededPix:
            self.blitGlyph( pixmap, blited, statePix, pixId )
            self.blitGlyphMask( mask, blited, fontMask, pixId )

            blited += 1
            if blited > self.nbChar+1:
                break

        pixmap.setMask(mask)

        # here, blit the curent pixmap in the new rect.
        # damn !  this will be slowwwwwwwww.
        # Must find something faster.
        #                      -- YGingras
        newPixmap = self.cropText(pixmap, rect)
        
        return newPixmap

    def cropText(self, pixmap, rect):
        if rect.height() != self.boundingRect().height():
            #  TODO : fix the damn bug that print text between the hit
            #  and the led
            #print "-" * 60
            #printRect(rect)
            #printRect(self.boundingRect())

            newPixmap =  QPixmap( rect.size(),
                                  pixmap.depth(),
                                  pixmap.optimization() )

            bitBlt( newPixmap,
                    ORIGIN, 
                    pixmap,
                    rect )
            
            newMask = QBitmap( rect.size(),
                               1,
                               pixmap.optimization() )
            #newMask.fill(Qt.color0)

            bitBlt( newMask,
                    ORIGIN, 
                    pixmap.mask(),
                    rect )

            newPixmap.setMask(newMask)
            return newPixmap

        else:
            return pixmap
        

    def blitGlyph( self,
                   dest,
                   nbCharPresent,
                   fontPixmap,
                   glyphId,
                   rOp=Qt.CopyROP ):
        bitBlt( dest,
                nbCharPresent*self.charWidth - self.scrollOffset,
                0,
                fontPixmap,
                (glyphId+1)*self.charWidth,
                0,
                self.charWidth,
                self.charWidth,
                rOp )

    def blitGlyphMask( self, dest, nbCharPresent, fontMaskPixmap, glyphId ):
        self.blitGlyph( dest,
                        nbCharPresent,
                        fontMaskPixmap,
                        glyphId,
                        Qt.OrROP )

    def scroll(self):
        self.scrollOffset = self.scrollOffset + 2 # self.charWidth/5
        if self.scrollOffset >= self.charWidth:
            self.scrollOffset = 0
            self.curText = self.curText[1:] + self.curText[:1]   
        self.parent().repaintWidget(self, self.region)

    def paintCurPixmap(self, rect, globalOffset, paintDev):
        statePix = self.curPixmap(rect)

        globalPos = addOffset(globalOffset, self.pos)

        paintDev.drawPixmap( addOffset(rect.topLeft(), globalPos),
                             statePix,
                             rect )
