#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2016    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF newton1 newton2 > ./output/res1
$NUMDIFF -#15 newton1 newton2 > ./output/res11
$NUMDIFF -X 1:5- -X 2:5- newton1 newton2 > ./output/res12
$NUMDIFF -b newton1 newton2 > ./output/res2
$NUMDIFF -b -X 1:5-6 -X 2:5-7 newton1 newton2 > ./output/res21
$NUMDIFF -b -X 1:-4 -X 1:6 -X 2:-4 -X 2:6- newton1 newton2 > ./output/res22
$NUMDIFF -b -X 1:1-5 -X 2:1-5 -X 2:7 newton1 newton2 > ./output/res23
$NUMDIFF -b -a 1.0e-4 newton1 newton2 > ./output/res3

LIST="res1 res11 res12 res2 res21 res22 res23 res3"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"
    fi
done
