#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2016    Ivano Primi  <ivprimi@libero.it>    
#
#  Copying and distribution of this file, with or without modification,
#  are permitted in any medium without royalty provided the copyright
#  notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -V many_fields1 many_fields2 > ./output/outfile # ok
$NUMDIFF -V -a 0.0 many_fields1 many_fields2 > ./output/a0.0_outfile #ok
$NUMDIFF -V -a 1.1e-3:2 many_fields1 many_fields2 > ./output/a1.1e-3:2_outfile # ok
$NUMDIFF -a 1.0e-5:2 -a 1.0e-4:2 -a 1.1e-3:2 many_fields1 many_fields2 > ./output/noV_a1.1e-3:2_outfile # ok
$NUMDIFF -V -a 1.00002e-4 many_fields1 many_fields2 > ./output/a1.00002e-4_outfile # ok
$NUMDIFF -V -a 1.00002e-4 -a 0.002:3-4 -a 0.011:4 many_fields1 many_fields2 > ./output/a1.00002e-4_a0.002:3-4_a0.011:4_outfile # ok
$NUMDIFF -V -a 1.00002e-4 -a 0.002:3-4 -a 1.01:4 many_fields1 many_fields2 > ./output/a1.00002e-4_a0.002:3-4_a1.01:4_outfile # ok
$NUMDIFF -V -a 1.00002e-4 -a 1.01:4 -a 0.002:3-4 many_fields1 many_fields2 > ./output/a1.00002e-4_a1.01:4_a0.002:3-4_outfile # ok
$NUMDIFF -V -a 1.00002e-4 -a 0.002:3-4:5-6 many_fields1 many_fields2 > ./output/a1.00002e-4_a0.002:3-4:5-6_outfile # ok
$NUMDIFF -V -a 1.00002e-4 -a 0.002:3-4:2-3 many_fields1 many_fields2 > ./output/a1.00002e-4_a0.002:3-4:2-3_outfile # ok
$NUMDIFF -V -a 1.00002e-4 -a 0.002:3-4:3-4 many_fields1 many_fields2 > ./output/a1.00002e-4_a0.002:3-4:3-4_outfile # ok

$NUMDIFF -V -r 0.0e0 many_fields1 many_fields2 > ./output/r0.0_outfile #ok
$NUMDIFF -V -r 1.001e-3:7 many_fields1 many_fields2 > ./output/r1.001e-3:7_outfile # ok
$NUMDIFF -V -r 1.001e-3:7 -r 1.01e-4:7 -r 1.00000005e-2:7 many_fields1 many_fields2 > ./output/r1.001e-3:7_r1.01e-4:7_r1.00000005e-2:7_outfile #ok
$NUMDIFF -V -r 1.00001e-3 many_fields1 many_fields2 > ./output/r1.00001e-3_outfile # ok
$NUMDIFF -V -r 1.00001e-3 -r 2.0e-3:6-7 -r0.05:7 many_fields1 many_fields2 > ./output/r1.00001e-3_r2.0e-3:6-7_r0.05:7_outfile # ok
$NUMDIFF -V -r 1.00001e-3 -r 2.0e-3:6-7 -r0.001:7 many_fields1 many_fields2 > ./output/r1.00001e-3_r2.0e-3:6-7_r0.001:7_outfile # ok
$NUMDIFF -V -r 1.00001e-3 -r0.001:7 -r 2.0e-1:6-7 many_fields1 many_fields2 > ./output/r1.00001e-3_r0.001:7_r2.0e-1:6-7_outfile # ok
$NUMDIFF -V -r 1.00001e-3 -r 2.0e-7:4-5:4-5 many_fields1 many_fields2 > ./output/r1.00001e-3_r2.0e-7:4-5:4-5_outfile # ok 
$NUMDIFF -V -r 1.00001e-3 -r 2.0e-7:4-5:5-6 many_fields1 many_fields2 > ./output/r1.00001e-3_r2.0e-7:4-5:5-6_outfile # ok 
$NUMDIFF -V -r 1.00001e-3 -r 2.0e-7:4-5:6-7 many_fields1 many_fields2 > ./output/r1.00001e-3_r2.0e-7:4-5:5-6_outfile # ok

$NUMDIFF -V -a 0.0 -r 0 many_fields1 many_fields2 > ./output/a0_r0_outfile #ok
$NUMDIFF -V -2 -a 0.0 -r .0 many_fields1 many_fields2 > ./output/2_a0_r0_outfile #ok
$NUMDIFF -V -a 1.00002e-4 -a 0.002:3-4 -a 1.01:4 -r 1.00001e-3 -r 2.0e-3:6-7 -r0.05:7 many_fields1 many_fields2 > ./output/no2_outfile # ok
$NUMDIFF -V -2 -a 1.00002e-4 -a 0.002:3-4 -a 1.01:4 -r 1.00001e-3 -r 2.0e-3:6-7 -r0.05:7 many_fields1 many_fields2 > ./output/2_outfile # ok

LIST="2_a0_r0_outfile 2_outfile a0.0_outfile a0_r0_outfile a1.00002e-4_a0.002:3-4:2-3_outfile a1.00002e-4_a0.002:3-4:3-4_outfile a1.00002e-4_a0.002:3-4:5-6_outfile a1.00002e-4_a0.002:3-4_a0.011:4_outfile a1.00002e-4_a0.002:3-4_a1.01:4_outfile a1.00002e-4_a1.01:4_a0.002:3-4_outfile a1.00002e-4_outfile a1.1e-3:2_outfile no2_outfile noV_a1.1e-3:2_outfile outfile r0.0_outfile r1.00001e-3_outfile r1.00001e-3_r0.001:7_r2.0e-1:6-7_outfile r1.00001e-3_r2.0e-3:6-7_r0.001:7_outfile r1.00001e-3_r2.0e-3:6-7_r0.05:7_outfile r1.00001e-3_r2.0e-7:4-5:4-5_outfile r1.00001e-3_r2.0e-7:4-5:5-6_outfile r1.001e-3:7_outfile r1.001e-3:7_r1.01e-4:7_r1.00000005e-2:7_outfile"

for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done
