#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2013    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3


$NUMDIFF -d., -t,. -X 1:10- -z 1:3- -z 2:3- -f register1 register2 > ./output/X10_z3_f0reg12
$NUMDIFF -d., -t,. -X 1:10- -z 1:3- -z 2:3- -V register1 register2 > ./output/X10_z3_Vreg12
$NUMDIFF -d,. -t., -X 1:-3 -X 1:7- -X 2:-3 -X 2:7- -z 1:4-6 -z 2:4-6 -f register2 register3 > ./output/X_3X7_z4_6f0reg23
$NUMDIFF -d,. -t., -X 1:-3 -X 1:7- -X 2:-3 -X 2:7- -z 1:4-6 -z 2:4-6 register2 register3 > ./output/X_3X7_z4_6reg23
$NUMDIFF -d,. -t., -X 1:-3 -X 1:7- -X 2:-3 -X 2:7- -z 1:4-6 -z 2:4-6 -V register2 register3 > ./output/X_3X7_z4_6Vreg23
$NUMDIFF -d,. -t., -X 1:2-3 -X 1:7- -X 2:2-3 -X 2:7- -z 1:4-6 -z 2:4-6 -f register2 register1 > ./output/X2_3X7_z4_6f0reg21
$NUMDIFF -d,. -t., -X 1:2-3 -X 1:7- -X 2:2-3 -X 2:7- -z 1:4-6 -z 2:4-6 -V register2 register1 > ./output/X2_3X7_z4_6Vreg21
$NUMDIFF -d., -t,. -z 1:3- -z 2:3- -f register1 register2 > ./output/z3_f0reg12
$NUMDIFF -d., -t,. -z 1:3- -z 2:3- -V register1 register2 > ./output/z3_Vreg12
$NUMDIFF -d., -t,. -Z 1:3- -Z 2:3- -f register1 register2 > ./output/Z3_f0reg12
$NUMDIFF -d., -t,. -Z 1:3- -Z 2:3- -V register1 register2 > ./output/Z3_Vreg12
$NUMDIFF -d., -t,. -X 1:1  -X 2:1 -X 1:10- -z 1:3- -z 2:3- -f register1 register2 > ./output/X1X10_z3_f0reg12
$NUMDIFF -d., -t,. -X 1:1  -X 2:1 -X 1:10- -z 1:3- -z 2:3- -V register1 register2 > ./output/X1X10_z3_Vreg12
$NUMDIFF -d., -t,. -X 1:3-4 -X 2:5-6 -X 1:9- -X 2:8 -X 2:10- -z 1:3- -z 2:3- -V register1 register2 > ./output/mixed
$NUMDIFF -d., -t,. -X 1:3-5 -X 2:4-6 -X 1:10- -X 2:10- -Z 1:3- -Z 2:3- -V register1 register2 > ./output/strange
$NUMDIFF -d., -t,. -X 1:3-5 -X 2:3-5 -X 1:8- -X 2:8- -Z 1:3- -Z 2:3- -V register1 register2 > ./output/X3_5X8_Z3_Vreg12
$NUMDIFF -d., -t,. -X 1:1  -X 2:1 -X 1:10- -Z 1:1 -Z 2:1 -z 1:3- -z 2:3- -f register1 register2 > ./output/Z1X1X10_z3_f0reg12
$NUMDIFF -d., -t,. -X 1:1  -X 2:1 -X 1:10- -Z 1:1 -Z 2:1 -z 1:3- -z 2:3- -V register1 register2 > ./output/Z1X1X10_z3_Vreg12
$NUMDIFF -d., -t,. -X 1:1  -X 2:1 -X 1:10- -z 1:1 -z 2:1 -z 1:3- -z 2:3- -f register1 register2 > ./output/z1X1X10_z3_f0reg12
$NUMDIFF -d., -t,. -X 1:1  -X 2:1 -X 1:10- -z 1:1 -z 2:1 -z 1:3- -z 2:3- -V register1 register2 > ./output/z1X1X10_z3_Vreg12

LIST="X10_z3_f0reg12 X10_z3_Vreg12 X2_3X7_z4_6Vreg21 X2_3X7_z4_6f0reg21 X_3X7_z4_6Vreg23 X_3X7_z4_6f0reg23 X_3X7_z4_6reg23 z3_f0reg12 z3_Vreg12 Z3_f0reg12 Z3_Vreg12 X1X10_z3_f0reg12 X1X10_z3_Vreg12 Z1X1X10_z3_Vreg12  Z1X1X10_z3_f0reg12  z1X1X10_z3_Vreg12  z1X1X10_z3_f0reg12 mixed strange X3_5X8_Z3_Vreg12"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

