#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2007    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF  file1 file2 > ./output/Res1
$NUMDIFF -b file1 file2 > ./output/Res1b
$NUMDIFF -V file1 file2 > ./output/Res1V
$NUMDIFF -b -V file1 file2 > ./output/Res1bV

LIST="Res1 Res1b Res1V Res1bV"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

# Common error message
# ***  End of file "file1" reached while trying to read line 7.
#      File "file2" has more lines than file "file1",
#      line 7 is the last one read from file "file2"
