#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2009    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF --test-filter=60 --blur-if-numeric=2- --expand-tabs short1 short2 > ./output/fz2_short12
$NUMDIFF --test-filter=60 --blur-if-numeric 2- --expand-tabs decimal scientific > ./output/fz2_decsci
$NUMDIFF --separator='1:$ \t\n' --separator='2:$ |\n' --minus-prefix='<-' --plus-prefix='>+' --decimal-point=._ --thousands-separator=,: --group-length=32 --exclude=1:5 --exclude=1:8 --exclude=2:3 --exclude=2:7 --blur-if-numeric=1:@ --blur-if-numeric=2:@ --test-filter list1 list2 > ./output/X1_58X2_37_f0list12
$NUMDIFF --separator '1:$ \t\n' --separator '2:$ |\n' --minus-prefix '<-' --plus-prefix '>+' --decimal-point ._ --thousands-separator ,: --group-length 32 --exclude 1:5 --exclude 1:8 --exclude 2:3 --exclude 2:7 --blur-if-numeric 1:@ --blur-if-numeric 2:@ --verbose list1 list2 > ./output/X1_58X2_37_Vlist12
$NUMDIFF --blur-if-numeric=1:3- --blur-if-numeric=2:3- --test-filter=0 --speed-large-files test17.25.1 test17.25.2 > ./output/res25H
$NUMDIFF --blur-if-numeric 1:3- --blur-if-numeric 2:3- --test-filter=0 --minimal test17.25.1 test17.25.2 > ./output/res25m
$NUMDIFF --blur-if-numeric=1:@  --blur-if-numeric 2:@ --ignore-case --verbose test16.1 test16.2   > ./output/zIV
$NUMDIFF --blur-unconditionally=1:3- --blur-unconditionally 2:3- --verbose --essential test16.1 test16.2 > ./output/Z3_ENDVE
$NUMDIFF --digits=5 --imaginary-unit=ij --exponent-letter=ed --blur-if-numeric 1:@ --blur-if-numeric 2:@ --exclude 1:2 --exclude 1:6 --exclude 1:8- --exclude 2:3-4 --exclude 2:8- test15.1 test15.2 > ./output/prec5
$NUMDIFF --digits 5 --imaginary-unit ij --exponent-letter ed --blur-if-numeric=1:@ --blur-if-numeric=2:@ --exclude=1:2 --exclude=1:6 --exclude=1:8- --exclude=2:3-4 --exclude=2:8- --verbose test15.1 test15.2 > ./output/prec5_V
$NUMDIFF --blur-unconditionally=1:2 --blur-unconditionally=2:2 --test-filter=-1 Table1 Table2 > ./output/ZfscG2
$NUMDIFF --blur-unconditionally 1:2 --blur-unconditionally 2:2 --test-filter=-1 --expand-tabs Table1 Table2 > ./output/ZfscG2T
$NUMDIFF --brief first_file second_file > ./output/Res1b
$NUMDIFF --statistics --quiet  --absolute-tolerance=0.5 --relative-tolerance 2.5e-2 file1 file2 > ./output/Res4q
$NUMDIFF --statistics --silent --absolute-tolerance=0.5 --relative-tolerance 2.5e-2 --strict file1 file2 > ./output/Res5q
$NUMDIFF --statistics --essential --absolute-tolerance=0.5 --relative-tolerance 2.5e-2 file1 file2 > ./output/Res4E
$NUMDIFF --statistics --dummy     --absolute-tolerance 0.5 --relative-tolerance=2.5e-2 --strict file1 file2 > ./output/Res5D
$NUMDIFF --statistics --positive-differences --absolute-tolerance 0.5 --relative-tolerance=2.5e-2 --strict file1 file2 > ./output/Res5P
$NUMDIFF --statistics --negative-differences --absolute-tolerance 0.5 --relative-tolerance=2.5e-2 file1 file2 > ./output/Res4N
$NUMDIFF --separator="\n\t $"  --plus-prefix P+ --minus-prefix N- --thousands-separator=_.  --decimal-point=., --output=./output/res1 --warnings-to=./output/warn1 currency1 currency2
$NUMDIFF --separator "\n\t _$" --plus-prefix=P+ --minus-prefix=N- --thousands-separator _.	 --decimal-point ., --output ./output/res2 --warnings-to ./output/warn2 currency1 currency2
$NUMDIFF --separator="\n \t:$,."         --exponent-letter d --imaginary-unit=j --decimal-point , --thousands-separator=. --group-length=3 hard1 hard2 > ./output/res4
$NUMDIFF --brief --separator "\n \t:$,." --exponent-letter=d --imaginary-unit j --decimal-point=, --thousands-separator . --group-length 3 hard1 hard2 > ./output/res5

LIST="fz2_short12 fz2_decsci X1_58X2_37_f0list12 X1_58X2_37_Vlist12 res25H res25m zIV Z3_ENDVE ZfscG2 ZfscG2T Res1b Res4q Res5q Res4E Res5D Res5P Res4N res1 res2 res4 res5"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

# Error message
# ***  End of file "first_file" reached
#      Likely the files "first_file" and "second_file" do not have the same number of lines !
