/*
    Numdiff - compare putatively similar files, 
    ignoring small numeric differences
    Copyright (C) 2005-2009  Ivano Primi  <ivprimi@libero.it>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
  Please, define just one between A_VER, H_VER and S_VER !
*/

#if !defined (A_VER) && !defined (H_VER) && !defined(S_VER)
#define S_VER 1
#endif

static 
#if defined(A_VER)
char* anum (const char *str, const struct numfmt* pnf)
#elif defined(H_VER)
char* hnum (const char *str, const struct numfmt* pnf, hash_value* ph, 
	    int im_flag, int* nonnull_digit_found)
#else
char* snum (const char *str, char** pit, const struct numfmt* pnf, 
	    int im_flag, int* nonnull_digit_found)
#endif
{
#if defined(A_VER)
  char *ptr;
  int digits, strscale;
#elif defined (H_VER)
  char *ptr;
  int digits, strscale, dp_to_hash = 1;
  unsigned char sign_to_hash = 0;

  *nonnull_digit_found = 0;
#else
  char *ptr, *it = *pit;
  int digits, strscale, dp_to_hash = 1;
  unsigned char sign_to_hash = 0;

  *nonnull_digit_found = 0;
#endif

  /* Check for valid number and count digits. */
  ptr = (char*)str;
  digits = 0;
  strscale = 0;
#ifdef A_VER
  if ( (*ptr == pnf->pos_sign) || (*ptr == pnf->neg_sign) )
    move_ahead(ptr); /* Sign */
#else
  if ( (*ptr == pnf->pos_sign) )
    {
      sign_to_hash = (im_flag) ? POS_SIGN : 0;
      move_ahead(ptr); /* Sign */
    }
  else if ( (*ptr == pnf->neg_sign) )
    {
      sign_to_hash = NEG_SIGN;
      move_ahead(ptr); /* Sign */
    }
#endif

  if (pnf->grouping > 0)
    {
      while ( (is_digit((int)*ptr)) || *ptr == pnf->thsep ) 
	{
	  int first_sep = 1;

	  if (*ptr == pnf->thsep)
	    {
	      unsigned i;
	      char* ptr2;

	      if ((first_sep))
		{
		  /* We have to check that before the separator there is */
		  /* at least one digit but no more than 'pnf->grouping' */
		  for (ptr2 = ptr; 
		       ptr2 > str && (is_digit ((int)*(ptr2-1)));
		       ptr2--);
		  if ((i=ptr-ptr2) == 0 || i > pnf->grouping)
		    {
#ifdef S_VER
		      *pit = it;
#endif
		      return (char*) str;
		    }
		  first_sep = 0;
		}
	      /* We have to check that after the separator   */
	      /* there are exactly 'pnf->grouping' digits    */
	      for (ptr2 = ptr + 1; (is_digit((int)*ptr2)); ptr2++);
	      if ((i=ptr2-ptr-1) != pnf->grouping)
		{
#ifdef S_VER
		  *pit = it;
#endif
		  return (char*) str;
		}
	      ptr++;
	    }
	  else /* We have just found a new digit */
	    {
#ifndef A_VER
	      if ((*nonnull_digit_found |= *ptr > CHAR_ZERO))
		{
#ifdef H_VER
		  if ( (sign_to_hash) )
		    {
		      *ph = HASH (*ph, sign_to_hash);
		      sign_to_hash = 0;
		    }
		  *ph = HASH (*ph, (unsigned char) *ptr);
#else
		  if ( (sign_to_hash) )
		    {
		      *it++ = (char)sign_to_hash;
		      sign_to_hash = 0;
		    }
		  *it++ = *ptr;
#endif
		}
#endif
	      move_ahead(ptr), digits++;
	    }
	}
    }
  else /* pnf->grouping == 0 */
    {
      while ( (is_digit((int)*ptr)) ) 
	{
#ifndef A_VER
	  if ((*nonnull_digit_found |= *ptr > CHAR_ZERO))
	    {
#ifdef H_VER
	      if ( (sign_to_hash) )
		{
		  *ph = HASH (*ph, sign_to_hash);
		  sign_to_hash = 0;
		}
	      *ph = HASH (*ph, (unsigned char) *ptr);
#else
	      if ( (sign_to_hash) )
		{
		  *it++ = (char)sign_to_hash;
		  sign_to_hash = 0;
		}
	      *it++ = *ptr;
#endif
	    }
#endif
	  move_ahead(ptr), digits++;	/* digits */
	}
    }
/* #ifndef A_VER */
/*   if (!*nonnull_digit_found) */
/* #ifdef H_VER */
/*     *ph = HASH (*ph, CHAR_ZERO); */
/* #else */
/*     *it++ = CHAR_ZERO; */
/* #endif */
/* #endif */

  if (*ptr == pnf->dp) 
      move_ahead(ptr);		/* decimal point */

  while ( (is_digit((int)*ptr)) )
#ifdef A_VER
    move_ahead(ptr), strscale++;	/* digits */
#else
    {
      int nzeros;

      for (nzeros = 0; *ptr == CHAR_ZERO; nzeros++, move_ahead(ptr)); 
      strscale += nzeros;
      if ( (is_digit((int)*ptr)) )
	{
	  if ( (sign_to_hash) )
	    {
#ifdef H_VER
	      *ph = HASH (*ph, sign_to_hash);
#else
	      *it++ = (char)sign_to_hash;
#endif
	      sign_to_hash = 0;
	    }
	  if ( (dp_to_hash) )
	    {
#ifdef H_VER
	      if (!*nonnull_digit_found)
		*ph = HASH (*ph, CHAR_ZERO);
	      *ph = HASH (*ph, DP);
#else
	      if (!*nonnull_digit_found)
		*it++ = CHAR_ZERO;
	      *it++ = DP;
#endif
	      *nonnull_digit_found = 1;
	      dp_to_hash = 0;
	    }
	  for (; nzeros > 0; nzeros--)
#ifdef H_VER
	    *ph = HASH (*ph, CHAR_ZERO);
	  *ph = HASH (*ph, (unsigned char) *ptr);
#else
	    *it++ = CHAR_ZERO;
	  *it++ = *ptr;
#endif
	  move_ahead(ptr), strscale++;	/* digits */	      
	}
    }
#endif

#ifdef S_VER
  *pit = it;
#endif
  if (digits+strscale == 0)
    return (char*)str;
#ifdef H_VER
  if (!*nonnull_digit_found && !im_flag)
    *ph = HASH (*ph, CHAR_ZERO);
#endif
#ifdef S_VER
  if (!*nonnull_digit_found && !im_flag)
    *it++ = CHAR_ZERO;
#endif
    
  if (toupper(*ptr) == toupper(pnf->ech) && !isspace (*(ptr+1)))
    {
      char *tail;
      long expn;

      expn = strtol (ptr + 1, &tail, 10);
#ifdef A_VER
      return (tail != ptr + 1 ? tail : ptr); 
#else
      if (tail != ptr + 1)
	{
	  if ((*nonnull_digit_found) && expn != 0)
	    {
#ifdef H_VER
	      *ph = HASH (*ph, ECH);
#else
	      *it++ = ECH;
#endif
	      if (*++ptr == '+')
		move_ahead(ptr);
	      else if (*ptr == '-')
		{
#ifdef H_VER
		  *ph = HASH (*ph, '-');
#else
		  *it++ = '-';
#endif
		  move_ahead(ptr);
		}
	      for (; *ptr == CHAR_ZERO; move_ahead (ptr));
	      if (ptr == tail)
#ifdef H_VER
		*ph = HASH (*ph, CHAR_ZERO);
#else
		*it++ = CHAR_ZERO;
#endif
	      for (; ptr < tail; move_ahead (ptr))
#ifdef H_VER
		*ph = HASH (*ph, (unsigned char) *ptr);
#else
		*it++ = *ptr;
	      *pit = it;
#endif
	    }
	  return tail;
	}
      else
	return ptr;
#endif
    }
  else
      return ptr;
} 

static
#if defined (A_VER)
char* acxnum (const char *str, const struct numfmt* pnf)
#elif defined (H_VER)
char* hcxnum (const char *str, const struct numfmt* pnf, hash_value *ph)
#else
char* scxnum (const char *str, char* buffer, const struct numfmt* pnf)
#endif
{
#if defined(S_VER)
  char *ptr, *endrp, *ptr2, *iterator = buffer;
  int nonnull_number;
#elif defined (H_VER)
  char *ptr, *endrp, *ptr2;
  int nonnull_number;
#else
  char *ptr, *endrp, *ptr2;
#endif

#if defined(A_VER)
  endrp = ptr = anum (str, pnf);
#elif defined (H_VER)
  endrp = ptr = hnum (str, pnf, ph, 0, &nonnull_number);
#else
  endrp = ptr = snum (str, &iterator, pnf, 0, &nonnull_number);
#endif
  if (ptr != str)
    {
      if (*ptr == pnf->iu)
	{
	  /*
	    We have just read a pure imaginary number
	  */
#ifndef A_VER
	  if ((nonnull_number))
#ifdef H_VER
	    *ph = HASH (*ph, IU);
#else
	    *iterator = IU;
#endif
#endif
	  return ptr + 1;
	}
      else
	{
	  /*
	    We have to see if it is possible to read a
	    full complex number
	  */
	  while (isspace (*ptr))
	    ptr++;
	  if (*ptr == POS_SIGN || *ptr == NEG_SIGN)
	    {

#if defined(A_VER)
	      ptr2 = anum (ptr, pnf);      
#elif defined(H_VER)
	      ptr2 = hnum (ptr, pnf, ph, 1, &nonnull_number);
#else /* S_VER */
	      ptr2 = snum (ptr, &iterator, pnf, 1, &nonnull_number);
#endif
	      /*
		If 'ptr2' points to the symbol of the
		imaginary unit, then we have read
		a complex number. Otherwise, we
		have just read a real number.
	      */
#ifdef A_VER
	      return (*ptr2 != pnf->iu ? endrp : ptr2 + 1);
#else
	      if (*ptr2 == pnf->iu)
		{
		  if ((nonnull_number))
#ifdef H_VER
		    *ph = HASH (*ph, IU);
#else
		    *iterator = IU; 
#endif
		  return ptr2 + 1;
		}
	      else
		return endrp;
#endif
	    }
	  /*
	    else
	    : we have successfully read just a real number
	  */
	  else
	    return endrp;
	}
    }
  /*
    else
    : 'str' does not start with a valid number 
  */
  else
    return ptr;
}
