#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2007    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF tt1 tt2 > ./output/res1
$NUMDIFF -a 1.0 tt1 tt2 > ./output/res11
$NUMDIFF -r 1.0e-1 tt1 tt2 > ./output/res12
$NUMDIFF -a 1.0 -r 1.0e-1 tt1 tt2 > ./output/res13
$NUMDIFF -a 1.0 -r 1.0e-1 -2 tt1 tt2 > ./output/res14

$NUMDIFF -s " \t\n$%_" tt1 tt2 > ./output/res2
$NUMDIFF -s " \t\n$%_" -a 0.05 tt1 tt2 > ./output/res21
$NUMDIFF -s " \t\n$%_" -r 1.7e-5 tt1 tt2 > ./output/res22
$NUMDIFF -s " \t\n$%_" -r 1.7e-5 -a 0.05 tt1 tt2 > ./output/res23
$NUMDIFF -s " \t\n$%_" -r 1.7e-5 -a 0.05 -2 tt1 tt2 > ./output/res24

$NUMDIFF -b tt1 tt2 > ./output/res3
$NUMDIFF -b -a 1.0 tt1 tt2 > ./output/res31
$NUMDIFF -b -r 1.0e-1 tt1 tt2 > ./output/res32
$NUMDIFF -b -a 1.0 -r 1.0e-1 tt1 tt2 > ./output/res33
$NUMDIFF -b -a 1.0 -r 1.0e-1 -2 tt1 tt2 > ./output/res34

$NUMDIFF -b -s " \t\n$%_" tt1 tt2 > ./output/res4
$NUMDIFF -b -s " \t\n$%_" -a 0.05 tt1 tt2 > ./output/res41
$NUMDIFF -b -s " \t\n$%_" -r 1.7e-5 tt1 tt2 > ./output/res42
$NUMDIFF -b -s " \t\n$%_" -r 1.7e-5 -a 0.05 tt1 tt2 > ./output/res43
$NUMDIFF -b -s " \t\n$%_" -r 1.7e-5 -a 0.05 -2 tt1 tt2 > ./output/res44

LIST="res1 res11 res12 res13 res14 res2 res21 res22 res23 res24 res3 res31 res32 res33 res34 res4 res41 res42 res43 res44"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

# Common error message
# ***  End of file "tt2" reached
#      Likely the files "tt1" and "tt2" do not have the same number of lines !
