#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2007    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF newton1 newton2 > ./output/res1
$NUMDIFF -#15 newton1 newton2 > ./output/res11
$NUMDIFF -F 1-4 newton1 newton2 > ./output/res12
$NUMDIFF -b newton1 newton2 > ./output/res2
$NUMDIFF -b -F 1-4 newton1 newton2 > ./output/res21
$NUMDIFF -b -F 5 newton1 newton2 > ./output/res22
$NUMDIFF -b -F 6 newton1 newton2 > ./output/res23
$NUMDIFF -b -F 6 -F 5-5 -L 100-210 newton1 newton2 > ./output/res24
$NUMDIFF -b -F 5-6 -L 100-210 newton1 newton2 > ./output/res25

$NUMDIFF -b -a 1.0e-4 newton1 newton2 > ./output/res3
$NUMDIFF -b -a 1.0e-4 -L 80-120 newton1 newton2 > ./output/res31
$NUMDIFF -b -a 1.0e-4 -L 80-120 -F 5 newton1 newton2 > ./output/res32
$NUMDIFF -b -a 1.0e-4 -L 80-120 -F 6 newton1 newton2 > ./output/res33
$NUMDIFF -b -a 1.0e-4 -L 80-120 -F 5-6 newton1 newton2 > ./output/res34

# Note: Only the second line range is considered
$NUMDIFF -b -r 0.95e-4 -L 100-200 -L 500-1001 -F 6 newton1 newton2 > ./output/res4
$NUMDIFF -b -r 0.95e-4 -a 1.0e-3 -L 100-200 -L 500-1001 -F 6 newton1 newton2 > ./output/res41
$NUMDIFF -b -r 0.95e-4 -a 1.0e-3 -2 -L 100-200 -L 500-1001 -F 6 newton1 newton2 > ./output/res42

LIST="res1 res11 res12 res2 res21 res22 res23 res24 res25 res3 res31 res32 res33 res34"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

