/*
    Copyright (C) 2005,2006  Ivano Primi  <ivprimi@libero.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include<stdio.h>
#include"number.h"

extern void out_char (int ch);
extern void bc_print_num (bc_num num, void (* out_char)(int), int prec);

#define SCALE 30 

bc_num Sqrt (bc_num x)
{
  bc_num y;

  bc_init_num (&y);
  y = bc_copy_num (x);
  bc_sqrt (&y, SCALE);
  return y;
}

int main (void)
{
  bc_num x;
  bc_num sqrt_x;
  int i;

  bc_init_numbers();
  bc_init_num (&x);
  for (i=0; i<= 100; i++)
    {
      bc_int2num (&x, i);
      sqrt_x = Sqrt(x);
      printf ("x = %3d, sqrt(x) = ", i);
      bc_print_num (sqrt_x, out_char, 10);
      putchar('\n');
      bc_free_num (&sqrt_x);
    }
  bc_free_num (&x);
  bc_end();
  return 0;
}
