/* numcosmo-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Nc", gir_namespace = "NumCosmo", gir_version = "1.0", lower_case_cprefix = "nc_")]
namespace Nc {
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_abundance_get_type ()")]
	public class ClusterAbundance : GLib.Object {
		[CCode (has_construct_function = false)]
		public ClusterAbundance (Nc.MassFunction mfp, Nc.HaloBiasFunc? mbiasf, Nc.ClusterRedshift clusterz, Nc.ClusterMass clusterm);
		public static void clear (Nc.ClusterAbundance cad);
		public Nc.ClusterAbundance copy ();
		public double d2n (Nc.HICosmo model, double lnM, double z);
		public void free ();
		public Nc.ClusterMass get_mass ();
		public Nc.ClusterRedshift get_redshift ();
		public double intp_d2n (Nc.HICosmo model, double lnM, double z);
		public double lnm_p_d2n (Nc.HICosmo model, double lnM_obs, double lnM_obs_params, double z);
		public double n (Nc.HICosmo model);
		public unowned Nc.ClusterMass peek_mass ();
		public unowned Nc.ClusterRedshift peek_redshift ();
		public void prepare (Nc.HICosmo model);
		public void prepare_inv_dNdlnM_z (Nc.HICosmo model, double z);
		public void prepare_inv_dNdz (Nc.HICosmo model);
		public Nc.ClusterAbundance @ref ();
		public void set_mass (Nc.ClusterMass clusterm);
		public void set_redshift (Nc.ClusterRedshift clusterz);
		public double true_n (Nc.HICosmo model);
		public double z_p_d2n (Nc.HICosmo model, double lnM, double z_obs, double z_obs_params);
		public double z_p_lnm_p_d2n (Nc.HICosmo model, double lnM_obs, double lnM_obs_params, double z_obs, double z_obs_params);
		public Nc.ClusterMass mass { owned get; set construct; }
		[NoAccessorMethod]
		public Nc.MassFunction mass_function { owned get; construct; }
		[NoAccessorMethod]
		public Nc.HaloBiasFunc mean_bias { owned get; construct; }
		public Nc.ClusterRedshift redshift { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	[Compact]
	public class ClusterAbundanceDataBin {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	[Compact]
	public class ClusterAbundanceDataBinM {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	[Compact]
	public class ClusterAbundanceDataBinZ {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	[Compact]
	public class ClusterAbundanceDataP {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_get_type ()")]
	public abstract class ClusterMass : Ncm.Model {
		[CCode (has_construct_function = false)]
		protected ClusterMass ();
		[NoWrapper]
		public virtual void N_limits (Nc.HICosmo model, double lnM_lower, double lnM_upper);
		[NoWrapper]
		public virtual double P (Nc.HICosmo model, double lnM, double z, double lnM_obs, double lnM_obs_params);
		[NoWrapper]
		public virtual void P_limits (Nc.HICosmo model, double lnM_obs, double lnM_obs_params, double lnM_lower, double lnM_upper);
		public static void clear (Nc.ClusterMass clusterm);
		public void free ();
		[CCode (has_construct_function = false)]
		public ClusterMass.from_name (string mass_name);
		public Nc.ClusterMassImpl impl ();
		[NoWrapper]
		public virtual double intP (Nc.HICosmo model, double lnM, double z);
		public double intp (Nc.HICosmo model, double lnM, double z);
		public static void log_all_models ();
		public void n_limits (Nc.HICosmo model, out double lnM_lower, out double lnM_upper);
		public virtual uint obs_len ();
		public virtual uint obs_params_len ();
		public double p (Nc.HICosmo model, double lnM, double z, double lnM_obs, double lnM_obs_params);
		public void p_limits (Nc.HICosmo model, double lnM_obs, double lnM_obs_params, out double lnM_lower, out double lnM_upper);
		public Nc.ClusterMass @ref ();
		public virtual bool resample (Nc.HICosmo model, double lnM, double z, out double lnM_obs, out double lnM_obs_params);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_benson_get_type ()")]
	public class ClusterMassBenson : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassBenson ();
		[NoAccessorMethod]
		public double Asz { get; set; }
		[NoAccessorMethod]
		public bool Asz_fit { get; set; }
		[NoAccessorMethod]
		public double Bsz { get; set; }
		[NoAccessorMethod]
		public bool Bsz_fit { get; set; }
		[NoAccessorMethod]
		public double Csz { get; set; }
		[NoAccessorMethod]
		public bool Csz_fit { get; set; }
		[NoAccessorMethod]
		public double Dsz { get; set; }
		[NoAccessorMethod]
		public bool Dsz_fit { get; set; }
		[NoAccessorMethod]
		public double M0 { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_max { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_min { get; construct; }
		[NoAccessorMethod]
		public double z0 { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_benson_xray_get_type ()")]
	public class ClusterMassBensonXRay : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassBensonXRay ();
		[NoAccessorMethod]
		public double Asz { get; set; }
		[NoAccessorMethod]
		public bool Asz_fit { get; set; }
		[NoAccessorMethod]
		public double Ax { get; set; }
		[NoAccessorMethod]
		public bool Ax_fit { get; set; }
		[NoAccessorMethod]
		public double Bsz { get; set; }
		[NoAccessorMethod]
		public bool Bsz_fit { get; set; }
		[NoAccessorMethod]
		public double Bx { get; set; }
		[NoAccessorMethod]
		public bool Bx_fit { get; set; }
		[NoAccessorMethod]
		public double Csz { get; set; }
		[NoAccessorMethod]
		public bool Csz_fit { get; set; }
		[NoAccessorMethod]
		public double Cx { get; set; }
		[NoAccessorMethod]
		public bool Cx_fit { get; set; }
		[NoAccessorMethod]
		public double Dsz { get; set; }
		[NoAccessorMethod]
		public bool Dsz_fit { get; set; }
		[NoAccessorMethod]
		public double Dx { get; set; }
		[NoAccessorMethod]
		public bool Dx_fit { get; set; }
		[NoAccessorMethod]
		public double M0 { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_max { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_min { get; construct; }
		[NoAccessorMethod]
		public double z0 { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_lnnormal_get_type ()")]
	public class ClusterMassLnnormal : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassLnnormal ();
		[NoAccessorMethod]
		public double lnMobs_max { get; construct; }
		[NoAccessorMethod]
		public double lnMobs_min { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_nodist_get_type ()")]
	public class ClusterMassNodist : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassNodist ();
		[NoAccessorMethod]
		public double lnM_max { get; construct; }
		[NoAccessorMethod]
		public double lnM_min { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_vanderlinde_get_type ()")]
	public class ClusterMassVanderlinde : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassVanderlinde ();
		[NoAccessorMethod]
		public double Asz { get; set; }
		[NoAccessorMethod]
		public bool Asz_fit { get; set; }
		[NoAccessorMethod]
		public double Bsz { get; set; }
		[NoAccessorMethod]
		public bool Bsz_fit { get; set; }
		[NoAccessorMethod]
		public double Csz { get; set; }
		[NoAccessorMethod]
		public bool Csz_fit { get; set; }
		[NoAccessorMethod]
		public double Dsz { get; set; }
		[NoAccessorMethod]
		public bool Dsz_fit { get; set; }
		[NoAccessorMethod]
		public double M0 { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_max { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_min { get; construct; }
		[NoAccessorMethod]
		public double z0 { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_photoz_gauss_get_type ()")]
	public class ClusterPhotozGauss : Nc.ClusterRedshift {
		[CCode (has_construct_function = false, type = "NcClusterRedshift*")]
		public ClusterPhotozGauss ();
		[NoAccessorMethod]
		public double pz_max { get; construct; }
		[NoAccessorMethod]
		public double pz_min { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_photoz_gauss_global_get_type ()")]
	public class ClusterPhotozGaussGlobal : Nc.ClusterRedshift {
		[CCode (has_construct_function = false, type = "NcClusterRedshift*")]
		public ClusterPhotozGaussGlobal (double pz_min, double pz_max, double z_bias, double sigma0);
		public double get_sigma0 ();
		public double get_z_bias ();
		public void set_sigma0 (double sigma0);
		public void set_z_bias (double z_bias);
		[NoAccessorMethod]
		public double pz_max { get; construct; }
		[NoAccessorMethod]
		public double pz_min { get; construct; }
		public double sigma0 { get; construct; }
		public double z_bias { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_redshift_get_type ()")]
	public abstract class ClusterRedshift : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ClusterRedshift ();
		[NoWrapper]
		public virtual void N_limits (double z_lower, double z_upper);
		[NoWrapper]
		public virtual double P (double lnM, double z, double z_obs, double z_obs_params);
		[NoWrapper]
		public virtual void P_limits (double z_obs, double z_obs_params, double z_lower, double z_upper);
		public static void clear (Nc.ClusterRedshift clusterz);
		public void free ();
		[CCode (has_construct_function = false)]
		public ClusterRedshift.from_name (string redshift_name);
		public Nc.ClusterRedshiftImpl impl ();
		[NoWrapper]
		public virtual double intP (double lnM, double z);
		public double intp (double lnM, double z);
		public void n_limits (out double z_lower, out double z_upper);
		public virtual uint obs_len ();
		public virtual uint obs_params_len ();
		public double p (double lnM, double z, double z_obs, double z_obs_params);
		public void p_limits (double z_obs, double z_obs_params, out double z_lower, out double z_upper);
		public Nc.ClusterRedshift @ref ();
		public virtual bool resample (double lnM, double z, out double z_obs, out double z_obs_params);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_redshift_nodist_get_type ()")]
	public class ClusterRedshiftNodist : Nc.ClusterRedshift {
		[CCode (has_construct_function = false)]
		protected ClusterRedshiftNodist ();
		[NoAccessorMethod]
		public double z_max { get; construct; }
		[NoAccessorMethod]
		public double z_min { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_bao_a_get_type ()")]
	public class DataBaoA : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataBaoA (Nc.Distance dist, Nc.DataBaoId id);
		public Nc.DataBaoId get_sample ();
		public uint get_size ();
		public void set_sample (Nc.DataBaoId id);
		public void set_size (uint np);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public Nc.DataBaoId sample_id { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_bao_dv_get_type ()")]
	public class DataBaoDV : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataBaoDV (Nc.Distance dist, Nc.DataBaoId id);
		public Nc.DataBaoId get_sample ();
		public uint get_size ();
		public void set_sample (Nc.DataBaoId id);
		public void set_size (uint np);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public Nc.DataBaoId sample_id { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_bao_dvdv_get_type ()")]
	public class DataBaoDVDV : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataBaoDVDV (Nc.Distance dist, Nc.DataBaoId id);
		public Nc.DataBaoId get_sample ();
		public void set_sample (Nc.DataBaoId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public Nc.DataBaoId sample_id { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_bao_rdv_get_type ()")]
	public class DataBaoRDV : Ncm.DataGauss {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataBaoRDV (Nc.Distance dist, Nc.DataBaoId id);
		public Nc.DataBaoId get_sample ();
		public uint get_size ();
		public void set_sample (Nc.DataBaoId id);
		public void set_size (uint np);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public Nc.DataBaoId sample_id { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_cmb_dist_priors_get_type ()")]
	public class DataCMBDistPriors : Ncm.DataGauss {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataCMBDistPriors (Nc.Distance dist, Nc.DataCMBId id);
		public Nc.DataCMBId get_sample ();
		public void set_sample (Nc.DataCMBId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public Nc.DataCMBId sample_id { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_cmb_shift_param_get_type ()")]
	public class DataCMBShiftParam : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataCMBShiftParam (Nc.Distance dist, Nc.DataCMBId id);
		public Nc.DataCMBId get_sample ();
		public void set_sample (Nc.DataCMBId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public Nc.DataCMBId sample_id { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_cluster_ncount_get_type ()")]
	public class DataClusterNCount : Ncm.Data {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataClusterNCount (Nc.ClusterAbundance cad);
		public static void binned_init_from_sampling (Ncm.Data data, Ncm.MSet mset, Ncm.Vector nodes, bool obs, double area_survey, double lnMi, double lnMf, double photoz_sigma0, double photoz_bias, double lnM_sigma0, double lnM_bias);
		public static void binned_init_from_text_file_gkey (Ncm.Data data, bool obs, string filename);
		[CCode (cname = "nc_data_cluster_ncount_binned_lnM_z_new", has_construct_function = false, type = "NcmData*")]
		public DataClusterNCount.binned_lnM_z_new (Nc.ClusterAbundance cad);
		[CCode (cname = "nc_data_cluster_ncount_binned_new", has_construct_function = false, type = "NcmData*")]
		public DataClusterNCount.binned_new (Nc.ClusterAbundance cad);
		public static void binned_save (Ncm.Data data, string filename);
		public void free ();
		public static void init_from_sampling (Ncm.Data data, Ncm.MSet mset, Nc.ClusterRedshift clusterz, Nc.ClusterMass clusterm, double area_survey);
		public static void print (Ncm.Data data, Nc.HICosmo cosmo, void* @out, string header);
		public Nc.DataClusterNCount @ref ();
		public static void true_data (Ncm.Data data, bool use_true_data);
		[NoAccessorMethod]
		public Nc.ClusterAbundance cluster_abundance { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_cluster_poisson_get_type ()")]
	public class DataClusterPoisson : Ncm.DataPoisson {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataClusterPoisson (Nc.DataClusterNCount ncount);
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataClusterPoisson.cad (Nc.ClusterAbundance cad);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_dist_mu_get_type ()")]
	public class DataDistMu : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataDistMu (Nc.Distance dist, Nc.DataSNIAId id);
		public Nc.DataSNIAId get_sample ();
		public uint get_size ();
		public void set_sample (Nc.DataSNIAId id);
		public void set_size (uint np);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public Nc.DataSNIAId sample_id { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_hubble_get_type ()")]
	public class DataHubble : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataHubble (Nc.DataHubbleId id);
		public Nc.DataHubbleId get_sample ();
		public uint get_size ();
		public void set_sample (Nc.DataHubbleId id);
		public void set_size (uint np);
		[NoAccessorMethod]
		public Nc.DataHubbleId sample_id { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_snia_cov_get_type ()")]
	public class DataSNIACov : Ncm.DataGaussCov {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataSNIACov (Nc.SNIADistCov dcov, bool use_det);
		public void set_dcov (Nc.SNIADistCov dcov);
		[NoAccessorMethod]
		public Nc.SNIADistCov dcov { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_distance_get_type ()")]
	public class Distance : GLib.Object {
		[CCode (has_construct_function = false)]
		public Distance (double z_f);
		public double Omega_k (Nc.HICosmo cosmo);
		public double acoustic_scale (Nc.HICosmo cosmo);
		public double bao_A_scale (Nc.HICosmo cosmo, double z);
		public double bao_r_Dv (Nc.HICosmo cosmo, double z);
		public static void clear (Nc.Distance dist);
		public double comoving (Nc.HICosmo cosmo, double z);
		public double comoving_a0 (Nc.HICosmo cosmo, double z);
		public double comoving_a0_lss (Nc.HICosmo cosmo);
		public double comoving_lss (Nc.HICosmo cosmo);
		public double conformal_lookback_time (Nc.HICosmo cosmo, double z);
		public double conformal_time (Nc.HICosmo cosmo, double z);
		public double conformal_time_mks_scale (Nc.HICosmo cosmo);
		public double cosmic_time (Nc.HICosmo cosmo, double z);
		public double cosmic_time_mks_scale (Nc.HICosmo cosmo);
		public double curvature (Nc.HICosmo cosmo, double z);
		public double decoupling_redshift (Nc.HICosmo cosmo);
		public double dilation_scale (Nc.HICosmo cosmo, double z);
		public double drag_redshift (Nc.HICosmo cosmo);
		public void free ();
		public Ncm.MSetFunc func0_new (Nc.DistanceFunc0 f0);
		public Ncm.MSetFunc func1_new (Nc.DistanceFunc1 f1);
		public double hubble (Nc.HICosmo cosmo);
		public double lookback_time (Nc.HICosmo cosmo, double z);
		public double luminosity (Nc.HICosmo cosmo, double z);
		public double luminosity_hef (Nc.HICosmo cosmo, double z_he, double z_cmb);
		public double modulus (Nc.HICosmo cosmo, double z);
		public double modulus_hef (Nc.HICosmo cosmo, double z_he, double z_cmb);
		public void prepare (Nc.HICosmo cosmo);
		public void prepare_if_needed (Nc.HICosmo cosmo);
		public Nc.Distance @ref ();
		public double shift_parameter (Nc.HICosmo cosmo, double z);
		public double shift_parameter_lss (Nc.HICosmo cosmo);
		public double sound_horizon (Nc.HICosmo cosmo, double z);
		public double transverse (Nc.HICosmo cosmo, double z);
		[NoAccessorMethod]
		public double zf { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_galaxy_acf_get_type ()")]
	public class GalaxyAcf : GLib.Object {
		[CCode (has_construct_function = false)]
		public GalaxyAcf (Nc.GrowthFunc gf, Nc.Distance dist, Nc.TransferFunc tf);
		public void prepare_psi (Nc.HICosmo model, uint l);
		public double psi (Nc.HICosmo model, double k, uint l);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_growth_func_get_type ()")]
	public class GrowthFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		public GrowthFunc ();
		public static void clear (Nc.GrowthFunc gf);
		public Nc.GrowthFunc copy ();
		public double eval (Nc.HICosmo model, double z);
		public void eval_both (Nc.HICosmo model, double z, double d, double f);
		public double eval_deriv (Nc.HICosmo model, double z);
		public void free ();
		public void prepare (Nc.HICosmo model);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo", type_id = "nc_hicosmo_get_type ()")]
	public abstract class HICosmo : Ncm.Model {
		[CCode (has_construct_function = false)]
		protected HICosmo ();
		public double E (double z);
		public double E2 (double x);
		public double H (double z);
		public double H0 ();
		public double Omega_b ();
		public double Omega_c ();
		public double Omega_k ();
		public double Omega_m ();
		public double Omega_r ();
		public double Omega_t ();
		public double T_gamma0 ();
		public double c_H0 ();
		public double cd (double x);
		public static Ncm.MSetFunc create_mset_func0 (Nc.HICosmoFunc0 f0);
		public static Ncm.MSetFunc create_mset_func1 (Nc.HICosmoFunc1 f1);
		public double d2E2_dz2 (double x);
		public double dE2_dz (double x);
		public double dH_dz (double z);
		public void de_omega_x2omega_k ();
		public void de_set_wmap5_params ();
		public void free ();
		[CCode (has_construct_function = false)]
		public HICosmo.from_name (GLib.Type parent_type, string cosmo_name);
		public double h ();
		public double h2 ();
		public static int32 id ();
		public double j (double z);
		public static void log_all_models (GLib.Type parent);
		public double powspec (double x);
		public static void prior_top_add (Ncm.Likelihood lh, double z, double alpha, double sigma_alpha, int n);
		public static void prior_top_free (Nc.HICosmoPriorTop tp);
		public static void prior_top_set (Nc.HICosmoPriorTop tp, double z, double alpha, double sigma_alpha, int n);
		public double q (double z);
		public static double qg_V (Ncm.Model model, double x, void* userdata);
		public static double qg_V_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_alphaprime2 (Ncm.Model model, double alpha, void* data);
		public static double qg_beta (Ncm.Model model, double x, void* userdata);
		public static double qg_cs2 (Ncm.Model model, double x, void* userdata);
		public static double qg_cs2_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_cs2_xxbar2 (Ncm.Model model, double x, void* userdata);
		public static double qg_cs2zeta2_int_1_zeta2_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_d2sqrtxxbarzeta_sqrtxxbarzeta (Ncm.Model model, double x, void* userdata);
		public static double qg_dalphaprime2_dalpha (Ncm.Model model, double alpha, void* data);
		public static double qg_dcs2 (Ncm.Model model, double x, void* userdata);
		public static double qg_ddzeta_zeta (Ncm.Model model, double x, void* userdata);
		public static double qg_dxxbarzeta2_xxbarzeta2 (Ncm.Model model, double x, void* userdata);
		public static double qg_dzeta_zeta (Ncm.Model model, double x, void* userdata);
		public static double qg_eta_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_gbar2 (Ncm.Model model, double x);
		public static double qg_gbar_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_gbarbar (Ncm.Model model, double x);
		public static double qg_gbarbar_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_get_eta_b (Ncm.Model model, void* userdata);
		public static double qg_get_lambda_d (Ncm.Model model, void* userdata);
		public static double qg_get_lambda_f (Ncm.Model model, void* userdata);
		public static double qg_get_lambda_i (Ncm.Model model, void* userdata);
		public static double qg_int_1_zeta2_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_lambda_k_cross (Ncm.Model model, double lambda, bool deriv);
		public static double qg_lambda_x (Ncm.Model model, double x, void* userdata);
		public static void qg_max_z (Ncm.Model model, double max, double trans);
		public static bool qg_modefunc_evolve (Nc.HICosmoQGMode qgmode);
		public static bool qg_modefunc_init (Nc.HICosmoQGMode qgmode);
		public static bool qg_modefunc_set_opts (Nc.HICosmoQGMode qgmode);
		public static bool qg_modefuncm_cvode_init (Nc.HICosmoQGMode qgmode);
		[CCode (cname = "nc_hicosmo_qg_new", has_construct_function = false)]
		public HICosmo.qg_new ();
		public static void qg_pert_R_to_h (Nc.HICosmoQGMode qgmode, double x, double R);
		public static bool qg_pert_evolve (Nc.HICosmoQGMode qgmode);
		public static void qg_pert_h_to_R (Nc.HICosmoQGMode qgmode, double x, double h);
		public static bool qg_pert_init (Nc.HICosmoQGMode qgmode, double k);
		public static double qg_pert_powerspectrum (Nc.HICosmoQGMode qgmode, double x, double R);
		public static bool qg_pert_prepare_pw_spline (Nc.HICosmoQGMode qgmode, bool verbose);
		public static bool qg_pert_set_opts (Nc.HICosmoQGMode qgmode);
		public static double qg_x_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_xbar (Ncm.Model model, double x, void* userdata);
		public static double qg_xddzeta_zeta_mxdzeta_zeta2_dzeta_zeta (Ncm.Model model, double x, void* userdata);
		public static double qg_xxbarzeta2 (Ncm.Model model, double x, void* userdata);
		public static double qg_zeta (Ncm.Model model, double x, void* userdata);
		public double qp (double z);
		public double sigma_8 ();
		public double z_lss ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de", type_id = "nc_hicosmo_de_get_type ()")]
	public abstract class HICosmoDE : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		protected HICosmoDE ();
		public double dweff_dz (double x);
		public static bool new_add_bbn (Ncm.Likelihood lh);
		public double weff (double x);
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegab { get; set; }
		[NoAccessorMethod]
		public bool Omegab_fit { get; set; }
		[NoAccessorMethod]
		public double Omegac { get; set; }
		[NoAccessorMethod]
		public bool Omegac_fit { get; set; }
		[NoAccessorMethod]
		public double Omegax { get; set; }
		[NoAccessorMethod]
		public bool Omegax_fit { get; set; }
		[NoAccessorMethod]
		public double Tgamma0 { get; set; }
		[NoAccessorMethod]
		public bool Tgamma0_fit { get; set; }
		[NoAccessorMethod]
		public double ns { get; set; }
		[NoAccessorMethod]
		public bool ns_fit { get; set; }
		[NoAccessorMethod]
		public double sigma8 { get; set; }
		[NoAccessorMethod]
		public bool sigma8_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de_linder", type_id = "nc_hicosmo_de_linder_get_type ()")]
	public class HICosmoDELinder : Nc.HICosmoDE {
		[CCode (has_construct_function = false)]
		public HICosmoDELinder ();
		[NoAccessorMethod]
		public double w0 { get; set; }
		[NoAccessorMethod]
		public bool w0_fit { get; set; }
		[NoAccessorMethod]
		public double w1 { get; set; }
		[NoAccessorMethod]
		public bool w1_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de_pad", type_id = "nc_hicosmo_de_pad_get_type ()")]
	public class HICosmoDEPad : Nc.HICosmoDE {
		[CCode (has_construct_function = false)]
		public HICosmoDEPad ();
		[NoAccessorMethod]
		public double w0 { get; set; }
		[NoAccessorMethod]
		public bool w0_fit { get; set; }
		[NoAccessorMethod]
		public double w1 { get; set; }
		[NoAccessorMethod]
		public bool w1_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de_qe", type_id = "nc_hicosmo_de_qe_get_type ()")]
	public class HICosmoDEQe : Nc.HICosmoDE {
		[CCode (has_construct_function = false)]
		public HICosmoDEQe ();
		[NoAccessorMethod]
		public double w0 { get; set; }
		[NoAccessorMethod]
		public bool w0_fit { get; set; }
		[NoAccessorMethod]
		public double w1 { get; set; }
		[NoAccessorMethod]
		public bool w1_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de_xcdm", type_id = "nc_hicosmo_de_xcdm_get_type ()")]
	public class HICosmoDEXcdm : Nc.HICosmoDE {
		[CCode (has_construct_function = false)]
		public HICosmoDEXcdm ();
		[NoAccessorMethod]
		public double w { get; set; }
		[NoAccessorMethod]
		public bool w_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_lcdm", type_id = "nc_hicosmo_lcdm_get_type ()")]
	public class HICosmoLCDM : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		public HICosmoLCDM ();
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegab { get; set; }
		[NoAccessorMethod]
		public bool Omegab_fit { get; set; }
		[NoAccessorMethod]
		public double Omegac { get; set; }
		[NoAccessorMethod]
		public bool Omegac_fit { get; set; }
		[NoAccessorMethod]
		public double Omegax { get; set; }
		[NoAccessorMethod]
		public bool Omegax_fit { get; set; }
		[NoAccessorMethod]
		public double Tgamma0 { get; set; }
		[NoAccessorMethod]
		public bool Tgamma0_fit { get; set; }
		[NoAccessorMethod]
		public double ns { get; set; }
		[NoAccessorMethod]
		public bool ns_fit { get; set; }
		[NoAccessorMethod]
		public double sigma8 { get; set; }
		[NoAccessorMethod]
		public bool sigma8_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_qconst", type_id = "nc_hicosmo_qconst_get_type ()")]
	public class HICosmoQConst : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		public HICosmoQConst ();
		[NoAccessorMethod]
		public double E { get; set; }
		[NoAccessorMethod]
		public bool E_fit { get; set; }
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegat { get; set; }
		[NoAccessorMethod]
		public bool Omegat_fit { get; set; }
		[NoAccessorMethod]
		public double cd { get; set; }
		[NoAccessorMethod]
		public bool cd_fit { get; set; }
		[NoAccessorMethod]
		public double q { get; set; }
		[NoAccessorMethod]
		public bool q_fit { get; set; }
		[NoAccessorMethod]
		public double zs { get; set; }
		[NoAccessorMethod]
		public bool zs_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_qlinear", type_id = "nc_hicosmo_qlinear_get_type ()")]
	public class HICosmoQLinear : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		public HICosmoQLinear ();
		public static double dE (double z2, double z1, double q, double qp);
		[NoAccessorMethod]
		public double E { get; set; }
		[NoAccessorMethod]
		public bool E_fit { get; set; }
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegat { get; set; }
		[NoAccessorMethod]
		public bool Omegat_fit { get; set; }
		[NoAccessorMethod]
		public double cd { get; set; }
		[NoAccessorMethod]
		public bool cd_fit { get; set; }
		[NoAccessorMethod]
		public double q { get; set; }
		[NoAccessorMethod]
		public bool q_fit { get; set; }
		[NoAccessorMethod]
		public double qp { get; set; }
		[NoAccessorMethod]
		public bool qp_fit { get; set; }
		[NoAccessorMethod]
		public double zs { get; set; }
		[NoAccessorMethod]
		public bool zs_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_qpw", type_id = "nc_hicosmo_qpw_get_type ()")]
	public class HICosmoQPW : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		public HICosmoQPW (uint npieces, double z_f, bool flat);
		public void add_asymptotic_cdm_prior (Ncm.Likelihood lh, double z, double q, double sigma);
		public void add_continuity_prior (Ncm.Likelihood lh, int knot, double sigma);
		public void add_continuity_priors (Ncm.Likelihood lh, double sigma);
		public void change_params (double z);
		public void change_params_qpp ();
		public uint index (double z);
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegat { get; set; }
		[NoAccessorMethod]
		public bool Omegat_fit { get; set; }
		[NoAccessorMethod]
		public bool flat { get; construct; }
		[NoAccessorMethod]
		public double q0 { get; set; }
		[NoAccessorMethod]
		public bool q0_fit { get; set; }
		[NoAccessorMethod]
		public GLib.Variant qp { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant qp_fit { owned get; set; }
		[NoAccessorMethod]
		public uint qp_length { get; construct; }
		[NoAccessorMethod]
		public double zf { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_qspline", type_id = "nc_hicosmo_qspline_get_type ()")]
	public class HICosmoQSpline : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		public HICosmoQSpline (Ncm.Spline s, size_t np, double z_f);
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegat { get; set; }
		[NoAccessorMethod]
		public bool Omegat_fit { get; set; }
		[NoAccessorMethod]
		public GLib.Variant qparam { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant qparam_fit { owned get; set; }
		[NoAccessorMethod]
		public uint qparam_length { get; construct; }
		[NoAccessorMethod]
		public Ncm.Spline spline { owned get; construct; }
		[NoAccessorMethod]
		public double zf { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_func_get_type ()")]
	public class HaloBiasFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		public HaloBiasFunc (Nc.MassFunction mfp, Nc.HaloBiasType? biasf);
		public static void clear (Nc.HaloBiasFunc mbiasf);
		public Nc.HaloBiasFunc copy ();
		public void free ();
		public double integrand (Nc.HICosmo model, double lnM, double z);
		[NoAccessorMethod]
		public Nc.HaloBiasType bias_type { owned get; construct; }
		[NoAccessorMethod]
		public Nc.MassFunction mass_function { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_get_type ()")]
	public abstract class HaloBiasType : GLib.Object {
		[CCode (has_construct_function = false)]
		protected HaloBiasType ();
		public static void clear (Nc.HaloBiasType biasf);
		public virtual double eval (double sigma, double z);
		public void free ();
		[CCode (has_construct_function = false)]
		public HaloBiasType.from_name (string bias_name);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_ps_get_type ()")]
	public class HaloBiasTypePS : Nc.HaloBiasType {
		[CCode (has_construct_function = false, type = "NcHaloBiasType*")]
		public HaloBiasTypePS (double delta_c);
		public double get_delta_c ();
		public void set_delta_c (double delta_c);
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_st_ellip_get_type ()")]
	public class HaloBiasTypeSTEllip : Nc.HaloBiasType {
		[CCode (has_construct_function = false, type = "NcHaloBiasType*")]
		public HaloBiasTypeSTEllip (double delta_c, double a, double b, double c);
		public double get_a ();
		public double get_b ();
		public double get_c ();
		public double get_delta_c ();
		public void set_a (double a);
		public void set_b (double b);
		public void set_c (double c);
		public void set_delta_c (double delta_c);
		public double a { get; construct; }
		public double b { get; construct; }
		public double c { get; construct; }
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_st_spher_get_type ()")]
	public class HaloBiasTypeSTSpher : Nc.HaloBiasType {
		[CCode (has_construct_function = false, type = "NcHaloBiasType*")]
		public HaloBiasTypeSTSpher (double delta_c, double a, double p);
		public double get_a ();
		public double get_delta_c ();
		public double get_p ();
		public void set_a (double a);
		public void set_delta_c (double delta_c);
		public void set_p (double p);
		public double a { get; construct; }
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
		public double p { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_tinker_get_type ()")]
	public class HaloBiasTypeTinker : Nc.HaloBiasType {
		[CCode (has_construct_function = false, type = "NcHaloBiasType*")]
		public HaloBiasTypeTinker (double delta_c, double B, double b, double c, double Delta);
		public double get_B ();
		public double get_Delta ();
		public double get_b ();
		public double get_c ();
		public double get_delta_c ();
		public void set_B (double B);
		public void set_Delta (double Delta);
		public void set_b (double b);
		public void set_c (double c);
		public void set_delta_c (double delta_c);
		public double B { get; construct; }
		public double Delta { get; construct; }
		public double b { get; construct; }
		public double c { get; construct; }
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_mass_function_get_type ()")]
	public class MassFunction : GLib.Object {
		[CCode (has_construct_function = false)]
		public MassFunction (Nc.Distance dist, Nc.MatterVar vp, Nc.GrowthFunc gf, Nc.MultiplicityFunc mulf);
		public static void alpha_eff (Nc.MatterVar vp, Nc.HICosmo model, double lnM, double a_eff_ptr);
		public static void clear (Nc.MassFunction mfp);
		public Nc.MassFunction copy ();
		public double d2n_dzdlnm (Nc.HICosmo model, double lnM, double z);
		public double dn_M1_to_M2_dv (Nc.HICosmo model, double M1, double M2, double z);
		public double dn_M_to_inf_dv (Nc.HICosmo model, double M, double z);
		public double dn_dlnm (Nc.HICosmo model, double lnM, double z);
		public double dn_dz (Nc.HICosmo model, double lnMl, double lnMu, double z, bool spline);
		public double dv_dzdomega (Nc.HICosmo model, double z);
		public void free ();
		public double n (Nc.HICosmo model, double lnMl, double lnMu, double zl, double zu, Nc.MassFunctionSplineOptimize spline);
		public void prepare (Nc.HICosmo model);
		public void prepare_if_needed (Nc.HICosmo model);
		public void set_eval_limits (Nc.HICosmo model, double lnMi, double lnMf, double zi, double zf);
		public void sigma (Nc.HICosmo model, double lnM, double z, double dn_dlnM_ptr, double sigma_ptr);
		[NoAccessorMethod]
		public Nc.Distance distance { owned get; construct; }
		[NoAccessorMethod]
		public Nc.GrowthFunc growth { owned get; construct; }
		[NoAccessorMethod]
		public Nc.MultiplicityFunc multiplicity { owned get; construct; }
		[NoAccessorMethod]
		public Nc.MatterVar variance { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_matter_var_get_type ()")]
	public class MatterVar : GLib.Object {
		[CCode (has_construct_function = false)]
		public MatterVar (Nc.MatterVarStrategy vs, Nc.Window wp, Nc.TransferFunc tf);
		public double R_to_mass (Nc.HICosmo model, double R);
		public static void clear (Nc.MatterVar vp);
		public Nc.MatterVar copy ();
		public double dlnvar0_dR (Nc.HICosmo model, double lnR);
		public double dlnvar0_dlnR (Nc.HICosmo model, double lnR);
		public double dsigma0_dR (Nc.HICosmo model, double lnR);
		public void free ();
		public double integrand_over_window2 (Nc.HICosmo model, double k);
		public double lnM_to_lnR (Nc.HICosmo model, double lnM);
		public double lnR_to_lnM (Nc.HICosmo model, double lnR);
		public double mass_to_R (Nc.HICosmo model, double M);
		public void prepare (Nc.HICosmo model);
		public double sigma8_sqrtvar0 (Nc.HICosmo model);
		public double spectral_moment_over_growth2 (Nc.HICosmo model, int n);
		public double spectral_moment_over_growth2_gaussian (Nc.HICosmo model, int n);
		public double spectral_moment_over_growth2_tophat (Nc.HICosmo model, int n);
		public double var0 (Nc.HICosmo model, double lnR);
		[NoAccessorMethod]
		public Nc.MatterVarStrategy strategy { get; construct; }
		[NoAccessorMethod]
		public Nc.TransferFunc transfer { owned get; construct; }
		[NoAccessorMethod]
		public Nc.Window window { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_get_type ()")]
	public abstract class MultiplicityFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MultiplicityFunc ();
		public static void clear (Nc.MultiplicityFunc mulf);
		public virtual double eval (Nc.HICosmo model, double sigma, double z);
		public void free ();
		[CCode (has_construct_function = false)]
		public MultiplicityFunc.from_name (string multiplicity_name);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_jenkins_get_type ()")]
	public class MultiplicityFuncJenkins : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncJenkins (double A, double A_tCDM, double B, double B_tCDM, double epsilon, double epsilon_tCDM);
		public double get_A ();
		public double get_A_tCDM ();
		public double get_B ();
		public double get_B_tCDM ();
		public double get_epsilon ();
		public double get_epsilon_tCDM ();
		public void set_A (double A);
		public void set_A_tCDM (double A_tCDM);
		public void set_B (double B);
		public void set_B_tCDM (double B_tCDM);
		public void set_epsilon (double epsilon);
		public void set_epsilon_tCDM (double epsilon_tCDM);
		public double A { get; construct; }
		public double A_tCDM { get; construct; }
		public double B { get; construct; }
		public double B_tCDM { get; construct; }
		public double epsilon { get; construct; }
		public double epsilon_tCDM { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_ps_get_type ()")]
	public class MultiplicityFuncPS : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncPS (double delta_c);
		public double get_delta_c ();
		public void set_delta_c (double delta_c);
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_st_get_type ()")]
	public class MultiplicityFuncST : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncST (double A, double b, double p, double delta_c);
		public double get_A ();
		public double get_b ();
		public double get_delta_c ();
		public double get_p ();
		public void set_A (double A);
		public void set_b (double b);
		public void set_delta_c (double delta_c);
		public void set_p (double p);
		public double A { get; construct; }
		public double b { get; construct; }
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
		public double p { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_tinker_get_type ()")]
	public class MultiplicityFuncTinker : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncTinker (double A0, double a0, double b0, double c, double Delta);
		public double get_A0 ();
		public double get_Delta ();
		public double get_a0 ();
		public double get_b0 ();
		public double get_c ();
		public void set_A0 (double A0);
		public void set_Delta (double Delta);
		public void set_a0 (double a0);
		public void set_b0 (double b0);
		public void set_c (double c);
		public double A0 { get; construct; }
		public double Delta { get; construct; }
		public double a0 { get; construct; }
		public double b0 { get; construct; }
		public double c { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_tinker_crit_get_type ()")]
	public class MultiplicityFuncTinkerCrit : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncTinkerCrit (double Delta);
		public double get_Delta ();
		public void set_Delta (double Delta);
		public double Delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_tinker_mean_get_type ()")]
	public class MultiplicityFuncTinkerMean : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncTinkerMean (double Delta);
		public double get_Delta ();
		public void set_Delta (double Delta);
		public double Delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_warren_get_type ()")]
	public class MultiplicityFuncWarren : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncWarren (double A, double a, double b, double c);
		public double get_A ();
		public double get_a ();
		public double get_b ();
		public double get_c ();
		public void set_A (double A);
		public void set_a (double a);
		public void set_b (double b);
		public void set_c (double c);
		public double A { get; construct; }
		public double a { get; construct; }
		public double b { get; construct; }
		public double c { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_recomb_get_type ()")]
	public abstract class Recomb : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Recomb ();
		public static double HI_ion_saha (Nc.HICosmo cosmo, double x);
		public static double HeII_ion_saha (Nc.HICosmo cosmo, double x);
		public static double HeII_ion_saha_x (Nc.HICosmo cosmo, double f);
		public static double HeII_ion_saha_x_by_HeIII_He (Nc.HICosmo cosmo, double f);
		public static double HeI_ion_saha (Nc.HICosmo cosmo, double x);
		public static double He_fully_ionized_Xe (Nc.HICosmo cosmo, double x);
		public static double He_fully_ionized_dtau_dlambda (Nc.HICosmo cosmo, double lambda);
		public double Xe (Nc.HICosmo cosmo, double lambda);
		public double d2tau_dlambda2 (Nc.HICosmo cosmo, double lambda);
		public double d2v_tau_dlambda2 (Nc.HICosmo cosmo, double lambda);
		public double d3tau_dlambda3 (Nc.HICosmo cosmo, double lambda);
		public double dtau_dlambda (Nc.HICosmo cosmo, double lambda);
		public static double dtau_dlambda_Xe (Nc.HICosmo cosmo, double lambda);
		public double dtau_dx (Nc.HICosmo cosmo, double lambda);
		public double dv_tau_dlambda (Nc.HICosmo cosmo, double lambda);
		public double equilibrium_Xe (Nc.HICosmo cosmo, double x);
		public void free ();
		[CCode (has_construct_function = false)]
		public Recomb.from_name (string recomb_name);
		public static double hummer_HeI_case_B (Nc.HICosmo cosmo, double Tm);
		public static double hummer_HeI_case_B_dTm (Nc.HICosmo cosmo, double Tm);
		public double log_v_tau (Nc.HICosmo cosmo, double lambda);
		public static double pequignot_HI_case_B (Nc.HICosmo cosmo, double Tm);
		public static double pequignot_HI_case_B_dTm (Nc.HICosmo cosmo, double Tm);
		public virtual void prepare (Nc.HICosmo cosmo);
		public void prepare_if_needed (Nc.HICosmo cosmo);
		public Nc.Recomb @ref ();
		public double tau (Nc.HICosmo cosmo, double lambda);
		public double tau_cutoff (Nc.HICosmo cosmo);
		public double tau_lambda0_lambda1 (Nc.HICosmo cosmo, double lambda0, double lambda1);
		public double tau_zdrag (Nc.HICosmo cosmo);
		public double tau_zstar (Nc.HICosmo cosmo);
		public double v_tau (Nc.HICosmo cosmo, double lambda);
		public void v_tau_lambda_features (Nc.HICosmo cosmo, double logref, out double lambda_max, out double lambda_l, out double lambda_u);
		public double v_tau_lambda_mode (Nc.HICosmo cosmo);
		[NoAccessorMethod]
		public double init_frac { get; set construct; }
		[NoAccessorMethod]
		public double prec { get; set construct; }
		[NoAccessorMethod]
		public double zi { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_recomb_seager_get_type ()")]
	public class RecombSeager : Nc.Recomb {
		[CCode (has_construct_function = false, type = "NcRecomb*")]
		public RecombSeager ();
		[CCode (has_construct_function = false, type = "NcRecomb*")]
		public RecombSeager.full (double init_frac, double zi, double prec);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_snia_dist_cov_get_type ()")]
	public class SNIADistCov : Ncm.Model {
		[CCode (has_construct_function = false)]
		public SNIADistCov (Nc.Distance dist, uint mu_len);
		public void calc (Ncm.Matrix cov);
		public static void clear (Nc.SNIADistCov dcov);
		public void free ();
		public void load_txt (string filename);
		public void mean (Nc.HICosmo cosmo, Ncm.Vector y);
		public void prepare (Ncm.MSet mset);
		public void prepare_if_needed (Ncm.MSet mset);
		public Nc.SNIADistCov @ref ();
		public void set_size (uint mu_len);
		[NoAccessorMethod]
		public double M1 { get; set; }
		[NoAccessorMethod]
		public bool M1_fit { get; set; }
		[NoAccessorMethod]
		public double M2 { get; set; }
		[NoAccessorMethod]
		public bool M2_fit { get; set; }
		[NoAccessorMethod]
		public double alpha { get; set; }
		[NoAccessorMethod]
		public bool alpha_fit { get; set; }
		[NoAccessorMethod]
		public double beta { get; set; }
		[NoAccessorMethod]
		public bool beta_fit { get; set; }
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public uint mu_len { get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant sigma_int { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant sigma_int_fit { owned get; set; }
		[NoAccessorMethod]
		public uint sigma_int_length { get; construct; }
		[NoAccessorMethod]
		public double sigma_pecz { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nc_scale_factor_get_type ()")]
	[Compact]
	public class ScaleFactor {
		[CCode (has_construct_function = false)]
		public ScaleFactor (Nc.ScaleFactorTimeType ttype, double zf);
		public double a_t (double t);
		public Nc.ScaleFactor copy ();
		public void free ();
		public void prepare (Nc.HICosmo model);
		public void prepare_if_needed (Nc.HICosmo model);
		public double t_x (double x);
		public double t_z (double z);
		public double z_t (double t);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_get_type ()")]
	public abstract class TransferFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TransferFunc ();
		[NoWrapper]
		public virtual double calc (double k);
		[NoWrapper]
		public virtual double calc_matter_P (Nc.HICosmo model, double k);
		public static void clear (Nc.TransferFunc tf);
		public double eval (Nc.HICosmo model, double kh);
		public void free ();
		[CCode (has_construct_function = false)]
		public TransferFunc.from_name (string transfer_name);
		public double matter_powerspectrum (Nc.HICosmo model, double kh);
		public virtual void prepare (Nc.HICosmo model);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_bbks_get_type ()")]
	public class TransferFuncBBKS : Nc.TransferFunc {
		[CCode (has_construct_function = false, type = "NcTransferFunc*")]
		public TransferFuncBBKS ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_camb_get_type ()")]
	public class TransferFuncCAMB : Nc.TransferFunc {
		[CCode (has_construct_function = false, type = "NcTransferFunc*")]
		public TransferFuncCAMB ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_eh_get_type ()")]
	public class TransferFuncEH : Nc.TransferFunc {
		[CCode (has_construct_function = false, type = "NcTransferFunc*")]
		public TransferFuncEH ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_pert_get_type ()")]
	public class TransferFuncPert : Nc.TransferFunc {
		[CCode (has_construct_function = false)]
		protected TransferFuncPert ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_window_get_type ()")]
	public abstract class Window : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Window ();
		public static void clear (Nc.Window wf);
		public virtual double deriv_fourier (double k, double R);
		public virtual double eval_fourier (double k, double R);
		[NoWrapper]
		public virtual double eval_real (double r, double R);
		public double eval_realspace (double r, double R);
		public void free ();
		[CCode (has_construct_function = false)]
		public Window.from_name (string window_name);
		public double volume ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_window_gaussian_get_type ()")]
	public class WindowGaussian : Nc.Window {
		[CCode (has_construct_function = false, type = "NcWindow*")]
		public WindowGaussian ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_window_tophat_get_type ()")]
	public class WindowTophat : Nc.Window {
		[CCode (has_construct_function = false, type = "NcWindow*")]
		public WindowTophat ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct HICosmoPriorTop {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct HICosmoQGMode {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct HICosmoQPWAsymCDMPrior {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct HICosmoQPWContPrior {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct LinearPert {
		public void* solver;
		public double eta0;
		public double lambdai;
		public double lambdaf;
		public double lambda_opt_cutoff;
		public double lambda_rec;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak double[] lambda_rec_10m2_max;
		public double abstol;
		public double reltol;
		public double tc_abstol;
		public double tc_reltol;
		public uint lmax;
		public uint sys_size;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct LinearPertOdeSolver {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct LinearPertSplines {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct LinearPertTF {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "_NcLinearPertWorkSpace", has_type_id = false)]
	public struct _LinearPertWorkSpace {
		public void* pert;
		public bool tight_coupling;
		public bool tight_coupling_end;
		public double lambda_int;
		public double lambda;
		public double dlambda;
		public double k;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "_NcPertHydrodyn", has_type_id = false)]
	public struct _PertHydrodyn {
		public weak Nc.HICosmo model;
		public void* cvode;
		public bool initialized;
		public double reltol;
		public double abstol;
		public long k;
		public long alpha0;
		public long alphai;
		public long alphaf;
		public weak Ncm.Spline pw_spline;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_BENSON_", type_id = "nc_cluster_mass_benson_params_get_type ()")]
	public enum ClusterMassBensonParams {
		A_SZ,
		B_SZ,
		C_SZ,
		D_SZ
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_BENSON_XRAY_", type_id = "nc_cluster_mass_benson_xray_params_get_type ()")]
	public enum ClusterMassBensonXRayParams {
		A_SZ,
		B_SZ,
		C_SZ,
		D_SZ,
		A_X,
		B_X,
		C_X,
		D_X
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_", type_id = "nc_cluster_mass_impl_get_type ()")]
	[Flags]
	public enum ClusterMassImpl {
		P,
		INTP,
		RESAMPLE,
		P_LIMITS,
		N_LIMITS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_VANDERLINDE_", type_id = "nc_cluster_mass_vanderlinde_params_get_type ()")]
	public enum ClusterMassVanderlindeParams {
		A_SZ,
		B_SZ,
		C_SZ,
		D_SZ
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_REDSHIFT_", type_id = "nc_cluster_redshift_impl_get_type ()")]
	[Flags]
	public enum ClusterRedshiftImpl {
		P,
		INTP,
		RESAMPLE,
		P_LIMITS,
		N_LIMTS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_BAO_", type_id = "nc_data_bao_id_get_type ()")]
	public enum DataBaoId {
		A_EISENSTEIN2005,
		DV_EISENSTEIN2005,
		DVDV_PERCIVAL2007,
		DVDV_PERCIVAL2010,
		RDV_PERCIVAL2007,
		RDV_PERCIVAL2010
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_CMB_", type_id = "nc_data_cmb_id_get_type ()")]
	public enum DataCMBId {
		SHIFT_PARAM_WMAP3,
		SHIFT_PARAM_WMAP5,
		SHIFT_PARAM_WMAP7,
		DIST_PRIORS_WMAP5,
		DIST_PRIORS_WMAP7,
		DIST_PRIORS_WMAP9
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_CLUSTER_ABUNDANCE_", type_id = "nc_data_cluster_abundance_id_get_type ()")]
	public enum DataClusterAbundanceId {
		FIT,
		TXT,
		SAMPLING
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_HUBBLE_", type_id = "nc_data_hubble_id_get_type ()")]
	public enum DataHubbleId {
		VERDE,
		CABRE
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_SNIA_", type_id = "nc_data_snia_id_get_type ()")]
	public enum DataSNIAId {
		SIMPLE_GOLD_157,
		SIMPLE_GOLD_182,
		SIMPLE_GOLD_182_FULL,
		SIMPLE_ESSENCE,
		SIMPLE_LEGACY,
		SIMPLE_UNION,
		[CCode (cname = "NC_DATA_SNIA_SIMPLE_CfA3")]
		SIMPLE_CFA3,
		SIMPLE_UNION2,
		SIMPLE_UNION2_1,
		COV_SNLS3_SYS_STAT,
		COV_SNLS3_STAT_ONLY
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_IMPL_", type_id = "nc_hi_cosmo_de_impl_get_type ()")]
	[Flags]
	public enum HICosmoDEImpl {
		[CCode (cname = "NC_HICOSMO_DE_IMPL_weff")]
		WEFF,
		[CCode (cname = "NC_HICOSMO_DE_IMPL_dweff_dz")]
		DWEFF_DZ
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_LINDER_", type_id = "nc_hi_cosmo_de_linder_params_get_type ()")]
	public enum HICosmoDELinderParams {
		W0,
		W1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_PAD_", type_id = "nc_hi_cosmo_de_pad_params_get_type ()")]
	public enum HICosmoDEPadParams {
		W0,
		W1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_", type_id = "nc_hi_cosmo_de_params_get_type ()")]
	public enum HICosmoDEParams {
		H0,
		OMEGA_C,
		OMEGA_X,
		T_GAMMA0,
		OMEGA_B,
		SPECINDEX,
		SIGMA8
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_QE_", type_id = "nc_hi_cosmo_deqe_params_get_type ()")]
	public enum HICosmoDEQEParams {
		W0,
		W1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_XCDM_", type_id = "nc_hi_cosmo_dexcdm_params_get_type ()")]
	public enum HICosmoDEXCDMParams {
		W
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_IMPL_", type_id = "nc_hi_cosmo_impl_get_type ()")]
	[Flags]
	public enum HICosmoImpl {
		H0,
		[CCode (cname = "NC_HICOSMO_IMPL_Omega_b")]
		OMEGA_B,
		[CCode (cname = "NC_HICOSMO_IMPL_Omega_r")]
		OMEGA_R,
		[CCode (cname = "NC_HICOSMO_IMPL_Omega_c")]
		OMEGA_C,
		[CCode (cname = "NC_HICOSMO_IMPL_Omega_t")]
		OMEGA_T,
		[CCode (cname = "NC_HICOSMO_IMPL_sigma_8")]
		SIGMA_8,
		[CCode (cname = "NC_HICOSMO_IMPL_T_gamma0")]
		T_GAMMA0,
		[CCode (cname = "NC_HICOSMO_IMPL_z_lss")]
		Z_LSS,
		E2,
		[CCode (cname = "NC_HICOSMO_IMPL_dE2_dz")]
		DE2_DZ,
		[CCode (cname = "NC_HICOSMO_IMPL_d2E2_dz2")]
		D2E2_DZ2,
		[CCode (cname = "NC_HICOSMO_IMPL_cd")]
		CD,
		[CCode (cname = "NC_HICOSMO_IMPL_powspec")]
		POWSPEC
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QCONST_", type_id = "nc_hi_cosmo_qconst_params_get_type ()")]
	public enum HICosmoQConstParams {
		H0,
		OMEGA_T,
		CD,
		E,
		Q,
		Z1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QG_PERT_", type_id = "nc_hi_cosmo_qg_pert_type_get_type ()")]
	public enum HICosmoQGPertType {
		CURVATURE,
		H
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QLINEAR_", type_id = "nc_hi_cosmo_qlinear_params_get_type ()")]
	public enum HICosmoQLinearParams {
		H0,
		OMEGA_T,
		CD,
		E,
		Q,
		QP,
		Z1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QPW_", type_id = "nc_hi_cosmo_qpws_params_get_type ()")]
	public enum HICosmoQPWSParams {
		H0,
		OMEGA_T,
		Q0
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QPW_", type_id = "nc_hi_cosmo_qpwv_params_get_type ()")]
	public enum HICosmoQPWVParams {
		QP
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QSPLINE_", type_id = "nc_hi_cosmo_qspline_sparams_get_type ()")]
	public enum HICosmoQSplineSParams {
		H0,
		OMEGA_T
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QSPLINE_", type_id = "nc_hi_cosmo_qspline_vparams_get_type ()")]
	public enum HICosmoQSplineVParams {
		Q
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_LINEAR_PERTURBATIONS_SPLINE_", type_id = "nc_linear_pert_spline_types_get_type ()")]
	[Flags]
	public enum LinearPertSplineTypes {
		SOURCES,
		PHI,
		THETA0,
		C0,
		B0,
		THETA1,
		C1,
		B1,
		THETA2
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_PERT_", type_id = "nc_linear_pert_vars_get_type ()")]
	public enum LinearPertVars {
		B0,
		THETA0,
		C0,
		PHI,
		B1,
		THETA1,
		C1,
		THETA2,
		THETA_P0,
		THETA_P1,
		THETA_P2
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_MASS_FUNCTION_SPLINE_", type_id = "nc_mass_function_spline_optimize_get_type ()")]
	public enum MassFunctionSplineOptimize {
		NONE,
		LNM,
		Z
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_MATTER_VAR_", type_id = "nc_matter_var_strategy_get_type ()")]
	public enum MatterVarStrategy {
		NUMINT,
		SPLINEINT,
		FFT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_SNIA_DIST_COV_", type_id = "nc_snia_dist_cov_data_get_type ()")]
	public enum SNIADistCovData {
		ZCMB,
		ZHE,
		SIGMA_Z,
		MAG,
		SIGMA_MAG,
		WIDTH,
		SIGMA_WIDTH,
		COLOUR,
		SIGMA_COLOUR,
		THIRDPAR,
		SIGMA_THIRDPAR,
		DIAG_MAG_WIDTH,
		DIAG_MAG_COLOUR,
		DIAG_WIDTH_COLOUR,
		ABSMAG_SET,
		VAR_MAG,
		VAR_WIDTH,
		VAR_COLOUR,
		VAR_MAG_WIDTH,
		VAR_MAG_COLOUR,
		VAR_WIDTH_COLOUR
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_SNIA_DIST_COV_", type_id = "nc_snia_dist_cov_params_get_type ()")]
	public enum SNIADistCovParams {
		ALPHA,
		BETA,
		M1,
		M2
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_TIME_", type_id = "nc_scale_factor_time_type_get_type ()")]
	public enum ScaleFactorTimeType {
		COSMIC,
		CONFORMAL
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double ClusterAbundanceIntPd2N (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnM, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double ClusterAbundanceN (Nc.ClusterAbundance cad, Nc.HICosmo model);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double DistanceFunc0 (Nc.Distance dist, Nc.HICosmo cosmo);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double DistanceFunc1 (Nc.Distance dist, Nc.HICosmo cosmo, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HICosmoFunc0 (Nc.HICosmo cosmo);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HICosmoFunc1 (Nc.HICosmo cosmo, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate void LinearPertConf (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate bool LinearPertEvol (Nc.LinearPert pert, double g);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double LinearPertGet (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double LinearPertGetN (Nc.LinearPert pert, uint n);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate void LinearPertSources (Nc.LinearPert pert, double S0, double S1, double S2);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate bool LinearPertTest (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_A_SZ")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_A_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_B_SZ")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_B_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_C_SZ")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_C_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_D_SZ")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_D_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_PARAMS_ABSTOL")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_A_SZ")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_A_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_A_X")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_A_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_B_SZ")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_B_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_B_X")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_B_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_C_SZ")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_C_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_C_X")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_C_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_D_SZ")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_D_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_D_X")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_D_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_PARAMS_ABSTOL")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_IMPL_ALL")]
	public const int CLUSTER_MASS_IMPL_ALL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_LNNORMAL_BIAS")]
	public const int CLUSTER_MASS_LNNORMAL_BIAS;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_LNNORMAL_SIGMA")]
	public const int CLUSTER_MASS_LNNORMAL_SIGMA;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_A_SZ")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_A_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_B_SZ")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_B_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_C_SZ")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_C_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_D_SZ")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_D_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_PARAMS_ABSTOL")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_PHOTOZ_GAUSS_BIAS")]
	public const int CLUSTER_PHOTOZ_GAUSS_BIAS;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_PHOTOZ_GAUSS_SIGMA")]
	public const int CLUSTER_PHOTOZ_GAUSS_SIGMA;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_REDSHIFT_IMPL_ALL")]
	public const int CLUSTER_REDSHIFT_IMPL_ALL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_LEN")]
	public const int DATA_SNIA_COV_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_SIMPLE_LEN")]
	public const int DATA_SNIA_SIMPLE_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DEFAULT_PARAMS_ABSTOL")]
	public const double HICOSMO_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DEFAULT_PARAMS_RELTOL")]
	public const double HICOSMO_DEFAULT_PARAMS_RELTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_OMEGA_B")]
	public const double HICOSMO_DE_DEFAULT_OMEGA_B;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_OMEGA_C")]
	public const double HICOSMO_DE_DEFAULT_OMEGA_C;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_OMEGA_X")]
	public const double HICOSMO_DE_DEFAULT_OMEGA_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_SIGMA8")]
	public const double HICOSMO_DE_DEFAULT_SIGMA8;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_SPECINDEX")]
	public const double HICOSMO_DE_DEFAULT_SPECINDEX;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_T_GAMMA0")]
	public const double HICOSMO_DE_DEFAULT_T_GAMMA0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_LINDER_DEFAULT_W0")]
	public const double HICOSMO_DE_LINDER_DEFAULT_W0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_LINDER_DEFAULT_W1")]
	public const double HICOSMO_DE_LINDER_DEFAULT_W1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_LINDER_N")]
	public const int HICOSMO_DE_LINDER_N;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_PAD_DEFAULT_W0")]
	public const double HICOSMO_DE_PAD_DEFAULT_W0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_PAD_DEFAULT_W1")]
	public const double HICOSMO_DE_PAD_DEFAULT_W1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_QE_DEFAULT_W0")]
	public const double HICOSMO_DE_QE_DEFAULT_W0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_QE_DEFAULT_W1")]
	public const double HICOSMO_DE_QE_DEFAULT_W1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_QE_N")]
	public const int HICOSMO_DE_QE_N;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_XCDM_DEFAULT_W0")]
	public const double HICOSMO_DE_XCDM_DEFAULT_W0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_XCDM_N")]
	public const int HICOSMO_DE_XCDM_N;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_CD")]
	public const double HICOSMO_QCONST_DEFAULT_CD;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_E")]
	public const double HICOSMO_QCONST_DEFAULT_E;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_OMEGA_T")]
	public const double HICOSMO_QCONST_DEFAULT_OMEGA_T;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_Q")]
	public const double HICOSMO_QCONST_DEFAULT_Q;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_Z1")]
	public const double HICOSMO_QCONST_DEFAULT_Z1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_CD")]
	public const double HICOSMO_QLINEAR_DEFAULT_CD;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_E")]
	public const double HICOSMO_QLINEAR_DEFAULT_E;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_OMEGA_T")]
	public const double HICOSMO_QLINEAR_DEFAULT_OMEGA_T;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_Q")]
	public const double HICOSMO_QLINEAR_DEFAULT_Q;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_QP")]
	public const double HICOSMO_QLINEAR_DEFAULT_QP;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_Z1")]
	public const double HICOSMO_QLINEAR_DEFAULT_Z1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QPW_DEFAULT_OMEGA_T")]
	public const double HICOSMO_QPW_DEFAULT_OMEGA_T;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QPW_DEFAULT_Q0")]
	public const double HICOSMO_QPW_DEFAULT_Q0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QPW_DEFAULT_QP")]
	public const double HICOSMO_QPW_DEFAULT_QP;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QPW_DEFAULT_QP_LEN")]
	public const int HICOSMO_QPW_DEFAULT_QP_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QSPLINE_DEFAULT_OMEGA_T")]
	public const double HICOSMO_QSPLINE_DEFAULT_OMEGA_T;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QSPLINE_DEFAULT_Q")]
	public const double HICOSMO_QSPLINE_DEFAULT_Q;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QSPLINE_DEFAULT_Q_LEN")]
	public const int HICOSMO_QSPLINE_DEFAULT_Q_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_LINEAR_PERTURBATIONS_SPLINE_ALL")]
	public const int LINEAR_PERTURBATIONS_SPLINE_ALL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_PERTURBATION_BASE_SIZE")]
	public const int PERTURBATION_BASE_SIZE;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_PERTURBATION_START_X")]
	public const double PERTURBATION_START_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_COLOUR_KEY")]
	public const string SNIA_DIST_COV_COLOUR_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DATA_GROUP")]
	public const string SNIA_DIST_COV_DATA_GROUP;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DATA_KEY")]
	public const string SNIA_DIST_COV_DATA_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DATA_LEN_KEY")]
	public const string SNIA_DIST_COV_DATA_LEN_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_ALPHA")]
	public const double SNIA_DIST_COV_DEFAULT_ALPHA;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_BETA")]
	public const double SNIA_DIST_COV_DEFAULT_BETA;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_M1")]
	public const double SNIA_DIST_COV_DEFAULT_M1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_M2")]
	public const double SNIA_DIST_COV_DEFAULT_M2;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_PARAMS_ABSTOL")]
	public const double SNIA_DIST_COV_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_SIGMA_INT")]
	public const double SNIA_DIST_COV_DEFAULT_SIGMA_INT;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_MAG_COLOUR_KEY")]
	public const string SNIA_DIST_COV_MAG_COLOUR_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_MAG_KEY")]
	public const string SNIA_DIST_COV_MAG_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_MAG_WIDTH_KEY")]
	public const string SNIA_DIST_COV_MAG_WIDTH_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_SIGMA_INT")]
	public const int SNIA_DIST_COV_SIGMA_INT;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_SIGMA_INT_DEFAULT_LEN")]
	public const int SNIA_DIST_COV_SIGMA_INT_DEFAULT_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_VPARAM_LEN")]
	public const int SNIA_DIST_COV_VPARAM_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_WIDTH_COLOUR_KEY")]
	public const string SNIA_DIST_COV_WIDTH_COLOUR_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_WIDTH_KEY")]
	public const string SNIA_DIST_COV_WIDTH_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_WINDOW_VOLUME_GAUSSIAN")]
	public const int WINDOW_VOLUME_GAUSSIAN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_WINDOW_VOLUME_TOPHAT")]
	public const int WINDOW_VOLUME_TOPHAT;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "_NC_CLUSTER_ABUNDANCE_MIN_Z")]
	public const double _CLUSTER_ABUNDANCE_MIN_Z;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "_NC_CLUSTER_ABUNDANCE_NNODES")]
	public const int _CLUSTER_ABUNDANCE_NNODES;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "_NC_TIGHT_COUPLING_END")]
	public const double _TIGHT_COUPLING_END;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "_NC_USE_CUTOFF")]
	public const int _USE_CUTOFF;
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void bias_mean_prepare (Nc.ClusterAbundance cad, Nc.HICosmo model);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double bias_mean_val (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnMl, double lnMu, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnM, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias_Mobs_denominator (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnMobs, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias_Mobs_numerator (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnMobs, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias_denominator (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnM, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias_numerator (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnM, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static Ncm.Data data_bao_create (Nc.Distance dist, Nc.DataBaoId id);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static Ncm.Data data_cmb_create (Nc.Distance dist, Nc.DataCMBId id);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static string data_snia_get_fits (string filename, bool check_size);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void data_snia_load_cat (Nc.SNIADistCov dcov, Nc.DataSNIAId id);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_cov_direct (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_clear (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_free (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double pert_linear_los_integrate (Nc.LinearPertSplines pspline, long l, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_prepare_splines (Nc.LinearPertSplines pspline);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static bool pert_linear_spline_set_source_at (Nc.LinearPertSplines pspline, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_splines_clear (Nc.LinearPertSplines pspline);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_splines_free (Nc.LinearPertSplines pspline);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double pert_transfer_function_get (Nc.LinearPertTF perttf, double kh);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_transfer_function_prepare (Nc.LinearPertTF perttf);
}
