/***************************************************************************
 *            nc_snia_dist_cov.h
 *
 *  Mon December 03 19:34:20 2012
 *  Copyright  2012  Sandro Dias Pinto Vitenti
 *  <sandro@isoftware.com.br>
 ****************************************************************************/
/*
 * numcosmo
 * Copyright (C) 2012 Sandro Dias Pinto Vitenti <sandro@isoftware.com.br>
 * 
 * numcosmo is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * numcosmo is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _NC_SNIA_DIST_COV_H_
#define _NC_SNIA_DIST_COV_H_

#include <glib.h>
#include <glib-object.h>
#include <numcosmo/math/ncm_model.h>

G_BEGIN_DECLS

#define NC_TYPE_SNIA_DIST_COV             (nc_snia_dist_cov_get_type ())
#define NC_SNIA_DIST_COV(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), NC_TYPE_SNIA_DIST_COV, NcSNIADistCov))
#define NC_SNIA_DIST_COV_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), NC_TYPE_SNIA_DIST_COV, NcSNIADistCovClass))
#define NC_IS_SNIA_DIST_COV(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NC_TYPE_SNIA_DIST_COV))
#define NC_IS_SNIA_DIST_COV_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), NC_TYPE_SNIA_DIST_COV))
#define NC_SNIA_DIST_COV_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), NC_TYPE_SNIA_DIST_COV, NcSNIADistCovClass))

typedef struct _NcSNIADistCovClass NcSNIADistCovClass;
typedef struct _NcSNIADistCov NcSNIADistCov;

/**
 * NcSNIADistCovParams:
 * @NC_SNIA_DIST_COV_ALPHA: FIXME
 * @NC_SNIA_DIST_COV_BETA: FIXME
 *
 * FIXME
 * 
 */
typedef enum _NcSNIADistCovParams
{
  NC_SNIA_DIST_COV_ALPHA = 0,
  NC_SNIA_DIST_COV_BETA,       /*< private >*/
  NC_SNIA_DIST_COV_SPARAM_LEN, /*< skip >*/
} NcSNIADistCovParams;

/**
 * NcSNIADistCovData:
 * @NC_SNIA_DIST_COV_NAME: FIXME 
 * @NC_SNIA_DIST_COV_ZCMB: FIXME
 * @NC_SNIA_DIST_COV_ZHE: FIXME
 * @NC_SNIA_DIST_COV_SIGMA_Z: FIXME
 * @NC_SNIA_DIST_COV_MAGNITUDE: FIXME
 * @NC_SNIA_DIST_COV_SIGMA_MAGNITUDE: FIXME
 * @NC_SNIA_DIST_COV_WIDTH: FIXME
 * @NC_SNIA_DIST_COV_SIGMA_WIDTH: FIXME
 * @NC_SNIA_DIST_COV_COLOUR: FIXME
 * @NC_SNIA_DIST_COV_SIGMA_COLOUR: FIXME
 * @NC_SNIA_DIST_COV_THIRDPAR: FIXME
 * @NC_SNIA_DIST_COV_SIGMA_THIRDPAR: FIXME
 * @NC_SNIA_DIST_COV_V_MAGNITUDE_WIDTH: FIXME
 * @NC_SNIA_DIST_COV_V_MAGNITUDE_COLOUR: FIXME
 * @NC_SNIA_DIST_COV_V_WIDTH_COLOUR: FIXME
 * @NC_SNIA_DIST_COV_ABSMAG_SET: FIXME
 *  
 * 
 * FIXME
 * 
 */
typedef enum _NcSNIADistCovData
{
  NC_SNIA_DIST_COV_NAME = 0,
  NC_SNIA_DIST_COV_ZCMB,
  NC_SNIA_DIST_COV_ZHE,
  NC_SNIA_DIST_COV_SIGMA_Z,
  NC_SNIA_DIST_COV_MAGNITUDE,
  NC_SNIA_DIST_COV_SIGMA_MAGNITUDE,
  NC_SNIA_DIST_COV_WIDTH,
  NC_SNIA_DIST_COV_SIGMA_WIDTH,
  NC_SNIA_DIST_COV_COLOUR,
  NC_SNIA_DIST_COV_SIGMA_COLOUR,
  NC_SNIA_DIST_COV_THIRDPAR,
  NC_SNIA_DIST_COV_SIGMA_THIRDPAR,
  NC_SNIA_DIST_COV_V_MAGNITUDE_WIDTH,
  NC_SNIA_DIST_COV_V_MAGNITUDE_COLOUR,
  NC_SNIA_DIST_COV_V_WIDTH_COLOUR,
  NC_SNIA_DIST_COV_ABSMAG_SET, /*< private >*/
  NC_SNIA_DIST_COV_LENGTH,     /*< skip >*/
} NcSNIADistCovData;

struct _NcSNIADistCovClass
{
  /*< private >*/
  NcmModelClass parent_class;
};

struct _NcSNIADistCov
{
  /*< private >*/
  NcmModel parent_instance;
  guint mu_len;
  NcmMatrix *magnitude;
  NcmMatrix *width;
  NcmMatrix *colour;
  NcmMatrix *magnitude_width;
  NcmMatrix *magnitude_colour;
  NcmMatrix *width_colour;
  NcmMatrix *snia_data;
  GArray *dataset;
  gdouble sigma_pecz;
};

GType nc_snia_dist_cov_get_type (void) G_GNUC_CONST;

NcSNIADistCov *nc_snia_dist_cov_new (guint mu_len);
void nc_snia_dist_cov_free (NcSNIADistCov *dcov);
void nc_snia_dist_cov_clear (NcSNIADistCov **dcov);

void nc_snia_dist_cov_set_size (NcSNIADistCov *dcov, guint mu_len);
void nc_snia_dist_cov_calc (NcSNIADistCov *dcov, NcmMatrix *cov);

void nc_snia_dist_cov_load (NcSNIADistCov *dcov, const gchar *filename);

#define NC_SNIA_DIST_COV_DEFAULT_ALPHA (1.45)
#define NC_SNIA_DIST_COV_DEFAULT_BETA (3.16)
#define NC_SNIA_DIST_COV_DEFAULT_PARAMS_ABSTOL (0.0)

#define NC_SNIA_DIST_COV_SIGMA_INT (0)
#define NC_SNIA_DIST_COV_SIGMA_INT_DEFAULT_LEN (4)
#define NC_SNIA_DIST_COV_DEFAULT_SIGMA_INT (0.0989)
#define NC_SNIA_DIST_COV_VPARAM_LEN (1)

#define NC_SNIA_DIST_COV_DATA_GROUP "Supernovae Ia Data"
#define NC_SNIA_DIST_COV_DATA_LEN_KEY "data-length"
#define NC_SNIA_DIST_COV_DATA_KEY "snia-data"

G_END_DECLS

#endif /* _NC_SNIA_DIST_COV_H_ */

