/***************************************************************************
 *            test_nc_recomb.c
 *
 *  Wed November 14 11:38:56 2012
 *  Copyright  2012  Sandro Dias Pinto Vitenti
 *  <sandro@isoftware.com.br>
 ****************************************************************************/
/*
 * test_nc_recomb.c
 *
 * Copyright (C) 2012 - Sandro Dias Pinto Vitenti
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#undef GSL_RANGE_CHECK_OFF
#endif /* HAVE_CONFIG_H */
#include <numcosmo/numcosmo.h>

void test_nc_recomb_seager_new (void);
void test_nc_recomb_seager_wmap_zstar (void);

gint
main (gint argc, gchar *argv[])
{
  g_test_init (&argc, &argv, NULL);
  ncm_cfg_init ();
  /* ncm_cfg_enable_gsl_err_handler (); */

  g_test_add_func ("/numcosmo/nc_recomb/seager/new", &test_nc_recomb_seager_new);
  g_test_add_func ("/numcosmo/nc_recomb/seager/wmap/zstar", &test_nc_recomb_seager_wmap_zstar);

  g_test_run ();
}

void
test_nc_recomb_seager_new ()
{
  NcRecomb *recomb = nc_recomb_seager_new ();
  g_assert (NC_IS_RECOMB (recomb));
  g_assert (NC_IS_RECOMB_SEAGER (recomb));
  nc_recomb_free (recomb);

  if (g_test_trap_fork (0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR))
  {
    nc_recomb_free (recomb);
    exit (0);
  }
  g_test_trap_assert_failed ();

  recomb = nc_recomb_seager_new_full (1e-10, 2.2e9, 1e-5);
  g_assert (NC_IS_RECOMB (recomb));
  g_assert (NC_IS_RECOMB_SEAGER (recomb));

  g_assert (recomb->init_frac == 1e-10);
  g_assert (recomb->zi == 2.2e9);
  g_assert (recomb->prec == 1e-5);
  
  nc_recomb_free (recomb);

  if (g_test_trap_fork (0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR))
  {
    nc_recomb_free (recomb);
    exit (0);
  }
  g_test_trap_assert_failed ();
  
  recomb = nc_recomb_new_from_name ("NcRecombSeager{'prec':<2e-7>}");
  g_assert (NC_IS_RECOMB (recomb));
  g_assert (NC_IS_RECOMB_SEAGER (recomb));
  nc_recomb_free (recomb);

  g_assert (recomb->prec == 2e-7);
  
  if (g_test_trap_fork (0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR))
  {
    nc_recomb_free (recomb);
    exit (0);
  }
  g_test_trap_assert_failed ();  
}

void
test_nc_recomb_seager_wmap_zstar (void)
{
  NcRecomb *recomb = nc_recomb_seager_new ();
  NcHICosmo *cosmo = nc_hicosmo_new_from_name (NC_TYPE_HICOSMO, "NcHICosmoDEXcdm");
  nc_hicosmo_de_set_wmap5_params (cosmo);
  nc_recomb_prepare (recomb, cosmo);

  printf ("zstar % 20.15g\n", exp (-nc_recomb_tau_zstar (recomb, cosmo)) - 1.0);

  nc_recomb_free (recomb);
}

