from typing import Any, Callable, Literal, Optional, Tuple, Type, TypeVar, Sequence

from gi.repository import GLib
from gi.repository import GObject


ABC_MIN_SYNC_INTERVAL: float = 10.0
BOOTSTRAP_RNG_NAME: str = "bootstrap"
CALC_DEFAULT_ABSTOL: float = 0.0
CALC_DEFAULT_RELTOL: float = 0.0
CALC_MAX_DEPS: int = 6
CFG_DATA_DIR_ENV: str = "NUMCOSMO_DATA_DIR"
DATA_RESAMPLE_RNG_NAME: str = "data_resample"
DEFAULT_PRECISION: float = 0.0
FIT_DEFAULT_M2LNL_ABSTOL: float = 0.0
FIT_DEFAULT_M2LNL_RELTOL: float = 0.0
FIT_DEFAULT_MAXITER: int = 100000
FIT_DEFAULT_PARAMS_RELTOL: float = 1e-05
FIT_ESMCMC_M2LNL_ID: int = 0
FIT_ESMCMC_MIN_SYNC_INTERVAL: float = 10.0
FIT_ESMCMC_MPI_IN_LEN: int = 3
FIT_ESMCMC_MPI_OUT_LEN: int = 1
FIT_MCMC_MIN_SYNC_INTERVAL: float = 10.0
FIT_MC_MIN_SYNC_INTERVAL: float = 10.0
HOAA_DEBUG_EVOL: bool = False
HOAA_DEBUG_EVOL_SING: bool = False
HOAA_DEBUG_SING: bool = False
HOAA_PARABOLIC_MIN_POINTS: int = 4
HOAA_PARABOLIC_TRIG_ONE: float = 0.999
HOAA_TIME_FRAC: float = 0.0
INTEGRAL1D_DEFAULT_ABSTOL: float = 0.0
INTEGRAL1D_DEFAULT_ALG: int = 6
INTEGRAL1D_DEFAULT_PARTITION: int = 100000
INTEGRAL1D_DEFAULT_RELTOL: float = 0.0
INTEGRAL_ABS_ERROR: float = 0.0
INTEGRAL_ALG: int = 6
INTEGRAL_ERROR: float = 0.0
INTEGRAL_PARTITION: int = 100000
MODEL_CLASS_IMPL_ALL: int = 18446744073709551615
MODEL_MAX_STATES: int = 10
MPI_CTRL_MASTER_ID: int = 0
MSET_CATALOG_ASYMB_LABEL: str = "ASYMB"
MSET_CATALOG_DIST_EST_SD_SCALE: float = 0.001
MSET_CATALOG_EXTNAME: str = "NcmMSetCatalog:DATA"
MSET_CATALOG_FIRST_ID_LABEL: str = "FIRST_ID"
MSET_CATALOG_FSYMB_LABEL: str = "FSYMB"
MSET_CATALOG_M2LNL_COLNAME: str = "NcmFit:m2lnL"
MSET_CATALOG_M2LNL_SYMBOL: str = "-2\ln(L)"
MSET_CATALOG_M2LNP_ID_LABEL: str = "M2LNP_ID"
MSET_CATALOG_NADDVAL_LABEL: str = "NADDVAL"
MSET_CATALOG_NCHAINS_LABEL: str = "NCHAINS"
MSET_CATALOG_NROWS_LABEL: str = "NAXIS2"
MSET_CATALOG_RNG_ALGO_LABEL: str = "RNG_ALGO"
MSET_CATALOG_RNG_INIS_LABEL: str = "RNG_INIS"
MSET_CATALOG_RNG_SEED_LABEL: str = "RNG_SEED"
MSET_CATALOG_RNG_STAT_LABEL: str = "RNG_STAT"
MSET_CATALOG_RTYPE_BSTRAP_MEAN: str = "bootstrap-mean"
MSET_CATALOG_RTYPE_LABEL: str = "RTYPE"
MSET_CATALOG_RTYPE_UNDEFINED: str = "undefined-run"
MSET_CATALOG_WEIGHTED_LABEL: str = "WEIGHTED"
MSET_INIT_MARRAY: int = 32
MSET_MAX_STACKSIZE: int = 1000
OBJ_ARRAY_OBJ_NAME_STR: str = "OBJECT:NAME"
OBJ_ARRAY_POS_STR: str = "ARRAY:ELEMENT"
OBJ_ARRAY_TYPE: str = "a"
ODE_SPLINE_DEFAULT_ABSTOL: float = 0.0
ODE_SPLINE_MIN_STEP: float = 0.0
POWSPEC_CORR3D_DEFAULT_SIZE: int = 200
POWSPEC_FILTER_DEFAULT_SIZE: int = 200
POWSPEC_SPHERE_PROJ_DEFAULT_SIZE: int = 200
REPARAM_PARAMS_DESC_DICT_TYPE: str = "a{u"
SERIALIZE_AUTOSAVE_NAME: str = "S"
SERIALIZE_AUTOSAVE_NFORMAT: str = "%u"
SERIALIZE_MATRIX_TYPE: str = "aad"
SERIALIZE_OBJECT_FORMAT: str = "{s@"
SERIALIZE_OBJECT_TYPE: str = "{s"
SERIALIZE_PROPERTIES_TYPE: str = "a"
SERIALIZE_PROPERTY_TYPE: str = "{sv}"
SERIALIZE_STRV_TYPE: str = "as"
SERIALIZE_VECTOR_TYPE: str = "ad"
SF_SPHERICAL_HARMONICS_ARRAY_DEFAULT_ABSTOL: float = 0.0
SF_SPHERICAL_HARMONICS_DEFAULT_ABSTOL: float = 0.0
SF_SPHERICAL_HARMONICS_EPS: float = 0.0
SF_SPHERICAL_HARMONICS_LATERAL_MOVE: int = 1
SF_SPHERICAL_HARMONICS_MAX_LEN: int = 6
SPHERE_MAP_DEFAULT_SIGNAL: str = "SIGNAL"
SPHERE_MAP_HEALPIX_NULLVAL: float = 1.6375e+30
SPLINE2D_BICUBIC_00: int = 0
SPLINE2D_BICUBIC_01: int = 2
SPLINE2D_BICUBIC_10: int = 1
SPLINE2D_BICUBIC_11: int = 3
SPLINE2D_BICUBIC_F: int = 0
SPLINE2D_BICUBIC_FX: int = 1
SPLINE2D_BICUBIC_FXY: int = 3
SPLINE2D_BICUBIC_FY: int = 2
SPLINE_FUNC_DEFAULT_MAX_NODES: int = 10000000
SPLINE_KNOT_DIFF_TOL: int = 0
THREAD_POOL_MAX: int = 5
TIMER_SEC_FORMAT: str = "%07.4f"
ZERO_LIMIT: float = 0.0
_lock = ... # FIXME Constant
_namespace: str = "NumCosmoMath"
_version: str = "1.0"

def binsplit_join(bs: BinSplit, bs_l: BinSplit, bs_r: BinSplit) -> None: ...
def cfg_command_line(argv: str, argc: int) -> str: ...
def cfg_enable_gsl_err_handler() -> None: ...
def cfg_entries_to_keyfile(kfile: GLib.KeyFile, group_name: str, entries: GLib.OptionEntry) -> None: ...
def cfg_enum_get_value(enum_type: Type, n: int) -> GObject.EnumValue: ...
def cfg_enum_print_all(enum_type: Type, header: str) -> None: ...
def cfg_get_data_filename(filename: str, must_exist: bool) -> str: ...
def cfg_get_enum_by_id_name_nick(enum_type: Type, id_name_nick: str) -> GObject.EnumValue: ...
def cfg_init() -> None: ...
def cfg_init_full(argc: int, argv: Sequence[str]) -> list[str]: ...
def cfg_init_full_ptr(argc: int, argv: Sequence[str]) -> None: ...
def cfg_keyfile_to_arg(kfile: GLib.KeyFile, group_name: str, entries: GLib.OptionEntry, argv: str, argc: int) -> None: ...
def cfg_lock_plan_fftw() -> None: ...
def cfg_logfile(on: bool) -> None: ...
def cfg_logfile_flush(on: bool) -> None: ...
def cfg_logfile_flush_now() -> None: ...
def cfg_mpi_nslaves() -> int: ...
def cfg_msg_sepa() -> None: ...
def cfg_register_obj(obj: Type) -> None: ...
def cfg_set_blis_nthreads(n: int) -> None: ...
def cfg_set_error_log_handler(logger: Callable[[str], None]) -> None: ...
def cfg_set_fftw_default_flag(flag: int, timeout: float) -> None: ...
def cfg_set_log_handler(logger: Callable[[str], None]) -> None: ...
def cfg_set_logfile(filename: str) -> None: ...
def cfg_set_logstream(stream: int) -> None: ...
def cfg_set_mkl_nthreads(n: int) -> None: ...
def cfg_set_openblas_nthreads(n: int) -> None: ...
def cfg_set_openmp_nthreads(n: int) -> None: ...
def cfg_string_to_comment(str: str) -> str: ...
def cfg_unlock_plan_fftw() -> None: ...
def cmp(x: float, y: float, reltol: float, abstol: float) -> int: ...
def cmpdbl(x: float, y: float) -> float: ...
def complex_clear(c: Complex) -> None: ...
def d1exprel(x: float) -> float: ...
def d2exprel(x: float) -> float: ...
def d3exprel(x: float) -> float: ...
def exprel(x: float) -> float: ...
def func_eval_log_pool_stats() -> None: ...
def func_eval_set_max_threads(mt: int) -> None: ...
def func_eval_threaded_loop(lfunc: Callable[..., None], i: int, f: int, *data: Any) -> None: ...
def func_eval_threaded_loop_full(lfunc: Callable[..., None], i: int, f: int, *data: Any) -> None: ...
def func_eval_threaded_loop_nw(lfunc: Callable[..., None], i: int, f: int, nworkers: int, *data: Any) -> None: ...
def integrate_2dim(integ: Integrand2dim, xi: float, yi: float, xf: float, yf: float, epsrel: float, epsabs: float, result: float, error: float) -> bool: ...
def integrate_2dim_divonne(integ: Integrand2dim, xi: float, yi: float, xf: float, yf: float, epsrel: float, epsabs: float, ngiven: int, ldxgiven: int, xgiven: float, result: float, error: float) -> bool: ...
def integrate_2dim_divonne_peakfinder(integ: Integrand2dim, xi: float, yi: float, xf: float, yf: float, epsrel: float, epsabs: float, ngiven: int, ldxgiven: int, xgiven: float, nextra: int, peakfinder: Callable[[int, float, int, float, None], None], result: float, error: float) -> bool: ...
def integrate_2dim_vegas(integ: Integrand2dim, xi: float, yi: float, xf: float, yf: float, epsrel: float, epsabs: float, nstart: int, result: float, error: float) -> bool: ...
def integrate_3dim(integ: Integrand3dim, xi: float, yi: float, zi: float, xf: float, yf: float, zf: float, epsrel: float, epsabs: float, result: float, error: float) -> bool: ...
def integrate_3dim_divonne(integ: Integrand3dim, xi: float, yi: float, zi: float, xf: float, yf: float, zf: float, epsrel: float, epsabs: float, ngiven: int, ldxgiven: int, xgiven: float, result: float, error: float) -> bool: ...
def integrate_3dim_vegas(integ: Integrand3dim, xi: float, yi: float, zi: float, xf: float, yf: float, zf: float, epsrel: float, epsabs: float, nstart: int, result: float, error: float) -> bool: ...
def lapack_dgeev(jobvl: int, jobvr: int, n: int, a: float, lda: int, wr: float, wi: float, vl: float, ldvl: int, vr: float, ldvr: int, work: float, lwork: int) -> int: ...
def lapack_dgeevx(balanc: int, jobvl: int, jobvr: int, sense: int, n: int, a: float, lda: int, wr: float, wi: float, vl: float, ldvl: int, vr: float, ldvr: int, ilo: int, ihi: int, scale: float, abnrm: float, rconde: float, rcondv: float, work: float, lwork: int, iwork: int) -> int: ...
def lapack_dgelqf(m: int, n: int, a: float, lda: int, tau: float, ws: LapackWS) -> int: ...
def lapack_dgels(trans: int, m: int, n: int, nrhs: int, a: float, lda: int, b: float, ldb: int, work: float, lwork: int) -> int: ...
def lapack_dgelsd(m: int, n: int, nrhs: int, a: float, lda: int, b: float, ldb: int, s: float, rcond: float, rank: int, ws: LapackWS) -> int: ...
def lapack_dgeqlf(m: int, n: int, a: float, lda: int, tau: float, ws: LapackWS) -> int: ...
def lapack_dgeqrf(m: int, n: int, a: float, lda: int, tau: float, ws: LapackWS) -> int: ...
def lapack_dgerqf(m: int, n: int, a: float, lda: int, tau: float, ws: LapackWS) -> int: ...
def lapack_dggglm_alloc(L: Matrix, X: Matrix, p: Vector, d: Vector, y: Vector) -> list[float]: ...
def lapack_dggglm_run(ws: Sequence[float], L: Matrix, X: Matrix, p: Vector, d: Vector, y: Vector) -> int: ...
def lapack_dposv(uplo: int, n: int, nrhs: int, a: float, lda: int, b: float, ldb: int) -> int: ...
def lapack_dpotrf(uplo: int, n: int, a: float, lda: int) -> int: ...
def lapack_dpotri(uplo: int, n: int, a: float, lda: int) -> int: ...
def lapack_dpotrs(uplo: int, n: int, nrhs: int, a: float, lda: int, b: float, ldb: int) -> int: ...
def lapack_dptsv(d: float, e: float, b: float, x: float, n: int) -> int: ...
def lapack_dsyevd(jobz: int, uplo: int, n: int, a: float, lda: int, w: float, ws: LapackWS) -> int: ...
def lapack_dsyevr(jobz: int, range: int, uplo: int, n: int, a: float, lda: int, vl: float, vu: float, il: int, iu: int, abstol: float, m: int, w: float, z: float, ldz: int, isuppz: int, ws: LapackWS) -> int: ...
def lapack_dsysv(uplo: int, n: int, nrhs: int, a: float, lda: int, ipiv: int, b: float, ldb: int, work: float, lwork: int) -> int: ...
def lapack_dsysvx(fact: int, uplo: int, n: int, nrhs: int, a: float, lda: int, af: float, ldaf: int, ipiv: int, b: float, ldb: int, x: float, ldx: int, rcond: float, ferr: float, berr: float, work: float, lwork: int, iwork: int) -> int: ...
def lapack_dsysvxx(fact: int, uplo: int, n: int, nrhs: int, a: float, lda: int, af: float, ldaf: int, ipiv: int, equed: str, s: float, b: float, ldb: int, x: float, ldx: int, rcond: float, rpvgrw: float, berr: float, n_err_bnds: int, err_bnds_norm: float, err_bnds_comp: float, nparams: int, params: float, work: float, iwork: int) -> int: ...
def lapack_dsytrf(uplo: int, n: int, a: float, lda: int, ipiv: int, ws: LapackWS) -> int: ...
def lapack_dsytri(uplo: int, n: int, a: float, lda: int, ipiv: int, ws: LapackWS) -> int: ...
def lapack_dsytrs(uplo: int, n: int, nrhs: int, a: float, lda: int, ipiv: int, b: float, ldb: int) -> int: ...
def lapack_ws_clear(ws: LapackWS) -> None: ...
def lh_ratio2d_region_clear(rg: LHRatio2dRegion) -> None: ...
def memory_pool_return(p: None) -> None: ...
def message_str(msg: str) -> None: ...
def message_ww(msg: str, first: str, rest: str, ncols: int) -> None: ...
def mpsf_0F1_free_cache() -> None: ...
def mpsf_sbessel_free_cache() -> None: ...
def obj_array_clear(oa: ObjArray) -> None: ...
def obj_array_load(filename: str, ser: Serialize) -> ObjArray: ...
def sf_sbessel(l: int, x: float) -> float: ...
def sf_sbessel_spline(l: int, xi: float, xf: float, reltol: float) -> Spline: ...
def sf_sbessel_taylor(l: int, x: float) -> list[float]: ...
def sf_sin_int(x: float) -> float: ...
def spline2dim_integ_total(s2d: Spline2d) -> float: ...
def string_ww(msg: str, first: str, rest: str, ncols: int) -> str: ...
def util_1mcosx(sinx: float, cosx: float) -> float: ...
def util_1msinx(sinx: float, cosx: float) -> float: ...
def util_1pcosx(sinx: float, cosx: float) -> float: ...
def util_1psinx(sinx: float, cosx: float) -> float: ...
def util_basename_fits(fits_filename: str) -> str: ...
def util_cos2x(sinx: float, cosx: float) -> float: ...
def util_cvode_check_flag(flagvalue: None, funcname: str, opt: int) -> bool: ...
def util_cvode_print_stats(cvode: None) -> bool: ...
def util_fact_size(n: int) -> int: ...
def util_function_params(func: str) -> Tuple[str, list[float], int]: ...
def util_great_circle_distance(ra1: float, dec1: float, ra2: float, dec2: float) -> float: ...
def util_ln1pexpx(x: float) -> float: ...
def util_mln_1mIexpzA_1pIexpmzA(rho: float, theta: float, A: float) -> Tuple[float, float]: ...
def util_position_angle(ra1: float, dec1: float, ra2: float, dec2: float) -> float: ...
def util_sinh1(x: float) -> float: ...
def util_sinh3(x: float) -> float: ...
def util_sinhx_m_xcoshx_x3(x: float) -> float: ...
def util_sleep_ms(milliseconds: int) -> None: ...
def util_smooth_trans(f0: float, f1: float, z0: float, dz: float, z: float) -> float: ...
def util_smooth_trans_get_theta(z0: float, dz: float, z: float, theta0: float, theta1: float) -> None: ...
def util_sqrt1px_m1(x: float) -> float: ...

class ABC(GObject.Object):
    r"""
    :Constructors:

    ::

        ABC(**properties)

    Object NcmABC

    Properties from NcmABC:
      mset -> NcmMSet: mset
        Model Set
      prior -> NcmMSetTransKern: prior
        Prior Sampler
      trans-kernel -> NcmMSetTransKern: trans-kernel
        Transition Kernel
      data-set -> NcmDataset: data-set
        Dataset
      epsilon -> gdouble: epsilon
        epsilon
      nparticles -> guint: nparticles
        Number of particles

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        data_set: Dataset
        epsilon: float
        mset: MSet
        nparticles: int
        prior: MSetTransKern
        trans_kernel: MSetTransKern
    props: Props = ...
    parent_instance: GObject.Object = ...
    def __init__(self, data_set: Dataset = ...,
                 epsilon: float = ...,
                 mset: MSet = ...,
                 prior: MSetTransKern = ...,
                 trans_kernel: MSetTransKern = ...): ...
    @staticmethod
    def clear(abc: ABC) -> None: ...
    def data_summary(self) -> bool: ...
    def distance_prob(self, distance: float) -> float: ...
    def do_data_summary(self) -> bool: ...
    def do_distance_prob(self, distance: float) -> float: ...
    def do_get_desc(self) -> str: ...
    def do_log_info(self) -> str: ...
    def do_mock_distance(self, dset: Dataset, theta: Vector, thetastar: Vector, rng: RNG) -> float: ...
    def do_update_tkern(self) -> None: ...
    def end_run(self) -> None: ...
    def end_update(self) -> None: ...
    def free(self) -> None: ...
    def get_accept_ratio(self) -> float: ...
    def get_depsilon(self) -> float: ...
    def get_desc(self) -> str: ...
    def get_dist_quantile(self, p: float) -> float: ...
    def get_epsilon(self) -> float: ...
    def get_mtype(self) -> FitRunMsgs: ...
    def log_info(self) -> str: ...
    def mean_covar(self, fit: Fit) -> None: ...
    def mock_distance(self, dset: Dataset, theta: Vector, thetastar: Vector, rng: RNG) -> float: ...
    def peek_catalog(self) -> MSetCatalog: ...
    def peek_covar(self) -> Matrix: ...
    def peek_dataset(self) -> Dataset: ...
    def peek_trans_kern(self) -> MSetTransKern: ...
    def reset(self) -> None: ...
    def run(self, nparticles: int) -> None: ...
    def set_data_file(self, filename: str) -> None: ...
    def set_mtype(self, mtype: FitRunMsgs) -> None: ...
    def set_nthreads(self, nthreads: int) -> None: ...
    def set_rng(self, rng: RNG) -> None: ...
    def set_trans_kern(self, tkern: MSetTransKern) -> None: ...
    def start_run(self) -> None: ...
    def start_update(self) -> None: ...
    def update(self) -> None: ...
    def update_epsilon(self, epsilon: float) -> None: ...
    def update_tkern(self) -> None: ...
    

class ABCClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ABCClass()
    """
    parent_class: GObject.ObjectClass = ...
    data_summary: Callable[[ABC], bool] = ...
    mock_distance: Callable[[ABC, Dataset, Vector, Vector, RNG], float] = ...
    distance_prob: Callable[[ABC, float], float] = ...
    update_tkern: Callable[[ABC], None] = ...
    get_desc: Callable[[ABC], str] = ...
    log_info: Callable[[ABC], str] = ...
    padding: list[None] = ...

class BinSplit(GObject.GPointer):
    r"""
    :Constructors:

    ::

        BinSplit()
    """
    userdata: None = ...
    n1: int = ...
    n2: int = ...
    P: int = ...
    Q: int = ...
    B: int = ...
    T: int = ...
    temp1: int = ...
    temp2: int = ...
    temp3: int = ...
    temp4: int = ...
    bs: list[BinSplit] = ...

class Bootstrap(GObject.Object):
    r"""
    :Constructors:

    ::

        Bootstrap(**properties)
        full_new(fsize:int, bsize:int) -> NumCosmoMath.Bootstrap
        new() -> NumCosmoMath.Bootstrap
        sized_new(fsize:int) -> NumCosmoMath.Bootstrap

    Object NcmBootstrap

    Properties from NcmBootstrap:
      full-size -> guint: full-size
        Data sample size
      bootstrap-size -> guint: bootstrap-size
        Bootstrap size
      init -> gboolean: init
        Bootstrap initialization status
      realization -> GVariant: realization
        Bootstrap current realization

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        bootstrap_size: int
        full_size: int
        init: bool
        realization: GLib.Variant
    props: Props = ...
    def __init__(self, bootstrap_size: int = ...,
                 full_size: int = ...,
                 realization: GLib.Variant = ...): ...
    @staticmethod
    def clear(bstrap: Bootstrap) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def full_new(cls, fsize: int, bsize: int) -> Bootstrap: ...
    def get(self, i: int) -> int: ...
    def get_bsize(self) -> int: ...
    def get_fsize(self) -> int: ...
    def get_sortncomp(self) -> list[int]: ...
    def is_init(self) -> bool: ...
    @classmethod
    def new(cls) -> Bootstrap: ...
    def ref(self) -> Bootstrap: ...
    def remix(self, rng: RNG) -> None: ...
    def resample(self, rng: RNG) -> None: ...
    def set_bsize(self, bsize: int) -> None: ...
    def set_fsize(self, fsize: int) -> None: ...
    @classmethod
    def sized_new(cls, fsize: int) -> Bootstrap: ...
    

class BootstrapClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        BootstrapClass()
    """
    parent_class: GObject.ObjectClass = ...

class C(GObject.Object):
    r"""
    :Constructors:

    ::

        C(**properties)

    Object NcmC

    Signals from GObject:
      notify (GParam)
    """
    @staticmethod
    def AR() -> float: ...
    @staticmethod
    def G() -> float: ...
    @staticmethod
    def G_mass_solar() -> float: ...
    @staticmethod
    def Glightyear_Mpc() -> float: ...
    @staticmethod
    def HI_Lyman_wl3_8pi_2p_2P0_5() -> float: ...
    @staticmethod
    def HI_Lyman_wl3_8pi_2p_2P3_5() -> float: ...
    @staticmethod
    def HI_Lyman_wl3_8pi_2p_2Pmean() -> float: ...
    @staticmethod
    def HI_Lyman_wl3_8pi_2s_2S0_5() -> float: ...
    @staticmethod
    def HI_Lyman_wl_2p_2P0_5() -> float: ...
    @staticmethod
    def HI_Lyman_wl_2p_2P3_5() -> float: ...
    @staticmethod
    def HI_Lyman_wl_2p_2Pmean() -> float: ...
    @staticmethod
    def HI_Lyman_wl_2s_2S0_5() -> float: ...
    @staticmethod
    def HI_Lyman_wn_2p_2P0_5() -> float: ...
    @staticmethod
    def HI_Lyman_wn_2p_2P3_5() -> float: ...
    @staticmethod
    def HI_Lyman_wn_2p_2Pmean() -> float: ...
    @staticmethod
    def HI_Lyman_wn_2s_2S0_5() -> float: ...
    @staticmethod
    def HI_ion_E_1s_2S0_5() -> float: ...
    @staticmethod
    def HI_ion_E_2p_2P0_5() -> float: ...
    @staticmethod
    def HI_ion_E_2p_2P3_5() -> float: ...
    @staticmethod
    def HI_ion_E_2p_2Pmean() -> float: ...
    @staticmethod
    def HI_ion_E_2s_2S0_5() -> float: ...
    @staticmethod
    def HI_ion_wn_1s_2S0_5() -> float: ...
    @staticmethod
    def HI_ion_wn_2p_2P0_5() -> float: ...
    @staticmethod
    def HI_ion_wn_2p_2P3_5() -> float: ...
    @staticmethod
    def HI_ion_wn_2p_2Pmean() -> float: ...
    @staticmethod
    def HI_ion_wn_2s_2S0_5() -> float: ...
    @staticmethod
    def H_bind(n: float, j: float) -> float: ...
    @staticmethod
    def H_reduced_energy() -> float: ...
    @staticmethod
    def H_reduced_mass() -> float: ...
    @staticmethod
    def HeII_ion_E_1s_2S0_5() -> float: ...
    @staticmethod
    def HeII_ion_wn_1s_2S0_5() -> float: ...
    @staticmethod
    def HeI_Balmer_E_kb_2p_1P1_2s_1S0() -> float: ...
    @staticmethod
    def HeI_Balmer_E_kb_2p_3Pmean_2s_3S1() -> float: ...
    @staticmethod
    def HeI_Balmer_wn_2p_1P1_2s_1S0() -> float: ...
    @staticmethod
    def HeI_Balmer_wn_2p_3Pmean_2s_3S1() -> float: ...
    @staticmethod
    def HeI_Lyman_wl3_8pi_2p_1P1() -> float: ...
    @staticmethod
    def HeI_Lyman_wl3_8pi_2p_3P0() -> float: ...
    @staticmethod
    def HeI_Lyman_wl3_8pi_2p_3P1() -> float: ...
    @staticmethod
    def HeI_Lyman_wl3_8pi_2p_3P2() -> float: ...
    @staticmethod
    def HeI_Lyman_wl3_8pi_2p_3Pmean() -> float: ...
    @staticmethod
    def HeI_Lyman_wl3_8pi_2s_1S0() -> float: ...
    @staticmethod
    def HeI_Lyman_wl3_8pi_2s_3S1() -> float: ...
    @staticmethod
    def HeI_Lyman_wl_2p_1P1() -> float: ...
    @staticmethod
    def HeI_Lyman_wl_2p_3P0() -> float: ...
    @staticmethod
    def HeI_Lyman_wl_2p_3P1() -> float: ...
    @staticmethod
    def HeI_Lyman_wl_2p_3P2() -> float: ...
    @staticmethod
    def HeI_Lyman_wl_2p_3Pmean() -> float: ...
    @staticmethod
    def HeI_Lyman_wl_2s_1S0() -> float: ...
    @staticmethod
    def HeI_Lyman_wl_2s_3S1() -> float: ...
    @staticmethod
    def HeI_Lyman_wn_2p_1P1() -> float: ...
    @staticmethod
    def HeI_Lyman_wn_2p_3P0() -> float: ...
    @staticmethod
    def HeI_Lyman_wn_2p_3P1() -> float: ...
    @staticmethod
    def HeI_Lyman_wn_2p_3P2() -> float: ...
    @staticmethod
    def HeI_Lyman_wn_2p_3Pmean() -> float: ...
    @staticmethod
    def HeI_Lyman_wn_2s_1S0() -> float: ...
    @staticmethod
    def HeI_Lyman_wn_2s_3S1() -> float: ...
    @staticmethod
    def HeI_ion_E_1s_1S0() -> float: ...
    @staticmethod
    def HeI_ion_E_2p_1P1() -> float: ...
    @staticmethod
    def HeI_ion_E_2p_3P0() -> float: ...
    @staticmethod
    def HeI_ion_E_2p_3P1() -> float: ...
    @staticmethod
    def HeI_ion_E_2p_3P2() -> float: ...
    @staticmethod
    def HeI_ion_E_2p_3Pmean() -> float: ...
    @staticmethod
    def HeI_ion_E_2s_1S0() -> float: ...
    @staticmethod
    def HeI_ion_E_2s_3S1() -> float: ...
    @staticmethod
    def HeI_ion_wn_1s_1S0() -> float: ...
    @staticmethod
    def HeI_ion_wn_2p_1P1() -> float: ...
    @staticmethod
    def HeI_ion_wn_2p_3P0() -> float: ...
    @staticmethod
    def HeI_ion_wn_2p_3P1() -> float: ...
    @staticmethod
    def HeI_ion_wn_2p_3P2() -> float: ...
    @staticmethod
    def HeI_ion_wn_2p_3Pmean() -> float: ...
    @staticmethod
    def HeI_ion_wn_2s_1S0() -> float: ...
    @staticmethod
    def HeI_ion_wn_2s_3S1() -> float: ...
    @staticmethod
    def Mpc() -> float: ...
    @staticmethod
    def Rinf() -> float: ...
    @staticmethod
    def Ry() -> float: ...
    @staticmethod
    def au() -> float: ...
    @staticmethod
    def blackbody_energy_density() -> float: ...
    @staticmethod
    def blackbody_per_crit_density_h2() -> float: ...
    @staticmethod
    def boltzmann_factor_HI_1s_2S0_5(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HI_2p_2P0_5(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HI_2p_2P3_5(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HI_2p_2Pmean(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HI_2s_2S0_5(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HeI_1s_1S0(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HeI_2p_1P1(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HeI_2p_3P0(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HeI_2p_3P1(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HeI_2p_3P2(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HeI_2p_3Pmean(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HeI_2s_1S0(T: float) -> float: ...
    @staticmethod
    def boltzmann_factor_HeI_2s_3S1(T: float) -> float: ...
    @staticmethod
    def c() -> float: ...
    @staticmethod
    def c2() -> float: ...
    @staticmethod
    def crit_density_h2() -> float: ...
    @staticmethod
    def crit_mass_density_h2() -> float: ...
    @staticmethod
    def crit_mass_density_h2_solar_mass_Mpc3() -> float: ...
    @staticmethod
    def crit_number_density_n() -> float: ...
    @staticmethod
    def crit_number_density_p() -> float: ...
    @staticmethod
    def decay_H_rate_2s_1s() -> float: ...
    @staticmethod
    def decay_He_rate_2s_1s() -> float: ...
    @staticmethod
    def degree_to_radian(d: float) -> float: ...
    @staticmethod
    def eV() -> float: ...
    @staticmethod
    def fine_struct() -> float: ...
    @staticmethod
    def fine_struct_square() -> float: ...
    @staticmethod
    def h() -> float: ...
    @staticmethod
    def hbar() -> float: ...
    @staticmethod
    def hc() -> float: ...
    @staticmethod
    def hubble_cte_hst() -> float: ...
    @staticmethod
    def hubble_cte_planck6_base() -> float: ...
    @staticmethod
    def hubble_radius_hm1_Mpc() -> float: ...
    @staticmethod
    def hubble_radius_hm1_planck() -> float: ...
    @staticmethod
    def kb() -> float: ...
    @staticmethod
    def kpc() -> float: ...
    @staticmethod
    def lightyear() -> float: ...
    @staticmethod
    def lightyear_pc() -> float: ...
    @staticmethod
    def mass_1H() -> float: ...
    @staticmethod
    def mass_1H_u() -> float: ...
    @staticmethod
    def mass_2H() -> float: ...
    @staticmethod
    def mass_2H_u() -> float: ...
    @staticmethod
    def mass_3H() -> float: ...
    @staticmethod
    def mass_3H_u() -> float: ...
    @staticmethod
    def mass_3He() -> float: ...
    @staticmethod
    def mass_3He_u() -> float: ...
    @staticmethod
    def mass_4He() -> float: ...
    @staticmethod
    def mass_4He_u() -> float: ...
    @staticmethod
    def mass_atomic() -> float: ...
    @staticmethod
    def mass_e() -> float: ...
    @staticmethod
    def mass_n() -> float: ...
    @staticmethod
    def mass_p() -> float: ...
    @staticmethod
    def mass_ratio_4He_1H() -> float: ...
    @staticmethod
    def mass_ratio_alpha_p() -> float: ...
    @staticmethod
    def mass_ratio_e_p() -> float: ...
    @staticmethod
    def mass_solar() -> float: ...
    @staticmethod
    def pc() -> float: ...
    @staticmethod
    def planck_length() -> float: ...
    @staticmethod
    def planck_length2() -> float: ...
    @staticmethod
    def radian_0_2pi(r: float) -> float: ...
    @staticmethod
    def radian_to_degree(r: float) -> float: ...
    @staticmethod
    def rest_energy_1H() -> float: ...
    @staticmethod
    def rest_energy_2H() -> float: ...
    @staticmethod
    def rest_energy_3H() -> float: ...
    @staticmethod
    def rest_energy_3He() -> float: ...
    @staticmethod
    def rest_energy_4He() -> float: ...
    @staticmethod
    def rest_energy_atomic() -> float: ...
    @staticmethod
    def rest_energy_e() -> float: ...
    @staticmethod
    def rest_energy_n() -> float: ...
    @staticmethod
    def rest_energy_p() -> float: ...
    @staticmethod
    def sign_sin(r: float) -> float: ...
    @staticmethod
    def stefan_boltzmann() -> float: ...
    @staticmethod
    def thermal_wl_e() -> float: ...
    @staticmethod
    def thermal_wl_n() -> float: ...
    @staticmethod
    def thermal_wl_p() -> float: ...
    @staticmethod
    def thermal_wn_e() -> float: ...
    @staticmethod
    def thermal_wn_n() -> float: ...
    @staticmethod
    def thermal_wn_p() -> float: ...
    @staticmethod
    def thomson_cs() -> float: ...
    @staticmethod
    def wmap5_coadded_I_K() -> float: ...
    @staticmethod
    def wmap5_coadded_I_Ka() -> float: ...
    @staticmethod
    def wmap5_coadded_I_Q() -> float: ...
    @staticmethod
    def wmap5_coadded_I_V() -> float: ...
    @staticmethod
    def wmap5_coadded_I_W() -> float: ...
    @staticmethod
    def year() -> float: ...
    

class CClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        CClass()
    """
    parent_class: GObject.ObjectClass = ...

class CSQ1D(GObject.Object):
    r"""
    :Constructors:

    ::

        CSQ1D(**properties)

    Object NcmCSQ1D

    Properties from NcmCSQ1D:
      reltol -> gdouble: reltol
        Relative tolerance
      abstol -> gdouble: abstol
        Absolute tolerance tolerance
      k -> gdouble: k
        Mode k
      ti -> gdouble: ti
        The initial time t_i
      tf -> gdouble: tf
        The final time t_f
      adiab-threshold -> gdouble: adiab-threshold
        The adiabatic threshold
      prop-threshold -> gdouble: prop-threshold
        The propagator threshold
      save-evol -> gboolean: save-evol
        Save the system evolution
      sing-detect -> gboolean: sing-detect
        Singularity detection

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        abstol: float
        adiab_threshold: float
        k: float
        prop_threshold: float
        reltol: float
        save_evol: bool
        sing_detect: bool
        tf: float
        ti: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    def __init__(self, abstol: float = ...,
                 adiab_threshold: float = ...,
                 k: float = ...,
                 prop_threshold: float = ...,
                 reltol: float = ...,
                 save_evol: bool = ...,
                 sing_detect: bool = ...,
                 tf: float = ...,
                 ti: float = ...): ...
    def alpha_dgamma_to_minkowski_frame(self, model: Optional[Model], adiab_frame: int, t: float, alpha: float, dgamma: float) -> Tuple[float, float]: ...
    def alpha_dgamma_to_phi_Pphi(self, model: Optional[Model], t: float, alpha: float, dgamma: float) -> Tuple[list[float], list[float]]: ...
    def alpha_gamma_circle(self, model: Optional[Model], alpha: float, gamma: float, r: float, theta: float) -> Tuple[float, float]: ...
    @staticmethod
    def clear(csq1d: CSQ1D) -> None: ...
    def do_eval_F1(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_F2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_FN(self, model: Optional[Model], n: int, t: float, k: float) -> float: ...
    def do_eval_dm(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_dxi(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_int_1_m(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_int_mnu2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_int_q2mnu2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_int_qmnu2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_m(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_nu(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_nu2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_powspec_factor(self, model: Optional[Model], k: float) -> float: ...
    def do_eval_xi(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_prepare(self, model: Optional[Model] = None) -> None: ...
    def eval_F1(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_F2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_FN(self, model: Optional[Model], n: int, t: float, k: float) -> float: ...
    def eval_adiab_at(self, model: Optional[Model], t: float) -> Tuple[float, float, float, float]: ...
    def eval_at(self, t: float) -> Tuple[float, float]: ...
    def eval_dm(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_dxi(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_int_1_m(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_int_mnu2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_int_q2mnu2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_int_qmnu2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_m(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_nonadiab_at(self, model: Optional[Model], nonadiab_frame: int, t: float) -> Tuple[float, float]: ...
    def eval_nu(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_nu2(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_powspec_factor(self, model: Optional[Model], k: float) -> float: ...
    def eval_xi(self, model: Optional[Model], t: float, k: float) -> float: ...
    def evolve_prop_vector_chi_Up(self, model: Optional[Model], t: float, nonadiab_frame: int, chi_i: float, Up_i: float) -> Tuple[float, float]: ...
    def find_adiab_max(self, model: Optional[Model], t0: float, t1: float, border_eps: float) -> Tuple[float, float, float, float]: ...
    def find_adiab_time_limit(self, model: Optional[Model], t0: float, t1: float, reltol: float) -> Tuple[bool, float]: ...
    def free(self) -> None: ...
    def get_H_poincare_disc(self, model: Optional[Model], t: float) -> Tuple[float, float]: ...
    def get_H_poincare_hp(self, model: Optional[Model], t: float) -> Tuple[float, float]: ...
    def get_Hadiab_poincare_disc(self, model: Optional[Model], t: float) -> Tuple[float, float]: ...
    def get_Hadiab_poincare_hp(self, model: Optional[Model], t: float) -> Tuple[float, float]: ...
    def get_J_at(self, model: Optional[Model], t: float) -> Tuple[float, float, float]: ...
    def get_abstol(self) -> float: ...
    def get_adiab_threshold(self) -> float: ...
    def get_k(self) -> float: ...
    def get_minkowski_frame(self, model: Optional[Model], adiab_frame: int, t: float) -> Tuple[float, float]: ...
    def get_poincare_disc(self, model: Optional[Model], t: float) -> Tuple[float, float]: ...
    def get_poincare_hp(self, model: Optional[Model], t: float) -> Tuple[float, float]: ...
    def get_poincare_hp_frame(self, model: Optional[Model], adiab_frame: int, t: float) -> Tuple[float, float]: ...
    def get_prop_threshold(self) -> float: ...
    def get_prop_vector_chi_Up(self, model: Optional[Model], t: float) -> Tuple[float, float]: ...
    def get_reltol(self) -> float: ...
    def get_save_evol(self) -> bool: ...
    def get_sing_detect(self) -> bool: ...
    def get_tf(self) -> float: ...
    def get_tf_prop(self) -> float: ...
    def get_ti(self) -> float: ...
    def get_time_array(self) -> Tuple[list[float], float]: ...
    def prepare(self, model: Optional[Model] = None) -> None: ...
    def prepare_prop(self, model: Optional[Model], ti: float, tii: float, tf: float) -> None: ...
    def ref(self) -> CSQ1D: ...
    def set_abstol(self, abstol: float) -> None: ...
    def set_adiab_threshold(self, adiab_threshold: float) -> None: ...
    def set_init_cond(self, state: CSQ1DEvolState, ti: float, x: float, y: float) -> None: ...
    def set_init_cond_adiab(self, model: Optional[Model], ti: float) -> None: ...
    def set_k(self, k: float) -> None: ...
    def set_prop_threshold(self, prop_threshold: float) -> None: ...
    def set_reltol(self, reltol: float) -> None: ...
    def set_save_evol(self, save: bool) -> None: ...
    def set_sing_detect(self, enable: bool) -> None: ...
    def set_tf(self, tf: float) -> None: ...
    def set_ti(self, ti: float) -> None: ...
    

class CSQ1DClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        CSQ1DClass()
    """
    parent_class: GObject.ObjectClass = ...
    eval_xi: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_dxi: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_nu: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_nu2: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_m: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_int_1_m: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_int_mnu2: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_int_qmnu2: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_int_q2mnu2: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_dm: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_F1: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_F2: Callable[[CSQ1D, Optional[Model], float, float], float] = ...
    eval_FN: Callable[[CSQ1D, Optional[Model], int, float, float], float] = ...
    eval_powspec_factor: Callable[[CSQ1D, Optional[Model], float], float] = ...
    prepare: Callable[[CSQ1D, Optional[Model]], None] = ...
    padding: list[None] = ...

class CSQ1DSingFitUm(GObject.GPointer): ...

class CSQ1DSingFitUp(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        CSQ1DSingFitUp()
        new(chi_dim:int, Up_dim:int) -> NumCosmoMath.CSQ1DSingFitUp
    """
    chi_dim: int = ...
    Up_dim: int = ...
    chi_c: Vector = ...
    Up_c: Vector = ...
    def dup(self) -> CSQ1DSingFitUp: ...
    def eval_chi(self, csq1d: CSQ1D, model: Optional[Model], t: float) -> float: ...
    def eval_dchi(self, csq1d: CSQ1D, model: Optional[Model], t: float) -> float: ...
    def eval_dexp_Up(self, csq1d: CSQ1D, model: Optional[Model], t: float) -> float: ...
    def eval_exp_Up(self, csq1d: CSQ1D, model: Optional[Model], t: float) -> float: ...
    def fit(self, csq1d: CSQ1D, model: Optional[Model], t: Vector, chim_t: Vector, exp_Up: Vector) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, chi_dim: int, Up_dim: int) -> CSQ1DSingFitUp: ...
    

class Calc(GObject.Object):
    r"""
    :Constructors:

    ::

        Calc(**properties)

    Object NcmCalc

    Properties from NcmCalc:
      reltol -> gdouble: reltol
        Relative tolerance
      abstol -> gdouble: abstol
        Absolute tolerance

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        abstol: float
        reltol: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    reltol: float = ...
    abstol: float = ...
    ctrl: list[None] = ...
    def __init__(self, abstol: float = ...,
                 reltol: float = ...): ...
    def check(self) -> None: ...
    def do_prepare(self) -> None: ...
    def get_abstol(self) -> float: ...
    def get_reltol(self) -> float: ...
    def prepare_array(self, ma: Sequence[Model]) -> None: ...
    def prepare_if_needed_array(self, ma: Sequence[Model]) -> None: ...
    def set_abstol(self, abstol: float) -> None: ...
    def set_dep(self, p: int, dep_model: Type) -> None: ...
    def set_num_dep(self, ndep: int) -> None: ...
    def set_reltol(self, reltol: float) -> None: ...
    

class CalcClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        CalcClass()
    """
    parent_class: GObject.ObjectClass = ...
    ndep: int = ...
    dep_list: list[None] = ...
    prepare: Callable[[Calc], None] = ...
    def check(self) -> None: ...
    def set_dep(self, p: int, dep_model: Type) -> None: ...
    def set_num_dep(self, ndep: int) -> None: ...
    

class Complex(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        Complex()
        new() -> NumCosmoMath.Complex
    """
    z: list[float] = ...
    def Im(self) -> float: ...
    def Re(self) -> float: ...
    @staticmethod
    def clear(c: Complex) -> None: ...
    def dup(self) -> Complex: ...
    def free(self) -> None: ...
    def mul_real(self, v: float) -> None: ...
    @classmethod
    def new(cls) -> Complex: ...
    def ref(self) -> Complex: ...
    def res_add_mul(self, c2: Complex, c3: Complex) -> None: ...
    def res_add_mul_real(self, c2: Complex, v: float) -> None: ...
    def res_mul(self, c2: Complex) -> None: ...
    def set(self, a: float, b: float) -> None: ...
    def set_zero(self) -> None: ...
    

class Data(GObject.Object):
    r"""
    :Constructors:

    ::

        Data(**properties)
        new_from_file(filename:str) -> NumCosmoMath.Data

    Object NcmData

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    parent_instance: GObject.Object = ...
    def __init__(self, bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    def bootstrap_create(self) -> None: ...
    def bootstrap_enabled(self) -> bool: ...
    def bootstrap_remove(self) -> None: ...
    def bootstrap_resample(self, rng: RNG) -> None: ...
    def bootstrap_set(self, bstrap: Bootstrap) -> None: ...
    @staticmethod
    def clear(data: Data) -> None: ...
    def do_begin(self) -> None: ...
    def do_fisher_matrix(self, mset: MSet) -> Matrix: ...
    def do_get_dof(self) -> int: ...
    def do_get_length(self) -> int: ...
    def do_inv_cov_UH(self, mset: MSet, H: Matrix) -> None: ...
    def do_leastsquares_J(self, mset: MSet, J: Matrix) -> None: ...
    def do_leastsquares_f(self, mset: MSet, f: Vector) -> None: ...
    def do_leastsquares_f_J(self, mset: MSet, f: Vector, J: Matrix) -> None: ...
    def do_m2lnL_grad(self, mset: MSet, grad: Vector) -> None: ...
    def do_m2lnL_val(self, mset: MSet) -> float: ...
    def do_m2lnL_val_grad(self, mset: MSet, grad: Vector) -> float: ...
    def do_mean_vector(self, mset: MSet, mu: Vector) -> None: ...
    def do_prepare(self, mset: MSet) -> None: ...
    def do_resample(self, mset: MSet, rng: RNG) -> None: ...
    def dup(self, ser_obj: Serialize) -> Data: ...
    def fisher_matrix(self, mset: MSet) -> Matrix: ...
    def free(self) -> None: ...
    def get_desc(self) -> str: ...
    def get_dof(self) -> int: ...
    def get_length(self) -> int: ...
    def inv_cov_UH(self, mset: MSet, H: Matrix) -> None: ...
    def is_init(self) -> bool: ...
    def leastsquares_J(self, mset: MSet, J: Matrix) -> None: ...
    def leastsquares_f(self, mset: MSet, f: Vector) -> None: ...
    def leastsquares_f_J(self, mset: MSet, f: Vector, J: Matrix) -> None: ...
    def m2lnL_grad(self, mset: MSet, grad: Vector) -> None: ...
    def m2lnL_val(self, mset: MSet) -> float: ...
    def m2lnL_val_grad(self, mset: MSet, grad: Vector) -> float: ...
    def mean_vector(self, mset: MSet, mu: Vector) -> None: ...
    @classmethod
    def new_from_file(cls, filename: str) -> Data: ...
    def peek_bootstrap(self) -> Bootstrap: ...
    def peek_desc(self) -> str: ...
    def prepare(self, mset: MSet) -> None: ...
    def ref(self) -> Data: ...
    def resample(self, mset: MSet, rng: RNG) -> None: ...
    def set_desc(self, desc: str) -> None: ...
    def set_init(self, state: bool) -> None: ...
    def sigma_vector(self, mset: MSet, sigma: Vector) -> None: ...
    def take_desc(self, desc: str) -> None: ...
    

class DataClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataClass()
    """
    parent_class: GObject.ObjectClass = ...
    name: str = ...
    bootstrap: bool = ...
    get_length: Callable[[Data], int] = ...
    get_dof: Callable[[Data], int] = ...
    begin: Callable[[Data], None] = ...
    prepare: Callable[[Data, MSet], None] = ...
    resample: Callable[[Data, MSet, RNG], None] = ...
    leastsquares_f: Callable[[Data, MSet, Vector], None] = ...
    leastsquares_J: Callable[[Data, MSet, Matrix], None] = ...
    leastsquares_f_J: Callable[[Data, MSet, Vector, Matrix], None] = ...
    m2lnL_val: Callable[[Data, MSet], float] = ...
    m2lnL_grad: Callable[[Data, MSet, Vector], None] = ...
    m2lnL_val_grad: Callable[[Data, MSet, Vector], float] = ...
    mean_vector: Callable[[Data, MSet, Vector], None] = ...
    inv_cov_UH: Callable[[Data, MSet, Matrix], None] = ...
    fisher_matrix: Callable[[Data, MSet], Matrix] = ...
    padding: list[None] = ...

class DataDist1d(Data):
    r"""
    :Constructors:

    ::

        DataDist1d(**properties)

    Object NcmDataDist1d

    Properties from NcmDataDist1d:
      n-points -> guint: n-points
        Data sample size
      vector -> NcmVector: vector
        Data vector

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        n_points: int
        vector: Vector
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    parent_instance: Data = ...
    def __init__(self, n_points: int = ...,
                 vector: Vector = ...,
                 bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    def do_get_size(self) -> int: ...
    def do_inv_pdf(self, mset: MSet, u: float) -> float: ...
    def do_set_size(self, np: int) -> None: ...
    def get_data(self) -> Vector: ...
    def get_size(self) -> int: ...
    def set_size(self, np: int) -> None: ...
    

class DataDist1dClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataDist1dClass()
    """
    parent_class: DataClass = ...
    m2lnL_val: Callable[[DataDist1d, MSet, float], float] = ...
    inv_pdf: Callable[[DataDist1d, MSet, float], float] = ...
    set_size: Callable[[DataDist1d, int], None] = ...
    get_size: Callable[[DataDist1d], int] = ...
    padding: list[None] = ...

class DataDist2d(Data):
    r"""
    :Constructors:

    ::

        DataDist2d(**properties)

    Object NcmDataDist2d

    Properties from NcmDataDist2d:
      n-points -> guint: n-points
        Data sample size
      matrix -> NcmMatrix: matrix
        Data matrix

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        matrix: Matrix
        n_points: int
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    parent_instance: Data = ...
    def __init__(self, matrix: Matrix = ...,
                 n_points: int = ...,
                 bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    def do_get_size(self) -> int: ...
    def do_inv_pdf(self, mset: MSet, u: float, v: float, x: float, y: float) -> None: ...
    def do_set_size(self, np: int) -> None: ...
    def get_data(self) -> Matrix: ...
    def get_size(self) -> int: ...
    def set_size(self, np: int) -> None: ...
    

class DataDist2dClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataDist2dClass()
    """
    parent_class: DataClass = ...
    m2lnL_val: Callable[[DataDist2d, MSet, float, float], float] = ...
    inv_pdf: Callable[[DataDist2d, MSet, float, float, float, float], None] = ...
    set_size: Callable[[DataDist2d, int], None] = ...
    get_size: Callable[[DataDist2d], int] = ...
    padding: list[None] = ...

class DataFunnel(Data):
    r"""
    :Constructors:

    ::

        DataFunnel(**properties)
        new() -> NumCosmoMath.DataFunnel

    Object NcmDataFunnel

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    def __init__(self, bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    @staticmethod
    def clear(dfu: DataFunnel) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls) -> DataFunnel: ...
    def ref(self) -> DataFunnel: ...
    

class DataFunnelClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataFunnelClass()
    """
    parent_class: DataClass = ...

class DataGauss(Data):
    r"""
    :Constructors:

    ::

        DataGauss(**properties)

    Object NcmDataGauss

    Properties from NcmDataGauss:
      n-points -> guint: n-points
        Data sample size
      mean -> NcmVector: mean
        Data mean
      inv-cov -> NcmMatrix: inv-cov
        Data covariance inverse

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        inv_cov: Matrix
        mean: Vector
        n_points: int
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    parent_instance: Data = ...
    def __init__(self, inv_cov: Matrix = ...,
                 mean: Vector = ...,
                 n_points: int = ...,
                 bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    def do_get_size(self) -> int: ...
    def do_inv_cov_func(self, mset: MSet, inv_cov: Matrix) -> bool: ...
    def do_mean_func(self, mset: MSet, vp: Vector) -> None: ...
    def do_set_size(self, np: int) -> None: ...
    def get_size(self) -> int: ...
    def peek_inv_cov(self) -> Matrix: ...
    def peek_mean(self) -> Vector: ...
    def set_size(self, np: int) -> None: ...
    

class DataGaussClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataGaussClass()
    """
    parent_class: DataClass = ...
    mean_func: Callable[[DataGauss, MSet, Vector], None] = ...
    inv_cov_func: Callable[[DataGauss, MSet, Matrix], bool] = ...
    set_size: Callable[[DataGauss, int], None] = ...
    get_size: Callable[[DataGauss], int] = ...
    padding: list[None] = ...

class DataGaussCov(Data):
    r"""
    :Constructors:

    ::

        DataGaussCov(**properties)

    Object NcmDataGaussCov

    Properties from NcmDataGaussCov:
      n-points -> guint: n-points
        Data sample size
      use-norma -> gboolean: use-norma
        Use the likelihood normalization to calculate -2lnL
      mean -> NcmVector: mean
        Data mean
      cov -> NcmMatrix: cov
        Data covariance

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        cov: Matrix
        mean: Vector
        n_points: int
        use_norma: bool
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    parent_instance: Data = ...
    def __init__(self, cov: Matrix = ...,
                 mean: Vector = ...,
                 n_points: int = ...,
                 use_norma: bool = ...,
                 bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    def bulk_resample(self, mset: MSet, resample: Matrix, rng: RNG) -> None: ...
    def do_cov_func(self, mset: MSet, cov: Matrix) -> bool: ...
    def do_get_size(self) -> int: ...
    def do_lnNorma2(self, mset: MSet, m2lnL: float) -> None: ...
    def do_lnNorma2_bs(self, mset: MSet, bstrap: Bootstrap, m2lnL: float) -> None: ...
    def do_mean_func(self, mset: MSet, vp: Vector) -> None: ...
    def do_set_size(self, np: int) -> None: ...
    def get_log_norma(self, mset: MSet) -> float: ...
    def get_size(self) -> int: ...
    def peek_cov(self) -> Matrix: ...
    def peek_mean(self) -> Vector: ...
    def replace_mean(self, mean: Vector) -> None: ...
    def set_size(self, np: int) -> None: ...
    def use_norma(self, use_norma: bool) -> None: ...
    

class DataGaussCovClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataGaussCovClass()
    """
    parent_class: DataClass = ...
    mean_func: Callable[[DataGaussCov, MSet, Vector], None] = ...
    cov_func: Callable[[DataGaussCov, MSet, Matrix], bool] = ...
    lnNorma2: Callable[[DataGaussCov, MSet, float], None] = ...
    lnNorma2_bs: Callable[[DataGaussCov, MSet, Bootstrap, float], None] = ...
    set_size: Callable[[DataGaussCov, int], None] = ...
    get_size: Callable[[DataGaussCov], int] = ...
    padding: list[None] = ...

class DataGaussCovMVND(DataGaussCov):
    r"""
    :Constructors:

    ::

        DataGaussCovMVND(**properties)
        new(dim:int) -> NumCosmoMath.DataGaussCovMVND
        new_full(dim:int, sigma_min:float, sigma_max:float, cor_level:float, mean_min:float, mean_max:float, rng:NumCosmoMath.RNG) -> NumCosmoMath.DataGaussCovMVND

    Object NcmDataGaussCovMVND

    Properties from NcmDataGaussCov:
      n-points -> guint: n-points
        Data sample size
      use-norma -> gboolean: use-norma
        Use the likelihood normalization to calculate -2lnL
      mean -> NcmVector: mean
        Data mean
      cov -> NcmMatrix: cov
        Data covariance

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        cov: Matrix
        mean: Vector
        n_points: int
        use_norma: bool
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    def __init__(self, cov: Matrix = ...,
                 mean: Vector = ...,
                 n_points: int = ...,
                 use_norma: bool = ...,
                 bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    @staticmethod
    def clear(data_mvnd: DataGaussCovMVND) -> None: ...
    def est_ratio(self, mset: MSet, obj: None, bound: Callable[[None, Vector], bool], reltol: float, rng: RNG) -> Tuple[float, int, int]: ...
    def free(self) -> None: ...
    def gen(self, mset: MSet, obj: None, bound: Optional[Callable[[None, Vector], bool]], rng: RNG) -> Tuple[Vector, int]: ...
    def gen_cov_mean(self, sigma_min: float, sigma_max: float, cor_level: float, mean_min: float, mean_max: float, rng: RNG) -> None: ...
    def log_info(self) -> None: ...
    @classmethod
    def new(cls, dim: int) -> DataGaussCovMVND: ...
    @classmethod
    def new_full(cls, dim: int, sigma_min: float, sigma_max: float, cor_level: float, mean_min: float, mean_max: float, rng: RNG) -> DataGaussCovMVND: ...
    def peek_mean(self) -> Vector: ...
    def ref(self) -> DataGaussCovMVND: ...
    def set_cov_mean(self, mean: Vector, cov: Matrix) -> None: ...
    def stats_vec(self, mset: MSet, n: int, maxiter: int, lower: Vector, upper: Vector, save_realizations: bool, rng: RNG) -> StatsVec: ...
    

class DataGaussCovMVNDClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataGaussCovMVNDClass()
    """
    parent_class: DataGaussCovClass = ...

class DataGaussDiag(Data):
    r"""
    :Constructors:

    ::

        DataGaussDiag(**properties)

    Object NcmDataGaussDiag

    Properties from NcmDataGaussDiag:
      n-points -> guint: n-points
        Data sample size
      w-mean -> gboolean: w-mean
        Whether to minimize analytically over the weighted mean
      mean -> NcmVector: mean
        Data mean
      sigma -> NcmVector: sigma
        Data standard deviation

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        mean: Vector
        n_points: int
        sigma: Vector
        w_mean: bool
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    parent_instance: Data = ...
    def __init__(self, mean: Vector = ...,
                 n_points: int = ...,
                 sigma: Vector = ...,
                 w_mean: bool = ...,
                 bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    def do_get_size(self) -> int: ...
    def do_mean_func(self, mset: MSet, vp: Vector) -> None: ...
    def do_set_size(self, np: int) -> None: ...
    def do_sigma_func(self, mset: MSet, var: Vector) -> bool: ...
    def get_size(self) -> int: ...
    def peek_mean(self) -> Vector: ...
    def peek_std(self) -> Vector: ...
    def set_size(self, np: int) -> None: ...
    

class DataGaussDiagClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataGaussDiagClass()
    """
    parent_class: DataClass = ...
    mean_func: Callable[[DataGaussDiag, MSet, Vector], None] = ...
    sigma_func: Callable[[DataGaussDiag, MSet, Vector], bool] = ...
    set_size: Callable[[DataGaussDiag, int], None] = ...
    get_size: Callable[[DataGaussDiag], int] = ...

class DataGaussMix2D(Data):
    r"""
    :Constructors:

    ::

        DataGaussMix2D(**properties)
        new() -> NumCosmoMath.DataGaussMix2D

    Object NcmDataGaussMix2D

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    parent_instance: Data = ...
    priv: DataGaussMix2DPrivate = ...
    def __init__(self, bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    @staticmethod
    def clear(gm2d: DataGaussMix2D) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls) -> DataGaussMix2D: ...
    def ref(self) -> DataGaussMix2D: ...
    

class DataGaussMix2DClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataGaussMix2DClass()
    """
    parent_class: DataClass = ...

class DataGaussMix2DPrivate(GObject.GPointer): ...

class DataPoisson(Data):
    r"""
    :Constructors:

    ::

        DataPoisson(**properties)

    Object NcmDataPoisson

    Properties from NcmDataPoisson:
      n-bins -> guint: n-bins
        Number of bins
      mean -> NcmVector: mean
        Data mean

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        mean: Vector
        n_bins: int
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    parent_instance: Data = ...
    def __init__(self, mean: Vector = ...,
                 n_bins: int = ...,
                 bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    def do_get_size(self) -> int: ...
    def do_mean_func(self, mset: MSet, n: int) -> float: ...
    def do_set_size(self, nbins: int) -> None: ...
    def get_hist_means(self, mset: MSet) -> Vector: ...
    def get_hist_vals(self) -> Vector: ...
    def get_size(self) -> int: ...
    def get_sum(self) -> float: ...
    def init_from_binning(self, nodes: Vector, x: Vector) -> None: ...
    def init_from_vector(self, nodes: Vector, N: Vector) -> None: ...
    def set_size(self, nbins: int) -> None: ...
    

class DataPoissonClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataPoissonClass()
    """
    parent_class: DataClass = ...
    mean_func: Callable[[DataPoisson, MSet, int], float] = ...
    set_size: Callable[[DataPoisson, int], None] = ...
    get_size: Callable[[DataPoisson], int] = ...
    padding: list[None] = ...

class DataRosenbrock(Data):
    r"""
    :Constructors:

    ::

        DataRosenbrock(**properties)
        new() -> NumCosmoMath.DataRosenbrock

    Object NcmDataRosenbrock

    Properties from NcmData:
      name -> gchararray: name
        Data type name
      desc -> gchararray: desc
        Data description
      long-desc -> gchararray: long-desc
        Data detailed description
      init -> gboolean: init
        Data initialized state
      bootstrap -> NcmBootstrap: bootstrap
        Data bootstrap object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        bootstrap: Bootstrap
        desc: str
        init: bool
        long_desc: str
        name: str
    props: Props = ...
    def __init__(self, bootstrap: Bootstrap = ...,
                 desc: str = ...,
                 init: bool = ...,
                 long_desc: str = ...): ...
    @staticmethod
    def clear(drb: DataRosenbrock) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls) -> DataRosenbrock: ...
    def ref(self) -> DataRosenbrock: ...
    

class DataRosenbrockClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DataRosenbrockClass()
    """
    parent_class: DataClass = ...

class Dataset(GObject.Object):
    r"""
    :Constructors:

    ::

        Dataset(**properties)
        new() -> NumCosmoMath.Dataset

    Object NcmDataset

    Properties from NcmDataset:
      bootstrap-type -> NcmDatasetBStrapType: bootstrap-type
        Bootstrap type
      data-array -> NcmObjArray: data-array
        NcmData array

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        bootstrap_type: DatasetBStrapType
        data_array: ObjArray
    props: Props = ...
    def __init__(self, bootstrap_type: DatasetBStrapType = ...,
                 data_array: ObjArray = ...): ...
    def all_init(self) -> bool: ...
    def append_data(self, data: Data) -> None: ...
    def bootstrap_resample(self, rng: RNG) -> None: ...
    def bootstrap_set(self, bstype: DatasetBStrapType) -> None: ...
    @staticmethod
    def clear(dset: Dataset) -> None: ...
    def copy(self) -> Dataset: ...
    def dup(self, ser: Serialize) -> Dataset: ...
    def fisher_matrix(self, mset: MSet) -> Matrix: ...
    def free(self) -> None: ...
    def get_data(self, n: int) -> Data: ...
    def get_data_array(self) -> ObjArray: ...
    def get_dof(self) -> int: ...
    def get_info(self) -> str: ...
    def get_length(self) -> int: ...
    def get_n(self) -> int: ...
    def get_ndata(self) -> int: ...
    def has_leastsquares_J(self) -> bool: ...
    def has_leastsquares_f(self) -> bool: ...
    def has_leastsquares_f_J(self) -> bool: ...
    def has_m2lnL_grad(self) -> bool: ...
    def has_m2lnL_val(self) -> bool: ...
    def has_m2lnL_val_grad(self) -> bool: ...
    def leastsquares_J(self, mset: MSet, J: Matrix) -> None: ...
    def leastsquares_f(self, mset: MSet, f: Vector) -> None: ...
    def leastsquares_f_J(self, mset: MSet, f: Vector, J: Matrix) -> None: ...
    def log_info(self) -> None: ...
    def m2lnL_grad(self, mset: MSet, grad: Vector) -> None: ...
    def m2lnL_i_val(self, mset: MSet, i: int) -> float: ...
    def m2lnL_val(self, mset: MSet) -> float: ...
    def m2lnL_val_grad(self, mset: MSet, grad: Vector) -> float: ...
    def m2lnL_vec(self, mset: MSet, m2lnL_v: Vector) -> None: ...
    @classmethod
    def new(cls) -> Dataset: ...
    def peek_data(self, n: int) -> Data: ...
    def peek_data_array(self) -> ObjArray: ...
    def ref(self) -> Dataset: ...
    def resample(self, mset: MSet, rng: RNG) -> None: ...
    def set_data_array(self, oa: ObjArray) -> None: ...
    

class DatasetClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DatasetClass()
    """
    parent_class: GObject.ObjectClass = ...

class Diff(GObject.Object):
    r"""
    :Constructors:

    ::

        Diff(**properties)
        new() -> NumCosmoMath.Diff

    Object NcmDiff

    Properties from NcmDiff:
      max-order -> guint: max-order
        Maximum order
      richardson-step -> gdouble: richardson-step
        Richardson extrapolation step
      round-off-pad -> gdouble: round-off-pad
        Round off padding
      terr-pad -> gdouble: terr-pad
        Truncation error padding
      ini-h -> gdouble: ini-h
        Initial h

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        ini_h: float
        max_order: int
        richardson_step: float
        round_off_pad: float
        terr_pad: float
    props: Props = ...
    def __init__(self, ini_h: float = ...,
                 max_order: int = ...,
                 richardson_step: float = ...,
                 round_off_pad: float = ...,
                 terr_pad: float = ...): ...
    @staticmethod
    def clear(diff: Diff) -> None: ...
    def free(self) -> None: ...
    def get_ini_h(self) -> float: ...
    def get_max_order(self) -> int: ...
    def get_richardson_step(self) -> float: ...
    def get_round_off_pad(self) -> float: ...
    def get_trunc_error_pad(self) -> float: ...
    def log_backward_tables(self) -> None: ...
    def log_central_tables(self) -> None: ...
    def log_forward_tables(self) -> None: ...
    @classmethod
    def new(cls) -> Diff: ...
    def rc_d1_1_to_1(self, x: float, f: Callable[..., float], *user_data: Any) -> Tuple[float, float]: ...
    def rc_d1_1_to_M(self, x: float, dim: int, f: Callable[..., None], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def rc_d1_N_to_1(self, x_a: Sequence[float], f: Callable[..., float], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def rc_d1_N_to_M(self, x_a: Sequence[float], dim: int, f: Callable[..., None], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def rc_d2_1_to_1(self, x: float, f: Callable[..., float], *user_data: Any) -> Tuple[float, float]: ...
    def rc_d2_1_to_M(self, x: float, dim: int, f: Callable[..., None], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def rc_d2_N_to_1(self, x_a: Sequence[float], f: Callable[..., float], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def rc_d2_N_to_M(self, x_a: Sequence[float], dim: int, f: Callable[..., None], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def ref(self) -> Diff: ...
    def rf_Hessian_N_to_1(self, x_a: Sequence[float], f: Callable[..., float], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def rf_d1_1_to_1(self, x: float, f: Callable[..., float], *user_data: Any) -> Tuple[float, float]: ...
    def rf_d1_1_to_M(self, x: float, dim: int, f: Callable[..., None], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def rf_d1_N_to_1(self, x_a: Sequence[float], f: Callable[..., float], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def rf_d1_N_to_M(self, x_a: Sequence[float], dim: int, f: Callable[..., None], *user_data: Any) -> Tuple[list[float], list[float]]: ...
    def set_ini_h(self, ini_h: float) -> None: ...
    def set_max_order(self, maxorder: int) -> None: ...
    def set_richardson_step(self, rs: float) -> None: ...
    def set_round_off_pad(self, roff_pad: float) -> None: ...
    def set_trunc_error_pad(self, terr_pad: float) -> None: ...
    

class DiffClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        DiffClass()
    """
    parent_class: GObject.ObjectClass = ...

class Fftlog(GObject.Object):
    r"""
    :Constructors:

    ::

        Fftlog(**properties)

    Object NcmFftlog

    Properties from NcmFftlog:
      nderivs -> guint: nderivs
        Number of derivatives
      lnr0 -> gdouble: lnr0
        Center value for ln(r)
      lnk0 -> gdouble: lnk0
        Center value for ln(k)
      Lk -> gdouble: Lk
        Function log-period
      N -> guint: N
        Number of knots
      padding -> gdouble: padding
        Padding percentage
      no-ringing -> gboolean: no-ringing
        No ringing
      name -> gchararray: name
        FFTW Plan wisdown name
      use-eval-int -> gboolean: use-eval-int
        Whether to use evaluation interval
      use-smooth-padding -> gboolean: use-smooth-padding
        Whether to use a smooth padding
      smooth-padding-scale -> gdouble: smooth-padding-scale
        Log10 of the smoothing scale
      eval-r-min -> gdouble: eval-r-min
        Evaluation r_min
      eval-r-max -> gdouble: eval-r-max
        Evaluation r_max

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        Lk: float
        N: int
        eval_r_max: float
        eval_r_min: float
        lnk0: float
        lnr0: float
        name: str
        nderivs: int
        no_ringing: bool
        padding: float
        smooth_padding_scale: float
        use_eval_int: bool
        use_smooth_padding: bool
    props: Props = ...
    parent_instance: GObject.Object = ...
    def __init__(self, Lk: float = ...,
                 N: int = ...,
                 eval_r_max: float = ...,
                 eval_r_min: float = ...,
                 lnk0: float = ...,
                 lnr0: float = ...,
                 nderivs: int = ...,
                 no_ringing: bool = ...,
                 padding: float = ...,
                 smooth_padding_scale: float = ...,
                 use_eval_int: bool = ...,
                 use_smooth_padding: bool = ...): ...
    def calibrate_size(self, Fk: Callable[..., float], reltol: float, *user_data: Any) -> None: ...
    @staticmethod
    def clear(fftlog: Fftlog) -> None: ...
    def do_get_Ym(self, Ym_0: None) -> None: ...
    def eval_by_function(self, Fk: Callable[..., float], *user_data: Any) -> None: ...
    def eval_by_vector(self, Fk: Vector) -> None: ...
    def eval_output(self, nderiv: int, lnr: float) -> float: ...
    def free(self) -> None: ...
    def get_Ym(self) -> list[float]: ...
    def get_array_index(self, phys_i: int) -> int: ...
    def get_eval_r_max(self) -> float: ...
    def get_eval_r_min(self) -> float: ...
    def get_full_length(self) -> float: ...
    def get_full_size(self) -> int: ...
    def get_length(self) -> float: ...
    def get_lnk0(self) -> float: ...
    def get_lnk_vector(self, lnk: Vector) -> None: ...
    def get_lnr0(self) -> float: ...
    def get_mode_index(self, i: int) -> int: ...
    def get_nderivs(self) -> int: ...
    def get_noring(self) -> bool: ...
    def get_norma(self) -> float: ...
    def get_padding(self) -> float: ...
    def get_size(self) -> int: ...
    def get_smooth_padding_scale(self) -> float: ...
    def get_vector_Gr(self, nderiv: int) -> Vector: ...
    def get_vector_lnr(self) -> Vector: ...
    def peek_name(self) -> str: ...
    def peek_output_vector(self, nderiv: int) -> Vector: ...
    def peek_spline_Gr(self, nderiv: int) -> Spline: ...
    def prepare_splines(self) -> None: ...
    def ref(self) -> Fftlog: ...
    def reset(self) -> None: ...
    def set_eval_r_max(self, eval_r_max: float) -> None: ...
    def set_eval_r_min(self, eval_r_min: float) -> None: ...
    def set_length(self, Lk: float) -> None: ...
    def set_lnk0(self, lnk0: float) -> None: ...
    def set_lnr0(self, lnr0: float) -> None: ...
    def set_nderivs(self, nderivs: int) -> None: ...
    def set_noring(self, active: bool) -> None: ...
    def set_padding(self, pad_p: float) -> None: ...
    def set_size(self, n: int) -> None: ...
    def set_smooth_padding_scale(self, log10sc: float) -> None: ...
    def use_eval_interval(self, use_eval_interal: bool) -> None: ...
    def use_smooth_padding(self, use_smooth_padding: bool) -> None: ...
    

class FftlogClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FftlogClass()
    """
    parent_class: GObject.ObjectClass = ...
    name: str = ...
    get_Ym: Callable[[Fftlog, None], None] = ...
    padding: list[None] = ...

class FftlogGausswin2(Fftlog):
    r"""
    :Constructors:

    ::

        FftlogGausswin2(**properties)
        new(lnr0:float, lnk0:float, Lk:float, N:int) -> NumCosmoMath.FftlogGausswin2

    Object NcmFftlogGausswin2

    Properties from NcmFftlog:
      nderivs -> guint: nderivs
        Number of derivatives
      lnr0 -> gdouble: lnr0
        Center value for ln(r)
      lnk0 -> gdouble: lnk0
        Center value for ln(k)
      Lk -> gdouble: Lk
        Function log-period
      N -> guint: N
        Number of knots
      padding -> gdouble: padding
        Padding percentage
      no-ringing -> gboolean: no-ringing
        No ringing
      name -> gchararray: name
        FFTW Plan wisdown name
      use-eval-int -> gboolean: use-eval-int
        Whether to use evaluation interval
      use-smooth-padding -> gboolean: use-smooth-padding
        Whether to use a smooth padding
      smooth-padding-scale -> gdouble: smooth-padding-scale
        Log10 of the smoothing scale
      eval-r-min -> gdouble: eval-r-min
        Evaluation r_min
      eval-r-max -> gdouble: eval-r-max
        Evaluation r_max

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        Lk: float
        N: int
        eval_r_max: float
        eval_r_min: float
        lnk0: float
        lnr0: float
        name: str
        nderivs: int
        no_ringing: bool
        padding: float
        smooth_padding_scale: float
        use_eval_int: bool
        use_smooth_padding: bool
    props: Props = ...
    def __init__(self, Lk: float = ...,
                 N: int = ...,
                 eval_r_max: float = ...,
                 eval_r_min: float = ...,
                 lnk0: float = ...,
                 lnr0: float = ...,
                 nderivs: int = ...,
                 no_ringing: bool = ...,
                 padding: float = ...,
                 smooth_padding_scale: float = ...,
                 use_eval_int: bool = ...,
                 use_smooth_padding: bool = ...): ...
    @classmethod
    def new(cls, lnr0: float, lnk0: float, Lk: float, N: int) -> FftlogGausswin2: ...
    

class FftlogGausswin2Class(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FftlogGausswin2Class()
    """
    parent_class: FftlogClass = ...

class FftlogSBesselJ(Fftlog):
    r"""
    :Constructors:

    ::

        FftlogSBesselJ(**properties)
        new(ell:int, lnr0:float, lnk0:float, Lk:float, N:int) -> NumCosmoMath.FftlogSBesselJ

    Object NcmFftlogSBesselJ

    Properties from NcmFftlogSBesselJ:
      ell -> guint: ell
        Spherical Bessel integer order
      q -> gdouble: q
        Spherical Bessel power

    Properties from NcmFftlog:
      nderivs -> guint: nderivs
        Number of derivatives
      lnr0 -> gdouble: lnr0
        Center value for ln(r)
      lnk0 -> gdouble: lnk0
        Center value for ln(k)
      Lk -> gdouble: Lk
        Function log-period
      N -> guint: N
        Number of knots
      padding -> gdouble: padding
        Padding percentage
      no-ringing -> gboolean: no-ringing
        No ringing
      name -> gchararray: name
        FFTW Plan wisdown name
      use-eval-int -> gboolean: use-eval-int
        Whether to use evaluation interval
      use-smooth-padding -> gboolean: use-smooth-padding
        Whether to use a smooth padding
      smooth-padding-scale -> gdouble: smooth-padding-scale
        Log10 of the smoothing scale
      eval-r-min -> gdouble: eval-r-min
        Evaluation r_min
      eval-r-max -> gdouble: eval-r-max
        Evaluation r_max

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        ell: int
        q: float
        Lk: float
        N: int
        eval_r_max: float
        eval_r_min: float
        lnk0: float
        lnr0: float
        name: str
        nderivs: int
        no_ringing: bool
        padding: float
        smooth_padding_scale: float
        use_eval_int: bool
        use_smooth_padding: bool
    props: Props = ...
    def __init__(self, ell: int = ...,
                 q: float = ...,
                 Lk: float = ...,
                 N: int = ...,
                 eval_r_max: float = ...,
                 eval_r_min: float = ...,
                 lnk0: float = ...,
                 lnr0: float = ...,
                 nderivs: int = ...,
                 no_ringing: bool = ...,
                 padding: float = ...,
                 smooth_padding_scale: float = ...,
                 use_eval_int: bool = ...,
                 use_smooth_padding: bool = ...): ...
    def get_ell(self) -> int: ...
    def get_q(self) -> float: ...
    @classmethod
    def new(cls, ell: int, lnr0: float, lnk0: float, Lk: float, N: int) -> FftlogSBesselJ: ...
    def set_best_lnk0(self) -> None: ...
    def set_best_lnr0(self) -> None: ...
    def set_ell(self, ell: int) -> None: ...
    def set_q(self, q: float) -> None: ...
    

class FftlogSBesselJClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FftlogSBesselJClass()
    """
    parent_class: FftlogClass = ...

class FftlogSBesselJLJM(Fftlog):
    r"""
    :Constructors:

    ::

        FftlogSBesselJLJM(**properties)
        new(ell:int, dell:int, lnw:float, lnr0:float, lnk0:float, Lk:float, N:int) -> NumCosmoMath.FftlogSBesselJLJM

    Object NcmFftlogSBesselJLJM

    Properties from NcmFftlogSBesselJLJM:
      ell -> gint: ell
        Spherical Bessel integer order j_\ell j_{\ell+d\ell}
      dell -> gint: dell
        Spherical Bessel integer order difference $j_\ell j_{\ell+d\ell}$
      lnw -> gdouble: lnw
        Spherical Bessel scale difference log(w)

    Properties from NcmFftlog:
      nderivs -> guint: nderivs
        Number of derivatives
      lnr0 -> gdouble: lnr0
        Center value for ln(r)
      lnk0 -> gdouble: lnk0
        Center value for ln(k)
      Lk -> gdouble: Lk
        Function log-period
      N -> guint: N
        Number of knots
      padding -> gdouble: padding
        Padding percentage
      no-ringing -> gboolean: no-ringing
        No ringing
      name -> gchararray: name
        FFTW Plan wisdown name
      use-eval-int -> gboolean: use-eval-int
        Whether to use evaluation interval
      use-smooth-padding -> gboolean: use-smooth-padding
        Whether to use a smooth padding
      smooth-padding-scale -> gdouble: smooth-padding-scale
        Log10 of the smoothing scale
      eval-r-min -> gdouble: eval-r-min
        Evaluation r_min
      eval-r-max -> gdouble: eval-r-max
        Evaluation r_max

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        dell: int
        ell: int
        lnw: float
        Lk: float
        N: int
        eval_r_max: float
        eval_r_min: float
        lnk0: float
        lnr0: float
        name: str
        nderivs: int
        no_ringing: bool
        padding: float
        smooth_padding_scale: float
        use_eval_int: bool
        use_smooth_padding: bool
    props: Props = ...
    def __init__(self, dell: int = ...,
                 ell: int = ...,
                 lnw: float = ...,
                 Lk: float = ...,
                 N: int = ...,
                 eval_r_max: float = ...,
                 eval_r_min: float = ...,
                 lnk0: float = ...,
                 lnr0: float = ...,
                 nderivs: int = ...,
                 no_ringing: bool = ...,
                 padding: float = ...,
                 smooth_padding_scale: float = ...,
                 use_eval_int: bool = ...,
                 use_smooth_padding: bool = ...): ...
    def get_dell(self) -> int: ...
    def get_ell(self) -> int: ...
    def get_lnw(self) -> float: ...
    @classmethod
    def new(cls, ell: int, dell: int, lnw: float, lnr0: float, lnk0: float, Lk: float, N: int) -> FftlogSBesselJLJM: ...
    def set_best_lnk0(self) -> None: ...
    def set_best_lnr0(self) -> None: ...
    def set_dell(self, dell: int) -> None: ...
    def set_ell(self, ell: int) -> None: ...
    def set_lnw(self, lnw: float) -> None: ...
    

class FftlogSBesselJLJMClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FftlogSBesselJLJMClass()
    """
    parent_class: FftlogClass = ...

class FftlogTophatwin2(Fftlog):
    r"""
    :Constructors:

    ::

        FftlogTophatwin2(**properties)
        new(lnr0:float, lnk0:float, Lk:float, N:int) -> NumCosmoMath.FftlogTophatwin2

    Object NcmFftlogTophatwin2

    Properties from NcmFftlog:
      nderivs -> guint: nderivs
        Number of derivatives
      lnr0 -> gdouble: lnr0
        Center value for ln(r)
      lnk0 -> gdouble: lnk0
        Center value for ln(k)
      Lk -> gdouble: Lk
        Function log-period
      N -> guint: N
        Number of knots
      padding -> gdouble: padding
        Padding percentage
      no-ringing -> gboolean: no-ringing
        No ringing
      name -> gchararray: name
        FFTW Plan wisdown name
      use-eval-int -> gboolean: use-eval-int
        Whether to use evaluation interval
      use-smooth-padding -> gboolean: use-smooth-padding
        Whether to use a smooth padding
      smooth-padding-scale -> gdouble: smooth-padding-scale
        Log10 of the smoothing scale
      eval-r-min -> gdouble: eval-r-min
        Evaluation r_min
      eval-r-max -> gdouble: eval-r-max
        Evaluation r_max

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        Lk: float
        N: int
        eval_r_max: float
        eval_r_min: float
        lnk0: float
        lnr0: float
        name: str
        nderivs: int
        no_ringing: bool
        padding: float
        smooth_padding_scale: float
        use_eval_int: bool
        use_smooth_padding: bool
    props: Props = ...
    def __init__(self, Lk: float = ...,
                 N: int = ...,
                 eval_r_max: float = ...,
                 eval_r_min: float = ...,
                 lnk0: float = ...,
                 lnr0: float = ...,
                 nderivs: int = ...,
                 no_ringing: bool = ...,
                 padding: float = ...,
                 smooth_padding_scale: float = ...,
                 use_eval_int: bool = ...,
                 use_smooth_padding: bool = ...): ...
    @classmethod
    def new(cls, lnr0: float, lnk0: float, Lk: float, N: int) -> FftlogTophatwin2: ...
    

class FftlogTophatwin2Class(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FftlogTophatwin2Class()
    """
    parent_class: FftlogClass = ...

class Fit(GObject.Object):
    r"""
    :Constructors:

    ::

        Fit(**properties)
        new(ftype:NumCosmoMath.FitType, algo_name:str, lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType) -> NumCosmoMath.Fit

    Object NcmFit

    Properties from NcmFit:
      likelihood -> NcmLikelihood: likelihood
        Likelihood object
      mset -> NcmMSet: mset
        Model set object
      state -> NcmFitState: state
        Fit state object
      grad-type -> NcmFitGradType: grad-type
        Differentiation method
      maxiter -> guint: maxiter
        Maximum number of interations
      m2lnL-reltol -> gdouble: m2lnL-reltol
        Relative tolarence in m2lnL
      m2lnL-abstol -> gdouble: m2lnL-abstol
        Absolute tolarence in m2lnL
      params-reltol -> gdouble: params-reltol
        Relative tolarence in fitted parameters
      equality-constraints -> NcmObjArray: equality-constraints
        Equality constraints array
      equality-constraints-tot -> NcmVector: equality-constraints-tot
        Equality constraints tolerance
      inequality-constraints -> NcmObjArray: inequality-constraints
        Inequality constraints array
      inequality-constraints-tot -> NcmVector: inequality-constraints-tot
        Inequality constraints tolerance
      sub-fit -> NcmFit: sub-fit
        Subsidiary fit

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        equality_constraints: ObjArray
        equality_constraints_tot: Vector
        grad_type: FitGradType
        inequality_constraints: ObjArray
        inequality_constraints_tot: Vector
        likelihood: Likelihood
        m2lnL_abstol: float
        m2lnL_reltol: float
        maxiter: int
        mset: MSet
        params_reltol: float
        state: FitState
        sub_fit: Fit
    props: Props = ...
    parent_instance: GObject.Object = ...
    lh: Likelihood = ...
    mset: MSet = ...
    fstate: FitState = ...
    mtype: FitRunMsgs = ...
    grad: FitGrad = ...
    maxiter: int = ...
    m2lnL_reltol: float = ...
    m2lnL_abstol: float = ...
    params_reltol: float = ...
    timer: GLib.Timer = ...
    equality_constraints: ObjArray = ...
    equality_constraints_tot: list[None] = ...
    inequality_constraints: ObjArray = ...
    inequality_constraints_tot: list[None] = ...
    sub_fit: Fit = ...
    diff: Diff = ...
    def __init__(self, equality_constraints: ObjArray = ...,
                 equality_constraints_tot: Vector = ...,
                 grad_type: FitGradType = ...,
                 inequality_constraints: ObjArray = ...,
                 inequality_constraints_tot: Vector = ...,
                 likelihood: Likelihood = ...,
                 m2lnL_abstol: float = ...,
                 m2lnL_reltol: float = ...,
                 maxiter: int = ...,
                 mset: MSet = ...,
                 params_reltol: float = ...,
                 state: FitState = ...,
                 sub_fit: Fit = ...): ...
    def add_equality_constraint(self, func: MSetFunc, tot: float) -> None: ...
    def add_inequality_constraint(self, func: MSetFunc, tot: float) -> None: ...
    def chisq_test(self, bins: int) -> float: ...
    @staticmethod
    def clear(fit: Fit) -> None: ...
    def copy_new(self, lh: Likelihood, mset: MSet, gtype: FitGradType) -> Fit: ...
    def covar_cor(self, mid1: int, pid1: int, mid2: int, pid2: int) -> float: ...
    def covar_cov(self, mid1: int, pid1: int, mid2: int, pid2: int) -> float: ...
    def covar_fparam_cor(self, fpi1: int, fpi2: int) -> float: ...
    def covar_fparam_cov(self, fpi1: int, fpi2: int) -> float: ...
    def covar_fparam_sd(self, fpi: int) -> float: ...
    def covar_fparam_var(self, fpi: int) -> float: ...
    def covar_sd(self, mid: int, pid: int) -> float: ...
    def covar_var(self, mid: int, pid: int) -> float: ...
    def data_m2lnL_val(self) -> float: ...
    def do_copy_new(self, lh: Likelihood, mset: MSet, gtype: FitGradType) -> Fit: ...
    def do_get_desc(self) -> str: ...
    def do_reset(self) -> None: ...
    def do_run(self, mtype: FitRunMsgs) -> bool: ...
    def dprob(self, mid: int, pid: int, a: float, b: float, step: float, norm: float) -> None: ...
    def dup(self, ser: Serialize) -> Fit: ...
    def fisher(self) -> None: ...
    def fisher_to_covar(self, fisher: Matrix) -> None: ...
    def fishermatrix_print(self, out: int, header: str) -> None: ...
    def free(self) -> None: ...
    def function_cov(self, func1: MSetFunc, z1: float, func2: MSetFunc, z2: float, pretty_print: bool) -> float: ...
    def function_error(self, func: MSetFunc, x: float, pretty_print: bool) -> Tuple[float, float]: ...
    def get_covar(self) -> Matrix: ...
    def get_desc(self) -> str: ...
    def get_m2lnL_abstol(self) -> float: ...
    def get_m2lnL_reltol(self) -> float: ...
    def get_maxiter(self) -> int: ...
    def get_params_reltol(self) -> float: ...
    def get_sub_fit(self) -> Fit: ...
    def has_equality_constraints(self) -> int: ...
    def has_inequality_constraints(self) -> int: ...
    def is_least_squares(self) -> bool: ...
    def log_covar(self) -> None: ...
    def log_end(self) -> None: ...
    def log_info(self) -> None: ...
    def log_start(self) -> None: ...
    def log_state(self) -> None: ...
    def log_step(self) -> None: ...
    def lr_test(self, mid: int, pid: int, val: float, dof: int) -> float: ...
    def lr_test_range(self, mid: int, pid: int, start: float, stop: float, step: float) -> None: ...
    def ls_J(self, J: Matrix) -> None: ...
    def ls_J_an(self, J: Matrix) -> None: ...
    def ls_J_nd_ac(self, J: Matrix) -> None: ...
    def ls_J_nd_ce(self, J: Matrix) -> None: ...
    def ls_J_nd_fo(self, J: Matrix) -> None: ...
    def ls_covar(self) -> None: ...
    def ls_f(self, f: Vector) -> None: ...
    def ls_f_J(self, f: Vector, J: Matrix) -> None: ...
    def ls_f_J_an(self, f: Vector, J: Matrix) -> None: ...
    def ls_f_J_nd_ac(self, f: Vector, J: Matrix) -> None: ...
    def ls_f_J_nd_ce(self, f: Vector, J: Matrix) -> None: ...
    def ls_f_J_nd_fo(self, f: Vector, J: Matrix) -> None: ...
    def m2lnL_grad(self, df: Vector) -> None: ...
    def m2lnL_grad_an(self, df: Vector) -> None: ...
    def m2lnL_grad_nd_ac(self, grad: Vector) -> None: ...
    def m2lnL_grad_nd_ce(self, grad: Vector) -> None: ...
    def m2lnL_grad_nd_fo(self, grad: Vector) -> None: ...
    def m2lnL_hessian_nd_ce(self, hessian: Matrix) -> None: ...
    def m2lnL_val(self) -> float: ...
    def m2lnL_val_grad(self, df: Vector) -> float: ...
    def m2lnL_val_grad_an(self, df: Vector) -> float: ...
    def m2lnL_val_grad_nd_ac(self, grad: Vector) -> float: ...
    def m2lnL_val_grad_nd_ce(self, m2lnL: float, grad: Vector) -> None: ...
    def m2lnL_val_grad_nd_fo(self, grad: Vector) -> float: ...
    @classmethod
    def new(cls, ftype: FitType, algo_name: str, lh: Likelihood, mset: MSet, gtype: FitGradType) -> Fit: ...
    def numdiff_m2lnL_covar(self) -> None: ...
    def numdiff_m2lnL_hessian(self, H: Matrix, reltol: float) -> None: ...
    def numdiff_m2lnL_lndet_covar(self) -> float: ...
    def obs_fisher(self) -> None: ...
    def params_set(self, i: int, x: float) -> None: ...
    def params_set_array(self, x: Sequence[float]) -> None: ...
    def params_set_vector(self, x: Vector) -> None: ...
    def params_set_vector_offset(self, x: Vector, offset: int) -> None: ...
    def params_update(self) -> None: ...
    def peek_mset(self) -> MSet: ...
    def priors_m2lnL_val(self) -> float: ...
    def prob(self, mid: int, pid: int, a: float, b: float) -> float: ...
    def ref(self) -> Fit: ...
    def remove_equality_constraints(self) -> None: ...
    def remove_inequality_constraints(self) -> None: ...
    def reset(self) -> None: ...
    def residual_ks_test(self, o_mean: float, o_sd: float, o_skew: float, o_kurtosis: float, o_max: float) -> float: ...
    def run(self, mtype: FitRunMsgs) -> bool: ...
    def run_restart(self, mtype: FitRunMsgs, abstol: float, reltol: float, save_mset: Optional[MSet] = None, mset_file: Optional[str] = None) -> None: ...
    def set_grad_type(self, gtype: FitGradType) -> None: ...
    def set_m2lnL_abstol(self, tol: float) -> None: ...
    def set_m2lnL_reltol(self, tol: float) -> None: ...
    def set_maxiter(self, maxiter: int) -> None: ...
    def set_params_reltol(self, tol: float) -> None: ...
    def set_sub_fit(self, sub_fit: Fit) -> None: ...
    def type_constrain_error(self, p: float, nu: int, dir: float, func: MSetFunc, z: float, walk: bool) -> float: ...
    

class FitClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitClass()
    """
    parent_class: GObject.ObjectClass = ...
    copy_new: Callable[[Fit, Likelihood, MSet, FitGradType], Fit] = ...
    reset: Callable[[Fit], None] = ...
    run: Callable[[Fit, FitRunMsgs], bool] = ...
    get_desc: Callable[[Fit], str] = ...
    is_least_squares: bool = ...

class FitESMCMC(GObject.Object):
    r"""
    :Constructors:

    ::

        FitESMCMC(**properties)
        new(fit:NumCosmoMath.Fit, nwalkers:int, sampler:NumCosmoMath.MSetTransKern, walker:NumCosmoMath.FitESMCMCWalker=None, mtype:NumCosmoMath.FitRunMsgs) -> NumCosmoMath.FitESMCMC
        new_funcs_array(fit:NumCosmoMath.Fit, nwalkers:int, sampler:NumCosmoMath.MSetTransKern, walker:NumCosmoMath.FitESMCMCWalker=None, mtype:NumCosmoMath.FitRunMsgs, funcs_array:NumCosmoMath.ObjArray) -> NumCosmoMath.FitESMCMC

    Object NcmFitESMCMC

    Properties from NcmFitESMCMC:
      fit -> NcmFit: fit
        Fit object
      nwalkers -> gint: nwalkers
        Number of walkers
      sampler -> NcmMSetTransKern: sampler
        Initial points sampler
      walker -> NcmFitESMCMCWalker: walker
        Walker object
      lre-step -> gdouble: lre-step
        Step size in the lre run
      auto-trim -> gboolean: auto-trim
        Whether to automatically trim the catalog
      auto-trim-div -> guint: auto-trim-div
        Automatically trim divisor
      trim-type -> NcmMSetCatalogTrimType: trim-type
        Trimming tests to apply
      min-runs -> guint: min-runs
        Minumum number of runs
      max-runs-time -> gdouble: max-runs-time
        Maximum time between runs
      log-time-interval -> gdouble: log-time-interval
        Time interval between log
      intermediary-log -> guint: intermediary-log
        Number of intermediary logs
      mtype -> NcmFitRunMsgs: mtype
        Run messages type
      nthreads -> guint: nthreads
        Number of threads to run
      use-mpi -> gboolean: use-mpi
        Use MPI instead of threads
      data-file -> gchararray: data-file
        Data filename
      function-array -> NcmObjArray: function-array
        Functions array

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        auto_trim: bool
        auto_trim_div: int
        data_file: str
        fit: Fit
        function_array: ObjArray
        intermediary_log: int
        log_time_interval: float
        lre_step: float
        max_runs_time: float
        min_runs: int
        mtype: FitRunMsgs
        nthreads: int
        nwalkers: int
        sampler: MSetTransKern
        trim_type: MSetCatalogTrimType
        use_mpi: bool
        walker: FitESMCMCWalker
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: FitESMCMCPrivate = ...
    def __init__(self, auto_trim: bool = ...,
                 auto_trim_div: int = ...,
                 data_file: str = ...,
                 fit: Fit = ...,
                 function_array: ObjArray = ...,
                 intermediary_log: int = ...,
                 log_time_interval: float = ...,
                 lre_step: float = ...,
                 max_runs_time: float = ...,
                 min_runs: int = ...,
                 mtype: FitRunMsgs = ...,
                 nthreads: int = ...,
                 nwalkers: int = ...,
                 sampler: MSetTransKern = ...,
                 trim_type: MSetCatalogTrimType = ...,
                 use_mpi: bool = ...,
                 walker: FitESMCMCWalker = ...): ...
    @staticmethod
    def clear(esmcmc: FitESMCMC) -> None: ...
    def end_run(self) -> None: ...
    def free(self) -> None: ...
    def get_accept_ratio(self) -> float: ...
    def get_accept_ratio_last_update(self) -> float: ...
    def get_catalog(self) -> MSetCatalog: ...
    def get_offboard_ratio(self) -> float: ...
    def get_offboard_ratio_last_update(self) -> float: ...
    def has_rng(self) -> bool: ...
    def mean_covar(self) -> None: ...
    @classmethod
    def new(cls, fit: Fit, nwalkers: int, sampler: MSetTransKern, walker: Optional[FitESMCMCWalker], mtype: FitRunMsgs) -> FitESMCMC: ...
    @classmethod
    def new_funcs_array(cls, fit: Fit, nwalkers: int, sampler: MSetTransKern, walker: Optional[FitESMCMCWalker], mtype: FitRunMsgs, funcs_array: ObjArray) -> FitESMCMC: ...
    def peek_catalog(self) -> MSetCatalog: ...
    def peek_fit(self) -> Fit: ...
    def peek_ser(self) -> Serialize: ...
    def peek_walker(self) -> FitESMCMCWalker: ...
    def ref(self) -> FitESMCMC: ...
    def reset(self) -> None: ...
    def run(self, n: int) -> None: ...
    def run_burnin(self, prerun: int, ntimes: int) -> None: ...
    def run_lre(self, prerun: int, lre: float) -> None: ...
    def set_auto_trim(self, enable: bool) -> None: ...
    def set_auto_trim_div(self, div: int) -> None: ...
    def set_auto_trim_type(self, ttype: MSetCatalogTrimType) -> None: ...
    def set_data_file(self, filename: str) -> None: ...
    def set_max_runs_time(self, max_runs_time: float) -> None: ...
    def set_min_runs(self, min_runs: int) -> None: ...
    def set_mtype(self, mtype: FitRunMsgs) -> None: ...
    def set_nthreads(self, nthreads: int) -> None: ...
    def set_rng(self, rng: RNG) -> None: ...
    def set_sampler(self, sampler: MSetTransKern) -> None: ...
    def start_run(self) -> None: ...
    def use_mpi(self, use_mpi: bool) -> None: ...
    def validate(self, pi: int, pf: int) -> bool: ...
    

class FitESMCMCClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitESMCMCClass()
    """
    parent_class: GObject.ObjectClass = ...

class FitESMCMCPrivate(GObject.GPointer): ...

class FitESMCMCWalker(GObject.Object):
    r"""
    :Constructors:

    ::

        FitESMCMCWalker(**properties)
        new_from_name(walker_name:str) -> NumCosmoMath.FitESMCMCWalker

    Object NcmFitESMCMCWalker

    Properties from NcmFitESMCMCWalker:
      size -> guint: size
        Number of walkers
      nparams -> guint: nparams
        Number of parameters

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        nparams: int
        size: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    def __init__(self, nparams: int = ...,
                 size: int = ...): ...
    def clean(self, ki: int, kf: int) -> None: ...
    @staticmethod
    def clear(walker: FitESMCMCWalker) -> None: ...
    def desc(self) -> str: ...
    def do_clean(self, ki: int, kf: int) -> None: ...
    def do_desc(self) -> str: ...
    def do_get_nparams(self) -> int: ...
    def do_get_size(self) -> int: ...
    def do_prob(self, theta: Sequence[Vector], m2lnL: Sequence[Vector], thetastar: Vector, k: int, m2lnL_cur: float, m2lnL_star: float) -> float: ...
    def do_prob_norm(self, theta: Sequence[Vector], m2lnL: Sequence[Vector], thetastar: Vector, k: int) -> float: ...
    def do_set_nparams(self, nparams: int) -> None: ...
    def do_set_size(self, size: int) -> None: ...
    def do_setup(self, mset: MSet, theta: Sequence[Vector], m2lnL: Sequence[Vector], ki: int, kf: int, rng: RNG) -> None: ...
    def do_step(self, theta: Sequence[Vector], m2lnL: Sequence[Vector], thetastar: Vector, k: int) -> None: ...
    def free(self) -> None: ...
    def get_nparams(self) -> int: ...
    def get_size(self) -> int: ...
    @classmethod
    def new_from_name(cls, walker_name: str) -> FitESMCMCWalker: ...
    def prob(self, theta: Sequence[Vector], m2lnL: Sequence[Vector], thetastar: Vector, k: int, m2lnL_cur: float, m2lnL_star: float) -> float: ...
    def prob_norm(self, theta: Sequence[Vector], m2lnL: Sequence[Vector], thetastar: Vector, k: int) -> float: ...
    def ref(self) -> FitESMCMCWalker: ...
    def set_nparams(self, nparams: int) -> None: ...
    def set_size(self, size: int) -> None: ...
    def setup(self, mset: MSet, theta: Sequence[Vector], m2lnL: Sequence[Vector], ki: int, kf: int, rng: RNG) -> None: ...
    def step(self, theta: Sequence[Vector], m2lnL: Sequence[Vector], thetastar: Vector, k: int) -> None: ...
    

class FitESMCMCWalkerAPES(FitESMCMCWalker):
    r"""
    :Constructors:

    ::

        FitESMCMCWalkerAPES(**properties)
        new(nwalkers:int, nparams:int) -> NumCosmoMath.FitESMCMCWalkerAPES
        new_full(nwalkers:int, nparams:int, method:NumCosmoMath.FitESMCMCWalkerAPESMethod, k_type:NumCosmoMath.FitESMCMCWalkerAPESKType, over_smooth:float, use_interp:bool) -> NumCosmoMath.FitESMCMCWalkerAPES

    Object NcmFitESMCMCWalkerAPES

    Properties from NcmFitESMCMCWalkerAPES:
      method -> NcmFitESMCMCWalkerAPESMethod: method
        Method used in posterior approximation
      kernel-type -> NcmFitESMCMCWalkerAPESKType: kernel-type
        Kernel used in posterior approximation
      over-smooth -> gdouble: over-smooth
        Over-smooth parameter used to adjust kernel bandwidth
      use-interp -> gboolean: use-interp
        Whether to use interpolation to build the posterior approximation
      use-threads -> gboolean: use-threads
        Whether to use threads when building the posterior approximation

    Properties from NcmFitESMCMCWalker:
      size -> guint: size
        Number of walkers
      nparams -> guint: nparams
        Number of parameters

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        kernel_type: FitESMCMCWalkerAPESKType
        method: FitESMCMCWalkerAPESMethod
        over_smooth: float
        use_interp: bool
        use_threads: bool
        nparams: int
        size: int
    props: Props = ...
    parent_instance: FitESMCMCWalker = ...
    priv: FitESMCMCWalkerAPESPrivate = ...
    def __init__(self, kernel_type: FitESMCMCWalkerAPESKType = ...,
                 method: FitESMCMCWalkerAPESMethod = ...,
                 over_smooth: float = ...,
                 use_interp: bool = ...,
                 use_threads: bool = ...,
                 nparams: int = ...,
                 size: int = ...): ...
    @staticmethod
    def clear(apes: FitESMCMCWalkerAPES) -> None: ...
    def free(self) -> None: ...
    def get_k_type(self) -> FitESMCMCWalkerAPESKType: ...
    def get_method(self) -> FitESMCMCWalkerAPESMethod: ...
    def get_over_smooth(self) -> float: ...
    def get_use_threads(self) -> bool: ...
    def interp(self) -> bool: ...
    @classmethod
    def new(cls, nwalkers: int, nparams: int) -> FitESMCMCWalkerAPES: ...
    @classmethod
    def new_full(cls, nwalkers: int, nparams: int, method: FitESMCMCWalkerAPESMethod, k_type: FitESMCMCWalkerAPESKType, over_smooth: float, use_interp: bool) -> FitESMCMCWalkerAPES: ...
    def peek_sds(self) -> Tuple[StatsDist, StatsDist]: ...
    def ref(self) -> FitESMCMCWalkerAPES: ...
    def set_cov_fixed_from_mset(self, mset: MSet) -> None: ...
    def set_cov_robust(self) -> None: ...
    def set_cov_robust_diag(self) -> None: ...
    def set_k_type(self, k_type: FitESMCMCWalkerAPESKType) -> None: ...
    def set_local_frac(self, local_frac: float) -> None: ...
    def set_method(self, method: FitESMCMCWalkerAPESMethod) -> None: ...
    def set_over_smooth(self, os: float) -> None: ...
    def set_use_threads(self, use_threads: bool) -> None: ...
    def use_interp(self, use_interp: bool) -> None: ...
    

class FitESMCMCWalkerAPESClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitESMCMCWalkerAPESClass()
    """
    parent_class: FitESMCMCWalkerClass = ...

class FitESMCMCWalkerAPESPrivate(GObject.GPointer): ...

class FitESMCMCWalkerClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitESMCMCWalkerClass()
    """
    parent_class: GObject.ObjectClass = ...
    set_size: Callable[[FitESMCMCWalker, int], None] = ...
    get_size: Callable[[FitESMCMCWalker], int] = ...
    set_nparams: Callable[[FitESMCMCWalker, int], None] = ...
    get_nparams: Callable[[FitESMCMCWalker], int] = ...
    setup: Callable[[FitESMCMCWalker, MSet, Sequence[Vector], Sequence[Vector], int, int, RNG], None] = ...
    step: Callable[[FitESMCMCWalker, Sequence[Vector], Sequence[Vector], Vector, int], None] = ...
    prob: Callable[[FitESMCMCWalker, Sequence[Vector], Sequence[Vector], Vector, int, float, float], float] = ...
    prob_norm: Callable[[FitESMCMCWalker, Sequence[Vector], Sequence[Vector], Vector, int], float] = ...
    clean: Callable[[FitESMCMCWalker, int, int], None] = ...
    desc: Callable[[FitESMCMCWalker], str] = ...

class FitESMCMCWalkerStretch(FitESMCMCWalker):
    r"""
    :Constructors:

    ::

        FitESMCMCWalkerStretch(**properties)
        new(nwalkers:int, nparams:int) -> NumCosmoMath.FitESMCMCWalkerStretch

    Object NcmFitESMCMCWalkerStretch

    Properties from NcmFitESMCMCWalkerStretch:
      scale -> gdouble: scale
        Stretch scale a
      multi-stretch -> gboolean: multi-stretch
        Whether it should use multiple stretchs per step

    Properties from NcmFitESMCMCWalker:
      size -> guint: size
        Number of walkers
      nparams -> guint: nparams
        Number of parameters

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        multi_stretch: bool
        scale: float
        nparams: int
        size: int
    props: Props = ...
    parent_instance: FitESMCMCWalker = ...
    size: int = ...
    size_2: int = ...
    nparams: int = ...
    a: float = ...
    z: Matrix = ...
    box: Matrix = ...
    norm_box: Vector = ...
    use_box: list[None] = ...
    indices: list[None] = ...
    numbers: list[None] = ...
    multi: bool = ...
    desc: str = ...
    def __init__(self, multi_stretch: bool = ...,
                 scale: float = ...,
                 nparams: int = ...,
                 size: int = ...): ...
    def get_scale(self) -> float: ...
    @classmethod
    def new(cls, nwalkers: int, nparams: int) -> FitESMCMCWalkerStretch: ...
    def set_box(self, n: int, lb: float, ub: float) -> None: ...
    def set_box_mset(self, mset: MSet) -> None: ...
    def set_scale(self, a: float) -> None: ...
    

class FitESMCMCWalkerStretchClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitESMCMCWalkerStretchClass()
    """
    parent_class: FitESMCMCWalkerClass = ...

class FitESMCMCWalkerWalk(FitESMCMCWalker):
    r"""
    :Constructors:

    ::

        FitESMCMCWalkerWalk(**properties)
        new(nwalkers:int) -> NumCosmoMath.FitESMCMCWalkerWalk

    Object NcmFitESMCMCWalkerWalk

    Properties from NcmFitESMCMCWalkerWalk:
      scale -> gdouble: scale
        Walk scale a

    Properties from NcmFitESMCMCWalker:
      size -> guint: size
        Number of walkers
      nparams -> guint: nparams
        Number of parameters

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        scale: float
        nparams: int
        size: int
    props: Props = ...
    parent_instance: FitESMCMCWalker = ...
    size: int = ...
    size_2: int = ...
    nparams: int = ...
    a: float = ...
    sqrt_nparams: float = ...
    z: Matrix = ...
    thetabar: list[None] = ...
    indices: list[None] = ...
    numbers: list[None] = ...
    def __init__(self, scale: float = ...,
                 nparams: int = ...,
                 size: int = ...): ...
    def get_scale(self) -> float: ...
    @classmethod
    def new(cls, nwalkers: int) -> FitESMCMCWalkerWalk: ...
    def set_scale(self, a: float) -> None: ...
    

class FitESMCMCWalkerWalkClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitESMCMCWalkerWalkClass()
    """
    parent_class: FitESMCMCWalkerClass = ...

class FitGSLLS(Fit):
    r"""
    :Constructors:

    ::

        FitGSLLS(**properties)
        new(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType) -> NumCosmoMath.Fit

    Object NcmFitGSLLS

    Properties from NcmFit:
      likelihood -> NcmLikelihood: likelihood
        Likelihood object
      mset -> NcmMSet: mset
        Model set object
      state -> NcmFitState: state
        Fit state object
      grad-type -> NcmFitGradType: grad-type
        Differentiation method
      maxiter -> guint: maxiter
        Maximum number of interations
      m2lnL-reltol -> gdouble: m2lnL-reltol
        Relative tolarence in m2lnL
      m2lnL-abstol -> gdouble: m2lnL-abstol
        Absolute tolarence in m2lnL
      params-reltol -> gdouble: params-reltol
        Relative tolarence in fitted parameters
      equality-constraints -> NcmObjArray: equality-constraints
        Equality constraints array
      equality-constraints-tot -> NcmVector: equality-constraints-tot
        Equality constraints tolerance
      inequality-constraints -> NcmObjArray: inequality-constraints
        Inequality constraints array
      inequality-constraints-tot -> NcmVector: inequality-constraints-tot
        Inequality constraints tolerance
      sub-fit -> NcmFit: sub-fit
        Subsidiary fit

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        equality_constraints: ObjArray
        equality_constraints_tot: Vector
        grad_type: FitGradType
        inequality_constraints: ObjArray
        inequality_constraints_tot: Vector
        likelihood: Likelihood
        m2lnL_abstol: float
        m2lnL_reltol: float
        maxiter: int
        mset: MSet
        params_reltol: float
        state: FitState
        sub_fit: Fit
    props: Props = ...
    parent_instance: Fit = ...
    ls: int = ...
    f: int = ...
    T: int = ...
    def __init__(self, equality_constraints: ObjArray = ...,
                 equality_constraints_tot: Vector = ...,
                 grad_type: FitGradType = ...,
                 inequality_constraints: ObjArray = ...,
                 inequality_constraints_tot: Vector = ...,
                 likelihood: Likelihood = ...,
                 m2lnL_abstol: float = ...,
                 m2lnL_reltol: float = ...,
                 maxiter: int = ...,
                 mset: MSet = ...,
                 params_reltol: float = ...,
                 state: FitState = ...,
                 sub_fit: Fit = ...): ...
    @classmethod
    def new(cls, lh: Likelihood, mset: MSet, gtype: FitGradType) -> FitGSLLS: ...
    

class FitGSLLSClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitGSLLSClass()
    """
    parent_class: FitClass = ...

class FitGSLMM(Fit):
    r"""
    :Constructors:

    ::

        FitGSLMM(**properties)
        new(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType, algo:NumCosmoMath.FitGSLMMAlgos) -> NumCosmoMath.Fit
        new_by_name(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType, algo_name:str) -> NumCosmoMath.Fit
        new_default(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType) -> NumCosmoMath.Fit

    Object NcmFitGSLMM

    Properties from NcmFitGSLMM:
      algorithm -> NcmFitGSLMMAlgos: algorithm
        GSL multidimensional minimization algorithm

    Properties from NcmFit:
      likelihood -> NcmLikelihood: likelihood
        Likelihood object
      mset -> NcmMSet: mset
        Model set object
      state -> NcmFitState: state
        Fit state object
      grad-type -> NcmFitGradType: grad-type
        Differentiation method
      maxiter -> guint: maxiter
        Maximum number of interations
      m2lnL-reltol -> gdouble: m2lnL-reltol
        Relative tolarence in m2lnL
      m2lnL-abstol -> gdouble: m2lnL-abstol
        Absolute tolarence in m2lnL
      params-reltol -> gdouble: params-reltol
        Relative tolarence in fitted parameters
      equality-constraints -> NcmObjArray: equality-constraints
        Equality constraints array
      equality-constraints-tot -> NcmVector: equality-constraints-tot
        Equality constraints tolerance
      inequality-constraints -> NcmObjArray: inequality-constraints
        Inequality constraints array
      inequality-constraints-tot -> NcmVector: inequality-constraints-tot
        Inequality constraints tolerance
      sub-fit -> NcmFit: sub-fit
        Subsidiary fit

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        algorithm: FitGSLMMAlgos
        equality_constraints: ObjArray
        equality_constraints_tot: Vector
        grad_type: FitGradType
        inequality_constraints: ObjArray
        inequality_constraints_tot: Vector
        likelihood: Likelihood
        m2lnL_abstol: float
        m2lnL_reltol: float
        maxiter: int
        mset: MSet
        params_reltol: float
        state: FitState
        sub_fit: Fit
    props: Props = ...
    parent_instance: Fit = ...
    mm: int = ...
    f: int = ...
    algo: FitGSLMMAlgos = ...
    desc: str = ...
    err_a: float = ...
    err_b: float = ...
    def __init__(self, algorithm: FitGSLMMAlgos = ...,
                 equality_constraints: ObjArray = ...,
                 equality_constraints_tot: Vector = ...,
                 grad_type: FitGradType = ...,
                 inequality_constraints: ObjArray = ...,
                 inequality_constraints_tot: Vector = ...,
                 likelihood: Likelihood = ...,
                 m2lnL_abstol: float = ...,
                 m2lnL_reltol: float = ...,
                 maxiter: int = ...,
                 mset: MSet = ...,
                 params_reltol: float = ...,
                 state: FitState = ...,
                 sub_fit: Fit = ...): ...
    @classmethod
    def new(cls, lh: Likelihood, mset: MSet, gtype: FitGradType, algo: FitGSLMMAlgos) -> FitGSLMM: ...
    @classmethod
    def new_by_name(cls, lh: Likelihood, mset: MSet, gtype: FitGradType, algo_name: str) -> FitGSLMM: ...
    @classmethod
    def new_default(cls, lh: Likelihood, mset: MSet, gtype: FitGradType) -> FitGSLMM: ...
    def set_algo(self, algo: FitGSLMMAlgos) -> None: ...
    

class FitGSLMMClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitGSLMMClass()
    """
    parent_class: FitClass = ...

class FitGSLMMS(Fit):
    r"""
    :Constructors:

    ::

        FitGSLMMS(**properties)
        new(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType, algo:NumCosmoMath.FitGSLMMSAlgos) -> NumCosmoMath.Fit
        new_by_name(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType, algo_name:str) -> NumCosmoMath.Fit
        new_default(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType) -> NumCosmoMath.Fit

    Object NcmFitGSLMMS

    Properties from NcmFitGSLMMS:
      algorithm -> NcmFitGSLMMSAlgos: algorithm
        GSL multidimensional minimization algorithm [simplex]

    Properties from NcmFit:
      likelihood -> NcmLikelihood: likelihood
        Likelihood object
      mset -> NcmMSet: mset
        Model set object
      state -> NcmFitState: state
        Fit state object
      grad-type -> NcmFitGradType: grad-type
        Differentiation method
      maxiter -> guint: maxiter
        Maximum number of interations
      m2lnL-reltol -> gdouble: m2lnL-reltol
        Relative tolarence in m2lnL
      m2lnL-abstol -> gdouble: m2lnL-abstol
        Absolute tolarence in m2lnL
      params-reltol -> gdouble: params-reltol
        Relative tolarence in fitted parameters
      equality-constraints -> NcmObjArray: equality-constraints
        Equality constraints array
      equality-constraints-tot -> NcmVector: equality-constraints-tot
        Equality constraints tolerance
      inequality-constraints -> NcmObjArray: inequality-constraints
        Inequality constraints array
      inequality-constraints-tot -> NcmVector: inequality-constraints-tot
        Inequality constraints tolerance
      sub-fit -> NcmFit: sub-fit
        Subsidiary fit

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        algorithm: FitGSLMMSAlgos
        equality_constraints: ObjArray
        equality_constraints_tot: Vector
        grad_type: FitGradType
        inequality_constraints: ObjArray
        inequality_constraints_tot: Vector
        likelihood: Likelihood
        m2lnL_abstol: float
        m2lnL_reltol: float
        maxiter: int
        mset: MSet
        params_reltol: float
        state: FitState
        sub_fit: Fit
    props: Props = ...
    parent_instance: Fit = ...
    mms: int = ...
    f: int = ...
    algo: FitGSLMMSAlgos = ...
    desc: str = ...
    ss: Vector = ...
    def __init__(self, algorithm: FitGSLMMSAlgos = ...,
                 equality_constraints: ObjArray = ...,
                 equality_constraints_tot: Vector = ...,
                 grad_type: FitGradType = ...,
                 inequality_constraints: ObjArray = ...,
                 inequality_constraints_tot: Vector = ...,
                 likelihood: Likelihood = ...,
                 m2lnL_abstol: float = ...,
                 m2lnL_reltol: float = ...,
                 maxiter: int = ...,
                 mset: MSet = ...,
                 params_reltol: float = ...,
                 state: FitState = ...,
                 sub_fit: Fit = ...): ...
    @classmethod
    def new(cls, lh: Likelihood, mset: MSet, gtype: FitGradType, algo: FitGSLMMSAlgos) -> FitGSLMMS: ...
    @classmethod
    def new_by_name(cls, lh: Likelihood, mset: MSet, gtype: FitGradType, algo_name: str) -> FitGSLMMS: ...
    @classmethod
    def new_default(cls, lh: Likelihood, mset: MSet, gtype: FitGradType) -> FitGSLMMS: ...
    def set_algo(self, algo: FitGSLMMSAlgos) -> None: ...
    

class FitGSLMMSClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitGSLMMSClass()
    """
    parent_class: FitClass = ...

class FitGrad(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitGrad()
    """
    gtype: FitGradType = ...
    diff_name: str = ...
    ls_J: None = ...
    ls_f_J: None = ...
    m2lnL_grad: None = ...
    m2lnL_val_grad: None = ...

class FitLevmar(Fit):
    r"""
    :Constructors:

    ::

        FitLevmar(**properties)
        new(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType, algo:NumCosmoMath.FitLevmarAlgos) -> NumCosmoMath.Fit
        new_by_name(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType, algo_name:str) -> NumCosmoMath.Fit
        new_default(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType) -> NumCosmoMath.Fit

    Object NcmFitLevmar

    Properties from NcmFitLevmar:
      algorithm -> NcmFitLevmarAlgos: algorithm
        Levmar least squares library algorithm

    Properties from NcmFit:
      likelihood -> NcmLikelihood: likelihood
        Likelihood object
      mset -> NcmMSet: mset
        Model set object
      state -> NcmFitState: state
        Fit state object
      grad-type -> NcmFitGradType: grad-type
        Differentiation method
      maxiter -> guint: maxiter
        Maximum number of interations
      m2lnL-reltol -> gdouble: m2lnL-reltol
        Relative tolarence in m2lnL
      m2lnL-abstol -> gdouble: m2lnL-abstol
        Absolute tolarence in m2lnL
      params-reltol -> gdouble: params-reltol
        Relative tolarence in fitted parameters
      equality-constraints -> NcmObjArray: equality-constraints
        Equality constraints array
      equality-constraints-tot -> NcmVector: equality-constraints-tot
        Equality constraints tolerance
      inequality-constraints -> NcmObjArray: inequality-constraints
        Inequality constraints array
      inequality-constraints-tot -> NcmVector: inequality-constraints-tot
        Inequality constraints tolerance
      sub-fit -> NcmFit: sub-fit
        Subsidiary fit

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        algorithm: FitLevmarAlgos
        equality_constraints: ObjArray
        equality_constraints_tot: Vector
        grad_type: FitGradType
        inequality_constraints: ObjArray
        inequality_constraints_tot: Vector
        likelihood: Likelihood
        m2lnL_abstol: float
        m2lnL_reltol: float
        maxiter: int
        mset: MSet
        params_reltol: float
        state: FitState
        sub_fit: Fit
    props: Props = ...
    parent_instance: Fit = ...
    workz: None = ...
    fparam_len: int = ...
    data_len: int = ...
    lb: Vector = ...
    ub: Vector = ...
    algo: FitLevmarAlgos = ...
    def __init__(self, algorithm: FitLevmarAlgos = ...,
                 equality_constraints: ObjArray = ...,
                 equality_constraints_tot: Vector = ...,
                 grad_type: FitGradType = ...,
                 inequality_constraints: ObjArray = ...,
                 inequality_constraints_tot: Vector = ...,
                 likelihood: Likelihood = ...,
                 m2lnL_abstol: float = ...,
                 m2lnL_reltol: float = ...,
                 maxiter: int = ...,
                 mset: MSet = ...,
                 params_reltol: float = ...,
                 state: FitState = ...,
                 sub_fit: Fit = ...): ...
    @classmethod
    def new(cls, lh: Likelihood, mset: MSet, gtype: FitGradType, algo: FitLevmarAlgos) -> FitLevmar: ...
    @classmethod
    def new_by_name(cls, lh: Likelihood, mset: MSet, gtype: FitGradType, algo_name: str) -> FitLevmar: ...
    @classmethod
    def new_default(cls, lh: Likelihood, mset: MSet, gtype: FitGradType) -> FitLevmar: ...
    def set_algo(self, algo: FitLevmarAlgos) -> None: ...
    

class FitLevmarClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitLevmarClass()
    """
    parent_class: FitClass = ...

class FitMC(GObject.Object):
    r"""
    :Constructors:

    ::

        FitMC(**properties)
        new(fit:NumCosmoMath.Fit, rtype:NumCosmoMath.FitMCResampleType, mtype:NumCosmoMath.FitRunMsgs) -> NumCosmoMath.FitMC

    Object NcmFitMC

    Properties from NcmFitMC:
      fit -> NcmFit: fit
        Fit object
      rtype -> NcmFitMCResampleType: rtype
        Monte Carlo run type
      fiducial -> NcmMSet: fiducial
        Fiducial model to sample from
      mtype -> NcmFitRunMsgs: mtype
        Run messages type
      nthreads -> guint: nthreads
        Number of threads to run
      keep-order -> gboolean: keep-order
        Whether keep the catalog in order of sampling

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        fiducial: MSet
        fit: Fit
        keep_order: bool
        mtype: FitRunMsgs
        nthreads: int
        rtype: FitMCResampleType
    props: Props = ...
    parent_instance: GObject.Object = ...
    resample: Callable[[Dataset, MSet, RNG], None] = ...
    fit: Fit = ...
    fiduc: MSet = ...
    mcat: MSetCatalog = ...
    mtype: FitRunMsgs = ...
    rtype: FitMCResampleType = ...
    bf: Vector = ...
    nt: Timer = ...
    ser: Serialize = ...
    nthreads: int = ...
    n: int = ...
    keep_order: bool = ...
    mp: MemoryPool = ...
    write_index: int = ...
    cur_sample_id: int = ...
    first_sample_id: int = ...
    started: bool = ...
    dup_fit: GLib.Mutex = ...
    resample_lock: GLib.Mutex = ...
    update_lock: GLib.Mutex = ...
    write_cond: GLib.Cond = ...
    def __init__(self, fiducial: MSet = ...,
                 fit: Fit = ...,
                 keep_order: bool = ...,
                 mtype: FitRunMsgs = ...,
                 nthreads: int = ...,
                 rtype: FitMCResampleType = ...): ...
    @staticmethod
    def clear(mc: FitMC) -> None: ...
    def end_run(self) -> None: ...
    def free(self) -> None: ...
    def get_catalog(self) -> MSetCatalog: ...
    def mean_covar(self) -> None: ...
    @classmethod
    def new(cls, fit: Fit, rtype: FitMCResampleType, mtype: FitRunMsgs) -> FitMC: ...
    def reset(self) -> None: ...
    def run(self, n: int) -> None: ...
    def run_lre(self, prerun: int, lre: float) -> None: ...
    def set_data_file(self, filename: str) -> None: ...
    def set_fiducial(self, fiduc: MSet) -> None: ...
    def set_first_sample_id(self, first_sample_id: int) -> None: ...
    def set_mtype(self, mtype: FitRunMsgs) -> None: ...
    def set_nthreads(self, nthreads: int) -> None: ...
    def set_rng(self, rng: RNG) -> None: ...
    def set_rtype(self, rtype: FitMCResampleType) -> None: ...
    def start_run(self) -> None: ...
    

class FitMCBS(GObject.Object):
    r"""
    :Constructors:

    ::

        FitMCBS(**properties)
        new(fit:NumCosmoMath.Fit) -> NumCosmoMath.FitMCBS

    Object NcmFitMCBS

    Properties from NcmFitMCBS:
      fit -> NcmFit: fit
        Fit object
      filename -> gchararray: filename
        Data filename

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        filename: str
        fit: Fit
    props: Props = ...
    parent_instance: GObject.Object = ...
    fit: Fit = ...
    mc_resample: FitMC = ...
    mc_bstrap: FitMC = ...
    mcat: MSetCatalog = ...
    base_name: str = ...
    def __init__(self, filename: str = ...,
                 fit: Fit = ...): ...
    @staticmethod
    def clear(mcbs: FitMCBS) -> None: ...
    def free(self) -> None: ...
    def get_catalog(self) -> MSetCatalog: ...
    @classmethod
    def new(cls, fit: Fit) -> FitMCBS: ...
    def run(self, fiduc: MSet, ni: int, nf: int, nbstraps: int, rtype: FitMCResampleType, mtype: FitRunMsgs, bsmt: int) -> None: ...
    def set_filename(self, filename: str) -> None: ...
    def set_rng(self, rng: RNG) -> None: ...
    

class FitMCBSClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitMCBSClass()
    """
    parent_class: GObject.ObjectClass = ...

class FitMCClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitMCClass()
    """
    parent_class: GObject.ObjectClass = ...

class FitMCMC(GObject.Object):
    r"""
    :Constructors:

    ::

        FitMCMC(**properties)
        new(fit:NumCosmoMath.Fit, tkern:NumCosmoMath.MSetTransKern, mtype:NumCosmoMath.FitRunMsgs) -> NumCosmoMath.FitMCMC

    Object NcmFitMCMC

    Properties from NcmFitMCMC:
      fit -> NcmFit: fit
        Fit object
      sampler -> NcmMSetTransKern: sampler
        Metropolis–Hastings sampler
      mtype -> NcmFitRunMsgs: mtype
        Run messages type
      nthreads -> guint: nthreads
        Number of threads to run

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        fit: Fit
        mtype: FitRunMsgs
        nthreads: int
        sampler: MSetTransKern
    props: Props = ...
    parent_instance: GObject.Object = ...
    fit: Fit = ...
    mcat: MSetCatalog = ...
    mtype: FitRunMsgs = ...
    nt: Timer = ...
    ser: Serialize = ...
    tkern: MSetTransKern = ...
    theta: Vector = ...
    thetastar: Vector = ...
    nthreads: int = ...
    n: int = ...
    mp: MemoryPool = ...
    write_index: int = ...
    cur_sample_id: int = ...
    naccepted: int = ...
    ntotal: int = ...
    started: bool = ...
    dup_fit: GLib.Mutex = ...
    resample_lock: GLib.Mutex = ...
    update_lock: GLib.Mutex = ...
    write_cond: GLib.Cond = ...
    def __init__(self, fit: Fit = ...,
                 mtype: FitRunMsgs = ...,
                 nthreads: int = ...,
                 sampler: MSetTransKern = ...): ...
    @staticmethod
    def clear(mcmc: FitMCMC) -> None: ...
    def end_run(self) -> None: ...
    def free(self) -> None: ...
    def get_accept_ratio(self) -> float: ...
    def get_catalog(self) -> MSetCatalog: ...
    def mean_covar(self) -> None: ...
    @classmethod
    def new(cls, fit: Fit, tkern: MSetTransKern, mtype: FitRunMsgs) -> FitMCMC: ...
    def reset(self) -> None: ...
    def run(self, n: int) -> None: ...
    def run_lre(self, prerun: int, lre: float) -> None: ...
    def set_data_file(self, filename: str) -> None: ...
    def set_fiducial(self, fiduc: MSet) -> None: ...
    def set_first_sample_id(self, first_sample_id: int) -> None: ...
    def set_mtype(self, mtype: FitRunMsgs) -> None: ...
    def set_nthreads(self, nthreads: int) -> None: ...
    def set_rng(self, rng: RNG) -> None: ...
    def set_trans_kern(self, tkern: MSetTransKern) -> None: ...
    def start_run(self) -> None: ...
    

class FitMCMCClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitMCMCClass()
    """
    parent_class: GObject.ObjectClass = ...

class FitNLOpt(Fit):
    r"""
    :Constructors:

    ::

        FitNLOpt(**properties)
        new_by_name(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType, algo_name:str) -> NumCosmoMath.Fit
        new_default(lh:NumCosmoMath.Likelihood, mset:NumCosmoMath.MSet, gtype:NumCosmoMath.FitGradType) -> NumCosmoMath.Fit

    Object NcmFitNLOpt

    Properties from NcmFitNLOpt:
      algorithm -> NcmFitNloptAlgorithm: algorithm
        NLOpt algorithm
      local-algorithm -> NcmFitNloptAlgorithm: local-algorithm
        NLOpt local algorithm

    Properties from NcmFit:
      likelihood -> NcmLikelihood: likelihood
        Likelihood object
      mset -> NcmMSet: mset
        Model set object
      state -> NcmFitState: state
        Fit state object
      grad-type -> NcmFitGradType: grad-type
        Differentiation method
      maxiter -> guint: maxiter
        Maximum number of interations
      m2lnL-reltol -> gdouble: m2lnL-reltol
        Relative tolarence in m2lnL
      m2lnL-abstol -> gdouble: m2lnL-abstol
        Absolute tolarence in m2lnL
      params-reltol -> gdouble: params-reltol
        Relative tolarence in fitted parameters
      equality-constraints -> NcmObjArray: equality-constraints
        Equality constraints array
      equality-constraints-tot -> NcmVector: equality-constraints-tot
        Equality constraints tolerance
      inequality-constraints -> NcmObjArray: inequality-constraints
        Inequality constraints array
      inequality-constraints-tot -> NcmVector: inequality-constraints-tot
        Inequality constraints tolerance
      sub-fit -> NcmFit: sub-fit
        Subsidiary fit

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        algorithm: FitNloptAlgorithm
        local_algorithm: FitNloptAlgorithm
        equality_constraints: ObjArray
        equality_constraints_tot: Vector
        grad_type: FitGradType
        inequality_constraints: ObjArray
        inequality_constraints_tot: Vector
        likelihood: Likelihood
        m2lnL_abstol: float
        m2lnL_reltol: float
        maxiter: int
        mset: MSet
        params_reltol: float
        state: FitState
        sub_fit: Fit
    props: Props = ...
    parent_instance: Fit = ...
    nlopt_algo: int = ...
    local_nlopt_algo: int = ...
    lb: Vector = ...
    ub: Vector = ...
    pabs: Vector = ...
    pscale: Vector = ...
    desc: str = ...
    fparam_len: int = ...
    def __init__(self, algorithm: FitNloptAlgorithm = ...,
                 local_algorithm: FitNloptAlgorithm = ...,
                 equality_constraints: ObjArray = ...,
                 equality_constraints_tot: Vector = ...,
                 grad_type: FitGradType = ...,
                 inequality_constraints: ObjArray = ...,
                 inequality_constraints_tot: Vector = ...,
                 likelihood: Likelihood = ...,
                 m2lnL_abstol: float = ...,
                 m2lnL_reltol: float = ...,
                 maxiter: int = ...,
                 mset: MSet = ...,
                 params_reltol: float = ...,
                 state: FitState = ...,
                 sub_fit: Fit = ...): ...
    @classmethod
    def new_by_name(cls, lh: Likelihood, mset: MSet, gtype: FitGradType, algo_name: str) -> FitNLOpt: ...
    @classmethod
    def new_default(cls, lh: Likelihood, mset: MSet, gtype: FitGradType) -> FitNLOpt: ...
    

class FitNLOptClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitNLOptClass()
    """
    parent_class: FitClass = ...

class FitState(GObject.Object):
    r"""
    :Constructors:

    ::

        FitState(**properties)
        new(data_len:int, fparam_len:int, dof:int, is_least_squares:bool) -> NumCosmoMath.FitState

    Object NcmFitState

    Properties from NcmFitState:
      data-len -> guint: data-len
        Data length
      fparam-len -> guint: fparam-len
        Free parameters length
      dof -> gint: dof
        Degrees of freedom
      is-least-squares -> gboolean: is-least-squares
        Is a least squares fit state
      niters -> guint: niters
        Number of interations
      func-eval -> guint: func-eval
        Number of function evaluations
      grad-eval -> guint: grad-eval
        Number of gradient evaluations
      is-best-fit -> gboolean: is-best-fit
        Is a best fit state

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        data_len: int
        dof: int
        fparam_len: int
        func_eval: int
        grad_eval: int
        is_best_fit: bool
        is_least_squares: bool
        niters: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    data_len: int = ...
    fparam_len: int = ...
    alloc_data_len: int = ...
    alloc_fparam_len: int = ...
    dof: int = ...
    niter: int = ...
    func_eval: int = ...
    grad_eval: int = ...
    m2lnL_prec: float = ...
    params_prec: float = ...
    elapsed_time: float = ...
    m2lnL_curval: float = ...
    dm2lnL: Vector = ...
    fparams: Vector = ...
    ls_f: Vector = ...
    ls_J: Matrix = ...
    covar: Matrix = ...
    hessian: Matrix = ...
    is_best_fit: bool = ...
    is_least_squares: bool = ...
    has_covar: bool = ...
    def __init__(self, data_len: int = ...,
                 dof: int = ...,
                 fparam_len: int = ...,
                 is_least_squares: bool = ...): ...
    @staticmethod
    def clear(fstate: FitState) -> None: ...
    def free(self) -> None: ...
    def get_data_len(self) -> int: ...
    def get_m2lnL_prec(self) -> float: ...
    def get_niter(self) -> int: ...
    def get_params_prec(self) -> float: ...
    @classmethod
    def new(cls, data_len: int, fparam_len: int, dof: int, is_least_squares: bool) -> FitState: ...
    def realloc(self) -> None: ...
    def ref(self) -> FitState: ...
    def reset(self) -> None: ...
    def set_all(self, data_len: int, fparam_len: int, dof: int, is_least_squares: bool) -> None: ...
    def set_ls(self, f: Vector, J: Matrix) -> None: ...
    def set_m2lnL_prec(self, prec: float) -> None: ...
    def set_niter(self, niter: int) -> None: ...
    def set_params_prec(self, prec: float) -> None: ...
    

class FitStateClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FitStateClass()
    """
    parent_class: GObject.ObjectClass = ...

class FunctionCache(GObject.Object):
    r"""
    :Constructors:

    ::

        FunctionCache(**properties)
        new(n:int, abstol:float, reltol:float) -> NumCosmoMath.FunctionCache

    Object NcmFunctionCache

    Properties from NcmFunctionCache:
      dimension -> guint: dimension
        Function dimension
      reltol -> gdouble: reltol
        Relative tolerance
      abstol -> gdouble: abstol
        Absolute tolerance

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        abstol: float
        dimension: int
        reltol: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: FunctionCachePrivate = ...
    def __init__(self, abstol: float = ...,
                 dimension: int = ...,
                 reltol: float = ...): ...
    @staticmethod
    def clear(cache: FunctionCache) -> None: ...
    def empty_cache(self) -> None: ...
    def free(self) -> None: ...
    def get_abstol(self) -> float: ...
    def get_near(self, x: float, x_found_ptr: float, type: FunctionCacheSearchType) -> Tuple[bool, Vector]: ...
    def get_reltol(self) -> float: ...
    def insert_vector(self, x: float, p: Vector) -> None: ...
    @classmethod
    def new(cls, n: int, abstol: float, reltol: float) -> FunctionCache: ...
    def ref(self) -> FunctionCache: ...
    

class FunctionCacheClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        FunctionCacheClass()
    """
    parent_class: GObject.ObjectClass = ...

class FunctionCachePrivate(GObject.GPointer): ...

class HOAA(GObject.Object):
    r"""
    :Constructors:

    ::

        HOAA(**properties)

    Object NcmHOAA

    Properties from NcmHOAA:
      reltol -> gdouble: reltol
        Relative tolerance
      abstol -> gdouble: abstol
        Absolute tolerance tolerance
      k -> gdouble: k
        The mode k
      ti -> gdouble: ti
        The initial time t_i
      tf -> gdouble: tf
        The final time t_f
      save-evol -> gboolean: save-evol
        Save the system evolution
      opt -> NcmHOAAOpt: opt
        Evolution options

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        abstol: float
        k: float
        opt: HOAAOpt
        reltol: float
        save_evol: bool
        tf: float
        ti: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: HOAAPrivate = ...
    k: float = ...
    def __init__(self, abstol: float = ...,
                 k: float = ...,
                 opt: HOAAOpt = ...,
                 reltol: float = ...,
                 save_evol: bool = ...,
                 tf: float = ...,
                 ti: float = ...): ...
    @staticmethod
    def clear(hoaa: HOAA) -> None: ...
    def do_eval_V(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_dlnmnu(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_mnu(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_nu(self, model: Optional[Model], t: float, k: float) -> float: ...
    def do_eval_powspec_factor(self, model: Optional[Model] = None) -> float: ...
    def do_eval_sing_V(self, model: Optional[Model], t_m_ts: float, k: float, sing: int) -> float: ...
    def do_eval_sing_dlnmnu(self, model: Optional[Model], t_m_ts: float, k: float, sing: int) -> float: ...
    def do_eval_sing_mnu(self, model: Optional[Model], t_m_ts: float, k: float, sing: int) -> float: ...
    def do_eval_sing_system(self, model: Optional[Model], t_m_ts: float, k: float, sing: int) -> Tuple[float, float, float]: ...
    def do_eval_system(self, model: Optional[Model], t: float, k: float) -> Tuple[float, float, float]: ...
    def do_get_sing_info(self, model: Optional[Model], k: float, sing: int) -> Tuple[float, float, float, HOAASingType]: ...
    def do_nsing(self, model: Optional[Model], k: float) -> int: ...
    def do_prepare(self, model: Optional[Model] = None) -> None: ...
    def eval_AA(self, model: Optional[Model], t: float) -> Tuple[float, float, float, float]: ...
    def eval_AA2QV(self, model: Optional[Model], t: float, upsilon: float, gamma: float, qbar: float, pbar: float) -> Tuple[float, float, float, float]: ...
    def eval_Delta(self, model: Optional[Model], t: float) -> Tuple[float, float]: ...
    def eval_QV(self, model: Optional[Model], t: float) -> Tuple[float, float, float, float]: ...
    def eval_QV2AA(self, model: Optional[Model], t: float, q: float, v: float, Pq: float, Pv: float) -> Tuple[float, float, float, float]: ...
    def eval_V(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_adiabatic_LnI_approx(self, model: Optional[Model], t: float, theta: float, psi: float) -> Tuple[float, float]: ...
    def eval_adiabatic_approx(self, model: Optional[Model], t: float) -> Tuple[float, float, float]: ...
    def eval_dlnmnu(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_mnu(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_nu(self, model: Optional[Model], t: float, k: float) -> float: ...
    def eval_powspec_factor(self, model: Optional[Model] = None) -> float: ...
    def eval_sing_V(self, model: Optional[Model], t_m_ts: float, k: float, sing: int) -> float: ...
    def eval_sing_dlnmnu(self, model: Optional[Model], t_m_ts: float, k: float, sing: int) -> float: ...
    def eval_sing_mnu(self, model: Optional[Model], t_m_ts: float, k: float, sing: int) -> float: ...
    def eval_sing_system(self, model: Optional[Model], t_m_ts: float, k: float, sing: int) -> Tuple[float, float, float]: ...
    def eval_solution(self, model: Optional[Model], t: float, S: float, PS: float) -> Tuple[float, float]: ...
    def eval_system(self, model: Optional[Model], t: float, k: float) -> Tuple[float, float, float]: ...
    def free(self) -> None: ...
    def get_sing_info(self, model: Optional[Model], k: float, sing: int) -> Tuple[float, float, float, HOAASingType]: ...
    def get_t0_t1(self, model: Optional[Model] = None) -> Tuple[float, float]: ...
    def nsing(self, model: Optional[Model], k: float) -> int: ...
    def prepare(self, model: Optional[Model] = None) -> None: ...
    def ref(self) -> HOAA: ...
    def save_evol(self, save_evol: bool) -> None: ...
    def set_abstol(self, abstol: float) -> None: ...
    def set_k(self, k: float) -> None: ...
    def set_reltol(self, reltol: float) -> None: ...
    def set_tf(self, tf: float) -> None: ...
    def set_ti(self, ti: float) -> None: ...
    

class HOAAClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        HOAAClass()
    """
    parent_class: GObject.ObjectClass = ...
    eval_mnu: Callable[[HOAA, Optional[Model], float, float], float] = ...
    eval_nu: Callable[[HOAA, Optional[Model], float, float], float] = ...
    eval_dlnmnu: Callable[[HOAA, Optional[Model], float, float], float] = ...
    eval_V: Callable[[HOAA, Optional[Model], float, float], float] = ...
    eval_system: Callable[[HOAA, Optional[Model], float, float], Tuple[float, float, float]] = ...
    nsing: Callable[[HOAA, Optional[Model], float], int] = ...
    get_sing_info: Callable[[HOAA, Optional[Model], float, int], Tuple[float, float, float, HOAASingType]] = ...
    eval_sing_mnu: Callable[[HOAA, Optional[Model], float, float, int], float] = ...
    eval_sing_dlnmnu: Callable[[HOAA, Optional[Model], float, float, int], float] = ...
    eval_sing_V: Callable[[HOAA, Optional[Model], float, float, int], float] = ...
    eval_sing_system: Callable[[HOAA, Optional[Model], float, float, int], Tuple[float, float, float]] = ...
    eval_powspec_factor: Callable[[HOAA, Optional[Model]], float] = ...
    prepare: Callable[[HOAA, Optional[Model]], None] = ...

class HOAAPrivate(GObject.GPointer): ...

class ISet(GObject.Object):
    r"""
    :Constructors:

    ::

        ISet(**properties)
        new(n:int) -> NumCosmoMath.ISet

    Object NcmISet

    Properties from NcmISet:
      max-index -> guint: max-index
        Maximum index

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        max_index: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: ISetPrivate = ...
    def __init__(self, max_index: int = ...): ...
    def add(self, i: int) -> None: ...
    def add_largest_subset(self, v: Vector, min: float, add_frac: float) -> int: ...
    def add_range(self, ii: int, fi: int) -> None: ...
    @staticmethod
    def clear(iset: ISet) -> None: ...
    def copy(self, target: ISet) -> None: ...
    def del_(self, i: int) -> None: ...
    def free(self) -> None: ...
    def get_len(self) -> int: ...
    def get_max_size(self) -> int: ...
    def get_submatrix(self, M: Matrix, M_dup: Matrix) -> Matrix: ...
    def get_submatrix_colmajor_cols(self, M: Matrix, M_dup: Matrix) -> Matrix: ...
    def get_submatrix_cols(self, M: Matrix, M_dup: Matrix) -> Matrix: ...
    def get_subset_vec_lt(self, out: ISet, v: Vector, tol: float) -> None: ...
    def get_subvector(self, v: Vector, v_dup: Vector) -> Vector: ...
    def get_sym_submatrix(self, UL: int, M: Matrix, M_dup: Matrix) -> Matrix: ...
    def get_vector_inv_cmp(self, u: Vector, v: Vector, v_dup: Vector) -> Vector: ...
    def get_vector_max(self, v: Vector) -> Tuple[float, int]: ...
    def log_vals(self, prefix: str) -> None: ...
    @classmethod
    def new(cls, n: int) -> ISet: ...
    def ref(self) -> ISet: ...
    def remove_smallest_subset(self, target: ISet, v: Vector, max_remove: int) -> int: ...
    def remove_subset(self, target: ISet) -> None: ...
    def reset(self) -> None: ...
    def set_complement(self, cmplm: ISet) -> None: ...
    def set_subvector(self, v: Vector, sub: Vector) -> None: ...
    

class ISetClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ISetClass()
    """
    parent_class: GObject.ObjectClass = ...

class ISetPrivate(GObject.GPointer): ...

class Integral1d(GObject.Object):
    r"""
    :Constructors:

    ::

        Integral1d(**properties)

    Object NcmIntegral1d

    Properties from NcmIntegral1d:
      partition -> guint: partition
        Integral maximum partititon
      rule -> guint: rule
        Integration rule
      reltol -> gdouble: reltol
        Integral relative tolerance
      abstol -> gdouble: abstol
        Integral absolute tolerance

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        abstol: float
        partition: int
        reltol: float
        rule: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: Integral1dPrivate = ...
    def __init__(self, abstol: float = ...,
                 partition: int = ...,
                 reltol: float = ...,
                 rule: int = ...): ...
    @staticmethod
    def clear(int1d: Integral1d) -> None: ...
    def do_integrand(self, x: float, w: float) -> float: ...
    def eval(self, xi: float, xf: float) -> Tuple[float, float]: ...
    def eval_gauss_hermite(self) -> Tuple[float, float]: ...
    def eval_gauss_hermite1_p(self) -> Tuple[float, float]: ...
    def eval_gauss_hermite1_r_p(self, r: float) -> Tuple[float, float]: ...
    def eval_gauss_hermite_mur(self, r: float, mu: float) -> Tuple[float, float]: ...
    def eval_gauss_hermite_p(self) -> Tuple[float, float]: ...
    def eval_gauss_hermite_r_p(self, r: float) -> Tuple[float, float]: ...
    def eval_gauss_laguerre(self) -> Tuple[float, float]: ...
    def eval_gauss_laguerre_r(self, r: float) -> Tuple[float, float]: ...
    def free(self) -> None: ...
    def get_abstol(self) -> float: ...
    def get_partition(self) -> int: ...
    def get_reltol(self) -> float: ...
    def get_rule(self) -> int: ...
    def integrand(self, x: float, w: float) -> float: ...
    def ref(self) -> Integral1d: ...
    def set_abstol(self, abstol: float) -> None: ...
    def set_partition(self, partition: int) -> None: ...
    def set_reltol(self, reltol: float) -> None: ...
    def set_rule(self, rule: int) -> None: ...
    

class Integral1dClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        Integral1dClass()
    """
    parent_class: GObject.ObjectClass = ...
    integrand: Callable[[Integral1d, float, float], float] = ...
    padding: list[None] = ...

class Integral1dPrivate(GObject.GPointer): ...

class Integral1dPtr(Integral1d):
    r"""
    :Constructors:

    ::

        Integral1dPtr(**properties)
        new(F:NumCosmoMath.Integral1dPtrF) -> NumCosmoMath.Integral1dPtr
        new_full(F:NumCosmoMath.Integral1dPtrF, reltol:float, abstol:float, partition:int, rule:int) -> NumCosmoMath.Integral1dPtr

    Object NcmIntegral1dPtr

    Properties from NcmIntegral1dPtr:
      integrand -> gpointer: integrand
        Integrand function pointer
      userdata -> gpointer: userdata
        Integrand function user data
      userfree -> gpointer: userfree
        Integrand function user data free function

    Properties from NcmIntegral1d:
      partition -> guint: partition
        Integral maximum partititon
      rule -> guint: rule
        Integration rule
      reltol -> gdouble: reltol
        Integral relative tolerance
      abstol -> gdouble: abstol
        Integral absolute tolerance

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        integrand: None
        userdata: Optional[None]
        userfree: None
        abstol: float
        partition: int
        reltol: float
        rule: int
    props: Props = ...
    parent_instance: Integral1d = ...
    priv: Integral1dPtrPrivate = ...
    def __init__(self, integrand: None = ...,
                 userdata: Optional[None] = ...,
                 userfree: None = ...,
                 abstol: float = ...,
                 partition: int = ...,
                 reltol: float = ...,
                 rule: int = ...): ...
    @staticmethod
    def clear(int1d_ptr: Integral1dPtr) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, F: Callable[[None, float, float], float], userfree: Callable[[None], None]) -> Integral1dPtr: ...
    @classmethod
    def new_full(cls, F: Callable[[None, float, float], float], userfree: Callable[[None], None], reltol: float, abstol: float, partition: int, rule: int) -> Integral1dPtr: ...
    def ref(self) -> Integral1dPtr: ...
    def set_userdata(self, userdata: None) -> None: ...
    

class Integral1dPtrClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        Integral1dPtrClass()
    """
    parent_class: Integral1dClass = ...

class Integral1dPtrPrivate(GObject.GPointer): ...

class IntegralFixed(GObject.GPointer):
    r"""
    :Constructors:

    ::

        IntegralFixed()
    """
    xl: float = ...
    xu: float = ...
    int_nodes: float = ...
    n_nodes: int = ...
    rule_n: int = ...
    def free(self) -> None: ...
    def nodes_eval(self) -> float: ...
    

class Integrand2dim(GObject.GPointer):
    r"""
    :Constructors:

    ::

        Integrand2dim()
    """
    userdata: None = ...
    f: None = ...

class Integrand3dim(GObject.GPointer):
    r"""
    :Constructors:

    ::

        Integrand3dim()
    """
    userdata: None = ...
    f: None = ...

class LHRatio1d(GObject.Object):
    r"""
    :Constructors:

    ::

        LHRatio1d(**properties)
        new(fit:NumCosmoMath.Fit, pi:NumCosmoMath.MSetPIndex) -> NumCosmoMath.LHRatio1d

    Object NcmLHRatio1d

    Properties from NcmLHRatio1d:
      fit -> NcmFit: fit
        NcmFit object
      pi -> NcmMSetPIndex: pi
        Param index
      constraint -> NcmMSetFunc: constraint
        Constraint

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        constraint: MSetFunc
        fit: Fit
        pi: MSetPIndex
    props: Props = ...
    parent_instance: GObject.Object = ...
    fit: Fit = ...
    constrained: Fit = ...
    mtype: FitRunMsgs = ...
    rtype: LHRatio1dRoot = ...
    pi: MSetPIndex = ...
    constraint: MSetFunc = ...
    chisquare: float = ...
    lb: float = ...
    ub: float = ...
    bf: float = ...
    niter: int = ...
    func_eval: int = ...
    grad_eval: int = ...
    def __init__(self, constraint: MSetFunc = ...,
                 fit: Fit = ...,
                 pi: MSetPIndex = ...): ...
    @staticmethod
    def clear(lhr1d: LHRatio1d) -> None: ...
    def find_bounds(self, clevel: float, mtype: FitRunMsgs) -> Tuple[float, float]: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, fit: Fit, pi: MSetPIndex) -> LHRatio1d: ...
    def set_pindex(self, pi: MSetPIndex) -> None: ...
    

class LHRatio1dClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        LHRatio1dClass()
    """
    parent_class: GObject.ObjectClass = ...

class LHRatio2d(GObject.Object):
    r"""
    :Constructors:

    ::

        LHRatio2d(**properties)
        new(fit:NumCosmoMath.Fit, pi1:NumCosmoMath.MSetPIndex, pi2:NumCosmoMath.MSetPIndex, border_prec:float) -> NumCosmoMath.LHRatio2d

    Object NcmLHRatio2d

    Properties from NcmLHRatio2d:
      fit -> NcmFit: fit
        NcmFit object
      pi1 -> NcmMSetPIndex: pi1
        First param index
      pi2 -> NcmMSetPIndex: pi2
        Second param index
      border-prec -> gdouble: border-prec
        Border precision

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        border_prec: float
        pi1: MSetPIndex
        pi2: MSetPIndex
        fit: Fit
    props: Props = ...
    parent_instance: GObject.Object = ...
    fit: Fit = ...
    constrained: Fit = ...
    mtype: FitRunMsgs = ...
    rtype: LHRatio2dRoot = ...
    pi: list[MSetPIndex] = ...
    rng: RNG = ...
    chisquare: float = ...
    lb: list[float] = ...
    ub: list[float] = ...
    bf: list[float] = ...
    border_prec: float = ...
    e_vec: Matrix = ...
    e_val: Vector = ...
    r: float = ...
    theta: float = ...
    shift: list[float] = ...
    angular: bool = ...
    niter: int = ...
    func_eval: int = ...
    grad_eval: int = ...
    diff: Diff = ...
    def __init__(self, border_prec: float = ...,
                 fit: Fit = ...,
                 pi1: MSetPIndex = ...,
                 pi2: MSetPIndex = ...): ...
    @staticmethod
    def clear(lhr2d: LHRatio2d) -> None: ...
    def conf_region(self, clevel: float, expected_np: float, mtype: FitRunMsgs) -> LHRatio2dRegion: ...
    def fisher_border(self, clevel: float, expected_np: float, mtype: FitRunMsgs) -> LHRatio2dRegion: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, fit: Fit, pi1: MSetPIndex, pi2: MSetPIndex, border_prec: float) -> LHRatio2d: ...
    def set_pindex(self, pi1: MSetPIndex, pi2: MSetPIndex) -> None: ...
    

class LHRatio2dClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        LHRatio2dClass()
    """
    parent_class: GObject.ObjectClass = ...

class LHRatio2dPoint(GObject.GPointer):
    r"""
    :Constructors:

    ::

        LHRatio2dPoint()
    """
    x: float = ...
    y: float = ...
    theta: float = ...
    p1: float = ...
    p2: float = ...

class LHRatio2dRegion(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        LHRatio2dRegion()
    """
    np: int = ...
    p1: Vector = ...
    p2: Vector = ...
    clevel: float = ...
    @staticmethod
    def clear(rg: LHRatio2dRegion) -> None: ...
    def dup(self) -> LHRatio2dRegion: ...
    def free(self) -> None: ...
    def print_(self, out: int) -> None: ...
    

class LapackWS(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        LapackWS()
        new() -> NumCosmoMath.LapackWS
    """
    work: list[None] = ...
    iwork: list[None] = ...
    @staticmethod
    def clear(ws: LapackWS) -> None: ...
    def dup(self) -> LapackWS: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls) -> LapackWS: ...
    

class Likelihood(GObject.Object):
    r"""
    :Constructors:

    ::

        Likelihood(**properties)
        new(dset:NumCosmoMath.Dataset) -> NumCosmoMath.Likelihood

    Object NcmLikelihood

    Properties from NcmLikelihood:
      dataset -> NcmDataset: dataset
        Dataset object
      priors-m2lnL -> NcmObjArray: priors-m2lnL
        Priors m2lnL array
      priors-f -> NcmObjArray: priors-f
        Priors f array
      m2lnL-v -> NcmVector: m2lnL-v
        m2lnL vector

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        dataset: Dataset
        m2lnL_v: Vector
        priors_f: ObjArray
        priors_m2lnL: ObjArray
    props: Props = ...
    parent_instance: GObject.Object = ...
    dset: Dataset = ...
    priors_f: ObjArray = ...
    priors_m2lnL: ObjArray = ...
    m2lnL_v: Vector = ...
    def __init__(self, dataset: Dataset = ...,
                 m2lnL_v: Vector = ...,
                 priors_f: ObjArray = ...,
                 priors_m2lnL: ObjArray = ...): ...
    @staticmethod
    def clear(lh: Likelihood) -> None: ...
    def dup(self, ser: Serialize) -> Likelihood: ...
    def free(self) -> None: ...
    def has_leastsquares_J(self) -> bool: ...
    def has_m2lnL_grad(self) -> bool: ...
    def leastsquares_J(self, mset: MSet, J: Matrix) -> None: ...
    def leastsquares_f(self, mset: MSet, f: Vector) -> None: ...
    def leastsquares_f_J(self, mset: MSet, f: Vector, J: Matrix) -> None: ...
    def m2lnL_grad(self, mset: MSet, grad: Vector) -> None: ...
    def m2lnL_val(self, mset: MSet) -> float: ...
    def m2lnL_val_grad(self, mset: MSet, grad: Vector) -> float: ...
    @classmethod
    def new(cls, dset: Dataset) -> Likelihood: ...
    def priors_add(self, prior: Prior) -> None: ...
    def priors_add_flat_func(self, mean_func: MSetFunc, x_low: float, x_upp: float, scale: float, variable: float) -> None: ...
    def priors_add_flat_param(self, mid: int, pid: int, x_low: float, x_upp: float, scale: float) -> None: ...
    def priors_add_flat_param_name(self, mset: MSet, name: str, x_low: float, x_upp: float, scale: float) -> None: ...
    def priors_add_flat_param_pindex(self, pi: MSetPIndex, x_low: float, x_upp: float, scale: float) -> None: ...
    def priors_add_gauss_func(self, mean_func: MSetFunc, mu: float, sigma: float, var: float) -> None: ...
    def priors_add_gauss_param(self, mid: int, pid: int, mu: float, sigma: float) -> None: ...
    def priors_add_gauss_param_name(self, mset: MSet, name: str, mu: float, sigma: float) -> None: ...
    def priors_add_gauss_param_pindex(self, pi: MSetPIndex, mu: float, sigma: float) -> None: ...
    def priors_leastsquares_f(self, mset: MSet, priors_f: Vector) -> None: ...
    def priors_length_f(self) -> int: ...
    def priors_length_m2lnL(self) -> int: ...
    def priors_m2lnL_val(self, mset: MSet) -> float: ...
    def priors_m2lnL_vec(self, mset: MSet, priors_m2lnL_v: Vector) -> None: ...
    def priors_peek_f(self, i: int) -> Prior: ...
    def priors_peek_m2lnL(self, i: int) -> Prior: ...
    def ref(self) -> Likelihood: ...
    

class LikelihoodClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        LikelihoodClass()
    """
    parent_class: GObject.ObjectClass = ...

class MPIJob(GObject.Object):
    r"""
    :Constructors:

    ::

        MPIJob(**properties)

    Object NcmMPIJob

    Properties from NcmMPIJob:
      placeholder -> guint: placeholder
        placeholder

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        placeholder: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: MPIJobPrivate = ...
    def __init__(self, placeholder: int = ...): ...
    @staticmethod
    def clear(mpi_job: MPIJob) -> None: ...
    def create_input(self) -> None: ...
    def create_return(self) -> None: ...
    def destroy_input(self, input: None) -> None: ...
    def destroy_input_buffer(self, input: None, buf: None) -> None: ...
    def destroy_return(self, ret: None) -> None: ...
    def destroy_return_buffer(self, ret: None, buf: None) -> None: ...
    def do_create_input(self) -> None: ...
    def do_create_return(self) -> None: ...
    def do_destroy_input(self, input: None) -> None: ...
    def do_destroy_input_buffer(self, input: None, buf: None) -> None: ...
    def do_destroy_return(self, ret: None) -> None: ...
    def do_destroy_return_buffer(self, ret: None, buf: None) -> None: ...
    def do_get_input_buffer(self, input: None) -> None: ...
    def do_get_return_buffer(self, ret: None) -> None: ...
    def do_input_datatype(self) -> Tuple[int, int]: ...
    def do_pack_input(self, input: None) -> None: ...
    def do_pack_return(self, ret: None) -> None: ...
    def do_return_datatype(self) -> Tuple[int, int]: ...
    def do_run(self, input: None, ret: None) -> None: ...
    def do_unpack_input(self, buf: None, input: None) -> None: ...
    def do_unpack_return(self, buf: None, ret: None) -> None: ...
    def do_work_clear(self) -> None: ...
    def do_work_init(self) -> None: ...
    def free(self) -> None: ...
    def free_all_slaves(self) -> None: ...
    def get_input_buffer(self, input: None) -> None: ...
    def get_return_buffer(self, ret: None) -> None: ...
    def init_all_slaves(self, ser: Serialize) -> None: ...
    def input_datatype(self) -> Tuple[int, int]: ...
    def pack_input(self, input: None) -> None: ...
    def pack_return(self, ret: None) -> None: ...
    def ref(self) -> MPIJob: ...
    def return_datatype(self) -> Tuple[int, int]: ...
    def run(self, input: None, ret: None) -> None: ...
    def run_array(self, input_array: Sequence[GObject.Object], ret_array: Sequence[GObject.Object]) -> None: ...
    def run_array_async(self, input_array: Sequence[GObject.Object], ret_array: Sequence[GObject.Object]) -> None: ...
    def unpack_input(self, buf: None, input: None) -> None: ...
    def unpack_return(self, buf: None, ret: None) -> None: ...
    def work_clear(self) -> None: ...
    def work_init(self) -> None: ...
    

class MPIJobClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MPIJobClass()
    """
    parent_class: GObject.ObjectClass = ...
    work_init: Callable[[MPIJob], None] = ...
    work_clear: Callable[[MPIJob], None] = ...
    input_datatype: Callable[[MPIJob], Tuple[int, int]] = ...
    return_datatype: Callable[[MPIJob], Tuple[int, int]] = ...
    create_input: Callable[[MPIJob], None] = ...
    create_return: Callable[[MPIJob], None] = ...
    destroy_input: Callable[[MPIJob, None], None] = ...
    destroy_return: Callable[[MPIJob, None], None] = ...
    get_input_buffer: Callable[[MPIJob, None], None] = ...
    get_return_buffer: Callable[[MPIJob, None], None] = ...
    destroy_input_buffer: Callable[[MPIJob, None, None], None] = ...
    destroy_return_buffer: Callable[[MPIJob, None, None], None] = ...
    pack_input: Callable[[MPIJob, None], None] = ...
    pack_return: Callable[[MPIJob, None], None] = ...
    unpack_input: Callable[[MPIJob, None, None], None] = ...
    unpack_return: Callable[[MPIJob, None, None], None] = ...
    run: Callable[[MPIJob, None, None], None] = ...

class MPIJobCtrl(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MPIJobCtrl()
    """
    initialized: int = ...
    rank: int = ...
    size: int = ...
    nslaves: int = ...
    working_slaves: int = ...

class MPIJobFEval(MPIJob):
    r"""
    :Constructors:

    ::

        MPIJobFEval(**properties)
        new(fit:NumCosmoMath.Fit, func_oa:list=None) -> NumCosmoMath.MPIJobFEval

    Object NcmMPIJobFEval

    Properties from NcmMPIJobFEval:
      fit -> NcmFit: fit
        Fit object
      function-array -> NcmObjArray: function-array
        Functions array

    Properties from NcmMPIJob:
      placeholder -> guint: placeholder
        placeholder

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        fit: Fit
        function_array: ObjArray
        placeholder: int
    props: Props = ...
    parent_instance: MPIJob = ...
    priv: MPIJobFEvalPrivate = ...
    def __init__(self, fit: Fit = ...,
                 function_array: ObjArray = ...,
                 placeholder: int = ...): ...
    @staticmethod
    def clear(mjfeval: MPIJobFEval) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, fit: Fit, func_oa: Optional[Sequence[MSetFunc]] = None) -> MPIJobFEval: ...
    def ref(self) -> MPIJobFEval: ...
    

class MPIJobFEvalClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MPIJobFEvalClass()
    """
    parent_class: MPIJobClass = ...

class MPIJobFEvalPrivate(GObject.GPointer): ...

class MPIJobFit(MPIJob):
    r"""
    :Constructors:

    ::

        MPIJobFit(**properties)
        new(fit:NumCosmoMath.Fit, func_oa:list=None) -> NumCosmoMath.MPIJobFit

    Object NcmMPIJobFit

    Properties from NcmMPIJobFit:
      fit -> NcmFit: fit
        Fit object
      function-array -> NcmObjArray: function-array
        Functions array

    Properties from NcmMPIJob:
      placeholder -> guint: placeholder
        placeholder

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        fit: Fit
        function_array: ObjArray
        placeholder: int
    props: Props = ...
    parent_instance: MPIJob = ...
    priv: MPIJobFitPrivate = ...
    def __init__(self, fit: Fit = ...,
                 function_array: ObjArray = ...,
                 placeholder: int = ...): ...
    @staticmethod
    def clear(mjfit: MPIJobFit) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, fit: Fit, func_oa: Optional[Sequence[MSetFunc]] = None) -> MPIJobFit: ...
    def ref(self) -> MPIJobFit: ...
    

class MPIJobFitClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MPIJobFitClass()
    """
    parent_class: MPIJobClass = ...

class MPIJobFitPrivate(GObject.GPointer): ...

class MPIJobMCMC(MPIJob):
    r"""
    :Constructors:

    ::

        MPIJobMCMC(**properties)
        new(fit:NumCosmoMath.Fit, func_oa:list=None) -> NumCosmoMath.MPIJobMCMC

    Object NcmMPIJobMCMC

    Properties from NcmMPIJobMCMC:
      fit -> NcmFit: fit
        Fit object
      function-array -> NcmObjArray: function-array
        Functions array

    Properties from NcmMPIJob:
      placeholder -> guint: placeholder
        placeholder

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        fit: Fit
        function_array: ObjArray
        placeholder: int
    props: Props = ...
    parent_instance: MPIJob = ...
    priv: MPIJobMCMCPrivate = ...
    def __init__(self, fit: Fit = ...,
                 function_array: ObjArray = ...,
                 placeholder: int = ...): ...
    @staticmethod
    def clear(mjmcmc: MPIJobMCMC) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, fit: Fit, func_oa: Optional[Sequence[MSetFunc]] = None) -> MPIJobMCMC: ...
    def ref(self) -> MPIJobMCMC: ...
    

class MPIJobMCMCClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MPIJobMCMCClass()
    """
    parent_class: MPIJobClass = ...

class MPIJobMCMCPrivate(GObject.GPointer): ...

class MPIJobPrivate(GObject.GPointer): ...

class MPIJobTest(MPIJob):
    r"""
    :Constructors:

    ::

        MPIJobTest(**properties)
        new() -> NumCosmoMath.MPIJobTest

    Object NcmMPIJobTest

    Properties from NcmMPIJobTest:
      vector -> NcmVector: vector
        vector

    Properties from NcmMPIJob:
      placeholder -> guint: placeholder
        placeholder

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        vector: Vector
        placeholder: int
    props: Props = ...
    parent_instance: MPIJob = ...
    priv: MPIJobTestPrivate = ...
    def __init__(self, vector: Vector = ...,
                 placeholder: int = ...): ...
    @staticmethod
    def clear(mjt: MPIJobTest) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls) -> MPIJobTest: ...
    def ref(self) -> MPIJobTest: ...
    def set_rand_vector(self, len: int, rng: RNG) -> None: ...
    

class MPIJobTestClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MPIJobTestClass()
    """
    parent_class: MPIJobClass = ...

class MPIJobTestPrivate(GObject.GPointer): ...

class MSet(GObject.Object):
    r"""
    :Constructors:

    ::

        MSet(**properties)
        empty_new() -> NumCosmoMath.MSet
        load(filename:str, ser:NumCosmoMath.Serialize) -> NumCosmoMath.MSet
        new_array(model_array:list) -> NumCosmoMath.MSet

    Object NcmMSet

    Properties from NcmMSet:
      valid-map -> gboolean: valid-map
        Valid properties map
      model-array -> NcmObjArray: model-array
        NcmModel array
      fmap -> GStrv: fmap
        Free params map

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        fmap: list[str]
        model_array: ObjArray
        valid_map: bool
    props: Props = ...
    parent_instance: GObject.Object = ...
    model_array: ObjArray = ...
    mid_item_hash: dict[None, None] = ...
    model_item_hash: dict[None, None] = ...
    fpi_hash: dict[None, None] = ...
    fullname_parray: list[None] = ...
    pi_array: list[None] = ...
    mid_array: list[None] = ...
    fullname_regex: GLib.Regex = ...
    valid_map: bool = ...
    total_len: int = ...
    fparam_len: int = ...
    temp_fparams: Vector = ...
    def __init__(self, fmap: Sequence[str] = ...,
                 model_array: ObjArray = ...,
                 valid_map: bool = ...): ...
    @staticmethod
    def clear(mset: MSet) -> None: ...
    def cmp(self, mset1: MSet, cmp_model: bool) -> bool: ...
    def cmp_all(self, mset1: MSet) -> int: ...
    def dup(self, ser: Serialize) -> MSet: ...
    @classmethod
    def empty_new(cls) -> MSet: ...
    def exists(self, model: Model) -> bool: ...
    def exists_pos(self, model: Model, stackpos_id: int) -> bool: ...
    def fparam_full_name(self, n: int) -> str: ...
    def fparam_get(self, n: int) -> float: ...
    def fparam_get_abstol(self, n: int) -> float: ...
    def fparam_get_bound_matrix(self) -> Matrix: ...
    def fparam_get_fpi(self, mid: int, pid: int) -> int: ...
    def fparam_get_lower_bound(self, n: int) -> float: ...
    def fparam_get_pi(self, n: int) -> MSetPIndex: ...
    def fparam_get_pi_by_name(self, name: str) -> MSetPIndex: ...
    def fparam_get_scale(self, n: int) -> float: ...
    def fparam_get_upper_bound(self, n: int) -> float: ...
    def fparam_name(self, n: int) -> str: ...
    def fparam_set(self, n: int, x: float) -> None: ...
    def fparam_set_scale(self, n: int, scale: float) -> None: ...
    def fparam_symbol(self, n: int) -> str: ...
    def fparam_valid_bounds(self, theta: Vector) -> bool: ...
    def fparam_valid_bounds_offset(self, theta: Vector, offset: int) -> bool: ...
    def fparam_validate_all(self, theta: Vector) -> bool: ...
    def fparams_get_vector(self, x: Vector) -> None: ...
    def fparams_get_vector_offset(self, x: Vector, offset: int) -> None: ...
    def fparams_len(self) -> int: ...
    def fparams_log_covar(self, covar: Matrix) -> None: ...
    def fparams_set_array(self, x: Sequence[float]) -> None: ...
    def fparams_set_vector(self, x: Vector) -> None: ...
    def fparams_set_vector_offset(self, x: Vector, offset: int) -> None: ...
    def free(self) -> None: ...
    def get(self, mid: int) -> Model: ...
    def get_fmap(self) -> list[str]: ...
    @staticmethod
    def get_id_by_ns(ns: str) -> int: ...
    @staticmethod
    def get_id_by_type(model_type: Type) -> int: ...
    def get_mid_array_pos(self, i: int) -> int: ...
    @staticmethod
    def get_ns_by_id(id: int) -> str: ...
    @staticmethod
    def get_type_by_id(id: int) -> Type: ...
    def is_subset(self, sub_mset: MSet) -> bool: ...
    @classmethod
    def load(cls, filename: str, ser: Serialize) -> MSet: ...
    def max_fparam_name(self) -> int: ...
    def max_model_nick(self) -> int: ...
    def max_param_name(self) -> int: ...
    @classmethod
    def new_array(cls, model_array: Sequence[Model]) -> MSet: ...
    def nmodels(self) -> int: ...
    def orig_param_get(self, mid: int, pid: int) -> float: ...
    def param_get(self, mid: int, pid: int) -> float: ...
    def param_get_abstol(self, mid: int, pid: int) -> float: ...
    def param_get_by_full_name(self, fullname: str) -> MSetPIndex: ...
    def param_get_ftype(self, mid: int, pid: int) -> ParamType: ...
    def param_get_lower_bound(self, mid: int, pid: int) -> float: ...
    def param_get_pi(self, pi: MSetPIndex, x: float, n: int) -> None: ...
    def param_get_scale(self, mid: int, pid: int) -> float: ...
    def param_get_upper_bound(self, mid: int, pid: int) -> float: ...
    def param_get_vector(self, params: Vector) -> None: ...
    def param_name(self, mid: int, pid: int) -> str: ...
    def param_set(self, mid: int, pid: int, x: float) -> None: ...
    def param_set0(self, mid: int, pid: int, x: float) -> None: ...
    def param_set_all_but_mid_ftype(self, mid: int, ftype: ParamType) -> None: ...
    def param_set_all_ftype(self, ftype: ParamType) -> None: ...
    def param_set_ftype(self, mid: int, pid: int, ftype: ParamType) -> None: ...
    def param_set_ftype_from_fmap(self) -> None: ...
    def param_set_mid_ftype(self, mid: int, ftype: ParamType) -> None: ...
    def param_set_mset(self, mset_src: MSet) -> None: ...
    def param_set_pi(self, pi: Sequence[MSetPIndex], x: Sequence[float]) -> None: ...
    def param_set_scale(self, mid: int, pid: int, scale: float) -> None: ...
    def param_set_vector(self, params: Vector) -> None: ...
    def param_symbol(self, mid: int, pid: int) -> str: ...
    def params_log_vals(self) -> None: ...
    def params_pretty_print(self, out: int, header: str) -> None: ...
    def params_print_vals(self, out: int) -> None: ...
    def params_valid(self) -> bool: ...
    def params_valid_bounds(self) -> bool: ...
    def peek(self, mid: int) -> Model: ...
    def peek_array_pos(self, i: int) -> Model: ...
    def peek_pos(self, base_mid: int, stackpos_id: int) -> Model: ...
    def prepare_fparam_map(self) -> None: ...
    def pretty_log(self) -> None: ...
    def push(self, model: Model) -> None: ...
    def ref(self) -> MSet: ...
    def remove(self, mid: int) -> None: ...
    def save(self, ser: Serialize, filename: str, save_comment: bool) -> None: ...
    def set(self, model: Model) -> None: ...
    def set_fmap(self, fmap: Sequence[str], update_models: bool) -> None: ...
    def set_pos(self, model: Model, stackpos_id: int) -> None: ...
    def shallow_copy(self) -> MSet: ...
    

class MSetCatalog(GObject.Object):
    r"""
    :Constructors:

    ::

        MSetCatalog(**properties)
        new_array(mset:NumCosmoMath.MSet, nadd_vals:int, nchains:int, weighted:bool, names:list, symbols:list) -> NumCosmoMath.MSetCatalog
        new_from_file(filename:str, burnin:int) -> NumCosmoMath.MSetCatalog
        new_from_file_ro(filename:str, burnin:int) -> NumCosmoMath.MSetCatalog

    Object NcmMSetCatalog

    Properties from NcmMSetCatalog:
      mset -> NcmMSet: mset
        NcmMSet object
      nadd-vals -> guint: nadd-vals
        Number of additional values
      nadd-val-names -> GStrv: nadd-val-names
        Additional value names
      nadd-val-symbols -> GStrv: nadd-val-symbols
        Additional value symbols
      m2lnp-var -> gint: m2lnp-var
        Index of the variable representing m2lnp
      weighted -> gboolean: weighted
        Catalog with weighted rows
      nchains -> guint: nchains
        Number of different chains in the catalog
      burnin -> glong: burnin
        Burn-in size
      tau-method -> NcmMSetCatalogTauMethod: tau-method
        Method used to calculate the autocorrelation time
      rng -> NcmRNG: rng
        Random number generator object
      filename -> gchararray: filename
        Catalog filename
      run-type-string -> gchararray: run-type-string
        Run type string
      smode -> NcmMSetCatalogSync: smode
        Catalog sync mode
      sync-interval -> gdouble: sync-interval
        Data sync interval
      read-only -> gboolean: read-only
        If the fits catalogue must be open in the readonly mode

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        burnin: int
        filename: str
        m2lnp_var: int
        mset: MSet
        nadd_val_names: list[str]
        nadd_val_symbols: list[str]
        nadd_vals: int
        nchains: int
        read_only: bool
        rng: Optional[RNG]
        run_type_string: str
        smode: MSetCatalogSync
        sync_interval: float
        tau_method: MSetCatalogTauMethod
        weighted: bool
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: MSetCatalogPrivate = ...
    def __init__(self, burnin: int = ...,
                 filename: str = ...,
                 m2lnp_var: int = ...,
                 mset: MSet = ...,
                 nadd_val_names: Sequence[str] = ...,
                 nadd_val_symbols: Sequence[str] = ...,
                 nadd_vals: int = ...,
                 nchains: int = ...,
                 read_only: bool = ...,
                 rng: RNG = ...,
                 run_type_string: str = ...,
                 smode: MSetCatalogSync = ...,
                 sync_interval: float = ...,
                 tau_method: MSetCatalogTauMethod = ...,
                 weighted: bool = ...): ...
    def add_from_mset_array(self, mset: MSet, ax: Sequence[float]) -> None: ...
    def add_from_vector(self, vals: Vector) -> None: ...
    def add_from_vector_array(self, vals: Vector, ax: Sequence[float]) -> None: ...
    def calc_add_param_distrib(self, add_param: int, mtype: FitRunMsgs) -> StatsDist1d: ...
    def calc_add_param_ensemble_evol(self, add_param: int, nsteps: int, mtype: FitRunMsgs) -> Tuple[Vector, Matrix]: ...
    def calc_ci_direct(self, func: MSetFunc, x_v: Vector, p_val: Sequence[float]) -> Matrix: ...
    def calc_ci_interp(self, func: MSetFunc, x_v: Vector, p_val: Sequence[float], nodes: int, mtype: FitRunMsgs) -> Matrix: ...
    def calc_const_break(self, p: int, mtype: FitRunMsgs) -> int: ...
    def calc_distrib(self, func: MSetFunc, mtype: FitRunMsgs) -> StatsDist1d: ...
    def calc_heidel_diag(self, ntests: int, pvalue: float, mtype: FitRunMsgs) -> int: ...
    def calc_max_ess_time(self, ntests: int, mtype: FitRunMsgs) -> Tuple[int, float]: ...
    def calc_param_distrib(self, pi: MSetPIndex, mtype: FitRunMsgs) -> StatsDist1d: ...
    def calc_param_ensemble_evol(self, pi: MSetPIndex, nsteps: int, mtype: FitRunMsgs) -> Tuple[Vector, Matrix]: ...
    def calc_pvalue(self, func: MSetFunc, x_v: Vector, lim: Sequence[float], nodes: int, mtype: FitRunMsgs) -> Matrix: ...
    @staticmethod
    def clear(mcat: MSetCatalog) -> None: ...
    def col_by_name(self, name: str) -> Tuple[bool, int]: ...
    def col_name(self, i: int) -> str: ...
    def col_symb(self, i: int) -> str: ...
    def erase_data(self) -> None: ...
    def estimate_autocorrelation_tau(self, force_single_chain: bool) -> None: ...
    def free(self) -> None: ...
    def get_bestfit_m2lnL(self) -> float: ...
    def get_bestfit_row(self) -> Vector: ...
    def get_burnin(self) -> int: ...
    def get_covar(self) -> Matrix: ...
    def get_cur_id(self) -> int: ...
    def get_first_id(self) -> int: ...
    def get_full_covar(self) -> Matrix: ...
    def get_m2lnp_var(self) -> int: ...
    def get_mean(self) -> Vector: ...
    def get_mset(self) -> MSet: ...
    def get_nth_m2lnL_percentile(self, p: float) -> Tuple[float, int]: ...
    def get_param_shrink_factor(self, p: int) -> float: ...
    def get_post_lnnorm(self) -> Tuple[float, float]: ...
    def get_post_lnvol(self, level: float) -> Tuple[float, float]: ...
    def get_rng(self) -> Optional[RNG]: ...
    def get_row_from_time(self, t: int) -> int: ...
    def get_run_type(self) -> str: ...
    def get_shrink_factor(self) -> float: ...
    def get_tau_method(self) -> MSetCatalogTauMethod: ...
    def heidel_diag_by_chain(self, ntests: int, pvalue: float, mtype: FitRunMsgs) -> Tuple[int, float]: ...
    def is_empty(self) -> bool: ...
    def largest_error(self) -> float: ...
    def len(self) -> int: ...
    def log_current_chain_stats(self) -> None: ...
    def log_current_stats(self) -> None: ...
    def log_full_covar(self) -> None: ...
    def max_ess_time_by_chain(self, ntests: int, mtype: FitRunMsgs) -> Tuple[int, float]: ...
    def max_time(self) -> int: ...
    def nadd_vals(self) -> int: ...
    def nchains(self) -> int: ...
    def ncols(self) -> int: ...
    @classmethod
    def new_array(cls, mset: MSet, nadd_vals: int, nchains: int, weighted: bool, names: Sequence[str], symbols: Sequence[str]) -> MSetCatalog: ...
    @classmethod
    def new_from_file(cls, filename: str, burnin: int) -> MSetCatalog: ...
    @classmethod
    def new_from_file_ro(cls, filename: str, burnin: int) -> MSetCatalog: ...
    def param_pdf(self, i: int) -> None: ...
    def param_pdf_pvalue(self, pvalue: float, both: bool) -> float: ...
    def peek_accept_ratio_array(self) -> list[float]: ...
    def peek_autocorrelation_tau(self) -> Vector: ...
    def peek_chain_pstats(self, i: int) -> StatsVec: ...
    def peek_current_e_mean(self) -> Vector: ...
    def peek_current_e_var(self) -> Vector: ...
    def peek_current_row(self) -> Vector: ...
    def peek_e_mean_stats(self) -> StatsVec: ...
    def peek_e_mean_t(self, t: int) -> Vector: ...
    def peek_e_var_t(self, t: int) -> Vector: ...
    def peek_filename(self) -> str: ...
    def peek_mset(self) -> MSet: ...
    def peek_pstats(self) -> StatsVec: ...
    def peek_rng(self) -> Optional[RNG]: ...
    def peek_row(self, i: int) -> Vector: ...
    def ref(self) -> MSetCatalog: ...
    def remove_last_ensemble(self) -> None: ...
    def reset(self) -> None: ...
    def reset_stats(self) -> None: ...
    def set_burnin(self, burnin: int) -> None: ...
    def set_file(self, filename: str) -> None: ...
    def set_first_id(self, first_id: int) -> None: ...
    def set_m2lnp_var(self, p: int) -> None: ...
    def set_rng(self, rng: RNG) -> None: ...
    def set_run_type(self, rtype_str: str) -> None: ...
    def set_sync_interval(self, interval: float) -> None: ...
    def set_sync_mode(self, smode: MSetCatalogSync) -> None: ...
    def set_tau_method(self, tau_method: MSetCatalogTauMethod) -> None: ...
    def sync(self, check: bool) -> None: ...
    def timed_sync(self, check: bool) -> None: ...
    def trim(self, tc: int, thin: int) -> None: ...
    def trim_by_type(self, ntests: int, trim_type: MSetCatalogTrimType, mtype: FitRunMsgs) -> None: ...
    def trim_oob(self, out_file: str) -> int: ...
    def trim_p(self, p: float) -> None: ...
    def weighted(self) -> bool: ...
    

class MSetCatalogClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetCatalogClass()
    """
    parent_class: GObject.ObjectClass = ...

class MSetCatalogPrivate(GObject.GPointer): ...

class MSetClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetClass()
    """
    parent_class: GObject.ObjectClass = ...
    ns_table: dict[None, None] = ...
    model_desc_array: list[None] = ...

class MSetFunc(GObject.Object):
    r"""
    :Constructors:

    ::

        MSetFunc(**properties)

    Object NcmMSetFunc

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    nvar: int = ...
    dim: int = ...
    eval_x: Vector = ...
    name: str = ...
    symbol: str = ...
    ns: str = ...
    desc: str = ...
    uname: str = ...
    usymbol: str = ...
    diff: Diff = ...
    def __init__(self, dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def array_new() -> list[MSetFunc]: ...
    @staticmethod
    def clear(func: MSetFunc) -> None: ...
    def do_eval(self, mset: MSet, x: Sequence[float], res: Sequence[float]) -> None: ...
    def eval(self, mset: MSet, x: Sequence[float], res: Sequence[float]) -> None: ...
    def eval0(self, mset: MSet) -> float: ...
    def eval1(self, mset: MSet, x: float) -> float: ...
    def eval_nvar(self, mset: MSet, x: float) -> float: ...
    def eval_vector(self, mset: MSet, x_v: Vector, res_v: Vector) -> None: ...
    def free(self) -> None: ...
    def get_dim(self) -> int: ...
    def get_nvar(self) -> int: ...
    def has_nvar(self, nvar: int) -> bool: ...
    def is_const(self) -> bool: ...
    def is_scalar(self) -> bool: ...
    def is_vector(self, dim: int) -> bool: ...
    def numdiff_fparams(self, mset: MSet, x: float) -> Vector: ...
    def peek_desc(self) -> str: ...
    def peek_name(self) -> str: ...
    def peek_ns(self) -> str: ...
    def peek_symbol(self) -> str: ...
    def peek_uname(self) -> str: ...
    def peek_usymbol(self) -> str: ...
    def ref(self) -> MSetFunc: ...
    def set_eval_x(self, x: Sequence[float]) -> None: ...
    

class MSetFunc1(MSetFunc):
    r"""
    :Constructors:

    ::

        MSetFunc1(**properties)

    Object NcmMSetFunc1

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: MSetFunc = ...
    priv: MSetFunc1Private = ...
    def __init__(self, dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def clear(f1: MSetFunc1) -> None: ...
    def do_eval1(self, mset: MSet, x: Sequence[float]) -> list[float]: ...
    def eval1(self, mset: MSet, x: Sequence[float]) -> list[float]: ...
    def free(self) -> None: ...
    def ref(self) -> MSetFunc1: ...
    

class MSetFunc1Class(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetFunc1Class()
    """
    parent_class: MSetFuncClass = ...
    eval1: Callable[[MSetFunc1, MSet, Sequence[float]], list[float]] = ...

class MSetFunc1Private(GObject.GPointer): ...

class MSetFuncClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetFuncClass()
    """
    parent_class: GObject.ObjectClass = ...
    eval: Callable[[MSetFunc, MSet, Sequence[float], Sequence[float]], None] = ...

class MSetFuncList(MSetFunc):
    r"""
    :Constructors:

    ::

        MSetFuncList(**properties)
        new(full_name:str, obj:GObject.Object=None) -> NumCosmoMath.MSetFuncList
        new_ns_name(ns:str, name:str, obj:GObject.Object=None) -> NumCosmoMath.MSetFuncList

    Object NcmMSetFuncList

    Properties from NcmMSetFuncList:
      full-name -> gchararray: full-name
        Namespace and function name
      object -> GObject: object
        object

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        full_name: str
        object: GObject.Object
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: MSetFunc = ...
    obj_type: Type = ...
    func: Callable[[MSetFuncList, MSet, float, float], None] = ...
    obj: GObject.Object = ...
    def __init__(self, full_name: str = ...,
                 object: GObject.Object = ...,
                 dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def has_full_name(full_name: str) -> bool: ...
    @staticmethod
    def has_ns_name(ns: str, name: str) -> bool: ...
    @classmethod
    def new(cls, full_name: str, obj: Optional[GObject.Object] = None) -> MSetFuncList: ...
    @classmethod
    def new_ns_name(cls, ns: str, name: str, obj: Optional[GObject.Object] = None) -> MSetFuncList: ...
    @staticmethod
    def register(name: str, symbol: str, ns: str, desc: str, obj_type: Type, func: Callable[[MSetFuncList, MSet, float, float], None], nvar: int, dim: int) -> None: ...
    @staticmethod
    def select(ns: Optional[str], nvar: int, dim: int) -> list[MSetFuncListStruct]: ...
    

class MSetFuncListClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetFuncListClass()
    """
    parent_class: MSetFuncClass = ...
    func_array: list[None] = ...
    ns_hash: dict[None, None] = ...

class MSetFuncListStruct(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetFuncListStruct()
    """
    name: str = ...
    symbol: str = ...
    ns: str = ...
    desc: str = ...
    obj_type: Type = ...
    func: Callable[[MSetFuncList, MSet, float, float], None] = ...
    nvar: int = ...
    dim: int = ...
    pos: int = ...

class MSetModelDesc(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetModelDesc()
    """
    init: bool = ...
    ns: str = ...
    desc: str = ...
    long_desc: str = ...

class MSetPIndex(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        MSetPIndex()
        new(mid:int, pid:int) -> NumCosmoMath.MSetPIndex
    """
    mid: int = ...
    pid: int = ...
    def dup(self) -> MSetPIndex: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, mid: int, pid: int) -> MSetPIndex: ...
    

class MSetTransKern(GObject.Object):
    r"""
    :Constructors:

    ::

        MSetTransKern(**properties)

    Object NcmMSetTransKern

    Properties from NcmMSetTransKern:
      mset -> NcmMSet: mset
        NcmMSet

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        mset: MSet
    props: Props = ...
    parent_instance: GObject.Object = ...
    mset: MSet = ...
    theta: Vector = ...
    def __init__(self, mset: MSet = ...): ...
    @staticmethod
    def clear(tkern: MSetTransKern) -> None: ...
    def do_generate(self, theta: Vector, thetastar: Vector, rng: RNG) -> None: ...
    def do_get_name(self) -> str: ...
    def do_pdf(self, theta: Vector, thetastar: Vector) -> float: ...
    def do_reset(self) -> None: ...
    def do_set_mset(self, mset: MSet) -> None: ...
    def free(self) -> None: ...
    def generate(self, theta: Vector, thetastar: Vector, rng: RNG) -> None: ...
    def get_name(self) -> str: ...
    def pdf(self, theta: Vector, thetastar: Vector) -> float: ...
    def prior_pdf(self, thetastar: Vector) -> float: ...
    def prior_sample(self, thetastar: Vector, rng: RNG) -> None: ...
    def ref(self) -> MSetTransKern: ...
    def reset(self) -> None: ...
    def set_mset(self, mset: MSet) -> None: ...
    def set_prior(self, theta: Vector) -> None: ...
    def set_prior_from_mset(self) -> None: ...
    

class MSetTransKernCat(MSetTransKern):
    r"""
    :Constructors:

    ::

        MSetTransKernCat(**properties)
        new(mcat:NumCosmoMath.MSetCatalog, sd:NumCosmoMath.StatsDist=None) -> NumCosmoMath.MSetTransKernCat

    Object NcmMSetTransKernCat

    Properties from NcmMSetTransKernCat:
      catalog -> NcmMSetCatalog: catalog
        catalog
      stats-dist -> NcmStatsDist: stats-dist
        NcmStatsDist object
      sampling-type -> NcmMSetTransKernCatSampling: sampling-type
        Sampling method to use
      m2lnL-reltol -> gdouble: m2lnL-reltol
        Relative tolerance for m2lnL
      choose-cut -> gboolean: choose-cut
        Whether to cut the catalog at the choose-percentile before choosing
      choose-percentile -> gdouble: choose-percentile
        Max percentile to choose from

    Properties from NcmMSetTransKern:
      mset -> NcmMSet: mset
        NcmMSet

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        catalog: MSetCatalog
        choose_cut: bool
        choose_percentile: float
        m2lnL_reltol: float
        sampling_type: MSetTransKernCatSampling
        stats_dist: StatsDist
        mset: MSet
    props: Props = ...
    parent_instance: MSetTransKern = ...
    priv: MSetTransKernCatPrivate = ...
    def __init__(self, catalog: MSetCatalog = ...,
                 choose_cut: bool = ...,
                 choose_percentile: float = ...,
                 m2lnL_reltol: float = ...,
                 sampling_type: MSetTransKernCatSampling = ...,
                 stats_dist: StatsDist = ...,
                 mset: MSet = ...): ...
    def get_sampling(self) -> MSetTransKernCatSampling: ...
    @classmethod
    def new(cls, mcat: MSetCatalog, sd: Optional[StatsDist] = None) -> MSetTransKernCat: ...
    def reset(self) -> None: ...
    def set_sampling(self, sampling: MSetTransKernCatSampling) -> None: ...
    

class MSetTransKernCatClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetTransKernCatClass()
    """
    parent_class: MSetTransKernClass = ...

class MSetTransKernCatPrivate(GObject.GPointer): ...

class MSetTransKernClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetTransKernClass()
    """
    parent_class: GObject.ObjectClass = ...
    bernoulli_scheme: bool = ...
    set_mset: Callable[[MSetTransKern, MSet], None] = ...
    generate: Callable[[MSetTransKern, Vector, Vector, RNG], None] = ...
    pdf: Callable[[MSetTransKern, Vector, Vector], float] = ...
    reset: Callable[[MSetTransKern], None] = ...
    get_name: Callable[[MSetTransKern], str] = ...

class MSetTransKernFlat(MSetTransKern):
    r"""
    :Constructors:

    ::

        MSetTransKernFlat(**properties)
        new() -> NumCosmoMath.MSetTransKernFlat

    Object NcmMSetTransKernFlat

    Properties from NcmMSetTransKern:
      mset -> NcmMSet: mset
        NcmMSet

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        mset: MSet
    props: Props = ...
    parent_instance: MSetTransKern = ...
    parea: float = ...
    def __init__(self, mset: MSet = ...): ...
    @classmethod
    def new(cls) -> MSetTransKernFlat: ...
    

class MSetTransKernFlatClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetTransKernFlatClass()
    """
    parent_class: MSetTransKernClass = ...

class MSetTransKernGauss(MSetTransKern):
    r"""
    :Constructors:

    ::

        MSetTransKernGauss(**properties)
        new(len:int) -> NumCosmoMath.MSetTransKernGauss

    Object NcmMSetTransKernGauss

    Properties from NcmMSetTransKernGauss:
      length -> guint: length
        length
      cov -> NcmMatrix: cov
        covariance

    Properties from NcmMSetTransKern:
      mset -> NcmMSet: mset
        NcmMSet

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        cov: Matrix
        length: int
        mset: MSet
    props: Props = ...
    parent_instance: MSetTransKern = ...
    len: int = ...
    cov: Matrix = ...
    LLT: Matrix = ...
    v: Vector = ...
    init: bool = ...
    def __init__(self, cov: Matrix = ...,
                 length: int = ...,
                 mset: MSet = ...): ...
    def get_cov(self) -> Matrix: ...
    def get_size(self) -> int: ...
    @classmethod
    def new(cls, len: int) -> MSetTransKernGauss: ...
    def set_cov(self, cov: Matrix) -> None: ...
    def set_cov_from_rescale(self, epsilon: float) -> None: ...
    def set_cov_from_scale(self) -> None: ...
    def set_cov_variant(self, cov: GLib.Variant) -> None: ...
    def set_size(self, len: int) -> None: ...
    

class MSetTransKernGaussClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MSetTransKernGaussClass()
    """
    parent_class: MSetTransKernClass = ...

class Matrix(GObject.Object):
    r"""
    :Constructors:

    ::

        Matrix(**properties)
        const_new_data(d:float, nrows:int, ncols:int) -> NumCosmoMath.Matrix
        const_new_variant(var:GLib.Variant) -> NumCosmoMath.Matrix
        new(nrows:int, ncols:int) -> NumCosmoMath.Matrix
        new_array(a:list, ncols:int) -> NumCosmoMath.Matrix
        new_full(d:float, nrows:int, ncols:int, tda:int, pdata=None, pfree:GLib.DestroyNotify=None) -> NumCosmoMath.Matrix
        new_variant(var:GLib.Variant) -> NumCosmoMath.Matrix

    Object NcmMatrix

    Properties from NcmMatrix:
      values -> GVariant: values
        values

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        values: GLib.Variant
    props: Props = ...
    parent_instance: GObject.Object = ...
    mv: int = ...
    pdata: None = ...
    pfree: Callable[[None], None] = ...
    type: MatrixInternal = ...
    def __init__(self, values: GLib.Variant = ...): ...
    def add(self, cm2: Matrix) -> None: ...
    def add_constant(self, val: float) -> None: ...
    def add_mul(self, a: float, cm2: Matrix) -> None: ...
    def addto(self, i: int, j: int, val: float) -> None: ...
    def as_vector(self) -> Vector: ...
    def cholesky_decomp(self, UL: int) -> int: ...
    def cholesky_inverse(self, UL: int) -> int: ...
    def cholesky_lndet(self) -> float: ...
    def cholesky_solve(self, b: Vector, UL: int) -> int: ...
    def cholesky_solve2(self, b: Vector, UL: int) -> int: ...
    @staticmethod
    def clear(cm: Matrix) -> None: ...
    def cmp(self, cm2: Matrix, scale: float) -> float: ...
    def cmp_diag(self, cm2: Matrix, scale: float) -> float: ...
    def col_len(self) -> int: ...
    def const_data(self) -> float: ...
    def const_free(self) -> None: ...
    @classmethod
    def const_new_data(cls, d: float, nrows: int, ncols: int) -> Matrix: ...
    @classmethod
    def const_new_variant(cls, var: GLib.Variant) -> Matrix: ...
    def const_ptr(self, i: int, j: int) -> float: ...
    def copy_triangle(self, UL: int) -> None: ...
    def cov2cor(self, cor: Matrix) -> None: ...
    def cov_dup_cor(self) -> Matrix: ...
    def data(self) -> float: ...
    def dgemm(self, TransA: int, TransB: int, alpha: float, A: Matrix, B: Matrix, beta: float) -> None: ...
    def div_elements(self, cm2: Matrix) -> None: ...
    def dsymm(self, UL: int, alpha: float, A: Matrix, B: Matrix, beta: float) -> None: ...
    def dup(self) -> Matrix: ...
    def dup_array(self) -> list[float]: ...
    def fast_get(self, ij: int) -> float: ...
    def fast_set(self, ij: int, val: float) -> None: ...
    def fill_rand_cor(self, cor_level: float, rng: RNG) -> None: ...
    def fill_rand_cov(self, sigma_min: float, sigma_max: float, cor_level: float, rng: RNG) -> None: ...
    def fill_rand_cov2(self, mu: Vector, reltol_min: float, reltol_max: float, cor_level: float, rng: RNG) -> None: ...
    def free(self) -> None: ...
    def get(self, i: int, j: int) -> float: ...
    def get_array(self) -> list[float]: ...
    def get_col(self, col: int) -> Vector: ...
    def get_colmajor(self, i: int, j: int) -> float: ...
    def get_diag(self, diag: Vector) -> None: ...
    def get_row(self, row: int) -> Vector: ...
    def get_submatrix(self, k1: int, k2: int, nrows: int, ncols: int) -> Matrix: ...
    def get_variant(self) -> GLib.Variant: ...
    def log_vals(self, prefix: str, format: str) -> None: ...
    def memcpy(self, cm2: Matrix) -> None: ...
    def memcpy_to_colmajor(self, cm2: Matrix) -> None: ...
    def mul_col(self, col_i: int, val: float) -> None: ...
    def mul_elements(self, cm2: Matrix) -> None: ...
    def mul_row(self, row_i: int, val: float) -> None: ...
    def ncols(self) -> int: ...
    def nearPD(self, UL: int, cholesky_decomp: bool, maxiter: int) -> int: ...
    @classmethod
    def new(cls, nrows: int, ncols: int) -> Matrix: ...
    @staticmethod
    def new0(nrows: int, ncols: int) -> Matrix: ...
    @classmethod
    def new_array(cls, a: Sequence[float], ncols: int) -> Matrix: ...
    @classmethod
    def new_full(cls, d: float, nrows: int, ncols: int, tda: int, pdata: None, pfree: Optional[Callable[[None], None]] = None) -> Matrix: ...
    @classmethod
    def new_variant(cls, var: GLib.Variant) -> Matrix: ...
    def nrows(self) -> int: ...
    def peek_variant(self) -> GLib.Variant: ...
    def ptr(self, i: int, j: int) -> float: ...
    def ref(self) -> Matrix: ...
    def row_len(self) -> int: ...
    def scale(self, val: float) -> None: ...
    def set(self, i: int, j: int, val: float) -> None: ...
    def set_all(self, val: float) -> None: ...
    def set_col(self, n: int, cv: Vector) -> None: ...
    def set_colmajor(self, i: int, j: int, val: float) -> None: ...
    def set_diag(self, diag: Vector) -> None: ...
    def set_from_array(self, a: Sequence[float]) -> None: ...
    def set_from_data(self, data: Sequence[float]) -> None: ...
    def set_from_variant(self, var: GLib.Variant) -> None: ...
    def set_identity(self) -> None: ...
    def set_row(self, n: int, cv: Vector) -> None: ...
    def set_zero(self) -> None: ...
    def size(self) -> int: ...
    def square_to_sym(self, NT: int, UL: int, sym: Matrix) -> None: ...
    def sub(self, cm2: Matrix) -> None: ...
    @staticmethod
    def substitute(cm: Matrix, nm: Optional[Matrix], check_size: bool) -> None: ...
    def sym_exp_cholesky(self, UL: int, exp_cm_dec: Matrix) -> None: ...
    def sym_posdef_log(self, UL: int, ln_cm: Matrix) -> None: ...
    def sym_update_vector(self, UL: int, alpha: float, v: Vector, beta: float, u: Vector) -> None: ...
    def tda(self) -> int: ...
    def transpose(self) -> None: ...
    def transpose_memcpy(self, src: Matrix) -> None: ...
    def triang_to_sym(self, UL: int, zero: bool, sym: Matrix) -> None: ...
    def update_vector(self, NT: int, alpha: float, v: Vector, beta: float, u: Vector) -> None: ...
    

class MatrixClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MatrixClass()
    """
    parent_class: GObject.ObjectClass = ...

class MemoryPool(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MemoryPool()
    """
    update: GLib.Mutex = ...
    finish: GLib.Cond = ...
    slices_in_use: int = ...
    slices: list[None] = ...
    alloc: Callable[[None], None] = ...
    free: Callable[[None], None] = ...
    userdata: None = ...
    def add(self, p: None) -> None: ...
    def empty(self, free_slices: bool) -> int: ...
    def free(self, free_slices: bool) -> None: ...
    def get(self) -> None: ...
    @staticmethod
    def return_(p: None) -> None: ...
    def set_min_size(self, n: int) -> None: ...
    

class MemoryPoolSlice(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MemoryPoolSlice()
    """
    p: None = ...
    in_use: bool = ...
    mp: MemoryPool = ...

class Model(GObject.Object):
    r"""
    :Constructors:

    ::

        Model(**properties)

    Object NcmModel

    Properties from NcmModel:
      name -> gchararray: name
        Model's name
      nick -> gchararray: nick
        Model's nick
      scalar-params-len -> guint: scalar-params-len
        Number of scalar parameters
      vector-params-len -> guint: vector-params-len
        Number of vector parameters
      implementation -> guint64: implementation
        Bitwise specification of functions implementation
      sparam-array -> NcmObjArray: sparam-array
        NcmModel array of NcmSParam
      params-types -> GArray: params-types
        Parameters' types
      reparam -> NcmReparam: reparam
        Model reparametrization
      submodel-array -> NcmObjArray: submodel-array
        NcmModel array of submodels

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        implementation: int
        name: str
        nick: str
        params_types: list[None]
        reparam: Reparam
        scalar_params_len: int
        sparam_array: ObjArray
        submodel_array: ObjArray
        vector_params_len: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    reparam: Reparam = ...
    sparams: ObjArray = ...
    params: Vector = ...
    p: Vector = ...
    vparam_pos: list[None] = ...
    vparam_len: list[None] = ...
    ptypes: list[None] = ...
    sparams_name_id: dict[None, None] = ...
    submodel_mid_pos: dict[None, None] = ...
    submodel_array: list[None] = ...
    total_len: int = ...
    pkey: int = ...
    skey: int = ...
    slkey: list[int] = ...
    def __init__(self, reparam: Reparam = ...,
                 sparam_array: ObjArray = ...,
                 submodel_array: ObjArray = ...): ...
    def add_params(self, sparam_len: int, vparam_len: int, nonparam_prop_len: int) -> None: ...
    def add_submodel(self, submodel: Model) -> None: ...
    def check_impl_flag(self, impl: int) -> bool: ...
    def check_impl_opt(self, opt: int) -> bool: ...
    def check_params_info(self) -> None: ...
    @staticmethod
    def clear(model: Model) -> None: ...
    def do_add_submodel(self, submodel: Model) -> None: ...
    def do_valid(self) -> bool: ...
    def dup(self, ser: Serialize) -> Model: ...
    def free(self) -> None: ...
    def get_submodel_len(self) -> int: ...
    def id(self) -> int: ...
    @staticmethod
    def id_by_type(model_type: Type) -> int: ...
    def is_equal(self, model2: Model) -> bool: ...
    def is_submodel(self) -> bool: ...
    def len(self) -> int: ...
    def lstate_is_update(self, i: int) -> bool: ...
    def lstate_set_update(self, i: int) -> None: ...
    def main_model(self) -> int: ...
    def name(self) -> str: ...
    def nick(self) -> str: ...
    def orig_param_get(self, n: int) -> float: ...
    def orig_param_get_abstol(self, n: int) -> float: ...
    def orig_param_get_by_name(self, param_name: str) -> float: ...
    def orig_param_get_lower_bound(self, n: int) -> float: ...
    def orig_param_get_scale(self, n: int) -> float: ...
    def orig_param_get_upper_bound(self, n: int) -> float: ...
    def orig_param_index_from_name(self, param_name: str) -> Tuple[bool, int]: ...
    def orig_param_name(self, n: int) -> str: ...
    def orig_param_set(self, n: int, val: float) -> None: ...
    def orig_param_set_by_name(self, param_name: str, val: float) -> None: ...
    def orig_param_symbol(self, n: int) -> str: ...
    def orig_params_log_all(self) -> None: ...
    def orig_params_peek_vector(self) -> Vector: ...
    def orig_params_update(self) -> None: ...
    def orig_vparam_get(self, n: int, i: int) -> float: ...
    def orig_vparam_get_vector(self, n: int) -> Vector: ...
    def orig_vparam_set(self, n: int, i: int, val: float) -> None: ...
    def orig_vparam_set_vector(self, n: int, val: Vector) -> None: ...
    def param_finite(self, i: int) -> bool: ...
    def param_get(self, n: int) -> float: ...
    def param_get_abstol(self, n: int) -> float: ...
    def param_get_by_name(self, param_name: str) -> float: ...
    def param_get_ftype(self, n: int) -> ParamType: ...
    def param_get_lower_bound(self, n: int) -> float: ...
    def param_get_scale(self, n: int) -> float: ...
    def param_get_upper_bound(self, n: int) -> float: ...
    def param_index_from_name(self, param_name: str) -> Tuple[bool, int]: ...
    def param_name(self, n: int) -> str: ...
    def param_names(self) -> list[str]: ...
    def param_peek_desc(self, n: int) -> SParam: ...
    def param_set(self, n: int, val: float) -> None: ...
    def param_set0(self, n: int, val: float) -> None: ...
    def param_set_abstol(self, n: int, abstol: float) -> None: ...
    def param_set_by_name(self, param_name: str, val: float) -> None: ...
    def param_set_default(self, n: int) -> None: ...
    def param_set_ftype(self, n: int, ptype: ParamType) -> None: ...
    def param_set_lower_bound(self, n: int, lb: float) -> None: ...
    def param_set_scale(self, n: int, scale: float) -> None: ...
    def param_set_upper_bound(self, n: int, ub: float) -> None: ...
    def param_symbol(self, n: int) -> str: ...
    def params_copyto(self, model_dest: Model) -> None: ...
    def params_finite(self) -> bool: ...
    def params_get_all(self) -> Vector: ...
    def params_log_all(self) -> None: ...
    def params_save_as_default(self) -> None: ...
    def params_set_all_data(self, data: float) -> None: ...
    def params_set_default(self) -> None: ...
    def params_set_default_ftype(self) -> None: ...
    def params_set_model(self, model_src: Model) -> None: ...
    def params_set_vector(self, v: Vector) -> None: ...
    def params_update(self) -> None: ...
    def params_valid(self) -> bool: ...
    def params_valid_bounds(self) -> bool: ...
    def peek_reparam(self) -> Reparam: ...
    def peek_submodel(self, i: int) -> Model: ...
    def peek_submodel_by_mid(self, mid: int) -> Model: ...
    def peek_submodel_pos_by_mid(self, mid: int) -> int: ...
    def ref(self) -> Model: ...
    def reparam_J(self, fJ: Matrix, J: Matrix) -> None: ...
    def reparam_df(self, fv: Vector, v: Vector) -> None: ...
    def set_name_nick(self, name: str, nick: str) -> None: ...
    def set_reparam(self, reparam: Reparam) -> None: ...
    def set_sparam(self, sparam_id: int, symbol: str, name: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_value: float, ppt: ParamType) -> None: ...
    def set_sparam_obj(self, sparam_id: int, sparam: SParam) -> None: ...
    def set_vparam(self, vparam_id: int, default_length: int, symbol: str, name: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_value: float, ppt: ParamType) -> None: ...
    def set_vparam_obj(self, vparam_id: int, vparam: VParam) -> None: ...
    def sparam_len(self) -> int: ...
    def state_is_update(self) -> bool: ...
    def state_mark_outdated(self) -> None: ...
    def state_set_update(self) -> None: ...
    @staticmethod
    def type_is_submodel(model_type: Type) -> bool: ...
    @staticmethod
    def type_main_model(model_type: Type) -> int: ...
    def vparam_array_len(self) -> int: ...
    def vparam_index(self, n: int, i: int) -> int: ...
    

class ModelBuilder(GObject.Object):
    r"""
    :Constructors:

    ::

        ModelBuilder(**properties)
        new(ptype:GType, name:str, desc:str) -> NumCosmoMath.ModelBuilder

    Object NcmModelBuilder

    Properties from NcmModelBuilder:
      parent-type -> GType: parent-type
        Parent type
      name -> gchararray: name
        Model's name
      description -> gchararray: description
        Model's description

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        description: str
        name: str
        parent_type: Type
    props: Props = ...
    parent_instance: GObject.Object = ...
    name: str = ...
    desc: str = ...
    ptype: Type = ...
    type: Type = ...
    sparams: list[None] = ...
    vparams: list[None] = ...
    created: bool = ...
    def __init__(self, description: str = ...,
                 name: str = ...,
                 parent_type: Type = ...): ...
    def add_sparam(self, symbol: str, name: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_value: float, ppt: ParamType) -> None: ...
    def add_sparam_obj(self, sparam: SParam) -> None: ...
    def add_sparams(self, sparams: ObjArray) -> None: ...
    def add_vparam(self, default_length: int, symbol: str, name: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_value: float, ppt: ParamType) -> None: ...
    def add_vparam_obj(self, vparam: VParam) -> None: ...
    def create(self) -> Type: ...
    def get_sparams(self) -> ObjArray: ...
    @classmethod
    def new(cls, ptype: Type, name: str, desc: str) -> ModelBuilder: ...
    def ref(self) -> ModelBuilder: ...
    

class ModelBuilderClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ModelBuilderClass()
    """
    parent_class: GObject.ObjectClass = ...

class ModelClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ModelClass()
    """
    parent_class: GObject.ObjectClass = ...
    get_property: Callable[[GObject.Object, int, Any, GObject.ParamSpec], None] = ...
    set_property: Callable[[GObject.Object, int, Any, GObject.ParamSpec], None] = ...
    add_submodel: Callable[[Model, Model], None] = ...
    valid: Callable[[Model], bool] = ...
    model_id: int = ...
    can_stack: bool = ...
    main_model_id: int = ...
    is_submodel: bool = ...
    name: str = ...
    nick: str = ...
    impl_flag: int = ...
    nonparam_prop_len: int = ...
    sparam_len: int = ...
    vparam_len: int = ...
    parent_sparam_len: int = ...
    parent_vparam_len: int = ...
    sparam: list[None] = ...
    vparam: list[None] = ...
    def add_params(self, sparam_len: int, vparam_len: int, nonparam_prop_len: int) -> None: ...
    def check_params_info(self) -> None: ...
    def set_name_nick(self, name: str, nick: str) -> None: ...
    def set_sparam(self, sparam_id: int, symbol: str, name: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_value: float, ppt: ParamType) -> None: ...
    def set_sparam_obj(self, sparam_id: int, sparam: SParam) -> None: ...
    def set_vparam(self, vparam_id: int, default_length: int, symbol: str, name: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_value: float, ppt: ParamType) -> None: ...
    def set_vparam_obj(self, vparam_id: int, vparam: VParam) -> None: ...
    

class ModelCtrl(GObject.Object):
    r"""
    :Constructors:

    ::

        ModelCtrl(**properties)
        new(model:NumCosmoMath.Model=None) -> NumCosmoMath.ModelCtrl

    Object NcmModelCtrl

    Properties from NcmModelCtrl:
      model -> NcmModel: model
        Last Model used

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        model: Model
    props: Props = ...
    parent_instance: GObject.Object = ...
    model_wr: GObject.WeakRef = ...
    pkey: int = ...
    last_update: bool = ...
    submodel_ctrl: list[None] = ...
    submodel_last_update: list[None] = ...
    def __init__(self, model: Model = ...): ...
    @staticmethod
    def clear(ctrl: ModelCtrl) -> None: ...
    def force_update(self) -> None: ...
    def free(self) -> None: ...
    def get_model(self) -> Model: ...
    def model_has_submodel(self, mid: int) -> bool: ...
    def model_last_update(self) -> bool: ...
    def model_update(self, model: Model) -> bool: ...
    @classmethod
    def new(cls, model: Optional[Model] = None) -> ModelCtrl: ...
    def set_model(self, model: Model) -> bool: ...
    def update(self, model: Model) -> bool: ...
    

class ModelCtrlClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ModelCtrlClass()
    """
    parent_class: GObject.ObjectClass = ...

class ModelFunnel(Model):
    r"""
    :Constructors:

    ::

        ModelFunnel(**properties)
        new(n:int) -> NumCosmoMath.ModelFunnel

    Object NcmModelFunnel

    Properties from NcmModelFunnel:
      nu -> gdouble: nu
        \nu
      x -> NcmVector: x
        x
      x-length -> guint: x-length
        x:length
      nu-fit -> gboolean: nu-fit
        \nu:fit
      x-fit -> GVariant: x-fit
        x:fit

    Properties from NcmModel:
      name -> gchararray: name
        Model's name
      nick -> gchararray: nick
        Model's nick
      scalar-params-len -> guint: scalar-params-len
        Number of scalar parameters
      vector-params-len -> guint: vector-params-len
        Number of vector parameters
      implementation -> guint64: implementation
        Bitwise specification of functions implementation
      sparam-array -> NcmObjArray: sparam-array
        NcmModel array of NcmSParam
      params-types -> GArray: params-types
        Parameters' types
      reparam -> NcmReparam: reparam
        Model reparametrization
      submodel-array -> NcmObjArray: submodel-array
        NcmModel array of submodels

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        nu: float
        nu_fit: bool
        x: Vector
        x_fit: GLib.Variant
        x_length: int
        implementation: int
        name: str
        nick: str
        params_types: list[None]
        reparam: Reparam
        scalar_params_len: int
        sparam_array: ObjArray
        submodel_array: ObjArray
        vector_params_len: int
    props: Props = ...
    parent_instance: Model = ...
    priv: ModelFunnelPrivate = ...
    def __init__(self, nu: float = ...,
                 nu_fit: bool = ...,
                 x: Vector = ...,
                 x_fit: GLib.Variant = ...,
                 x_length: int = ...,
                 reparam: Reparam = ...,
                 sparam_array: ObjArray = ...,
                 submodel_array: ObjArray = ...): ...
    @staticmethod
    def clear(mfu: ModelFunnel) -> None: ...
    def free(self) -> None: ...
    @staticmethod
    def id() -> int: ...
    @classmethod
    def new(cls, n: int) -> ModelFunnel: ...
    def ref(self) -> ModelFunnel: ...
    

class ModelFunnelClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ModelFunnelClass()
    """
    parent_class: ModelClass = ...

class ModelFunnelPrivate(GObject.GPointer): ...

class ModelMVND(Model):
    r"""
    :Constructors:

    ::

        ModelMVND(**properties)
        new(dim:int) -> NumCosmoMath.ModelMVND

    Object NcmModelMVND

    Properties from NcmModelMVND:
      dim -> guint: dim
        Problem dimension
      mu -> NcmVector: mu
        mu
      mu-length -> guint: mu-length
        mu:length
      mu-fit -> GVariant: mu-fit
        mu:fit

    Properties from NcmModel:
      name -> gchararray: name
        Model's name
      nick -> gchararray: nick
        Model's nick
      scalar-params-len -> guint: scalar-params-len
        Number of scalar parameters
      vector-params-len -> guint: vector-params-len
        Number of vector parameters
      implementation -> guint64: implementation
        Bitwise specification of functions implementation
      sparam-array -> NcmObjArray: sparam-array
        NcmModel array of NcmSParam
      params-types -> GArray: params-types
        Parameters' types
      reparam -> NcmReparam: reparam
        Model reparametrization
      submodel-array -> NcmObjArray: submodel-array
        NcmModel array of submodels

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        dim: int
        mu: Vector
        mu_fit: GLib.Variant
        mu_length: int
        implementation: int
        name: str
        nick: str
        params_types: list[None]
        reparam: Reparam
        scalar_params_len: int
        sparam_array: ObjArray
        submodel_array: ObjArray
        vector_params_len: int
    props: Props = ...
    parent_instance: Model = ...
    priv: ModelMVNDPrivate = ...
    def __init__(self, dim: int = ...,
                 mu: Vector = ...,
                 mu_fit: GLib.Variant = ...,
                 mu_length: int = ...,
                 reparam: Reparam = ...,
                 sparam_array: ObjArray = ...,
                 submodel_array: ObjArray = ...): ...
    @staticmethod
    def clear(model_mvnd: ModelMVND) -> None: ...
    def free(self) -> None: ...
    @staticmethod
    def id() -> int: ...
    def mean(self, y: Vector) -> None: ...
    @classmethod
    def new(cls, dim: int) -> ModelMVND: ...
    def ref(self) -> ModelMVND: ...
    

class ModelMVNDClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ModelMVNDClass()
    """
    parent_class: ModelClass = ...

class ModelMVNDPrivate(GObject.GPointer): ...

class ModelRosenbrock(Model):
    r"""
    :Constructors:

    ::

        ModelRosenbrock(**properties)
        new() -> NumCosmoMath.ModelRosenbrock

    Object NcmModelRosenbrock

    Properties from NcmModelRosenbrock:
      x1 -> gdouble: x1
        x_1
      x2 -> gdouble: x2
        x_2
      x1-fit -> gboolean: x1-fit
        x_1:fit
      x2-fit -> gboolean: x2-fit
        x_2:fit

    Properties from NcmModel:
      name -> gchararray: name
        Model's name
      nick -> gchararray: nick
        Model's nick
      scalar-params-len -> guint: scalar-params-len
        Number of scalar parameters
      vector-params-len -> guint: vector-params-len
        Number of vector parameters
      implementation -> guint64: implementation
        Bitwise specification of functions implementation
      sparam-array -> NcmObjArray: sparam-array
        NcmModel array of NcmSParam
      params-types -> GArray: params-types
        Parameters' types
      reparam -> NcmReparam: reparam
        Model reparametrization
      submodel-array -> NcmObjArray: submodel-array
        NcmModel array of submodels

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        x1: float
        x1_fit: bool
        x2: float
        x2_fit: bool
        implementation: int
        name: str
        nick: str
        params_types: list[None]
        reparam: Reparam
        scalar_params_len: int
        sparam_array: ObjArray
        submodel_array: ObjArray
        vector_params_len: int
    props: Props = ...
    parent_instance: Model = ...
    priv: ModelRosenbrockPrivate = ...
    def __init__(self, x1: float = ...,
                 x1_fit: bool = ...,
                 x2: float = ...,
                 x2_fit: bool = ...,
                 reparam: Reparam = ...,
                 sparam_array: ObjArray = ...,
                 submodel_array: ObjArray = ...): ...
    @staticmethod
    def clear(mrb: ModelRosenbrock) -> None: ...
    def free(self) -> None: ...
    @staticmethod
    def id() -> int: ...
    @classmethod
    def new(cls) -> ModelRosenbrock: ...
    def ref(self) -> ModelRosenbrock: ...
    

class ModelRosenbrockClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ModelRosenbrockClass()
    """
    parent_class: ModelClass = ...

class ModelRosenbrockPrivate(GObject.GPointer): ...

class MpsfSBesselRecur(GObject.GPointer):
    r"""
    :Constructors:

    ::

        MpsfSBesselRecur()
    """
    prec: int = ...
    l: int = ...
    q: int = ...
    x: int = ...
    jl: list[int] = ...
    temp: int = ...

class NNLS(GObject.Object):
    r"""
    :Constructors:

    ::

        NNLS(**properties)
        new(nrows:int, ncols:int) -> NumCosmoMath.NNLS

    Object NcmNNLS

    Properties from NcmNNLS:
      umethod -> NcmNNLSUMethod: umethod
        Unconstrained method
      nrows -> guint: nrows
        Number of rows
      ncols -> guint: ncols
        Number of cols
      reltol -> gdouble: reltol
        Relative tolerance

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        ncols: int
        nrows: int
        reltol: float
        umethod: NNLSUMethod
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: NNLSPrivate = ...
    def __init__(self, ncols: int = ...,
                 nrows: int = ...,
                 reltol: float = ...,
                 umethod: NNLSUMethod = ...): ...
    @staticmethod
    def clear(nnls: NNLS) -> None: ...
    def free(self) -> None: ...
    def get_ncols(self) -> int: ...
    def get_nrows(self) -> int: ...
    def get_reltol(self) -> float: ...
    def get_residuals(self) -> Vector: ...
    def get_umethod(self) -> NNLSUMethod: ...
    @classmethod
    def new(cls, nrows: int, ncols: int) -> NNLS: ...
    def ref(self) -> NNLS: ...
    def set_reltol(self, reltol: float) -> None: ...
    def set_umethod(self, umethod: NNLSUMethod) -> None: ...
    def solve(self, A: Matrix, x: Vector, f: Vector) -> float: ...
    def solve_LH(self, A: Matrix, x: Vector, f: Vector) -> float: ...
    def solve_gsmo(self, A: Matrix, x: Vector, f: Vector) -> float: ...
    def solve_lowrankqp(self, A: Matrix, x: Vector, f: Vector) -> float: ...
    def solve_splx(self, A: Matrix, x: Vector, f: Vector) -> float: ...
    

class NNLSClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        NNLSClass()
    """
    parent_class: GObject.ObjectClass = ...

class NNLSPrivate(GObject.GPointer): ...

class ODE(GObject.Object):
    r"""
    :Constructors:

    ::

        ODE(**properties)

    Object NcmODE

    Properties from NcmODE:
      sys-size -> guint: sys-size
        ODE system size

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        sys_size: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: ODEPrivate = ...
    def __init__(self, sys_size: int = ...): ...
    @staticmethod
    def clear(ode: ODE) -> None: ...
    def do_set_sys_size(self, sys_size: int) -> None: ...
    def free(self) -> None: ...
    def get_sys_size(self) -> int: ...
    def ref(self) -> ODE: ...
    def set_sys_size(self, sys_size: int) -> None: ...
    

class ODEClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ODEClass()
    """
    parent_class: GObject.ObjectClass = ...
    set_sys_size: Callable[[ODE, int], None] = ...

class ODEEval(GObject.Object):
    r"""
    :Constructors:

    ::

        ODEEval(**properties)

    Object NcmODEEval

    Properties from NcmODEEval:
      sys-size -> guint: sys-size
        ODE system size

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        sys_size: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: ODEEvalPrivate = ...
    def __init__(self, sys_size: int = ...): ...
    def J_dense(self, sys_size: int, t: float, f: Sequence[float], J_col: Sequence[float]) -> int: ...
    @staticmethod
    def clear(ode_eval: ODEEval) -> None: ...
    def df(self, t: float, f: Sequence[float]) -> Tuple[int, int, list[float]]: ...
    def do_J_dense(self, sys_size: int, t: float, f: Sequence[float], J_col: Sequence[float]) -> int: ...
    def do_clean_ls(self) -> None: ...
    def do_df(self, t: float, f: Sequence[float]) -> Tuple[int, int, list[float]]: ...
    def free(self) -> None: ...
    def ref(self) -> ODEEval: ...
    

class ODEEvalClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ODEEvalClass()
    """
    parent_class: GObject.ObjectClass = ...
    df: Callable[[ODEEval, float, Sequence[float]], Tuple[int, int, list[float]]] = ...
    J_dense: Callable[[ODEEval, int, float, Sequence[float], Sequence[float]], int] = ...
    clean_ls: Callable[[ODEEval], None] = ...

class ODEEvalPrivate(GObject.GPointer): ...

class ODEPrivate(GObject.GPointer): ...

class ObjArray(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        new() -> NumCosmoMath.ObjArray
        new_from_variant(ser:NumCosmoMath.Serialize, var:GLib.Variant) -> NumCosmoMath.ObjArray
        sized_new(n:int) -> NumCosmoMath.ObjArray
    """
    def add(self, obj: GObject.Object) -> None: ...
    @staticmethod
    def clear(oa: ObjArray) -> None: ...
    def dup(self, ser: Serialize) -> ObjArray: ...
    def get(self, i: int) -> GObject.Object: ...
    def len(self) -> int: ...
    @staticmethod
    def load(filename: str, ser: Serialize) -> ObjArray: ...
    @classmethod
    def new(cls) -> ObjArray: ...
    @classmethod
    def new_from_variant(cls, ser: Serialize, var: GLib.Variant) -> ObjArray: ...
    def peek(self, i: int) -> GObject.Object: ...
    def ref(self) -> ObjArray: ...
    def save(self, ser: Serialize, filename: str, save_comment: bool) -> None: ...
    def ser(self, ser: Serialize) -> GLib.Variant: ...
    def set(self, i: int, obj: GObject.Object) -> None: ...
    @classmethod
    def sized_new(cls, n: int) -> ObjArray: ...
    def unref(self) -> None: ...
    

class OdeSpline(GObject.Object):
    r"""
    :Constructors:

    ::

        OdeSpline(**properties)
        new(s:NumCosmoMath.Spline, dydx:NumCosmoMath.OdeSplineDydx) -> NumCosmoMath.OdeSpline
        new_full(s:NumCosmoMath.Spline, dydx:NumCosmoMath.OdeSplineDydx, yi:float, xi:float, xf:float) -> NumCosmoMath.OdeSpline

    Object NcmOdeSpline

    Properties from NcmOdeSpline:
      reltol -> gdouble: reltol
        Relative tolerance
      abstol -> gdouble: abstol
        Absolute tolerance
      xi -> gdouble: xi
        Initial point
      xf -> gdouble: xf
        Final point
      yi -> gdouble: yi
        Initial Value
      yf -> gdouble: yf
        Final Value
      dydx -> gpointer: dydx
        Pointer to the dydx function
      spline -> NcmSpline: spline
        Spline algorithm to be used
      stop-hnil -> gboolean: stop-hnil
        Whether treat hnil as error
      auto-abstol -> gboolean: auto-abstol
        Automatic abstol
      ini-step -> gdouble: ini-step
        Integration initial step size

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        abstol: float
        auto_abstol: bool
        dydx: None
        ini_step: float
        reltol: float
        spline: Spline
        stop_hnil: bool
        xf: float
        xi: float
        yf: float
        yi: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: OdeSplinePrivate = ...
    spline: Spline = ...
    def __init__(self, abstol: float = ...,
                 auto_abstol: bool = ...,
                 dydx: None = ...,
                 ini_step: float = ...,
                 reltol: float = ...,
                 spline: Spline = ...,
                 stop_hnil: bool = ...,
                 xf: float = ...,
                 xi: float = ...,
                 yf: float = ...,
                 yi: float = ...): ...
    def auto_abstol(self, on: bool) -> None: ...
    @staticmethod
    def clear(os: OdeSpline) -> None: ...
    def free(self) -> None: ...
    def get_ini_step(self) -> float: ...
    @classmethod
    def new(cls, s: Spline, dydx: Callable[[float, float, None], float]) -> OdeSpline: ...
    @classmethod
    def new_full(cls, s: Spline, dydx: Callable[[float, float, None], float], yi: float, xi: float, xf: float) -> OdeSpline: ...
    def peek_spline(self) -> Spline: ...
    def prepare(self, userdata: None) -> None: ...
    def set_abstol(self, abstol: float) -> None: ...
    def set_ini_step(self, ini_step: float) -> None: ...
    def set_interval(self, yi: float, xi: float, xf: float) -> None: ...
    def set_reltol(self, reltol: float) -> None: ...
    def set_xf(self, xf: float) -> None: ...
    def set_xi(self, xi: float) -> None: ...
    def set_yf(self, yf: float) -> None: ...
    def set_yi(self, yi: float) -> None: ...
    

class OdeSplineClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        OdeSplineClass()
    """
    parent_class: GObject.ObjectClass = ...

class OdeSplinePrivate(GObject.GPointer): ...

class Powspec(GObject.Object):
    r"""
    :Constructors:

    ::

        Powspec(**properties)

    Object NcmPowspec

    Properties from NcmPowspec:
      zi -> gdouble: zi
        Initial time
      zf -> gdouble: zf
        Final time
      kmin -> gdouble: kmin
        Minimum mode value
      kmax -> gdouble: kmax
        Maximum mode value
      reltol -> gdouble: reltol
        Relative tolerance on the interpolation error

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        kmax: float
        kmin: float
        reltol: float
        zf: float
        zi: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    zi: float = ...
    zf: float = ...
    kmin: float = ...
    kmax: float = ...
    var_tophat_R: Integral1dPtr = ...
    corr3D: Integral1dPtr = ...
    sproj: Integral1dPtr = ...
    reltol_spline: float = ...
    ctrl: ModelCtrl = ...
    def __init__(self, kmax: float = ...,
                 kmin: float = ...,
                 reltol: float = ...,
                 zf: float = ...,
                 zi: float = ...): ...
    @staticmethod
    def clear(powspec: Powspec) -> None: ...
    def corr3d(self, model: Model, reltol: float, z: float, r: float) -> float: ...
    def do_eval(self, model: Model, z: float, k: float) -> float: ...
    def do_eval_vec(self, model: Model, z: float, k: Vector) -> Vector: ...
    def do_get_nknots(self) -> Tuple[int, int]: ...
    def do_get_spline_2d(self, model: Model) -> Spline2d: ...
    def do_prepare(self, model: Model) -> None: ...
    def eval(self, model: Model, z: float, k: float) -> float: ...
    def eval_vec(self, model: Model, z: float, k: Vector) -> Vector: ...
    def free(self) -> None: ...
    def get_kmax(self) -> float: ...
    def get_kmin(self) -> float: ...
    def get_nknots(self) -> Tuple[int, int]: ...
    def get_spline_2d(self, model: Model) -> Spline2d: ...
    def get_zf(self) -> float: ...
    def get_zi(self) -> float: ...
    def prepare(self, model: Model) -> None: ...
    def prepare_if_needed(self, model: Model) -> None: ...
    def ref(self) -> Powspec: ...
    def require_kmax(self, kmax: float) -> None: ...
    def require_kmin(self, kmin: float) -> None: ...
    def require_zf(self, zf: float) -> None: ...
    def require_zi(self, zi: float) -> None: ...
    def set_kmax(self, kmax: float) -> None: ...
    def set_kmin(self, kmin: float) -> None: ...
    def set_reltol_spline(self, reltol: float) -> None: ...
    def set_zf(self, zf: float) -> None: ...
    def set_zi(self, zi: float) -> None: ...
    def sigma_tophat_R(self, model: Model, reltol: float, z: float, R: float) -> float: ...
    

class PowspecClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PowspecClass()
    """
    parent_class: GObject.ObjectClass = ...
    prepare: Callable[[Powspec, Model], None] = ...
    eval: Callable[[Powspec, Model, float, float], float] = ...
    eval_vec: Callable[[Powspec, Model, float, Vector], Vector] = ...
    get_nknots: Callable[[Powspec], Tuple[int, int]] = ...
    get_spline_2d: Callable[[Powspec, Model], Spline2d] = ...

class PowspecCorr3d(GObject.Object):
    r"""
    :Constructors:

    ::

        PowspecCorr3d(**properties)
        new(ps:NumCosmoMath.Powspec) -> NumCosmoMath.PowspecCorr3d

    Object NcmPowspecCorr3d

    Properties from NcmPowspecCorr3d:
      lnr0 -> gdouble: lnr0
        Output center value
      zi -> gdouble: zi
        Output initial time
      zf -> gdouble: zf
        Output final time
      reltol -> gdouble: reltol
        Relative tolerance for calibration
      reltol-z -> gdouble: reltol-z
        Relative tolerance for calibration in the redshift direction
      powerspectrum -> NcmPowspec: powerspectrum
        NcmPowspec object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        lnr0: float
        powerspectrum: Powspec
        reltol: float
        reltol_z: float
        zf: float
        zi: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    ps: Powspec = ...
    fftlog: Fftlog = ...
    lnr0: float = ...
    lnk0: float = ...
    Lk: float = ...
    zi: float = ...
    zf: float = ...
    calibrated: bool = ...
    reltol: float = ...
    reltol_z: float = ...
    xi: Spline2d = ...
    ctrl: ModelCtrl = ...
    constructed: bool = ...
    def __init__(self, lnr0: float = ...,
                 powerspectrum: Powspec = ...,
                 reltol: float = ...,
                 reltol_z: float = ...,
                 zf: float = ...,
                 zi: float = ...): ...
    @staticmethod
    def clear(psc: PowspecCorr3d) -> None: ...
    def eval_xi(self, z: float, r: float) -> float: ...
    def eval_xi_lnr(self, z: float, lnr: float) -> float: ...
    def free(self) -> None: ...
    def get_r_max(self) -> float: ...
    def get_r_min(self) -> float: ...
    @classmethod
    def new(cls, ps: Powspec) -> PowspecCorr3d: ...
    def prepare(self, model: Model) -> None: ...
    def prepare_if_needed(self, model: Model) -> None: ...
    def ref(self) -> PowspecCorr3d: ...
    def set_best_lnr0(self) -> None: ...
    def set_lnr0(self, lnr0: float) -> None: ...
    def set_zf(self, zf: float) -> None: ...
    def set_zi(self, zi: float) -> None: ...
    

class PowspecCorr3dClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PowspecCorr3dClass()
    """
    parent_class: GObject.ObjectClass = ...

class PowspecFilter(GObject.Object):
    r"""
    :Constructors:

    ::

        PowspecFilter(**properties)
        new(ps:NumCosmoMath.Powspec, type:NumCosmoMath.PowspecFilterType) -> NumCosmoMath.PowspecFilter

    Object NcmPowspecFilter

    Properties from NcmPowspecFilter:
      type -> NcmPowspecFilterType: type
        Filter type
      lnr0 -> gdouble: lnr0
        Output center value
      zi -> gdouble: zi
        Output initial time
      zf -> gdouble: zf
        Output final time
      reltol -> gdouble: reltol
        Relative tolerance for calibration
      reltol-z -> gdouble: reltol-z
        Relative tolerance for calibration in the redshift direction
      powerspectrum -> NcmPowspec: powerspectrum
        NcmPowspec object

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        lnr0: float
        powerspectrum: Powspec
        reltol: float
        reltol_z: float
        type: PowspecFilterType
        zf: float
        zi: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    ps: Powspec = ...
    type: PowspecFilterType = ...
    fftlog: Fftlog = ...
    lnr0: float = ...
    lnk0: float = ...
    Lk: float = ...
    zi: float = ...
    zf: float = ...
    calibrated: bool = ...
    reltol: float = ...
    reltol_z: float = ...
    var: Spline2d = ...
    dvar: Spline2d = ...
    ctrl: ModelCtrl = ...
    constructed: bool = ...
    def __init__(self, lnr0: float = ...,
                 powerspectrum: Powspec = ...,
                 reltol: float = ...,
                 reltol_z: float = ...,
                 type: PowspecFilterType = ...,
                 zf: float = ...,
                 zi: float = ...): ...
    @staticmethod
    def clear(psf: PowspecFilter) -> None: ...
    def eval_dlnvar_dlnr(self, z: float, lnr: float) -> float: ...
    def eval_dlnvar_dr(self, z: float, lnr: float) -> float: ...
    def eval_dnlnvar_dlnrn(self, z: float, lnr: float, n: int) -> float: ...
    def eval_dnvar_dlnrn(self, z: float, lnr: float, n: int) -> float: ...
    def eval_dvar_dlnr(self, z: float, lnr: float) -> float: ...
    def eval_lnvar_lnr(self, z: float, lnr: float) -> float: ...
    def eval_sigma(self, z: float, r: float) -> float: ...
    def eval_sigma_lnr(self, z: float, lnr: float) -> float: ...
    def eval_var(self, z: float, r: float) -> float: ...
    def eval_var_lnr(self, z: float, lnr: float) -> float: ...
    def free(self) -> None: ...
    def get_r_max(self) -> float: ...
    def get_r_min(self) -> float: ...
    @classmethod
    def new(cls, ps: Powspec, type: PowspecFilterType) -> PowspecFilter: ...
    def prepare(self, model: Model) -> None: ...
    def prepare_if_needed(self, model: Model) -> None: ...
    def ref(self) -> PowspecFilter: ...
    def require_zf(self, zf: float) -> None: ...
    def require_zi(self, zi: float) -> None: ...
    def set_best_lnr0(self) -> None: ...
    def set_lnr0(self, lnr0: float) -> None: ...
    def set_type(self, type: PowspecFilterType) -> None: ...
    def set_zf(self, zf: float) -> None: ...
    def set_zi(self, zi: float) -> None: ...
    def volume_rm3(self) -> float: ...
    

class PowspecFilterClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PowspecFilterClass()
    """
    parent_class: GObject.ObjectClass = ...

class PowspecSphereProj(GObject.Object):
    r"""
    :Constructors:

    ::

        PowspecSphereProj(**properties)
        new(ps:NumCosmoMath.Powspec, ell_min:int, ell_max:int) -> NumCosmoMath.PowspecSphereProj

    Object NcmPowspecSphereProj

    Properties from NcmPowspecSphereProj:
      xi-i -> gdouble: xi-i
        Output initial scale
      xi-f -> gdouble: xi-f
        Output final scale
      k-pivot -> gdouble: k-pivot
        Pivot k for growth computation
      reltol -> gdouble: reltol
        Relative tolerance for calibration
      reltol-z -> gdouble: reltol-z
        Relative tolerance for calibration in the redshift direction
      powerspectrum -> NcmPowspec: powerspectrum
        NcmPowspec object
      ell-min -> guint: ell-min
        Minimum ell
      ell-max -> guint: ell-max
        Maximum ell

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        ell_max: int
        ell_min: int
        k_pivot: float
        powerspectrum: Powspec
        reltol: float
        reltol_z: float
        xi_f: float
        xi_i: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: PowspecSphereProjPrivate = ...
    def __init__(self, ell_max: int = ...,
                 ell_min: int = ...,
                 k_pivot: float = ...,
                 powerspectrum: Powspec = ...,
                 reltol: float = ...,
                 reltol_z: float = ...,
                 xi_f: float = ...,
                 xi_i: float = ...): ...
    @staticmethod
    def clear(psp: PowspecSphereProj) -> None: ...
    def eval_Cell_xi1_xi2(self, model: Model, ell: int, z1: float, z2: float, xi1: float, xi2: float) -> float: ...
    def eval_lnvar_lnr(self, z: float, lnr: float) -> float: ...
    def free(self) -> None: ...
    def get_ell(self, w_i: int, ell: int) -> Tuple[list[float], list[float]]: ...
    def get_ell_max(self) -> int: ...
    def get_ell_min(self) -> int: ...
    def get_r_max(self) -> float: ...
    def get_r_min(self) -> float: ...
    def get_w(self, w_i: int) -> float: ...
    @classmethod
    def new(cls, ps: Powspec, ell_min: int, ell_max: int) -> PowspecSphereProj: ...
    def peek_ell_spline(self, w_i: int, ell: int) -> Spline: ...
    def prepare(self, model: Model) -> None: ...
    def prepare_if_needed(self, model: Model) -> None: ...
    def ref(self) -> PowspecSphereProj: ...
    def set_ell_max(self, ell_max: int) -> None: ...
    def set_ell_min(self, ell_min: int) -> None: ...
    def set_k_pivot(self, k_pivot: float) -> None: ...
    def set_xi_f(self, xi_f: float) -> None: ...
    def set_xi_i(self, xi_i: float) -> None: ...
    

class PowspecSphereProjClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PowspecSphereProjClass()
    """
    parent_class: GObject.ObjectClass = ...

class PowspecSphereProjPrivate(GObject.GPointer): ...

class Prior(MSetFunc):
    r"""
    :Constructors:

    ::

        Prior(**properties)

    Object NcmPrior

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: MSetFunc = ...
    def __init__(self, dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def clear(prior: Prior) -> None: ...
    def free(self) -> None: ...
    def is_m2lnL(self) -> bool: ...
    def ref(self) -> Prior: ...
    

class PriorClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PriorClass()
    """
    parent_class: MSetFuncClass = ...
    is_m2lnL: bool = ...

class PriorFlat(Prior):
    r"""
    :Constructors:

    ::

        PriorFlat(**properties)

    Object NcmPriorFlat

    Properties from NcmPriorFlat:
      x-low -> gdouble: x-low
        lower limit
      x-upp -> gdouble: x-upp
        upper limit
      scale -> gdouble: scale
        border scale
      variable -> gdouble: variable
        variable

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        scale: float
        variable: float
        x_low: float
        x_upp: float
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: Prior = ...
    x_low: float = ...
    x_upp: float = ...
    s: float = ...
    var: float = ...
    def __init__(self, scale: float = ...,
                 variable: float = ...,
                 x_low: float = ...,
                 x_upp: float = ...,
                 dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def clear(pf: PriorFlat) -> None: ...
    def do_mean(self, mset: MSet) -> float: ...
    def free(self) -> None: ...
    def ref(self) -> PriorFlat: ...
    

class PriorFlatClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PriorFlatClass()
    """
    parent_class: PriorClass = ...
    mean: Callable[[PriorFlat, MSet], float] = ...

class PriorFlatFunc(PriorFlat):
    r"""
    :Constructors:

    ::

        PriorFlatFunc(**properties)
        new(mean_func:NumCosmoMath.MSetFunc, x_low:float, x_upp:float, scale:float, variable:float) -> NumCosmoMath.PriorFlatFunc

    Object NcmPriorFlatFunc

    Properties from NcmPriorFlatFunc:
      mean-func -> NcmMSetFunc: mean-func
        mean function

    Properties from NcmPriorFlat:
      x-low -> gdouble: x-low
        lower limit
      x-upp -> gdouble: x-upp
        upper limit
      scale -> gdouble: scale
        border scale
      variable -> gdouble: variable
        variable

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        mean_func: MSetFunc
        scale: float
        variable: float
        x_low: float
        x_upp: float
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: PriorFlat = ...
    mean_func: MSetFunc = ...
    def __init__(self, mean_func: MSetFunc = ...,
                 scale: float = ...,
                 variable: float = ...,
                 x_low: float = ...,
                 x_upp: float = ...,
                 dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def clear(pff: PriorFlatFunc) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, mean_func: MSetFunc, x_low: float, x_upp: float, scale: float, variable: float) -> PriorFlatFunc: ...
    def ref(self) -> PriorFlatFunc: ...
    

class PriorFlatFuncClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PriorFlatFuncClass()
    """
    parent_class: PriorFlatClass = ...

class PriorFlatParam(PriorFlat):
    r"""
    :Constructors:

    ::

        PriorFlatParam(**properties)
        new(mid:int, pid:int, x_low:float, x_upp:float, scale:float) -> NumCosmoMath.PriorFlatParam
        new_name(mset:NumCosmoMath.MSet, name:str, x_low:float, x_upp:float, scale:float) -> NumCosmoMath.PriorFlatParam
        new_pindex(pi:NumCosmoMath.MSetPIndex, x_low:float, x_upp:float, scale:float) -> NumCosmoMath.PriorFlatParam

    Object NcmPriorFlatParam

    Properties from NcmPriorFlatParam:
      mid -> gint: mid
        model id
      pid -> guint: pid
        parameter id

    Properties from NcmPriorFlat:
      x-low -> gdouble: x-low
        lower limit
      x-upp -> gdouble: x-upp
        upper limit
      scale -> gdouble: scale
        border scale
      variable -> gdouble: variable
        variable

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        mid: int
        pid: int
        scale: float
        variable: float
        x_low: float
        x_upp: float
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: PriorFlat = ...
    mid: int = ...
    pid: int = ...
    def __init__(self, mid: int = ...,
                 pid: int = ...,
                 scale: float = ...,
                 variable: float = ...,
                 x_low: float = ...,
                 x_upp: float = ...,
                 dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def clear(pfp: PriorFlatParam) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, mid: int, pid: int, x_low: float, x_upp: float, scale: float) -> PriorFlatParam: ...
    @classmethod
    def new_name(cls, mset: MSet, name: str, x_low: float, x_upp: float, scale: float) -> PriorFlatParam: ...
    @classmethod
    def new_pindex(cls, pi: MSetPIndex, x_low: float, x_upp: float, scale: float) -> PriorFlatParam: ...
    def ref(self) -> PriorFlatParam: ...
    

class PriorFlatParamClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PriorFlatParamClass()
    """
    parent_class: PriorFlatClass = ...

class PriorGauss(Prior):
    r"""
    :Constructors:

    ::

        PriorGauss(**properties)

    Object NcmPriorGauss

    Properties from NcmPriorGauss:
      mu -> gdouble: mu
        mean
      sigma -> gdouble: sigma
        standard deviation
      variable -> gdouble: variable
        variable

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        mu: float
        sigma: float
        variable: float
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: Prior = ...
    mu: float = ...
    sigma: float = ...
    var: float = ...
    def __init__(self, mu: float = ...,
                 sigma: float = ...,
                 variable: float = ...,
                 dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def clear(pg: PriorGauss) -> None: ...
    def do_mean(self, mset: MSet) -> float: ...
    def free(self) -> None: ...
    def ref(self) -> PriorGauss: ...
    

class PriorGaussClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PriorGaussClass()
    """
    parent_class: PriorClass = ...
    mean: Callable[[PriorGauss, MSet], float] = ...

class PriorGaussFunc(PriorGauss):
    r"""
    :Constructors:

    ::

        PriorGaussFunc(**properties)
        new(mean_func:NumCosmoMath.MSetFunc, mu:float, sigma:float, var:float) -> NumCosmoMath.PriorGaussFunc

    Object NcmPriorGaussFunc

    Properties from NcmPriorGaussFunc:
      mean-func -> NcmMSetFunc: mean-func
        mean function

    Properties from NcmPriorGauss:
      mu -> gdouble: mu
        mean
      sigma -> gdouble: sigma
        standard deviation
      variable -> gdouble: variable
        variable

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        mean_func: MSetFunc
        mu: float
        sigma: float
        variable: float
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: PriorGauss = ...
    mean_func: MSetFunc = ...
    def __init__(self, mean_func: MSetFunc = ...,
                 mu: float = ...,
                 sigma: float = ...,
                 variable: float = ...,
                 dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def clear(pgf: PriorGaussFunc) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, mean_func: MSetFunc, mu: float, sigma: float, var: float) -> PriorGaussFunc: ...
    def ref(self) -> PriorGaussFunc: ...
    

class PriorGaussFuncClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PriorGaussFuncClass()
    """
    parent_class: PriorGaussClass = ...

class PriorGaussParam(PriorGauss):
    r"""
    :Constructors:

    ::

        PriorGaussParam(**properties)
        new(mid:int, pid:int, mu:float, sigma:float) -> NumCosmoMath.PriorGaussParam
        new_name(mset:NumCosmoMath.MSet, name:str, mu:float, sigma:float) -> NumCosmoMath.PriorGaussParam
        new_pindex(pi:NumCosmoMath.MSetPIndex, mu:float, sigma:float) -> NumCosmoMath.PriorGaussParam

    Object NcmPriorGaussParam

    Properties from NcmPriorGaussParam:
      mid -> gint: mid
        model id
      pid -> guint: pid
        parameter id

    Properties from NcmPriorGauss:
      mu -> gdouble: mu
        mean
      sigma -> gdouble: sigma
        standard deviation
      variable -> gdouble: variable
        variable

    Properties from NcmMSetFunc:
      nvariables -> guint: nvariables
        Number of variables
      dimension -> guint: dimension
        Function dimension
      eval-x -> NcmVector: eval-x
        Evaluation point x

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        mid: int
        pid: int
        mu: float
        sigma: float
        variable: float
        dimension: int
        eval_x: Vector
        nvariables: int
    props: Props = ...
    parent_instance: PriorGauss = ...
    mid: int = ...
    pid: int = ...
    def __init__(self, mid: int = ...,
                 pid: int = ...,
                 mu: float = ...,
                 sigma: float = ...,
                 variable: float = ...,
                 dimension: int = ...,
                 eval_x: Vector = ...,
                 nvariables: int = ...): ...
    @staticmethod
    def clear(pgp: PriorGaussParam) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, mid: int, pid: int, mu: float, sigma: float) -> PriorGaussParam: ...
    @classmethod
    def new_name(cls, mset: MSet, name: str, mu: float, sigma: float) -> PriorGaussParam: ...
    @classmethod
    def new_pindex(cls, pi: MSetPIndex, mu: float, sigma: float) -> PriorGaussParam: ...
    def ref(self) -> PriorGaussParam: ...
    

class PriorGaussParamClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        PriorGaussParamClass()
    """
    parent_class: PriorGaussClass = ...

class Quaternion(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        Quaternion()
        new() -> NumCosmoMath.Quaternion
        new_from_data(x:float, y:float, z:float, theta:float) -> NumCosmoMath.Quaternion
        new_from_vector(v:NumCosmoMath.TriVec) -> NumCosmoMath.Quaternion
    """
    s: float = ...
    v: TriVec = ...
    def conjugate(self) -> None: ...
    def conjugate_q_mul(self, u: Quaternion, res: Quaternion) -> None: ...
    def conjugate_u_mul(self, u: Quaternion, res: Quaternion) -> None: ...
    def dup(self) -> Quaternion: ...
    def free(self) -> None: ...
    def inv_rotate(self, v: TriVec) -> None: ...
    def lmul(self, u: Quaternion) -> None: ...
    def memcpy(self, orig: Quaternion) -> None: ...
    def mul(self, u: Quaternion, res: Quaternion) -> None: ...
    @classmethod
    def new(cls) -> Quaternion: ...
    @classmethod
    def new_from_data(cls, x: float, y: float, z: float, theta: float) -> Quaternion: ...
    @classmethod
    def new_from_vector(cls, v: TriVec) -> Quaternion: ...
    def norm(self) -> float: ...
    def normalize(self) -> None: ...
    def rmul(self, u: Quaternion) -> None: ...
    def rotate(self, v: TriVec) -> None: ...
    def set_0(self) -> None: ...
    def set_I(self) -> None: ...
    def set_from_data(self, x: float, y: float, z: float, theta: float) -> None: ...
    def set_random(self, rng: RNG) -> None: ...
    

class RNG(GObject.Object):
    r"""
    :Constructors:

    ::

        RNG(**properties)
        new(algo:str=None) -> NumCosmoMath.RNG
        seeded_new(algo:str=None, seed:int) -> NumCosmoMath.RNG

    Object NcmRNG

    Properties from NcmRNG:
      algorithm -> gchararray: algorithm
        Algorithm name
      state -> gchararray: state
        Algorithm state
      seed -> gulong: seed
        Algorithm seed

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        algorithm: str
        seed: int
        state: str
    props: Props = ...
    parent_instance: GObject.Object = ...
    r: int = ...
    seed_val: int = ...
    seed_set: bool = ...
    lock: GLib.Mutex = ...
    def __init__(self, algorithm: str = ...,
                 seed: int = ...,
                 state: str = ...): ...
    def beta_gen(self, a: float, b: float) -> float: ...
    def check_seed(self, seed: int) -> bool: ...
    def chisq_gen(self, nu: float) -> float: ...
    @staticmethod
    def clear(rng: RNG) -> None: ...
    def exponential_gen(self, mu: float) -> float: ...
    def exppow_gen(self, a: float, b: float) -> float: ...
    def free(self) -> None: ...
    def gamma_gen(self, a: float, b: float) -> float: ...
    def gaussian_gen(self, mu: float, sigma: float) -> float: ...
    def gaussian_tail_gen(self, a: float, sigma: float) -> float: ...
    def get_algo(self) -> str: ...
    def get_seed(self) -> int: ...
    def get_state(self) -> str: ...
    def laplace_gen(self, a: float) -> float: ...
    @classmethod
    def new(cls, algo: Optional[str] = None) -> RNG: ...
    @staticmethod
    def pool_get(name: str) -> RNG: ...
    def ref(self) -> RNG: ...
    @classmethod
    def seeded_new(cls, algo: Optional[str], seed: int) -> RNG: ...
    def set_algo(self, algo: str) -> None: ...
    def set_random_seed(self, allow_colisions: bool) -> None: ...
    def set_seed(self, seed: int) -> None: ...
    def set_state(self, state: str) -> None: ...
    def ugaussian_gen(self) -> float: ...
    def uniform_gen(self, xl: float, xu: float) -> float: ...
    def unlock(self) -> None: ...
    

class RNGClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        RNGClass()
    """
    parent_class: GObject.ObjectClass = ...
    seed_gen: GLib.Rand = ...
    seed_hash: dict[None, None] = ...

class Reparam(GObject.Object):
    r"""
    :Constructors:

    ::

        Reparam(**properties)

    Object NcmReparam

    Properties from NcmReparam:
      length -> guint: length
        System's length
      params-desc -> GVariant: params-desc
        News parameter descriptions
      compat-type -> gchararray: compat-type
        Compatible type

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        compat_type: str
        length: int
        params_desc: GLib.Variant
    props: Props = ...
    parent_instance: GObject.Object = ...
    length: int = ...
    new_params: Vector = ...
    sparams: list[None] = ...
    sparams_name_id: dict[None, None] = ...
    compat_type: Type = ...
    def __init__(self, compat_type: str = ...,
                 length: int = ...,
                 params_desc: GLib.Variant = ...): ...
    def M_old2new(self, model: None, jac: Matrix, old_M: Matrix, new_M: Matrix) -> None: ...
    @staticmethod
    def clear(reparam: Reparam) -> None: ...
    def do_jac(self, model: None, jac: Matrix) -> bool: ...
    def do_new2old(self, model: None) -> bool: ...
    def do_old2new(self, model: None) -> bool: ...
    def free(self) -> None: ...
    def get_compat_type(self) -> Type: ...
    def get_param_desc(self, i: int) -> SParam: ...
    def get_params_desc_dict(self) -> GLib.Variant: ...
    def grad_old2new(self, model: None, jac: Matrix, old_grad: Vector, new_grad: Vector) -> None: ...
    def index_from_name(self, param_name: str) -> Tuple[bool, int]: ...
    def jac(self, model: None, jac: Matrix) -> None: ...
    def new2old(self, model: None) -> None: ...
    def old2new(self, model: None) -> None: ...
    def peek_param_desc(self, i: int) -> SParam: ...
    def ref(self) -> Reparam: ...
    def set_param_desc(self, i: int, sp: SParam) -> None: ...
    def set_param_desc_full(self, i: int, name: str, symbol: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_val: float, ftype: ParamType) -> None: ...
    def set_params_desc_dict(self, pdesc_dict: GLib.Variant) -> None: ...
    

class ReparamClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ReparamClass()
    """
    parent_class: GObject.ObjectClass = ...
    old2new: Callable[[Reparam, None], bool] = ...
    new2old: Callable[[Reparam, None], bool] = ...
    jac: Callable[[Reparam, None, Matrix], bool] = ...

class ReparamLinear(Reparam):
    r"""
    :Constructors:

    ::

        ReparamLinear(**properties)
        new(size:int, T:NumCosmoMath.Matrix, v:NumCosmoMath.Vector) -> NumCosmoMath.ReparamLinear

    Object NcmReparamLinear

    Properties from NcmReparamLinear:
      vector -> NcmVector: vector
        Vector of parameters shift
      matrix -> NcmMatrix: matrix
        Matrix of parameters mixing

    Properties from NcmReparam:
      length -> guint: length
        System's length
      params-desc -> GVariant: params-desc
        News parameter descriptions
      compat-type -> gchararray: compat-type
        Compatible type

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        matrix: Matrix
        vector: Vector
        compat_type: str
        length: int
        params_desc: GLib.Variant
    props: Props = ...
    parent_instance: Reparam = ...
    T: Matrix = ...
    v: Vector = ...
    vp: Vector = ...
    T_LU: Matrix = ...
    p: int = ...
    signum: int = ...
    def __init__(self, matrix: Matrix = ...,
                 vector: Vector = ...,
                 compat_type: str = ...,
                 length: int = ...,
                 params_desc: GLib.Variant = ...): ...
    @classmethod
    def new(cls, size: int, T: Matrix, v: Vector) -> ReparamLinear: ...
    def set_compat_type(self, compat_type: Type) -> None: ...
    

class ReparamLinearClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        ReparamLinearClass()
    """
    parent_class: ReparamClass = ...

class SFSphericalHarmonics(GObject.Object):
    r"""
    :Constructors:

    ::

        SFSphericalHarmonics(**properties)
        new(lmax:int) -> NumCosmoMath.SFSphericalHarmonics

    Object NcmSFSphericalHarmonics

    Properties from NcmSFSphericalHarmonics:
      lmax -> gint: lmax
        max l

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        lmax: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    lmax: int = ...
    sqrt_n: list[None] = ...
    sqrtm1_n: list[None] = ...
    K_array: list[None] = ...
    Klm_m: int = ...
    def __init__(self, lmax: int = ...): ...
    @staticmethod
    def clear(spha: SFSphericalHarmonics) -> None: ...
    def free(self) -> None: ...
    def get_lmax(self) -> int: ...
    @classmethod
    def new(cls, lmax: int) -> SFSphericalHarmonics: ...
    def ref(self) -> SFSphericalHarmonics: ...
    def set_lmax(self, lmax: int) -> None: ...
    def start_rec(self, sphaY: SFSphericalHarmonicsY, theta: float) -> None: ...
    def start_rec_array(self, sphaYa: SFSphericalHarmonicsYArray, len: int, theta: Sequence[float]) -> None: ...
    

class SFSphericalHarmonicsClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SFSphericalHarmonicsClass()
    """
    parent_class: GObject.ObjectClass = ...

class SFSphericalHarmonicsK(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SFSphericalHarmonicsK()
    """
    l: float = ...
    lp1: float = ...

class SFSphericalHarmonicsP(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SFSphericalHarmonicsP()
    """
    x: float = ...
    sqrt1mx2: float = ...
    l0m: float = ...
    l0p1m: float = ...
    lm: float = ...
    lp1m: float = ...

class SFSphericalHarmonicsY(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        SFSphericalHarmonicsY()
        new(spha:NumCosmoMath.SFSphericalHarmonics, abstol:float) -> NumCosmoMath.SFSphericalHarmonicsY
    """
    x: float = ...
    sqrt1mx2: float = ...
    l: int = ...
    l0: int = ...
    m: int = ...
    Klm: SFSphericalHarmonicsK = ...
    Pl0m: float = ...
    Pl0p1m: float = ...
    Plm: float = ...
    Plp1m: float = ...
    spha: SFSphericalHarmonics = ...
    abstol: float = ...
    def dup(self) -> SFSphericalHarmonicsY: ...
    def free(self) -> None: ...
    def get_l(self) -> int: ...
    def get_lm(self) -> float: ...
    def get_lp1m(self) -> float: ...
    def get_m(self) -> int: ...
    def get_x(self) -> float: ...
    @classmethod
    def new(cls, spha: SFSphericalHarmonics, abstol: float) -> SFSphericalHarmonicsY: ...
    def next_l(self) -> None: ...
    def next_l2(self) -> list[float]: ...
    def next_l2pn(self, Yblm: float, n: int) -> None: ...
    def next_l4(self) -> list[float]: ...
    def next_m(self) -> None: ...
    def reset(self) -> None: ...
    

class SFSphericalHarmonicsYArray(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        SFSphericalHarmonicsYArray()
        new(spha:NumCosmoMath.SFSphericalHarmonics, len:int, abstol:float) -> NumCosmoMath.SFSphericalHarmonicsYArray
    """
    l: int = ...
    l0: int = ...
    m: int = ...
    len: int = ...
    x: list[float] = ...
    sqrt1mx2: list[float] = ...
    Yl0m: list[float] = ...
    Ylm: list[float] = ...
    Klm: SFSphericalHarmonicsK = ...
    spha: SFSphericalHarmonics = ...
    abstol: float = ...
    def dup(self) -> SFSphericalHarmonicsYArray: ...
    def free(self) -> None: ...
    def get_l(self) -> int: ...
    def get_lm(self, len: int, i: int) -> float: ...
    def get_lp1m(self, len: int, i: int) -> float: ...
    def get_m(self) -> int: ...
    def get_x(self, i: int) -> float: ...
    @classmethod
    def new(cls, spha: SFSphericalHarmonics, len: int, abstol: float) -> SFSphericalHarmonicsYArray: ...
    def next_l(self, len: int) -> None: ...
    def next_l2(self, len: int, Yblm: float) -> None: ...
    def next_l2pn(self, len: int, Yblm: float, n: int) -> None: ...
    def next_l4(self, len: int, Yblm: float) -> None: ...
    def next_m(self, len: int) -> None: ...
    def reset(self, len: int) -> None: ...
    

class SParam(GObject.Object):
    r"""
    :Constructors:

    ::

        SParam(**properties)
        new(name:str, symbol:str, lower_bound:float, upper_bound:float, scale:float, abstol:float, default_val:float, ftype:NumCosmoMath.ParamType) -> NumCosmoMath.SParam

    Object NcmSParam

    Properties from NcmSParam:
      name -> gchararray: name
        Name (only ASCII plus -)
      symbol -> gchararray: symbol
        Symbol (latex)
      lower-bound -> gdouble: lower-bound
        Lower bound
      upper-bound -> gdouble: upper-bound
        Upper bound
      scale -> gdouble: scale
        Scale in which the model varies
      absolute-tolerance -> gdouble: absolute-tolerance
        Absolute tolerance
      default-value -> gdouble: default-value
        Default value
      fit-type -> NcmParamType: fit-type
        Fit Type

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        absolute_tolerance: float
        default_value: float
        fit_type: ParamType
        lower_bound: float
        name: str
        scale: float
        symbol: str
        upper_bound: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    name: str = ...
    symbol: str = ...
    lower_bound: float = ...
    upper_bound: float = ...
    scale: float = ...
    abstol: float = ...
    default_val: float = ...
    ftype: ParamType = ...
    def __init__(self, absolute_tolerance: float = ...,
                 default_value: float = ...,
                 fit_type: ParamType = ...,
                 lower_bound: float = ...,
                 name: str = ...,
                 scale: float = ...,
                 symbol: str = ...,
                 upper_bound: float = ...): ...
    @staticmethod
    def clear(sparam: SParam) -> None: ...
    def copy(self) -> SParam: ...
    def free(self) -> None: ...
    def get_absolute_tolerance(self) -> float: ...
    def get_default_value(self) -> float: ...
    def get_fit_type(self) -> ParamType: ...
    def get_lower_bound(self) -> float: ...
    def get_scale(self) -> float: ...
    def get_upper_bound(self) -> float: ...
    @classmethod
    def new(cls, name: str, symbol: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_val: float, ftype: ParamType) -> SParam: ...
    def ref(self) -> SParam: ...
    def set_absolute_tolerance(self, abstol: float) -> None: ...
    def set_default_value(self, default_val: float) -> None: ...
    def set_fit_type(self, ftype: ParamType) -> None: ...
    def set_lower_bound(self, lb: float) -> None: ...
    def set_scale(self, scale: float) -> None: ...
    def set_upper_bound(self, ub: float) -> None: ...
    def take_name(self, name: str) -> None: ...
    def take_symbol(self, symbol: str) -> None: ...
    

class SParamClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SParamClass()
    """
    parent_class: GObject.ObjectClass = ...

class Serialize(GObject.Object):
    r"""
    :Constructors:

    ::

        Serialize(**properties)
        new(sopt:NumCosmoMath.SerializeOpt) -> NumCosmoMath.Serialize

    Object NcmSerialize

    Properties from NcmSerialize:
      options -> NcmSerializeOpt: options
        Serialization options

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        options: SerializeOpt
    props: Props = ...
    parent_instance: GObject.Object = ...
    name_ptr: dict[None, None] = ...
    ptr_name: dict[None, None] = ...
    saved_ptr_name: dict[None, None] = ...
    saved_name_ser: dict[None, None] = ...
    is_named_regex: GLib.Regex = ...
    parse_obj_regex: GLib.Regex = ...
    opts: SerializeOpt = ...
    autosave_count: int = ...
    def __init__(self, options: SerializeOpt = ...): ...
    @staticmethod
    def clear(ser: Serialize) -> None: ...
    def clear_instances(self, autosave_only: bool) -> None: ...
    def contain_instance(self, obj: GObject.Object) -> bool: ...
    def contain_name(self, name: str) -> bool: ...
    def count_instances(self) -> int: ...
    def count_saved_serializations(self) -> int: ...
    def dup_obj(self, obj: GObject.Object) -> GObject.Object: ...
    def free(self) -> None: ...
    def from_binfile(self, filename: str) -> GObject.Object: ...
    def from_file(self, filename: str) -> GObject.Object: ...
    def from_name_params(self, obj_name: str, params: GLib.Variant) -> GObject.Object: ...
    def from_string(self, obj_ser: str) -> GObject.Object: ...
    def from_variant(self, var_obj: GLib.Variant) -> GObject.Object: ...
    def get_by_name(self, name: str) -> GObject.Object: ...
    @staticmethod
    def global_() -> Serialize: ...
    @staticmethod
    def global_clear_instances(autosave_only: bool) -> None: ...
    @staticmethod
    def global_contain_instance(obj: GObject.Object) -> bool: ...
    @staticmethod
    def global_contain_name(name: str) -> bool: ...
    @staticmethod
    def global_count_instances() -> int: ...
    @staticmethod
    def global_count_saved_serializations() -> int: ...
    @staticmethod
    def global_dup_obj(obj: GObject.Object) -> GObject.Object: ...
    @staticmethod
    def global_from_binfile(filename: str) -> GObject.Object: ...
    @staticmethod
    def global_from_file(filename: str) -> GObject.Object: ...
    @staticmethod
    def global_from_name_params(obj_name: str, params: GLib.Variant) -> GObject.Object: ...
    @staticmethod
    def global_from_string(obj_ser: str) -> GObject.Object: ...
    @staticmethod
    def global_from_variant(var_obj: GLib.Variant) -> GObject.Object: ...
    @staticmethod
    def global_get_by_name(name: str) -> GObject.Object: ...
    @staticmethod
    def global_global_peek_name(obj: None) -> str: ...
    @staticmethod
    def global_gvalue_to_gvariant(val: Any) -> GLib.Variant: ...
    @staticmethod
    def global_is_named(serobj: str) -> Tuple[bool, str]: ...
    @staticmethod
    def global_log_stats() -> None: ...
    @staticmethod
    def global_remove_ser(obj: GObject.Object) -> None: ...
    @staticmethod
    def global_reset(autosave_only: bool) -> None: ...
    @staticmethod
    def global_set(obj: GObject.Object, name: str, overwrite: bool) -> None: ...
    @staticmethod
    def global_set_property(obj: GObject.Object, prop_str: str) -> None: ...
    @staticmethod
    def global_set_property_from_key_file(obj: GObject.Object, prop_file: str) -> None: ...
    @staticmethod
    def global_to_binfile(obj: GObject.Object, filename: str) -> None: ...
    @staticmethod
    def global_to_file(obj: GObject.Object, filename: str) -> None: ...
    @staticmethod
    def global_to_string(obj: GObject.Object, valid_variant: bool) -> str: ...
    @staticmethod
    def global_to_variant(obj: GObject.Object) -> GLib.Variant: ...
    @staticmethod
    def global_to_yaml(obj: GObject.Object) -> str: ...
    @staticmethod
    def global_to_yaml_file(obj: GObject.Object, filename: str) -> None: ...
    @staticmethod
    def global_unset(obj: GObject.Object) -> None: ...
    @staticmethod
    def global_variant_to_yaml(var_obj: GLib.Variant) -> str: ...
    def gvalue_to_gvariant(self, val: Any) -> GLib.Variant: ...
    def is_named(self, serobj: str) -> Tuple[bool, str]: ...
    def log_stats(self) -> None: ...
    @classmethod
    def new(cls, sopt: SerializeOpt) -> Serialize: ...
    def peek_by_name(self, name: str) -> GObject.Object: ...
    def peek_name(self, obj: GObject.Object) -> str: ...
    def ref(self) -> Serialize: ...
    def remove_ser(self, obj: GObject.Object) -> None: ...
    def reset(self, autosave_only: bool) -> None: ...
    def set(self, obj: GObject.Object, name: str, overwrite: bool) -> None: ...
    def set_property(self, obj: GObject.Object, prop_str: str) -> None: ...
    def set_property_from_key_file(self, obj: GObject.Object, prop_file: str) -> None: ...
    def to_binfile(self, obj: GObject.Object, filename: str) -> None: ...
    def to_file(self, obj: GObject.Object, filename: str) -> None: ...
    def to_string(self, obj: GObject.Object, valid_variant: bool) -> str: ...
    def to_variant(self, obj: GObject.Object) -> GLib.Variant: ...
    def to_yaml(self, obj: GObject.Object) -> str: ...
    def to_yaml_file(self, obj: GObject.Object, filename: str) -> None: ...
    def unref(self) -> None: ...
    def unset(self, obj: GObject.Object) -> None: ...
    def variant_to_yaml(self, var_obj: GLib.Variant) -> str: ...
    

class SerializeClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SerializeClass()
    """
    parent_class: GObject.ObjectClass = ...

class SerializePrivate(GObject.GPointer): ...

class SphereMap(GObject.Object):
    r"""
    :Constructors:

    ::

        SphereMap(**properties)
        new(nside:int) -> NumCosmoMath.SphereMap

    Object NcmSphereMap

    Properties from NcmSphereMap:
      nside -> gint64: nside
        nside
      order -> NcmSphereMapOrder: order
        Map pixel ordering
      coordsys -> NcmSphereMapCoordSys: coordsys
        Map coordinate system
      lmax -> guint: lmax
        max ell

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        coordsys: SphereMapCoordSys
        lmax: int
        nside: int
        order: SphereMapOrder
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: SphereMapPrivate = ...
    def __init__(self, coordsys: SphereMapCoordSys = ...,
                 lmax: int = ...,
                 nside: int = ...,
                 order: SphereMapOrder = ...): ...
    def add_noise(self, sd: float, rng: RNG) -> None: ...
    def add_to_ang(self, theta: float, phi: float, s: float) -> None: ...
    def add_to_vec(self, vec: TriVec, s: float) -> None: ...
    def alm2map(self) -> None: ...
    def ang2pix_nest(self, theta: float, phi: float) -> int: ...
    def ang2pix_ring(self, theta: float, phi: float) -> int: ...
    def calc_Ctheta(self, reltol: float) -> Spline: ...
    @staticmethod
    def clear(smap: SphereMap) -> None: ...
    def clear_smapels(self) -> None: ...
    def free(self) -> None: ...
    def get_Cl(self, l: int) -> float: ...
    def get_alm(self, l: int, m: int) -> Tuple[float, float]: ...
    def get_cap_size(self) -> int: ...
    def get_coordsys(self) -> SphereMapCoordSys: ...
    def get_lmax(self) -> int: ...
    def get_middle_size(self) -> int: ...
    def get_npix(self) -> int: ...
    def get_nrings(self) -> int: ...
    def get_nrings_cap(self) -> int: ...
    def get_nrings_middle(self) -> int: ...
    def get_nside(self) -> int: ...
    def get_nsmap(self) -> int: ...
    def get_order(self) -> SphereMapOrder: ...
    def get_pix(self, i: int) -> float: ...
    def get_ring_first_index(self, r_i: int) -> int: ...
    def get_ring_size(self, r_i: int) -> int: ...
    def load_fits(self, fits_file: str, signal_name: Optional[str] = None) -> None: ...
    def load_from_fits_catalog(self, fits_file: str, RA: str, DEC: str, S: Optional[str] = None) -> None: ...
    def nest2ring(self, nest_index: int) -> int: ...
    @classmethod
    def new(cls, nside: int) -> SphereMap: ...
    def pix2ang_nest(self, nest_index: int) -> Tuple[float, float]: ...
    def pix2ang_ring(self, ring_index: int) -> Tuple[float, float]: ...
    def pix2vec_nest(self, nest_index: int, vec: TriVec) -> None: ...
    def pix2vec_ring(self, ring_index: int, vec: TriVec) -> None: ...
    def prepare_alm(self) -> None: ...
    def ref(self) -> SphereMap: ...
    def ring2nest(self, ring_index: int) -> int: ...
    def save_fits(self, fits_file: str, signal_name: Optional[str], overwrite: bool) -> None: ...
    def set_Cls(self, Cls: Vector) -> None: ...
    def set_alm(self, l: int, m: int, Re_alm: float, Im_alm: float) -> None: ...
    def set_coordsys(self, coordsys: SphereMapCoordSys) -> None: ...
    def set_lmax(self, lmax: int) -> None: ...
    def set_map(self, map: Sequence[float]) -> None: ...
    def set_nside(self, nside: int) -> None: ...
    def set_order(self, order: SphereMapOrder) -> None: ...
    def update_Cl(self) -> None: ...
    def vec2pix_nest(self, vec: TriVec) -> int: ...
    def vec2pix_ring(self, vec: TriVec) -> int: ...
    

class SphereMapClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SphereMapClass()
    """
    parent_class: GObject.ObjectClass = ...

class SphereMapPrivate(GObject.GPointer): ...

class Spline(GObject.Object):
    r"""
    :Constructors:

    ::

        Spline(**properties)

    Object NcmSpline

    Properties from NcmSpline:
      length -> guint: length
        Spline length
      x -> NcmVector: x
        Spline knots
      y -> NcmVector: y
        Spline values

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        length: int
        x: Vector
        y: Vector
    props: Props = ...
    parent_instance: GObject.Object = ...
    len: int = ...
    xv: Vector = ...
    yv: Vector = ...
    acc: int = ...
    init: bool = ...
    empty: bool = ...
    def __init__(self, length: int = ...,
                 x: Vector = ...,
                 y: Vector = ...): ...
    @staticmethod
    def clear(s: Spline) -> None: ...
    def copy(self) -> Spline: ...
    def copy_empty(self) -> Spline: ...
    def do_copy_empty(self) -> Spline: ...
    def do_deriv(self, x: float) -> float: ...
    def do_deriv2(self, x: float) -> float: ...
    def do_deriv_nmax(self, x: float) -> float: ...
    def do_eval(self, x: float) -> float: ...
    def do_integ(self, xi: float, xf: float) -> float: ...
    def do_min_size(self) -> int: ...
    def do_name(self) -> str: ...
    def do_prepare(self) -> None: ...
    def do_prepare_base(self) -> None: ...
    def do_reset(self) -> None: ...
    def eval(self, x: float) -> float: ...
    def eval_deriv(self, x: float) -> float: ...
    def eval_deriv2(self, x: float) -> float: ...
    def eval_deriv_nmax(self, x: float) -> float: ...
    def eval_integ(self, x0: float, x1: float) -> float: ...
    def free(self) -> None: ...
    def get_bounds(self) -> Tuple[float, float]: ...
    def get_index(self, x: float) -> int: ...
    def get_len(self) -> int: ...
    def get_xv(self) -> Vector: ...
    def get_yv(self) -> Vector: ...
    def is_empty(self) -> bool: ...
    def min_size(self) -> int: ...
    def new(self, xv: Vector, yv: Vector, init: bool) -> Spline: ...
    def new_array(self, x: Sequence[float], y: Sequence[float], init: bool) -> Spline: ...
    def new_data(self, x: float, y: float, len: int, init: bool) -> Spline: ...
    def prepare(self) -> None: ...
    def prepare_base(self) -> None: ...
    def ref(self) -> Spline: ...
    def set(self, xv: Vector, yv: Vector, init: bool) -> Spline: ...
    def set_array(self, x: Sequence[float], y: Sequence[float], init: bool) -> None: ...
    def set_data_static(self, x: float, y: float, len: int, init: bool) -> None: ...
    def set_func1(self, ftype: SplineFuncType, F: Callable[[float, GObject.Object], float], obj: Optional[GObject.Object], xi: float, xf: float, max_nodes: int, rel_error: float) -> None: ...
    def set_func_grid1(self, ftype: SplineFuncType, F: Callable[[float, GObject.Object], float], obj: Optional[GObject.Object], xi: float, xf: float, nnodes: int) -> None: ...
    def set_len(self, len: int) -> None: ...
    def set_xv(self, xv: Vector, init: bool) -> None: ...
    def set_yv(self, yv: Vector, init: bool) -> None: ...
    

class Spline2d(GObject.Object):
    r"""
    :Constructors:

    ::

        Spline2d(**properties)

    Object NcmSpline2d

    Properties from NcmSpline2d:
      spline -> NcmSpline: spline
        Spline
      x-vector -> NcmVector: x-vector
        x vector
      y-vector -> NcmVector: y-vector
        y vector
      z-matrix -> NcmMatrix: z-matrix
        z matrix
      init -> gboolean: init
        init
      use-acc -> gboolean: use-acc
        Use accelerated bsearch

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        init: bool
        spline: Spline
        use_acc: bool
        x_vector: Vector
        y_vector: Vector
        z_matrix: Matrix
    props: Props = ...
    parent_instance: GObject.Object = ...
    empty: bool = ...
    init: bool = ...
    to_init: bool = ...
    s: Spline = ...
    xv: Vector = ...
    yv: Vector = ...
    x_interv: int = ...
    y_interv: int = ...
    x_data: float = ...
    y_data: float = ...
    zm: Matrix = ...
    acc_x: int = ...
    acc_y: int = ...
    use_acc: bool = ...
    no_stride: bool = ...
    def __init__(self, init: bool = ...,
                 spline: Spline = ...,
                 use_acc: bool = ...,
                 x_vector: Vector = ...,
                 y_vector: Vector = ...,
                 z_matrix: Matrix = ...): ...
    @staticmethod
    def clear(s2d: Spline2d) -> None: ...
    def copy(self) -> Spline2d: ...
    def copy_empty(self) -> Spline2d: ...
    def deriv_d2zdx2(self, x: float, y: float) -> float: ...
    def deriv_d2zdxy(self, x: float, y: float) -> float: ...
    def deriv_d2zdy2(self, x: float, y: float) -> float: ...
    def deriv_dzdx(self, x: float, y: float) -> float: ...
    def deriv_dzdy(self, x: float, y: float) -> float: ...
    def do_copy_empty(self) -> Spline2d: ...
    def do_d2zdx2(self, x: float, y: float) -> float: ...
    def do_d2zdxy(self, x: float, y: float) -> float: ...
    def do_d2zdy2(self, x: float, y: float) -> float: ...
    def do_dzdx(self, x: float, y: float) -> float: ...
    def do_dzdy(self, x: float, y: float) -> float: ...
    def do_eval(self, x: float, y: float) -> float: ...
    def do_eval_vec_y(self, x: float, y: Vector, order: Optional[Sequence[int]], res: Sequence[float]) -> None: ...
    def do_int_dx(self, xl: float, xu: float, y: float) -> float: ...
    def do_int_dxdy(self, xl: float, xu: float, yl: float, yu: float) -> float: ...
    def do_int_dy(self, x: float, yl: float, yu: float) -> float: ...
    def do_prepare(self) -> None: ...
    def do_reset(self) -> None: ...
    def eval(self, x: float, y: float) -> float: ...
    def eval_vec_y(self, x: float, y: Vector, order: Optional[Sequence[int]], res: Sequence[float]) -> None: ...
    def free(self) -> None: ...
    def integ_dx(self, xl: float, xu: float, y: float) -> float: ...
    def integ_dx_spline(self, xl: float, xu: float) -> Spline: ...
    def integ_dx_spline_val(self, xl: float, xu: float, y: float) -> float: ...
    def integ_dxdy(self, xl: float, xu: float, yl: float, yu: float) -> float: ...
    def integ_dxdy_spline_x(self, xl: float, xu: float, yl: float, yu: float) -> float: ...
    def integ_dxdy_spline_y(self, xl: float, xu: float, yl: float, yu: float) -> float: ...
    def integ_dy(self, x: float, yl: float, yu: float) -> float: ...
    def integ_dy_spline(self, yl: float, yu: float) -> Spline: ...
    def integ_dy_spline_val(self, x: float, yl: float, yu: float) -> float: ...
    def m_integ_total(self) -> float: ...
    def min_size(self) -> int: ...
    def new(self, xv: Vector, yv: Vector, zm: Matrix, init: bool) -> Spline2d: ...
    def prepare(self) -> None: ...
    def ref(self) -> Spline2d: ...
    def set(self, xv: Vector, yv: Vector, zm: Matrix, init: bool) -> None: ...
    

class Spline2dBicubic(Spline2d):
    r"""
    :Constructors:

    ::

        Spline2dBicubic(**properties)
        new(s:NumCosmoMath.Spline) -> NumCosmoMath.Spline2d
        notaknot_new() -> NumCosmoMath.Spline2d

    Object NcmSpline2dBicubic

    Properties from NcmSpline2d:
      spline -> NcmSpline: spline
        Spline
      x-vector -> NcmVector: x-vector
        x vector
      y-vector -> NcmVector: y-vector
        y vector
      z-matrix -> NcmMatrix: z-matrix
        z matrix
      init -> gboolean: init
        init
      use-acc -> gboolean: use-acc
        Use accelerated bsearch

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        init: bool
        spline: Spline
        use_acc: bool
        x_vector: Vector
        y_vector: Vector
        z_matrix: Matrix
    props: Props = ...
    parent_instance: Spline2d = ...
    z_x: Spline = ...
    dzdy_x: Spline = ...
    z_y: Spline = ...
    bicoeff: Spline2dBicubicCoeffs = ...
    optimize_dx: None = ...
    optimize_dy: None = ...
    def __init__(self, init: bool = ...,
                 spline: Spline = ...,
                 use_acc: bool = ...,
                 x_vector: Vector = ...,
                 y_vector: Vector = ...,
                 z_matrix: Matrix = ...): ...
    @staticmethod
    def bi(sc: SplineCubic, xv: Vector, yv: Vector, i: int) -> float: ...
    @staticmethod
    def bi_bip1(sc: SplineCubic, xv: Vector, yv: Vector, i: int, b_i: float, b_ip1: float) -> None: ...
    @staticmethod
    def eval_poly(sa: Spline2dBicubicCoeffs, x: float, y: float) -> float: ...
    @staticmethod
    def fij_to_aij(sf: Spline2dBicubicCoeffs, dx: float, dy: float, sa: Spline2dBicubicCoeffs) -> None: ...
    @staticmethod
    def integ_dx_coeffs(aij: Spline2dBicubicCoeffs, dy: float, coeffs: float) -> None: ...
    @staticmethod
    def integ_dy_coeffs(aij: Spline2dBicubicCoeffs, dx: float, coeffs: float) -> None: ...
    @staticmethod
    def integ_eval2d(aij: Spline2dBicubicCoeffs, x0: float, xl: float, xu: float, y0: float, yl: float, yu: float) -> float: ...
    @classmethod
    def new(cls, s: Spline) -> Spline2dBicubic: ...
    @classmethod
    def notaknot_new(cls) -> Spline2dBicubic: ...
    

class Spline2dBicubicClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        Spline2dBicubicClass()
    """
    parent_class: Spline2dClass = ...

class Spline2dBicubicCoeffs(GObject.GPointer):
    r"""
    :Constructors:

    ::

        Spline2dBicubicCoeffs()
    """
    ij: list[float] = ...

class Spline2dClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        Spline2dClass()
    """
    parent_class: GObject.ObjectClass = ...
    copy_empty: Callable[[Spline2d], Spline2d] = ...
    reset: Callable[[Spline2d], None] = ...
    prepare: Callable[[Spline2d], None] = ...
    eval: Callable[[Spline2d, float, float], float] = ...
    dzdx: Callable[[Spline2d, float, float], float] = ...
    dzdy: Callable[[Spline2d, float, float], float] = ...
    d2zdxy: Callable[[Spline2d, float, float], float] = ...
    d2zdx2: Callable[[Spline2d, float, float], float] = ...
    d2zdy2: Callable[[Spline2d, float, float], float] = ...
    int_dx: Callable[[Spline2d, float, float, float], float] = ...
    int_dy: Callable[[Spline2d, float, float, float], float] = ...
    int_dxdy: Callable[[Spline2d, float, float, float, float], float] = ...
    int_dx_spline: None = ...
    int_dy_spline: None = ...
    eval_vec_y: Callable[[Spline2d, float, Vector, Optional[Sequence[int]], Sequence[float]], None] = ...

class Spline2dGsl(Spline2d):
    r"""
    :Constructors:

    ::

        Spline2dGsl(**properties)
        natural_new() -> NumCosmoMath.Spline2d
        new(s:NumCosmoMath.Spline) -> NumCosmoMath.Spline2d

    Object NcmSpline2dGsl

    Properties from NcmSpline2d:
      spline -> NcmSpline: spline
        Spline
      x-vector -> NcmVector: x-vector
        x vector
      y-vector -> NcmVector: y-vector
        y vector
      z-matrix -> NcmMatrix: z-matrix
        z matrix
      init -> gboolean: init
        init
      use-acc -> gboolean: use-acc
        Use accelerated bsearch

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        init: bool
        spline: Spline
        use_acc: bool
        x_vector: Vector
        y_vector: Vector
        z_matrix: Matrix
    props: Props = ...
    parent_instance: Spline2d = ...
    zdiff: Matrix = ...
    vertv: Vector = ...
    vertintv: Vector = ...
    s_hor: Spline = ...
    s_dzdy: Spline = ...
    s_ver: Spline = ...
    s_ver_integ: Spline = ...
    s_hor_len: int = ...
    def __init__(self, init: bool = ...,
                 spline: Spline = ...,
                 use_acc: bool = ...,
                 x_vector: Vector = ...,
                 y_vector: Vector = ...,
                 z_matrix: Matrix = ...): ...
    @classmethod
    def natural_new(cls) -> Spline2dGsl: ...
    @classmethod
    def new(cls, s: Spline) -> Spline2dGsl: ...
    

class Spline2dGslClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        Spline2dGslClass()
    """
    parent_class: Spline2dClass = ...

class Spline2dSpline(Spline2d):
    r"""
    :Constructors:

    ::

        Spline2dSpline(**properties)
        new(s:NumCosmoMath.Spline) -> NumCosmoMath.Spline2d

    Object NcmSpline2dSpline

    Properties from NcmSpline2d:
      spline -> NcmSpline: spline
        Spline
      x-vector -> NcmVector: x-vector
        x vector
      y-vector -> NcmVector: y-vector
        y vector
      z-matrix -> NcmMatrix: z-matrix
        z matrix
      init -> gboolean: init
        init
      use-acc -> gboolean: use-acc
        Use accelerated bsearch

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        init: bool
        spline: Spline
        use_acc: bool
        x_vector: Vector
        y_vector: Vector
        z_matrix: Matrix
    props: Props = ...
    parent_instance: Spline2d = ...
    first_prepare: bool = ...
    first_prepare_integ: bool = ...
    last_x: float = ...
    last_xl: float = ...
    last_xu: float = ...
    last_yl: float = ...
    last_yu: float = ...
    vertv: Vector = ...
    vertintv: Vector = ...
    s_hor: Spline = ...
    s_ver: Spline = ...
    s_ver_integ: Spline = ...
    s_hor_len: int = ...
    def __init__(self, init: bool = ...,
                 spline: Spline = ...,
                 use_acc: bool = ...,
                 x_vector: Vector = ...,
                 y_vector: Vector = ...,
                 z_matrix: Matrix = ...): ...
    @classmethod
    def new(cls, s: Spline) -> Spline2dSpline: ...
    

class Spline2dSplineClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        Spline2dSplineClass()
    """
    parent_class: Spline2dClass = ...

class SplineClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SplineClass()
    """
    parent_class: GObject.ObjectClass = ...
    name: Callable[[Spline], str] = ...
    reset: Callable[[Spline], None] = ...
    prepare: Callable[[Spline], None] = ...
    prepare_base: Callable[[Spline], None] = ...
    min_size: Callable[[Spline], int] = ...
    eval: Callable[[Spline, float], float] = ...
    deriv: Callable[[Spline, float], float] = ...
    deriv2: Callable[[Spline, float], float] = ...
    deriv_nmax: Callable[[Spline, float], float] = ...
    integ: Callable[[Spline, float, float], float] = ...
    copy_empty: Callable[[Spline], Spline] = ...

class SplineCubic(Spline):
    r"""
    :Constructors:

    ::

        SplineCubic(**properties)

    Object NcmSplineCubic

    Properties from NcmSpline:
      length -> guint: length
        Spline length
      x -> NcmVector: x
        Spline knots
      y -> NcmVector: y
        Spline values

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        length: int
        x: Vector
        y: Vector
    props: Props = ...
    parent_instance: Spline = ...
    b: Vector = ...
    c: Vector = ...
    d: Vector = ...
    g: Vector = ...
    diag: Vector = ...
    offdiag: Vector = ...
    init: bool = ...
    len: int = ...
    def __init__(self, length: int = ...,
                 x: Vector = ...,
                 y: Vector = ...): ...

class SplineCubicClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SplineCubicClass()
    """
    parent_class: SplineClass = ...

class SplineCubicD2(SplineCubic):
    r"""
    :Constructors:

    ::

        SplineCubicD2(**properties)
        new(xv:NumCosmoMath.Vector, yv:NumCosmoMath.Vector, d2yv:NumCosmoMath.Vector, init:bool) -> NumCosmoMath.SplineCubicD2

    Object NcmSplineCubicD2

    Properties from NcmSpline:
      length -> guint: length
        Spline length
      x -> NcmVector: x
        Spline knots
      y -> NcmVector: y
        Spline values

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        length: int
        x: Vector
        y: Vector
    props: Props = ...
    parent_instance: SplineCubic = ...
    d2: Vector = ...
    len: int = ...
    def __init__(self, length: int = ...,
                 x: Vector = ...,
                 y: Vector = ...): ...
    @classmethod
    def new(cls, xv: Vector, yv: Vector, d2yv: Vector, init: bool) -> SplineCubicD2: ...
    

class SplineCubicD2Class(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SplineCubicD2Class()
    """
    parent_class: SplineCubicClass = ...

class SplineCubicNotaknot(SplineCubic):
    r"""
    :Constructors:

    ::

        SplineCubicNotaknot(**properties)
        new() -> NumCosmoMath.Spline
        new_full(xv:NumCosmoMath.Vector, yv:NumCosmoMath.Vector, init:bool) -> NumCosmoMath.Spline

    Object NcmSplineCubicNotaknot

    Properties from NcmSpline:
      length -> guint: length
        Spline length
      x -> NcmVector: x
        Spline knots
      y -> NcmVector: y
        Spline values

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        length: int
        x: Vector
        y: Vector
    props: Props = ...
    parent_instance: SplineCubic = ...
    def __init__(self, length: int = ...,
                 x: Vector = ...,
                 y: Vector = ...): ...
    @classmethod
    def new(cls) -> SplineCubicNotaknot: ...
    @classmethod
    def new_full(cls, xv: Vector, yv: Vector, init: bool) -> SplineCubicNotaknot: ...
    

class SplineCubicNotaknotClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SplineCubicNotaknotClass()
    """
    parent_class: SplineCubicClass = ...

class SplineFuncTest(GObject.Object):
    r"""
    :Constructors:

    ::

        SplineFuncTest(**properties)
        new() -> NumCosmoMath.SplineFuncTest

    Object NcmSplineFuncTest

    Properties from NcmSplineFuncTest:
      type -> NcmSplineFuncTestType: type
        Type
      ngrid -> guint: ngrid
        Number of grid nodes
      seed -> gulong: seed
        RNG seed
      par-info -> NcmMatrix: par-info
        Test function parameters information
      xi -> gdouble: xi
        Initial abscissa value
      xf -> gdouble: xf
        Final abscissa value
      rel-error -> gdouble: rel-error
        Relative error
      scale -> gdouble: scale
        Scale

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        ngrid: int
        par_info: Matrix
        rel_error: float
        scale: float
        seed: int
        type: SplineFuncTestType
        xf: float
        xi: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: SplineFuncTestPrivate = ...
    def __init__(self, ngrid: int = ...,
                 par_info: Matrix = ...,
                 rel_error: float = ...,
                 scale: float = ...,
                 seed: int = ...,
                 type: SplineFuncTestType = ...,
                 xf: float = ...,
                 xi: float = ...): ...
    @staticmethod
    def clear(sft: SplineFuncTest) -> None: ...
    def get_ngrid(self) -> int: ...
    def get_out_threshold(self) -> float: ...
    def get_params_info(self) -> Matrix: ...
    def get_rel_error(self) -> float: ...
    def get_scale(self) -> float: ...
    def get_seed(self) -> int: ...
    def get_xf(self) -> float: ...
    def get_xi(self) -> float: ...
    def log_vals_mc_stats(self) -> None: ...
    def log_vals_one_grid_stats(self) -> None: ...
    def monte_carlo(self, nsim: int) -> None: ...
    def monte_carlo_and_save_to_txt(self, nsim: int, fname: str) -> None: ...
    @classmethod
    def new(cls) -> SplineFuncTest: ...
    def peek_current_params(self) -> Vector: ...
    def prepare(self, ftype: SplineFuncType, pdftype: SplineFuncTestTypePDF) -> None: ...
    def ref(self) -> SplineFuncTest: ...
    def save_grid_functions_to_txt(self, fname: str) -> None: ...
    def save_knots_to_txt(self, fname: str) -> None: ...
    def set_ngrid(self, ngrid: int) -> None: ...
    def set_one_grid_stats(self) -> None: ...
    def set_out_threshold(self, out_threshold: float) -> None: ...
    def set_params_info(self, par_info: Matrix) -> None: ...
    def set_params_info_all(self, npar: int, p1: float, p2: float) -> None: ...
    def set_prepare_user_function(self, F_prepare: Callable[[None], None]) -> None: ...
    def set_rel_error(self, rel_error: float) -> None: ...
    def set_scale(self, scale: float) -> None: ...
    def set_seed(self, seed: int) -> None: ...
    def set_type(self, type: SplineFuncTestType) -> None: ...
    def set_user_gsl_function(self, F: int) -> None: ...
    def set_xf(self, xf: float) -> None: ...
    def set_xi(self, xi: float) -> None: ...
    def unref(self) -> None: ...
    

class SplineFuncTestClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SplineFuncTestClass()
    """
    parent_class: GObject.ObjectClass = ...

class SplineFuncTestPrivate(GObject.GPointer): ...

class SplineGsl(Spline):
    r"""
    :Constructors:

    ::

        SplineGsl(**properties)
        new(type:int) -> NumCosmoMath.Spline
        new_by_id(type_id:NumCosmoMath.SplineGslType) -> NumCosmoMath.Spline
        new_full(type:int, xv:NumCosmoMath.Vector, yv:NumCosmoMath.Vector, init:bool) -> NumCosmoMath.Spline
        new_full_by_id(type_id:NumCosmoMath.SplineGslType, xv:NumCosmoMath.Vector, yv:NumCosmoMath.Vector, init:bool) -> NumCosmoMath.Spline

    Object NcmSplineGsl

    Properties from NcmSplineGsl:
      type-name -> gchararray: type-name
        GSL Interpolation method name

    Properties from NcmSpline:
      length -> guint: length
        Spline length
      x -> NcmVector: x
        Spline knots
      y -> NcmVector: y
        Spline values

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        type_name: str
        length: int
        x: Vector
        y: Vector
    props: Props = ...
    parent_instance: Spline = ...
    interp: int = ...
    type_id: SplineGslType = ...
    inst_name: str = ...
    type: int = ...
    def __init__(self, type_name: str = ...,
                 length: int = ...,
                 x: Vector = ...,
                 y: Vector = ...): ...
    @classmethod
    def new(cls, type: int) -> SplineGsl: ...
    @classmethod
    def new_by_id(cls, type_id: SplineGslType) -> SplineGsl: ...
    @classmethod
    def new_full(cls, type: int, xv: Vector, yv: Vector, init: bool) -> SplineGsl: ...
    @classmethod
    def new_full_by_id(cls, type_id: SplineGslType, xv: Vector, yv: Vector, init: bool) -> SplineGsl: ...
    def set_type(self, type: int) -> None: ...
    def set_type_by_id(self, type_id: SplineGslType) -> None: ...
    def set_type_by_name(self, type_name: str) -> None: ...
    

class SplineGslClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SplineGslClass()
    """
    parent_class: SplineClass = ...

class SplineRBF(Spline):
    r"""
    :Constructors:

    ::

        SplineRBF(**properties)
        new(type_id:NumCosmoMath.SplineRBFType) -> NumCosmoMath.SplineRBF

    Object NcmSplineRBF

    Properties from NcmSplineRBF:
      type-id -> NcmSplineRBFType: type-id
        Type ID

    Properties from NcmSpline:
      length -> guint: length
        Spline length
      x -> NcmVector: x
        Spline knots
      y -> NcmVector: y
        Spline values

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        type_id: SplineRBFType
        length: int
        x: Vector
        y: Vector
    props: Props = ...
    parent_instance: Spline = ...
    priv: SplineRBFPrivate = ...
    def __init__(self, type_id: SplineRBFType = ...,
                 length: int = ...,
                 x: Vector = ...,
                 y: Vector = ...): ...
    @staticmethod
    def clear(rbf: SplineRBF) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, type_id: SplineRBFType) -> SplineRBF: ...
    def ref(self) -> SplineRBF: ...
    def set_shape_params(self, shape_params: Vector) -> None: ...
    def set_type(self, type_id: SplineRBFType) -> None: ...
    

class SplineRBFClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        SplineRBFClass()
    """
    parent_class: SplineClass = ...

class SplineRBFPrivate(GObject.GPointer): ...

class StatsDist(GObject.Object):
    r"""
    :Constructors:

    ::

        StatsDist(**properties)

    Object NcmStatsDist

    Properties from NcmStatsDist:
      kernel -> NcmStatsDistKernel: kernel
        Interpolating kernel
      N -> guint: N
        sample size
      over-smooth -> gdouble: over-smooth
        Over-smooth distribution
      CV-type -> NcmStatsDistCV: CV-type
        Cross-validation method
      use-threads -> gboolean: use-threads
        Whether to use OpenMP threads during computation
      split-frac -> gdouble: split-frac
        Fraction to use in the split cross-validation
      print-fit -> gboolean: print-fit
        Whether to print the fitting process

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        CV_type: StatsDistCV
        N: int
        kernel: StatsDistKernel
        over_smooth: float
        print_fit: bool
        split_frac: float
        use_threads: bool
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: StatsDistPrivate = ...
    def __init__(self, CV_type: StatsDistCV = ...,
                 kernel: StatsDistKernel = ...,
                 over_smooth: float = ...,
                 print_fit: bool = ...,
                 split_frac: float = ...,
                 use_threads: bool = ...): ...
    def add_obs(self, y: Vector) -> None: ...
    @staticmethod
    def clear(sd: StatsDist) -> None: ...
    def do_compute_IM(self, IM: Matrix) -> None: ...
    def do_eval_weights(self, weights: Vector, x: Vector) -> float: ...
    def do_eval_weights_m2lnp(self, weights: Vector, x: Vector) -> float: ...
    def do_get_href(self) -> float: ...
    def do_get_lnnorm(self, i: int) -> float: ...
    def do_peek_cov_decomp(self, i: int) -> Matrix: ...
    def do_prepare(self) -> None: ...
    def do_prepare_interp(self, m2lnp: Vector) -> None: ...
    def do_prepare_kernel(self, sample_array: Sequence[Vector]) -> None: ...
    def do_reset(self) -> None: ...
    def do_set_dim(self, dim: int) -> None: ...
    def eval(self, x: Vector) -> float: ...
    def eval_m2lnp(self, x: Vector) -> float: ...
    def free(self) -> None: ...
    def get_Ki(self, i: int) -> Tuple[Vector, Matrix, float, float]: ...
    def get_cv_type(self) -> StatsDistCV: ...
    def get_dim(self) -> int: ...
    def get_href(self) -> float: ...
    def get_kernel(self) -> StatsDistKernel: ...
    def get_lnnorm(self, i: int) -> float: ...
    def get_n_kernels(self) -> int: ...
    def get_over_smooth(self) -> float: ...
    def get_print_fit(self) -> bool: ...
    def get_rnorm(self) -> float: ...
    def get_sample_size(self) -> int: ...
    def get_split_frac(self) -> float: ...
    def get_use_threads(self) -> bool: ...
    def kernel_choose(self, rng: RNG) -> int: ...
    def peek_cov_decomp(self, i: int) -> Matrix: ...
    def peek_kernel(self) -> StatsDistKernel: ...
    def peek_sample_array(self) -> list[Vector]: ...
    def peek_weights(self) -> Vector: ...
    def prepare(self) -> None: ...
    def prepare_interp(self, m2lnp: Vector) -> None: ...
    def prepare_kernel(self, sample_array: Sequence[Vector]) -> None: ...
    def ref(self) -> StatsDist: ...
    def reset(self) -> None: ...
    def sample(self, x: Vector, rng: RNG) -> None: ...
    def set_cv_type(self, cv_type: StatsDistCV) -> None: ...
    def set_kernel(self, sdk: StatsDistKernel) -> None: ...
    def set_over_smooth(self, over_smooth: float) -> None: ...
    def set_print_fit(self, print_fit: bool) -> None: ...
    def set_split_frac(self, split_frac: float) -> None: ...
    def set_use_threads(self, use_threads: bool) -> None: ...
    

class StatsDist1d(GObject.Object):
    r"""
    :Constructors:

    ::

        StatsDist1d(**properties)

    Object NcmStatsDist1d

    Properties from NcmStatsDist1d:
      xi -> gdouble: xi
        x_i
      xf -> gdouble: xf
        x_f
      norma -> gdouble: norma
        Distribution norma
      reltol -> gdouble: reltol
        relative tolerance
      abstol -> gdouble: abstol
        Absolute tolerance on the random variables
      max-prob -> gdouble: max-prob
        Maximal probability considered
      compute-cdf -> gboolean: compute-cdf
        Whether to compute CDF and inverse CDF

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        abstol: float
        compute_cdf: bool
        max_prob: float
        norma: float
        reltol: float
        xf: float
        xi: float
    props: Props = ...
    parent_instance: GObject.Object = ...
    xi: float = ...
    xf: float = ...
    norma: float = ...
    reltol: float = ...
    abstol: float = ...
    max_prob: float = ...
    compute_cdf: bool = ...
    inv_cdf: OdeSpline = ...
    pdf: OdeSpline = ...
    fmin: int = ...
    def __init__(self, abstol: float = ...,
                 compute_cdf: bool = ...,
                 max_prob: float = ...,
                 reltol: float = ...,
                 xf: float = ...,
                 xi: float = ...): ...
    @staticmethod
    def clear(sd1: StatsDist1d) -> None: ...
    def do_get_current_h(self) -> float: ...
    def do_m2lnp(self, x: float) -> float: ...
    def do_p(self, x: float) -> float: ...
    def do_prepare(self) -> None: ...
    def eval_inv_pdf(self, u: float) -> float: ...
    def eval_inv_pdf_tail(self, v: float) -> float: ...
    def eval_m2lnp(self, x: float) -> float: ...
    def eval_mode(self) -> float: ...
    def eval_norma(self) -> float: ...
    def eval_p(self, x: float) -> float: ...
    def eval_pdf(self, x: float) -> float: ...
    def free(self) -> None: ...
    def gen(self, rng: RNG) -> float: ...
    def get_compute_cdf(self) -> bool: ...
    def get_current_h(self) -> float: ...
    def get_xf(self) -> float: ...
    def get_xi(self) -> float: ...
    def prepare(self) -> None: ...
    def ref(self) -> StatsDist1d: ...
    def set_compute_cdf(self, compute_cdf: bool) -> None: ...
    

class StatsDist1dClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDist1dClass()
    """
    parent_class: GObject.ObjectClass = ...
    p: Callable[[StatsDist1d, float], float] = ...
    m2lnp: Callable[[StatsDist1d, float], float] = ...
    prepare: Callable[[StatsDist1d], None] = ...
    get_current_h: Callable[[StatsDist1d], float] = ...

class StatsDist1dEPDF(StatsDist1d):
    r"""
    :Constructors:

    ::

        StatsDist1dEPDF(**properties)
        new(sd_min_scale:float) -> NumCosmoMath.StatsDist1dEPDF
        new_full(max_obs:int, bw:NumCosmoMath.StatsDist1dEPDFBw, h_fixed:float, sd_min_scale:float) -> NumCosmoMath.StatsDist1dEPDF

    Object NcmStatsDist1dEPDF

    Properties from NcmStatsDist1dEPDF:
      max-obs -> guint: max-obs
        Maximum observations before compacting
      n-obs -> guint: n-obs
        Number of observations
      bandwidth -> NcmStatsDist1dEPDFBw: bandwidth
        Bandwidth method
      h-fixed -> gdouble: h-fixed
        Fixed bandwidth
      sd-min-scale -> gdouble: sd-min-scale
        Percentage of the standard deviation to use as minimum distance
      outliers-threshold -> gdouble: outliers-threshold
        How many sigmas to consider an outlier

    Properties from NcmStatsDist1d:
      xi -> gdouble: xi
        x_i
      xf -> gdouble: xf
        x_f
      norma -> gdouble: norma
        Distribution norma
      reltol -> gdouble: reltol
        relative tolerance
      abstol -> gdouble: abstol
        Absolute tolerance on the random variables
      max-prob -> gdouble: max-prob
        Maximal probability considered
      compute-cdf -> gboolean: compute-cdf
        Whether to compute CDF and inverse CDF

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        bandwidth: StatsDist1dEPDFBw
        h_fixed: float
        max_obs: int
        n_obs: int
        outliers_threshold: float
        sd_min_scale: float
        abstol: float
        compute_cdf: bool
        max_prob: float
        norma: float
        reltol: float
        xf: float
        xi: float
    props: Props = ...
    parent_instance: StatsDist1d = ...
    obs_stats: StatsVec = ...
    max_obs: int = ...
    bw: StatsDist1dEPDFBw = ...
    h_fixed: float = ...
    sd_min_scale: float = ...
    outliers_threshold: float = ...
    h: float = ...
    n_obs: int = ...
    np_obs: int = ...
    WT: float = ...
    obs: list[None] = ...
    min: float = ...
    max: float = ...
    list_sorted: bool = ...
    fftsize: int = ...
    Iv: Vector = ...
    p_data: Vector = ...
    p_tilde: Vector = ...
    p_tilde2: Vector = ...
    p_est: Vector = ...
    xv: Vector = ...
    pv: Vector = ...
    fft_data_to_tilde: None = ...
    fft_tilde_to_est: None = ...
    ph_spline: Spline = ...
    p_spline: Spline = ...
    bw_set: bool = ...
    def __init__(self, bandwidth: StatsDist1dEPDFBw = ...,
                 h_fixed: float = ...,
                 max_obs: int = ...,
                 outliers_threshold: float = ...,
                 sd_min_scale: float = ...,
                 abstol: float = ...,
                 compute_cdf: bool = ...,
                 max_prob: float = ...,
                 reltol: float = ...,
                 xf: float = ...,
                 xi: float = ...): ...
    def add_obs(self, x: float) -> None: ...
    def add_obs_weight(self, x: float, w: float) -> None: ...
    @staticmethod
    def clear(epdf1d: StatsDist1dEPDF) -> None: ...
    def free(self) -> None: ...
    def get_bw_type(self) -> StatsDist1dEPDFBw: ...
    def get_obs_mean(self) -> float: ...
    @classmethod
    def new(cls, sd_min_scale: float) -> StatsDist1dEPDF: ...
    @classmethod
    def new_full(cls, max_obs: int, bw: StatsDist1dEPDFBw, h_fixed: float, sd_min_scale: float) -> StatsDist1dEPDF: ...
    def ref(self) -> StatsDist1dEPDF: ...
    def reset(self) -> None: ...
    def set_bw_type(self, bw: StatsDist1dEPDFBw) -> None: ...
    def set_max(self, max: float) -> None: ...
    def set_min(self, min: float) -> None: ...
    

class StatsDist1dEPDFClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDist1dEPDFClass()
    """
    parent_class: StatsDist1dClass = ...

class StatsDist1dSpline(StatsDist1d):
    r"""
    :Constructors:

    ::

        StatsDist1dSpline(**properties)
        new(m2lnp:NumCosmoMath.Spline) -> NumCosmoMath.StatsDist1dSpline

    Object NcmStatsDist1dSpline

    Properties from NcmStatsDist1dSpline:
      m2lnp -> NcmSpline: m2lnp
        m2lnp
      tail-sigma -> gdouble: tail-sigma
        Tail sigma

    Properties from NcmStatsDist1d:
      xi -> gdouble: xi
        x_i
      xf -> gdouble: xf
        x_f
      norma -> gdouble: norma
        Distribution norma
      reltol -> gdouble: reltol
        relative tolerance
      abstol -> gdouble: abstol
        Absolute tolerance on the random variables
      max-prob -> gdouble: max-prob
        Maximal probability considered
      compute-cdf -> gboolean: compute-cdf
        Whether to compute CDF and inverse CDF

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        m2lnp: Spline
        tail_sigma: float
        abstol: float
        compute_cdf: bool
        max_prob: float
        norma: float
        reltol: float
        xf: float
        xi: float
    props: Props = ...
    parent_instance: StatsDist1d = ...
    m2lnp: Spline = ...
    tail_sigma: float = ...
    left_tail: StatsDist1dSplineTail = ...
    right_tail: StatsDist1dSplineTail = ...
    def __init__(self, m2lnp: Spline = ...,
                 tail_sigma: float = ...,
                 abstol: float = ...,
                 compute_cdf: bool = ...,
                 max_prob: float = ...,
                 reltol: float = ...,
                 xf: float = ...,
                 xi: float = ...): ...
    @classmethod
    def new(cls, m2lnp: Spline) -> StatsDist1dSpline: ...
    

class StatsDist1dSplineClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDist1dSplineClass()
    """
    parent_class: StatsDist1dClass = ...

class StatsDist1dSplineTail(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDist1dSplineTail()
    """
    xb: float = ...
    a: float = ...
    b: float = ...
    c: float = ...

class StatsDist2d(GObject.Object):
    r"""
    :Constructors:

    ::

        StatsDist2d(**properties)

    Object NcmStatsDist2d

    Signals from GObject:
      notify (GParam)
    """
    parent_instance: GObject.Object = ...
    @staticmethod
    def clear(sd2: StatsDist2d) -> None: ...
    def do_cdf(self, x: float, y: float) -> float: ...
    def do_inv_cond(self, u: float, xy: float) -> float: ...
    def do_m2lnp(self, x: float, y: float) -> float: ...
    def do_marginal_cdf(self, xy: float) -> float: ...
    def do_marginal_inv_cdf(self, u: float) -> float: ...
    def do_marginal_pdf(self, xy: float) -> float: ...
    def do_pdf(self, x: float, y: float) -> float: ...
    def do_prepare(self) -> None: ...
    def do_xbounds(self) -> Tuple[float, float]: ...
    def do_ybounds(self) -> Tuple[float, float]: ...
    def eval_cdf(self, x: float, y: float) -> float: ...
    def eval_inv_cond(self, u: float, xy: float) -> float: ...
    def eval_m2lnp(self, x: float, y: float) -> float: ...
    def eval_marginal_cdf(self, xy: float) -> float: ...
    def eval_marginal_inv_cdf(self, xy: float) -> float: ...
    def eval_marginal_pdf(self, xy: float) -> float: ...
    def eval_pdf(self, x: float, y: float) -> float: ...
    def free(self) -> None: ...
    def prepare(self) -> None: ...
    def ref(self) -> StatsDist2d: ...
    def xbounds(self) -> Tuple[float, float]: ...
    def ybounds(self) -> Tuple[float, float]: ...
    

class StatsDist2dClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDist2dClass()
    """
    parent_class: GObject.ObjectClass = ...
    xbounds: Callable[[StatsDist2d], Tuple[float, float]] = ...
    ybounds: Callable[[StatsDist2d], Tuple[float, float]] = ...
    pdf: Callable[[StatsDist2d, float, float], float] = ...
    m2lnp: Callable[[StatsDist2d, float, float], float] = ...
    cdf: Callable[[StatsDist2d, float, float], float] = ...
    marginal_pdf: Callable[[StatsDist2d, float], float] = ...
    marginal_cdf: Callable[[StatsDist2d, float], float] = ...
    marginal_inv_cdf: Callable[[StatsDist2d, float], float] = ...
    inv_cond: Callable[[StatsDist2d, float, float], float] = ...
    prepare: Callable[[StatsDist2d], None] = ...

class StatsDist2dSpline(StatsDist2d):
    r"""
    :Constructors:

    ::

        StatsDist2dSpline(**properties)
        new(m2lnp:NumCosmoMath.Spline2d) -> NumCosmoMath.StatsDist2dSpline

    Object NcmStatsDist2dSpline

    Properties from NcmStatsDist2dSpline:
      m2lnp -> NcmSpline2d: m2lnp
        m2lnp
      marginal-x -> gboolean: marginal-x
        Compute marginal with respect to x if True, and y if False.

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        m2lnp: Spline2d
        marginal_x: bool
    props: Props = ...
    parent_instance: StatsDist2d = ...
    m2lnp: Spline2d = ...
    marginal_x: bool = ...
    norma: float = ...
    m2lnnorma: float = ...
    def __init__(self, m2lnp: Spline2d = ...,
                 marginal_x: bool = ...): ...
    @classmethod
    def new(cls, m2lnp: Spline2d) -> StatsDist2dSpline: ...
    

class StatsDist2dSplineClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDist2dSplineClass()
    """
    parent_class: StatsDist2dClass = ...

class StatsDistClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDistClass()
    """
    parent_class: GObject.ObjectClass = ...
    set_dim: Callable[[StatsDist, int], None] = ...
    get_href: Callable[[StatsDist], float] = ...
    prepare_kernel: Callable[[StatsDist, Sequence[Vector]], None] = ...
    prepare: Callable[[StatsDist], None] = ...
    prepare_interp: Callable[[StatsDist, Vector], None] = ...
    compute_IM: Callable[[StatsDist, Matrix], None] = ...
    peek_cov_decomp: Callable[[StatsDist, int], Matrix] = ...
    get_lnnorm: Callable[[StatsDist, int], float] = ...
    eval_weights: Callable[[StatsDist, Vector, Vector], float] = ...
    eval_weights_m2lnp: Callable[[StatsDist, Vector, Vector], float] = ...
    reset: Callable[[StatsDist], None] = ...

class StatsDistKDE(StatsDist):
    r"""
    :Constructors:

    ::

        StatsDistKDE(**properties)
        new(sdk:NumCosmoMath.StatsDistKernel, CV_type:NumCosmoMath.StatsDistCV) -> NumCosmoMath.StatsDistKDE

    Object NcmStatsDistKDE

    Properties from NcmStatsDistKDE:
      nearPD-maxiter -> guint: nearPD-maxiter
        Maximum number of iterations in the nearPD call
      cov-type -> NcmStatsDistKDECovType: cov-type
        Covariance type
      cov-fixed -> NcmMatrix: cov-fixed
        Fixed covariance matrix

    Properties from NcmStatsDist:
      kernel -> NcmStatsDistKernel: kernel
        Interpolating kernel
      N -> guint: N
        sample size
      over-smooth -> gdouble: over-smooth
        Over-smooth distribution
      CV-type -> NcmStatsDistCV: CV-type
        Cross-validation method
      use-threads -> gboolean: use-threads
        Whether to use OpenMP threads during computation
      split-frac -> gdouble: split-frac
        Fraction to use in the split cross-validation
      print-fit -> gboolean: print-fit
        Whether to print the fitting process

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        cov_fixed: Matrix
        cov_type: StatsDistKDECovType
        nearPD_maxiter: int
        CV_type: StatsDistCV
        N: int
        kernel: StatsDistKernel
        over_smooth: float
        print_fit: bool
        split_frac: float
        use_threads: bool
    props: Props = ...
    parent_instance: StatsDist = ...
    priv: StatsDistKDEPrivate = ...
    def __init__(self, cov_fixed: Matrix = ...,
                 cov_type: StatsDistKDECovType = ...,
                 nearPD_maxiter: int = ...,
                 CV_type: StatsDistCV = ...,
                 kernel: StatsDistKernel = ...,
                 over_smooth: float = ...,
                 print_fit: bool = ...,
                 split_frac: float = ...,
                 use_threads: bool = ...): ...
    @staticmethod
    def clear(sdkde: StatsDistKDE) -> None: ...
    def free(self) -> None: ...
    def get_cov_type(self) -> StatsDistKDECovType: ...
    def get_nearPD_maxiter(self) -> int: ...
    @classmethod
    def new(cls, sdk: StatsDistKernel, CV_type: StatsDistCV) -> StatsDistKDE: ...
    def peek_cov_fixed(self) -> Optional[Matrix]: ...
    def ref(self) -> StatsDistKDE: ...
    def set_cov_fixed(self, cov_fixed: Matrix) -> None: ...
    def set_cov_type(self, cov_type: StatsDistKDECovType) -> None: ...
    def set_nearPD_maxiter(self, maxiter: int) -> None: ...
    

class StatsDistKDEClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDistKDEClass()
    """
    parent_class: StatsDistClass = ...

class StatsDistKDEPrivate(GObject.GPointer): ...

class StatsDistKernel(GObject.Object):
    r"""
    :Constructors:

    ::

        StatsDistKernel(**properties)

    Object NcmStatsDistKernel

    Properties from NcmStatsDistKernel:
      dimension -> guint: dimension
        Kernel dimension

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        dimension: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    priv: StatsDistKernelPrivate = ...
    def __init__(self, dimension: int = ...): ...
    @staticmethod
    def clear(sdk: StatsDistKernel) -> None: ...
    def do_eval_sum0_gamma_lambda(self, chi2: Vector, weights: Vector, lnnorms: Vector, lnK: Vector) -> Tuple[float, float]: ...
    def do_eval_sum1_gamma_lambda(self, chi2: Vector, weights: Vector, lnnorm: float, lnK: Vector) -> Tuple[float, float]: ...
    def do_eval_unnorm(self, chi2: float) -> float: ...
    def do_eval_unnorm_vec(self, chi2: Vector, Ku: Vector) -> None: ...
    def do_get_dim(self) -> int: ...
    def do_get_lnnorm(self, cov_decomp: Matrix) -> float: ...
    def do_get_rot_bandwidth(self, n: float) -> float: ...
    def do_sample(self, cov_decomp: Matrix, href: float, mu: Vector, y: Vector, rng: RNG) -> None: ...
    def do_set_dim(self, dim: int) -> None: ...
    def eval_sum0_gamma_lambda(self, chi2: Vector, weights: Vector, lnnorms: Vector, lnK: Vector) -> Tuple[float, float]: ...
    def eval_sum1_gamma_lambda(self, chi2: Vector, weights: Vector, lnnorm: float, lnK: Vector) -> Tuple[float, float]: ...
    def eval_unnorm(self, chi2: float) -> float: ...
    def eval_unnorm_vec(self, chi2: Vector, Ku: Vector) -> None: ...
    def free(self) -> None: ...
    def get_dim(self) -> int: ...
    def get_lnnorm(self, cov_decomp: Matrix) -> float: ...
    def get_rot_bandwidth(self, n: float) -> float: ...
    def ref(self) -> StatsDistKernel: ...
    def sample(self, cov_decomp: Matrix, href: float, mu: Vector, y: Vector, rng: RNG) -> None: ...
    

class StatsDistKernelClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDistKernelClass()
    """
    parent_class: GObject.ObjectClass = ...
    set_dim: Callable[[StatsDistKernel, int], None] = ...
    get_dim: Callable[[StatsDistKernel], int] = ...
    get_rot_bandwidth: Callable[[StatsDistKernel, float], float] = ...
    get_lnnorm: Callable[[StatsDistKernel, Matrix], float] = ...
    eval_unnorm: Callable[[StatsDistKernel, float], float] = ...
    eval_unnorm_vec: Callable[[StatsDistKernel, Vector, Vector], None] = ...
    eval_sum0_gamma_lambda: Callable[[StatsDistKernel, Vector, Vector, Vector, Vector], Tuple[float, float]] = ...
    eval_sum1_gamma_lambda: Callable[[StatsDistKernel, Vector, Vector, float, Vector], Tuple[float, float]] = ...
    sample: Callable[[StatsDistKernel, Matrix, float, Vector, Vector, RNG], None] = ...

class StatsDistKernelGauss(StatsDistKernel):
    r"""
    :Constructors:

    ::

        StatsDistKernelGauss(**properties)
        new(dim:int) -> NumCosmoMath.StatsDistKernelGauss

    Object NcmStatsDistKernelGauss

    Properties from NcmStatsDistKernel:
      dimension -> guint: dimension
        Kernel dimension

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        dimension: int
    props: Props = ...
    parent_instance: StatsDistKernel = ...
    priv: StatsDistKernelGaussPrivate = ...
    def __init__(self, dimension: int = ...): ...
    @staticmethod
    def clear(sdkg: StatsDistKernelGauss) -> None: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls, dim: int) -> StatsDistKernelGauss: ...
    def ref(self) -> StatsDistKernelGauss: ...
    

class StatsDistKernelGaussClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDistKernelGaussClass()
    """
    parent_class: StatsDistKernelClass = ...

class StatsDistKernelGaussPrivate(GObject.GPointer): ...

class StatsDistKernelPrivate(GObject.GPointer): ...

class StatsDistKernelST(StatsDistKernel):
    r"""
    :Constructors:

    ::

        StatsDistKernelST(**properties)
        new(dim:int, nu:float) -> NumCosmoMath.StatsDistKernelST

    Object NcmStatsDistKernelST

    Properties from NcmStatsDistKernelST:
      nu -> gdouble: nu
        nu value of the function

    Properties from NcmStatsDistKernel:
      dimension -> guint: dimension
        Kernel dimension

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        nu: float
        dimension: int
    props: Props = ...
    parent_instance: StatsDistKernel = ...
    priv: StatsDistKernelSTPrivate = ...
    def __init__(self, nu: float = ...,
                 dimension: int = ...): ...
    @staticmethod
    def clear(sdkst: StatsDistKernelST) -> None: ...
    def free(self) -> None: ...
    def get_nu(self) -> float: ...
    @classmethod
    def new(cls, dim: int, nu: float) -> StatsDistKernelST: ...
    def ref(self) -> StatsDistKernelST: ...
    def set_nu(self, nu: float) -> None: ...
    

class StatsDistKernelSTClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDistKernelSTClass()
    """
    parent_class: StatsDistKernelClass = ...

class StatsDistKernelSTPrivate(GObject.GPointer): ...

class StatsDistPrivate(GObject.GPointer): ...

class StatsDistVKDE(StatsDistKDE):
    r"""
    :Constructors:

    ::

        StatsDistVKDE(**properties)
        new(sdk:NumCosmoMath.StatsDistKernel, CV_type:NumCosmoMath.StatsDistCV) -> NumCosmoMath.StatsDistVKDE

    Object NcmStatsDistVKDE

    Properties from NcmStatsDistVKDE:
      local-frac -> gdouble: local-frac
        Fraction to use in the local kernel covariance computation
      use-rot-href -> gboolean: use-rot-href
        Whether to use the href rule-of-thumb to compute the final bandwidth

    Properties from NcmStatsDistKDE:
      nearPD-maxiter -> guint: nearPD-maxiter
        Maximum number of iterations in the nearPD call
      cov-type -> NcmStatsDistKDECovType: cov-type
        Covariance type
      cov-fixed -> NcmMatrix: cov-fixed
        Fixed covariance matrix

    Properties from NcmStatsDist:
      kernel -> NcmStatsDistKernel: kernel
        Interpolating kernel
      N -> guint: N
        sample size
      over-smooth -> gdouble: over-smooth
        Over-smooth distribution
      CV-type -> NcmStatsDistCV: CV-type
        Cross-validation method
      use-threads -> gboolean: use-threads
        Whether to use OpenMP threads during computation
      split-frac -> gdouble: split-frac
        Fraction to use in the split cross-validation
      print-fit -> gboolean: print-fit
        Whether to print the fitting process

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        local_frac: float
        use_rot_href: bool
        cov_fixed: Matrix
        cov_type: StatsDistKDECovType
        nearPD_maxiter: int
        CV_type: StatsDistCV
        N: int
        kernel: StatsDistKernel
        over_smooth: float
        print_fit: bool
        split_frac: float
        use_threads: bool
    props: Props = ...
    parent_instance: StatsDistKDE = ...
    priv: StatsDistVKDEPrivate = ...
    def __init__(self, local_frac: float = ...,
                 use_rot_href: bool = ...,
                 cov_fixed: Matrix = ...,
                 cov_type: StatsDistKDECovType = ...,
                 nearPD_maxiter: int = ...,
                 CV_type: StatsDistCV = ...,
                 kernel: StatsDistKernel = ...,
                 over_smooth: float = ...,
                 print_fit: bool = ...,
                 split_frac: float = ...,
                 use_threads: bool = ...): ...
    @staticmethod
    def clear(sdvkde: StatsDistVKDE) -> None: ...
    def free(self) -> None: ...
    def get_local_frac(self) -> float: ...
    def get_use_rot_href(self) -> bool: ...
    @classmethod
    def new(cls, sdk: StatsDistKernel, CV_type: StatsDistCV) -> StatsDistVKDE: ...
    def ref(self) -> StatsDistVKDE: ...
    def set_local_frac(self, local_frac: float) -> None: ...
    def set_use_rot_href(self, use_rot_href: bool) -> None: ...
    

class StatsDistVKDEClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsDistVKDEClass()
    """
    parent_class: StatsDistKDEClass = ...

class StatsDistVKDEPrivate(GObject.GPointer): ...

class StatsVec(GObject.Object):
    r"""
    :Constructors:

    ::

        StatsVec(**properties)
        new(len:int, t:NumCosmoMath.StatsVecType, save_x:bool) -> NumCosmoMath.StatsVec

    Object NcmStatsVec

    Properties from NcmStatsVec:
      length -> guint: length
        Statistics vector length
      type -> NcmStatsVecType: type
        Statistics vector type
      save-x -> gboolean: save-x
        Whenever to save all x vectors

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        length: int
        save_x: bool
        type: StatsVecType
    props: Props = ...
    parent_instance: GObject.Object = ...
    t: StatsVecType = ...
    update: Callable[[StatsVec, float, Vector], None] = ...
    tmp: StatsVec = ...
    len: int = ...
    save_x: bool = ...
    weight: float = ...
    weight2: float = ...
    bias_wt: float = ...
    nitens: int = ...
    x: Vector = ...
    mean: Vector = ...
    var: Vector = ...
    cov: Matrix = ...
    real_cov: Matrix = ...
    saved_x: list[None] = ...
    q_array: list[None] = ...
    fft_size: int = ...
    fft_plan_size: int = ...
    param_data: float = ...
    param_fft: int = ...
    param_r2c: int = ...
    param_c2r: int = ...
    def __init__(self, length: int = ...,
                 save_x: bool = ...,
                 type: StatsVecType = ...): ...
    def append(self, x: Vector, dup: bool) -> None: ...
    def append_data(self, data: Sequence[Vector], dup: bool) -> None: ...
    def append_weight(self, x: Vector, w: float, dup: bool) -> None: ...
    def ar_ess(self, p: int, ar_crit: StatsVecARType) -> Tuple[float, float, int]: ...
    @staticmethod
    def clear(svec: StatsVec) -> None: ...
    def compute_cov_robust_diag(self) -> Matrix: ...
    def compute_cov_robust_ogk(self) -> Matrix: ...
    def disable_quantile(self) -> None: ...
    def dup_saved_x(self) -> list[Vector]: ...
    def enable_quantile(self, p: float) -> None: ...
    def estimate_const_break(self, p: int) -> float: ...
    def fit_ar_model(self, p: int, order: int, ar_crit: StatsVecARType) -> Tuple[bool, Vector, Vector, float, int]: ...
    def free(self) -> None: ...
    def get(self, i: int) -> float: ...
    def get_autocorr(self, p: int) -> Vector: ...
    def get_autocorr_tau(self, p: int, max_lag: int) -> float: ...
    def get_cor(self, i: int, j: int) -> float: ...
    def get_cov(self, i: int, j: int) -> float: ...
    def get_cov_matrix(self, m: Matrix, offset: int) -> None: ...
    def get_mean(self, i: int) -> float: ...
    def get_mean_vector(self, mean: Vector, offset: int) -> None: ...
    def get_param_at(self, i: int, p: int) -> float: ...
    def get_quantile(self, i: int) -> float: ...
    def get_quantile_spread(self, i: int) -> float: ...
    def get_sd(self, i: int) -> float: ...
    def get_subsample_autocorr(self, p: int, subsample: int) -> Vector: ...
    def get_subsample_autocorr_tau(self, p: int, subsample: int, max_lag: int) -> float: ...
    def get_var(self, i: int) -> float: ...
    def get_weight(self) -> float: ...
    def heidel_diag(self, ntests: int, pvalue: float) -> Tuple[Vector, int, int, int, float]: ...
    def max_ess_time(self, ntests: int) -> Tuple[Vector, int, int, int, float]: ...
    @classmethod
    def new(cls, len: int, t: StatsVecType, save_x: bool) -> StatsVec: ...
    def nrows(self) -> int: ...
    def peek_cov_matrix(self, offset: int) -> Matrix: ...
    def peek_mean(self) -> Vector: ...
    def peek_row(self, i: int) -> Vector: ...
    def peek_x(self) -> Vector: ...
    def prepend(self, x: Vector, dup: bool) -> None: ...
    def prepend_data(self, data: Sequence[Vector], dup: bool) -> None: ...
    def prepend_weight(self, x: Vector, w: float, dup: bool) -> None: ...
    def ref(self) -> StatsVec: ...
    def reset(self, rm_saved: bool) -> None: ...
    def set(self, i: int, x_i: float) -> None: ...
    def update_weight(self, w: float) -> None: ...
    def visual_heidel_diag(self, p: int, fi: int) -> Tuple[Vector, float, float]: ...
    

class StatsVecClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        StatsVecClass()
    """
    parent_class: GObject.ObjectClass = ...

class Timer(GObject.Object):
    r"""
    :Constructors:

    ::

        Timer(**properties)
        new() -> NumCosmoMath.Timer

    Object NcmTimer

    Properties from NcmTimer:
      name -> gchararray: name
        Timer's name
      task-len -> guint: task-len
        Task length
      task-pos -> guint: task-pos
        Task position

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        name: str
        task_len: int
        task_pos: int
    props: Props = ...
    parent_instance: GObject.Object = ...
    gt: GLib.Timer = ...
    name: str = ...
    task_len: int = ...
    task_pos: int = ...
    pos_time: float = ...
    last_log_time: float = ...
    time_stats: StatsVec = ...
    msg: GLib.String = ...
    msg_tmp1: GLib.String = ...
    msg_tmp2: GLib.String = ...
    def __init__(self, name: str = ...): ...
    @staticmethod
    def clear(nt: Timer) -> None: ...
    def continue_(self) -> None: ...
    def elapsed(self) -> float: ...
    def elapsed_dhms(self) -> Tuple[int, int, int, float]: ...
    def elapsed_dhms_str(self) -> str: ...
    def free(self) -> None: ...
    @classmethod
    def new(cls) -> Timer: ...
    def ref(self) -> Timer: ...
    def set_name(self, name: str) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def task_accumulate(self, nitens: int) -> None: ...
    def task_add_tasks(self, ptasks: int) -> None: ...
    def task_continue(self) -> None: ...
    def task_cur_datetime_str(self) -> str: ...
    def task_elapsed_str(self) -> str: ...
    def task_end(self) -> bool: ...
    def task_end_datetime_str(self) -> str: ...
    def task_estimate_by_time(self, sec: float) -> int: ...
    def task_increment(self) -> None: ...
    def task_is_running(self) -> bool: ...
    def task_log_cur_datetime(self) -> None: ...
    def task_log_elapsed(self) -> None: ...
    def task_log_end_datetime(self) -> None: ...
    def task_log_mean_time(self) -> None: ...
    def task_log_start_datetime(self) -> None: ...
    def task_log_time_left(self) -> None: ...
    def task_mean_time(self) -> float: ...
    def task_mean_time_str(self) -> str: ...
    def task_pause(self) -> None: ...
    def task_start(self, task_len: int) -> None: ...
    def task_start_datetime_str(self) -> str: ...
    def task_time_left(self) -> float: ...
    def task_time_left_str(self) -> str: ...
    

class TimerClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        TimerClass()
    """
    parent_class: GObject.ObjectClass = ...

class TriVec(GObject.GBoxed):
    r"""
    :Constructors:

    ::

        TriVec()
        new() -> NumCosmoMath.TriVec
        new_full(c:float) -> NumCosmoMath.TriVec
        new_full_c(x:float, y:float, z:float) -> NumCosmoMath.TriVec
    """
    c: list[float] = ...
    def dot(self, v2: TriVec) -> float: ...
    def dup(self) -> TriVec: ...
    def free(self) -> None: ...
    def get_phi(self) -> float: ...
    def get_spherical_coord(self) -> Tuple[float, float]: ...
    def memcpy(self, orig: TriVec) -> None: ...
    @classmethod
    def new(cls) -> TriVec: ...
    @classmethod
    def new_full(cls, c: float) -> TriVec: ...
    @classmethod
    def new_full_c(cls, x: float, y: float, z: float) -> TriVec: ...
    def norm(self) -> float: ...
    def normalize(self) -> None: ...
    def scale(self, scale: float) -> None: ...
    def set_0(self) -> None: ...
    def set_spherical_coord(self, r: float, theta: float, phi: float) -> None: ...
    

class VParam(GObject.Object):
    r"""
    :Constructors:

    ::

        VParam(**properties)
        full_new(len:int, name:str, symbol:str, lower_bound:float, upper_bound:float, scale:float, abstol:float, default_val:float, ftype:NumCosmoMath.ParamType) -> NumCosmoMath.VParam
        new(len:int, default_param:NumCosmoMath.SParam) -> NumCosmoMath.VParam

    Object NcmVParam

    Properties from NcmVParam:
      default-sparam -> NcmSParam: default-sparam
        Default sparam for the vector components

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        default_sparam: SParam
    props: Props = ...
    parent_instance: GObject.Object = ...
    len: int = ...
    default_sparam: SParam = ...
    sparam: list[None] = ...
    def __init__(self, default_sparam: SParam = ...): ...
    @staticmethod
    def clear(vparam: VParam) -> None: ...
    def copy(self) -> VParam: ...
    def free(self) -> None: ...
    @classmethod
    def full_new(cls, len: int, name: str, symbol: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_val: float, ftype: ParamType) -> VParam: ...
    def get_absolute_tolerance(self, n: int) -> float: ...
    def get_default_value(self, n: int) -> float: ...
    def get_fit_type(self, n: int) -> ParamType: ...
    def get_len(self) -> int: ...
    def get_lower_bound(self, n: int) -> float: ...
    def get_scale(self, n: int) -> float: ...
    def get_sparam(self, n: int) -> SParam: ...
    def get_upper_bound(self, n: int) -> float: ...
    def name(self) -> str: ...
    @classmethod
    def new(cls, len: int, default_param: SParam) -> VParam: ...
    def peek_sparam(self, n: int) -> SParam: ...
    def ref(self) -> VParam: ...
    def set_absolute_tolerance(self, n: int, abstol: float) -> None: ...
    def set_default_value(self, n: int, default_val: float) -> None: ...
    def set_fit_type(self, n: int, ftype: ParamType) -> None: ...
    def set_len(self, len: int) -> None: ...
    def set_lower_bound(self, n: int, lb: float) -> None: ...
    def set_scale(self, n: int, scale: float) -> None: ...
    def set_sparam(self, n: int, spn: SParam) -> None: ...
    def set_sparam_full(self, n: int, name: str, symbol: str, lower_bound: float, upper_bound: float, scale: float, abstol: float, default_val: float, ftype: ParamType) -> None: ...
    def set_upper_bound(self, n: int, ub: float) -> None: ...
    def symbol(self) -> str: ...
    

class VParamClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        VParamClass()
    """
    parent_class: GObject.ObjectClass = ...

class Vector(GObject.Object):
    r"""
    :Constructors:

    ::

        Vector(**properties)
        const_new_data(d:list, size:int, stride:int) -> NumCosmoMath.Vector
        const_new_variant(var:GLib.Variant) -> NumCosmoMath.Vector
        new(n:int) -> NumCosmoMath.Vector
        new_array(a:list) -> NumCosmoMath.Vector
        new_data_dup(d:list, size:int, stride:int) -> NumCosmoMath.Vector
        new_data_malloc(d:list, size:int, stride:int) -> NumCosmoMath.Vector
        new_data_slice(d:list, size:int, stride:int) -> NumCosmoMath.Vector
        new_data_static(d:list, size:int, stride:int) -> NumCosmoMath.Vector
        new_fftw(size:int) -> NumCosmoMath.Vector
        new_full(d:list, size:int, stride:int, pdata=None, pfree:GLib.DestroyNotify=None) -> NumCosmoMath.Vector
        new_variant(var:GLib.Variant) -> NumCosmoMath.Vector

    Object NcmVector

    Properties from NcmVector:
      values -> GVariant: values
        values

    Signals from GObject:
      notify (GParam)
    """
    class Props:
        values: GLib.Variant
    props: Props = ...
    parent_instance: GObject.Object = ...
    vv: int = ...
    pdata: None = ...
    pfree: Callable[[None], None] = ...
    type: VectorInternal = ...
    def __init__(self, values: GLib.Variant = ...): ...
    def add(self, cv2: Vector) -> None: ...
    def add_constant(self, val: float) -> None: ...
    def addto(self, i: int, val: float) -> None: ...
    def axpy(self, alpha: float, cv2: Vector) -> None: ...
    def between(self, cv_lb: Vector, cv_ub: Vector, type: int) -> bool: ...
    @staticmethod
    def clear(cv: Vector) -> None: ...
    def cmp(self, cv2: Vector) -> None: ...
    def cmp2(self, cv2: Vector, reltol: float, abstol: float) -> int: ...
    def const_data(self) -> float: ...
    def const_free(self) -> None: ...
    @classmethod
    def const_new_data(cls, d: Sequence[float], size: int, stride: int) -> Vector: ...
    @classmethod
    def const_new_variant(cls, var: GLib.Variant) -> Vector: ...
    def const_ptr(self, i: int) -> float: ...
    def const_ref(self) -> Vector: ...
    def data(self) -> float: ...
    def div(self, cv2: Vector) -> None: ...
    def dnrm2(self) -> float: ...
    def dot(self, cv2: Vector) -> float: ...
    def dup(self) -> Vector: ...
    def dup_array(self) -> list[float]: ...
    def fast_addto(self, i: int, val: float) -> None: ...
    def fast_get(self, i: int) -> float: ...
    def fast_mulby(self, i: int, val: float) -> None: ...
    def fast_ptr(self, i: int) -> float: ...
    def fast_set(self, i: int, val: float) -> None: ...
    def fast_subfrom(self, i: int, val: float) -> None: ...
    def find_closest_index(self, x: float) -> int: ...
    def free(self) -> None: ...
    def get(self, i: int) -> float: ...
    def get_absminmax(self) -> Tuple[float, float]: ...
    def get_array(self) -> list[float]: ...
    def get_max(self) -> float: ...
    def get_max_index(self) -> int: ...
    def get_min(self) -> float: ...
    def get_min_index(self) -> int: ...
    def get_minmax(self) -> Tuple[float, float]: ...
    def get_subvector(self, k: int, size: int) -> Vector: ...
    def get_subvector_stride(self, k: int, size: int, stride: int) -> Vector: ...
    def get_variant(self) -> GLib.Variant: ...
    def hypot(self, a: float, cv2: Vector) -> None: ...
    def is_finite(self) -> bool: ...
    def len(self) -> int: ...
    def log_vals(self, prestr: str, format: str, cr: bool) -> None: ...
    def log_vals_avpb(self, prestr: str, format: str, a: float, b: float) -> None: ...
    def log_vals_func(self, prestr: str, format: str, f: Callable[..., float], *user_data: Any) -> None: ...
    def lt(self, cv2: Vector) -> bool: ...
    def lteq(self, cv2: Vector) -> bool: ...
    def mean(self) -> float: ...
    def memcpy(self, cv2: Vector) -> None: ...
    def memcpy2(self, cv2: Vector, cv1_start: int, cv2_start: int, size: int) -> None: ...
    def mul(self, cv2: Vector) -> None: ...
    def mulby(self, i: int, val: float) -> None: ...
    @classmethod
    def new(cls, n: int) -> Vector: ...
    @classmethod
    def new_array(cls, a: Sequence[float]) -> Vector: ...
    @classmethod
    def new_data_dup(cls, d: Sequence[float], size: int, stride: int) -> Vector: ...
    @classmethod
    def new_data_malloc(cls, d: Sequence[float], size: int, stride: int) -> Vector: ...
    @classmethod
    def new_data_slice(cls, d: Sequence[float], size: int, stride: int) -> Vector: ...
    @classmethod
    def new_data_static(cls, d: Sequence[float], size: int, stride: int) -> Vector: ...
    @classmethod
    def new_fftw(cls, size: int) -> Vector: ...
    @classmethod
    def new_full(cls, d: Sequence[float], size: int, stride: int, pdata: None, pfree: Optional[Callable[[None], None]] = None) -> Vector: ...
    @classmethod
    def new_variant(cls, var: GLib.Variant) -> Vector: ...
    def peek_variant(self) -> GLib.Variant: ...
    def ptr(self, i: int) -> float: ...
    def reciprocal(self) -> None: ...
    def ref(self) -> Vector: ...
    def scale(self, val: float) -> None: ...
    def set(self, i: int, val: float) -> None: ...
    def set_all(self, val: float) -> None: ...
    def set_array(self, array: Sequence[float]) -> None: ...
    def set_data(self, array: Sequence[float]) -> None: ...
    def set_from_variant(self, var: GLib.Variant) -> None: ...
    def set_zero(self) -> None: ...
    def sqrt(self) -> None: ...
    def square(self) -> None: ...
    def stride(self) -> int: ...
    def sub(self, cv2: Vector) -> None: ...
    def sub_round_off(self, cv2: Vector) -> None: ...
    def subfrom(self, i: int, val: float) -> None: ...
    @staticmethod
    def substitute(cv1: Vector, cv2: Vector, check_size: bool) -> None: ...
    def sum_cpts(self) -> float: ...
    

class VectorClass(GObject.GPointer):
    r"""
    :Constructors:

    ::

        VectorClass()
    """
    parent_class: GObject.ObjectClass = ...

class _Spline2dBicubicOptimizeInt(GObject.GPointer):
    r"""
    :Constructors:

    ::

        _Spline2dBicubicOptimizeInt()
    """
    l: float = ...
    u: float = ...
    init: bool = ...
    s: Spline = ...

class MSetCatalogTrimType(GObject.GFlags):
    ALL = 7
    CK = 4
    ESS = 1
    HEIDEL = 2

class SerializeOpt(GObject.GFlags):
    AUTONAME_SER = 2
    AUTOSAVE_SER = 1
    CLEAN_DUP = 3
    NONE = 0

class CSQ1DEvolState(GObject.GEnum):
    ADIABATIC = 1
    INVALID = 0
    UM = 3
    UP = 2

class DataPoissonType(GObject.GEnum):
    INT = 0

class DatasetBStrapType(GObject.GEnum):
    DISABLE = 0
    PARTIAL = 1
    TOTAL = 2

class FitESMCMCWalkerAPESKType(GObject.GEnum):
    CAUCHY = 0
    GAUSS = 2
    ST3 = 1

class FitESMCMCWalkerAPESMethod(GObject.GEnum):
    KDE = 0
    VKDE = 1

class FitGSLMMAlgos(GObject.GEnum):
    CONJUGATE_FR = 0
    CONJUGATE_PR = 1
    STEEPEST_DESCENT = 4
    VECTOR_BFGS = 2
    VECTOR_BFGS2 = 3

class FitGSLMMSAlgos(GObject.GEnum):
    NMSIMPLEX = 1
    NMSIMPLEX2 = 0
    NMSIMPLEX2RAND = 2

class FitGradType(GObject.GEnum):
    ANALYTICAL = 0
    NUMDIFF_ACCURATE = 3
    NUMDIFF_CENTRAL = 2
    NUMDIFF_FORWARD = 1

class FitLevmarAlgos(GObject.GEnum):
    BC_DER = 2
    BC_DIF = 3
    DER = 0
    DIF = 1

class FitMCResampleType(GObject.GEnum):
    BOOTSTRAP_MIX = 2
    BOOTSTRAP_NOMIX = 1
    FROM_MODEL = 0

class FitNloptAlgorithm(GObject.GEnum):
    AUGLAG = 36
    AUGLAG_EQ = 37
    GD_MLSL = 21
    GD_MLSL_LDS = 23
    GD_STOGO = 8
    GD_STOGO_RAND = 9
    GN_AGS = 43
    GN_CRS2_LM = 19
    GN_DIRECT = 0
    GN_DIRECT_L = 1
    GN_DIRECT_L_NOSCAL = 4
    GN_DIRECT_L_RAND = 2
    GN_DIRECT_L_RAND_NOSCAL = 5
    GN_DIRECT_NOSCAL = 3
    GN_ESCH = 42
    GN_ISRES = 35
    GN_MLSL = 20
    GN_MLSL_LDS = 22
    GN_ORIG_DIRECT = 6
    GN_ORIG_DIRECT_L = 7
    G_MLSL = 38
    G_MLSL_LDS = 39
    LD_AUGLAG = 31
    LD_AUGLAG_EQ = 33
    LD_CCSAQ = 41
    LD_LBFGS = 11
    LD_LBFGS_NOCEDAL = 10
    LD_MMA = 24
    LD_SLSQP = 40
    LD_TNEWTON = 15
    LD_TNEWTON_PRECOND = 17
    LD_TNEWTON_PRECOND_RESTART = 18
    LD_TNEWTON_RESTART = 16
    LD_VAR1 = 13
    LD_VAR2 = 14
    LN_AUGLAG = 30
    LN_AUGLAG_EQ = 32
    LN_BOBYQA = 34
    LN_COBYLA = 25
    LN_NELDERMEAD = 28
    LN_NEWUOA = 26
    LN_NEWUOA_BOUND = 27
    LN_PRAXIS = 12
    LN_SBPLX = 29
    NUM_ALGORITHMS = 44

class FitNloptResult(GObject.GEnum):
    FAILURE = -1
    FORCED_STOP = -5
    FTOL_REACHED = 3
    INVALID_ARGS = -2
    MAXEVAL_REACHED = 5
    MAXTIME_REACHED = 6
    NUM_FAILURES = -6
    NUM_RESULTS = 7
    OUT_OF_MEMORY = -3
    ROUNDOFF_LIMITED = -4
    STOPVAL_REACHED = 2
    SUCCESS = 1
    XTOL_REACHED = 4

class FitRunMsgs(GObject.GEnum):
    FULL = 2
    NONE = 0
    SIMPLE = 1

class FitType(GObject.GEnum):
    GSL_LS = 0
    GSL_MM = 1
    GSL_MMS = 2
    LEVMAR = 3
    NLOPT = 4

class FunctionCacheSearchType(GObject.GEnum):
    BOTH = 0
    GT = 1
    LT = 2

class HOAAOpt(GObject.GEnum):
    DLNMNU_ONLY = 2
    FULL = 0
    INVALID = 3
    V_ONLY = 1

class HOAASingType(GObject.GEnum):
    INF = 1
    INVALID = 2
    ZERO = 0

class HOAAVar(GObject.GEnum):
    GAMMA = 3
    PBAR = 1
    QBAR = 0
    SYS_SIZE = 4
    UPSILON = 2

class LHRatio1dRoot(GObject.GEnum):
    BRACKET = 0
    NUMDIFF = 1

class LHRatio2dRoot(GObject.GEnum):
    BRACKET = 0
    NUMDIFF = 1

class MPIJobCtrlMsg(GObject.GEnum):
    FREE = 1
    INIT = 0
    KILL = 2
    WORK = 3

class MPIJobCtrlTag(GObject.GEnum):
    CMD = 0
    JOB = 1
    WORK_INPUT = 2
    WORK_RETURN = 3

class MSetCatalogPostNormMethod(GObject.GEnum):
    ELIPSOID = 2
    HYPERBOX = 0
    HYPERBOX_BS = 1

class MSetCatalogSync(GObject.GEnum):
    AUTO = 1
    DISABLE = 0
    TIMED = 2

class MSetCatalogTauMethod(GObject.GEnum):
    ACOR = 0
    AR_MODEL = 1

class MSetTransKernCatSampling(GObject.GEnum):
    CHOOSE = 0
    KDE = 2
    RBF_INTERP = 1

class MatrixInternal(GObject.GEnum):
    DERIVED = 4
    GARRAY = 3
    GSL_MATRIX = 1
    MALLOC = 2
    SLICE = 0

class ModelFunnelSParams(GObject.GEnum):
    NU = 0

class ModelFunnelVParams(GObject.GEnum):
    X = 0

class ModelMVNDVParams(GObject.GEnum):
    MEAN = 0

class ModelRosenbrockSParams(GObject.GEnum):
    X1 = 0
    X2 = 1

class NNLSUMethod(GObject.GEnum):
    DGELSD = 3
    GSL = 4
    NORMAL = 0
    NORMAL_LU = 1
    QR = 2

class ODEEvalReturn(GObject.GEnum):
    SUCCESS = 0

class ParamType(GObject.GEnum):
    FIXED = 1
    FREE = 0

class PowspecFilterType(GObject.GEnum):
    GAUSS = 1
    TOPHAT = 0

class SphereMapCoordSys(GObject.GEnum):
    CELESTIAL = 67
    ECLIPTIC = 69
    GALACTIC = 71

class SphereMapOrder(GObject.GEnum):
    NEST = 0
    RING = 1

class SplineFuncTestType(GObject.GEnum):
    COSINE = 1
    POLYNOMIAL = 0
    RBF = 2
    USER = 3

class SplineFuncTestTypePDF(GObject.GEnum):
    FLAT = 0
    NORMAL = 1

class SplineFuncType(GObject.GEnum):
    FUNCTION_4POINTS = 0
    FUNCTION_SPLINE = 1
    FUNCTION_SPLINE_LNKNOT = 2
    FUNCTION_SPLINE_SINHKNOT = 3
    FUNC_GRID_LINEAR = 4
    FUNC_GRID_LOG = 5

class SplineGslType(GObject.GEnum):
    AKIMA = 4
    AKIMA_PERIODIC = 5
    CSPLINE = 2
    CSPLINE_PERIODIC = 3
    LINEAR = 0
    POLYNOMIAL = 1

class SplineRBFType(GObject.GEnum):
    GAUSS = 1
    POSDEF_GAUSS = 0

class StatsDist1dEPDFBw(GObject.GEnum):
    AUTO = 2
    FIXED = 0
    ROT = 1

class StatsDistCV(GObject.GEnum):
    NONE = 0
    SPLIT = 1
    SPLIT_NOFIT = 2

class StatsDistKDECovType(GObject.GEnum):
    FIXED = 1
    ROBUST = 3
    ROBUST_DIAG = 2
    SAMPLE = 0

class StatsVecARType(GObject.GEnum):
    AIC = 2
    AICC = 3
    FPE = 1
    NONE = 0

class StatsVecType(GObject.GEnum):
    COV = 2
    MEAN = 0
    VAR = 1

class VectorInternal(GObject.GEnum):
    ARRAY = 3
    DERIVED = 4
    GSL_VECTOR = 1
    MALLOC = 2
    SLICE = 0


