/* numcosmo-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Nc", gir_namespace = "NumCosmo", gir_version = "1.0", lower_case_cprefix = "nc_")]
namespace Nc {
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_abc_cluster_ncount_get_type ()")]
	public class ABCClusterNCount : Ncm.ABC {
		[CCode (has_construct_function = false)]
		public ABCClusterNCount (Ncm.MSet mset, Ncm.MSetTransKern prior, Ncm.Dataset dset);
		public void set_bin_nodes (Ncm.Vector z_nodes, Ncm.Vector lnM_nodes);
		public void set_bin_quantile (Ncm.Vector? quantiles);
		public void set_bin_uniform (uint z_bins, uint lnM_bins);
		public void set_epsilon_update (double q);
		public void set_scale_cov (bool on);
		[NoAccessorMethod]
		public double epsilon_update { get; set construct; }
		[NoAccessorMethod]
		public Nc.ABCClusterNCountEpsilonUpdate epsilon_update_type { get; set construct; }
		[NoAccessorMethod]
		public uint lnM_bins { get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant lnM_nodes { owned get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant quantiles { owned get; set construct; }
		[NoAccessorMethod]
		public double rbf_scale { get; set construct; }
		[NoAccessorMethod]
		public bool scale_cov { get; set construct; }
		[NoAccessorMethod]
		public Nc.ABCClusterNCountSummary summary_type { get; set; }
		[NoAccessorMethod]
		public uint z_bins { get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant z_nodes { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_abundance_get_type ()")]
	public class ClusterAbundance : GLib.Object {
		[CCode (has_construct_function = false)]
		public ClusterAbundance (Nc.MassFunction mfp, Nc.HaloBiasFunc? mbiasf, Nc.ClusterRedshift clusterz, Nc.ClusterMass clusterm);
		public static void clear (Nc.ClusterAbundance cad);
		public Nc.ClusterAbundance copy ();
		public double d2n (Nc.HICosmo model, double lnM, double z);
		public void free ();
		public Nc.ClusterMass get_mass ();
		public Nc.ClusterRedshift get_redshift ();
		public double intp_d2n (Nc.HICosmo model, double lnM, double z);
		public double lnm_p_d2n (Nc.HICosmo model, double lnM_obs, double lnM_obs_params, double z);
		public double n (Nc.HICosmo model);
		[CCode (cname = "nc_cluster_abundance_nodist_new", has_construct_function = false)]
		public ClusterAbundance.nodist_new (Nc.MassFunction mfp, Nc.HaloBiasFunc? mbiasf);
		public unowned Nc.ClusterMass peek_mass ();
		public unowned Nc.ClusterRedshift peek_redshift ();
		public void prepare (Nc.HICosmo model);
		public void prepare_inv_dNdlnM_z (Nc.HICosmo model, double z);
		public void prepare_inv_dNdz (Nc.HICosmo model);
		public Nc.ClusterAbundance @ref ();
		public void set_mass (Nc.ClusterMass clusterm);
		public void set_redshift (Nc.ClusterRedshift clusterz);
		public double true_n (Nc.HICosmo model);
		public double z_p_d2n (Nc.HICosmo model, double lnM, double z_obs, double z_obs_params);
		public double z_p_lnm_p_d2n (Nc.HICosmo model, double lnM_obs, double lnM_obs_params, double z_obs, double z_obs_params);
		public Nc.ClusterMass mass { owned get; set construct; }
		[NoAccessorMethod]
		public Nc.MassFunction mass_function { owned get; construct; }
		[NoAccessorMethod]
		public Nc.HaloBiasFunc mean_bias { owned get; construct; }
		public Nc.ClusterRedshift redshift { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	[Compact]
	public class ClusterAbundanceDataBin {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	[Compact]
	public class ClusterAbundanceDataBinM {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	[Compact]
	public class ClusterAbundanceDataBinZ {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	[Compact]
	public class ClusterAbundanceDataP {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_get_type ()")]
	public abstract class ClusterMass : Ncm.Model {
		[CCode (has_construct_function = false)]
		protected ClusterMass ();
		[NoWrapper]
		public virtual void N_limits (Nc.HICosmo model, double lnM_lower, double lnM_upper);
		[NoWrapper]
		public virtual double P (Nc.HICosmo model, double lnM, double z, double lnM_obs, double lnM_obs_params);
		[NoWrapper]
		public virtual void P_limits (Nc.HICosmo model, double lnM_obs, double lnM_obs_params, double lnM_lower, double lnM_upper);
		public static void clear (Nc.ClusterMass clusterm);
		public void free ();
		[CCode (has_construct_function = false)]
		public ClusterMass.from_name (string mass_name);
		public static int32 id ();
		public Nc.ClusterMassImpl impl ();
		[NoWrapper]
		public virtual double intP (Nc.HICosmo model, double lnM, double z);
		public double intp (Nc.HICosmo model, double lnM, double z);
		public static void log_all_models ();
		public void n_limits (Nc.HICosmo model, out double lnM_lower, out double lnM_upper);
		public virtual uint obs_len ();
		public virtual uint obs_params_len ();
		public double p (Nc.HICosmo model, double lnM, double z, double lnM_obs, double lnM_obs_params);
		public void p_limits (Nc.HICosmo model, double lnM_obs, double lnM_obs_params, out double lnM_lower, out double lnM_upper);
		public Nc.ClusterMass @ref ();
		public virtual bool resample (Nc.HICosmo model, double lnM, double z, out double lnM_obs, out double lnM_obs_params, Ncm.RNG rng);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_benson_get_type ()")]
	public class ClusterMassBenson : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassBenson ();
		[NoAccessorMethod]
		public double Asz { get; set; }
		[NoAccessorMethod]
		public bool Asz_fit { get; set; }
		[NoAccessorMethod]
		public double Bsz { get; set; }
		[NoAccessorMethod]
		public bool Bsz_fit { get; set; }
		[NoAccessorMethod]
		public double Csz { get; set; }
		[NoAccessorMethod]
		public bool Csz_fit { get; set; }
		[NoAccessorMethod]
		public double Dsz { get; set; }
		[NoAccessorMethod]
		public bool Dsz_fit { get; set; }
		[NoAccessorMethod]
		public double M0 { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_max { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_min { get; construct; }
		[NoAccessorMethod]
		public double z0 { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_benson_xray_get_type ()")]
	public class ClusterMassBensonXRay : Nc.ClusterMassBenson {
		[CCode (has_construct_function = false)]
		protected ClusterMassBensonXRay ();
		[NoAccessorMethod]
		public double Ax { get; set; }
		[NoAccessorMethod]
		public bool Ax_fit { get; set; }
		[NoAccessorMethod]
		public double Bx { get; set; }
		[NoAccessorMethod]
		public bool Bx_fit { get; set; }
		[NoAccessorMethod]
		public double Cx { get; set; }
		[NoAccessorMethod]
		public bool Cx_fit { get; set; }
		[NoAccessorMethod]
		public double Dx { get; set; }
		[NoAccessorMethod]
		public bool Dx_fit { get; set; }
		[NoAccessorMethod]
		public double M0x { get; construct; }
		[NoAccessorMethod]
		public double Y0 { get; construct; }
		[NoAccessorMethod]
		public double Yx_obs_max { get; construct; }
		[NoAccessorMethod]
		public double Yx_obs_min { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_lnnormal_get_type ()")]
	public class ClusterMassLnnormal : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassLnnormal ();
		[NoAccessorMethod]
		public double bias { get; set; }
		[NoAccessorMethod]
		public bool bias_fit { get; set; }
		[NoAccessorMethod]
		public double lnMobs_max { get; construct; }
		[NoAccessorMethod]
		public double lnMobs_min { get; construct; }
		[NoAccessorMethod]
		public double sigma { get; set; }
		[NoAccessorMethod]
		public bool sigma_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_nodist_get_type ()")]
	public class ClusterMassNodist : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassNodist ();
		[NoAccessorMethod]
		public double lnM_max { get; construct; }
		[NoAccessorMethod]
		public double lnM_min { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "cluster_mass_plcl", type_id = "nc_cluster_mass_plcl_get_type ()")]
	public class ClusterMassPlCL : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassPlCL ();
		[NoAccessorMethod]
		public double Al { get; set; }
		[NoAccessorMethod]
		public bool Al_fit { get; set; }
		[NoAccessorMethod]
		public double Asz { get; set; }
		[NoAccessorMethod]
		public bool Asz_fit { get; set; }
		[NoAccessorMethod]
		public double Bl { get; set; }
		[NoAccessorMethod]
		public bool Bl_fit { get; set; }
		[NoAccessorMethod]
		public double Bsz { get; set; }
		[NoAccessorMethod]
		public bool Bsz_fit { get; set; }
		[NoAccessorMethod]
		public double COR { get; set; }
		[NoAccessorMethod]
		public bool COR_fit { get; set; }
		[NoAccessorMethod]
		public double MCUT { get; set; }
		[NoAccessorMethod]
		public bool MCUT_fit { get; set; }
		[NoAccessorMethod]
		public double SDl { get; set; }
		[NoAccessorMethod]
		public bool SDl_fit { get; set; }
		[NoAccessorMethod]
		public double SDsz { get; set; }
		[NoAccessorMethod]
		public bool SDsz_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_mass_vanderlinde_get_type ()")]
	public class ClusterMassVanderlinde : Nc.ClusterMass {
		[CCode (has_construct_function = false)]
		protected ClusterMassVanderlinde ();
		[NoAccessorMethod]
		public double Asz { get; set; }
		[NoAccessorMethod]
		public bool Asz_fit { get; set; }
		[NoAccessorMethod]
		public double Bsz { get; set; }
		[NoAccessorMethod]
		public bool Bsz_fit { get; set; }
		[NoAccessorMethod]
		public double Csz { get; set; }
		[NoAccessorMethod]
		public bool Csz_fit { get; set; }
		[NoAccessorMethod]
		public double Dsz { get; set; }
		[NoAccessorMethod]
		public bool Dsz_fit { get; set; }
		[NoAccessorMethod]
		public double M0 { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_max { get; construct; }
		[NoAccessorMethod]
		public double signif_obs_min { get; construct; }
		[NoAccessorMethod]
		public double z0 { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_photoz_gauss_get_type ()")]
	public class ClusterPhotozGauss : Nc.ClusterRedshift {
		[CCode (has_construct_function = false, type = "NcClusterRedshift*")]
		public ClusterPhotozGauss ();
		[NoAccessorMethod]
		public double pz_max { get; construct; }
		[NoAccessorMethod]
		public double pz_min { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_photoz_gauss_global_get_type ()")]
	public class ClusterPhotozGaussGlobal : Nc.ClusterRedshift {
		[CCode (has_construct_function = false, type = "NcClusterRedshift*")]
		public ClusterPhotozGaussGlobal (double pz_min, double pz_max, double z_bias, double sigma0);
		public double get_sigma0 ();
		public double get_z_bias ();
		public void set_sigma0 (double sigma0);
		public void set_z_bias (double z_bias);
		[NoAccessorMethod]
		public double pz_max { get; construct; }
		[NoAccessorMethod]
		public double pz_min { get; construct; }
		public double sigma0 { get; set; }
		[NoAccessorMethod]
		public bool sigma0_fit { get; set; }
		public double z_bias { get; set; }
		[NoAccessorMethod]
		public bool z_bias_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_redshift_get_type ()")]
	public abstract class ClusterRedshift : Ncm.Model {
		[CCode (has_construct_function = false)]
		protected ClusterRedshift ();
		[NoWrapper]
		public virtual void N_limits (double z_lower, double z_upper);
		[NoWrapper]
		public virtual double P (double lnM, double z, double z_obs, double z_obs_params);
		[NoWrapper]
		public virtual void P_limits (double z_obs, double z_obs_params, double z_lower, double z_upper);
		public static void clear (Nc.ClusterRedshift clusterz);
		public void free ();
		[CCode (has_construct_function = false)]
		public ClusterRedshift.from_name (string redshift_name);
		public static int32 id ();
		public Nc.ClusterRedshiftImpl impl ();
		[NoWrapper]
		public virtual double intP (double lnM, double z);
		public double intp (double lnM, double z);
		public static void log_all_models ();
		public void n_limits (out double z_lower, out double z_upper);
		public virtual uint obs_len ();
		public virtual uint obs_params_len ();
		public double p (double lnM, double z, double z_obs, double z_obs_params);
		public void p_limits (double z_obs, double z_obs_params, out double z_lower, out double z_upper);
		public Nc.ClusterRedshift @ref ();
		public virtual bool resample (double lnM, double z, out double z_obs, out double z_obs_params, Ncm.RNG rng);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cluster_redshift_nodist_get_type ()")]
	public class ClusterRedshiftNodist : Nc.ClusterRedshift {
		[CCode (has_construct_function = false)]
		protected ClusterRedshiftNodist ();
		[NoAccessorMethod]
		public double z_max { get; construct; }
		[NoAccessorMethod]
		public double z_min { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_cor_cluster_cmb_lens_limber_get_type ()")]
	public class CorClusterCmbLensLimber : GLib.Object {
		public weak Ncm.Spline oneh_int_mass_spline;
		[CCode (has_construct_function = false)]
		public CorClusterCmbLensLimber ();
		public double oneh_int_mass (Nc.ClusterAbundance cad, Nc.HICosmo model, Nc.DensityProfile dp, double k, double z, [CCode (array_length = false)] double[] lnM_obs, [CCode (array_length = false)] double[] lnM_obs_params);
		public double oneh_term (Nc.ClusterAbundance cad, Nc.HICosmo model, Nc.Distance dist, Nc.DensityProfile dp, int l, [CCode (array_length = false)] double[] lnM_obs, [CCode (array_length = false)] double[] lnM_obs_params, [CCode (array_length = false)] double[] z_obs, [CCode (array_length = false)] double[] z_obs_params);
		public double twoh_int_mass1 (Nc.ClusterAbundance cad, Nc.HICosmo model, double z);
		public double twoh_int_mass2 (Nc.ClusterAbundance cad, Nc.HICosmo model, Nc.DensityProfile dp, double k, double z);
		public double twoh_int_mm (Nc.ClusterAbundance cad, Nc.HICosmo model, Nc.DensityProfile dp, double k, double z);
		public double twoh_term (Nc.ClusterAbundance cad, Nc.HICosmo model, Nc.Distance dist, Nc.DensityProfile dp, int l, [CCode (array_length = false)] double[] z_obs, [CCode (array_length = false)] double[] z_obs_params);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_bao_a_get_type ()")]
	public class DataBaoA : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataBaoA (Nc.Distance dist, Nc.DataBaoId id);
		public void set_sample (Nc.DataBaoId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant z { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_bao_dv_get_type ()")]
	public class DataBaoDV : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataBaoDV (Nc.Distance dist, Nc.DataBaoId id);
		public void set_sample (Nc.DataBaoId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant z { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_bao_dvdv_get_type ()")]
	public class DataBaoDVDV : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataBaoDVDV (Nc.Distance dist, Nc.DataBaoId id);
		public Nc.DataBaoId get_sample ();
		public void set_sample (Nc.DataBaoId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_bao_empirical_fit_get_type ()")]
	public class DataBaoEmpiricalFit : Ncm.DataDist1d {
		[CCode (has_construct_function = false)]
		public DataBaoEmpiricalFit (Ncm.Spline m2lnp, double Dv_fiduc, double rs_fiduc, double z);
		[CCode (has_construct_function = false)]
		public DataBaoEmpiricalFit.from_file (string filename);
		[CCode (has_construct_function = false)]
		public DataBaoEmpiricalFit.from_id (Nc.Distance dist, Nc.DataBaoId id);
		public double get_alpha (Ncm.MSet mset);
		public double get_mode ();
		public void set_dist (Nc.Distance dist);
		[NoAccessorMethod]
		public double Dv_fiduc { get; set construct; }
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Spline m2lnp { owned get; set construct; }
		[NoAccessorMethod]
		public double rs_fiduc { get; set construct; }
		[NoAccessorMethod]
		public double z { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_bao_rdv_get_type ()")]
	public class DataBaoRDV : Ncm.DataGauss {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataBaoRDV (Nc.Distance dist, Nc.DataBaoId id);
		public void set_sample (Nc.DataBaoId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set; }
		[NoAccessorMethod]
		public bool is_rDV { get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant z { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_cmb_dist_priors_get_type ()")]
	public class DataCMBDistPriors : Ncm.DataGauss {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataCMBDistPriors (Nc.Distance dist, Nc.DataCMBId id);
		public void set_sample (Nc.DataCMBId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_cmb_shift_param_get_type ()")]
	public class DataCMBShiftParam : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataCMBShiftParam (Nc.Distance dist, Nc.DataCMBId id);
		public void set_sample (Nc.DataCMBId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant z { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_cluster_ncount_get_type ()")]
	public class DataClusterNCount : Ncm.Data {
		[CCode (has_construct_function = false)]
		public DataClusterNCount (Nc.ClusterAbundance cad);
		public void catalog_load (string filename);
		public void catalog_save (string filename, bool overwrite);
		public static void clear (Nc.DataClusterNCount ncount);
		public void free ();
		public uint get_len ();
		public Ncm.Matrix get_lnM_obs ();
		public Ncm.Matrix get_lnM_obs_params ();
		public Ncm.Vector get_lnM_true ();
		public Ncm.Matrix get_z_obs ();
		public Ncm.Matrix get_z_obs_params ();
		public Ncm.Vector get_z_true ();
		public bool has_lnM_true ();
		public bool has_z_true ();
		public void init_from_sampling (Ncm.MSet mset, Nc.ClusterRedshift clusterz, Nc.ClusterMass clusterm, double area_survey, Ncm.RNG rng);
		public uint lnM_obs_len ();
		public uint lnM_obs_params_len ();
		public void print (Nc.HICosmo cosmo, int @out, string header);
		public Nc.DataClusterNCount @ref ();
		public void set_bin_by_minmax (uint z_nbins, uint lnM_nbins);
		public void set_bin_by_nodes (Ncm.Vector z_nodes, Ncm.Vector lnM_nodes);
		public void set_bin_by_quantile (Ncm.Vector z_quantiles, Ncm.Vector lnM_quantiles);
		public void set_binned (bool on);
		public void set_lnM_obs (Ncm.Matrix m);
		public void set_lnM_obs_params (Ncm.Matrix m);
		public void set_lnM_true (Ncm.Vector v);
		public void set_mass (Nc.ClusterMass m);
		public void set_redshift (Nc.ClusterRedshift z);
		public void set_z_obs (Ncm.Matrix m);
		public void set_z_obs_params (Ncm.Matrix m);
		public void set_z_true (Ncm.Vector v);
		public void true_data (bool use_true_data);
		public bool using_true_data ();
		public uint z_obs_len ();
		public uint z_obs_params_len ();
		[NoAccessorMethod]
		public double area { get; set; }
		[NoAccessorMethod]
		public bool binned { get; set; }
		[NoAccessorMethod]
		public Nc.ClusterAbundance cluster_abundance { owned get; set construct; }
		[NoAccessorMethod]
		public bool fiducial { get; set; }
		[NoAccessorMethod]
		public GLib.Variant lnM_nodes { owned get; set construct; }
		public GLib.Variant lnM_obs { owned get; set; }
		public GLib.Variant lnM_obs_params { owned get; set; }
		public GLib.Variant lnM_true { owned get; set; }
		[NoAccessorMethod]
		public Nc.ClusterMass mass { owned get; set; }
		[NoAccessorMethod]
		public Nc.ClusterRedshift redshift { owned get; set; }
		[NoAccessorMethod]
		public string rng_name { owned get; set; }
		[NoAccessorMethod]
		public uint64 rng_seed { get; set; }
		[NoAccessorMethod]
		public bool use_true { get; set; }
		[NoAccessorMethod]
		public GLib.Variant z_nodes { owned get; set construct; }
		public GLib.Variant z_obs { owned get; set; }
		public GLib.Variant z_obs_params { owned get; set; }
		public GLib.Variant z_true { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_cluster_poisson_get_type ()")]
	public class DataClusterPoisson : Ncm.DataPoisson {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataClusterPoisson (Nc.DataClusterNCount ncount);
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataClusterPoisson.cad (Nc.ClusterAbundance cad);
		[NoAccessorMethod]
		public Nc.DataClusterNCount cluster_ncount { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_dist_mu_get_type ()")]
	public class DataDistMu : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataDistMu (Nc.Distance dist, Nc.DataSNIAId id);
		public void set_sample (Nc.DataSNIAId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant z { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_hubble_get_type ()")]
	public class DataHubble : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataHubble (Nc.DataHubbleId id);
		public void set_sample (Nc.DataHubbleId id);
		[NoAccessorMethod]
		public GLib.Variant z { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_hubble_bao_get_type ()")]
	public class DataHubbleBao : Ncm.DataGaussDiag {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataHubbleBao (Nc.Distance dist, Nc.DataHubbleBaoId id);
		public void set_sample (Nc.DataHubbleBaoId id);
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant z { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_data_snia_cov_get_type ()")]
	public class DataSNIACov : Ncm.DataGaussCov {
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataSNIACov (bool use_norma);
		public double estimate_width_colour (Ncm.MSet mset);
		[CCode (has_construct_function = false, type = "NcmData*")]
		public DataSNIACov.full (string filename, bool use_norma);
		public Ncm.Vector get_estimated_colour (Ncm.MSet mset);
		public Ncm.Vector get_estimated_mag (Ncm.MSet mset);
		public Ncm.Vector get_estimated_width (Ncm.MSet mset);
		public void load (string filename);
		public void load_txt (string filename);
		public unowned GLib.Array<uint32> peek_abs_mag_set ();
		public unowned Ncm.Vector peek_colour ();
		public unowned Ncm.Matrix peek_cov_full ();
		public unowned Ncm.Vector peek_mag ();
		public unowned Ncm.Vector peek_sigma_z ();
		public unowned Ncm.Vector peek_thirdpar ();
		public unowned Ncm.Vector peek_width ();
		public unowned Ncm.Vector peek_z_cmb ();
		public unowned Ncm.Vector peek_z_he ();
		public void save (string filename, bool overwrite);
		public void set_abs_mag_set (GLib.Array<uint32> abs_mag_set);
		public void set_colour (Ncm.Vector colour);
		public void set_cov_full (Ncm.Matrix cov_full);
		public void set_mag (Ncm.Vector mag);
		public void set_sigma_z (Ncm.Vector sigma_z);
		public void set_thirdpar (Ncm.Vector thirdpar);
		public void set_width (Ncm.Vector width);
		public void set_z_cmb (Ncm.Vector z_cmb);
		public void set_z_he (Ncm.Vector z_he);
		public uint sigma_int_len ();
		[NoAccessorMethod]
		public GLib.Variant absmag_set { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant colour { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant cov_full { owned get; set; }
		[NoAccessorMethod]
		public bool has_complete_cov { get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant magnitudes { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant sigma_thirdpar { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant sigma_z { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant thirdpar { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant width { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant z_He { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant z_cmb { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_density_profile_get_type ()")]
	public class DensityProfile : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DensityProfile ();
		public static void clear (Nc.DensityProfile dp);
		public virtual double eval_fourier (Nc.HICosmo model, double k, double M, double z);
		public void free ();
		[CCode (has_construct_function = false)]
		public DensityProfile.from_name (string density_profile_name);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_density_profile_nfw_get_type ()")]
	public class DensityProfileNFW : Nc.DensityProfile {
		[CCode (has_construct_function = false, type = "NcDensityProfile*")]
		public DensityProfileNFW ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_distance_get_type ()")]
	public class Distance : GLib.Object {
		[CCode (has_construct_function = false)]
		public Distance (double z_f);
		public double Omega_k (Nc.HICosmo cosmo);
		public double acoustic_scale (Nc.HICosmo cosmo);
		public double angular_diameter_curvature_scale (Nc.HICosmo cosmo);
		public double bao_A_scale (Nc.HICosmo cosmo, double z);
		public double bao_r_Dv (Nc.HICosmo cosmo, double z);
		public static void clear (Nc.Distance dist);
		public double comoving (Nc.HICosmo cosmo, double z);
		public double comoving_lss (Nc.HICosmo cosmo);
		public double conformal_lookback_time (Nc.HICosmo cosmo, double z);
		public double conformal_time (Nc.HICosmo cosmo, double z);
		public double conformal_time_mks_scale (Nc.HICosmo cosmo);
		public double cosmic_time (Nc.HICosmo cosmo, double z);
		public double cosmic_time_mks_scale (Nc.HICosmo cosmo);
		public Ncm.MSetFunc create_mset_arrayfunc1 (Nc.DistanceFunc1 f1, uint size);
		public double decoupling_redshift (Nc.HICosmo cosmo);
		public double dilation_scale (Nc.HICosmo cosmo, double z);
		public double drag_redshift (Nc.HICosmo cosmo);
		public double dsound_horizon_dz (Nc.HICosmo cosmo, double z);
		public double dtransverse_dz (Nc.HICosmo cosmo, double z);
		public void free ();
		public Ncm.MSetFunc func0_new (Nc.DistanceFunc0 f0);
		public Ncm.MSetFunc func1_new (Nc.DistanceFunc1 f1);
		[CCode (cname = "nc_distance_class_func_table")]
		public class GLib.Array<weak Nc.DistanceFunc> func_table ();
		[CCode (cname = "nc_distance_class_func_z_table")]
		public class GLib.Array<weak Nc.DistanceFuncZ> func_z_table ();
		[CCode (cname = "nc_distance_class_get_func")]
		public class unowned Nc.DistanceFunc? get_func (string name);
		[CCode (cname = "nc_distance_class_get_func_z")]
		public class unowned Nc.DistanceFuncZ? get_func_z (string name);
		public double hubble (Nc.HICosmo cosmo);
		public double lookback_time (Nc.HICosmo cosmo, double z);
		public double luminosity (Nc.HICosmo cosmo, double z);
		public double luminosity_hef (Nc.HICosmo cosmo, double z_he, double z_cmb);
		public double modulus (Nc.HICosmo cosmo, double z);
		public double modulus_hef (Nc.HICosmo cosmo, double z_he, double z_cmb);
		public void prepare (Nc.HICosmo cosmo);
		public void prepare_if_needed (Nc.HICosmo cosmo);
		public Nc.Distance @ref ();
		public double shift_parameter (Nc.HICosmo cosmo, double z);
		public double shift_parameter_lss (Nc.HICosmo cosmo);
		public double sound_horizon (Nc.HICosmo cosmo, double z);
		public double transverse (Nc.HICosmo cosmo, double z);
		[NoAccessorMethod]
		public double zf { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_galaxy_acf_get_type ()")]
	public class GalaxyAcf : GLib.Object {
		[CCode (has_construct_function = false)]
		public GalaxyAcf (Nc.GrowthFunc gf, Nc.Distance dist, Nc.TransferFunc tf);
		public void prepare_psi (Nc.HICosmo model, uint l);
		public double psi (Nc.HICosmo model, double k, uint l);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_growth_func_get_type ()")]
	public class GrowthFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		public GrowthFunc ();
		public static void clear (Nc.GrowthFunc gf);
		public Nc.GrowthFunc copy ();
		public double eval (Nc.HICosmo model, double z);
		public void eval_both (Nc.HICosmo model, double z, double d, double f);
		public double eval_deriv (Nc.HICosmo model, double z);
		public void free ();
		public void prepare (Nc.HICosmo model);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo", type_id = "nc_hicosmo_get_type ()")]
	public abstract class HICosmo : Ncm.Model {
		[CCode (has_construct_function = false)]
		protected HICosmo ();
		public double E (double z);
		public double E2 (double x);
		public double Em2 (double z);
		public double H (double z);
		public double H0 ();
		public double Omega_b ();
		public double Omega_bh2 ();
		public double Omega_c ();
		public double Omega_ch2 ();
		public double Omega_k ();
		public double Omega_m ();
		public double Omega_mh2 ();
		public double Omega_r ();
		public double Omega_rh2 ();
		public double Omega_t ();
		public double T_gamma0 ();
		public double abs_alpha (double x);
		public double as_drag ();
		public double c_H0 ();
		public double cd (double x);
		public static GLib.Array<weak Nc.HICosmoFunc> class_func_table ();
		public static GLib.Array<weak Nc.HICosmoFuncZ> class_func_z_table ();
		public static unowned Nc.HICosmoFunc? class_get_func (string name);
		public static unowned Nc.HICosmoFuncZ? class_get_func_z (string name);
		public static void clear (Nc.HICosmo cosmo);
		public static Ncm.MSetFunc create_mset_arrayfunc1 (Nc.HICosmoFunc1 f1, uint size);
		public static Ncm.MSetFunc create_mset_func0 (Nc.HICosmoFunc0 f0);
		public static Ncm.MSetFunc create_mset_func1 (Nc.HICosmoFunc1 f1);
		public double cs2 (double x);
		public double d2E2_dz2 (double x);
		public double dE2_dz (double x);
		public double dH_dz (double z);
		public double dec (double z);
		public void free ();
		[CCode (has_construct_function = false)]
		public HICosmo.from_name (GLib.Type parent_type, string cosmo_name);
		public double h ();
		public double h2 ();
		public static int32 id ();
		public double j (double z);
		public static void log_all_models (GLib.Type parent);
		public double powspec (double x);
		public static void prior_top_add (Ncm.Likelihood lh, double z, double alpha, double sigma_alpha, int n);
		public static void prior_top_free (Nc.HICosmoPriorTop tp);
		public static void prior_top_set (Nc.HICosmoPriorTop tp, double z, double alpha, double sigma_alpha, int n);
		public double q (double z);
		public static double qg_V (Ncm.Model model, double x, void* userdata);
		public static double qg_V_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_alphaprime2 (Ncm.Model model, double alpha, void* data);
		public static double qg_beta (Ncm.Model model, double x, void* userdata);
		public static double qg_cs2 (Ncm.Model model, double x, void* userdata);
		public static double qg_cs2_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_cs2_xxbar2 (Ncm.Model model, double x, void* userdata);
		public static double qg_cs2zeta2_int_1_zeta2_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_d2sqrtxxbarzeta_sqrtxxbarzeta (Ncm.Model model, double x, void* userdata);
		public static double qg_dalphaprime2_dalpha (Ncm.Model model, double alpha, void* data);
		public static double qg_dcs2 (Ncm.Model model, double x, void* userdata);
		public static double qg_ddzeta_zeta (Ncm.Model model, double x, void* userdata);
		public static double qg_dxxbarzeta2_xxbarzeta2 (Ncm.Model model, double x, void* userdata);
		public static double qg_dzeta_zeta (Ncm.Model model, double x, void* userdata);
		public static double qg_eta_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_gbar2 (Ncm.Model model, double x);
		public static double qg_gbar_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_gbarbar (Ncm.Model model, double x);
		public static double qg_gbarbar_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_get_eta_b (Ncm.Model model, void* userdata);
		public static double qg_get_lambda_d (Ncm.Model model, void* userdata);
		public static double qg_get_lambda_f (Ncm.Model model, void* userdata);
		public static double qg_get_lambda_i (Ncm.Model model, void* userdata);
		public static double qg_int_1_zeta2_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_lambda_k_cross (Ncm.Model model, double lambda, bool deriv);
		public static double qg_lambda_x (Ncm.Model model, double x, void* userdata);
		public static void qg_max_z (Ncm.Model model, double max, double trans);
		public static bool qg_modefunc_evolve (Nc.HICosmoQGMode qgmode);
		public static bool qg_modefunc_init (Nc.HICosmoQGMode qgmode);
		public static bool qg_modefunc_set_opts (Nc.HICosmoQGMode qgmode);
		public static bool qg_modefuncm_cvode_init (Nc.HICosmoQGMode qgmode);
		[CCode (cname = "nc_hicosmo_qg_new", has_construct_function = false)]
		public HICosmo.qg_new ();
		public static void qg_pert_R_to_h (Nc.HICosmoQGMode qgmode, double x, double R);
		public static bool qg_pert_evolve (Nc.HICosmoQGMode qgmode);
		public static void qg_pert_h_to_R (Nc.HICosmoQGMode qgmode, double x, double h);
		public static bool qg_pert_init (Nc.HICosmoQGMode qgmode, double k);
		public static double qg_pert_powerspectrum (Nc.HICosmoQGMode qgmode, double x, double R);
		public static bool qg_pert_prepare_pw_spline (Nc.HICosmoQGMode qgmode, bool verbose);
		public static bool qg_pert_set_opts (Nc.HICosmoQGMode qgmode);
		public static double qg_x_lambda (Ncm.Model model, double lambda, bool deriv);
		public static double qg_xbar (Ncm.Model model, double x, void* userdata);
		public static double qg_xddzeta_zeta_mxdzeta_zeta2_dzeta_zeta (Ncm.Model model, double x, void* userdata);
		public static double qg_xxbarzeta2 (Ncm.Model model, double x, void* userdata);
		public static double qg_zeta (Ncm.Model model, double x, void* userdata);
		public double qp (double z);
		public Nc.HICosmo @ref ();
		public double rhopp (double x);
		public double sigma_8 ();
		public double wec (double z);
		public double x_alpha (double alpha);
		public double xb ();
		public double z_lss ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de", type_id = "nc_hicosmo_de_get_type ()")]
	public abstract class HICosmoDE : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		protected HICosmoDE ();
		public double dweff_dz (double x);
		public static bool new_add_bbn (Ncm.Likelihood lh);
		public void omega_x2omega_k ();
		public void set_wmap5_params ();
		public double weff (double x);
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegab { get; set; }
		[NoAccessorMethod]
		public bool Omegab_fit { get; set; }
		[NoAccessorMethod]
		public double Omegac { get; set; }
		[NoAccessorMethod]
		public bool Omegac_fit { get; set; }
		[NoAccessorMethod]
		public double Omegax { get; set; }
		[NoAccessorMethod]
		public bool Omegax_fit { get; set; }
		[NoAccessorMethod]
		public double Tgamma0 { get; set; }
		[NoAccessorMethod]
		public bool Tgamma0_fit { get; set; }
		[NoAccessorMethod]
		public double ns { get; set; }
		[NoAccessorMethod]
		public bool ns_fit { get; set; }
		[NoAccessorMethod]
		public double sigma8 { get; set; }
		[NoAccessorMethod]
		public bool sigma8_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de_linder", type_id = "nc_hicosmo_de_linder_get_type ()")]
	public class HICosmoDELinder : Nc.HICosmoDE {
		[CCode (has_construct_function = false)]
		public HICosmoDELinder ();
		[NoAccessorMethod]
		public double w0 { get; set; }
		[NoAccessorMethod]
		public bool w0_fit { get; set; }
		[NoAccessorMethod]
		public double w1 { get; set; }
		[NoAccessorMethod]
		public bool w1_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de_pad", type_id = "nc_hicosmo_de_pad_get_type ()")]
	public class HICosmoDEPad : Nc.HICosmoDE {
		[CCode (has_construct_function = false)]
		public HICosmoDEPad ();
		[NoAccessorMethod]
		public double w0 { get; set; }
		[NoAccessorMethod]
		public bool w0_fit { get; set; }
		[NoAccessorMethod]
		public double w1 { get; set; }
		[NoAccessorMethod]
		public bool w1_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de_qe", type_id = "nc_hicosmo_de_qe_get_type ()")]
	public class HICosmoDEQe : Nc.HICosmoDE {
		[CCode (has_construct_function = false)]
		public HICosmoDEQe ();
		[NoAccessorMethod]
		public double w0 { get; set; }
		[NoAccessorMethod]
		public bool w0_fit { get; set; }
		[NoAccessorMethod]
		public double w1 { get; set; }
		[NoAccessorMethod]
		public bool w1_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_de_xcdm", type_id = "nc_hicosmo_de_xcdm_get_type ()")]
	public class HICosmoDEXcdm : Nc.HICosmoDE {
		[CCode (has_construct_function = false)]
		public HICosmoDEXcdm ();
		[NoAccessorMethod]
		public double w { get; set; }
		[NoAccessorMethod]
		public bool w_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_lcdm", type_id = "nc_hicosmo_lcdm_get_type ()")]
	public class HICosmoLCDM : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		public HICosmoLCDM ();
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegab { get; set; }
		[NoAccessorMethod]
		public bool Omegab_fit { get; set; }
		[NoAccessorMethod]
		public double Omegac { get; set; }
		[NoAccessorMethod]
		public bool Omegac_fit { get; set; }
		[NoAccessorMethod]
		public double Omegax { get; set; }
		[NoAccessorMethod]
		public bool Omegax_fit { get; set; }
		[NoAccessorMethod]
		public double Tgamma0 { get; set; }
		[NoAccessorMethod]
		public bool Tgamma0_fit { get; set; }
		[NoAccessorMethod]
		public double ns { get; set; }
		[NoAccessorMethod]
		public bool ns_fit { get; set; }
		[NoAccessorMethod]
		public double sigma8 { get; set; }
		[NoAccessorMethod]
		public bool sigma8_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_qconst", type_id = "nc_hicosmo_qconst_get_type ()")]
	public class HICosmoQConst : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		public HICosmoQConst ();
		[NoAccessorMethod]
		public double E { get; set; }
		[NoAccessorMethod]
		public bool E_fit { get; set; }
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegat { get; set; }
		[NoAccessorMethod]
		public bool Omegat_fit { get; set; }
		[NoAccessorMethod]
		public double cd { get; set; }
		[NoAccessorMethod]
		public bool cd_fit { get; set; }
		[NoAccessorMethod]
		public double q { get; set; }
		[NoAccessorMethod]
		public bool q_fit { get; set; }
		[NoAccessorMethod]
		public double zs { get; set; }
		[NoAccessorMethod]
		public bool zs_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_qgrw", type_id = "nc_hicosmo_qgrw_get_type ()")]
	public class HICosmoQGRW : Nc.HICosmo, Nc.HIPertIAdiab, Nc.HIPertITwoFluids {
		[CCode (has_construct_function = false)]
		public HICosmoQGRW ();
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegar { get; set; }
		[NoAccessorMethod]
		public bool Omegar_fit { get; set; }
		[NoAccessorMethod]
		public double Omegaw { get; set; }
		[NoAccessorMethod]
		public bool Omegaw_fit { get; set; }
		[NoAccessorMethod]
		public double w { get; set; }
		[NoAccessorMethod]
		public bool w_fit { get; set; }
		[NoAccessorMethod]
		public double xb { get; set; }
		[NoAccessorMethod]
		public bool xb_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_qlinear", type_id = "nc_hicosmo_qlinear_get_type ()")]
	public class HICosmoQLinear : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		public HICosmoQLinear ();
		public static double dE (double z2, double z1, double q, double qp);
		[NoAccessorMethod]
		public double E { get; set; }
		[NoAccessorMethod]
		public bool E_fit { get; set; }
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegat { get; set; }
		[NoAccessorMethod]
		public bool Omegat_fit { get; set; }
		[NoAccessorMethod]
		public double cd { get; set; }
		[NoAccessorMethod]
		public bool cd_fit { get; set; }
		[NoAccessorMethod]
		public double q { get; set; }
		[NoAccessorMethod]
		public bool q_fit { get; set; }
		[NoAccessorMethod]
		public double qp { get; set; }
		[NoAccessorMethod]
		public bool qp_fit { get; set; }
		[NoAccessorMethod]
		public double zs { get; set; }
		[NoAccessorMethod]
		public bool zs_fit { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_qspline", type_id = "nc_hicosmo_qspline_get_type ()")]
	public class HICosmoQSpline : Nc.HICosmo {
		[CCode (has_construct_function = false)]
		public HICosmoQSpline (Ncm.Spline s, size_t np, double z_f);
		public void add_continuity_constraint (Ncm.Fit fit, uint knot, Nc.HICosmoQSplineContPrior qspline_cp);
		public Nc.HICosmoQSplineContPrior add_continuity_constraints (Ncm.Fit fit, double sigma);
		public void add_continuity_prior (Ncm.Likelihood lh, uint knot, Nc.HICosmoQSplineContPrior qspline_cp);
		public Nc.HICosmoQSplineContPrior add_continuity_priors (Ncm.Likelihood lh, double sigma, double abstol);
		[NoAccessorMethod]
		public double H0 { get; set; }
		[NoAccessorMethod]
		public bool H0_fit { get; set; }
		[NoAccessorMethod]
		public double Omegat { get; set; }
		[NoAccessorMethod]
		public bool Omegat_fit { get; set; }
		[NoAccessorMethod]
		public double asdrag { get; set; }
		[NoAccessorMethod]
		public bool asdrag_fit { get; set; }
		[NoAccessorMethod]
		public GLib.Variant qparam { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant qparam_fit { owned get; set; }
		[NoAccessorMethod]
		public uint qparam_length { get; construct; }
		[NoAccessorMethod]
		public Ncm.Spline spline { owned get; construct; }
		[NoAccessorMethod]
		public double zf { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hicosmo_qspline_cont_prior", type_id = "nc_hicosmo_qspline_cont_prior_get_type ()")]
	public class HICosmoQSplineContPrior : Ncm.Model {
		[CCode (has_construct_function = false)]
		public HICosmoQSplineContPrior (uint npriors);
		public void free ();
		public double get_abstol ();
		public double get_lnsigma (uint i);
		public static int32 id ();
		public Nc.HICosmoQSplineContPrior @ref ();
		public void set_abstol (double abstol);
		public void set_all_lnsigma (double ln_sigma);
		public void set_lnsigma (uint i, double ln_sigma);
		public double abstol { get; set; }
		[NoAccessorMethod]
		public bool abstol_fit { get; set; }
		[NoAccessorMethod]
		public GLib.Variant lnsigma { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant lnsigma_fit { owned get; set; }
		[NoAccessorMethod]
		public uint lnsigma_length { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hipert", type_id = "nc_hipert_get_type ()")]
	public abstract class HIPert : GLib.Object {
		[CCode (has_construct_function = false)]
		protected HIPert ();
		public double get_abstol ();
		public double get_reltol ();
		public virtual void set_abstol (double abstol);
		public virtual void set_mode_k (double k);
		public virtual void set_reltol (double reltol);
		public void set_stiff_solver (bool stiff);
		public void set_sys_size (uint sys_size);
		public double abstol { get; set construct; }
		[NoAccessorMethod]
		public double alphai { get; set; }
		[NoAccessorMethod]
		public double k { get; set construct; }
		public double reltol { get; set construct; }
		[NoAccessorMethod]
		public uint sys_size { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hipert_adiab", type_id = "nc_hipert_adiab_get_type ()")]
	public class HIPertAdiab : Nc.HIPert {
		[CCode (has_construct_function = false)]
		public HIPertAdiab ();
		public static void clear (Nc.HIPertAdiab pa);
		public void evolve (Nc.HICosmo cosmo, double alphaf);
		public void free ();
		public void get_values (out double alpha_i, out double Re_zeta, out double Im_zeta, out double Re_Pzeta, out double Im_Pzeta);
		public void prepare_wkb (Nc.HICosmo cosmo, double prec, double alpha_i, double alpha_f);
		public Nc.HIPertAdiab @ref ();
		public void set_init_cond (Nc.HICosmo cosmo, double alpha_i, double Re_zeta, double Im_zeta, double Re_Pzeta, double Im_Pzeta);
		public void set_init_cond_wkb (Nc.HICosmo cosmo, double alpha_i);
		public double wkb_maxtime (Nc.HICosmo cosmo, double alpha0, double alpha1);
		public double wkb_maxtime_prec (Nc.HICosmo cosmo, Nc.HIPertWKBCmp cmp, double prec, double alpha0, double alpha1);
		public void wkb_v (Nc.HICosmo cosmo, double alpha, double Re_v, double Im_v);
		public void wkb_zeta (Nc.HICosmo cosmo, double alpha, out double Re_zeta, out double Im_zeta);
		public void wkb_zeta_Pzeta (Nc.HICosmo cosmo, double alpha, out double Re_zeta, out double Im_zeta, out double Re_Pzeta, out double Im_Pzeta);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hipert_boltzmann", type_id = "nc_hipert_boltzmann_get_type ()")]
	public abstract class HIPertBoltzmann : Nc.HIPert {
		[CCode (has_construct_function = false)]
		public HIPertBoltzmann ();
		public static void clear (Nc.HIPertBoltzmann pb);
		[NoWrapper]
		public virtual void evol (double g);
		[NoWrapper]
		public virtual void evol_step (double g);
		public void free ();
		[NoWrapper]
		public virtual double @get (uint n);
		[NoWrapper]
		public virtual double get_b0 ();
		[NoWrapper]
		public virtual double get_b1 ();
		[NoWrapper]
		public virtual double get_c0 ();
		[NoWrapper]
		public virtual double get_c1 ();
		[NoWrapper]
		public virtual double get_los_theta (uint n);
		[NoWrapper]
		public virtual double get_phi ();
		[NoWrapper]
		public virtual void get_sources (double S0, double S1, double S2);
		[NoWrapper]
		public virtual double get_theta (uint n);
		[NoWrapper]
		public virtual double get_theta_p (uint n);
		[NoWrapper]
		public virtual double get_z ();
		[NoWrapper]
		public virtual void init (Nc.HICosmo cosmo);
		public void prepare (Nc.HICosmo cosmo);
		[NoWrapper]
		public virtual void print_all ();
		[NoWrapper]
		public virtual void print_stats ();
		public Nc.HIPertBoltzmann @ref ();
		[NoWrapper]
		public virtual void reset ();
		public void set_lmax (uint lmax);
		[NoWrapper]
		public virtual void set_opts ();
		public void set_recomb (Nc.Recomb recomb);
		[NoAccessorMethod]
		public uint l_max { get; set construct; }
		[NoAccessorMethod]
		public Nc.Recomb recomb { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hipert_boltzmann_std", type_id = "nc_hipert_boltzmann_std_get_type ()")]
	public class HIPertBoltzmannStd : Nc.HIPertBoltzmann {
		[CCode (has_construct_function = false)]
		public HIPertBoltzmannStd (Nc.Recomb recomb, uint lmax);
		[NoAccessorMethod]
		public uint l_maxa { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", lower_case_csuffix = "hipert_iadiab_eom", type_id = "nc_hipert_iadiab_eom_get_type ()")]
	[Compact]
	public class HIPertIAdiabEOM {
		public Nc.HIPertIAdiabEOM dup ();
		public void free ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", lower_case_csuffix = "hipert_itwo_fluids_eom", type_id = "nc_hipert_itwo_fluids_eom_get_type ()")]
	[Compact]
	public class HIPertITwoFluidsEOM {
		public Nc.HIPertITwoFluidsEOM dup ();
		public void free ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hipert_two_fluids", type_id = "nc_hipert_two_fluids_get_type ()")]
	public class HIPertTwoFluids : Nc.HIPert {
		[CCode (has_construct_function = false)]
		public HIPertTwoFluids ();
		public double LA (Nc.HICosmo cosmo, double alpha);
		public double LB (Nc.HICosmo cosmo, double alpha);
		public double YAB (Nc.HICosmo cosmo, double alpha);
		public static void clear (Nc.HIPertTwoFluids ptf);
		public void eom_full (Nc.HICosmo cosmo, double alpha, out unowned Nc.HIPertITwoFluidsEOM eom_full);
		public void evolve (Nc.HICosmo cosmo, double alphaf);
		public void free ();
		public void get_values (out double alphai, [CCode (array_length = false)] ref double[] vars);
		public double laq2 (Nc.HICosmo cosmo, double alpha);
		public double lazeta2 (Nc.HICosmo cosmo, double alpha);
		public double nuA (Nc.HICosmo cosmo, double alpha);
		public double nuB (Nc.HICosmo cosmo, double alpha);
		public double nuS2 (Nc.HICosmo cosmo, double alpha);
		public double numinus2 (Nc.HICosmo cosmo, double alpha);
		public double nuplus2 (Nc.HICosmo cosmo, double alpha);
		public double nuzeta2 (Nc.HICosmo cosmo, double alpha);
		public void prepare_wkb_S (Nc.HICosmo cosmo, double prec, double alpha_i, double alpha_f);
		public void prepare_wkb_zeta (Nc.HICosmo cosmo, double prec, double alpha_i, double alpha_f);
		public Nc.HIPertTwoFluids @ref ();
		public void set_init_cond (Nc.HICosmo cosmo, double alphai, [CCode (array_length = false)] double[] vars);
		public void set_init_cond_wkb_Q (Nc.HICosmo cosmo, double alphai);
		public void set_init_cond_wkb_zeta (Nc.HICosmo cosmo, double alphai);
		public void wkb_Q (Nc.HICosmo cosmo, double alpha, out double Re_Q, out double Im_Q);
		public void wkb_Q_PQ (Nc.HICosmo cosmo, double alpha, out double Re_Q, out double Im_Q, out double Re_PQ, out double Im_PQ);
		public double wkb_S_maxtime (Nc.HICosmo cosmo, double alpha0, double alpha1);
		public double wkb_S_maxtime_prec (Nc.HICosmo cosmo, Nc.HIPertWKBCmp cmp, double prec, double alpha0, double alpha1);
		public void wkb_full_Q (Nc.HICosmo cosmo, double alpha, [CCode (array_length = false)] ref double[] vars);
		public void wkb_full_zeta (Nc.HICosmo cosmo, double alpha, [CCode (array_length = false)] ref double[] vars);
		public void wkb_zeta (Nc.HICosmo cosmo, double alpha, out double Re_zeta, out double Im_zeta);
		public void wkb_zeta_Pzeta (Nc.HICosmo cosmo, double alpha, out double Re_zeta, out double Im_zeta, out double Re_Pzeta, out double Im_Pzeta);
		public double wkb_zeta_maxtime (Nc.HICosmo cosmo, double alpha0, double alpha1);
		public double wkb_zeta_maxtime_prec (Nc.HICosmo cosmo, Nc.HIPertWKBCmp cmp, double prec, double alpha0, double alpha1);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hipert_wkb", type_id = "nc_hipert_wkb_get_type ()")]
	public class HIPertWKB : Nc.HIPert {
		[CCode (has_construct_function = false)]
		public HIPertWKB (GLib.Type impl_type, Nc.HIPertWKBFunc nuA2, Nc.HIPertWKBFunc V, Nc.HIPertWKBFunc dmnuA_nuA, Nc.HIPertWKBEom eom);
		public static void clear (Nc.HIPertWKB wkb);
		public void free ();
		public double maxtime (GLib.Object obj, double alpha0, double alpha1);
		public double maxtime_prec (GLib.Object obj, Nc.HIPertWKBCmp cmp, double prec, double alpha0, double alpha1);
		public double nuA (GLib.Object obj, double alpha);
		public double phase (GLib.Object obj, double alpha);
		public void prepare (GLib.Object obj, double prec, double alpha_i, double alpha_f);
		public void q (GLib.Object obj, double alpha, out double Re_q, out double Im_q);
		public void q_p (GLib.Object obj, double alpha, out double Re_q, out double Im_q, out double Re_p, out double Im_p);
		public Nc.HIPertWKB @ref ();
		public void* V { construct; }
		public void* dmnuA_nuA { construct; }
		public void* eom { construct; }
		public GLib.Type impl_type { construct; }
		public void* nuA2 { construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_func_get_type ()")]
	public class HaloBiasFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		public HaloBiasFunc (Nc.MassFunction mfp, Nc.HaloBiasType? biasf);
		public static void clear (Nc.HaloBiasFunc mbiasf);
		public Nc.HaloBiasFunc copy ();
		public void free ();
		public double integrand (Nc.HICosmo model, double lnM, double z);
		[NoAccessorMethod]
		public Nc.HaloBiasType bias_type { owned get; construct; }
		[NoAccessorMethod]
		public Nc.MassFunction mass_function { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_get_type ()")]
	public abstract class HaloBiasType : GLib.Object {
		[CCode (has_construct_function = false)]
		protected HaloBiasType ();
		public static void clear (Nc.HaloBiasType biasf);
		public virtual double eval (double sigma, double z);
		public void free ();
		[CCode (has_construct_function = false)]
		public HaloBiasType.from_name (string bias_name);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_ps_get_type ()")]
	public class HaloBiasTypePS : Nc.HaloBiasType {
		[CCode (has_construct_function = false, type = "NcHaloBiasType*")]
		public HaloBiasTypePS (double delta_c);
		public double get_delta_c ();
		public void set_delta_c (double delta_c);
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_st_ellip_get_type ()")]
	public class HaloBiasTypeSTEllip : Nc.HaloBiasType {
		[CCode (has_construct_function = false, type = "NcHaloBiasType*")]
		public HaloBiasTypeSTEllip (double delta_c, double a, double b, double c);
		public double get_a ();
		public double get_b ();
		public double get_c ();
		public double get_delta_c ();
		public void set_a (double a);
		public void set_b (double b);
		public void set_c (double c);
		public void set_delta_c (double delta_c);
		public double a { get; construct; }
		public double b { get; construct; }
		public double c { get; construct; }
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_st_spher_get_type ()")]
	public class HaloBiasTypeSTSpher : Nc.HaloBiasType {
		[CCode (has_construct_function = false, type = "NcHaloBiasType*")]
		public HaloBiasTypeSTSpher (double delta_c, double a, double p);
		public double get_a ();
		public double get_delta_c ();
		public double get_p ();
		public void set_a (double a);
		public void set_delta_c (double delta_c);
		public void set_p (double p);
		public double a { get; construct; }
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
		public double p { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_halo_bias_type_tinker_get_type ()")]
	public class HaloBiasTypeTinker : Nc.HaloBiasType {
		[CCode (has_construct_function = false, type = "NcHaloBiasType*")]
		public HaloBiasTypeTinker (double delta_c, double B, double b, double c, double Delta);
		public double get_B ();
		public double get_Delta ();
		public double get_b ();
		public double get_c ();
		public double get_delta_c ();
		public void set_B (double B);
		public void set_Delta (double Delta);
		public void set_b (double b);
		public void set_c (double c);
		public void set_delta_c (double delta_c);
		public double B { get; construct; }
		public double Delta { get; construct; }
		public double b { get; construct; }
		public double c { get; construct; }
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_mass_function_get_type ()")]
	public class MassFunction : GLib.Object {
		[CCode (has_construct_function = false)]
		public MassFunction (Nc.Distance dist, Nc.MatterVar vp, Nc.GrowthFunc gf, Nc.MultiplicityFunc mulf);
		public static void alpha_eff (Nc.MatterVar vp, Nc.HICosmo model, double lnM, double a_eff_ptr);
		public static void clear (Nc.MassFunction mfp);
		public Nc.MassFunction copy ();
		public double d2n_dzdlnm (Nc.HICosmo model, double lnM, double z);
		public double dn_M1_to_M2_dv (Nc.HICosmo model, double M1, double M2, double z);
		public double dn_M_to_inf_dv (Nc.HICosmo model, double M, double z);
		public double dn_dlnm (Nc.HICosmo model, double lnM, double z);
		public double dn_dz (Nc.HICosmo model, double lnMl, double lnMu, double z, bool spline);
		public double dv_dzdomega (Nc.HICosmo model, double z);
		public void free ();
		public double n (Nc.HICosmo model, double lnMl, double lnMu, double zl, double zu, Nc.MassFunctionSplineOptimize spline);
		public void prepare (Nc.HICosmo model);
		public void prepare_if_needed (Nc.HICosmo model);
		public void set_area (double area);
		public void set_area_sd (double area_sd);
		public void set_eval_limits (Nc.HICosmo model, double lnMi, double lnMf, double zi, double zf);
		public void set_prec (double prec);
		public void sigma (Nc.HICosmo model, double lnM, double z, double dn_dlnM_ptr, double sigma_ptr);
		[NoAccessorMethod]
		public double area { get; set construct; }
		[NoAccessorMethod]
		public Nc.Distance distance { owned get; construct; }
		[NoAccessorMethod]
		public Nc.GrowthFunc growth { owned get; construct; }
		[NoAccessorMethod]
		public Nc.MultiplicityFunc multiplicity { owned get; construct; }
		[NoAccessorMethod]
		public double prec { get; set construct; }
		[NoAccessorMethod]
		public Nc.MatterVar variance { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_matter_var_get_type ()")]
	public class MatterVar : GLib.Object {
		[CCode (has_construct_function = false)]
		public MatterVar (Nc.MatterVarStrategy vs, Nc.Window wp, Nc.TransferFunc tf);
		public double R_to_mass (Nc.HICosmo model, double R);
		public static void clear (Nc.MatterVar vp);
		public Nc.MatterVar copy ();
		public double dlnvar0_dR (Nc.HICosmo model, double lnR);
		public double dlnvar0_dlnR (Nc.HICosmo model, double lnR);
		public double dsigma0_dR (Nc.HICosmo model, double lnR);
		public void free ();
		public double integrand_over_window2 (Nc.HICosmo model, double k);
		public double lnM_to_lnR (Nc.HICosmo model, double lnM);
		public double lnR_to_lnM (Nc.HICosmo model, double lnR);
		public double mass_to_R (Nc.HICosmo model, double M);
		public void prepare (Nc.HICosmo model);
		public double sigma8_sqrtvar0 (Nc.HICosmo model);
		public double spectral_moment_over_growth2 (Nc.HICosmo model, int n);
		public double spectral_moment_over_growth2_gaussian (Nc.HICosmo model, int n);
		public double spectral_moment_over_growth2_tophat (Nc.HICosmo model, int n);
		public double var0 (Nc.HICosmo model, double lnR);
		[NoAccessorMethod]
		public Nc.MatterVarStrategy strategy { get; construct; }
		[NoAccessorMethod]
		public Nc.TransferFunc transfer { owned get; construct; }
		[NoAccessorMethod]
		public Nc.Window window { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_get_type ()")]
	public abstract class MultiplicityFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MultiplicityFunc ();
		public static void clear (Nc.MultiplicityFunc mulf);
		public virtual double eval (Nc.HICosmo model, double sigma, double z);
		public void free ();
		[CCode (has_construct_function = false)]
		public MultiplicityFunc.from_name (string multiplicity_name);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_jenkins_get_type ()")]
	public class MultiplicityFuncJenkins : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncJenkins (double A, double A_tCDM, double B, double B_tCDM, double epsilon, double epsilon_tCDM);
		public double get_A ();
		public double get_A_tCDM ();
		public double get_B ();
		public double get_B_tCDM ();
		public double get_epsilon ();
		public double get_epsilon_tCDM ();
		public void set_A (double A);
		public void set_A_tCDM (double A_tCDM);
		public void set_B (double B);
		public void set_B_tCDM (double B_tCDM);
		public void set_epsilon (double epsilon);
		public void set_epsilon_tCDM (double epsilon_tCDM);
		public double A { get; construct; }
		public double A_tCDM { get; construct; }
		public double B { get; construct; }
		public double B_tCDM { get; construct; }
		public double epsilon { get; construct; }
		public double epsilon_tCDM { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_ps_get_type ()")]
	public class MultiplicityFuncPS : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncPS (double delta_c);
		public double get_delta_c ();
		public void set_delta_c (double delta_c);
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_st_get_type ()")]
	public class MultiplicityFuncST : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncST (double A, double b, double p, double delta_c);
		public double get_A ();
		public double get_b ();
		public double get_delta_c ();
		public double get_p ();
		public void set_A (double A);
		public void set_b (double b);
		public void set_delta_c (double delta_c);
		public void set_p (double p);
		public double A { get; construct; }
		public double b { get; construct; }
		[NoAccessorMethod]
		public double critical_delta { get; construct; }
		public double p { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_tinker_get_type ()")]
	public class MultiplicityFuncTinker : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncTinker (double A0, double a0, double b0, double c, double Delta);
		public double get_A0 ();
		public double get_Delta ();
		public double get_a0 ();
		public double get_b0 ();
		public double get_c ();
		public void set_A0 (double A0);
		public void set_Delta (double Delta);
		public void set_a0 (double a0);
		public void set_b0 (double b0);
		public void set_c (double c);
		public double A0 { get; construct; }
		public double Delta { get; construct; }
		public double a0 { get; construct; }
		public double b0 { get; construct; }
		public double c { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_tinker_crit_get_type ()")]
	public class MultiplicityFuncTinkerCrit : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncTinkerCrit (double Delta);
		public double get_Delta ();
		public void set_Delta (double Delta);
		public double Delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_tinker_mean_get_type ()")]
	public class MultiplicityFuncTinkerMean : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncTinkerMean (double Delta);
		public double get_Delta ();
		public void set_Delta (double Delta);
		public double Delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_tinker_mean_normalized_get_type ()")]
	public class MultiplicityFuncTinkerMeanNormalized : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncTinkerMeanNormalized (double Delta);
		public double get_Delta ();
		public void set_Delta (double Delta);
		public double Delta { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_multiplicity_func_warren_get_type ()")]
	public class MultiplicityFuncWarren : Nc.MultiplicityFunc {
		[CCode (has_construct_function = false, type = "NcMultiplicityFunc*")]
		public MultiplicityFuncWarren (double A, double a, double b, double c);
		public double get_A ();
		public double get_a ();
		public double get_b ();
		public double get_c ();
		public void set_A (double A);
		public void set_a (double a);
		public void set_b (double b);
		public void set_c (double c);
		public double A { get; construct; }
		public double a { get; construct; }
		public double b { get; construct; }
		public double c { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_recomb_get_type ()")]
	public abstract class Recomb : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Recomb ();
		public static double HI_ion_saha (Nc.HICosmo cosmo, double x);
		public static double HeII_ion_saha (Nc.HICosmo cosmo, double x);
		public static double HeII_ion_saha_x (Nc.HICosmo cosmo, double f);
		public static double HeII_ion_saha_x_by_HeIII_He (Nc.HICosmo cosmo, double f);
		public static double HeI_ion_saha (Nc.HICosmo cosmo, double x);
		public static double He_fully_ionized_Xe (Nc.HICosmo cosmo, double x);
		public static double He_fully_ionized_dtau_dlambda (Nc.HICosmo cosmo, double lambda);
		public double Xe (Nc.HICosmo cosmo, double lambda);
		public static void clear (Nc.Recomb recomb);
		public double d2tau_dlambda2 (Nc.HICosmo cosmo, double lambda);
		public double d2v_tau_dlambda2 (Nc.HICosmo cosmo, double lambda);
		public double d3tau_dlambda3 (Nc.HICosmo cosmo, double lambda);
		public double dtau_dlambda (Nc.HICosmo cosmo, double lambda);
		public static double dtau_dlambda_Xe (Nc.HICosmo cosmo, double lambda);
		public double dtau_dx (Nc.HICosmo cosmo, double lambda);
		public double dv_tau_dlambda (Nc.HICosmo cosmo, double lambda);
		public double equilibrium_Xe (Nc.HICosmo cosmo, double x);
		public void free ();
		[CCode (has_construct_function = false)]
		public Recomb.from_name (string recomb_name);
		public static double hummer_HeI_case_B (Nc.HICosmo cosmo, double Tm);
		public static double hummer_HeI_case_B_dTm (Nc.HICosmo cosmo, double Tm);
		public double log_v_tau (Nc.HICosmo cosmo, double lambda);
		public static double pequignot_HI_case_B (Nc.HICosmo cosmo, double Tm);
		public static double pequignot_HI_case_B_dTm (Nc.HICosmo cosmo, double Tm);
		public virtual void prepare (Nc.HICosmo cosmo);
		public void prepare_if_needed (Nc.HICosmo cosmo);
		public Nc.Recomb @ref ();
		public double tau (Nc.HICosmo cosmo, double lambda);
		public double tau_cutoff (Nc.HICosmo cosmo);
		public double tau_lambda0_lambda1 (Nc.HICosmo cosmo, double lambda0, double lambda1);
		public double tau_zdrag (Nc.HICosmo cosmo);
		public double tau_zstar (Nc.HICosmo cosmo);
		public double v_tau (Nc.HICosmo cosmo, double lambda);
		public void v_tau_lambda_features (Nc.HICosmo cosmo, double logref, out double lambda_max, out double lambda_l, out double lambda_u);
		public double v_tau_lambda_mode (Nc.HICosmo cosmo);
		[NoAccessorMethod]
		public double init_frac { get; set construct; }
		[NoAccessorMethod]
		public double prec { get; set construct; }
		[NoAccessorMethod]
		public double zi { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_recomb_seager_get_type ()")]
	public class RecombSeager : Nc.Recomb {
		[CCode (has_construct_function = false, type = "NcRecomb*")]
		public RecombSeager ();
		[CCode (has_construct_function = false, type = "NcRecomb*")]
		public RecombSeager.full (double init_frac, double zi, double prec);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_snia_dist_cov_get_type ()")]
	public class SNIADistCov : Ncm.Model {
		[CCode (has_construct_function = false)]
		public SNIADistCov (Nc.Distance dist, uint sigma_int_len);
		public void alpha_beta (out double alpha, out double beta);
		public void calc (Nc.DataSNIACov snia_cov, Ncm.Matrix cov);
		public static void clear (Nc.SNIADistCov dcov);
		public double extra_var (Nc.DataSNIACov snia_cov, uint i);
		public void free ();
		public static int32 id ();
		public double mag (Nc.HICosmo cosmo, Nc.DataSNIACov snia_cov, uint i, double width_th, double colour_th);
		public void mag_to_width_colour (Nc.HICosmo cosmo, Nc.DataSNIACov snia_cov, Ncm.Vector obs, Ncm.Matrix X, bool colmajor);
		public void mean (Nc.HICosmo cosmo, Nc.DataSNIACov snia_cov, Ncm.Vector y);
		public void prepare (Ncm.MSet mset);
		public void prepare_if_needed (Ncm.MSet mset);
		public Nc.SNIADistCov @ref ();
		public void set_empty_fac (bool enable);
		[NoAccessorMethod]
		public double M1 { get; set; }
		[NoAccessorMethod]
		public bool M1_fit { get; set; }
		[NoAccessorMethod]
		public double M2 { get; set; }
		[NoAccessorMethod]
		public bool M2_fit { get; set; }
		[NoAccessorMethod]
		public double alpha { get; set; }
		[NoAccessorMethod]
		public bool alpha_fit { get; set; }
		[NoAccessorMethod]
		public double beta { get; set; }
		[NoAccessorMethod]
		public bool beta_fit { get; set; }
		[NoAccessorMethod]
		public Nc.Distance dist { owned get; set construct; }
		[NoAccessorMethod]
		public bool empty_fac { get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant lnsigma_int { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant lnsigma_int_fit { owned get; set; }
		[NoAccessorMethod]
		public uint lnsigma_int_length { get; construct; }
		[NoAccessorMethod]
		public double lnsigma_lens { get; set; }
		[NoAccessorMethod]
		public bool lnsigma_lens_fit { get; set; }
		[NoAccessorMethod]
		public double lnsigma_pecz { get; set; }
		[NoAccessorMethod]
		public bool lnsigma_pecz_fit { get; set; }
		[NoAccessorMethod]
		public GLib.Variant mu { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant mu_fit { owned get; set; }
		[NoAccessorMethod]
		public uint mu_length { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "nc_scale_factor_get_type ()")]
	[Compact]
	public class ScaleFactor {
		[CCode (has_construct_function = false)]
		public ScaleFactor (Nc.ScaleFactorTimeType ttype, double zf);
		public double a_t (double t);
		public static void clear (Nc.ScaleFactor a);
		public Nc.ScaleFactor copy ();
		public void free ();
		public void prepare (Nc.HICosmo model);
		public void prepare_if_needed (Nc.HICosmo model);
		public double t_x (double x);
		public double t_z (double z);
		public double z_t (double t);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_get_type ()")]
	public abstract class TransferFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		protected TransferFunc ();
		[NoWrapper]
		public virtual double calc (double k);
		[NoWrapper]
		public virtual double calc_matter_P (Nc.HICosmo model, double k);
		public static void clear (Nc.TransferFunc tf);
		public double eval (Nc.HICosmo model, double kh);
		public void free ();
		[CCode (has_construct_function = false)]
		public TransferFunc.from_name (string transfer_name);
		public double matter_powerspectrum (Nc.HICosmo model, double kh);
		public virtual void prepare (Nc.HICosmo model);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_bbks_get_type ()")]
	public class TransferFuncBBKS : Nc.TransferFunc {
		[CCode (has_construct_function = false, type = "NcTransferFunc*")]
		public TransferFuncBBKS ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_camb_get_type ()")]
	public class TransferFuncCAMB : Nc.TransferFunc {
		[CCode (has_construct_function = false, type = "NcTransferFunc*")]
		public TransferFuncCAMB ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_eh_get_type ()")]
	public class TransferFuncEH : Nc.TransferFunc {
		[CCode (has_construct_function = false, type = "NcTransferFunc*")]
		public TransferFuncEH ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_transfer_func_pert_get_type ()")]
	public class TransferFuncPert : Nc.TransferFunc {
		[CCode (has_construct_function = false)]
		protected TransferFuncPert ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_window_get_type ()")]
	public abstract class Window : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Window ();
		public static void clear (Nc.Window wf);
		public virtual double deriv_fourier (double k, double R);
		public virtual double eval_fourier (double k, double R);
		[NoWrapper]
		public virtual double eval_real (double r, double R);
		public double eval_realspace (double r, double R);
		public void free ();
		[CCode (has_construct_function = false)]
		public Window.from_name (string window_name);
		public double volume ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_window_gaussian_get_type ()")]
	public class WindowGaussian : Nc.Window {
		[CCode (has_construct_function = false, type = "NcWindow*")]
		public WindowGaussian ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", type_id = "nc_window_tophat_get_type ()")]
	public class WindowTophat : Nc.Window {
		[CCode (has_construct_function = false, type = "NcWindow*")]
		public WindowTophat ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hipert_iadiab", type_cname = "NcHIPertIAdiabInterface", type_id = "nc_hipert_iadiab_get_type ()")]
	public interface HIPertIAdiab : GLib.Object {
		public abstract double VA (double alpha, double k);
		public abstract double dlnmzeta (double alpha, double k);
		public abstract double dmzetanuA_nuA (double alpha, double k);
		public abstract Nc.HIPertIAdiabEOM eom (double alpha, double k);
		public abstract double nuA2 (double alpha, double k);
		public void wkb_eom (double alpha, double k, double nu2, double m, double dlnm);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", lower_case_csuffix = "hipert_itwo_fluids", type_cname = "NcHIPertITwoFluidsInterface", type_id = "nc_hipert_itwo_fluids_get_type ()")]
	public interface HIPertITwoFluids : GLib.Object {
		public abstract double VA (double alpha, double k);
		public abstract double VB (double alpha, double k);
		public abstract double dlnmS (double alpha, double k);
		public abstract double dlnmzeta (double alpha, double k);
		public abstract double dmSnuB_nuB (double alpha, double k);
		public abstract double dmzetanuA_nuA (double alpha, double k);
		public abstract Nc.HIPertITwoFluidsEOM eom (double alpha, double k);
		public abstract Nc.HIPertITwoFluidsEOM eom_full (double alpha, double k);
		public abstract double nuA2 (double alpha, double k);
		public abstract double nuB2 (double alpha, double k);
		public void wkb_S_eom (double alpha, double k, double nu2, double m, double dlnm);
		public void wkb_zeta_eom (double alpha, double k, double nu2, double m, double dlnm);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct DistanceFunc {
		public weak string name;
		public weak string desc;
		public weak Nc.DistanceFunc0 f;
		public Nc.HICosmoImpl impl;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct DistanceFuncZ {
		public weak string name;
		public weak string desc;
		public weak Nc.DistanceFunc1 f;
		public Nc.HICosmoImpl impl;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct HICosmoFunc {
		public weak string name;
		public weak string desc;
		public weak Nc.HICosmoFunc0 f;
		public Nc.HICosmoImpl impl;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct HICosmoFuncZ {
		public weak string name;
		public weak string desc;
		public weak Nc.HICosmoFunc1 f;
		public Nc.HICosmoImpl impl;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct HICosmoPriorTop {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct HICosmoQGMode {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct LinearPert {
		public void* solver;
		public Nc.LinearPertWorkSpace pws;
		public double eta0;
		public double lambdai;
		public double lambdaf;
		public double lambda_opt_cutoff;
		public double lambda_rec;
		[CCode (array_length = false, array_null_terminated = true)]
		public weak double[] lambda_rec_10m2_max;
		public double abstol;
		public double reltol;
		public double tc_abstol;
		public double tc_reltol;
		public uint lmax;
		public uint sys_size;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct LinearPertOdeSolver {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct LinearPertSplines {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct LinearPertTF {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_type_id = false)]
	public struct LinearPertWorkSpace {
		public void* pert;
		public bool tight_coupling;
		public bool tight_coupling_end;
		public double lambda_int;
		public double lambda;
		public double dlambda;
		public double k;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_ABC_CLUSTER_NCOUNT_EPSILON_UPDATE_", type_id = "nc_abc_cluster_ncount_epsilon_update_get_type ()")]
	public enum ABCClusterNCountEpsilonUpdate {
		UNIFORM,
		QUANTILE
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_ABC_CLUSTER_NCOUNT_SUMMARY_", type_id = "nc_abc_cluster_ncount_summary_get_type ()")]
	public enum ABCClusterNCountSummary {
		BIN_UNIFORM,
		BIN_QUANTILE,
		BIN_NODES,
		GAUSS_RBF
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_BENSON_", type_id = "nc_cluster_mass_benson_params_get_type ()")]
	public enum ClusterMassBensonParams {
		A_SZ,
		B_SZ,
		C_SZ,
		D_SZ
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_BENSON_XRAY_", type_id = "nc_cluster_mass_benson_xray_params_get_type ()")]
	public enum ClusterMassBensonXRayParams {
		A_X,
		B_X,
		C_X,
		D_X
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_", type_id = "nc_cluster_mass_impl_get_type ()")]
	[Flags]
	public enum ClusterMassImpl {
		P,
		INTP,
		RESAMPLE,
		P_LIMITS,
		N_LIMITS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_LNNORMAL_", type_id = "nc_cluster_mass_lnnormal_params_get_type ()")]
	public enum ClusterMassLnnormalParams {
		BIAS,
		SIGMA
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_PLCL_", type_id = "nc_cluster_mass_plcl_params_get_type ()")]
	public enum ClusterMassPlclParams {
		A_SZ,
		B_SZ,
		SD_SZ,
		A_L,
		B_L,
		SD_L,
		COR,
		MCUT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_MASS_VANDERLINDE_", type_id = "nc_cluster_mass_vanderlinde_params_get_type ()")]
	public enum ClusterMassVanderlindeParams {
		A_SZ,
		B_SZ,
		C_SZ,
		D_SZ
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_PHOTOZ_GAUSS_GLOBAL_", type_id = "nc_cluster_photoz_gauss_global_params_get_type ()")]
	public enum ClusterPhotozGaussGlobalParams {
		Z_BIAS,
		SIGMA0
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_CLUSTER_REDSHIFT_", type_id = "nc_cluster_redshift_impl_get_type ()")]
	[Flags]
	public enum ClusterRedshiftImpl {
		P,
		INTP,
		RESAMPLE,
		P_LIMITS,
		N_LIMTS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_BAO_", type_id = "nc_data_bao_id_get_type ()")]
	public enum DataBaoId {
		A_EISENSTEIN2005,
		DV_EISENSTEIN2005,
		DVDV_PERCIVAL2007,
		DVDV_PERCIVAL2010,
		RDV_PERCIVAL2007,
		RDV_PERCIVAL2010,
		RDV_BEUTLER2011,
		RDV_PADMANABHAN2012,
		RDV_ANDERSON2012,
		RDV_BLAKE2012,
		RDV_KAZIN2014,
		EMPIRICAL_FIT_ROSS2015
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_CMB_", type_id = "nc_data_cmb_id_get_type ()")]
	public enum DataCMBId {
		SHIFT_PARAM_WMAP3,
		SHIFT_PARAM_WMAP5,
		SHIFT_PARAM_WMAP7,
		DIST_PRIORS_WMAP5,
		DIST_PRIORS_WMAP7,
		DIST_PRIORS_WMAP9
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_CLUSTER_ABUNDANCE_", type_id = "nc_data_cluster_abundance_id_get_type ()")]
	public enum DataClusterAbundanceId {
		FIT,
		TXT,
		SAMPLING
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_HUBBLE_BAO_", type_id = "nc_data_hubble_bao_id_get_type ()")]
	public enum DataHubbleBaoId {
		BUSCA2013
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_HUBBLE_", type_id = "nc_data_hubble_id_get_type ()")]
	public enum DataHubbleId {
		SIMON2005,
		CABRE,
		STERN2009,
		MORESCO2012_BC03,
		MORESCO2012_MASTRO,
		BUSCA2013_BAO_WMAP,
		RIESS2008_HST,
		ZHANG2012
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_SNIA_COV_", type_id = "nc_data_snia_cov_data_get_type ()")]
	public enum DataSNIACovData {
		ZCMB,
		ZHE,
		SIGMA_Z,
		MAG,
		SIGMA_MAG,
		WIDTH,
		SIGMA_WIDTH,
		COLOUR,
		SIGMA_COLOUR,
		THIRDPAR,
		SIGMA_THIRDPAR,
		DIAG_MAG_WIDTH,
		DIAG_MAG_COLOUR,
		DIAG_WIDTH_COLOUR,
		ABSMAG_SET,
		VAR_MAG,
		VAR_WIDTH,
		VAR_COLOUR,
		VAR_MAG_WIDTH,
		VAR_MAG_COLOUR,
		VAR_WIDTH_COLOUR
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_SNIA_COV_INIT_", type_id = "nc_data_snia_cov_data_init_get_type ()")]
	[Flags]
	public enum DataSNIACovDataInit {
		ZCMB,
		ZHE,
		SIGMA_Z,
		MAG,
		WIDTH,
		COLOUR,
		THIRDPAR,
		ABSMAG_SET,
		COV_FULL
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_SNIA_COV_V1_", type_id = "nc_data_snia_cov_data_v1_get_type ()")]
	public enum DataSNIACovDataV1 {
		ZCMB,
		ZHE,
		SIGMA_Z,
		MAG,
		WIDTH,
		COLOUR,
		THIRDPAR,
		SIGMA_THIRDPAR,
		ABSMAG_SET,
		MAG_MAG,
		MAG_WIDTH,
		MAG_COLOUR,
		WIDTH_WIDTH,
		WIDTH_COLOUR,
		COLOUR_COLOUR
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_SNIA_COV_ORDER_", type_id = "nc_data_snia_cov_order_get_type ()")]
	public enum DataSNIACovOrder {
		MAG_MAG,
		MAG_WIDTH,
		MAG_COLOUR,
		WIDTH_WIDTH,
		WIDTH_COLOUR,
		COLOUR_COLOUR
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_DATA_SNIA_", type_id = "nc_data_snia_id_get_type ()")]
	public enum DataSNIAId {
		SIMPLE_GOLD_157,
		SIMPLE_GOLD_182,
		SIMPLE_GOLD_182_FULL,
		SIMPLE_ESSENCE,
		SIMPLE_LEGACY,
		SIMPLE_UNION,
		[CCode (cname = "NC_DATA_SNIA_SIMPLE_CfA3")]
		SIMPLE_CFA3,
		SIMPLE_UNION2,
		SIMPLE_UNION2_1,
		SIMPLE_SDSS_EMILLE,
		COV_SNLS3_SYS_STAT,
		COV_SNLS3_STAT_ONLY,
		COV_JLA_SNLS3_SDSS_SYS_STAT,
		COV_JLA_SNLS3_SDSS_SYS_STAT_CMPL
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_IMPL_", type_id = "nc_hi_cosmo_de_impl_get_type ()")]
	[Flags]
	public enum HICosmoDEImpl {
		[CCode (cname = "NC_HICOSMO_DE_IMPL_weff")]
		WEFF,
		[CCode (cname = "NC_HICOSMO_DE_IMPL_dweff_dz")]
		DWEFF_DZ
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_LINDER_", type_id = "nc_hi_cosmo_de_linder_params_get_type ()")]
	public enum HICosmoDELinderParams {
		W0,
		W1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_PAD_", type_id = "nc_hi_cosmo_de_pad_params_get_type ()")]
	public enum HICosmoDEPadParams {
		W0,
		W1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_", type_id = "nc_hi_cosmo_de_params_get_type ()")]
	public enum HICosmoDEParams {
		H0,
		OMEGA_C,
		OMEGA_X,
		T_GAMMA0,
		OMEGA_B,
		SPECINDEX,
		SIGMA8
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_QE_", type_id = "nc_hi_cosmo_deqe_params_get_type ()")]
	public enum HICosmoDEQEParams {
		W0,
		W1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_DE_XCDM_", type_id = "nc_hi_cosmo_dexcdm_params_get_type ()")]
	public enum HICosmoDEXCDMParams {
		W
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_IMPL_", type_id = "nc_hi_cosmo_impl_get_type ()")]
	[Flags]
	public enum HICosmoImpl {
		H0,
		[CCode (cname = "NC_HICOSMO_IMPL_Omega_b")]
		OMEGA_B,
		[CCode (cname = "NC_HICOSMO_IMPL_Omega_r")]
		OMEGA_R,
		[CCode (cname = "NC_HICOSMO_IMPL_Omega_c")]
		OMEGA_C,
		[CCode (cname = "NC_HICOSMO_IMPL_Omega_t")]
		OMEGA_T,
		[CCode (cname = "NC_HICOSMO_IMPL_sigma_8")]
		SIGMA_8,
		[CCode (cname = "NC_HICOSMO_IMPL_T_gamma0")]
		T_GAMMA0,
		[CCode (cname = "NC_HICOSMO_IMPL_z_lss")]
		Z_LSS,
		[CCode (cname = "NC_HICOSMO_IMPL_as_drag")]
		AS_DRAG,
		[CCode (cname = "NC_HICOSMO_IMPL_xb")]
		XB,
		E2,
		[CCode (cname = "NC_HICOSMO_IMPL_dE2_dz")]
		DE2_DZ,
		[CCode (cname = "NC_HICOSMO_IMPL_d2E2_dz2")]
		D2E2_DZ2,
		[CCode (cname = "NC_HICOSMO_IMPL_cs2")]
		CS2,
		[CCode (cname = "NC_HICOSMO_IMPL_rhopp")]
		RHOPP,
		[CCode (cname = "NC_HICOSMO_IMPL_cd")]
		CD,
		[CCode (cname = "NC_HICOSMO_IMPL_powspec")]
		POWSPEC
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QCONST_", type_id = "nc_hi_cosmo_qconst_params_get_type ()")]
	public enum HICosmoQConstParams {
		H0,
		OMEGA_T,
		CD,
		E,
		Q,
		Z1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QG_PERT_", type_id = "nc_hi_cosmo_qg_pert_type_get_type ()")]
	public enum HICosmoQGPertType {
		CURVATURE,
		H
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QGRW_", type_id = "nc_hi_cosmo_qgrw_params_get_type ()")]
	public enum HICosmoQGRWParams {
		H0,
		OMEGA_R,
		OMEGA_W,
		W,
		X_B
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QLINEAR_", type_id = "nc_hi_cosmo_qlinear_params_get_type ()")]
	public enum HICosmoQLinearParams {
		H0,
		OMEGA_T,
		CD,
		E,
		Q,
		QP,
		Z1
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QSPLINE_", type_id = "nc_hi_cosmo_qspline_sparams_get_type ()")]
	public enum HICosmoQSplineSParams {
		H0,
		OMEGA_T,
		AS_DRAG
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HICOSMO_QSPLINE_", type_id = "nc_hi_cosmo_qspline_vparams_get_type ()")]
	public enum HICosmoQSplineVParams {
		Q
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HIPERT_ADIAB_", type_id = "nc_hi_pert_adiab_vars_get_type ()")]
	public enum HIPertAdiabVars {
		RE_ZETA,
		IM_ZETA,
		RE_PZETA,
		IM_PZETA
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HIPERT_BOLTZMANN_", type_id = "nc_hi_pert_boltzmann_vars_get_type ()")]
	public enum HIPertBoltzmannVars {
		B0,
		THETA0,
		C0,
		PHI,
		B1,
		THETA1,
		C1,
		THETA2,
		THETA_P0,
		THETA_P1,
		THETA_P2
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HIPERT_TWO_FLUIDS_", type_id = "nc_hi_pert_two_fluids_vars_get_type ()")]
	public enum HIPertTwoFluidsVars {
		RE_ZETA,
		IM_ZETA,
		RE_PZETA,
		IM_PZETA,
		RE_Q,
		IM_Q,
		RE_PQ,
		IM_PQ
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HIPERT_WKB_CMP_", type_id = "nc_hi_pert_wkb_cmp_get_type ()")]
	public enum HIPertWKBCmp {
		POTENTIAL,
		ALPHA2
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_HIPERT_WKB_", type_id = "nc_hi_pert_wkb_vars_get_type ()")]
	public enum HIPertWKBVars {
		RE_Q,
		IM_Q,
		RE_P,
		IM_P
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_LINEAR_PERTURBATIONS_SPLINE_", type_id = "nc_linear_pert_spline_types_get_type ()")]
	[Flags]
	public enum LinearPertSplineTypes {
		SOURCES,
		PHI,
		THETA0,
		C0,
		B0,
		THETA1,
		C1,
		B1,
		THETA2
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_PERT_", type_id = "nc_linear_pert_vars_get_type ()")]
	public enum LinearPertVars {
		B0,
		THETA0,
		C0,
		PHI,
		B1,
		THETA1,
		C1,
		THETA2,
		THETA_P0,
		THETA_P1,
		THETA_P2
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_MASS_FUNCTION_SPLINE_", type_id = "nc_mass_function_spline_optimize_get_type ()")]
	public enum MassFunctionSplineOptimize {
		NONE,
		LNM,
		Z
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_MATTER_VAR_", type_id = "nc_matter_var_strategy_get_type ()")]
	public enum MatterVarStrategy {
		NUMINT,
		SPLINEINT,
		FFT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_SNIA_DIST_COV_", type_id = "nc_snia_dist_cov_sparams_get_type ()")]
	public enum SNIADistCovSParams {
		ALPHA,
		BETA,
		M1,
		M2,
		LNSIGMA_PECZ,
		LNSIGMA_LENS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_SNIA_DIST_COV_", type_id = "nc_snia_dist_cov_vparams_get_type ()")]
	public enum SNIADistCovVParams {
		LNSIGMA_INT,
		MU
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cprefix = "NC_TIME_", type_id = "nc_scale_factor_time_type_get_type ()")]
	public enum ScaleFactorTimeType {
		COSMIC,
		CONFORMAL
	}
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double ClusterAbundanceIntPd2N (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnM, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double ClusterAbundanceN (Nc.ClusterAbundance cad, Nc.HICosmo model);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double DistanceFunc0 (Nc.Distance dist, Nc.HICosmo cosmo);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double DistanceFunc1 (Nc.Distance dist, Nc.HICosmo cosmo, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HICosmoFunc0 (Nc.HICosmo cosmo);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HICosmoFunc1 (Nc.HICosmo cosmo, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate void HIPertBoltzmannConf (Nc.HIPertBoltzmann pb);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate void HIPertBoltzmannCreate (Nc.HIPertBoltzmann pb, Nc.HICosmo cosmo);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate void HIPertBoltzmannEvol (Nc.HIPertBoltzmann pb, double g);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertBoltzmannGet (Nc.HIPertBoltzmann pb);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertBoltzmannGetN (Nc.HIPertBoltzmann pb, uint n);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate void HIPertBoltzmannSources (Nc.HIPertBoltzmann pb, double S0, double S1, double S2);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate bool HIPertBoltzmannTest (Nc.HIPertBoltzmann pb);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertIAdiabFuncDlnmzeta (Nc.HIPertIAdiab iadiab, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertIAdiabFuncDmzetanuAnuA (Nc.HIPertIAdiab iadiab, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate Nc.HIPertIAdiabEOM HIPertIAdiabFuncEOM (Nc.HIPertIAdiab iadiab, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertIAdiabFuncNuA2 (Nc.HIPertIAdiab iadiab, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertITwoFluidsFuncDlnmS (Nc.HIPertITwoFluids itf, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertITwoFluidsFuncDlnmzeta (Nc.HIPertITwoFluids itf, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertITwoFluidsFuncDmSnuBnuB (Nc.HIPertITwoFluids itf, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertITwoFluidsFuncDmzetanuAnuA (Nc.HIPertITwoFluids itf, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate Nc.HIPertITwoFluidsEOM HIPertITwoFluidsFuncEOM (Nc.HIPertITwoFluids itf, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertITwoFluidsFuncNuA2 (Nc.HIPertITwoFluids itf, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertITwoFluidsFuncNuB2 (Nc.HIPertITwoFluids itf, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertITwoFluidsFuncVA (Nc.HIPertITwoFluids itf, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertITwoFluidsFuncVB (Nc.HIPertITwoFluids itf, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate void HIPertWKBEom (GLib.Object obj, double alpha, double k, double nu2, double m, double dlnm);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double HIPertWKBFunc (GLib.Object obj, double alpha, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate void LinearPertConf (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate bool LinearPertEvol (Nc.LinearPert pert, double g);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double LinearPertGet (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate double LinearPertGetN (Nc.LinearPert pert, uint n);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate void LinearPertSources (Nc.LinearPert pert, double S0, double S1, double S2);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", has_target = false)]
	public delegate bool LinearPertTest (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_A_SZ")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_A_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_B_SZ")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_B_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_C_SZ")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_C_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_D_SZ")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_D_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_DEFAULT_PARAMS_ABSTOL")]
	public const double CLUSTER_MASS_BENSON_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_M_LOWER_BOUND")]
	public const double CLUSTER_MASS_BENSON_M_LOWER_BOUND;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XI_ZETA_DIST_CUT")]
	public const double CLUSTER_MASS_BENSON_XI_ZETA_DIST_CUT;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_A_X")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_A_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_B_X")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_B_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_C_X")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_C_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_D_X")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_D_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_BENSON_XRAY_DEFAULT_PARAMS_ABSTOL")]
	public const double CLUSTER_MASS_BENSON_XRAY_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_IMPL_ALL")]
	public const int CLUSTER_MASS_IMPL_ALL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_LNNORMAL_DEFAULT_BIAS")]
	public const double CLUSTER_MASS_LNNORMAL_DEFAULT_BIAS;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_LNNORMAL_DEFAULT_PARAMS_ABSTOL")]
	public const double CLUSTER_MASS_LNNORMAL_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_LNNORMAL_DEFAULT_SIGMA")]
	public const double CLUSTER_MASS_LNNORMAL_DEFAULT_SIGMA;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_PLCL_DEFAULT_A_L")]
	public const double CLUSTER_MASS_PLCL_DEFAULT_A_L;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_PLCL_DEFAULT_A_SZ")]
	public const double CLUSTER_MASS_PLCL_DEFAULT_A_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_PLCL_DEFAULT_B_L")]
	public const double CLUSTER_MASS_PLCL_DEFAULT_B_L;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_PLCL_DEFAULT_B_SZ")]
	public const double CLUSTER_MASS_PLCL_DEFAULT_B_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_PLCL_DEFAULT_COR")]
	public const double CLUSTER_MASS_PLCL_DEFAULT_COR;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_PLCL_DEFAULT_MCUT")]
	public const double CLUSTER_MASS_PLCL_DEFAULT_MCUT;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_PLCL_DEFAULT_PARAMS_ABSTOL")]
	public const double CLUSTER_MASS_PLCL_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_PLCL_DEFAULT_SD_L")]
	public const double CLUSTER_MASS_PLCL_DEFAULT_SD_L;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_PLCL_DEFAULT_SD_SZ")]
	public const double CLUSTER_MASS_PLCL_DEFAULT_SD_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_A_SZ")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_A_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_B_SZ")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_B_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_C_SZ")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_C_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_D_SZ")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_D_SZ;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_MASS_VANDERLINDE_DEFAULT_PARAMS_ABSTOL")]
	public const double CLUSTER_MASS_VANDERLINDE_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_PHOTOZ_GAUSS_BIAS")]
	public const int CLUSTER_PHOTOZ_GAUSS_BIAS;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_PHOTOZ_GAUSS_SIGMA")]
	public const int CLUSTER_PHOTOZ_GAUSS_SIGMA;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_REDSHIFT_IMPL_ALL")]
	public const int CLUSTER_REDSHIFT_IMPL_ALL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_REDSHIFT_PHOTOZ_GAUSS_GLOBAL_DEFAULT_BIAS")]
	public const double CLUSTER_REDSHIFT_PHOTOZ_GAUSS_GLOBAL_DEFAULT_BIAS;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_REDSHIFT_PHOTOZ_GAUSS_GLOBAL_DEFAULT_PARAMS_ABSTOL")]
	public const double CLUSTER_REDSHIFT_PHOTOZ_GAUSS_GLOBAL_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_CLUSTER_REDSHIFT_PHOTOZ_GAUSS_GLOBAL_DEFAULT_SIGMA0")]
	public const double CLUSTER_REDSHIFT_PHOTOZ_GAUSS_GLOBAL_DEFAULT_SIGMA0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_BAO_RDV_LEN")]
	public const int DATA_BAO_RDV_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_CAT_DESC")]
	public const string DATA_SNIA_COV_CAT_DESC;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_CAT_DESC_COMMENT")]
	public const string DATA_SNIA_COV_CAT_DESC_COMMENT;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_CAT_HAS_COMPLETE_COV")]
	public const string DATA_SNIA_COV_CAT_HAS_COMPLETE_COV;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_CAT_HAS_COMPLETE_COV_COMMENT")]
	public const string DATA_SNIA_COV_CAT_HAS_COMPLETE_COV_COMMENT;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_CAT_LAST_VERSION")]
	public const int DATA_SNIA_COV_CAT_LAST_VERSION;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_CAT_VERSION")]
	public const string DATA_SNIA_COV_CAT_VERSION;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_CAT_VERSION_COMMENT")]
	public const string DATA_SNIA_COV_CAT_VERSION_COMMENT;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_COLOUR_KEY")]
	public const string DATA_SNIA_COV_COLOUR_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_DATA_DESC")]
	public const string DATA_SNIA_COV_DATA_DESC;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_DATA_GROUP")]
	public const string DATA_SNIA_COV_DATA_GROUP;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_DATA_HAS_COMPLETE_COV_KEY")]
	public const string DATA_SNIA_COV_DATA_HAS_COMPLETE_COV_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_DATA_KEY")]
	public const string DATA_SNIA_COV_DATA_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_DATA_LEN_KEY")]
	public const string DATA_SNIA_COV_DATA_LEN_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_INIT_ALL")]
	public const int DATA_SNIA_COV_INIT_ALL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_LEN")]
	public const int DATA_SNIA_COV_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_MAG_COLOUR_KEY")]
	public const string DATA_SNIA_COV_MAG_COLOUR_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_MAG_KEY")]
	public const string DATA_SNIA_COV_MAG_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_MAG_WIDTH_KEY")]
	public const string DATA_SNIA_COV_MAG_WIDTH_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_SYMM_TOL")]
	public const double DATA_SNIA_COV_SYMM_TOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_WIDTH_COLOUR_KEY")]
	public const string DATA_SNIA_COV_WIDTH_COLOUR_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_COV_WIDTH_KEY")]
	public const string DATA_SNIA_COV_WIDTH_KEY;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_DATA_SNIA_SIMPLE_LEN")]
	public const int DATA_SNIA_SIMPLE_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DEFAULT_PARAMS_ABSTOL")]
	public const double HICOSMO_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DEFAULT_PARAMS_RELTOL")]
	public const double HICOSMO_DEFAULT_PARAMS_RELTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_OMEGA_B")]
	public const double HICOSMO_DE_DEFAULT_OMEGA_B;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_OMEGA_C")]
	public const double HICOSMO_DE_DEFAULT_OMEGA_C;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_OMEGA_X")]
	public const double HICOSMO_DE_DEFAULT_OMEGA_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_SIGMA8")]
	public const double HICOSMO_DE_DEFAULT_SIGMA8;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_SPECINDEX")]
	public const double HICOSMO_DE_DEFAULT_SPECINDEX;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_DEFAULT_T_GAMMA0")]
	public const double HICOSMO_DE_DEFAULT_T_GAMMA0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_LINDER_DEFAULT_W0")]
	public const double HICOSMO_DE_LINDER_DEFAULT_W0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_LINDER_DEFAULT_W1")]
	public const double HICOSMO_DE_LINDER_DEFAULT_W1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_LINDER_N")]
	public const int HICOSMO_DE_LINDER_N;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_PAD_DEFAULT_W0")]
	public const double HICOSMO_DE_PAD_DEFAULT_W0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_PAD_DEFAULT_W1")]
	public const double HICOSMO_DE_PAD_DEFAULT_W1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_QE_DEFAULT_W0")]
	public const double HICOSMO_DE_QE_DEFAULT_W0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_QE_DEFAULT_W1")]
	public const double HICOSMO_DE_QE_DEFAULT_W1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_QE_N")]
	public const int HICOSMO_DE_QE_N;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_XCDM_DEFAULT_W0")]
	public const double HICOSMO_DE_XCDM_DEFAULT_W0;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_DE_XCDM_N")]
	public const int HICOSMO_DE_XCDM_N;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_H")]
	public const int HICOSMO_IMPL_H;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_Omega_bh2")]
	public const int HICOSMO_IMPL_Omega_bh2;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_Omega_ch2")]
	public const int HICOSMO_IMPL_Omega_ch2;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_Omega_m")]
	public const int HICOSMO_IMPL_Omega_m;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_Omega_mh2")]
	public const int HICOSMO_IMPL_Omega_mh2;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_Omega_rh2")]
	public const int HICOSMO_IMPL_Omega_rh2;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_dH_dz")]
	public const int HICOSMO_IMPL_dH_dz;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_dec")]
	public const int HICOSMO_IMPL_dec;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_j")]
	public const int HICOSMO_IMPL_j;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_q")]
	public const int HICOSMO_IMPL_q;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_IMPL_wec")]
	public const int HICOSMO_IMPL_wec;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_CD")]
	public const double HICOSMO_QCONST_DEFAULT_CD;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_E")]
	public const double HICOSMO_QCONST_DEFAULT_E;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_OMEGA_T")]
	public const double HICOSMO_QCONST_DEFAULT_OMEGA_T;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_Q")]
	public const double HICOSMO_QCONST_DEFAULT_Q;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QCONST_DEFAULT_Z1")]
	public const double HICOSMO_QCONST_DEFAULT_Z1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QGRW_DEFAULT_OMEGA_R")]
	public const double HICOSMO_QGRW_DEFAULT_OMEGA_R;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QGRW_DEFAULT_OMEGA_W")]
	public const int HICOSMO_QGRW_DEFAULT_OMEGA_W;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QGRW_DEFAULT_W")]
	public const double HICOSMO_QGRW_DEFAULT_W;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QGRW_DEFAULT_X_B")]
	public const double HICOSMO_QGRW_DEFAULT_X_B;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_CD")]
	public const double HICOSMO_QLINEAR_DEFAULT_CD;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_E")]
	public const double HICOSMO_QLINEAR_DEFAULT_E;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_OMEGA_T")]
	public const double HICOSMO_QLINEAR_DEFAULT_OMEGA_T;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_Q")]
	public const double HICOSMO_QLINEAR_DEFAULT_Q;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_QP")]
	public const double HICOSMO_QLINEAR_DEFAULT_QP;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QLINEAR_DEFAULT_Z1")]
	public const double HICOSMO_QLINEAR_DEFAULT_Z1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QSPLINE_CONT_PRIOR_ABSTOL")]
	public const int HICOSMO_QSPLINE_CONT_PRIOR_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QSPLINE_CONT_PRIOR_LNSIGMA")]
	public const int HICOSMO_QSPLINE_CONT_PRIOR_LNSIGMA;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QSPLINE_DEFAULT_AS_DRAG")]
	public const double HICOSMO_QSPLINE_DEFAULT_AS_DRAG;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QSPLINE_DEFAULT_OMEGA_T")]
	public const double HICOSMO_QSPLINE_DEFAULT_OMEGA_T;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QSPLINE_DEFAULT_Q")]
	public const double HICOSMO_QSPLINE_DEFAULT_Q;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HICOSMO_QSPLINE_DEFAULT_Q_LEN")]
	public const int HICOSMO_QSPLINE_DEFAULT_Q_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_HIPERT_BOLTZMANN_BASE_SIZE")]
	public const int HIPERT_BOLTZMANN_BASE_SIZE;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_LINEAR_PERTURBATIONS_SPLINE_ALL")]
	public const int LINEAR_PERTURBATIONS_SPLINE_ALL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_PERTURBATION_BASE_SIZE")]
	public const int PERTURBATION_BASE_SIZE;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_PERTURBATION_START_X")]
	public const double PERTURBATION_START_X;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_ALPHA")]
	public const double SNIA_DIST_COV_DEFAULT_ALPHA;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_BETA")]
	public const double SNIA_DIST_COV_DEFAULT_BETA;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_M1")]
	public const double SNIA_DIST_COV_DEFAULT_M1;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_M2")]
	public const double SNIA_DIST_COV_DEFAULT_M2;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_MU")]
	public const double SNIA_DIST_COV_DEFAULT_MU;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_DEFAULT_PARAMS_ABSTOL")]
	public const double SNIA_DIST_COV_DEFAULT_PARAMS_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_LNSIGMA_INT_DEFAULT_LEN")]
	public const int SNIA_DIST_COV_LNSIGMA_INT_DEFAULT_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_SNIA_DIST_COV_MU_DEFAULT_LEN")]
	public const int SNIA_DIST_COV_MU_DEFAULT_LEN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_WINDOW_VOLUME_GAUSSIAN")]
	public const int WINDOW_VOLUME_GAUSSIAN;
	[CCode (cheader_filename = "numcosmo/numcosmo.h", cname = "NC_WINDOW_VOLUME_TOPHAT")]
	public const int WINDOW_VOLUME_TOPHAT;
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void bias_mean_prepare (Nc.ClusterAbundance cad, Nc.HICosmo model);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double bias_mean_val (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnMl, double lnMu, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnM, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias_Mobs_denominator (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnMobs, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias_Mobs_numerator (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnMobs, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias_denominator (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnM, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double ca_mean_bias_numerator (Nc.ClusterAbundance cad, Nc.HICosmo model, double lnM, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static Ncm.Data data_bao_create (Nc.Distance dist, Nc.DataBaoId id);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static Ncm.Data data_cmb_create (Nc.Distance dist, Nc.DataCMBId id);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static string data_snia_get_catalog (string id);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static string data_snia_get_catalog_by_id (Nc.DataSNIAId id);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static string data_snia_get_fits (string filename, bool check_size);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void data_snia_load_cat (Nc.DataSNIACov snia_cov, Nc.DataSNIAId id);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_cov_direct (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_clear (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_free (Nc.LinearPert pert);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double pert_linear_los_integrate (Nc.LinearPertSplines pspline, long l, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_prepare_splines (Nc.LinearPertSplines pspline);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static bool pert_linear_spline_set_source_at (Nc.LinearPertSplines pspline, double k);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_splines_clear (Nc.LinearPertSplines pspline);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_linear_splines_free (Nc.LinearPertSplines pspline);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static double pert_transfer_function_get (Nc.LinearPertTF perttf, double kh);
	[CCode (cheader_filename = "numcosmo/numcosmo.h")]
	public static void pert_transfer_function_prepare (Nc.LinearPertTF perttf);
}
