<script language=javascript>

/****************************************************************************/
/* PHP-NUKE: Webpages 1.2                                                   */
/* ======================                                                   */
/*                                                                          */
/* Copyright (c) 2002,2003 by Wm. Wong                                      */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify     */
/* it under the terms of the GNU General Public License as published by     */
/* the Free Software Foundation; either version 2 of the License, or        */
/* (at your option) any later version.                                      */
/*                                                                          */ 
/* This program is distributed in the hope that it will be useful,          */ 
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */ 
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */ 
/* GNU General Public License for more details.                             */ 
/*                                                                          */ 
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/****************************************************************************/

function storeCaret (field) {
  if (field.createTextRange) 
    field.caretPos = document.selection.createRange().duplicate();
}

function defaultText(){
  var field=document.webform.webpage;
  if (field.createTextRange && field.caretPos && (field.caretPos.text!='')) {
    return field.caretPos.text;
  }
  return 'Text';
}

function promptDefault(prompt1){
  var field=document.webform.webpage;
  if (field.createTextRange && field.caretPos && (field.caretPos.text!='')) {
    return field.caretPos.text;
  }
  return prompt(prompt1,'Text');
}

function addtext(field,txt) {
  if (field.createTextRange && field.caretPos) {
    var caretPos=field.caretPos;
    caretPos.text=caretPos.text.charAt(caretPos.text.length - 1)==' '?(txt + ' '):txt;
  } else
    field.value+=txt;

  field.focus();
  storeCaret(field);
  if (document.webform.format.selectedIndex==0) {
    document.webform.format.selectedIndex=1;// change plaintext to html
  }
}

function inserttext(field,txt) {
  var field=document.webform.webpage;
  if (field.createTextRange && field.caretPos && (field.caretPos.text!='')) {
    txt=field.caretPos.text+txt;
  }
  addtext(field,txt);
}

function addcolor(field,fg) {
  var txt1=promptDefault('Colored text');
  addtext(field,'<font color='+fg+'>'+txt1+'</font>');
}

function bracket(field,tag,data) {
  addtext(field,'<'+tag+'>'+data+'</'+tag+'>');
}

function bracket2(field,tag,prefix,data1,data2) {
  addtext(field,'<'+tag+' '+prefix+'="'+data1+'">'+data2+'</'+tag+'>');
}

function promptBracket(field,tag,prompt1) {
  var txt1=promptDefault(prompt1);
  if (txt1)
    bracket(field,tag,txt1);
}

function promptBracketnl(field,tag,prompt) {
  promptBracket(field,tag,prompt);
  addtext(field,'\r\n');
}

function promptBracket2(field,tag,prefix,default1,prompt1,prompt2) {
  var txt1=prompt(prompt1,default1);
  if (txt1) {
    var txt2=promptDefault(prompt2);
    if (txt2) 
      bracket2(field,tag,prefix,txt1,txt2);
  }
}

function bold(field) {
  promptBracket(field,'b','Bold text');
}

function underline(field) {
  promptBracket(field,'u','Underline text');
}

function italic(field) {
  promptBracket(field,'i','Italic text');
}

function addpre(field) {
  addtext(field,'\r\n<pre>\r\nThis text will not be reformatted.\r\n</pre>\r\n');
}

function addh1(field) {
  promptBracketnl(field,'h1','Header text');
}

function addh2(field) {
  promptBracketnl(field,'h2','Header 2 text');
}


function httplink(field) {
  promptBracket2(field,'a','href','http://','URL for link','URL description');
}

function httpslink(field) {
  promptBracket2(field,'a','href','https://','URL for link','URL description');
}

function ftplink(field) {
  promptBracket2(field,'a','href','ftp://','URL for link','URL description');
}

function maillink(field) {
  promptBracket2(field,'a','href','mailto:','Email address for link','URL description');
}

function insertlist(field,tag) {
  addtext(field,'\r\n<'+tag+'>\r\n<li>text1\r\n<li>text2\r\n</'+tag+'>\r\n');
}

function addhr(field) {
  inserttext(field,'\r\n<hr>\r\n');
}

function addp(field) {
  inserttext(field,'<p>');
}

function addbr(field) {
  inserttext(field,'<br>');
}

function addnbsp(field) {
  inserttext(field,'&nbsp;');
}

function orderedl(field) {
  insertlist(field,'ol');
}

function bulletl(field) {
  insertlist(field,'ul');
}

function listentry(field) {
  promptBracketnl(field,'li','List item');
}

function addimage(field) {
  var img=prompt('Image URL','http://');
  if (img)
    inserttext(field,'<img src="'+img+'" alt="'+prompt('Image description','image')+'">');
}


</script>
