<?php
/***************************************************************************
 *                            synch-ldap-posix.php
 *                            -------------------
 *   begin                : December 10, 2004
 *   copyright            : (C) 2004 William Wong
 *   email                : bwong at voicenet.com
 *
 *   $Id: synch-ldap-posix.php,v 2.00 2004/12/10 $
 *
 ***************************************************************************/
/*                                                                      */
/*                                                                      */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to the Free Software          */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA */
/*                                                                         */
/***************************************************************************/

if (eregi("synch-ldap-posix.php",$_SERVER['PHP_SELF'])) {
    Header("Location: ../index.php");
    die();
}

// global parameters
synchSet('posixEnabled',true);
synchSet('defaultloginshell',"/bin/sh");		// use /bin/bash for bash shell or /dev/null to prevent regular login
synchSet('group',"users");				// all new users added to this group



// add and mod entries are processed after PHPNuke database has been updated
// These definitions are used when creating a new account
// The appropriate group of attributes or scripts is used if the $ldapconfig['var'][group] is non-zero.
$ldapconfig['add']['callFirst'][]			="synchAddPosix";
$ldapconfig['add']['callLast'][]			="synchAddPosixGroup";

function synchAddPosix(){
	global $ldapconfig;
	if (!synchGet('posixEnabled'))
		return;

	$ldapconfig['add']['ldif']['objectclass'][]	="posixaccount";
	$ldapconfig['add']['ldif']['objectclass'][]	="shadowaccount";
	$ldapconfig['add']['ldif']['gecos']		="{myName}";
	$ldapconfig['add']['ldif']['description']	="{nuke_user_occ}  - {group}";
	$ldapconfig['add']['ldif']['loginshell']	="{loginshell}";
	$ldapconfig['add']['ldif']['homedirectory']	="/home/{group}/{myName}";
	$ldapconfig['add']['ldif']['sn']		="{myName}";
	$ldapconfig['add']['ldif']['uidnumber']		="{uidnumber}";
	$ldapconfig['add']['ldif']['gidnumber']		="{gidnumber}";

	synchAddScript	( 'add', '{scriptPath}posixadd.sh {myName} {uidnumber} {gidnumber} "/home/{group}/{myName}"'
		, "Adding posix user {myName}" ) ;

 	// setup variables before ldap operations occur
 	// sets: uidnumber, guinumber, group

	synchLdapOpen();
	$list=synchLdapList("objectclass=posixaccount", array("uidnumber"));

        foreach ($list as $entry){
		$uids[]=$entry["uidnumber"][0];
	}

	// grab first unused uid
	sort($uids);
	$uidnumber=1000;
	foreach ($uids as $uid) {
		if ($uid==$uidnumber)
			++$uidnumber;
		elseif ($uid>$uidnumber)
                	break;
	}

	// try to load a particular group
	$result = synchLdapSearch(synchGet('groupBase'),synchTranslate("cn={group}"),array("gidnumber"));
	if($result==false){
		$gidnumber=1000;	// default group
	} else {
		$gidnumber=$result[0]["gidnumber"][0];
	}

	// store parameters for user
	synchSet('uidnumber',$uidnumber);
	synchSet('gidnumber',$gidnumber);
}


function synchAddPosixGroup(){
	if(synchGet('ldifResult')==1){
		// add to group memberUid list
		$atts['memberUid'][]=synchTranslate('{myName}');
		synchLdapOpen();
		synchLdapInsert(synchTranslate("cn={group},{groupBase}"),$atts);
		synchLdapClose();
	}
}


// Use these fields when making modifications to the ldap database
// No password synch needed as nuke user support handles this

// Use these when deleting something from the ldap database
// scripts for each matching objectclass will be run after the user is deleted
synchAddScript	( 'del'
		, "{scriptPath}posixdel.sh {myName} {ldap_homedirectory}"
		, 'Deleting {ldap_homedirecory}' ) ;



// These definitions used after authentication to load/save information
// uid/username and password should not be included in this list
$ldapconfig['login']['sql']['description']		="{ldap_gecos}";

$ldapconfig['logout']['ldif']['gecos']			="{nuke_description'}";

$ldapconfig['save']['ldif']['gecos']			="{nuke_description'}";


// field definitions for edit form and substitutions
$ldapconfig['addAdminTop']['show'][]			='synchPosixShowAdd';
$ldapconfig['addAdminBottom']['show'][]			='synchPosixShowFields';

$ldapconfig['addAdmin']['get'][]			='synchPosixGet';

$ldapconfig['editAdminTop']['show'][]			='synchPosixShowEdit';
$ldapconfig['editAdminBottom']['show'][]		='synchPosixShowFields';

$ldapconfig['editUserTop']['show'][]			='synchPosixShowEditUser';

$ldapconfig['editAdmin']['get'][]			='synchPosixGet';

$ldapconfig['load'][]					='synchPosixLoad';

function synchPosixLoad(){
	synchSet('posixEnabled',synchInArray(synchGet('ldap_objectclass'),'posixAccount'));
}

function synchPosixShowAdd(){
	synchPosixShow(true);
}

function synchPosixShowEdit(){
	synchPosixShow(false);
}

function synchPosixShowEditUser(){
	synchPosixShow(false, true);
}

function synchPosixShow($enabled,$user=false){
	global $bgcolor2,$bgcolor3;
	if($user){	// user has color
		$bg1=" bgcolor='$bgcolor2'";
		$bg2=" bgcolor='$bgcolor3'";
		$bf="<b>";
		$bl="</b>";
	}else{		// admin does not
		$bg1="";
		$bg2="";
		$bf="";
		$bl="";
	}

	echo "<tr><td$bg1>{$bf}Linux User$bl</td><td$bg2><INPUT TYPE=CHECKBOX NAME=synchPosix "
	    . (synchGet('posixEnabled')==1 ? "checked " : "")
	    . ($enabled ? "" : "disabled ")
	    . "</INPUT></td></tr>";
}

function synchPosixShowFields(){
	echo  "<tr><td><b>Linux Info</b></td><td></td></tr>"
	    . "<tr><td>Login Shell</td><td><INPUT TYPE=TEXT SIZE=60 NAME=synchPosixShell VALUE='"
	    . synchGetTranslated('defaultloginshell')
	    . "'</INPUT></td></tr>";
}

function synchPosixGet(){
	synchSet('posixEnabled',$GLOBALS['synchPosix']=='on');		// checkbox returns "on" or nothing
	$loginshell=$GLOBALS['synchPosixShell'];
	synchSet('loginshell',($loginshell=="")?synchGet('defaultloginshell'):$loginshell);
}

?>
