/*  This file is part of NI.

    NI is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    NI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with NI; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Copyright (C) 2006 Michael Jumper
 */


#ifndef PARSER_H
#define PARSER_H

#include <map>
using std::map;

#include <string>
using std::string;

#include "altt.h"

#define ID_ALTT     0
#define ID_BITARRAY 1
#define ID_STRING   2

#define ERR_SUCCESS 0
#define ERR_NOVALUE 1
#define ERR_NOVAR   2
#define ERR_UNDEF   3
#define ERR_UNIMP   4
#define ERR_LARGE   5
#define ERR_QUOTE   6

struct general_ptr {
    int id;
    void* ptr;
    int length; // For bitarrays
};

extern altt* one;
extern altt* zero;
extern altt* unknown;

extern map<string, general_ptr> storage;

int parse(general_ptr&, char**);
char* skipws(char*);
inline bool istdigit(char);
int get_value(general_ptr&, char**);
void wrapper(altt_segment* (*)(altt_segment*, altt_segment*), 
        general_ptr&, general_ptr&);
int parse(general_ptr&, char**);
void parseline(general_ptr&, char*);

#endif

