/*  This file is part of NI.

    NI is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    NI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with NI; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Copyright (C) 2006 Michael Jumper
 */


#include <iostream>
using std::cerr;
using std::cout;

#include <map>
using std::map;

#include <string>
using std::string;

#include <cctype>
#include <cstring>
#include <vector>
using std::vector;

#include "altt.h"
#include "parser.h"
#include "flags.h"

altt* one;
altt* zero;
altt* unknown;

#define apply_mask(result) { if (mask != NULL) wrapper(aand_n, result, *mask); }
general_ptr* mask = NULL;
general_ptr MASK_STORAGE;	// Kludge

map<string, general_ptr> storage;

int print(general_ptr&);
    
char* skipws(char* x) {
    for (; *x != 0 && isspace(*x); x++);
    return x;
}

inline bool istdigit(char x) {
    return x == '0' || x == '1' || x == '?';
}

inline int get_value_actual(general_ptr& p, char** s) {
    char* orig = *s;

    if (**s == 0)
	    return ERR_SUCCESS;	// Ignore empty strings
    
    if (**s == '!') {
        (*s)++;
        int res = get_value(p, s);
        if (res != ERR_SUCCESS)
            return res;
        
        wrapper(anot_n, p, p);
    }
    /*
    else if (**s == '{') {
        vector<general_ptr> temp;
        (*s)++;
        *s = skipws(*s);

        while (**s != '}') {
            general_ptr temp_ptr;
            
            int res = get_value(temp_ptr, s);
            if (res != ERR_SUCCESS)
                return res;
            
            *s = skipws(*s);
            
            temp.push_back(temp_ptr);
        }
        (*s)++;

        general_ptr* bitarray = (general_ptr*) 
            malloc(sizeof(general_ptr) * temp.size());
        for (int i=0, n=temp.size()-1; i<temp.size(); i++, n--)
            memcpy(&(bitarray[i]), &(temp[n]), sizeof(general_ptr));

        p.id = ID_BITARRAY;
        p.ptr = bitarray;
        p.length = temp.size();
        
    }
    */
    /*
    else if (**s == '"') {
        char str[4096];
        char* st = str;
        int len = 1;
        
        (*s)++;
        while (**s != '"') {
            if (**s == 0) {
                *s = orig;
                return ERR_QUOTE;
            }
            *st = **s;
            st++; (*s)++;
            len++;
        }
        *st = 0;
        (*s)++; // Skip past final quote.

        p.id = ID_STRING;
        p.ptr = malloc(len);
        memcpy(p.ptr, str, len);

        return ERR_SUCCESS;
        
    }
    */
    else if (**s == '$') {
        char var_name[128];
        char* vn = var_name;
        (*s)++;
        while (isalnum(**s)) {
            *vn = **s;
            vn++; (*s)++;
        }
        *vn = 0;

        if (var_name[0] == 0) {
            *s = orig;
            return ERR_NOVAR;
        }

        map<string, general_ptr>::iterator i = storage.find(var_name);
        
        if (i == storage.end()) {
            *s = orig;
            return ERR_UNDEF;
        }
            
        p.id = i->second.id;
        p.ptr = i->second.ptr;
        p.length = i->second.length;
        
        return ERR_SUCCESS;
        
    }
    else if (**s == 'g' && isdigit(*((*s) + 1))) {
        char num[4096];
        char* n = num;
        (*s)++;
        while (isdigit(**s)) {
            *n = **s;
            n++; (*s)++;
        }
        *n = 0;

        if (num[0] == 0) {
            *s = orig;
            return ERR_NOVALUE;
        }

        p.id = ID_ALTT;
        p.ptr = generate_general_altt(atoi(num));
        //cout << "GENERAL: " << num << '\n';
        
    }
    else if (islower(**s) && !isalnum(*((*s) + 1)) && !istdigit(*((*s) + 1))) {

        p.id = ID_ALTT;
        p.ptr = generate_general_altt((**s) - 'a');
        (*s)++;
        //cout << "GENERAL: " << num << '\n';
        
    }
    else if (**s == '(') {
        (*s)++;
        int res = parse(p, s);
        if (res != ERR_SUCCESS)
            return res;
    }
    else {
        char num[4096];
        char* n = num;
        int num_len = 0;
        
        while (istdigit(**s) || islower(**s)) {
            *n = **s;
            n++; (*s)++;
            num_len++;
        }
        *n = 0;

        if (num[0] == 0) {
            *s = orig;
            return ERR_NOVALUE;
        }

        if (strcmp(num, "0") == 0) {
            p.id = ID_ALTT;
            p.ptr = zero;
            return ERR_SUCCESS;
        }
        else if (strcmp(num, "1") == 0) {
            p.id = ID_ALTT;
            p.ptr = one;
            return ERR_SUCCESS;
        }
        else if (strcmp(num, "?") == 0) {
            p.id = ID_ALTT;
            p.ptr = unknown;
            return ERR_SUCCESS;
        }
       /* 
        general_ptr* bitarray = (general_ptr*)
            malloc(sizeof(general_ptr) * num_len);
        for (int i=0, n=num_len-1; i<num_len; i++, n--) {
            bitarray[i].id = ID_ALTT;
            if (num[n] == '1')
                bitarray[i].ptr = one;
            else if (num[n] == '0')
                bitarray[i].ptr = zero;
            else if (num[n] == '?')
                bitarray[i].ptr = unknown;
            else if (islower(num[n]))
                bitarray[i].ptr = generate_general_altt(num[n] - 'a');
            else {
                *s = orig;
                return ERR_NOVALUE; // Need to define new error here...
            }
        }
        
        //cout << "LITERAL: " << num << '\n';
        //*s = orig;
        //return ERR_UNIMP;
        
        p.id = ID_BITARRAY;
        p.ptr = bitarray;
        p.length = num_len;
        */
	return ERR_NOVALUE;
    }

    return ERR_SUCCESS;
    
}

int get_value(general_ptr& p, char** s) {
	int err = get_value_actual(p, s);
	if (err == ERR_SUCCESS)
		apply_mask(p);	// BUG - Check ptr type.
	return err;
}

void wrapper(altt_segment* (*func)(altt_segment*, altt_segment*), 
        general_ptr& result, general_ptr& parm) {
    if (result.id == ID_ALTT) {
        if (parm.id == ID_ALTT) {
            result.ptr = wrapper(func,
                    (altt*) result.ptr,
                    (altt*) parm.ptr);
        }
        else if (parm.id == ID_BITARRAY) {
            general_ptr* temp = (general_ptr*) malloc(sizeof(general_ptr));
            memcpy(temp, &result, sizeof(general_ptr));
            
            result.id = ID_BITARRAY;
            result.ptr = temp;
            result.length = 1;
            
            wrapper(func, result, parm);
        }
    }
    else if (result.id == ID_BITARRAY) {
        if (parm.id == ID_BITARRAY) {
            // If result space is smaller than parm space, resize result,
            // filling as necessary.
            if (result.length < parm.length) {
                general_ptr* new_res = (general_ptr*)
                    malloc(sizeof(general_ptr) * parm.length);
                memcpy(new_res, result.ptr, result.length *
                        sizeof(general_ptr));
                
                general_ptr& fill =
                    ((general_ptr*) result.ptr)[result.length-1];

                for (int i=result.length; i<parm.length; i++) {
                    new_res[i].id = fill.id;
                    new_res[i].ptr = fill.ptr;
                    new_res[i].length = fill.length;
                }

                result.ptr = new_res;
                result.length = parm.length;
                
            }

            // Appy func to result and parm, result is still result.
            for (int i=0; i<result.length; i++) {
                general_ptr* parm_ptr;
                if (i < parm.length)
                    parm_ptr = &(((general_ptr*) parm.ptr)[i]);
                else
                    parm_ptr = &(((general_ptr*) parm.ptr)[parm.length-1]);

                wrapper(func,
                        (((general_ptr*) result.ptr)[i]),
                        *parm_ptr
                        );
            }

            // Done.
            
        }
        else if (parm.id == ID_ALTT) {
            // Appy func to result and parm, result is still result.
            for (int i=0; i<result.length; i++) {
                wrapper(func,
                        (((general_ptr*) result.ptr)[i]),
                        parm
                        );
            }
        }
        
    }
    
}

int print(general_ptr& result) {
    if (result.id == ID_ALTT) {
        cout << *((altt*) result.ptr) << '\n';
        return ERR_SUCCESS;
    }
    else if (result.id == ID_STRING) {
        cout << (char*) result.ptr << '\n';
        return ERR_SUCCESS;
    }
    else if (result.id == ID_BITARRAY) {
        cout << "{\n";
        for (int i=result.length-1; i>=0; i--) {
            int res = print(((general_ptr*) result.ptr)[i]);
            if (res != ERR_SUCCESS)
                return res;
        }
        cout << "}\n";

        return ERR_SUCCESS;
    }
    else
        return ERR_UNIMP;
}

int parse(general_ptr& result, char** cur) {
   
    // Parse tokens from that line
    while (**cur != 0) {
        *cur = skipws(*cur);

	if (verbosity >= 3)
		cerr << strlen(*cur) << " chars remaining in expression.\n";
       	
        if ((*cur)[0] == '#') {
            return ERR_SUCCESS;
        }
        
        if ((*cur)[0] == ')') {
            (*cur)++;
            break;
        }

        if ((*cur)[0] == '@') {
            (*cur)++;
            if (result.id != ID_BITARRAY)
                return ERR_UNIMP;
            
            char num[4096];
            char* n = num;
            
            while (isdigit(**cur)) {
                *n = **cur;
                n++; (*cur)++;
            }
            *n = 0;
            
            if (num[0] == 0)
                return ERR_NOVALUE;   // Need ERR_CONSTANT or ERR_INTEGER
            
            int i = atoi(num);
            if (i >= result.length) i = result.length-1;
            
            result = ((general_ptr*) result.ptr)[i];
            
        }
        
        else if (strncmp(*cur, "!&", 2) == 0) {
            // Handle !&
            (*cur) += 2;
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            wrapper(nand, result, parm);
	    apply_mask(result);
        }
        else if (strncmp(*cur, "!=", 2) == 0) {
            // Handle !=
            (*cur)+=2;
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            wrapper(axor, result, parm);
	    apply_mask(result);
        }
	/*
        else if (strncmp(*cur, "inverse", 7) == 0) {
            (*cur) += 7;
            wrapper(anot_n, result, result);
	    apply_mask(result);
        }
	*/
	/*
        else if (strncmp(*cur, "abs", 3) == 0) {
            // Handle abs
            // Changes fuzzy values to ABSOLUTE
            // If value is 1:n, return 1:0, else return 0:0
            (*cur) +=3;
            if (result.id == ID_ALTT) {
                if (((altt*) result.ptr)->b == NULL &&
                        ((altt*) result.ptr)->a->type == ST_BIT1)
                    result.ptr = one;
                else
                    result.ptr = zero;
            }
            else
                return ERR_UNIMP;
            
        }*/
	else if (strncmp(*cur, "verify", 6) == 0) {
		(*cur) += 6;
		
		*cur = skipws(*cur);
		general_ptr parm;
		int res = get_value(parm, cur);
		if (res != ERR_SUCCESS)
			return res;
		
		if (parm.id == ID_ALTT) {
			bool verified = false;
			altt* p = (altt*) parm.ptr;
			if (mask == NULL)
				verified = (p->b == NULL && p->a->type == ST_BIT1);
			else {
				if (mask->id != ID_ALTT)
					return ERR_UNIMP;
				verified = (p == (altt*) mask->ptr);
			}

			if (verified)
				cout << "True.\n";
			else
				cout << "False.\n";
		}
		else
			return ERR_UNIMP;
	}
        else if (strncmp(*cur, "implies", 7) == 0) {
            // Handle implies
            (*cur) += 7;
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            wrapper(anot_n, result, result);
	    apply_mask(result);
            wrapper(aor_n, result, parm);
	    apply_mask(result);
        }
        else if (strncmp(*cur, "iff", 3) == 0) {
            // Handle iff
            (*cur) += 3;
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            wrapper(axor, result, parm);
	    apply_mask(result);
            wrapper(anot_n, result, result);
	    apply_mask(result);
        }
        else if (strncmp(*cur, "iff2", 3) == 0) {
            // Handle iff2 (iff implemented through nand)
            (*cur) += 4;
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            wrapper(axor_n, result, parm);
	    apply_mask(result);
            wrapper(anot_n, result, result);
	    apply_mask(result);
        }
        else if (strncmp(*cur, "^^", 2) == 0) {
            // Handle ^^
            (*cur) += 2;
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            wrapper(axor_n, result, parm);
	    apply_mask(result);
        }
        else if ((*cur)[0] == '^') {
            // Handle ^
            (*cur)++;
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            wrapper(axor, result, parm);
	    apply_mask(result);
        }
        else if ((*cur)[0] == '&') {
            // Handle &
            (*cur)++;
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            wrapper(aand_n, result, parm);
	    apply_mask(result);
        }
        else if ((*cur)[0] == '|') {
            // Handle |
            (*cur)++;
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            wrapper(aor_n, result, parm);
	    apply_mask(result);
        }
        else if (strncmp(*cur, "undef", 5) == 0) {
            *cur += 5;
            *cur = skipws(*cur);
            if (**cur == '$') {
                char var_name[128];
                char* vn = var_name;
                (*cur)++;
                while (isalnum(**cur)) {
                    *vn = **cur;
                    vn++; (*cur)++;
                }
                *vn = 0;

                if (var_name[0] == 0) {
                    return ERR_NOVAR;
                }

                storage.erase(var_name);
		if (strcmp(var_name, "MASK") == 0) mask = NULL;
		
            }
            else
                return ERR_NOVAR;
	 }
         else if (strncmp(*cur, "assume", 6) == 0) {
            *cur += 6;

	    general_ptr parm;
	    
	    *cur = skipws(*cur);
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

	    memcpy(&MASK_STORAGE, &parm, sizeof(general_ptr));
	    storage["MASK"] = MASK_STORAGE;

	    mask = &MASK_STORAGE;
	    
	    // Check for zero mask
	    if (mask->id == ID_ALTT) {
		    altt* a = (altt*) mask->ptr;
		    if (a->b == NULL && a->a->type == ST_BIT0)
			    cerr << "WARNING: Assuming a CONTRADICTION to be TRUE. All future calculations will return 0.\n";
	    }

	 }
	 else if (strncmp(*cur, "reset", 5) == 0) {
            *cur += 5;
	    mask = NULL;
            storage.erase("MASK");	// Undefine MASK
	 }
         else if (strncmp(*cur, "=>", 2) == 0) {
            *cur += 2;
            *cur = skipws(*cur);
            if (**cur == '$') {
                char var_name[128];
                char* vn = var_name;
                (*cur)++;
                while (isalnum(**cur)) {
                    *vn = **cur;
                    vn++; (*cur)++;
                }
                *vn = 0;

                if (var_name[0] == 0) {
                    return ERR_NOVAR;
                }

                general_ptr& p = storage[var_name];
		if (strcmp(var_name, "MASK") == 0) mask = &p;	// Set mask pointer.
                //memcpy(&p, &result, sizeof(general_ptr));
                p.id = result.id;
                p.ptr = result.ptr;
                p.length = result.length;
            }
            else
                return ERR_NOVAR;
        
        }
 /*
        else if (strncmp(*cur, "eval", 4) == 0) {
            (*cur) += 4;

            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;
            
            if (parm.id == ID_STRING) {
                parseline(result, (char*) parm.ptr);
            }
            else {
                result.id = parm.id;
                result.ptr = parm.ptr;
            }
            
        }
	*/
	/*	// NOTE: getvalue should be implemented, but this way is useless. It needs to get a value from someplace other than cur.
        else if (strncmp(*cur, "getvalue", 8) == 0) {
            // Handle getvalue
            (*cur)+=8;
            
            *cur = skipws(*cur);
            int res = get_value(result, cur);
            if (res != ERR_SUCCESS)
                return res;
	}
	*/
        else if (strncmp(*cur, "==", 2) == 0) {
            // Handle ==
            (*cur)+=2;
            
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            // If a ^ b == 0, return 1, else return 0.
            wrapper(axor, result, parm);    // changed to implement !xor
	    apply_mask(result);
            wrapper(anot_n, result, result);  // it's better. really.
	    apply_mask(result);
            
        }
	/*
        else if (strncmp(*cur, ":=", 2) == 0) {
            // Handle :=
            (*cur)+=2;
            
            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;

            // Essentially !(a ^ b)
            wrapper(axor, result, parm);
	    apply_mask(result);
            wrapper(anot_n, result, result);
	    apply_mask(result);
        }
	*/
        else if (strncmp(*cur, "ltt=", 4) == 0) {
            if (result.id == ID_ALTT) {
                if (!size_override && ((altt*) result.ptr)->length > 26)
                    return ERR_LARGE;
                print_expanded(cout, *((altt*) result.ptr)); cout << '\n';
            }
            else
                return ERR_UNIMP;
            (*cur)+=4;
        }
        else if (strncmp(*cur, "simplify", 8) == 0) {
		
            (*cur)+=8;

		*cur = skipws(*cur);
		general_ptr parm;
		int res = get_value(parm, cur);
		if (res != ERR_SUCCESS)
			return res;
		
            if (parm.id == ID_ALTT) {
		    if (mask != NULL)
			    result.ptr = simplify((altt*) parm.ptr, (altt*) mask->ptr);
            }
            else
                return ERR_UNIMP;
	}
        else if (strncmp(*cur, "f=", 2) == 0) {
            if (result.id == ID_ALTT) {
                //if (!size_override && ((altt*) result.ptr)->length > 26)
                //    return ERR_LARGE;
                print_function(cout, *((altt*) result.ptr), false, false, false); cout << '\n';
            }
            else
                return ERR_UNIMP;
            (*cur)+=2;
        }
        else if (strncmp(*cur, "tt=", 3) == 0) {
            if (result.id == ID_ALTT) {
                int var_vals = 0;
                int var_count = ((altt*) result.ptr)->length;

                if (!size_override && var_count > 26)
                    return ERR_LARGE;
                
                cout << '\n';

                for (int i=0; i<var_count; i++) {
                    if (i <= 25)
                        cout << ' ' << (char) ('a' + i);
		    else
		        cout << " *";
		}
                cout << " | result\n";
                
                for (int i=0; i<var_count; i++)
                    cout << "--";
                cout << "-+-------\n";
                
                print_tt(cout, *((altt*) result.ptr), var_vals, var_count);
                
                cout << '\n';
                
            }
            else
                return ERR_UNIMP;
            (*cur)+=3;
        }
	/*
	else if (strncmp(*cur, "g=", 2) == 0) {
		if (result.id == ID_ALTT) {
			altt* a = (altt*) result.ptr;
			if (a->b != NULL && a->a->length == a->b->length) {
				if (a->a->type == ST_BIT0 && a->b->type == ST_BIT1) {
					cout << 'g' << a->a->length;
					if (a->a->length <= 25)
						cout << ", " << (char) ('a' + a->a->length);
					cout << '\n';
					
				}
				else if (a->a->type == ST_BIT1 && a->b->type == ST_BIT0) {
					cout << "!g" << a->a->length;
					if (a->a->length <= 25)
						cout << ", !" << (char) ('a' + a->a->length);
					cout << '\n';
				}
				else
					cout << "(not a general variable)\n";
			}
			else
				cout << "(not a general variable)\n";
		}
		else
			return ERR_UNIMP;
		(*cur)+=2;
	}
	*/
        else if (strncmp(*cur, "id=", 3) == 0) {
            (*cur)+=3;
	    cout << result.ptr << '\n';
        }
        else if ((*cur)[0] == '=') {
            (*cur)++;
            int res = print(result);
            if (res != ERR_SUCCESS)
                return res;
        }
	/*
        else if ((*cur)[0] == '+') {
            (*cur)++;
            if (result.id != ID_BITARRAY)
                return ERR_UNIMP;

            *cur = skipws(*cur);
            general_ptr parm;
            int res = get_value(parm, cur);
            if (res != ERR_SUCCESS)
                return res;
            
            if (parm.id != ID_BITARRAY)
                return ERR_UNIMP;

            if (result.length < parm.length+1) {
                general_ptr* new_res = (general_ptr*)
                    malloc(sizeof(general_ptr) * (parm.length+1));
                memcpy(new_res, result.ptr, result.length *
                        sizeof(general_ptr));
                
                general_ptr& fill =
                    ((general_ptr*) result.ptr)[result.length-1];

                for (int i=result.length; i<parm.length+1; i++) {
                    new_res[i].id = fill.id;
                    new_res[i].ptr = fill.ptr;
                    new_res[i].length = fill.length;
                }

                result.ptr = new_res;
                result.length = parm.length+1;
                
            }

            general_ptr carry = {ID_ALTT, zero};
            for (int i=0; i<parm.length; i++) {

                general_ptr* parm_ptr;
                if (i < parm.length)
                    parm_ptr = &(((general_ptr*) parm.ptr)[i]);
                else
                    parm_ptr = &(((general_ptr*) parm.ptr)[parm.length-1]);
                
                general_ptr& r = ((general_ptr*) result.ptr)[i];
                general_ptr b1 = *parm_ptr;
                general_ptr old_result = r;

                wrapper(axor, r, b1);
	        apply_mask(result);
                wrapper(axor, r, carry);
	        apply_mask(result);
                
                // Result is now set properly.
                
                // Three-bit adder...
                general_ptr b2 = b1;
                wrapper(aor_n, b1, carry);  // b1 = b1 | carry
	        apply_mask(result);
                wrapper(aand_n, b2, carry); // b2 = b2 & carry
	        apply_mask(result);
                
                carry = old_result;
                wrapper(aand_n, carry, b1);     // a = a & b1
	        apply_mask(result);
                wrapper(aor_n, carry, b2);      // a = a | b2
	        apply_mask(result);

                // Carry bit is now set properly.
                
            }
            ((general_ptr*) result.ptr)[parm.length] = carry;
            
        }
	*/
        else {
            // Get value
            int res = get_value(result, cur);
            if (res != ERR_SUCCESS)
                return res;
        }
    
    }

    return ERR_SUCCESS;

}


void parseline(general_ptr& result, char* rl) {
    rl = skipws(rl);
    if (strcmp(rl, "info") == 0) {
        cout << storage.size() << " variable(s) allocated.\n";
        cout << total_nands << " operation(s) performed total, "
             << total_nands-nonunique_nands << " unique.\n";
        cout << "Seg. heap size = " << segheap.size() << '\n';
        cout << "ALTT heap size = " << alttheap.size() << '\n';
        if (result.id == ID_ALTT) {
            cout << "Last result was of type ALTT.\n";
            cout << "Length of last result = 2^" <<
                ((altt*) result.ptr)->length << '\n';

	    int nbs = ((altt*) result.ptr)->num_bit1_segs;
	    if (nbs == 0)
		    cout << "No 1:n segments in result.\n";
	    else if (nbs == 1)
		    cout << "Exactly one 1:n segment in result.\n";
	    else
		    cout << "More than one 1:n segment in result.\n";
        }
        else if (result.id == ID_STRING) {
            cout << "Last result was of type STRING.\n";
        }
        else if (result.id == ID_BITARRAY) {
            cout << "Last result was of type BITARRAY.\n";
            cout << "Length of last result = " << result.length << '\n';
        }
        
        //gcollect();
        return;
    }

    char* temp = rl; int res = parse(result, &temp);
    if (res != ERR_SUCCESS) {
        switch (res) {
            case ERR_NOVAR:
                cerr << "ERROR: Variable name expected.\n";
                break;
            case ERR_NOVALUE:
                cerr << "ERROR: Value expected.\n";
                break;
            case ERR_UNDEF:
                cerr << "ERROR: Variable undefined.\n";
                break;
            case ERR_UNIMP:
                cerr << "ERROR: Unimplemented.\n";
                break;
            case ERR_LARGE:
                cerr << "ERROR: Physical result of operation is too large.\n";
                break;
            case ERR_QUOTE:
                cerr << "ERROR: Unterminated string (missing ending quote).\n";
                break;
            default:
                cerr << "ERROR: [undefined error number... this shouldn't be happening]\n";
        }
        cerr << rl << '\n';
        while (temp > rl) { cerr << ' '; temp--; }
        cerr << "^\n";
    }

    storage["ANS"] = result;
    
    //gcollect();
}

