<?php

/**
 * Generated by PHPUnit_SkeletonGenerator on 2017-11-26 at 11:24:04.
 */
class Acc_AccountTest extends PHPUnit_Framework_TestCase
{

    /**
     * @var Acc_Account
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        global $g_connection, $g_parameter, $g_user;
        $_REQUEST['gDossier']=DOSSIER;
        $g_connection=new Database(DOSSIER);
        $g_parameter=new Noalyss_Parameter_Folder($g_connection);
        $g_user=new User($g_connection);
        $cn=Dossier::connect();
        $this->object=new Acc_Account($cn, '400');
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
        
    }

    /**
     * @covers Acc_Account::get_parameter
     */
    public function testGet_parameter()
    {

        $this->assertEquals($this->object->get_parameter("pcm_lib"), 'Clients');
    }

    /**
     * @covers Acc_Account::set_parameter
     */
    public function testSet_parameter()
    {
        $this->object->set_parameter("pcm_direct_use", "N");
    }

    /**
     * @covers Acc_Account::get_lib
     */
    public function testGet_lib()
    {
        $this->assertEquals($this->object->get_lib(), 'Clients');
    }

    /**
     * @covers Acc_Account::load
     */
    public function testLoad()
    {
        $this->object->load();
    }

    /**
     * @covers Acc_Account::count
     */
    public function testCount()
    {

        $this->assertEquals($this->object->count("400"), 1);
    }

    /**
     * @covers Acc_Account::verify
     */
    public function testVerify()
    {
        $this->object->verify();
    }

    /**
     * @covers Acc_Account::update
     */
    public function testUpdate()
    {
        $this->object->update();
    }

    /**
     * @covers Acc_Account::insert
     */
    public function testInsert()
    {
        $cn=Dossier::connect();
        $new=new Acc_Account($cn);
        $new->set_parameter("pcm_val", '400A');
        $new->set_parameter("pcm_val_parent", "400");
        $new->set_parameter("pcm_direct_use", "Y");
        // expect libelle vide
        try
        {
            // exception must be thrown from insert
            $new->insert();
            $this->assertFalse(true);
        }
        catch (Exception $e)
        {
            $this->assertEquals($e->getCode(), EXC_PARAM_VALUE);
        }

        $new->set_parameter("pcm_lib", "Insertion test");
        $new->insert();
        $new->delete();
    }

    /**
     * @covers Acc_Account::delete
     */
    public function testDelete()
    {
        try
        {
            $this->object->delete();
            $this->assertFalse(true);
        }
        catch (Exception $e)
        {
            echo $e->getTraceAsString();
            $this->assertEquals($e->getCode(), EXC_PARAM_VALUE);
        }
    }

    /**
     * @covers Acc_Account::save
     */
    public function testSave()
    {
        $this->object->save();
    }

}
