<?php
/*
 *   This file is part of NOALYSS.
 *
 *   NOALYSS is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   NOALYSS is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with NOALYSS; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// Copyright Author Dany De Bontridder danydb@aevalys.eu

/*!\file
 * \brief Concerns the Analytic plan (table plan_analytique)
 */

/*! \brief
 *  Concerns the Analytic plan (table plan_analytique)
 */
require_once NOALYSS_INCLUDE.'/lib/itext.class.php';
require_once NOALYSS_INCLUDE.'/lib/ihidden.class.php';
require_once NOALYSS_INCLUDE.'/constant.php';
require_once NOALYSS_INCLUDE.'/lib/database.class.php';
require_once NOALYSS_INCLUDE.'/database/poste_analytique_sql.class.php';
require_once  NOALYSS_INCLUDE.'/class/dossier.class.php';

class Anc_Plan
{
    var $db; /*!<database connection */
    var $name; 					/*!< name plan_analytique.pa_name */
    var $description;				/*!< description of the PA plan_analytique.pa_description*/
    var $id;						/*!< id = plan_analytique.pa_id */

    function __construct($p_cn,$p_id=0)
    {
        $this->db=$p_cn;
        $this->id=$p_id;
        $this->name="";
        $this->description="";
        $this->get();
    }
    /*!\brief get the list of all existing PA
     * \return an array of PA (not object)
     *
     */
    function get_list($p_order=" order by pa_name")
    {
        $array=array();
        $sql="select pa_id as id,pa_name as name,".
             "pa_description as description from plan_analytique $p_order";
        $ret=$this->db->exec_sql($sql);
        $array=Database::fetch_all($ret);
        return $array;
    }

    function get()
    {
        if ( $this->id==0) return;

        $sql="select pa_name,pa_description from plan_analytique where pa_id=$1";
        $ret= $this->db->exec_sql($sql,array($this->id));
        if ( Database::num_row($ret) == 0)
        {
            return;
        }
        $a=  Database::fetch_array($ret,0);
        $this->name=$a['pa_name'];
        $this->description=$a['pa_description'];

    }

    function delete()
    {
        if ( $this->id == 0 ) return;
        $this->db->exec_sql("delete from plan_analytique where pa_id=$1",array($this->id));
    }

    function update()
    {
        if ( $this->id==0) return;
        $name=sql_string($this->name);
        if ( strlen($name) == 0)
            return;

        $description=sql_string($this->description);
        $this->db->exec_sql("update plan_analytique set pa_name=$1,
                            pa_description=$2 where pa_id=$3",array($name,$description,$this->id));
    }

    function add()
    {
        $name=sql_string($this->name);
        if ( strlen($name) == 0)
            return;
        if ( $this->isAppend() == false) return;
        $description=sql_string($this->description);
        $this->db->exec_sql("insert into plan_analytique(pa_name,pa_description)".
                            " values ($1,$2 )"
                            ,array($name,$description));
        $this->id=$this->db->get_current_seq('plan_analytique_pa_id_seq');

    }
    function form()
    {
        $dossier_id=Dossier::id();
        $wName=new IText('pa_name',$this->name,"pa_name");
        $iName=new Inplace_Edit($wName);
        $iName->set_callback("ajax_misc.php");
        $iName->add_json_param("gDossier",$dossier_id);
        $iName->add_json_param("action","anc_updatedescription");
        $iName->add_json_param("op","anc_updatedescription");
        $iName->add_json_param("id",$this->id);


        $wDescription=new IText('pa_description',$this->description,"pa_description");
        $wDescription->size=50;
        if ( $this->description == "") $wDescription->value=_("Aucune description");
        $iDescription=new Inplace_Edit($wDescription);
        $iDescription->add_json_param("gDossier",$dossier_id);
        $iDescription->add_json_param("op","anc_updatedescription");
        $iDescription->add_json_param("action","anc_updatedescription");
        $iDescription->set_callback("ajax_misc.php");
        $iDescription->add_json_param("id",$this->id);
        

        $wId=new IHidden("pa_id",$this->id);
        $ret="<TABLE>";
        $ret.='<tr>'.td(_('Nom')).'<td>'.$iName->input().'</td>'.'</tr>';
        $ret.="<tr>".td(_('Description')).'<td>'.$iDescription->input().'</td>'."</tr>";
        $ret.="</table>";
        $ret.=$wId->input();
        return $ret;
    }
    /**
     * @brief add a new plan
     */
    function form_new()
    {
        $wName=new IText("pa_name");
        $wDescription=new IText("pa_description");
        $wDescription->size=80;
        
        $ret="<TABLE>";
        $ret.='<tr>'.td(_('Nom')).'<td>'.$wName->input().'</td>'.'</tr>';
        $ret.="<tr>".td(_('Description')).'<td>'.$wDescription->input().'</td>'."</tr>";
        $ret.="</table>";
        return $ret;

        
    }
    function isAppend()
    {
        $count=$this->db->get_value("select count(pa_id) from plan_analytique");

        if ( $count > 10 )
            return false;
        else
            return true;
    }
    /*!\brief show the header for a table for PA
     * \return string like <th>name</th>...
     */
    function header()
    {
        $res="";
        $a_plan=$this->get_list(" order by pa_id");
        if ( empty($a_plan)) return "";
        foreach ($a_plan as $r_plan)
        {
            $res.="<th>".h($r_plan['name'])."</th>";
        }
        return $res;
    }
    function count()
    {
        $a=$this->db->count_sql("select pa_id from plan_analytique");
        return $a;
    }
    function exist()
    {
        $a=$this->db->count_sql("select pa_id from plan_analytique where pa_id=$1",
                                array($this->pa_id));

        return ($a==0)?false:true;

    }
    /**
    *@brief return an HTML string containing hidden input type to
    * hold the differant PA_ID
    *@param $p_array contains a array, it is the result of the fct
    * Anc_Plan::get_list
    *@return html string
    *@see Anc_Plan::get_list
    */
    static function hidden($p_array)
    {
        $r='';
        for ($i_anc=0;$i_anc <count($p_array);$i_anc++)
        {
            $r.=HtmlInput::hidden('pa_id[]',$p_array[$i_anc]['id']);
        }
        return $r;
    }
    static function test_me()
    {
        $cn=Dossier::connect();
        echo "<h1>Plan analytique : test</h1>";
        echo "clean";
        $cn->exec_sql("delete from plan_analytique");

        $p=new Anc_Plan($cn);
        echo "<h2>Add</h2>";
        $p->name="Nouveau 1";
        $p->description="C'est un test";
        echo "Add<hr>";
        $p->add();
        $p->name="Nouveau 2";
        $p->add();
        $pa_id=$p->id;
        echo $p->id."/";
        $p->name="Nouveau 3";
        $p->add();
        echo $p->id."/";


        $p->name="Nouveau 4";
        $p->add();
        echo $p->id;

        echo "<h2>get</h2>";
        $p->get();
        var_dump($p);
        echo "<h2>Update</h2> ";
        $p->name="Update ";
        $p->description="c'est change";
        $p->update();
        $p->get();
        var_dump($p);
        echo "<h2>get_list</h2>";
        $a=$p->get_list();
        var_dump($a);
        echo "<h2>delete </h2>";
        $p->delete();


    }
}

?>
