.TH SENDFILES %manext1% 2012-11-14 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
sendfiles \- send multiple files by MIME message with nmh
.SH SYNOPSIS
.HP 5
.na
.B sendfiles
.RB [ \-help ]
.RB [ \-version ]
.RB [ -compress
.IR bzip2 " | " compress " | " gzip " | " lzma " | " none ]
.br
.RB [ \-from
.IR sender ]
.br
.B \-to
.I recipient
.B \-subject
.IR subject " | "
.I recipient
.I subject
.br
.I file/directory1
.RI [ file/directory2
\&...]
.ad
.SH DESCRIPTION
The shell script
.B sendfiles
is used to send a collection
of files and directories via electronic mail.
.PP
.B sendfiles
will archive the files and directories you name
with the
.B tar
command, and then mail the compressed
archive to the \*(lqrecipient\*(rq with the given \*(lqsubject\*(rq.
.PP
The
.B \-to
switch specifies the recipient.  The
.B \-subject
switch specifies the subject.  Alternatively, these two required values
can be provided without their corresponding switch names.
.PP
The
.B \-from
switch can, and should, be used to specify the sender's mailbox (name
and email address).  Alternatively, the
.B PERSON
environment variable can be used for the same purpose.
If neither is used,
.B sendfiles
will supply a \*(lqFrom:\*(rq header field using the sender's local
mailbox, see
.I localmbox
in
.IR mh-format (5).
.PP
The
.B \-compress
command line switch can be used to override the run-time determination
of the compression program by
.BR sendfiles .
.B \-compress
.I none
(alternatively,
.BR \-none )
disables compression.
.PP
.SS "Extracting the Received Files"
When the message is received, invoke
.B mhstore
once for
the received message.  The default is for
.B mhstore
to write the archive to a file where you can
subsequently uncompress and untar it.  For instance:
.PP
.RS 5
.nf
$ mhlist -verbose 9
 msg part  type/subtype             size description
   9       application/octet-stream 118K
             (extract with uncompress | tar xvpf -)
             type=tar
             conversions=compress
$ mhstore 9
$ uncompress < 9.tar.Z | tar xvpf -
.fi
.RE
.PP
Alternately, by using the
.B \-auto
switch,
.B mhstore
will automatically do the extraction for you:
.PP
.RS 5
.nf
$ mhlist -verbose 9
 msg part  type/subtype             size description
   9       application/octet-stream 118K
             (extract with uncompress | tar xvpf -)
             type=tar
             conversions=compress
$ mhstore -auto 9
-- tar listing appears here as files are extracted
.fi
.RE
.PP
As the second
.B tar
listing is generated, the files are extracted.
A prudent user will never put
.B \-auto
in the
.I \&.mh_profile
file.  The correct procedure is to first use
.B mhlist
to find out what will be extracted.  Then
.B mhstore
can be invoked with
.B \-auto
to perform the extraction.
.SH FILES
.fc ^ ~
.nf
.ta \w'%nmhetcdir%/ExtraBigFileName  'u
^$HOME/.mh_profile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
.fi
.SH "SEE ALSO"
.IR mhbuild (1),
.IR mhlist (1),
.IR mhshow (1),
.IR mhstore (1),
.IR mh-format (5)
.PP
.I "Proposed Standard for Message Encapsulation"
(RFC 934)
.SH DEFAULTS
.nf
.RB ` "\-delay\ 0" '
.RB ` "\-from localmbox" '
.fi
.SH CONTEXT
None
