.TH SEND %manext1% 2022-12-22 "%nmhversion%"
.
.\" %nmhwarning%
.
.SH NAME
send \- send an nmh message
.SH SYNOPSIS
.HP 5
.na
.B send
.RB [ \-help ]
.RB [ \-version ]
.RB [ \-alias
.IR aliasfile ]
.RB [ \-draft ]
.RB [ \-draftfolder
.IR +folder ]
.RB [ \-draftmessage
.IR msg ]
.RB [ \-nodraftfolder ]
.RB [ \-filter
.IR filterfile ]
.RB [ \-nofilter ]
.RB [ \-format " | " \-noformat ]
.RB [ \-forward " | " \-noforward ]
.RB [ \-mime " | " \-nomime ]
.RB [ \-msgid " | " \-nomsgid ]
.RB [ \-messageid
.IR localname " | " random ]
.RB [ \-push " | " \-nopush ]
.RB [ \-verbose " | " \-noverbose ]
.RB [ \-watch " | " \-nowatch ]
.RB [ \-mts
.IR smtp " | " sendmail/smtp " | " sendmail/pipe ]
.RB [ \-sendmail
.IR program ]
.RB [ \-server
.IR servername ]
.RB [ \-port
.IR port-name/number ]
.RB [ \-sasl ]
.RB [ \-nosasl ]
.RB [ \-saslmech
.IR mechanism ]
.RB [ \-authservice
.IR service ]
.RB [ \-snoop ]
.RB [ \-user
.IR username ]
.RB [ \-tls ]
.RB [ \-initialtls ]
.RB [ \-notls ]
.RB [ \-certverify ]
.RB [ \-nocertverify ]
.RB [ \-width
.IR columns ]
.RB [ file
\&...]
.ad
.SH DESCRIPTION
.B send
will cause each of the specified files to be delivered
to each of the destinations in the \*(lqTo:\*(rq, \*(lqcc:\*(rq,
\*(lqBcc:\*(rq, \*(lqDcc:\*(rq, and \*(lqFcc:\*(rq fields of the message.  If
.B send
is re-distributing a message, as invoked from
.BR dist ,
then the
corresponding \*(lqResent\-xxx\*(rq fields are examined instead.
.PP
By default,
.B send
uses the program
.B post
to do the actual
delivery of the messages, although this can be changed by defining the
.I postproc
profile component.  Most of the features attributed to
.B send
are actually performed by
.BR post .
.PP
Before
.B send
gives the message to
.B post
for delivery, the message is processed by
.B mhbuild
to perform any necessary MIME encoding of the outgoing message.  This
can be changed by the
.I buildmimeproc
profile component.
.B mhbuild
is invoked with the
.B \-auto
switch, so
.B mhbuild
directives are not processed by default.  See
.IR mhbuild (1)
for more information.
.PP
.B mhbuild
will scan the message draft for a header named
.IR Attach .
The draft is converted to a MIME message if one or more matches are found.
This conversion occurs before all other processing.
.IR whatnow (1)
describes the user interface for managing MIME attachments via
this mechanism.
.PP
The first part of the MIME message is the draft body if that body contains
any non-blank characters.
The body of each
.I Attach
header field is interpreted as a file name, and each file named is included as a separate
part in the MIME message.
.PP
Determination of the content MIME type inserted into the Content-Type
header for each part depends on how the
.B nmh
installation was configured.  If a program, such as
.B file
with a
.B \-\-mime
or
.B \-i
option, was found that can specify the type of a file as a MIME type
string, then that will be used.  To determine if your
.B nmh
was so configured, run
.B mhparam mimetypeproc
and see if a non-empty string is displayed.
.PP
If your
.B nmh
was not configured with a program to specify a file type as a MIME
string, then a different method is used to determine the content-type
string.  This method is also used if the configured mimetypeproc fails
to find the MIME type of the content.  For file names with dot suffixes,
the profile is scanned for a
.I mhshow-suffix-
entry for that suffix.
The content-type for the part is taken from that profile entry if a match is
found.  If a match is not found in the user profile, the mhn.defaults
profile is scanned next.
If no match is found or the file does not have a dot suffix, the content-type
is text/plain if the file contains only ASCII characters or application/octet-stream
if it contains characters outside of the ASCII range.  See
.IR mhshow (1)
for more details and example syntax.
.PP
Each attached MIME part contains a
\*(lqContent-Description\*(rq header that includes the filename, and
adds a \*(lqContent-Disposition\*(rq header.
Here is an example of MIME part headers for an attachment:
.PP
.nf
Content-Type: text/plain; name="VERSION"; charset="us-ascii"
Content-Description: VERSION
Content-Disposition: attachment; filename="VERSION"
.fi
.PP
See
.IR mhbuild (1)
for explanation of how the Content-Disposition value is selected.
.PP
If
.B \-push
is specified,
.B send
will detach itself from the user's
terminal and perform its actions in the background.  If
.BR push 'd
and the draft can't be sent, then an error message will be sent (using
the mailproc) back to the user.  If
.B \-forward
is given, then a copy
of the draft will be attached to this failure notice.  Using
.B \-push
differs from putting
.B send
in the background because the output is
trapped and analyzed by
.BR nmh .
.PP
If
.B \-verbose
is specified,
.B send
will indicate the interactions
occurring with the transport system, prior to actual delivery.
If
.B \-watch
is specified
.B send
will monitor the delivery of local
and network mail.  Hence, by specifying both switches, a large detail
of information can be gathered about each step of the message's entry
into the transport system.
.PP
The
.B \-draftfolder
.I +folder
and
.B \-draftmessage
.I msg
switches invoke
the
.B nmh
draft folder facility.  This is an advanced (and highly
useful) feature.  Consult
.IR mh-draft (5)
for more
information.
.PP
.B send
with no
.I file
argument will query whether the draft
is the intended file, whereas
.B \-draft
will suppress this question.
Once the transport system has successfully accepted custody of the
message, the file will be renamed with a site-dependent prefix
(usually a comma), which allows
it to be retrieved until the next draft message is sent.  If there are
errors in the formatting of the message,
.B send
will abort with a
(hopefully) helpful error message.
.PP
If a \*(lqBcc:\*(rq field is encountered, its addresses will be used for
delivery, and the \*(lqBcc:\*(rq field will be removed from the message
sent to sighted recipients.  The blind recipients will receive an entirely
new message with a minimal set of headers. The body of this new message
will contain a copy of the message sent to the sighted recipients, either
marked up with the indicator text "Blind-Carbon-Copy" or encapsulated
as a MIME digest.
.PP
If a \*(lqDcc:\*(rq field is encountered and the
.B sendmail/pipe
mail transport method is not in use, its addresses will be used for
delivery, and the \*(lqDcc:\*(rq field will be removed from the message.  The
blind recipients will receive exactly the same message as the sighted
recipients.  *WARNING* Recipients listed in the \*(lqDcc:\*(rq field receive no
explicit indication that they have received a \*(lqblind copy\*(rq.
This can cause blind recipients to
inadvertently reply to all of the sighted recipients of the
original message, revealing that they received a blind copy.
On the other hand, since a normal reply to a message sent
via a \*(lqBcc:\*(rq field
will generate a reply only to the sender of the original message,
it takes extra effort in most mailers to reply to the included
message, and so would usually only be done deliberately, rather
than by accident.
.PP
If the
.B sendmail/pipe
mail transport method is used, then messages containing
a \*(lqDcc:\*(rq field are rejected.

.PP
If
.B \-filter
.I filterfile
is specified, then this copy is filtered
(re-formatted) by
.B mhl
prior to being sent to the blind recipients.
Alternately, if you specify the
.B -mime
switch, then
.B send
will
use the MIME rules for encapsulation.
.PP
Prior to sending the message, the \*(lqDate:\ now\*(rq field will be appended to the headers in the message.
If
.B \-msgid
is specified, then a \*(lqMessage\-ID:\*(rq field will also
be added to the message.
.PP
The
.B \-messageid
switch selects the style used for the part appearing after the @
in \*(lqMessage\-ID:\*(rq, \*(lqResent\-Message\-ID:\*(rq, and
\*(lqContent\-ID:\*(rq header fields.  The two acceptable options are
.B localname
(which is the default),
and
.BR random .
With
.BR localname ,
the local hostname is used.  With
.BR random ,
a random sequence of characters is used instead.  Note that the
.B \-msgid
switch must be enabled for this switch to have any effect.
.PP
If
.B send
is re-distributing a message (when invoked by
.BR dist ),
then \*(lqResent\-\*(rq will be prepended to each of these
fields: \*(lqFrom:\*(rq, \*(lqDate:\*(rq, and \*(lqMessage\-ID:\*(rq.
.PP
A \*(lqFrom:\*(rq field is required for all outgoing messages.  Multiple
addresses are permitted in the \*(lqFrom:\*(rq field, but a \*(lqSender:\*(rq
field is required in this case.  Otherwise a \*(lqSender:\*(rq field
is optional.
.PP
If a message with multiple \*(lqFrom:\*(rq
addresses does
.I not
include a \*(lqSender:\*(rq field but does include an \*(lqEnvelope\-From:\*(rq
field, the \*(lqEnvelope\-From:\*(rq field will be used to construct
a \*(lqSender:\*(rq field.
.PP
When using SMTP for mail submission, the envelope-from used for the SMTP
transaction is derived from the \*(lqEnvelope\-From:\*(rq field.
If no \*(lqEnvelope\-From:\*(rq field is present, the \*(lqSender:\*(rq
field is used.  If neither the \*(lqEnvelope\-From:\*(rq nor the
\*(lqSender:\*(rq field is present, the \*(lqFrom:\*(rq field is used.
When \*(lqEnvelope\-From:\*(rq appears in a message
it will be removed from the final outgoing message.
.PP
By using the
.B \-format
switch, each of the entries in the \*(lqTo:\*(rq
and \*(lqcc:\*(rq fields will be replaced with \*(lqstandard\*(rq
format entries.  This standard format is designed to be usable by all
of the message handlers on the various systems around the Internet.
If
.B \-noformat
is given, then headers are output exactly as they appear
in the message draft.
.PP
If an \*(lqFcc:\ folder\*(rq is encountered, the message will be copied
to the specified folder for the sender in the format in which it will
appear to any non\-Bcc receivers of the message.  That is, it will have
the appended fields and field reformatting.  The \*(lqFcc:\*(rq fields
will be removed from all outgoing copies of the message.
.PP
Beware that if an \*(lqFcc:\*(rq with one or more folders is present
but none of the folders exist, and the default
.I fileproc
and
.I postproc
are in use, then
.B refile
will prompt the user to create the folder(s) if
.B \-push
is not specified.  If all responses are negative, or creation of each folder
fails, or
.B \-push
is specified, the message will not be copied to any folder and will be
removed by
.BR post .
With the default
.B refile
switches, the message draft will be renamed according to the specification
of its
.B \-nolink
switch.
.PP
By using the
.B \-width
.I columns
switch, the user can direct
.B send
as to how long it should make header lines containing addresses.
.PP
The mail transport system default is provided in
.I %nmhetcdir%/mts.conf
but can be overridden here with the
.B \-mts
switch.
.PP
If nmh is using
.B sendmail/pipe
or
.B sendmail/smtp
as its mail transport system, the
.B \-sendmail
switch can be used to override the default
.B sendmail
program.
.PP
If nmh is using the SMTP MTA, the
.B \-server
and the
.B \-port
switches can be used to override the default mail server (defined by the
.I %nmhetcdir%/mts.conf
.I servers
entry).  The
.B \-snoop
switch can be used to view the SMTP transaction.  (Beware that the
SMTP transaction may contain authentication information either in
plaintext or easily decoded base64.)  If
.B \-sasl \-saslmech xoauth2
is used, the HTTP transaction is also shown.
.PP
If
.B nmh
has been compiled with SASL support, the
.B \-sasl
and
.B \-nosasl
switches will enable and disable
the use of SASL authentication with the SMTP MTA.  Depending on the
SASL mechanism used, this may require an additional password prompt from the
user (but the
.I netrc
file can be used to store this password, as described in
.IR mh-profile (5).
The
.B \-saslmech
switch can be used to select a particular SASL mechanism,
and the
.B \-user
switch can be used to select a authorization userid to provide to SASL
other than the default.  The credentials profile entry in
.IR mh\-profile (5)
describes the ways to supply a username and
password.
.PP
If SASL authentication is successful,
nmh
will attempt to negotiate a security layer for session encryption.
Encrypted data is labelled with `(encrypted)' and `(decrypted)' when
viewing the SMTP transaction with the
.B \-snoop
switch; see
.IR post (8)'s
description of
.B \-snoop
for its other features.
.PP
If
.B nmh
has been compiled with OAuth support, the
.B \-sasl
and
.B \-saslmech xoauth2
switches will enable OAuth authentication.  The
.B \-user
switch must be used, and the
.I username
must be an email address the user has for the service, which must
be specified with the
.B \-authservice
.I service
switch.  Before using OAuth authentication, the user must authorize nmh by
running
.B mhlogin
and grant authorization to that account.  See
.IR mhlogin (1)
for more details.
.PP
If
.B nmh
has been compiled with TLS support, the
.B \-tls
and
.B \-initialtls
switches will require the negotiation of TLS when
connecting to the SMTP MTA.  The
.B \-tls
switch will negotiate TLS as part of the normal SMTP protocol
using the STARTTLS command.  The
.B \-initialtls
will negotiate TLS immediately after the connection has
taken place, before any SMTP commands are sent or received.  Encrypted data
is labelled with `(tls-encrypted)' and
`(tls-decrypted)' when viewing the SMTP transaction with the
.B \-snoop
switch; see
.IR post (8)'s
description of
.B \-snoop
for its other features.
The
.B \-notls
switch will disable all attempts to negotiate TLS.
.PP
If port 465 is specified and none of the TLS switches were enabled,
.B \-initialtls
will be implied if TLS support was compiled in.  Though port 465 for
SMTPS (SMTP over SSL) was deregistered by IANA in 1998, it is still
used for that service.
.PP
When using TLS the default is to verify the remote certificate and SubjectName
against the local trusted certificate store.  This can be controlled by
the
.B \-certverify
and
.B \-nocertverify
switches.  See your OpenSSL documentation for more information on certificate
verification.
.PP
The files specified by the profile entry \*(lqAliasfile:\*(rq and any
additional alias files given by the
.B \-alias
.I aliasfile
switch will be
read (more than one file, each preceded by
.BR \-alias ,
can be named).
See
.IR mh\-alias (5)
for more information.
.SS Selection based on sender address:  sendfrom
One or more
.I sendfrom
profile components can be used to select a mail server address, mail server
port, or any other switch that can be supplied to
.BR post .
It works by first looking at the sender address and domain name in the
message draft, as described below.
It then looks for a corresponding profile entry, which contains the
.B post
switches.
To enable, add profile entries of the form:
.PP
.RS 5
.RI sendfrom- "address/domain name" : " post switches"
.RE
.PP
The email address is extracted from the Envelope-From:  header, if not blank,
the Sender: header, or the From: header line in the message draft.
Multiple profile entries, with different email addresses or domain names, are
supported.
This allows different switches to
.BR post ,
such as -user, to be associated with different email addresses.
If a domain name is used, it matches all users in that domain.
.PP
Here is an example profile entry to use the SMTP on the localhost when the
sender address is clearly local:
.PP
.nf
.RS 5
sendfrom-localuser@localhost: -server localhost -port smtp
.RE
.fi
.PP
(Indentation indicates a continued line, as supported in MH profiles.)
The username need not be the same as the sender address, which was extracted
from the appropriate header line as noted above.
.PP
Here are example profile entries that use an nmh credentials file:
.PP
.nf
.RS 5
credentials: file:nmhcreds
sendfrom-sendgrid_address@example.com: -sasl -tls
.RS 5
-server smtp.sendgrid.net
.RE
sendfrom-outbound.att.net: -sasl -initialtls
.RS 5
-server outbound.att.net -port 465
.RE
sendfrom-fastmail.com: -initialtls -sasl -saslmech LOGIN
.RS 5
-server smtps-proxy.messagingengine.com -port 80
.RE
.RE
.fi
.PP
where nmhcreds is in the user's nmh directory (from the Path profile component)
and contains:
.PP
.nf
.RS 5
machine smtp.sendgrid.net
.RS 5
login sendgrid_login@example.com
password ********
.RE
machine outbound.att.net
.RS 5
login att_login@example.com
password ********
.RE
machine smtps-proxy.messagingengine.com
.RS 5
login fastmail_login@example.com
password ********
.RE
.RE
.fi
.PP
For more information on authentication to mail servers, see
.IR mhlogin (1)
for OAuth services, and
.IR mh-profile (5)
for login credentials.
.PP
.SH FILES
.fc ^ ~
.nf
.ta \w'%nmhetcdir%/ExtraBigFileName  'u
^$HOME/.mh_profile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Aliasfile:~^For a default alias file
^Signature:~^To determine the user's mail signature
^mailproc:~^Program to post failure notices
^postproc:~^Program to post the message
^sendfrom-address:~^Switches to post for sender address
^sendfrom-domain:~^Switches to post for sender domain name
.fi
.SH "SEE ALSO"
.IR comp (1),
.IR dist (1),
.IR file (1),
.IR forw (1),
.IR mhbuild (1),
.IR mhparam (1),
.IR mhlogin (1),
.IR refile (1),
.IR repl (1),
.IR whatnow (1),
.IR mh\-alias (5),
.IR mh\-profile (5),
.IR mh\-tailor (5),
.IR post (8)
.SH DEFAULTS
.nf
.RB ` file "' defaults to <mh-dir>/draft"
.RB ` \-alias "' defaults to %nmhetcdir%/MailAliases"
.RB ` \-nodraftfolder '
.RB ` \-nofilter '
.RB ` \-format '
.RB ` \-forward '
.RB ` \-nomime '
.RB ` \-nomsgid '
.RB ` "\-messageid\ localname" '
.RB ` \-nopush '
.RB ` \-noverbose '
.RB ` \-nowatch '
.RB ` "\-width\ 72" '
.RB ` \-certverify '
.fi
.SH CONTEXT
None
.SH BUGS
Under some configurations, it is not possible to monitor the mail delivery
transaction;
.B \-watch
is a no-op on those systems.
