.\"
.\" %nmhwarning%
.\" $Id: mh-alias.man,v 1.5 2006/04/14 08:42:04 jjr Exp $
.\"
.TH MH-ALIAS %manext5% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
mh-alias \- alias file for nmh message system
.SH SYNOPSIS
any
.B nmh
command
.SH DESCRIPTION
This describes both
.B nmh
personal alias files and
the global alias file for
.B nmh
mail delivery, the file
.PP
.RS 5
%etcdir%/MailAliases
.RE
.PP
It does
.B not
describe aliases files used by the message transport system.
Each line of the alias file has the format:
.PP
.RS 5
.I alias
.B :
.I address\-group
.RE
or
.RS 5
.I alias
.B ;
.I address\-group
.RE
or
.RS 5
.B <
.I alias\-file
.RE
or
.RS 5
.B ;
.I comment
.RE
.PP
where:
.PP
.RS 5
.nf
.IR address\-group "	:= " address\-list
.RI "			|  < " file
.RI "			|  = " UNIX\-group
.RI "			|  + " UNIX\-group
			|  *

.IR address\-list "	:= " address
.RI "			|  " address\-list ", " address
.fi
.RE
.PP
Continuation lines in alias files end with `\\' followed by the newline
character.
.PP
.RI \*(lq  Alias\-file \*(rq
and
.RI \*(lq file \*(rq
are UNIX file names.
.I UNIX\-group
is a group name (or number) from
.IR /etc/group .
An address is a \*(lqsimple\*(rq
Internet\-style address.  Througout this file, case is ignored, except
for file names.
.PP
If the line starts with a `<', then the file named after the `<' is
read for more alias definitions.  The reading is done recursively, so a
`<' may occur in the beginning of an alias file with the expected results.
.PP
If the
.I address\-group
starts with a `<', then the file named after the
`<' is read and its contents are added to the
.I address\-list
for the alias.
.PP
If the
.I address\-group
starts with an `=', then the file
.I /etc/group
is consulted for the UNIX\-group named after the `='.  Each login name
occurring as a member of the group is added to the
.I address\-list
for the alias.
.PP
In contrast, if the
.I address\-group
starts with a `+', then the file
.I /etc/group
is consulted to determine the group\-id of the
UNIX\-group named after the `+'.  Each login name occurring in the
.I /etc/passwd
file whose group\-id is indicated by this group is
added to the
.I address\-list
for the alias.
.PP
If the
.I address\-group
is simply `*', then the file
.I /etc/passwd
is consulted and all login names with a userid
greater than some magic number (usually 200) are added to the
.I address\-list
for the alias.
.PP
In match, a trailing \*(lq*\*(rq on an alias will match just about anything
appropriate.  (See example below.)
.PP
An approximation of the way aliases are resolved at posting time is
(it's not really done this way):
.PP
.RS 2
.IP 1) 3
Build a list of all addresses from the message to be delivered,
eliminating duplicate addresses.
.PP
.IP 2) 3
If this draft originated on the local host, then for those addresses in
the message that have no host specified, perform alias resolution.
.PP
.IP 3) 3
For each line in the alias file, compare \*(lqalias\*(rq against all of
the existing addresses.  If a match, remove the matched \*(lqalias\*(rq
from the address list, and add each new address in the address\-group to
the address list if it is not already on the list.  The alias itself is
not usually output, rather the address\-group that the alias maps to is
output instead.  If \*(lqalias\*(rq is terminated with a `;' instead of
a `:', then both the \*(lqalias\*(rq and the address are output in the
correct format.  (This makes replies possible since
.B nmh
aliases
and personal aliases are unknown to the mail transport system.)
.RE
.PP
Since the alias file is read line by line, forward references work, but
backward references are not recognized, thus, there is no recursion.
.PP
Example Alias File:
.PP
.RS 5
.nf
<%etcdir%/BBoardAliases
sgroup: fred, fear, freida
b-people: Blind List: bill, betty;
fred: frated@UCI
UNIX\-committee: <unix.aliases
staff: =staff
wheels: +wheel
everyone: *
news.*: news
.fi
.RE
.PP
The first line says that more aliases should immediately be read from
the file
.IR %etcdir%/BBoardAliases .
Following this, \*(lqfred\*(rq
is defined as an alias for \*(lqfrated@UCI\*(rq, and \*(lqsgroup\*(rq
is defined as an alias for the three names \*(lqfrated@UCI\*(rq,
\*(rqfear\*(rq, and \*(rqfreida\*(rq.
.PP
The alias \*(lqb-people\*(rq is a blind list which includes the addresses
\*(lqbill\*(rq and \*(lqbetty\*(rq; the message will be delieved to those
addresses, but the message header will  show only \*(lqBlind List: ;\*(rq
(not the addresses).
.PP
Next, the definition of \*(lqUNIX\-committee\*(rq is given by
reading the file
.I unix.aliases
in the users
.B nmh
directory,
\*(lqstaff\*(rq is defined as all users who are listed as members of the
group \*(lqstaff\*(rq in the
.I /etc/group
file, and \*(lqwheels\*(rq
is defined as all users whose group\-id in
.I /etc/passwd
is equivalent to the \*(lqwheel\*(rq group.
.PP
Finally, \*(lqeveryone\*(rq is defined as all users with a user\-id
in
.I /etc/passwd
greater than 200, and all aliases of the form
\*(lqnews.<anything>\*(rq are defined to be \*(lqnews\*(rq.
.PP
The key thing to understand about aliasing in
.B nmh
is that aliases in
.B nmh
alias files are expanded into the headers of messages posted.
This aliasing occurs first, at posting time, without the knowledge of the
message transport system.  In contrast, once the message transport system
is given a message to deliver to a list of addresses, for each address
that appears to be local, a system\-wide alias file is consulted.  These
aliases are
.B NOT
expanded into the headers of messages delivered.

.SH "HELPFUL HINTS"
To use aliasing in
.B nmh
quickly, do the following:
.PP
.RS 2
.IP 1) 3
In your
.IR \&.mh\(ruprofile ,
choose a name for your alias file, say
.RI \*(lq aliases \*(rq,
and add the line:
.PP
.RS 5
.nf
Aliasfile: aliases
.\" ali: \-alias aliases
.\" send: \-alias aliases
.\" whom: \-alias aliases
.fi
.RE
.PP
.IP 2) 3
Create the file
.RI \*(lq aliases \*(rq
in your
.B nmh
directory.
.PP
.IP 3) 3
Start adding aliases to your
.RI \*(lq aliases \*(rq
file as appropriate.
.RE

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^%etcdir%/MailAliases~^global nmh alias file
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Aliasfile:~^For a default alias file
.fi

.SH "SEE ALSO"
ali(1), send(1), whom(1), group(5), passwd(5), conflict(8), post(8)

.SH CONTEXT
None

.SH BUGS
Although the forward-referencing semantics of
.B mh\-alias
files prevent recursion, the
.RI \*(lq< " alias\-file" \*(rq
command may defeat this.
Since the number of file descriptors is finite (and very limited), such
infinite recursion will terminate with a meaningless diagnostic when
all the fds are used up.
.PP
Forward references do not work correctly inside blind lists.
