.\"
.\" %nmhwarning%
.\" $Id: comp.man,v 1.6 2001/01/25 21:15:53 ssen Exp $
.\"
.TH COMP %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
comp \- compose a message
.SH SYNOPSIS
.HP 5
.na
.B comp 
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-form
.IR formfile ]
.RB [ \-use " | " \-nouse ]
.RB [ \-file
.IR file ]
.RB [ \-draftfolder
.IR +folder ]
.RB [ \-draftmessage
.IR msg ]
.RB [ \-nodraftfolder ]
.RB [ \-editor
.IR editor ]
.RB [ \-noedit ]
.RB [ \-whatnowproc
.IR program ]
.RB [ \-nowhatnowproc ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B Comp
is used to create a new message to be mailed.  It copies a
message form to the draft being composed and then invokes an editor on
the draft (unless
.B \-noedit
is given, in which case the initial edit is suppressed).
.PP
The default message form contains the following elements:
.PP
.RS 5
.nf
%components%
.fi
.RE
.PP
If a file named
.RI \*(lq components \*(rq
exists in the user's nmh directory,
it will be used instead of this form.  You may specify an alternate
forms file with the switch
.B \-form
.IR formfile .
.PP
You may also start
.B comp
using the contents of an existing message
as the form.  If you supply either a
.I +folder
or
.I msg
argument, that
message will be used as the message form.  You may not supply both a
.B \-form
.I formfile
and a
.I +folder
or
.I msg
argument.  The line of
dashes or a blank line must be left between the header and the body of
the message for the message to be identified properly when it is sent
(see
.BR send (1)).
.PP
The switch
.B \-use
directs
.B comp
to continue editing an already
started message.  That is, if a
.B comp
(or
.BR dist ,
.BR repl ,
or
.BR forw )
is terminated without sending the draft, the draft can
be edited again via
.RB \*(lq comp
.BR \-use \*(rq.
.PP
The
.B \-file
.I file
switch says to use the named file as the message draft.
.PP
If the draft already exists,
.B comp
will ask you as to the disposition
of the draft.  A reply of
.B quit
will abort
.BR comp ,
leaving the draft intact;
.B replace
will replace the existing draft with
the appropriate form;
.B list
will display the draft;
.B use
will use the draft for further composition; and
.B refile
.I +folder
will file the draft in the given folder, and give you a new draft with the
appropriate form.  (The
.I +folder
argument to
.B refile
is required.)
.PP
The
.B \-draftfolder
.I +folder
and
.B \-draftmessage
.I msg
switches invoke the
.B nmh
draft folder facility.  This is an advanced (and highly
useful) feature.  Consult the
.BR mh-draft (5)
man page for more information.
.PP
The
.B \-editor
.I editor
switch indicates the editor to use for the
initial edit.  Upon exiting from the editor,
.B comp
will invoke the
.B whatnow
program.  See
.BR whatnow (1)
for a discussion of
available options.  The invocation of this program can be inhibited
by using the
.B \-nowhatnowproc
switch.  (In truth of fact, it is
the
.I whatnow
program which starts the initial edit.  Hence,
.B \-nowhatnowproc
will prevent any edit from occurring.)

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^%etcdir%/components~^The standard message skeleton
^or <mh\-dir>/components~^Rather than the standard skeleton
^$HOME/\&.mh\(ruprofile~^The user profile
^<mh\-dir>/draft~^The draft file
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Draft\-Folder:~^To find the default draft\-folder
^Editor:~^To override the default editor
^Msg\-Protect:~^To set mode when creating a new message (draft)
^fileproc:~^Program to refile the message
^whatnowproc:~^Program to ask the \*(lqWhat now?\*(rq questions
.fi

.SH "SEE ALSO"
dist(1), forw(1), repl(1), send(1), whatnow(1), mh-profile(5)

.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msg "' defaults to the current message"
.RB ` \-nodraftfolder '
.RB ` \-nouse '
.fi

.SH CONTEXT
None

.SH BUGS
If
.I whatnowproc
is
.BR whatnow ,
then
.B comp
uses a built\-in
.BR whatnow ,
it does not actually run the
.B whatnow
program.
Hence, if you define your own
.IR whatnowproc ,
don't call it
.B whatnow
since
.B comp
won't run it.
