.\"
.\" %nmhwarning%
.\" $Id: anno.man,v 1.8 2005/12/07 21:25:46 jon Exp $
.\"
.TH ANNO %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
anno \- annotate messages
.SH SYNOPSIS
.HP 5
.na
.B anno
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-component
.IR field ]
.RB [ \-inplace " | " \-noinplace ]
.RB [ \-date " | " \-nodate ]
.RB [ \-draft ]
.RB [ \-append ]
.RB [ \-list ]
.RB [ \-delete ]
.RB [ \-number
.IR [ num|all ]]
.RB [ \-preserve " | " \-nopreserve ]
.RB [ \-version ]
.RB [ \-help ]
.RB [ \-text
.IR body ]
.ad
.SH DESCRIPTION
.B Anno
manipulates header fields or
.I annotations
in messages.
Header fields consist of a field name and an optional field body
as defined by RFC-2822.
The
.B -component
option specifies the field name, and the
.B -text
option specifies the field body.
.PP
The messages are either the
.I msgs
in the named folder, or the draft if invoked with the
.B -draft
option.
.PP
Usually, annotation is performed by the commands
.BR dist ,
.BR forw ,
and
.BR repl ,
if they are given the
.B \-anno
switch.  This allows you to keep track of your distribution of,
forwarding of, and replies to a message.
.PP
By using
.BR anno ,
you can perform arbitrary annotations of your own.
Each message selected will be annotated with the lines
.PP
    field:\ date
    field:\ body
.PP
The
.B \-nodate
switch inhibits the date annotation, leaving only the
body annotation.
.PP
By default,
.B anno
prepends the annotations to the message.
Annotations are instead appended if the
.B -append
option is specified.
.PP
If a
.B \-component
.I field
is not specified when
.B anno
is invoked,
.B anno
will prompt the user for the name of field for the annotation.
.PP
The field specified must be a valid 2822-style message field name,
which means that it may only consist of alphanumerics and dashes,
The body specified is arbitrary text.
.PP
Normally
.B anno
does the annotation inplace in order to preserve
any links to the message.  You may change this by using the
.B \-noinplace
switch.
.PP
The
.B -list
option produces a listing of the field bodies for header fields with
names matching the specified component, one per line.
The listing is numbered, starting at 1, if the
.B -number
option is also used.
A tab character separates the number and the field body.
The field body is treated as if it is a file name, and only the final
path name component is listed.
The complete field body is listed if the
.B -text
option is used, the contents of the text are ignored.
.PP
The
.B -delete
option removes header fields from messages.
The first header field whose name matches the component is deleted if
no other options are specified.
If the
.B -text
option is used in conjunction with the
.B -delete
option, the first header field whose name matches the component and
whose body matches the text is deleted.
The text is treated as if it was a file name; if it begins with a
slash, the entire field body must match the text, otherwise just the
last path name component of the field body must match.
If the
.B -number
option is used in conjuction with the
.B -delete
option, header field
.I num
whose name matches the component is deleted.
The number matches that which is produced by the
.B -list
option.
The special value
.B all
can be used for the number, and causes all components that match the
name to be deleted.
.PP
By default,
.B anno
changes the last-accessed and last-modified times on annotate messages
to the time at which the annotation occurs.
.B Anno
preserves the original times if the
.B -preserve
option is used.
A matching
.B -nopreserve
option exists that allows time preservation to be turned off if enabled
in the profile.
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
.fi

.SH "SEE ALSO"
dist(1), forw(1), repl(1)

.SH DEFAULTS
.nf
.RI ` +folder "' defaults to the current folder"
.RI ` msgs "' defaults to cur"
.RB ` \-inplace '
.RB ` \-date '
.fi

.SH CONTEXT
If a folder is given, it will become the current folder.  The first
message annotated will become the current message.
