/* $Id: xdr.h,v 1.8 2004/12/22 23:15:04 ali Exp $
 * Copyright (C) 2001, 2002, 2003  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#if __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#ifndef NHPROXY_XDR_H
#define NHPROXY_XDR_H

#ifdef __cplusplus
extern "C" {
#endif

#define NHPROXY_XDR_RNDUP(x)	(((x) - 1 | 3) + 1)

typedef enum { nhproxy_false = 0, nhproxy_true = 1 } nhproxy_bool_t;

typedef enum {
    NHPROXY_XDR_ENCODE, NHPROXY_XDR_DECODE, NHPROXY_XDR_FREE, NHPROXY_XDR_COUNT
} nhproxy_xdr_op_t;

typedef struct nhproxy_xdr {
    nhproxy_genericptr_t x_data;
    nhproxy_xdr_op_t x_op;
    nhproxy_bool_t (*x_write)(struct nhproxy_xdr *xdrs,
      const nhproxy_genericptr_t addr, int size);
    nhproxy_bool_t (*x_read)(struct nhproxy_xdr *xdrs,
      nhproxy_genericptr_t addr, int size);
    void (*x_destroy)(struct nhproxy_xdr *xdrs);
    unsigned int x_pos, x_size;
} NhProxyXdr;

typedef struct NhProxyIO_ NhProxyIO;
typedef int (*nhproxy_io_func)(nhproxy_genericptr_t handle,
  nhproxy_genericptr_t buf, unsigned int len);
typedef struct NhProxyNB_ NhProxyNB;

extern unsigned int NHPROXY_FDECL(nhproxy_xdr_getpos, (NhProxyXdr *xdrs));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_setpos,
  (NhProxyXdr *xdrs, unsigned int pos));
extern void NHPROXY_FDECL(nhproxy_xdr_free, (nhproxy_bool_t (*codec)(),
  char *addr));
extern void NHPROXY_FDECL(nhproxy_xdrmem_create, (NhProxyXdr *xdrs, char *addr,
  unsigned int size, nhproxy_xdr_op_t op));
extern void NHPROXY_FDECL(nhproxy_xdrio_create, (NhProxyXdr *xdrs,
  NhProxyIO *io, nhproxy_xdr_op_t op));

#define nhproxy_xdr_destroy(xdrs)	(*(xdrs)->x_destroy)(xdrs)

extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_long, (NhProxyXdr *xdrs,
  long *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_u_long, (NhProxyXdr *xdrs,
  unsigned long *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_short, (NhProxyXdr *xdrs,
  short *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_u_short, (NhProxyXdr *xdrs,
  unsigned short *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_int, (NhProxyXdr *xdrs,
  int *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_u_int, (NhProxyXdr *xdrs,
  unsigned int *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_char, (NhProxyXdr *xdrs,
  char *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_u_char, (NhProxyXdr *xdrs,
  unsigned char *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_enum, (NhProxyXdr *xdrs,
  int *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_bool, (NhProxyXdr *xdrs,
  nhproxy_bool_t *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_string, (NhProxyXdr *xdrs,
  char **datum, unsigned int maxsize));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_bytes, (NhProxyXdr *xdrs,
  char **datum, unsigned int *len, unsigned int maxlen));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_wrapstring, (NhProxyXdr *xdrs,
  char **datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_vector, (NhProxyXdr *xdrs,
  char *addr, unsigned int len, unsigned int size, nhproxy_bool_t (*codec)()));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_array, (NhProxyXdr *xdrs,
  char **addr, unsigned int *len, unsigned int maxlen, unsigned int size,
  nhproxy_bool_t (*codec)()));

#define NHPROXY_IO_RDONLY		1
#define NHPROXY_IO_WRONLY		2
#define NHPROXY_IO_NBLOCK		4
#define NHPROXY_IO_NOAUTOFILL	8
#define NHPROXY_IO_LINEBUF	16	/* Only honoured by text based calls */
#define NHPROXY_IO_SIMPLEBUFFER	32
#define NHPROXY_IO_PENDING	64

extern NhProxyIO *NHPROXY_FDECL(nhproxy_io_open, (nhproxy_io_func func,
  nhproxy_genericptr_t handle, unsigned int flags));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_io_close, (NhProxyIO *io));
extern unsigned int NHPROXY_FDECL(nhproxy_io_getmode, (NhProxyIO *io));
extern void NHPROXY_FDECL(nhproxy_io_setmode, (NhProxyIO *io,
  unsigned int flags));
extern void NHPROXY_FDECL(nhproxy_io_setautofill_limit, (NhProxyIO *io,
  unsigned int limit));
extern void NHPROXY_FDECL(nhproxy_io_setnbfunc, (NhProxyIO *io,
  nhproxy_io_func func));
extern int NHPROXY_FDECL(nhproxy_io_filbuf, (NhProxyIO *io,
  nhproxy_bool_t blocking));
extern int NHPROXY_FDECL(nhproxy_io_getc, (NhProxyIO *io));
extern int NHPROXY_FDECL(nhproxy_io_read, (NhProxyIO *io, char *buf, int nb));
extern int NHPROXY_FDECL(nhproxy_io_fread, (nhproxy_genericptr_t buffer,
  int size, int nmemb, NhProxyIO *io));
extern char *NHPROXY_FDECL(nhproxy_io_getpacket, (NhProxyIO *io, int *nb));
extern int NHPROXY_FDECL(nhproxy_io_willblock, (NhProxyIO *io));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_io_flush, (NhProxyIO *io));
extern int NHPROXY_FDECL(nhproxy_io_fputc, (int c, NhProxyIO *io));
extern int NHPROXY_FDECL(nhproxy_io_write, (NhProxyIO *io, char *buf, int nb));
extern int NHPROXY_FDECL(nhproxy_io_writet, (NhProxyIO *io, char *buf, int nb));
extern int NHPROXY_FDECL(nhproxy_io_vprintf, (NhProxyIO *io, char *fmt,
  va_list ap));

#if __GNUC__ >= 3 || __GNUC__ == 2 && __GNUC_MINOR__ >= 5
#define NHPROXY__PRINTF(p_fmt, p_arg0) \
	__attribute__((format(printf, p_fmt, p_arg0)))
#else
#define NHPROXY__PRINTF(p_fmt, p_arg0)
#endif

extern int NHPROXY_VDECL(nhproxy_io_printf, (NhProxyIO *io, char *fmt, ...))
  NHPROXY__PRINTF(2, 3);

extern NhProxyNB *NHPROXY_FDECL(nhproxy_nb_open, (nhproxy_io_func func,
  nhproxy_genericptr_t handle));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_nb_close, (NhProxyNB *nb));
extern int NHPROXY_FDECL(nhproxy_nb_read, (NhProxyNB *nb, char *buf, int bytes,
  int blocking));

#ifdef __cplusplus
}
#endif

#endif /* NHPROXY_XDR_H */
