/* $Id: compat.h,v 1.1 2004/12/22 23:15:03 ali Exp $
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#ifndef COMPAT_H
#define COMPAT_H

#ifndef FALSE
#define FALSE 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef MIN
#define MIN(a, b)	((a) <= (b) ? (a) : (b))
#endif

#ifndef MAX
#define MAX(a, b)	((a) >= (b) ? (a) : (b))
#endif

#ifndef SIZE
#define SIZE(array)	(sizeof(array) / sizeof(*(array)))
#endif

#include <stdio.h>
#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
# define MEMZERO(d, n) memset(d, 0, n)
#else	/* STDC_HEADERS */
# if !HAVE_STRCHR
#  define strchr index
#  define strrchr rindex
# endif
char *strchr();
char *strrchr();
# if !HAVE_MEMCPY
#  define memcpy(d, s, n) bcopy(s, d, n)
#  define memmove(d, s, n) bcopy(s, d, n)
# endif
# if HAVE_MEMSET
#  define MEMZERO(d, n) memset(d, 0, n)
# else
#  define MEMZERO(d, n) bzero(d, n)
# endif
char *strdup();
#endif	/* STDC_HEADERS */

#if HAVE_STDARG_H
# include <stdarg.h>
# define VA_START(a, f)		va_start(a, f)
#else
# if HAVE_VARARGS_H
#  include <varargs.h>
#  define VA_START(a, f)	va_start(a)
# endif
#endif

#endif /* COMPAT_H */
