/* $Id: compat.c,v 1.1 2004/12/22 23:15:03 ali Exp $
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#include "config.h"
#include "compat.h"

#if !HAVE_STRDUP
char *
strdup(s)
char *s;
{
    char *dupl;
    if (s) {
	dupl = malloc(strlen(s) + 1);
	if (dupl)
	    strcpy(dupl, s);
    } else
	dupl = (char *)0;
    return dupl;
}
#endif

#if !HAVE_STRERROR
#include <errno.h>

extern const char *sys_errlist[];
extern int sys_nerr;

#define LOG2	0.30103

char *
strerror(errnum)
int errnum;
{
    static char buf[8+(int)(LOG2*8*sizeof(int))];	/* Error -####\0 */
    if (errnum < 0 || errnum >= sys_nerr) {
	sprintf(buf, "Error %d", errnum);
	return buf;
    } else
	return sys_errlist[errnum];
}
#endif
