/* $Id: common.h,v 1.18 2004/12/22 23:15:03 ali Exp $
 * Copyright (C) 2002, 2003, 2004  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#ifndef NHPROXY_COMMON_H
#define NHPROXY_COMMON_H

#ifdef __cplusplus
extern "C" {
#endif

/* The NhExt standard to which we conform */

#define NHPROXY_EXT_STANDARD_MAJOR	1
#define NHPROXY_EXT_STANDARD_MINOR	0
#define NHPROXY_EXT_STANDARD_MICRO	2	/* Not used in the code */

#define NHPROXY_EXT_IM_STATUS		0x0001
#define NHPROXY_EXT_IM_DISPLAY_LAYERS	0x0002

#define NHPROXY_EXT_NHW_MESSAGE		1
#define NHPROXY_EXT_NHW_STATUS		2
#define NHPROXY_EXT_NHW_MAP		3
#define NHPROXY_EXT_NHW_MENU		4
#define NHPROXY_EXT_NHW_TEXT		5

#define NHPROXY_EXT_ATR_NONE		0
#define NHPROXY_EXT_ATR_BOLD		1
#define NHPROXY_EXT_ATR_DIM		2
#define NHPROXY_EXT_ATR_ULINE		4
#define NHPROXY_EXT_ATR_BLINK		5
#define NHPROXY_EXT_ATR_INVERSE		7

#define NHPROXY_PARAM_INT	0x4001
#define NHPROXY_PARAM_LONG	0x4002
#define NHPROXY_PARAM_STRING	0x4003
#define NHPROXY_PARAM_BYTES	0x4004
#define NHPROXY_PARAM_BOOLEAN	0x4005
#define NHPROXY_PARAM_CHAR	0x4006
#define NHPROXY_PARAM_XDRF	0x4007

#define NHPROXY_PARAM_PTR	0x8000

#define NHPROXY_INT(i)		NHPROXY_PARAM_INT, i
#define NHPROXY_LONG(l)		NHPROXY_PARAM_LONG, l
#define NHPROXY_STRING(s)	NHPROXY_PARAM_STRING, (s) ? (s) : ""
#define NHPROXY_BYTES(buf, nb)	NHPROXY_PARAM_BYTES, buf, nb
#define NHPROXY_BOOLEAN(b)	NHPROXY_PARAM_BOOLEAN, b
#define NHPROXY_CHAR(c)		NHPROXY_PARAM_CHAR, c
#define NHPROXY_XDRF(func, data)	NHPROXY_PARAM_XDRF, func, data

#define NHPROXY_INT_PTR(i)	NHPROXY_PARAM_PTR | NHPROXY_PARAM_INT, &(i)
#define NHPROXY_LONG_PTR(l)	NHPROXY_PARAM_PTR | NHPROXY_PARAM_LONG, &(l)
#define NHPROXY_STRING_PTR(s)	NHPROXY_PARAM_PTR | NHPROXY_PARAM_STRING, &(s)
#define NHPROXY_BYTES_PTR(buf, nb)	NHPROXY_PARAM_PTR | \
					NHPROXY_PARAM_BYTES, &(buf), &(nb)
#define NHPROXY_BOOLEAN_PTR(b)	NHPROXY_PARAM_PTR | NHPROXY_PARAM_BOOLEAN, &(b)
#define NHPROXY_CHAR_PTR(c)	NHPROXY_PARAM_PTR | NHPROXY_PARAM_CHAR, &(c)

#define NHPROXY_SPECIAL_ERROR			0

#define NHPROXY_ERROR_EXT_UNSUPPORTED		1
#define NHPROXY_ERROR_EXT_UNAVAILABLE		2
#define NHPROXY_ERROR_EXT_INVALIDENCODING	3
#define NHPROXY_ERROR_EXT_INVALIDPARAMS		4
#define NHPROXY_ERROR_EXT_RESOURCEFAILURE	5

#define NHPROXY_ERROR_GENERIC			0x100

#define NHPROXY_ERROR_INTERNAL			0x101
#define NHPROXY_ERROR_COMMS			0x102
#define NHPROXY_ERROR_NOTSUPPORTED		0x103
#define NHPROXY_ERROR_PROTOCOL			0x104

#ifdef NHPROXY_XDR_H
struct nhproxy_rpc_services {
    unsigned short id;
    void NHPROXY_FDECL((*handler), (unsigned short, NhProxyXdr *,
      NhProxyXdr *));
};

struct nhproxy_line {
    char *type;
    int n;
    char **tags, **values;
};

typedef void NHPROXY_FDECL((*nhproxy_rpc_errhandler), (int type,
  const char *error));

extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_rpc_init, (NhProxyIO *rd,
  NhProxyIO *wr, struct nhproxy_rpc_services *cb));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_rpc_set_protocol, (int protocol));
extern nhproxy_bool_t NHPROXY_NDECL(nhproxy_rpc_async_mode);
extern void NHPROXY_NDECL(nhproxy_rpc_end);
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_subprotocol0_write_line,
  (struct nhproxy_line *line));
extern void NHPROXY_FDECL(nhproxy_subprotocol0_free_line,
  (struct nhproxy_line *line));
extern struct nhproxy_line *NHPROXY_NDECL(nhproxy_subprotocol0_read_line);
extern char *NHPROXY_FDECL(nhproxy_subprotocol0_get_failed_packet, (int *nb));
extern nhproxy_rpc_errhandler NHPROXY_FDECL(nhproxy_rpc_set_errhandler,
  (nhproxy_rpc_errhandler new));
extern nhproxy_bool_t NHPROXY_VDECL(nhproxy_rpc_params, (NhProxyXdr *xdrs,
  int no, ...));
extern nhproxy_bool_t NHPROXY_VDECL(nhproxy_rpc, (unsigned short id, ...));
extern int NHPROXY_FDECL(nhproxy_rpc_svc,
  (struct nhproxy_rpc_services *services));
extern void NHPROXY_FDECL(nhproxy_rpc_set_async_masks, (int n,
  unsigned long *masks));
extern void NHPROXY_FDECL(nhproxy_rpc_set_unsupported, (int id));
extern unsigned short NHPROXY_NDECL(nhproxy_rpc_get_next_serial);
extern unsigned short NHPROXY_NDECL(nhproxy_rpc_svc_get_serial);
extern void NHPROXY_FDECL(nhproxy_rpc_send_error,
  (unsigned short id, unsigned char error_code));
#endif	/* NHPROXY_XDR_H */

#define NHPROXY_EXT_FID_INIT			0x01
#define NHPROXY_EXT_FID_INIT_NHWINDOWS		0x02
#define NHPROXY_EXT_FID_PLAYER_SELECTION	0x03
#define NHPROXY_EXT_FID_ASKNAME			0x04
#define NHPROXY_EXT_FID_GET_NH_EVENT		0x05
#define NHPROXY_EXT_FID_EXIT_NHWINDOWS		0x06
#define NHPROXY_EXT_FID_SUSPEND_NHWINDOWS	0x07
#define NHPROXY_EXT_FID_RESUME_NHWINDOWS	0x08
#define NHPROXY_EXT_FID_CREATE_NHWINDOW		0x09
#define NHPROXY_EXT_FID_CLEAR_NHWINDOW		0x0A
#define NHPROXY_EXT_FID_DISPLAY_NHWINDOW	0x0B
#define NHPROXY_EXT_FID_DESTROY_NHWINDOW	0x0C
#define NHPROXY_EXT_FID_CURS			0x0D
#define NHPROXY_EXT_FID_PUTSTR			0x0E
#define NHPROXY_EXT_FID_DISPLAY_FILE		0x0F
#define NHPROXY_EXT_FID_START_MENU		0x10
#define NHPROXY_EXT_FID_ADD_MENU		0x11
#define NHPROXY_EXT_FID_END_MENU		0x12
#define NHPROXY_EXT_FID_SELECT_MENU		0x13
#define NHPROXY_EXT_FID_MESSAGE_MENU		0x14
#define NHPROXY_EXT_FID_UPDATE_INVENTORY	0x15
#define NHPROXY_EXT_FID_MARK_SYNC		0x16
#define NHPROXY_EXT_FID_WAIT_SYNC		0x17
#define NHPROXY_EXT_FID_CLIPAROUND		0x18
#define NHPROXY_EXT_FID_UPDATE_POSITIONBAR	0x19
#define NHPROXY_EXT_FID_PRINT_GLYPH		0x1A
#define NHPROXY_EXT_FID_RAW_PRINT		0x1B
#define NHPROXY_EXT_FID_RAW_PRINT_BOLD		0x1C
#define NHPROXY_EXT_FID_NHGETCH			0x1D
#define NHPROXY_EXT_FID_NH_POSKEY		0x1E
#define NHPROXY_EXT_FID_NHBELL			0x1F
#define NHPROXY_EXT_FID_DOPREV_MESSAGE		0x20
#define NHPROXY_EXT_FID_YN_FUNCTION		0x21
#define NHPROXY_EXT_FID_GETLIN			0x22
#define NHPROXY_EXT_FID_GET_EXT_CMD		0x23
#define NHPROXY_EXT_FID_NUMBER_PAD		0x24
#define NHPROXY_EXT_FID_DELAY_OUTPUT		0x25
#define NHPROXY_EXT_FID_CHANGE_COLOR		0x26
#define NHPROXY_EXT_FID_CHANGE_BACKGROUND	0x27
#define NHPROXY_EXT_FID_SET_FONT_NAME		0x28
#define NHPROXY_EXT_FID_GET_COLOR_STRING	0x29
#define NHPROXY_EXT_FID_START_SCREEN		0x2A
#define NHPROXY_EXT_FID_END_SCREEN		0x2B
#define NHPROXY_EXT_FID_OUTRIP			0x2C
#define NHPROXY_EXT_FID_PREFERENCE_UPDATE	0x2D
#define NHPROXY_EXT_FID_STATUS			0x2E
#define NHPROXY_EXT_FID_PRINT_GLYPH_LAYERED	0x2F
#define NHPROXY_EXT_FID_SEND_CONFIG_FILE	0x30

#ifdef NHPROXY_XDR_H
struct nhproxy_init_nhwindow_req {
    int argc;
    char **argv;
};

struct nhproxy_init_nhwindow_res {
    nhproxy_bool_t inited;
    int argc;
    char **argv;
    int capc;
    char **capv;
};

struct nhproxy_mi {
    int item;			/* identifier */
    long count;			/* count */
};

struct nhproxy_select_menu_res {
    int retval;
    int n;
    struct nhproxy_mi *selected;
};

struct nhproxy_status_req {
    int reconfig;
    int nv;
    const char **values;
};

struct nhproxy_glyph_row {
    int start;
    int ng;
    int *glyphs;
};

struct nhproxy_glyph_layer {
    int start;
    int nr;
    struct nhproxy_glyph_row *rows;
};

struct nhproxy_print_glyph_layered_req {
    int window;
    int nl;
    struct nhproxy_glyph_layer *layers;
};

extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_init_nhwindow_req,
  (NhProxyXdr *xdrs, struct nhproxy_init_nhwindow_req *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_init_nhwindow_res,
  (NhProxyXdr *xdrs, struct nhproxy_init_nhwindow_res *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_proxy_mi,
  (NhProxyXdr *xdrs, struct nhproxy_mi *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_select_menu_res,
  (NhProxyXdr *xdrs, struct nhproxy_select_menu_res *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_glyph_row, (NhProxyXdr *xdr,
  struct nhproxy_glyph_row *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_glyph_layer, (NhProxyXdr *xdr,
  struct nhproxy_glyph_layer *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_status_req,
  (NhProxyXdr *xdrs, struct nhproxy_status_req *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_xdr_print_glyph_layered_req,
  (NhProxyXdr *xdrs, struct nhproxy_print_glyph_layered_req *datum));
#endif	/* NHPROXY_XDR_H */

#define NHPROXY_EXT_CID_DISPLAY_INVENTORY	0x01
#define NHPROXY_EXT_CID_DLBH_FOPEN		0x02
#define NHPROXY_EXT_CID_DLBH_FGETS		0x03
#define NHPROXY_EXT_CID_DLBH_FREAD		0x04
#define NHPROXY_EXT_CID_DLBH_FWRITE		0x05
#define NHPROXY_EXT_CID_DLBH_FCLOSE		0x06
#define NHPROXY_EXT_CID_DLBH_FMD5SUM		0x07
#define NHPROXY_EXT_CID_FLUSH_SCREEN		0x08
#define NHPROXY_EXT_CID_DOREDRAW		0x09
#define NHPROXY_EXT_CID_INTERFACE_MODE		0x0A
#define NHPROXY_EXT_CID_PARSE_OPTIONS		0x0B
#define NHPROXY_EXT_CID_GET_OPTION		0x0C
#define NHPROXY_EXT_CID_GET_PLAYER_CHOICES	0x0D
#define NHPROXY_EXT_CID_GET_VALID_SELECTIONS	0x0E
#define NHPROXY_EXT_CID_QUIT_GAME		0x0F
#define NHPROXY_EXT_CID_DISPLAY_SCORE		0x10
#define NHPROXY_EXT_CID_DOSET			0x11
#define NHPROXY_EXT_CID_GET_EXTENDED_COMMANDS	0x12
#define NHPROXY_EXT_CID_MAP_MENU_CMD		0x13
#define NHPROXY_EXT_CID_GET_STANDARD_WINID	0x14
#define NHPROXY_EXT_CID_GET_TILESETS		0x15
#define NHPROXY_EXT_CID_GET_GLYPH_MAPPING	0x16
#define NHPROXY_EXT_CID_GET_EXTENSIONS		0x17
#define NHPROXY_EXT_CID_SET_OPTION_MOD_STATUS	0x18

#ifdef NHPROXY_XDR_H
struct nhproxy_cb_get_player_choices_res_role {
    const char *male;
    const char *female;
};

struct nhproxy_cb_get_player_choices_res {
    int n_aligns;
    const char **aligns;
    int n_genders;
    const char **genders;
    int n_races;
    const char **races;
    int n_roles;
    struct nhproxy_cb_get_player_choices_res_role *roles;
};

struct nhproxy_cb_get_valid_selections_res {
    int no_roles;
    int no_races;
    int no_aligns;
    int no_genders;
    int n_masks;
    unsigned long *masks;
};

struct nhproxy_cb_get_extended_commands_res {
    int n_commands;
    const char **commands;
};

struct nhproxy_cb_get_tilesets_res_tileset {
    const char *name;
    const char *file;
    const char *mapfile;
    unsigned long flags;
};

struct nhproxy_cb_get_tilesets_res {
    int n_tilesets;
    struct nhproxy_cb_get_tilesets_res_tileset *tilesets;
};

#define NHPROXY_RGB_SYM(rgb, sym)	((rgb) << 8 | (sym))
#define NHPROXY_RGBSYM_RGB(rgbsym)	((rgbsym) >> 8 & 0xFFFFFF)
#define NHPROXY_RGBSYM_SYM(rgbsym)	((rgbsym) & 0xFF)

struct nhproxy_cb_get_glyph_mapping_res_symdef {
    long rgbsym;
    const char *description;
};

struct nhproxy_cb_get_glyph_mapping_res_submapping {
    struct nhproxy_cb_get_glyph_mapping_res_symdef symdef;
    int n_glyphs;
    struct nhproxy_cb_get_glyph_mapping_res_symdef *glyphs;
};

struct nhproxy_cb_get_glyph_mapping_res_mapping {
    const char *flags;
    int base_mapping;
    int alt_glyph;
    struct nhproxy_cb_get_glyph_mapping_res_symdef symdef;
    int n_submappings;
    struct nhproxy_cb_get_glyph_mapping_res_submapping *submappings;
};

struct nhproxy_cb_get_glyph_mapping_res {
    int no_glyph;
    long transparent;
    int n_mappings;
    struct nhproxy_cb_get_glyph_mapping_res_mapping *mappings;
};

struct nhproxy_cb_get_extensions_res_extension {
    const char *name;
    const char *version;
    int no_procedures;
};

struct nhproxy_cb_get_extensions_res {
    int n_extensions;
    struct nhproxy_cb_get_extensions_res_extension *extensions;
};

/* This structure is used for both the sub-protocol 2 init request and reply */
struct nhproxy_cb_subprot2_init {
    int n_masks;
    unsigned long *masks;
};

extern nhproxy_bool_t NHPROXY_FDECL(
  nhproxy_cb_xdr_get_player_choices_res_role,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_player_choices_res_role *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_cb_xdr_get_player_choices_res,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_player_choices_res *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_cb_xdr_get_valid_selections_res,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_valid_selections_res *datum));
extern nhproxy_bool_t NHPROXY_FDECL(
  nhproxy_cb_xdr_get_extended_commands_res,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_extended_commands_res *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_cb_xdr_get_tilesets_res_tileset,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_tilesets_res_tileset *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_cb_xdr_get_tilesets_res,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_tilesets_res *datum));
extern nhproxy_bool_t NHPROXY_FDECL(
  nhproxy_cb_xdr_get_glyph_mapping_res_symdef,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_glyph_mapping_res_symdef *datum));
extern nhproxy_bool_t NHPROXY_FDECL(
  nhproxy_cb_xdr_get_glyph_mapping_res_submapping, (NhProxyXdr *xdrs,
  struct nhproxy_cb_get_glyph_mapping_res_submapping *datum));
extern nhproxy_bool_t NHPROXY_FDECL(
  nhproxy_cb_xdr_get_glyph_mapping_res_mapping,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_glyph_mapping_res_mapping *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_cb_xdr_get_glyph_mapping_res,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_glyph_mapping_res *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_cb_xdr_get_extensions_res_extension,
  (NhProxyXdr *xdr, struct nhproxy_cb_get_extensions_res_extension *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_cb_xdr_get_extensions_res,
  (NhProxyXdr *xdrs, struct nhproxy_cb_get_extensions_res *datum));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_cb_xdr_subprot2_init,
  (NhProxyXdr *xdrs, struct nhproxy_cb_subprot2_init *datum));
#endif  /* NHPROXY_XDR_H */

typedef void NHPROXY_FDECL((*nhproxy_errhandler), (const char *error));
extern nhproxy_errhandler NHPROXY_FDECL(nhproxy_set_errhandler,
  (nhproxy_errhandler new));
#ifdef NHPROXY__PRINTF
extern void NHPROXY_VDECL(nhproxy_error, (const char *fmt, ...))
  NHPROXY__PRINTF(1, 2);
#else
extern void NHPROXY_VDECL(nhproxy_error, (const char *fmt, ...));
#endif

#ifdef __cplusplus
}
#endif

#endif /* NHPROXY_COMMON_H */
