/* $Id: client.c,v 1.28 2004/12/22 23:15:03 ali Exp $
 * Copyright (C) 2001, 2002, 2003, 2004  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

/* #define DEBUG */
/* #define DEBUG_RPC */		/* Log RPC calls to stderr */

#include "config.h"
#include "compat.h"
#if STDC_HEADERS
#include <stdarg.h>
#endif
#ifdef MSWIN_API
#include <io.h>
#include <windows.h>
#include <commctrl.h>
#endif
#include <nhproxy/system.h>
#include <nhproxy/xdr.h>
#include <nhproxy/common.h>
#include <nhproxy/clientcb.h>
#include <nhproxy/client.h>

static void NHPROXY_NDECL((*nhproxy_ini));	/* optional (can be 0) */
static struct nhproxy_clnt_ext_procs *nhproxy_clnt;

int nhproxy_clnt_ver_major, nhproxy_clnt_ver_minor, nhproxy_clnt_protocol;

NhProxyIO *nhproxy_clnt_log = NULL;
unsigned long nhproxy_clnt_flags = 0;

/*
 * The proxy svc module provides a set of service functions (ie., suitable
 * to act as handlers for nhproxy_rpc_svc()). These service functions decode the
 * incoming parameters; call the relevant windowing interface ext function;
 * and then encode the results.
 */

static void NHPROXY_FDECL(nhproxy_clnt_init, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_init_nhwindows, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_player_selection, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_askname, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_get_nh_event, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_exit_nhwindows, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_suspend_nhwindows, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_resume_nhwindows, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_create_nhwindow, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_clear_nhwindow, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_display_nhwindow, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_destroy_nhwindow, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_curs, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_putstr, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_display_file, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_start_menu, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_add_menu, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_end_menu, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_select_menu, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_message_menu, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_update_inventory, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_mark_synch, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_wait_synch, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_cliparound, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_update_positionbar, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_print_glyph, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_raw_print, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_raw_print_bold, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_nhgetch, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_nh_poskey, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_nhbell, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_doprev_message, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_yn_function, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_getlin, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_get_ext_cmd, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_number_pad, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_delay_output, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_change_color, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_change_background, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_set_font_name, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_get_color_string, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_start_screen, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_end_screen, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_outrip, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_preference_update, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_status, (unsigned short, NhProxyXdr *,
  NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_print_glyph_layered, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));
static void NHPROXY_FDECL(nhproxy_clnt_send_config_file, (unsigned short,
  NhProxyXdr *, NhProxyXdr *));

static unsigned long async_procedures[] = {
    1 << NHPROXY_EXT_FID_GET_NH_EVENT - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_EXIT_NHWINDOWS - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_SUSPEND_NHWINDOWS - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_RESUME_NHWINDOWS - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_CLEAR_NHWINDOW - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_DISPLAY_NHWINDOW - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_DESTROY_NHWINDOW - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_CURS - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_PUTSTR - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_START_MENU - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_ADD_MENU - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_END_MENU - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_UPDATE_INVENTORY - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_MARK_SYNC - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_WAIT_SYNC - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_CLIPAROUND - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_UPDATE_POSITIONBAR - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_PRINT_GLYPH - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_RAW_PRINT - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_RAW_PRINT_BOLD - NHPROXY_EXT_FID_INIT |
      1 << NHPROXY_EXT_FID_NHBELL - NHPROXY_EXT_FID_INIT,
    1 << NHPROXY_EXT_FID_NUMBER_PAD - NHPROXY_EXT_FID_YN_FUNCTION |
      1 << NHPROXY_EXT_FID_DELAY_OUTPUT - NHPROXY_EXT_FID_YN_FUNCTION |
      1 << NHPROXY_EXT_FID_CHANGE_COLOR - NHPROXY_EXT_FID_YN_FUNCTION |
      1 << NHPROXY_EXT_FID_CHANGE_BACKGROUND - NHPROXY_EXT_FID_YN_FUNCTION |
      1 << NHPROXY_EXT_FID_START_SCREEN - NHPROXY_EXT_FID_YN_FUNCTION |
      1 << NHPROXY_EXT_FID_END_SCREEN - NHPROXY_EXT_FID_YN_FUNCTION |
      1 << NHPROXY_EXT_FID_PREFERENCE_UPDATE - NHPROXY_EXT_FID_YN_FUNCTION |
      1 << NHPROXY_EXT_FID_STATUS - NHPROXY_EXT_FID_YN_FUNCTION |
      1 << NHPROXY_EXT_FID_PRINT_GLYPH_LAYERED - NHPROXY_EXT_FID_YN_FUNCTION,
};

static void
nhproxy_clnt_init(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int i;
    struct nhproxy_cb_subprot2_init async_request, async_reply;
    if (nhproxy_clnt_protocol > 1) {
	async_request.masks = (unsigned long *)0;
	nhproxy_rpc_params(request, 1,
	  NHPROXY_XDRF(nhproxy_cb_xdr_subprot2_init, &async_request));
	if (nhproxy_clnt_log) {
	    nhproxy_io_printf(nhproxy_clnt_log, "[%u] init(<",
	      nhproxy_rpc_svc_get_serial());
	    for(i = 0; i < async_request.n_masks; i++) {
		if (i)
		    nhproxy_io_printf(nhproxy_clnt_log, ", ");
		nhproxy_io_printf(nhproxy_clnt_log, "0x%08lX",
		  async_request.masks[i]);
	    }
	    nhproxy_io_printf(nhproxy_clnt_log, ">)\n");
	}
	nhproxy_rpc_set_async_masks(async_request.n_masks, async_request.masks);
	free(async_request.masks);
    } else if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] init()\n",
	  nhproxy_rpc_svc_get_serial());
    if (nhproxy_ini)
	(*nhproxy_ini)();
    if (nhproxy_clnt_protocol > 1) {
	async_reply.n_masks = SIZE(async_procedures);
	async_reply.masks = async_procedures;
	if (nhproxy_clnt_log) {
	    nhproxy_io_printf(nhproxy_clnt_log, "[%u] init = <",
	      nhproxy_rpc_svc_get_serial());
	    for(i = 0; i < async_reply.n_masks; i++) {
		if (i)
		    nhproxy_io_printf(nhproxy_clnt_log, ", ");
		nhproxy_io_printf(nhproxy_clnt_log, "0x%08lX",
		  async_reply.masks[i]);
	    }
	    nhproxy_io_printf(nhproxy_clnt_log, ">\n");
	}
	nhproxy_rpc_params(reply, 1,
	  NHPROXY_XDRF(nhproxy_cb_xdr_subprot2_init, &async_reply));
    } else
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_init_nhwindows(id, request, reply)
unsigned short id; 
NhProxyXdr *request, *reply;
{
    int i;
    struct nhproxy_init_nhwindow_req req = { 0, (char **)0 };
    struct nhproxy_init_nhwindow_res res;
    nhproxy_rpc_params(request, 1, NHPROXY_XDRF(nhproxy_xdr_init_nhwindow_req,
      &req));
    if (nhproxy_clnt_log) {
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] init_nhwindows(<",
	  nhproxy_rpc_svc_get_serial());
	for(i = 0; i < req.argc; i++) {
	    if (i)
		nhproxy_io_printf(nhproxy_clnt_log, ", ");
	    nhproxy_io_printf(nhproxy_clnt_log, "%#s",
	      req.argv[i]);
	}
	nhproxy_io_printf(nhproxy_clnt_log, ">)\n");
    }
    res.argc = req.argc;
    res.argv = req.argv;
    res.capc = 0;
    res.capv = (char **)0;
    res.inited =
      (*nhproxy_clnt->winext_init_nhwindows)(&res.argc, res.argv, &res.capv);
    if (res.capv)
	for(res.capc = 0; res.capv[res.capc]; res.capc++)
	    ;
    if (nhproxy_clnt_log) {
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] init_nhwindows = %s, <",
	  nhproxy_rpc_svc_get_serial(), res.inited ? "TRUE" : "FALSE");
	for(i = 0; i < res.argc; i++) {
	    if (i)
		nhproxy_io_printf(nhproxy_clnt_log, ", ");
	    nhproxy_io_printf(nhproxy_clnt_log, "%#s",
	      res.argv[i]);
	}
	nhproxy_io_printf(nhproxy_clnt_log, ">, <");
	for(i = 0; i < res.capc; i++) {
	    if (i)
		nhproxy_io_printf(nhproxy_clnt_log, ", ");
	    nhproxy_io_printf(nhproxy_clnt_log, "%#s",
	      res.capv[i]);
	}
	nhproxy_io_printf(nhproxy_clnt_log, ">\n");
    }
    nhproxy_rpc_params(reply, 1, NHPROXY_XDRF(nhproxy_xdr_init_nhwindow_res,
      &res));
}

static void
nhproxy_clnt_player_selection(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int role, race, gend, align;
    nhproxy_bool_t quit;
    nhproxy_rpc_params(request, 4, NHPROXY_INT_PTR(role), NHPROXY_INT_PTR(race),
      NHPROXY_INT_PTR(gend), NHPROXY_INT_PTR(align));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] player_selection(%d, %d, %d, %d)\n",
	  nhproxy_rpc_svc_get_serial(), role, race, gend, align);
    quit = (nhproxy_bool_t)
      (*nhproxy_clnt->winext_player_selection)(&role, &race, &gend, &align);
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] player_selection = %d, %d, %d, %d, %s\n",
	  nhproxy_rpc_svc_get_serial(), role, race, gend, align,
	  quit ? "TRUE" : "FALSE");
    nhproxy_rpc_params(reply, 5, NHPROXY_INT(role), NHPROXY_INT(race),
      NHPROXY_INT(gend), NHPROXY_INT(align), NHPROXY_BOOLEAN(quit));
}

static void
nhproxy_clnt_askname(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *plname;
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] askname()\n", nhproxy_rpc_svc_get_serial());
    plname = (*nhproxy_clnt->winext_askname)();
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] askname = %#s\n", nhproxy_rpc_svc_get_serial(), plname);
    nhproxy_rpc_params(reply, 1, NHPROXY_STRING(plname));
    free(plname);
}

static void
nhproxy_clnt_get_nh_event(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] get_nh_event()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_get_nh_event)
	(*nhproxy_clnt->winext_get_nh_event)();
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] get_nh_event not supported\n",
	      nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_exit_nhwindows(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *str = (char *)0;
    nhproxy_rpc_params(request, 1, NHPROXY_STRING_PTR(str));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] exit_nhwindows(%#s)\n", nhproxy_rpc_svc_get_serial(), str);
    (*nhproxy_clnt->winext_exit_nhwindows)(str);
    free(str);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_suspend_nhwindows(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *str = (char *)0;
    nhproxy_rpc_params(request, 1, NHPROXY_STRING_PTR(str));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] suspend_nhwindows(%#s)\n", nhproxy_rpc_svc_get_serial(), str);
    if (nhproxy_clnt->winext_suspend_nhwindows)
	(*nhproxy_clnt->winext_suspend_nhwindows)(str);
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] suspend_nhwindows not supported\n",
	      nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    free(str);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_resume_nhwindows(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] resume_nhwindows()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_resume_nhwindows)
	(*nhproxy_clnt->winext_resume_nhwindows)();
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] resume_nhwindows not supported\n",
	      nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_create_nhwindow(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int type;
    int window;
    static const char *nhwindow_types[] = { NULL, "NHW_MESSAGE", "NHW_STATUS",
      "NHW_MAP", "NHW_MENU", "NHW_TEXT" };
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(type));
    if (nhproxy_clnt_log) {
	if (type >= 1 && type < SIZE(nhwindow_types))
	    nhproxy_io_printf(nhproxy_clnt_log, "[%u] create_nhwindow(%s)\n",
	      nhproxy_rpc_svc_get_serial(), nhwindow_types[type]);
	else
	    nhproxy_io_printf(nhproxy_clnt_log, "[%u] create_nhwindow(%d)\n",
	      nhproxy_rpc_svc_get_serial(), type);
    }
    window = (*nhproxy_clnt->winext_create_nhwindow)(type);
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] create_nhwindow = %d\n", nhproxy_rpc_svc_get_serial(), window);
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(window));
}

static void
nhproxy_clnt_clear_nhwindow(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window, rows, cols, layers;
    nhproxy_rpc_params(request, 4, NHPROXY_INT_PTR(window),
      NHPROXY_INT_PTR(rows), NHPROXY_INT_PTR(cols), NHPROXY_INT_PTR(layers));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] clear_nhwindow(%d, %d, %d, %d)\n",
	  nhproxy_rpc_svc_get_serial(), window, rows, cols, layers);
    (*nhproxy_clnt->winext_clear_nhwindow)(window, rows, cols, layers);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_display_nhwindow(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    nhproxy_bool_t blocking;
    nhproxy_rpc_params(request, 2, NHPROXY_INT_PTR(window),
      NHPROXY_BOOLEAN_PTR(blocking));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] display_nhwindow(%d, %s)\n",
	  nhproxy_rpc_svc_get_serial(), window, blocking ? "TRUE" : "FALSE");
    (*nhproxy_clnt->winext_display_nhwindow)(window, blocking);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_destroy_nhwindow(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(window));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] destroy_nhwindow(%d)\n", nhproxy_rpc_svc_get_serial(), window);
    (*nhproxy_clnt->winext_destroy_nhwindow)(window);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_curs(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    int x, y;
    nhproxy_rpc_params(request, 3, NHPROXY_INT_PTR(window),
      NHPROXY_INT_PTR(x), NHPROXY_INT_PTR(y));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] curs(%d, %d, %d)\n",
	  nhproxy_rpc_svc_get_serial(), window, x, y);
    (*nhproxy_clnt->winext_curs)(window, x, y);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_putstr(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    int attr;
    char *str = (char *)0;
    static const char *nhwindow_atrs[] = { "ATR_NONE", "ATR_BOLD", "ATR_DIM",
      "ATR_ULINE", "ATR_BLINK", "ATR_INVERSE" };
    nhproxy_rpc_params(request, 3, NHPROXY_INT_PTR(window),
      NHPROXY_INT_PTR(attr), NHPROXY_STRING_PTR(str));
    if (nhproxy_clnt_log) {
	if (attr >= 0 && attr < SIZE(nhwindow_atrs))
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] putstr(%d, %s, %#s)\n",
	      nhproxy_rpc_svc_get_serial(), window, nhwindow_atrs[attr], str);
	else
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] putstr(%d, %d, %#s)\n",
	      nhproxy_rpc_svc_get_serial(), window, attr, str);
    }
    (*nhproxy_clnt->winext_putstr)(window, attr, str);
    free(str);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_display_file(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int fh;
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(fh));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] display_file(%d)\n", nhproxy_rpc_svc_get_serial(), fh);
    (*nhproxy_clnt->winext_display_file)(fh);
    nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_start_menu(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(window));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] start_menu(%d)\n", nhproxy_rpc_svc_get_serial(), window);
    (*nhproxy_clnt->winext_start_menu)(window);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_add_menu(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    int glyph, identifier, accelerator, groupacc, attr;
    char *str = (char *)0;
    nhproxy_bool_t preselected;
    nhproxy_rpc_params(request, 8, NHPROXY_INT_PTR(window),
      NHPROXY_INT_PTR(glyph), NHPROXY_INT_PTR(identifier),
      NHPROXY_INT_PTR(accelerator), NHPROXY_INT_PTR(groupacc),
      NHPROXY_INT_PTR(attr), NHPROXY_STRING_PTR(str),
      NHPROXY_BOOLEAN_PTR(preselected));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] add_menu(%d, %d, %d, %d, %d, %d, %#s, %s)\n",
	  nhproxy_rpc_svc_get_serial(), window, glyph, identifier, accelerator,
	  groupacc, attr, str, preselected ? "TRUE" : "FALSE");
    (*nhproxy_clnt->winext_add_menu)(window, glyph, identifier, accelerator,
      groupacc, attr, str, preselected);
    free(str);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_end_menu(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    char *prompt = (char *)0;
    nhproxy_rpc_params(request, 2, NHPROXY_INT_PTR(window),
      NHPROXY_STRING_PTR(prompt));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] end_menu(%d, %#s)\n",
	  nhproxy_rpc_svc_get_serial(), window, prompt);
    (*nhproxy_clnt->winext_end_menu)(window, prompt);
    free(prompt);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_select_menu(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int i;
    int window;
    int how;
    struct nhproxy_mi *selected;
    struct nhproxy_select_menu_res ret;
    static const char *menu_picks[] = { "PICK_NONE", "PICK_ONE", "PICK_ANY" };
    nhproxy_rpc_params(request, 2, NHPROXY_INT_PTR(window),
      NHPROXY_INT_PTR(how));
    if (nhproxy_clnt_log) {
	if (how >= 0 && how < SIZE(menu_picks))
	    nhproxy_io_printf(nhproxy_clnt_log, "[%u] select_menu(%d, %s)\n",
	      nhproxy_rpc_svc_get_serial(), window, menu_picks[how]);
	else
	    nhproxy_io_printf(nhproxy_clnt_log, "[%u] select_menu(%d, %d)\n",
	      nhproxy_rpc_svc_get_serial(), window, how);
    }
    ret.retval = (*nhproxy_clnt->winext_select_menu)(window, how, &selected);
    ret.n = ret.retval > 0 && selected ? ret.retval : 0;
    if (ret.n) {
	ret.selected =
	  (struct nhproxy_mi *)malloc(ret.n * sizeof (struct nhproxy_mi));
	if (!ret.selected) {
	    nhproxy_error("Not enough memory");
	    ret.n = 0;
	}
	for(i = 0; i < ret.n; i++) {
	    ret.selected[i].item = selected[i].item;
	    ret.selected[i].count = selected[i].count;
	}
    }
    else
	ret.selected = (struct nhproxy_mi *)0;
    if (nhproxy_clnt_log) {
	int i;
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] select_menu = %d, <",
	  nhproxy_rpc_svc_get_serial(), ret.retval);
	for(i = 0; i < ret.n; i++) {
	    if (i)
		nhproxy_io_printf(nhproxy_clnt_log, ", ");
	    nhproxy_io_printf(nhproxy_clnt_log, "{%d, %ld}",
	      ret.selected[i].item, ret.selected[i].count);
	}
	nhproxy_io_printf(nhproxy_clnt_log, ">\n");
    }
    nhproxy_rpc_params(reply, 1,
      NHPROXY_XDRF(nhproxy_xdr_select_menu_res, &ret));
    if (ret.n)
	free(ret.selected);
}

static void
nhproxy_clnt_message_menu(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int retval;
    int let, how;
    char *mesg = (char *)0;
    nhproxy_rpc_params(request,
      3, NHPROXY_INT_PTR(let), NHPROXY_INT_PTR(how), NHPROXY_STRING_PTR(mesg));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] message_menu(%d, %d, %#s)\n",
	  nhproxy_rpc_svc_get_serial(), let, how, mesg);
    retval = (*nhproxy_clnt->winext_message_menu)(let, how, mesg);
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] message_menu = %d\n",
	  nhproxy_rpc_svc_get_serial(), retval);
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(retval));
    free(mesg);
}

static void
nhproxy_clnt_update_inventory(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] update_inventory()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_update_inventory)
	(*nhproxy_clnt->winext_update_inventory)();
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] update_inventory not supported\n",
	      nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_mark_synch(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] mark_sync()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_mark_synch)
	(*nhproxy_clnt->winext_mark_synch)();
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] mark_sync not supported\n", nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_wait_synch(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] wait_sync()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_wait_synch)
	(*nhproxy_clnt->winext_wait_synch)();
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] wait_sync not supported\n", nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_cliparound(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int x, y;
    nhproxy_rpc_params(request, 2, NHPROXY_INT_PTR(x), NHPROXY_INT_PTR(y));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] cliparound(%d, %d)\n", nhproxy_rpc_svc_get_serial(), x, y);
    if (nhproxy_clnt->winext_cliparound)
	(*nhproxy_clnt->winext_cliparound)(x, y);
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] cliparound not supported\n", nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_update_positionbar(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *posbar = (char *)0;
    nhproxy_rpc_params(request, 1, NHPROXY_STRING_PTR(posbar));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] update_positionbar(%#s)\n",
	  nhproxy_rpc_svc_get_serial(), posbar);
    if (nhproxy_clnt->winext_update_positionbar)
	(*nhproxy_clnt->winext_update_positionbar)(posbar);
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] update_positionbar not supported\n",
	      nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    free(posbar);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_print_glyph(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    int x, y, glyph;
    nhproxy_rpc_params(request, 4, NHPROXY_INT_PTR(window), NHPROXY_INT_PTR(x),
      NHPROXY_INT_PTR(y), NHPROXY_INT_PTR(glyph));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] print_glyph(%d, %d, %d, %d)\n",
	  nhproxy_rpc_svc_get_serial(), window, x, y, glyph);
    (*nhproxy_clnt->winext_print_glyph)(window, x, y, glyph);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_raw_print(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *str = (char *)0;
    nhproxy_rpc_params(request, 1, NHPROXY_STRING_PTR(str));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] raw_print(%#s", nhproxy_rpc_svc_get_serial(), str);
    (*nhproxy_clnt->winext_raw_print)(str);
    free(str);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_raw_print_bold(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *str = (char *)0;
    nhproxy_rpc_params(request, 1, NHPROXY_STRING_PTR(str));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] raw_print_bold(%#s", nhproxy_rpc_svc_get_serial(), str);
    (*nhproxy_clnt->winext_raw_print_bold)(str);
    free(str);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_nhgetch(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int ret;
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] nhgetch()\n", nhproxy_rpc_svc_get_serial());
    ret = (*nhproxy_clnt->winext_nhgetch)();
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] nhgetch = %d\n", nhproxy_rpc_svc_get_serial(), ret);
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(ret));
}

static void
nhproxy_clnt_nh_poskey(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int ret, lx, ly, lmod;
    const char *mouse_clicks[] = { NULL, "CLICK_1", "CLICK_2" };
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] nh_poskey()\n", nhproxy_rpc_svc_get_serial());
    ret = (*nhproxy_clnt->winext_nh_poskey)(&lx, &ly, &lmod);
    if (nhproxy_clnt_log) {
	if (lmod >= 1 && lmod < SIZE(mouse_clicks))
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] nh_poskey = %d, %d, %d, %s\n", nhproxy_rpc_svc_get_serial(),
	      ret, lx, ly, mouse_clicks[lmod]);
	else
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] nh_poskey = %d, %d, %d, %d\n", nhproxy_rpc_svc_get_serial(),
	      ret, lx, ly, lmod);
    }
    nhproxy_rpc_params(reply,
      4, NHPROXY_INT(ret), NHPROXY_INT(lx), NHPROXY_INT(ly), NHPROXY_INT(lmod));
}

static void
nhproxy_clnt_nhbell(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] nhbell()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_nhbell)
	(*nhproxy_clnt->winext_nhbell)();
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] nhbell not supported\n", nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_doprev_message(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int ret;
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] doprev_message()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_doprev_message)
	ret = (*nhproxy_clnt->winext_doprev_message)();
    else {
	if (nhproxy_clnt_protocol > 1) {
	    if (nhproxy_clnt_log)
		nhproxy_io_printf(nhproxy_clnt_log,
		  "[%u] doprev_message not supported\n",
		  nhproxy_rpc_svc_get_serial());
	    nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
	}
	ret = 0;
    }
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] doprev_message = %d\n", nhproxy_rpc_svc_get_serial(), ret);
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(ret));
}

static void
nhproxy_clnt_yn_function(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int retval, count = 0, def;
    char *ques = (char *)0, *choices = (char *)0;
    nhproxy_rpc_params(request, 3, NHPROXY_STRING_PTR(ques),
      NHPROXY_STRING_PTR(choices), NHPROXY_INT_PTR(def));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] yn_function(%#s, %#s, %d)\n", nhproxy_rpc_svc_get_serial(),
	  ques, choices, def);
    retval = (*nhproxy_clnt->winext_yn_function)(ques, choices, def, &count);
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] yn_function = %d, %d\n",
	  nhproxy_rpc_svc_get_serial(), retval, count);
    nhproxy_rpc_params(reply, 2, NHPROXY_INT(retval), NHPROXY_INT(count));
    free(ques);
    free(choices);
}

static void
nhproxy_clnt_getlin(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *ques = (char *)0, *input;
    nhproxy_rpc_params(request, 1, NHPROXY_STRING_PTR(ques));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] getlin(%#s)\n", nhproxy_rpc_svc_get_serial(), ques);
    input = (*nhproxy_clnt->winext_getlin)(ques);
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] getlin = %#s\n", nhproxy_rpc_svc_get_serial(), input);
    nhproxy_rpc_params(reply, 1, NHPROXY_STRING(input));
    free(ques);
    free(input);
}

static void
nhproxy_clnt_get_ext_cmd(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int extcmd;
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] get_ext_cmd()\n", nhproxy_rpc_svc_get_serial());
    extcmd = (*nhproxy_clnt->winext_get_ext_cmd)();
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] get_ext_cmd = %d\n", nhproxy_rpc_svc_get_serial(), extcmd);
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(extcmd));
}

static void
nhproxy_clnt_number_pad(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int state;
    const char *number_pad_modes[] = { "NP_KEYPAD", NULL, "NP_NUMERIC" };
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(state));
    if (nhproxy_clnt_log) {
	if (state == -1 || state == 1)
	    nhproxy_io_printf(nhproxy_clnt_log, "[%u] number_pad(%s)\n",
	      nhproxy_rpc_svc_get_serial(), number_pad_modes[state]);
	else
	    nhproxy_io_printf(nhproxy_clnt_log, "[%u] number_pad(%d)\n",
	      nhproxy_rpc_svc_get_serial(), state);
    }
    if (nhproxy_clnt->winext_number_pad)
	(*nhproxy_clnt->winext_number_pad)(state);
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] number_pad not supported\n", nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_delay_output(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] delay_output()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_delay_output)
	(*nhproxy_clnt->winext_delay_output)();
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] delay_output not supported\n",
	      nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_change_color(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int color;
    long rgb;
    nhproxy_bool_t reverse;
    nhproxy_rpc_params(request, 3, NHPROXY_INT_PTR(color),
      NHPROXY_LONG_PTR(rgb), NHPROXY_BOOLEAN_PTR(reverse));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] change_color(%d, %ld, %s)\n",
	  nhproxy_rpc_svc_get_serial(), color, rgb, reverse ? "TRUE" : "FALSE");
    if (nhproxy_clnt->winext_change_color)
	(*nhproxy_clnt->winext_change_color)(color, rgb, reverse);
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] change_color not supported\n",
	      nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_change_background(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    nhproxy_bool_t white_or_black;
    nhproxy_rpc_params(request, 1, NHPROXY_BOOLEAN_PTR(white_or_black));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] change_background(%s)\n",
	  nhproxy_rpc_svc_get_serial(), white_or_black ? "TRUE" : "FALSE");
    if (nhproxy_clnt->winext_change_background)
	(*nhproxy_clnt->winext_change_background)(white_or_black);
    else if (nhproxy_clnt_protocol > 1) {
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] change_background not supported\n",
	      nhproxy_rpc_svc_get_serial());
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_set_font_name(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    char *font = (char *)0;
    int ret;
    nhproxy_rpc_params(request, 2, NHPROXY_INT_PTR(window),
      NHPROXY_STRING_PTR(font));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] set_font_name(%d, %#s)\n",
	  nhproxy_rpc_svc_get_serial(), window, font);
    if (nhproxy_clnt->winext_set_font_name)
	ret = (*nhproxy_clnt->winext_set_font_name)(window, font);
    else {
	if (nhproxy_clnt_protocol > 1) {
	    if (nhproxy_clnt_log)
		nhproxy_io_printf(nhproxy_clnt_log,
		  "[%u] set_font_name not supported\n",
		  nhproxy_rpc_svc_get_serial());
	    nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
	}
	ret = -1;
    }
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] set_font_name = %d\n",
	  nhproxy_rpc_svc_get_serial(), ret);
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(ret));
    free(font);
}

static void
nhproxy_clnt_get_color_string(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *ret;
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] get_color_string()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_get_color_string)
	ret = (*nhproxy_clnt->winext_get_color_string)();
    else {
	if (nhproxy_clnt_protocol > 1) {
	    if (nhproxy_clnt_log)
		nhproxy_io_printf(nhproxy_clnt_log,
		  "[%u] get_color_string not supported\n",
		  nhproxy_rpc_svc_get_serial());
	    nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
	}
	ret = "";
    }
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] get_color_string = %#s\n", nhproxy_rpc_svc_get_serial(), ret);
    nhproxy_rpc_params(reply, 1, NHPROXY_STRING(ret));
    free(ret);
}

static void
nhproxy_clnt_start_screen(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] start_screen()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_start_screen)
	(*nhproxy_clnt->winext_start_screen)();
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] start_screen not supported\n",
	      nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_end_screen(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] end_screen()\n", nhproxy_rpc_svc_get_serial());
    if (nhproxy_clnt->winext_end_screen)
	(*nhproxy_clnt->winext_end_screen)();
    else if (nhproxy_clnt_protocol > 1) {
	if (nhproxy_clnt_log)
	    nhproxy_io_printf(nhproxy_clnt_log,
	      "[%u] end_screen not supported\n", nhproxy_rpc_svc_get_serial());
    	nhproxy_rpc_send_error(id, NHPROXY_ERROR_EXT_UNSUPPORTED);
    }
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_outrip(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int window;
    char *killed_by = (char *)0;
    nhproxy_bool_t handled;
    nhproxy_rpc_params(request, 2, NHPROXY_INT_PTR(window),
      NHPROXY_STRING_PTR(killed_by));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] outrip(%d, %#s)\n",
	  nhproxy_rpc_svc_get_serial(), window, killed_by);
    handled =
      (nhproxy_bool_t)(*nhproxy_clnt->winext_outrip)(window, killed_by);
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log, "[%u] outrip = %s\n",
	  nhproxy_rpc_svc_get_serial(), handled ? "TRUE" : "FALSE");
    nhproxy_rpc_params(reply, 1, NHPROXY_BOOLEAN(handled));
    free(killed_by);
}

static void
nhproxy_clnt_preference_update(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *optnam = (char *)0;
    char *value = (char *)0;
    nhproxy_rpc_params(request, 2, NHPROXY_STRING_PTR(optnam),
      NHPROXY_STRING_PTR(value));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] preference_update(%#s, %#s)\n",
	  nhproxy_rpc_svc_get_serial(), optnam, value);
    (*nhproxy_clnt->winext_preference_update)(optnam, value);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
    free(optnam);
    free(value);
}

static void
nhproxy_clnt_status(id, request, reply)
unsigned short id; 
NhProxyXdr *request, *reply;
{
    struct nhproxy_status_req req = { 0, 0, (const char **)0 };
    nhproxy_rpc_params(request, 1, NHPROXY_XDRF(nhproxy_xdr_status_req, &req));
    if (nhproxy_clnt_log) {
	int i;
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] status(%d, <", nhproxy_rpc_svc_get_serial(), req.reconfig);
	for(i = 0; i < req.nv; i++) {
	    if (i)
		nhproxy_io_printf(nhproxy_clnt_log, ", ");
	    nhproxy_io_printf(nhproxy_clnt_log, "%#s", req.values[i]);
	}
	nhproxy_io_printf(nhproxy_clnt_log, ">\n");
    }
    (*nhproxy_clnt->winext_status)(req.reconfig, req.nv, req.values);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_print_glyph_layered(id, request, reply)
unsigned short id; 
NhProxyXdr *request, *reply;
{
    int i, j;
    struct nhproxy_print_glyph_layered_req req = { 0, 0, 0 };
    nhproxy_rpc_params(request,
      1, NHPROXY_XDRF(nhproxy_xdr_print_glyph_layered_req, &req));
    if (nhproxy_clnt_log) {
	int k, ng;
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] print_glyph_layered(%d, <\n  ",
	  nhproxy_rpc_svc_get_serial(), req.window);
	for(i = 0; i < req.nl; i++) {
	    if (i)
		nhproxy_io_printf(nhproxy_clnt_log, ",\n  ");
	    ng = 0;
	    for(j = 0; j < req.layers[i].nr; j++)
		ng += req.layers[i].rows[j].ng;
	    nhproxy_io_printf(nhproxy_clnt_log, "%d, <%s",
	      req.layers[i].start, ng > 10 ? "\n    " : "");
	    for(j = 0; j < req.layers[i].nr; j++) {
		if (j)
		    nhproxy_io_printf(nhproxy_clnt_log,
		      ng > 10 ? ",\n    " : ", ");
		nhproxy_io_printf(nhproxy_clnt_log, "%d, <",
		  req.layers[i].rows[j].start);
		for(k = 0; k < req.layers[i].rows[j].ng; k++) {
		    if (k)
			nhproxy_io_printf(nhproxy_clnt_log, ", ");
		    nhproxy_io_printf(nhproxy_clnt_log, "%d",
		      req.layers[i].rows[j].glyphs[k]);
		}
		nhproxy_io_printf(nhproxy_clnt_log, ">");
	    }
	    nhproxy_io_printf(nhproxy_clnt_log, ng > 10 ? "\n    >" : ">");
	}
	nhproxy_io_printf(nhproxy_clnt_log, "\n  >\n");
    }
    (*nhproxy_clnt->winext_print_glyph_layered)(req.window, req.nl, req.layers);
    for(i = 0; i < req.nl; i++) {
	for(j = 0; j < req.layers[i].nr; j++)
	    free(req.layers[i].rows[j].glyphs);
	free(req.layers[i].rows);
    }
    free(req.layers);
    if (!nhproxy_rpc_async_mode())
	nhproxy_rpc_params(reply, 0);
}

static void
nhproxy_clnt_send_config_file(id, request, reply)
unsigned short id; 
NhProxyXdr *request, *reply;
{
    int fh;
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(fh));
    if (nhproxy_clnt_log)
	nhproxy_io_printf(nhproxy_clnt_log,
	  "[%u] send_config_file(%d)\n", nhproxy_rpc_svc_get_serial(), fh);
    (*nhproxy_clnt->winext_send_config_file)(fh);
    nhproxy_rpc_params(reply, 0);
}

static struct nhproxy_rpc_services services[] = {
    NHPROXY_EXT_FID_INIT,		    nhproxy_clnt_init,
    NHPROXY_EXT_FID_INIT_NHWINDOWS,	    nhproxy_clnt_init_nhwindows,
    NHPROXY_EXT_FID_PLAYER_SELECTION,	    nhproxy_clnt_player_selection,
    NHPROXY_EXT_FID_ASKNAME,		    nhproxy_clnt_askname,
    NHPROXY_EXT_FID_GET_NH_EVENT,	    nhproxy_clnt_get_nh_event,
    NHPROXY_EXT_FID_EXIT_NHWINDOWS,	    nhproxy_clnt_exit_nhwindows,
    NHPROXY_EXT_FID_SUSPEND_NHWINDOWS,	    nhproxy_clnt_suspend_nhwindows,
    NHPROXY_EXT_FID_RESUME_NHWINDOWS,	    nhproxy_clnt_resume_nhwindows,
    NHPROXY_EXT_FID_CREATE_NHWINDOW,	    nhproxy_clnt_create_nhwindow,
    NHPROXY_EXT_FID_CLEAR_NHWINDOW,	    nhproxy_clnt_clear_nhwindow,
    NHPROXY_EXT_FID_DISPLAY_NHWINDOW,	    nhproxy_clnt_display_nhwindow,
    NHPROXY_EXT_FID_DESTROY_NHWINDOW,	    nhproxy_clnt_destroy_nhwindow,
    NHPROXY_EXT_FID_CURS,		    nhproxy_clnt_curs,
    NHPROXY_EXT_FID_PUTSTR,		    nhproxy_clnt_putstr,
    NHPROXY_EXT_FID_DISPLAY_FILE,	    nhproxy_clnt_display_file,
    NHPROXY_EXT_FID_START_MENU,		    nhproxy_clnt_start_menu,
    NHPROXY_EXT_FID_ADD_MENU,		    nhproxy_clnt_add_menu,
    NHPROXY_EXT_FID_END_MENU,		    nhproxy_clnt_end_menu,
    NHPROXY_EXT_FID_SELECT_MENU,	    nhproxy_clnt_select_menu,
    NHPROXY_EXT_FID_MESSAGE_MENU,	    nhproxy_clnt_message_menu,
    NHPROXY_EXT_FID_UPDATE_INVENTORY,	    nhproxy_clnt_update_inventory,
    NHPROXY_EXT_FID_MARK_SYNC,		    nhproxy_clnt_mark_synch,
    NHPROXY_EXT_FID_WAIT_SYNC,		    nhproxy_clnt_wait_synch,
    NHPROXY_EXT_FID_CLIPAROUND,		    nhproxy_clnt_cliparound,
    NHPROXY_EXT_FID_UPDATE_POSITIONBAR,	    nhproxy_clnt_update_positionbar,
    NHPROXY_EXT_FID_PRINT_GLYPH,	    nhproxy_clnt_print_glyph,
    NHPROXY_EXT_FID_RAW_PRINT,		    nhproxy_clnt_raw_print,
    NHPROXY_EXT_FID_RAW_PRINT_BOLD,	    nhproxy_clnt_raw_print_bold,
    NHPROXY_EXT_FID_NHGETCH,		    nhproxy_clnt_nhgetch,
    NHPROXY_EXT_FID_NH_POSKEY,		    nhproxy_clnt_nh_poskey,
    NHPROXY_EXT_FID_NHBELL,		    nhproxy_clnt_nhbell,
    NHPROXY_EXT_FID_DOPREV_MESSAGE,	    nhproxy_clnt_doprev_message,
    NHPROXY_EXT_FID_YN_FUNCTION,	    nhproxy_clnt_yn_function,
    NHPROXY_EXT_FID_GETLIN,		    nhproxy_clnt_getlin,
    NHPROXY_EXT_FID_GET_EXT_CMD,	    nhproxy_clnt_get_ext_cmd,
    NHPROXY_EXT_FID_NUMBER_PAD,		    nhproxy_clnt_number_pad,
    NHPROXY_EXT_FID_DELAY_OUTPUT,	    nhproxy_clnt_delay_output,
    NHPROXY_EXT_FID_CHANGE_COLOR,	    nhproxy_clnt_change_color,
    NHPROXY_EXT_FID_CHANGE_BACKGROUND,	    nhproxy_clnt_change_background,
    NHPROXY_EXT_FID_SET_FONT_NAME,	    nhproxy_clnt_set_font_name,
    NHPROXY_EXT_FID_GET_COLOR_STRING,	    nhproxy_clnt_get_color_string,
    NHPROXY_EXT_FID_START_SCREEN,	    nhproxy_clnt_start_screen,
    NHPROXY_EXT_FID_END_SCREEN,		    nhproxy_clnt_end_screen,
    NHPROXY_EXT_FID_OUTRIP,		    nhproxy_clnt_outrip,
    NHPROXY_EXT_FID_PREFERENCE_UPDATE,	    nhproxy_clnt_preference_update,
    NHPROXY_EXT_FID_STATUS,		    nhproxy_clnt_status,
    NHPROXY_EXT_FID_PRINT_GLYPH_LAYERED,    nhproxy_clnt_print_glyph_layered,
    NHPROXY_EXT_FID_SEND_CONFIG_FILE,	    nhproxy_clnt_send_config_file,
    0,					    NULL,
};

void
nhproxy_clnt_set_ext_procs(ini_routine, windowprocs)
void NHPROXY_NDECL((*ini_routine));
struct nhproxy_clnt_ext_procs *windowprocs;
{
    nhproxy_ini = ini_routine;
    nhproxy_clnt = windowprocs;
}

#ifdef DEBUG
static void
debug_dump(buf, len, arrow)
nhproxy_genericptr_t buf;
unsigned int len;
char *arrow;
{
    int i, j, nc;
    long l;
    char cbuf[17];
    unsigned char *bp = buf;
    for(i = 0; i < len; ) {
	if ((i & 15) == 0) {
	    if (!i)
		fputs(arrow, stderr);
	    else {
		cbuf[16] = '\0';
		while(nc++ < 40)
		    fputc(' ', stderr);
		fputs(cbuf, stderr);
		fputs("\n  ", stderr);
	    }
	    nc = 2;
	}
	if (len - i >= 4) {
	    l = (long)bp[i] << 24 | (long)bp[i + 1] << 16 |
	      (long)bp[i + 2] << 8 | bp[i + 3];
	    fprintf(stderr, " %08X", l);
	    nc += 9;
	    for(j = 0; j < 4; j++, i++)
		cbuf[i & 15] = isgraph(bp[i]) || bp[i] == ' ' ?  bp[i] : '.';
	}
	else {
	    fprintf(stderr, " %02X", bp[i]);
	    nc += 3;
	    cbuf[i & 15] = isgraph(bp[i]) || bp[i] == ' ' ? bp[i] : '.';
	    i++;
	}
    }
    if (len) {
	cbuf[i & 15 ? i & 15 : 16] = '\0';
	while(nc++ < 40)
	    fputc(' ', stderr);
	fputs(cbuf, stderr);
    }
    fputc('\n', stderr);
}

struct debug_handle {
    nhproxy_io_func f;
    nhproxy_genericptr_t h;
    char *arrow;
};

static int
debug_snoop(handle, buf, len)
nhproxy_genericptr_t handle;
nhproxy_genericptr_t buf;
unsigned int len;
{
    int retval;
    struct debug_handle *h = (struct debug_handle *)handle;
    retval = h->f(h->h, buf, len);
    if (retval == -2)
	fprintf(stderr, "%s PENDING\n", h->arrow);
    else if (retval < 0)
	fprintf(stderr, "%s ERROR\n", h->arrow);
    else
	debug_dump(buf, retval, h->arrow);
    return retval;
}
#endif	/* DEBUG */

static struct nhproxy_line *nhproxy_clnt_subprotocol0_lp;
static struct nhproxy_line *nhproxy_clnt_subprotocol0_resp;

char *
nhproxy_clnt_gettag(tag)
const char *tag;
{
    int i;
    for(i = 0; i < nhproxy_clnt_subprotocol0_lp->n; i++)
	if (!strcmp(nhproxy_clnt_subprotocol0_lp->tags[i], tag))
	    return nhproxy_clnt_subprotocol0_lp->values[i];
    return (char *)0;
}

nhproxy_bool_t
nhproxy_clnt_settag(tag, value)
const char *tag, *value;
{
    int i;
    char **new;
    for(i = 0; i < nhproxy_clnt_subprotocol0_resp->n; i++)
	if (!strcmp(nhproxy_clnt_subprotocol0_resp->tags[i], tag)) {
	    free(nhproxy_clnt_subprotocol0_resp->values[i]);
	    nhproxy_clnt_subprotocol0_resp->values[i] = strdup(value);
	    return !!nhproxy_clnt_subprotocol0_resp->values[i];
	}
    new = (char **)realloc(nhproxy_clnt_subprotocol0_resp->tags,
      (i + 1) * sizeof(char *));
    if (!new)
	return nhproxy_false;
    nhproxy_clnt_subprotocol0_resp->tags = new;
    new = (char **)realloc(nhproxy_clnt_subprotocol0_resp->values,
      (i + 1) * sizeof(char *));
    if (!new)
	return nhproxy_false;
    nhproxy_clnt_subprotocol0_resp->values = new;
    nhproxy_clnt_subprotocol0_resp->tags[i] = strdup(tag);
    if (!nhproxy_clnt_subprotocol0_resp->tags[i])
	return nhproxy_false;
    nhproxy_clnt_subprotocol0_resp->values[i] = strdup(value);
    if (!nhproxy_clnt_subprotocol0_resp->values[i]) {
	free(nhproxy_clnt_subprotocol0_resp->tags[i]);
	return nhproxy_false;
    }
    nhproxy_clnt_subprotocol0_resp->n++;
    return nhproxy_true;
}

void
nhproxy_clnt_set_flags(mask, value)
unsigned long mask, value;
{
    nhproxy_clnt_flags &= ~mask;
    nhproxy_clnt_flags |= mask & value;
}

nhproxy_bool_t
nhproxy_clnt_log_open(func, handle)
nhproxy_io_func func;
nhproxy_genericptr_t handle;
{
    if (nhproxy_clnt_log)
	nhproxy_io_close(nhproxy_clnt_log);
    if (func)
	nhproxy_clnt_log = nhproxy_io_open(func, handle,
	  NHPROXY_IO_WRONLY | NHPROXY_IO_LINEBUF);
    else
	nhproxy_clnt_log = (NhProxyIO *)0;
    return !!nhproxy_clnt_log;
}

#ifdef DEBUG_RPC
static int
debug_rpc_out(handle, buf, len)
nhproxy_genericptr_t handle;
nhproxy_genericptr_t buf;
unsigned int len;
{
    return write(2, buf, len);
}
#endif

static nhproxy_clnt_authhandler nhproxy_clnt_auth_handler = NULL;

/**
 * nhproxy_clnt_set_authhandler:
 * @new: The new authentication handler to install.
 *
 * Installs an authentication handler to be called if the game server
 * requires authentication (ie., includes the authmethods tag in the
 * NhProxy sub-protocol 0 greeting).
 *
 * Returns: The previous authentication handler, or NULL.
 **/
nhproxy_clnt_authhandler
nhproxy_clnt_set_authhandler(new)
nhproxy_clnt_authhandler new;
{
    nhproxy_clnt_authhandler old = nhproxy_clnt_auth_handler;
    nhproxy_clnt_auth_handler = new;
    return old;
}

nhproxy_bool_t
nhproxy_clnt_tryaccept(read_f, read_h, write_f, write_h)
nhproxy_io_func read_f, write_f;
nhproxy_genericptr_t read_h, write_h;
{
    int i;
    char *s;
    NhProxyIO *rd, *wr;
    struct nhproxy_line line;
    char *standard, *protocols, *authmethods, buf[32];
#ifdef DEBUG
    static struct debug_handle dhr, dhw;
    dhr.f = read_f;
    dhr.h = read_h;
    dhr.arrow = "<=";
    rd = nhproxy_io_open(debug_snoop, &dhr, NHPROXY_IO_RDONLY);
    dhw.f = write_f;
    dhw.h = write_h;
    dhw.arrow = "=>";
    wr = nhproxy_io_open(debug_snoop, &dhw, NHPROXY_IO_WRONLY);
#else
    rd = nhproxy_io_open(read_f, read_h, NHPROXY_IO_RDONLY);
    wr = nhproxy_io_open(write_f, write_h, NHPROXY_IO_WRONLY);
#endif
    if (!rd || !wr) {
	nhproxy_error("Failed to open I/O streams");
	return nhproxy_false;
    }
#ifdef DEBUG_RPC
    (void)nhproxy_clnt_log_open(debug_rpc_out, 0);
#endif
    if (!nhproxy_rpc_init(rd, wr, services)) {
	nhproxy_error("Failed to initialize NhProxy");
	nhproxy_io_close(wr);
	nhproxy_io_close(rd);
	return nhproxy_false;
    }
    nhproxy_clnt_subprotocol0_lp = nhproxy_subprotocol0_read_line();
    if (!nhproxy_clnt_subprotocol0_lp) {
failed:
	nhproxy_error("Failed to start NhProxy");
	/* We leave the NhProxyIO streams open and NhProxy initialized so
	 * that nhproxy_clnt_get_failed_packet() will still work.
	 */
	return nhproxy_false;
    }
    if (strcmp(nhproxy_clnt_subprotocol0_lp->type, "NhExt") ||
      !nhproxy_clnt_gettag("game") ||
      !(standard = nhproxy_clnt_gettag("standard")) ||
      !nhproxy_clnt_gettag("version") ||
      !(protocols = nhproxy_clnt_gettag("protocols"))) {
	nhproxy_subprotocol0_free_line(nhproxy_clnt_subprotocol0_lp);
	goto failed;
    }
    if (sscanf(standard, "%u.%u", &nhproxy_clnt_ver_major,
      &nhproxy_clnt_ver_minor) != 2 ||
      nhproxy_clnt_ver_major != NHPROXY_EXT_STANDARD_MAJOR) {
	nhproxy_error("Incompatible NhExt standard (%s)", standard);
	nhproxy_subprotocol0_free_line(nhproxy_clnt_subprotocol0_lp);
	s = "Error mesg \"Incompatible NhExt standard\"\n";
	(void)nhproxy_io_write(wr, s, strlen(s));
	nhproxy_rpc_end();
	nhproxy_io_close(wr);
	nhproxy_io_close(rd);
	return nhproxy_false;
    }
    if (nhproxy_clnt_flags & NHPROXY_CLNT_SYNCHRONOUS)
	s = NULL;
    else
	s = strchr(protocols, '2');
    if (s && (s == protocols || s[-1] == ',') && (!s[1] || s[1] == ','))
	nhproxy_clnt_protocol = 2;
    else {
	s = strchr(protocols, '1');
	if (s && (s == protocols || s[-1] == ',') && (!s[1] || s[1] == ','))
	    nhproxy_clnt_protocol = 1;
	else {
	    nhproxy_subprotocol0_free_line(nhproxy_clnt_subprotocol0_lp);
	    if (nhproxy_clnt_flags & NHPROXY_CLNT_SYNCHRONOUS)
		nhproxy_error("Sub-protocol 1 not supported");
	    else
		nhproxy_error("Sub-protocols 1 & 2 not supported");
	    s = "Error mesg \"No supported protocols\"\n";
	    (void)nhproxy_io_write(wr, s, strlen(s));
	    nhproxy_rpc_end();
	    nhproxy_io_close(wr);
	    nhproxy_io_close(rd);
	    return nhproxy_false;
	}
    }
    authmethods = nhproxy_clnt_gettag("authmethods");
    if (!nhproxy_clnt_auth_handler) {
	if (authmethods) {
	    s = strchr(authmethods, '0');
	    if (!s || s != authmethods && s[-1] != ',' || s[1] && s[1] != ',') {
		nhproxy_error(
		  "No handler defined for required authorization");
		s = "Error mesg \"Authorization not supported\"\n";
		(void)nhproxy_io_write(wr, s, strlen(s));
		nhproxy_rpc_end();
		nhproxy_io_close(wr);
		nhproxy_io_close(rd);
		return nhproxy_false;
	    }
	}
    } else if (authmethods && strcmp(authmethods,"0")) {
	int method = 0;
	unsigned long authmask = 0;
	nhproxy_clnt_subprotocol0_resp =
	  (struct nhproxy_line *) malloc(sizeof(struct nhproxy_line));
	if (!nhproxy_clnt_subprotocol0_resp) {
	    nhproxy_error("Not enough memory");
	    s = "Error mesg \"Resource failure\"\n";
	    (void)nhproxy_io_write(wr, s, strlen(s));
	    nhproxy_rpc_end();
	    nhproxy_io_close(wr);
	    nhproxy_io_close(rd);
	    return nhproxy_false;
	}
	nhproxy_clnt_subprotocol0_resp->n = 0;
	nhproxy_clnt_subprotocol0_resp->values = NULL;
	nhproxy_clnt_subprotocol0_resp->tags = NULL;
	i = 0;
	do {
	    if (authmethods[i] == ',' || authmethods[i] == '\0') {
		if (method < sizeof(unsigned long) * 8)
		    authmask |= 1UL << method;
		method = 0;
	    } else if (authmethods[i] >= '0' && authmethods[i] <= '9') {
		method *= 10;
		method += authmethods[i] - '0';
	    }
	} while (authmethods[i++]);
	if (!nhproxy_clnt_auth_handler(authmask)) {
	    if (nhproxy_clnt_subprotocol0_resp->n) {
		nhproxy_clnt_subprotocol0_resp->type = "Error";
		(void)nhproxy_subprotocol0_write_line(
		  nhproxy_clnt_subprotocol0_resp);
		for(i = 0; i < nhproxy_clnt_subprotocol0_resp->n; i++) {
		    free(nhproxy_clnt_subprotocol0_resp->values[i]);
		    free(nhproxy_clnt_subprotocol0_resp->tags[i]);
		}
		free(nhproxy_clnt_subprotocol0_resp->values);
		free(nhproxy_clnt_subprotocol0_resp->tags);
	    } else {
		s = "Error mesg \"Generic authorization failure\"\n";
		(void)nhproxy_io_write(wr, s, strlen(s));
	    }
	    free(nhproxy_clnt_subprotocol0_resp);
	    nhproxy_rpc_end();
	    nhproxy_io_close(wr);
	    nhproxy_io_close(rd);
	    return nhproxy_false;
	}
    }
    line.type = "Ack";
    line.n = nhproxy_clnt_subprotocol0_resp ?
      2 + nhproxy_clnt_subprotocol0_resp->n : 2;
    line.tags = (char **)malloc(line.n * sizeof(char *));
    line.values = (char **)malloc(line.n * sizeof(char *));
    if (!line.tags || !line.values) {
	free(line.tags);
	free(line.values);
	nhproxy_error("Not enough memory");
	s = "Error mesg \"Resource failure\"\n";
	(void)nhproxy_io_write(wr, s, strlen(s));
	nhproxy_rpc_end();
	nhproxy_io_close(wr);
	nhproxy_io_close(rd);
	return nhproxy_false;
    }
    line.tags[0] = "windowtype";
    line.values[0] = (char *)nhproxy_clnt->name;
    line.tags[1] = "protocol";
    sprintf(buf, "%d", nhproxy_clnt_protocol);
    line.values[1] = buf;
    if (nhproxy_clnt_subprotocol0_resp) {
	for(i = 0; i < nhproxy_clnt_subprotocol0_resp->n; i++) {
	    line.values[i + 2] = nhproxy_clnt_subprotocol0_resp->values[i];
	    line.tags[i + 2] = nhproxy_clnt_subprotocol0_resp->tags[i];
	}
    }
    i = nhproxy_subprotocol0_write_line(&line);
    if (nhproxy_clnt_subprotocol0_resp) {
	for(i = 0; i < nhproxy_clnt_subprotocol0_resp->n; i++) {
	    free(nhproxy_clnt_subprotocol0_resp->values[i]);
	    free(nhproxy_clnt_subprotocol0_resp->tags[i]);
	}
	free(nhproxy_clnt_subprotocol0_resp->values);
	free(nhproxy_clnt_subprotocol0_resp->tags);
    }
    free(line.tags);
    free(line.values);
    if (!i) {
	nhproxy_subprotocol0_free_line(nhproxy_clnt_subprotocol0_lp);
	nhproxy_error("Failed to write NhExt acknowledgement");
	nhproxy_rpc_end();
	nhproxy_io_close(wr);
	nhproxy_io_close(rd);
	return nhproxy_false;
    }
    nhproxy_rpc_set_protocol(nhproxy_clnt_protocol);
    return nhproxy_true;
}

int
nhproxy_clnt_main_iteration()
{
    int i;
    i = nhproxy_rpc_svc(services);
    if (!i)
	nhproxy_error("Ignoring packet with zero ID");
    return i;
}

char *
nhproxy_clnt_get_failed_packet(nb)
int *nb;
{
    return nhproxy_subprotocol0_get_failed_packet(nb);
}

/*
 * This uses the following rules:
 *
 *	<version>.0	==	<version>
 *	<version>.n+1	>	<version>.n
 *	<version>a	>	<version>
 *	<version>a+1	>	<version>.a
 *
 * where n is any decimal number and a is any single non-digit (with a+1
 * meaning the next ASCII character after a). Note: the use of atoi()
 * means that whitespace and +/- signs will cause odd effects. The
 * assumption is that only alphanumeric characters plus '.' will be used.
 */

static int
cmp_versions(ver1, ver2)
const char *ver1, *ver2;
{
    const char *s1, *s2;
    int n1, n2;
    int retval = 0;
    for(;*ver1 || *ver2;) {
	s1 = strchr(ver1, '.');
	if (!s1)
	    s1 = ver1 + strlen(ver1);
	s2 = strchr(ver2, '.');
	if (!s2)
	    s2 = ver2 + strlen(ver2);
	n1 = atoi(ver1);
	n2 = atoi(ver2);
	retval = n1 - n2;
	if (retval)
	    break;
	while(*ver1 >= '0' && *ver1 <= '9')
	    ver1++;
	while(*ver2 >= '0' && *ver2 <= '9')
	    ver2++;
	while(ver1 < s1 && ver2 < s2 && *ver1 == *ver2)
	    ver1++, ver2++;
	if (ver1 >= s1)
	    retval = ver2 < s2 ? -1 : 0;
	else
	    retval = ver2 < s2 ? *ver1 - *ver2 : 1;
	if (retval)
	    break;
	ver1 = *s1 ? s1 + 1 : s1;
	ver2 = *s2 ? s2 + 1 : s2;
    }
    return retval;
}

/*
 * min_ver is inclusive, next_ver is exclusive, so that a typical requirement of
 * ver 1.x can be expressed as 1.0 <= ver < 2.0 (min_ver = 1.0, next_ver = 2.0).
 * We return the first listed entry that matches so extensions should be
 * listed with the latest version first to select this in preference where
 * there is a choice.
 */

char *
nhproxy_clnt_get_extension(name, min_ver, next_ver, idp)
const char *name, *min_ver, *next_ver;
unsigned short *idp;
{
    int i;
    char *retval = NULL;
    unsigned short id = 0x8000;
    struct nhproxy_cb_get_extensions_res *exts;
    struct nhproxy_cb_get_extensions_res_extension *ext;
    exts = nhproxy_cb_get_extensions();
    if (exts) {
	ext = exts->extensions;
	for(i = 0; i < exts->n_extensions; i++, ext++) {
	    if (!strcmp(name, ext->name) &&
	      min_ver && cmp_versions(min_ver, ext->version) <= 0 &&
	      next_ver && cmp_versions(next_ver, ext->version) > 0) {
		*idp = id;
		retval = strdup(ext->version);
		break;
	    }
	    id += ext->no_procedures;
	}
	nhproxy_cb_free_extensions(exts);
    }
    return retval;
}
