# $Id: acinclude.m4,v 1.1 2004/12/22 23:14:44 ali Exp $
# Copyright (C) 2004  J. Ali Harlow
#
# This file is part of NetHack Proxy.
#
# NetHack Proxy is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as
# published by the Free Software Foundation; either version 2.1 of the
# License, or (at your option) any later version.
#
# NetHack Proxy is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with NetHack Proxy; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
# USA
#
# Alternatively (at your option) you may instead choose to redistribute
# and/or modify NetHack Proxy under the terms of the NetHack General
# Public License.
#
# You should have receieved a copy of the NetHack General Public License
# along with NetHack Proxy; if not, download a copy from
# http://www.nethack.org/common/license.html

# According to ANSI C, when you mix old-style function definitons
# with new-style function declarations then the type of each
# parameter in the declaration must agree with the corresponding
# parameter in the definition, after the definition's parameter
# type has been widened. Thus:
#
#     Widened prototypes           Unwidened prototypes
#     +-------------------+        +-------------------+
#     | int func(int a);  |        | int func(char a); |
#     |                   |        |                   |
#     | int func(a)       |        | int func(a)       |
#     | char a;           |        | char a;           |
#     | {                 |        | {                 |
#     | }                 |        | }                 |
#     +-------------------+        +-------------------+
#             Okay                       Not okay
#
# However, a number of compilers will accept unwidened prototypes
# in these circumstances and use the extra information to provide
# better type checking. We take advantage of this where it works.
#
# Note: This uses knowledge of the internals of autoconf to switch
# on and off AC_COMPILE_IFELSE treatment of warnings.
AC_DEFUN([NHPROXY_CHECK_UNWIDENED_PROTOTYPES],
    [AC_CACHE_CHECK([whether compiler can use unwidened prototypes],
      [ac_cv_nhproxy_unwidened_prototypes],
      [save_werror_flag=$ac_[]_AC_LANG_ABBREV[]_werror_flag
        ac_[]_AC_LANG_ABBREV[]_werror_flag=yes
        AC_COMPILE_IFELSE([int func(char); int func(c) char c; {return 0;}],
        AC_COMPILE_IFELSE([
	    int func(char, char);
	    int main()
	    {
		int i;
		int (*funcptr)(char, char) = func;
		i = func(i, 256);
		return (*funcptr)(i, 256);
	    }],ac_cv_nhproxy_unwidened_prototypes=no,
	    ac_cv_nhproxy_unwidened_prototypes=yes),
	ac_cv_nhproxy_unwidened_prototypes=no)
	ac_[]_AC_LANG_ABBREV[]_werror_flag=$save_werror_flag])])

AC_DEFUN([NHPROXY_CHECK_SYSTEM_H],
    [AC_MSG_CHECKING([whether system.h is configured correctly])
    nhproxy_save_cflags="$CFLAGS"
    CFLAGS="$CFLAGS -I$srcdir"
    AC_COMPILE_IFELSE([
	#include "nhproxy/system.h"
	#ifndef NHPROXY_VOID_PTR
	    choke me
	#endif
	],nhproxy_system_genericptr="void *",nhproxy_system_genericptr="char *")
    if test "$1" != "$nhproxy_system_genericptr"; then
	AC_MSG_ERROR([
*** Internal configuration error:
*** The system.h header file included with this version of nhproxy
*** is configured to use $nhproxy_system_genericptr as a generic pointer type.
*** However, the correct type to use is $1. Please report this bug to the
*** nhproxy maintainers including a copy of config.log.])
    fi
    AC_COMPILE_IFELSE([
	#include "nhproxy/system.h"
	#ifndef NHPROXY_PROTOTYPES
	    choke me
	#endif
	],nhproxy_system_prototypes="yes",nhproxy_system_prototypes="no")
    if test "$2" != "$nhproxy_system_prototypes"; then
	AC_MSG_ERROR([
*** Internal configuration error:
*** The system.h header file included with this version of nhproxy
*** is configured with prototypes=$nhproxy_system_prototypes.
*** However, the correct value is $2. Please report this bug to the
*** nhproxy maintainers including a copy of config.log.])
    fi
    if test "$2" = "yes"; then
	AC_COMPILE_IFELSE([
	    #include "nhproxy/system.h"
	    #ifndef NHPROXY_UNWIDENED_PROTOTYPES
		choke me
	    #endif
	    ],nhproxy_system_unwidened="yes",nhproxy_system_unwidened="no")
	if test "$3" != "$nhproxy_system_unwidened"; then
	    AC_MSG_ERROR([
*** Internal configuration error:
*** The system.h header file included with this version of nhproxy
*** is configured with unwidened_prototypes=$nhproxy_system_unwidened.
*** However, the correct value is $3. Please report this bug to the
*** nhproxy maintainers including a copy of config.log.])
	fi
    fi
    CFLAGS="$nhproxy_save_cflags"
    AC_MSG_RESULT([yes])])

AC_DEFUN([NHPROXY_FUNC_XDR],
    [nhproxy_save_libs="$LIBS"
    LIBS=""
    AC_SEARCH_LIBS([xdrmem_create], [rpclib], [ac_cv_have_xdr=yes], [ac_cv_have_xdr=no])
    AM_CONDITIONAL(HAVE_XDR, test "$ac_cv_have_xdr" = "yes")
    XDR_LIBS="$LIBS"
    AC_SUBST([XDR_LIBS])
    LIBS="$nhproxy_save_libs"])

AC_DEFUN([NHPROXY_CHECK_PTHREAD_CFLAG],
    [nhproxy_save_cflags="$CFLAGS"
    CFLAGS="$CFLAGS [$1]"
    AC_LINK_IFELSE([
	#include <pthread.h>
	main()
	{
	    pthread_mutex_t mutex;
	    (void)pthread_mutex_init(&mutex, NULL);
	    (void)pthread_mutex_lock(&mutex);
	    (void)pthread_mutex_trylock(&mutex);
	    (void)pthread_mutex_unlock(&mutex);
	    (void)pthread_mutex_destroy(&mutex);
	}],ac_cv_nhproxy_pthread_cflag=[$1])
    CFLAGS="$nhproxy_save_cflags"])

AC_DEFUN([NHPROXY_TCP_REQUIRE_FUNC],
    [if test $ac_cv_enable_tcp_scheme = yes; then
	if test "$ac_cv_func_[$1]" != "yes"; then
	    AC_MSG_ERROR([
*** Your C library does not appear to have a [$1] function.
*** You can build without it by passing --disable-tcp-scheme to
*** configure if you don't need to have the game and the interface
*** running on seperate machines.])
	fi
    fi])
