/* Worm.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;

import se.kth.netzack.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;
import java.lang.*;
import java.awt.geom.*;
import java.awt.image.*;



public class Worm {

    public double x;
    public double y;

    private double x1;
    private double y1;

    private double sin;
    private double cos;

    public double a;
    public Direction da = Direction.none;
    public Color color;


    private int skip = 0;

    int[] rgb = new int[20*20];

    Worm() {
	x = 50;
	y = 50;
	a = Math.PI/4;
	color = Color.red;

    }

    Worm(int x0, int y0, double a0, Color c) {
	x = (double)x0;
	y = (double)y0;
	a = a0;
	color = c;
    }

    public void paint(Graphics2D g2, short[][] hit, double elapsed, short n) throws DeadException {

	try {

	    g2.setStroke(ZCanvas.stroke);


	    a += da.get()*Config.turnSpeed*elapsed/1000;

	    /*    if(a > 2*Math.PI)
		a -= 2*Math.PI;
	    else if(a < 0)
	    a += 2*Math.PI;*/

	    cos = Math.cos(a);
	    sin = Math.sin(a);
	    double l = Config.speed*elapsed/1000;
	    x1 = x + l*cos;
	    y1 = y + l*sin;

	    if(x1 < 0 || x1 > Config.X || y1 < 0 || y1 > Config.Y)
		throw new DeadException();



	    if(skip == 0 &&  0.2 > 10*Math.random()) {
		skip = 1;
	    }
	    else if(skip > 0) {
		if( (skip > 6/l && 3 > 10*Math.random())
		    || skip > 10/l) {
		    skip = 0;
		}
		else
		    skip++;
	    }



	    if(skip == 0) {

		int x0 = 0;
		int y0 = 0;
		for(int i = 0; i < Math.round(l + 0.5); i++) {
		    x0 = (int)Math.round(x + i*cos);
		    y0 = (int)Math.round(y + i*sin);
		    if(hit[x0][y0] > 0) {
			if(Math.abs(n - hit[x0][y0]) > 3)
			    throw new DeadException();
		    }
		}

		for(int i = 0; i < Math.round(l + 0.5); i++) {
		    x0 = (int)Math.round(x + i*cos);
		    y0 = (int)Math.round(y + i*sin);


		    hit[x0+1][y0] = n;
		    hit[x0][y0] = n;
		    hit[x0-1][y0] = n;

		    hit[x0-1][y0+1] = n;
		    hit[x0][y0+1] = n;
		    hit[x0+1][y0+1] = n;

		    hit[x0-1][y0-1] = n;
		    hit[x0][y0-1] = n;
		    hit[x0+1][y0-1] = n;


		}

		/*int w = Math.abs((int)Math.round(x1 - x));
		int h = Math.abs((int)Math.round(y1 - y));

		if(h == 0)
		    h = 1;
		if(w == 0)
		    w = 1;

		if(cos > 0) {
		    if(sin > 0)
			rgb = img.getRGB((int)Math.round(x),
					 (int)Math.round(y), w, h, null, 0, w);
		    else
			rgb = img.getRGB((int)Math.round(x),
					 (int)Math.round(y1), w, h, null, 0, w);
		}
		else {
		    if(sin > 0)
			rgb = img.getRGB((int)Math.round(x1),
					 (int)Math.round(y), w, h, null, 0, w);
		    else
			rgb = img.getRGB((int)Math.round(x1),
					 (int)Math.round(y1), w, h, null, 0, w);
		}

		rgb[0] = rgbBlack;


		for(int i = 0; i < rgb.length; i++) {
		    int c = rgb[i];
		    if(c != rgbBlack) {
			//System.out.println(c);
			break;
		    }
		}

		Graphics g = img.getGraphics();
		g.setColor(Color.white);
		g.drawLine((int)Math.round(x),
			   (int)Math.round(y),
			   (int)Math.round(x1),
			   (int)Math.round(y1));*/


		g2.setColor(color);
		g2.draw(new Line2D.Double((int)Math.round(x),
					  (int)Math.round(y),
					  (int)Math.round(x1),
					  (int)Math.round(y1)));



	    }

	    x = x1;
	    y = y1;
	}
	catch(IndexOutOfBoundsException e) {
	    throw new DeadException();
	}

    }


    public void turn(Direction dir) {
	da = dir;
    }

}
