/* PrivateChannel.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import java.net.*;
import java.io.*;




public class PrivateChannel extends Thread {

    DatagramSocket socket;

    boolean initialConnection = false;
    Server server;
    Object lock;

    PrivateChannel(Server s, Object l) {
	super("PrivateChannel");
	lock = l;

	try {
	    socket = new DatagramSocket();
	}
	catch(IOException e) {
	    Netzack.error(e);
	}


	server = s;
	start();


    }

    protected void finalize() throws Throwable {
	try {
	    socket.close();
	}
	finally {
	    super.finalize();
	}
    }


    public void run() {
	if(!socket.isBound()) {
	    Netzack.debug("Premature exit: PrivateChannel thread");
	    return;
	}

	synchronized(lock) {
	    lock.notify();
	}

	try {
	    while(true) {

		//Get data...
		Packet p = new Packet();

		DatagramPacket recv = p.receive(socket);


		//...and handle it

		Message m = p.getMsg();

		//Netzack.debug("<Priv> m:" + m.get() + " l:" + recv.getLength());

		if(m.equals(Message.ECHO)) {
		    server.echos++;

		    if(!initialConnection) {
			initialConnection = true;
			int port = p.readInt();
			byte[] ip = (byte[])p.readObject();
			InetAddress addr = InetAddress.getByAddress(ip);
			//InetAddress addr = (InetAddress)p.readObject();
			if(addr != null) {
			    server.connect(addr, port);
			}
		    }


		}

		p.release();

	    }
	}
	catch(IOException e) {
	    Netzack.debug(e);
	}

    }


    public void send(Packet p) {
	try {
	    p.send(socket);
	}
	catch(IOException e) {
	    Netzack.debug(e);
	}
    }


    public void send(Packet p, SocketAddress addr) {
    	try {
	    p.send(socket, addr);
	}
	catch(IOException e) {
	    Netzack.debug(e);
	}

    }


}
