/* Config.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import se.kth.netzack.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.*;

public class Config {

    static int packetLimit = 1000;
    static double turnSpeed = Math.PI/2;
    static float wormWidth = 4.0f;
    static int X = 600;
    static int Y = 400;
    static double speed = 50;
    static int TTL = 30;

    static int FPS = 16;
    static int PORT = 37001;
    static String GROUP = "237.77.3.1";

    static String VERSION;
    static String PRODUCT;

    static Color COLOR = Color.red;

    static String NOTICE;
    static String COPYRIGHT;

    static int BORDER = 4;

    static String FONT = "sans";
    static int FONT_SIZE = 12;
    static Color CONSOLE_COLOR = Color.white;
    static int MSG_TIMEOUT = 10000;

    static int NICKNAME_LENGTH = 20;


    static void readProperties(String filename) {
	URL url = ClassLoader.getSystemResource(filename);

	if(url != null) {
	    try {
		InputStream in = url.openStream();

		Properties properties = new Properties();

		try {
		    properties.loadFromXML(in);
		}
		catch(InvalidPropertiesFormatException e) {
		    try {
			in = url.openStream();
			properties.load(in);
		    }
		    catch(InvalidPropertiesFormatException e2) {
			Netzack.error("Syntax error in properties file " + filename);
			Netzack.error(e);
		    }
		}


		//Set port
		try {
		    String p = properties.getProperty("port");
		    if(p != null && p.length() > 0)
		       PORT = Integer.parseInt(p);
		}
		catch(NumberFormatException e) {
		    Netzack.error("Invalid port number.");
		}


		//Set group

		String group = properties.getProperty("group");
		if(group != null && group.length() > 0)
		    GROUP = group;


		//Set version

		String version = properties.getProperty("version");
		if(version != null && version.length() > 0)
		    VERSION = version;


		//Set product

		String product = properties.getProperty("product");
		if(product != null && product.length() > 0)
		    PRODUCT = product;



		//Set font
		String font = properties.getProperty("font");
		if(font != null && font.length() > 0)
		    FONT = font;


		//Set font-size
		try {
		    String fs = properties.getProperty("font-size");
		    if(fs != null && fs.length() > 0)
		       FONT_SIZE = Integer.parseInt(fs);
		}
		catch(NumberFormatException e) {
		    Netzack.error("Invalid font-size value.");
		}


		//Set Color
		try {
		    String c = properties.getProperty("color");
		    if(c != null && c.length() > 0)
		       COLOR = new Color(Integer.parseInt(c, 16));
		}
		catch(NumberFormatException e) {
		    Netzack.error("Invalid color value.");
		}


		//Set border
		try {
		    String b = properties.getProperty("border");
		    if(b != null && b.length() > 0)
		       BORDER = Integer.parseInt(b);
		}
		catch(NumberFormatException e) {
		    Netzack.error("Invalid border width.");
		}


		//Set X
		try {
		    String w = properties.getProperty("width");
		    if(w != null && w.length() > 0)
		       X = Integer.parseInt(w);
		}
		catch(NumberFormatException e) {
		    Netzack.error("Invalid width value.");
		}

		//Set Y
		try {
		    String h = properties.getProperty("height");
		    if(h != null && h.length() > 0)
		       Y = Integer.parseInt(h);
		}
		catch(NumberFormatException e) {
		    Netzack.error("Invalid height value.");
		}


		//Set FPS
		try {
		    String f = properties.getProperty("fps");
		    if(f != null && f.length() > 0)
		       FPS = Integer.parseInt(f);
		}
		catch(NumberFormatException e) {
		    Netzack.error("Invalid FPS value.");
		}


	    }
	    catch(IOException e) {
		Netzack.error(e);
	    }
	    finally {
		Netzack.verbose("Loaded " + filename);
	    }

	}

    }


    static {
	Config.readProperties("/se/kth/netzack/defaults.xml");
	Config.readProperties("config.xml");
	Config.readProperties("local.xml");
	Config.readProperties("local.properties");

	//Netzack.debug("port=" + PORT + " group=" + GROUP + " x=" + X + " y=" + Y + " fps=" + FPS);

	COPYRIGHT = Config.PRODUCT + " version " + Config.VERSION + ", Copyright (C) 2007, 2008 Gustav Behm";
	NOTICE = Config.PRODUCT + " comes with ABSOLUTELY NO WARRANTY. This is free software, and you\nare welcome to redistribute it under certain conditions; press `L' for details.\n";


    }


}