/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#ifndef AL_H
#define AL_H


#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdarg.h>
#include <syslog.h>


/**
 */
#define AL_STR(s)                               #s

/**
 */
#define AL_TO_VERSION(name,major,minor,micro)   AL_STR(name major.minor.micro)

/**
 * Version
 */
#define LIB_AL_VERSION_MAJOR             0
#define LIB_AL_VERSION_MINOR             0
#define LIB_AL_VERSION_MICRO             2
#define LIB_AL_VERSION_NAME          libal

#define LIB_AL_VERSION               AL_TO_VERSION(LIB_AL_VERSION_NAME, \
						   LIB_AL_VERSION_MAJOR,\
						   LIB_AL_VERSION_MINOR,\
						   LIB_AL_VERSION_MICRO)

/**
 * XML verify
 * @fixme: path
 */
#define AL_XML_VERIFY                 "/opt/web-admin/bin/xml-verify"


/**
 * XML verify user for run with limited rights
 */
#define AL_XML_VERIFY_USER            "agentd"


#ifndef STDIN_FILENO
# define STDIN_FILENO 0
#endif
#ifndef STDOUT_FILENO
# define STDOUT_FILENO 1
#endif
#ifndef STDERR_FILENO
# define STDERR_FILENO 2
#endif


#include "al-string.h"
#include "al-spawn.h"
#include "util.h"
#include "xml.h"
#include "connection.h"
#include "al-stdio.h"
#include "al-socket.h"

/**
 * SSL connection support.
 */
#define AL_SSL

#ifdef AL_SSL
#include "al-ssl.h"
#endif


#endif /* AL_H */
