/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#include "al.h"


/**
 */
#define AGENTD_STRING_INC       100


/**
 */
AlString * al_string_new(void)
{
	AlString * ret = al_new(AlString);

	ret->s = NULL;
	ret->len = 0;

	return ret;
}


/**
 */
AlString * al_string_new_from_string(const char * s)
{
	AlString * ret = al_new(AlString);

	ret->s = al_strdup(s);
	if (ret->s) ret->len = strlen(ret->s);

	return ret;
}


/**
 */
void al_string_delete(AlString * string)
{
	al_return_if_fail(string);

	al_delete(string->s);
	al_delete(string);
}


/**
 */
void al_string_append_char(AlString * string, char c)
{
	al_return_if_fail(string);

	if (string->s == NULL)
	{
		string->s = (char*)malloc(sizeof(char) * AGENTD_STRING_INC);
		string->len = 0;
		string->allocated = AGENTD_STRING_INC;
	}

	if ((string->len + 1) >= string->allocated)
	{
		string->allocated += AGENTD_STRING_INC;
		string->s = (char*)realloc(string->s, sizeof(char) * string->allocated);
	}

	string->s[string->len] = c;
	string->s[++(string->len)] = '\0';
}


/**
 */
void al_string_delete_last_char(AlString * string)
{

	al_return_if_fail(string);

	if (string->s && string->len)
	{
		string->len--;
		string->s[((string->len) ? string->len-1 : 0)] = '\0';
	}

}


/**
 */
void al_string_set(AlString * string, const char * s)
{

	al_return_if_fail(string && s);

	al_delete(string->s);

	if (s)
	{
		string->s = al_strdup(s);
		string->len = strlen(s);
		string->allocated = string->len;
	}
	else
	{
		string->s = NULL;
		string->len = 0;
		string->allocated = 0;
	}
}


/**
 */
int al_string_last_match_and_remove(AlString * string, const char * s)
{
	int n;
	
	
	al_return_val_if_fail(string && s, 0);
	
	n = strlen(s);
	
	if (string->len >= n)
	{
		if (!strcmp(&string->s[string->len - n],s))
		{
			string->len -= n;
			string->s[string->len] = '\0';

			return 1;
		}
	}

	return 0;
}


/**
 */
void al_string_append_chars(AlString * string, const char * s, int len)
{
	int i;


	al_return_if_fail(string && s && len > 0);


	for (i=0;i < len;i++) al_string_append_char(string, s[i]);

}


