/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#ifndef AGENTD_AGENT_H_
#define AGENTD_AGENT_H_



/**
 * Structure with an agent definition
 */
struct _AgentdAgent
{

	char * name;
	char * bin;
	char * user;

	char * args;

};

typedef struct _AgentdAgent AgentdAgent;


/**
 */
#define agentd_agent_set_name(agent,v)                   (agent)->name = al_strdup(v)


/**
 */
#define agentd_agent_get_name(agent)                     (agent)->name


/**
 */
#define agentd_agent_set_bin(agent,v)                    (agent)->bin = al_strdup(v)


/**
 */
#define agentd_agent_get_bin(agent)                      (agent)->bin


/**
 */
#define agentd_agent_set_user(agent,v)                   (agent)->user = al_strdup(v)


/**
 */
#define agentd_agent_get_user(agent)                     (agent)->user


/**
 */
#define agentd_agent_set_args(agent,v)                   (agent)->args = al_strdup(v)


/**
 */
#define agentd_agent_get_args(agent)                     (agent)->args


/**
 * Create a new agent.
 *
 * @return a new empty agent
 */
AgentdAgent * agentd_agent_new(void);


/**
 * Delet an agent.
 *
 * @param agent agent to delete
 */
void agentd_agent_delete(AgentdAgent * agent);


/**
 * Search the requested agent in the config file.
 *
 * @param request request with agent name
 *
 * @return the agent if found, otherwise NULL
 */
AgentdAgent * agentd_agent_find(const AgentdRequest * request, AlXml * config);


/**
 * Execute an agent passing the request data.
 *
 * @param agent to execute
 * @param request request with data to send at the agent
 * @param response response for insert the data returned
 */
void agentd_agent_execute(const AgentdAgent * agent, const AgentdRequest * request, AgentdResponse * response);


#endif /* AGENTD_AGENT_H_ */
