/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#ifndef REQUEST_H_
#define REQUEST_H_


/**
 * Structure with a request
 */
struct _AgentRequest
{

	struct _AgentRequest * prev;
	struct _AgentRequest * next;

	char                  * id;          /* request id              */
	char                  * agent_data;  /* data for agent          */

};

typedef struct _AgentRequest AgentRequest;


/**
 */
#define agent_request_set_id(request,v)                  (request)->id = al_strdup(v)


/**
 */
#define agent_request_get_id(request)                    (request)->id


/**
 */
#define agent_request_set_agent_data(request,v)          (request)->agent_data = al_strdup(v)


/**
 */
#define agent_request_get_agent_data(request)            (request)->agent_data


/**
 * Structure with a list of request.
 */
struct _AgentRequestPacket
{

	struct _AgentRequest * requests; /* list of request in the packet */

};

typedef struct _AgentRequestPacket AgentRequestPacket;


/**
 * Create a new request.
 *
 * @return the new request.
 */
AgentRequest * agent_request_new(void);


/**
 * Delete a request.
 *
 * @param request request to free
 */
void agent_request_delete(AgentRequest * request);


/**
 * Create a new request packet.
 *
 * @return the new request packet.
 */
AgentRequestPacket * agent_request_packet_new(void);


/**
 * Delete a request packet and all request in list.
 *
 * @param request_packet request packet to free
 */
void agent_request_packet_delete(AgentRequestPacket * request_packet);


/**
 * Add a request to a request packet.
 *
 * @param request_packet request packet
 * @param request request to add
 */
void agent_request_packet_request_add(AgentRequestPacket * request_packet, AgentRequest * request);


/**
 * Create a new request packet from xml string.
 *
 * @param xml xml string
 *
 * @return a new request packet or NULL if xml is not valid.
 */
AgentRequestPacket * agent_request_packet_from_xml_string(const AlString * xml);


/**
 * Create a new request packet from xml.
 *
 * @param xml xml
 *
 * @return a new request packet or NULL if xml is not valid.
 */
AgentRequestPacket * agent_request_packet_from_xml(AlXml * xml);


/**
 * Create a new request from xml.
 *
 * @param node xml node
 *
 * @return a new request
 */
AgentRequest * agent_request_from_xml(AlXmlNode * node);



#endif /* REQUEST_H_ */
