/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#include "agents.h"



/**
 */
AgentsRequest * agents_request_new(void)
{
	AgentsRequest * request = al_new(AgentsRequest);

	request->prev = request->next = NULL;

	request->id = NULL;
	request->server_name = NULL;
	request->server_data = NULL;

	return request;
}


/**
 */
void agents_request_delete(AgentsRequest * request)
{

	al_return_if_fail (request);

	al_delete(request->id);
	al_delete(request->server_name);
	al_delete(request->server_data);
	al_delete(request);

}


/**
 */
AgentsRequestPacket * agents_request_packet_new(void)
{
	AgentsRequestPacket * request_packet = al_new(AgentsRequestPacket);

	request_packet->requests = NULL;

	return request_packet;
}


/**
 */
void agents_request_packet_delete(AgentsRequestPacket * request_packet)
{

	al_return_if_fail (request_packet);

	if (request_packet->requests)
	{
		AgentsRequest * request = request_packet->requests;
		AgentsRequest * next;

		while (request)
		{
			next = request->next;
			agents_request_delete(request);
			request = next;
		}
	}
	
	al_delete(request_packet);

}


/**
 */
void agents_request_packet_request_add(AgentsRequestPacket * request_packet, AgentsRequest * request)
{

	al_return_if_fail (request_packet && request);

	if (request_packet->requests == NULL)
	{

		request_packet->requests = request;
		return;
	}


	request->next = request_packet->requests->next;
	request->prev = request_packet->requests;

	request_packet->requests->next = request;


}


/**
 */
AgentsRequestPacket * agents_request_packet_from_xml_string(const AlString * xml)
{
	AlXml               * x = al_xml_new_from_string(al_string_get(xml));
	AgentsRequestPacket * request_packet;


	request_packet = agents_request_packet_from_xml(x);
	al_xml_delete(x);

	return request_packet;
}


/**
 */
AgentsRequestPacket * agents_request_packet_from_xml(AlXml * xml)
{
	AgentsRequestPacket * request_packet;
	AgentsRequest       * request;
	AlXmlList           * list;
	AlXmlNode           * node;


	al_return_val_if_fail(xml, NULL);

	al_log(("agents_request_packet_from_xml:\n%s\n", xml->string));

	request_packet = agents_request_packet_new();
	list = al_xml_get_list(xml, "requests");
	if (list)
	{
		for (node = list->nodes; node; node = node->next)
		{

			request = agents_request_from_xml(node);

			if (request) agents_request_packet_request_add(request_packet, request);

		}
	}
	else
	{
		agents_request_packet_delete(request_packet);
		request_packet = NULL;
	}

	return request_packet;
}


/**
 */
AgentsRequest * agents_request_from_xml(AlXmlNode * node)
{
	AgentsRequest * ret;


	al_return_val_if_fail (node, NULL);

	ret = agents_request_new();

	agents_request_set_id(ret, al_xml_get_attribute_value(node, "id"));
	agents_request_set_server_name(ret, al_xml_get_attribute_value(node, "server"));
	agents_request_set_server_data(ret, al_xml_node_get_cdata(node));

	return ret;
}
