/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#ifndef AGENTS_H
#define AGENTS_H


#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include <al.h>

/**
 * Version
 */
#define AGENTS_VERSION_MAJOR               0
#define AGENTS_VERSION_MINOR               0
#define AGENTS_VERSION_MICRO               1
#define AGENTS_VERSION_NAME           agents

#define AGENTS_VERSION                AL_TO_VERSION(AGENTS_VERSION_NAME,AGENTS_VERSION_MAJOR,AGENTS_VERSION_MINOR,AGENTS_VERSION_MICRO)


/**
 * Default config file.
 */
#define AGENTS_CONFIG_FILE           "../etc/agents.conf"


#include "conf.h"
#include "request.h"
#include "response.h"


#endif /* AGENTS_H */
