/* tcpclient-inet_ends_threads.c generated by valac 0.20.1, the Vala compiler
 * generated from tcpclient-inet_ends_threads.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define TASKLETS_TYPE_TIMER (tasklets_timer_get_type ())
#define TASKLETS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_TIMER, TaskletsTimer))
#define TASKLETS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_TIMER, TaskletsTimerClass))
#define TASKLETS_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_TIMER))
#define TASKLETS_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_TIMER))
#define TASKLETS_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_TIMER, TaskletsTimerClass))

typedef struct _TaskletsTimer TaskletsTimer;
typedef struct _TaskletsTimerClass TaskletsTimerClass;
typedef struct _TaskletsTimerPrivate TaskletsTimerPrivate;

#define TASKLETS_TYPE_STAT (tasklets_stat_get_type ())
#define TASKLETS_STAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_STAT, TaskletsStat))
#define TASKLETS_STAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_STAT, TaskletsStatClass))
#define TASKLETS_IS_STAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_STAT))
#define TASKLETS_IS_STAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_STAT))
#define TASKLETS_STAT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_STAT, TaskletsStatClass))

typedef struct _TaskletsStat TaskletsStat;
typedef struct _TaskletsStatClass TaskletsStatClass;
typedef struct _TaskletsStatPrivate TaskletsStatPrivate;

#define TASKLETS_TYPE_STATUS (tasklets_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define ZCD_TYPE_ICONNECTED_STREAM_SOCKET (zcd_iconnected_stream_socket_get_type ())
#define ZCD_ICONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_ICONNECTED_STREAM_SOCKET, zcdIConnectedStreamSocket))
#define ZCD_IS_ICONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_ICONNECTED_STREAM_SOCKET))
#define ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_ICONNECTED_STREAM_SOCKET, zcdIConnectedStreamSocketIface))

typedef struct _zcdIConnectedStreamSocket zcdIConnectedStreamSocket;
typedef struct _zcdIConnectedStreamSocketIface zcdIConnectedStreamSocketIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define ZCD_TYPE_CALLER_INFO (zcd_caller_info_get_type ())
#define ZCD_CALLER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_CALLER_INFO, zcdCallerInfo))
#define ZCD_CALLER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_CALLER_INFO, zcdCallerInfoClass))
#define ZCD_IS_CALLER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_CALLER_INFO))
#define ZCD_IS_CALLER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_CALLER_INFO))
#define ZCD_CALLER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_CALLER_INFO, zcdCallerInfoClass))

typedef struct _zcdCallerInfo zcdCallerInfo;
typedef struct _zcdCallerInfoClass zcdCallerInfoClass;
typedef struct _zcdCallerInfoPrivate zcdCallerInfoPrivate;

#define ZCD_TYPE_FAKE_RMT (zcd_fake_rmt_get_type ())
#define ZCD_FAKE_RMT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_FAKE_RMT, zcdFakeRmt))
#define ZCD_IS_FAKE_RMT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_FAKE_RMT))
#define ZCD_FAKE_RMT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_FAKE_RMT, zcdFakeRmtIface))

typedef struct _zcdFakeRmt zcdFakeRmt;
typedef struct _zcdFakeRmtIface zcdFakeRmtIface;

#define ZCD_TYPE_REMOTE_CALL (zcd_remote_call_get_type ())
#define ZCD_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCall))
#define ZCD_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))
#define ZCD_IS_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_REMOTE_CALL))
#define ZCD_IS_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_REMOTE_CALL))
#define ZCD_REMOTE_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))

typedef struct _zcdRemoteCall zcdRemoteCall;
typedef struct _zcdRemoteCallClass zcdRemoteCallClass;

#define ZCD_TYPE_ISERIALIZABLE (zcd_iserializable_get_type ())
#define ZCD_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializable))
#define ZCD_IS_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_ISERIALIZABLE))
#define ZCD_ISERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializableIface))

typedef struct _zcdISerializable zcdISerializable;
typedef struct _zcdISerializableIface zcdISerializableIface;

#define ZCD_TYPE_TCP_CLIENT (zcd_tcp_client_get_type ())
#define ZCD_TCP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_TCP_CLIENT, zcdTCPClient))
#define ZCD_TCP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_TCP_CLIENT, zcdTCPClientClass))
#define ZCD_IS_TCP_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_TCP_CLIENT))
#define ZCD_IS_TCP_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_TCP_CLIENT))
#define ZCD_TCP_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_TCP_CLIENT, zcdTCPClientClass))

typedef struct _zcdTCPClient zcdTCPClient;
typedef struct _zcdTCPClientClass zcdTCPClientClass;
typedef struct _zcdTCPClientPrivate zcdTCPClientPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZCD_TYPE_TCP_REQUEST (zcd_tcp_request_get_type ())
#define ZCD_TCP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_TCP_REQUEST, zcdTCPRequest))
#define ZCD_TCP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_TCP_REQUEST, zcdTCPRequestClass))
#define ZCD_IS_TCP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_TCP_REQUEST))
#define ZCD_IS_TCP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_TCP_REQUEST))
#define ZCD_TCP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_TCP_REQUEST, zcdTCPRequestClass))

typedef struct _zcdTCPRequest zcdTCPRequest;
typedef struct _zcdTCPRequestClass zcdTCPRequestClass;

#define ZCD_TYPE_SERIALIZABLE_NONE (zcd_serializable_none_get_type ())
#define ZCD_SERIALIZABLE_NONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNone))
#define ZCD_SERIALIZABLE_NONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNoneClass))
#define ZCD_IS_SERIALIZABLE_NONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_NONE))
#define ZCD_IS_SERIALIZABLE_NONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_NONE))
#define ZCD_SERIALIZABLE_NONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNoneClass))

typedef struct _zcdSerializableNone zcdSerializableNone;
typedef struct _zcdSerializableNoneClass zcdSerializableNoneClass;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

#define ZCD_TYPE_CLIENT_STREAM_SOCKET (zcd_client_stream_socket_get_type ())
#define ZCD_CLIENT_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocket))
#define ZCD_CLIENT_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocketClass))
#define ZCD_IS_CLIENT_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_CLIENT_STREAM_SOCKET))
#define ZCD_IS_CLIENT_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_CLIENT_STREAM_SOCKET))
#define ZCD_CLIENT_STREAM_SOCKET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocketClass))

typedef struct _zcdClientStreamSocket zcdClientStreamSocket;
typedef struct _zcdClientStreamSocketClass zcdClientStreamSocketClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TaskletsTimer {
	GObject parent_instance;
	TaskletsTimerPrivate * priv;
	GTimeVal exp;
};

struct _TaskletsTimerClass {
	GObjectClass parent_class;
};

typedef enum  {
	TASKLETS_STATUS_SPAWNED,
	TASKLETS_STATUS_STARTED,
	TASKLETS_STATUS_ENDED,
	TASKLETS_STATUS_CRASHED,
	TASKLETS_STATUS_ABORTED
} TaskletsStatus;

struct _TaskletsStat {
	GObject parent_instance;
	TaskletsStatPrivate * priv;
	gint id;
	gint parent;
	gchar* funcname;
	TaskletsStatus status;
	gchar* crash_message;
};

struct _TaskletsStatClass {
	GObjectClass parent_class;
};

struct _zcdIConnectedStreamSocketIface {
	GTypeInterface parent_iface;
	guint16 (*_peer_port_getter) (zcdIConnectedStreamSocket* self);
	const gchar* (*_peer_address_getter) (zcdIConnectedStreamSocket* self);
	guint16 (*_my_port_getter) (zcdIConnectedStreamSocket* self);
	const gchar* (*_my_address_getter) (zcdIConnectedStreamSocket* self);
	gint (*send_part) (zcdIConnectedStreamSocket* self, guchar* data, int data_length1, gint maxlen, GError** error);
	guchar* (*recv) (zcdIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error);
	void (*close) (zcdIConnectedStreamSocket* self, GError** error);
};

struct _zcdCallerInfo {
	GObject parent_instance;
	zcdCallerInfoPrivate * priv;
	gchar* caller_ip;
	gchar* my_ip;
	gchar* dev;
};

struct _zcdCallerInfoClass {
	GObjectClass parent_class;
};

typedef enum  {
	ZCD_SERIALIZER_ERROR_GENERIC
} zcdSerializerError;
#define ZCD_SERIALIZER_ERROR zcd_serializer_error_quark ()
struct _zcdISerializableIface {
	GTypeInterface parent_iface;
	GVariant* (*serialize_to_variant) (zcdISerializable* self);
	void (*deserialize_from_variant) (zcdISerializable* self, GVariant* v, GError** error);
};

typedef enum  {
	ZCD_RPC_ERROR_FUNCTION_NOT_REMOTABLE,
	ZCD_RPC_ERROR_MALFORMED_PACKET,
	ZCD_RPC_ERROR_NETWORK_ERROR,
	ZCD_RPC_ERROR_NOT_VALID_MAP_YET,
	ZCD_RPC_ERROR_DROP,
	ZCD_RPC_ERROR_SERIALIZER_ERROR,
	ZCD_RPC_ERROR_GENERIC
} zcdRPCError;
#define ZCD_RPC_ERROR zcd_rpc_error_quark ()
struct _zcdFakeRmtIface {
	GTypeInterface parent_iface;
	zcdISerializable* (*rmt) (zcdFakeRmt* self, zcdRemoteCall* data, GError** error);
};

struct _zcdTCPClient {
	GObject parent_instance;
	zcdTCPClientPrivate * priv;
	guint16 dest_port;
};

struct _zcdTCPClientClass {
	GObjectClass parent_class;
};

struct _zcdTCPClientPrivate {
	gchar* _dest_addr;
	gchar* my_addr;
	gboolean wait_response;
	gboolean connected;
	gboolean _calling;
	gboolean _retry_connect;
	zcdIConnectedStreamSocket* socket;
};


static gpointer tasklets_timer_parent_class = NULL;
static gpointer tasklets_stat_parent_class = NULL;
extern gboolean zcd_endianness_network;
static gpointer zcd_caller_info_parent_class = NULL;
static gpointer zcd_tcp_client_parent_class = NULL;
static zcdFakeRmtIface* zcd_tcp_client_zcd_fake_rmt_parent_iface = NULL;

GType tasklets_timer_get_type (void) G_GNUC_CONST;
enum  {
	TASKLETS_TIMER_DUMMY_PROPERTY
};
TaskletsTimer* tasklets_timer_new (gint64 msec_ttl);
TaskletsTimer* tasklets_timer_construct (GType object_type, gint64 msec_ttl);
void tasklets_timer_set_time (TaskletsTimer* self, gint64 msec_ttl);
gint64 tasklets_timer_get_msec_ttl (TaskletsTimer* self);
gboolean tasklets_timer_is_younger (TaskletsTimer* self, TaskletsTimer* t);
gboolean tasklets_timer_is_expired (TaskletsTimer* self);
gchar* tasklets_timer_get_string_msec_ttl (TaskletsTimer* self);
static void tasklets_timer_finalize (GObject* obj);
GType tasklets_stat_get_type (void) G_GNUC_CONST;
GType tasklets_status_get_type (void) G_GNUC_CONST;
enum  {
	TASKLETS_STAT_DUMMY_PROPERTY
};
gboolean tasklets_stat_equal_func (TaskletsStat* a, TaskletsStat* b);
TaskletsStat* tasklets_stat_new (void);
TaskletsStat* tasklets_stat_construct (GType object_type);
static void tasklets_stat_finalize (GObject* obj);
guchar* zcd_data_pack (guchar* data, int data_length1, int* result_length1);
GType zcd_iconnected_stream_socket_get_type (void) G_GNUC_CONST;
guchar* zcd_data_unpack_from_stream (zcdIConnectedStreamSocket* socket, int* result_length1);
guchar* zcd_iconnected_stream_socket_recv (zcdIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error);
static guchar* _vala_array_dup2 (guchar* self, int length);
static guint _variant_get14 (GVariant* value);
static guchar* _vala_array_dup3 (guchar* self, int length);
GType zcd_caller_info_get_type (void) G_GNUC_CONST;
enum  {
	ZCD_CALLER_INFO_DUMMY_PROPERTY
};
zcdCallerInfo* zcd_caller_info_new (const gchar* caller_ip, const gchar* my_ip, const gchar* dev);
zcdCallerInfo* zcd_caller_info_construct (GType object_type, const gchar* caller_ip, const gchar* my_ip, const gchar* dev);
static void zcd_caller_info_finalize (GObject* obj);
GType zcd_remote_call_get_type (void) G_GNUC_CONST;
GQuark zcd_serializer_error_quark (void);
GType zcd_iserializable_get_type (void) G_GNUC_CONST;
GQuark zcd_rpc_error_quark (void);
GType zcd_fake_rmt_get_type (void) G_GNUC_CONST;
GType zcd_tcp_client_get_type (void) G_GNUC_CONST;
#define ZCD_TCP_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_TCP_CLIENT, zcdTCPClientPrivate))
enum  {
	ZCD_TCP_CLIENT_DUMMY_PROPERTY,
	ZCD_TCP_CLIENT_DEST_ADDR,
	ZCD_TCP_CLIENT_CALLING,
	ZCD_TCP_CLIENT_RETRY_CONNECT
};
void zcd_tcp_client_close (zcdTCPClient* self, GError** error);
zcdTCPClient* zcd_tcp_client_new (const gchar* dest_addr, guint16* dest_port, const gchar* my_addr, gboolean wait_response);
zcdTCPClient* zcd_tcp_client_construct (GType object_type, const gchar* dest_addr, guint16* dest_port, const gchar* my_addr, gboolean wait_response);
static void zcd_tcp_client_set_dest_addr (zcdTCPClient* self, const gchar* value);
static void zcd_tcp_client_set_calling (zcdTCPClient* self, gboolean value);
static zcdISerializable* zcd_tcp_client_real_rmt (zcdFakeRmt* base, zcdRemoteCall* data, GError** error);
gboolean zcd_tcp_client_get_calling (zcdTCPClient* self);
zcdTCPRequest* zcd_tcp_request_new (gboolean wait_response, zcdRemoteCall* data);
zcdTCPRequest* zcd_tcp_request_construct (GType object_type, gboolean wait_response, zcdRemoteCall* data);
GType zcd_tcp_request_get_type (void) G_GNUC_CONST;
void zcd_tcp_client_rpc_send (zcdTCPClient* self, guchar* serdata, int serdata_length1, GError** error);
guchar* zcd_iserializable_serialize (zcdISerializable* self, int* result_length1);
zcdISerializable* zcd_tcp_client_rpc_receive (zcdTCPClient* self, GError** error);
zcdSerializableNone* zcd_serializable_none_new (void);
zcdSerializableNone* zcd_serializable_none_construct (GType object_type);
GType zcd_serializable_none_get_type (void) G_GNUC_CONST;
void zcd_tcp_client_connect (zcdTCPClient* self);
gboolean zcd_tcp_client_get_retry_connect (zcdTCPClient* self);
const gchar* zcd_tcp_client_get_dest_addr (zcdTCPClient* self);
void zcd_iconnected_stream_socket_send (zcdIConnectedStreamSocket* self, guchar* data, int data_length1, GError** error);
zcdISerializable* zcd_iserializable_deserialize (guchar* ser, int ser_length1, GError** error);
zcdClientStreamSocket* zcd_client_stream_socket_new (const gchar* my_addr, GError** error);
zcdClientStreamSocket* zcd_client_stream_socket_construct (GType object_type, const gchar* my_addr, GError** error);
GType zcd_client_stream_socket_get_type (void) G_GNUC_CONST;
zcdIConnectedStreamSocket* zcd_client_stream_socket_socket_connect (zcdClientStreamSocket* self, const gchar* addr, guint16 port, GError** error);
void zcd_log_warn (const gchar* msg);
void zcd_iconnected_stream_socket_close (zcdIConnectedStreamSocket* self, GError** error);
void zcd_tcp_client_set_retry_connect (zcdTCPClient* self, gboolean value);
static void zcd_tcp_client_finalize (GObject* obj);
static void _vala_zcd_tcp_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zcd_tcp_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


TaskletsTimer* tasklets_timer_construct (GType object_type, gint64 msec_ttl) {
	TaskletsTimer * self = NULL;
	gint64 _tmp0_;
	self = (TaskletsTimer*) g_object_new (object_type, NULL);
	_tmp0_ = msec_ttl;
	tasklets_timer_set_time (self, _tmp0_);
	return self;
}


TaskletsTimer* tasklets_timer_new (gint64 msec_ttl) {
	return tasklets_timer_construct (TASKLETS_TYPE_TIMER, msec_ttl);
}


void tasklets_timer_set_time (TaskletsTimer* self, gint64 msec_ttl) {
	gint64 _tmp0_;
	glong milli;
	gint64 _tmp1_;
	glong seconds;
	GTimeVal _tmp2_;
	glong _tmp3_;
	gint64 check_seconds;
	gint64 _tmp4_;
	gint64 _tmp5_;
	glong _tmp6_;
	glong _tmp7_;
	g_return_if_fail (self != NULL);
	g_get_current_time (&self->exp);
	g_get_current_time (&self->exp);
	_tmp0_ = msec_ttl;
	milli = (glong) (_tmp0_ % ((gint64) 1000));
	_tmp1_ = msec_ttl;
	seconds = (glong) (_tmp1_ / ((gint64) 1000));
	_tmp2_ = self->exp;
	_tmp3_ = _tmp2_.tv_sec;
	check_seconds = (gint64) _tmp3_;
	_tmp4_ = check_seconds;
	check_seconds = _tmp4_ + ((gint64) seconds);
	_tmp5_ = check_seconds;
	_tmp6_ = G_MAXLONG;
	_vala_assert (_tmp5_ <= ((gint64) _tmp6_), "check_seconds <= long.MAX");
	g_time_val_add (&self->exp, milli * 1000);
	_tmp7_ = self->exp.tv_sec;
	self->exp.tv_sec = _tmp7_ + seconds;
}


gint64 tasklets_timer_get_msec_ttl (TaskletsTimer* self) {
	gint64 result = 0LL;
	GTimeVal now = {0};
	GTimeVal _tmp0_;
	glong _tmp1_;
	GTimeVal _tmp2_;
	glong _tmp3_;
	glong sec;
	GTimeVal _tmp4_;
	glong _tmp5_;
	GTimeVal _tmp6_;
	glong _tmp7_;
	glong usec;
	glong _tmp11_;
	glong _tmp12_;
	g_return_val_if_fail (self != NULL, 0LL);
	g_get_current_time (&now);
	g_get_current_time (&now);
	_tmp0_ = self->exp;
	_tmp1_ = _tmp0_.tv_sec;
	_tmp2_ = now;
	_tmp3_ = _tmp2_.tv_sec;
	sec = _tmp1_ - _tmp3_;
	_tmp4_ = self->exp;
	_tmp5_ = _tmp4_.tv_usec;
	_tmp6_ = now;
	_tmp7_ = _tmp6_.tv_usec;
	usec = _tmp5_ - _tmp7_;
	while (TRUE) {
		glong _tmp8_;
		glong _tmp9_;
		glong _tmp10_;
		_tmp8_ = usec;
		if (!(_tmp8_ < ((glong) 0))) {
			break;
		}
		_tmp9_ = usec;
		usec = _tmp9_ + 1000000;
		_tmp10_ = sec;
		sec = _tmp10_ - 1;
	}
	_tmp11_ = sec;
	_tmp12_ = usec;
	result = (((gint64) _tmp11_) * ((gint64) 1000)) + (((gint64) _tmp12_) / ((gint64) 1000));
	return result;
}


gboolean tasklets_timer_is_younger (TaskletsTimer* self, TaskletsTimer* t) {
	gboolean result = FALSE;
	GTimeVal _tmp0_;
	glong _tmp1_;
	TaskletsTimer* _tmp2_;
	GTimeVal _tmp3_;
	glong _tmp4_;
	GTimeVal _tmp5_;
	glong _tmp6_;
	TaskletsTimer* _tmp7_;
	GTimeVal _tmp8_;
	glong _tmp9_;
	GTimeVal _tmp10_;
	glong _tmp11_;
	TaskletsTimer* _tmp12_;
	GTimeVal _tmp13_;
	glong _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = self->exp;
	_tmp1_ = _tmp0_.tv_sec;
	_tmp2_ = t;
	_tmp3_ = _tmp2_->exp;
	_tmp4_ = _tmp3_.tv_sec;
	if (_tmp1_ > _tmp4_) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->exp;
	_tmp6_ = _tmp5_.tv_sec;
	_tmp7_ = t;
	_tmp8_ = _tmp7_->exp;
	_tmp9_ = _tmp8_.tv_sec;
	if (_tmp6_ < _tmp9_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = self->exp;
	_tmp11_ = _tmp10_.tv_usec;
	_tmp12_ = t;
	_tmp13_ = _tmp12_->exp;
	_tmp14_ = _tmp13_.tv_usec;
	if (_tmp11_ > _tmp14_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


gboolean tasklets_timer_is_expired (TaskletsTimer* self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tasklets_timer_get_msec_ttl (self);
	result = _tmp0_ < ((gint64) 0);
	return result;
}


gchar* tasklets_timer_get_string_msec_ttl (TaskletsTimer* self) {
	gchar* result = NULL;
	gint64 _tmp0_ = 0LL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = tasklets_timer_get_msec_ttl (self);
	_tmp1_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp0_);
	result = _tmp1_;
	return result;
}


static void tasklets_timer_class_init (TaskletsTimerClass * klass) {
	tasklets_timer_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tasklets_timer_finalize;
}


static void tasklets_timer_instance_init (TaskletsTimer * self) {
}


static void tasklets_timer_finalize (GObject* obj) {
	TaskletsTimer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKLETS_TYPE_TIMER, TaskletsTimer);
	G_OBJECT_CLASS (tasklets_timer_parent_class)->finalize (obj);
}


/** Class for "timeouts" or "timespans"
      */
GType tasklets_timer_get_type (void) {
	static volatile gsize tasklets_timer_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_timer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsTimerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklets_timer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskletsTimer), 0, (GInstanceInitFunc) tasklets_timer_instance_init, NULL };
		GType tasklets_timer_type_id;
		tasklets_timer_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskletsTimer", &g_define_type_info, 0);
		g_once_init_leave (&tasklets_timer_type_id__volatile, tasklets_timer_type_id);
	}
	return tasklets_timer_type_id__volatile;
}


gboolean tasklets_stat_equal_func (TaskletsStat* a, TaskletsStat* b) {
	gboolean result = FALSE;
	TaskletsStat* _tmp0_;
	gint _tmp1_;
	TaskletsStat* _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->id;
	_tmp2_ = b;
	_tmp3_ = _tmp2_->id;
	result = _tmp1_ == _tmp3_;
	return result;
}


TaskletsStat* tasklets_stat_construct (GType object_type) {
	TaskletsStat * self = NULL;
	self = (TaskletsStat*) g_object_new (object_type, NULL);
	return self;
}


TaskletsStat* tasklets_stat_new (void) {
	return tasklets_stat_construct (TASKLETS_TYPE_STAT);
}


static void tasklets_stat_class_init (TaskletsStatClass * klass) {
	tasklets_stat_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = tasklets_stat_finalize;
}


static void tasklets_stat_instance_init (TaskletsStat * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = g_strdup ("");
	self->funcname = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->crash_message = _tmp1_;
}


static void tasklets_stat_finalize (GObject* obj) {
	TaskletsStat * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKLETS_TYPE_STAT, TaskletsStat);
	_g_free0 (self->funcname);
	_g_free0 (self->crash_message);
	G_OBJECT_CLASS (tasklets_stat_parent_class)->finalize (obj);
}


GType tasklets_stat_get_type (void) {
	static volatile gsize tasklets_stat_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_stat_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsStatClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklets_stat_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskletsStat), 0, (GInstanceInitFunc) tasklets_stat_instance_init, NULL };
		GType tasklets_stat_type_id;
		tasklets_stat_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskletsStat", &g_define_type_info, 0);
		g_once_init_leave (&tasklets_stat_type_id__volatile, tasklets_stat_type_id);
	}
	return tasklets_stat_type_id__volatile;
}


GType tasklets_status_get_type (void) {
	static volatile gsize tasklets_status_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_status_type_id__volatile)) {
		static const GEnumValue values[] = {{TASKLETS_STATUS_SPAWNED, "TASKLETS_STATUS_SPAWNED", "spawned"}, {TASKLETS_STATUS_STARTED, "TASKLETS_STATUS_STARTED", "started"}, {TASKLETS_STATUS_ENDED, "TASKLETS_STATUS_ENDED", "ended"}, {TASKLETS_STATUS_CRASHED, "TASKLETS_STATUS_CRASHED", "crashed"}, {TASKLETS_STATUS_ABORTED, "TASKLETS_STATUS_ABORTED", "aborted"}, {0, NULL, NULL}};
		GType tasklets_status_type_id;
		tasklets_status_type_id = g_enum_register_static ("TaskletsStatus", values);
		g_once_init_leave (&tasklets_status_type_id__volatile, tasklets_status_type_id);
	}
	return tasklets_status_type_id__volatile;
}


/** Packs a message of variable size together with the indication of its size
      */
guchar* zcd_data_pack (guchar* data, int data_length1, int* result_length1) {
	guchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guint data_sz;
	guint _tmp1_;
	GVariant* _tmp2_;
	GVariant* data_hdr;
	GVariant* _tmp3_;
	gsize _tmp4_ = 0UL;
	guint data_hdr_sz;
	guchar* ser;
	gint ser_length1;
	gint _ser_size_;
	guint _tmp5_;
	guint _tmp6_;
	guchar* _tmp7_ = NULL;
	gboolean _tmp20_;
	GVariant* _tmp23_;
	guchar* _tmp24_;
	gint _tmp24__length1;
	guchar* _tmp25_;
	gint _tmp25__length1;
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	data_sz = (guint) _tmp0__length1;
	_tmp1_ = data_sz;
	_tmp2_ = g_variant_new_uint32 ((guint32) _tmp1_);
	g_variant_ref_sink (_tmp2_);
	data_hdr = _tmp2_;
	_tmp3_ = data_hdr;
	_tmp4_ = g_variant_get_size (_tmp3_);
	data_hdr_sz = (guint) _tmp4_;
	ser = NULL;
	ser_length1 = 0;
	_ser_size_ = ser_length1;
	_tmp5_ = data_hdr_sz;
	_tmp6_ = data_sz;
	_tmp7_ = g_new0 (guchar, _tmp5_ + _tmp6_);
	ser = (g_free (ser), NULL);
	ser = _tmp7_;
	ser_length1 = _tmp5_ + _tmp6_;
	_ser_size_ = ser_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				guint _tmp12_;
				guchar* _tmp13_;
				gint _tmp13__length1;
				guint _tmp14_;
				gint _tmp15_;
				guchar* _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				guchar _tmp18_;
				guchar _tmp19_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = data_sz;
				if (!(((guint) _tmp11_) < _tmp12_)) {
					break;
				}
				_tmp13_ = ser;
				_tmp13__length1 = ser_length1;
				_tmp14_ = data_hdr_sz;
				_tmp15_ = i;
				_tmp16_ = data;
				_tmp16__length1 = data_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				_tmp13_[_tmp14_ + _tmp15_] = _tmp18_;
				_tmp19_ = _tmp13_[_tmp14_ + _tmp15_];
			}
		}
	}
	_tmp20_ = zcd_endianness_network;
	if (!_tmp20_) {
		GVariant* _tmp21_;
		GVariant* _tmp22_ = NULL;
		_tmp21_ = data_hdr;
		_tmp22_ = g_variant_byteswap (_tmp21_);
		_g_variant_unref0 (data_hdr);
		data_hdr = _tmp22_;
	}
	_tmp23_ = data_hdr;
	_tmp24_ = ser;
	_tmp24__length1 = ser_length1;
	g_variant_store (_tmp23_, _tmp24_);
	_tmp25_ = ser;
	_tmp25__length1 = ser_length1;
	if (result_length1) {
		*result_length1 = _tmp25__length1;
	}
	result = _tmp25_;
	_g_variant_unref0 (data_hdr);
	return result;
}


/** Reads from a stream a message of variable size (use with tcp streams)
      */
static guchar* _vala_array_dup2 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


static guint _variant_get14 (GVariant* value) {
	return g_variant_get_uint32 (value);
}


static guchar* _vala_array_dup3 (guchar* self, int length) {
	return g_memdup (self, length * sizeof (guchar));
}


guchar* zcd_data_unpack_from_stream (zcdIConnectedStreamSocket* socket, int* result_length1) {
	guchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (socket != NULL, NULL);
	{
		gint i = 0;
		guchar* _tmp0_ = NULL;
		guchar* readBuffer;
		gint readBuffer_length1;
		gint _readBuffer_size_;
		GVariant* _tmp1_;
		GVariant* data_hdr_tmp;
		GVariant* _tmp2_;
		gsize _tmp3_ = 0UL;
		guint data_hdr_sz;
		_tmp0_ = g_new0 (guchar, 0);
		readBuffer = _tmp0_;
		readBuffer_length1 = 0;
		_readBuffer_size_ = readBuffer_length1;
		_tmp1_ = g_variant_new_uint32 ((guint32) 0);
		g_variant_ref_sink (_tmp1_);
		data_hdr_tmp = _tmp1_;
		_tmp2_ = data_hdr_tmp;
		_tmp3_ = g_variant_get_size (_tmp2_);
		data_hdr_sz = (guint) _tmp3_;
		while (TRUE) {
			zcdIConnectedStreamSocket* _tmp4_;
			guint _tmp5_;
			guchar* _tmp6_;
			gint _tmp6__length1;
			gint _tmp7_ = 0;
			guchar* _tmp8_ = NULL;
			guchar* rawPacket;
			gint rawPacket_length1;
			gint _rawPacket_size_;
			guchar* _tmp9_;
			gint _tmp9__length1;
			guchar* _tmp10_;
			gint _tmp10__length1;
			guchar* _tmp11_ = NULL;
			guchar* tempBuffer;
			gint tempBuffer_length1;
			gint _tempBuffer_size_;
			guchar* _tmp35_;
			gint _tmp35__length1;
			guchar* _tmp36_;
			gint _tmp36__length1;
			guchar* _tmp37_;
			gint _tmp37__length1;
			guint _tmp38_;
			_tmp4_ = socket;
			_tmp5_ = data_hdr_sz;
			_tmp6_ = readBuffer;
			_tmp6__length1 = readBuffer_length1;
			_tmp8_ = zcd_iconnected_stream_socket_recv (_tmp4_, (gint) (_tmp5_ - _tmp6__length1), &_tmp7_, &_inner_error_);
			rawPacket = _tmp8_;
			rawPacket_length1 = _tmp7_;
			_rawPacket_size_ = rawPacket_length1;
			if (_inner_error_ != NULL) {
				_g_variant_unref0 (data_hdr_tmp);
				readBuffer = (g_free (readBuffer), NULL);
				goto __catch1_g_error;
			}
			_tmp9_ = readBuffer;
			_tmp9__length1 = readBuffer_length1;
			_tmp10_ = rawPacket;
			_tmp10__length1 = rawPacket_length1;
			_tmp11_ = g_new0 (guchar, _tmp9__length1 + _tmp10__length1);
			tempBuffer = _tmp11_;
			tempBuffer_length1 = _tmp9__length1 + _tmp10__length1;
			_tempBuffer_size_ = tempBuffer_length1;
			{
				gboolean _tmp12_;
				i = 0;
				_tmp12_ = TRUE;
				while (TRUE) {
					gboolean _tmp13_;
					gint _tmp15_;
					guchar* _tmp16_;
					gint _tmp16__length1;
					guchar* _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_;
					guchar* _tmp19_;
					gint _tmp19__length1;
					gint _tmp20_;
					guchar _tmp21_;
					guchar _tmp22_;
					_tmp13_ = _tmp12_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp15_ = i;
					_tmp16_ = readBuffer;
					_tmp16__length1 = readBuffer_length1;
					if (!(_tmp15_ < _tmp16__length1)) {
						break;
					}
					_tmp17_ = tempBuffer;
					_tmp17__length1 = tempBuffer_length1;
					_tmp18_ = i;
					_tmp19_ = readBuffer;
					_tmp19__length1 = readBuffer_length1;
					_tmp20_ = i;
					_tmp21_ = _tmp19_[_tmp20_];
					_tmp17_[_tmp18_] = _tmp21_;
					_tmp22_ = _tmp17_[_tmp18_];
				}
			}
			{
				gboolean _tmp23_;
				i = 0;
				_tmp23_ = TRUE;
				while (TRUE) {
					gboolean _tmp24_;
					gint _tmp26_;
					guchar* _tmp27_;
					gint _tmp27__length1;
					guchar* _tmp28_;
					gint _tmp28__length1;
					guchar* _tmp29_;
					gint _tmp29__length1;
					gint _tmp30_;
					guchar* _tmp31_;
					gint _tmp31__length1;
					gint _tmp32_;
					guchar _tmp33_;
					guchar _tmp34_;
					_tmp24_ = _tmp23_;
					if (!_tmp24_) {
						gint _tmp25_;
						_tmp25_ = i;
						i = _tmp25_ + 1;
					}
					_tmp23_ = FALSE;
					_tmp26_ = i;
					_tmp27_ = rawPacket;
					_tmp27__length1 = rawPacket_length1;
					if (!(_tmp26_ < _tmp27__length1)) {
						break;
					}
					_tmp28_ = tempBuffer;
					_tmp28__length1 = tempBuffer_length1;
					_tmp29_ = readBuffer;
					_tmp29__length1 = readBuffer_length1;
					_tmp30_ = i;
					_tmp31_ = rawPacket;
					_tmp31__length1 = rawPacket_length1;
					_tmp32_ = i;
					_tmp33_ = _tmp31_[_tmp32_];
					_tmp28_[_tmp29__length1 + _tmp30_] = _tmp33_;
					_tmp34_ = _tmp28_[_tmp29__length1 + _tmp30_];
				}
			}
			_tmp35_ = tempBuffer;
			_tmp35__length1 = tempBuffer_length1;
			_tmp36_ = (_tmp35_ != NULL) ? _vala_array_dup2 (_tmp35_, _tmp35__length1) : ((gpointer) _tmp35_);
			_tmp36__length1 = _tmp35__length1;
			readBuffer = (g_free (readBuffer), NULL);
			readBuffer = _tmp36_;
			readBuffer_length1 = _tmp36__length1;
			_readBuffer_size_ = readBuffer_length1;
			_tmp37_ = readBuffer;
			_tmp37__length1 = readBuffer_length1;
			_tmp38_ = data_hdr_sz;
			if (((guint) _tmp37__length1) == _tmp38_) {
				const GVariantType* _tmp39_;
				guchar* _tmp40_;
				gint _tmp40__length1;
				GVariant* _tmp41_ = NULL;
				GVariant* data_hdr;
				gboolean _tmp42_;
				GVariant* _tmp45_;
				guint _tmp46_;
				guint data_sz;
				guchar* _tmp47_ = NULL;
				guchar* _tmp84_;
				gint _tmp84__length1;
				_tmp39_ = G_VARIANT_TYPE_UINT32;
				_tmp40_ = readBuffer;
				_tmp40__length1 = readBuffer_length1;
				_tmp41_ = g_variant_new_from_data (_tmp39_, _tmp40_, _tmp40__length1, FALSE, g_free, NULL);
				g_variant_ref_sink (_tmp41_);
				data_hdr = _tmp41_;
				_tmp42_ = zcd_endianness_network;
				if (!_tmp42_) {
					GVariant* _tmp43_;
					GVariant* _tmp44_ = NULL;
					_tmp43_ = data_hdr;
					_tmp44_ = g_variant_byteswap (_tmp43_);
					_g_variant_unref0 (data_hdr);
					data_hdr = _tmp44_;
				}
				_tmp45_ = data_hdr;
				_tmp46_ = _variant_get14 (_tmp45_);
				data_sz = _tmp46_;
				_tmp47_ = g_new0 (guchar, 0);
				readBuffer = (g_free (readBuffer), NULL);
				readBuffer = _tmp47_;
				readBuffer_length1 = 0;
				_readBuffer_size_ = readBuffer_length1;
				while (TRUE) {
					guchar* _tmp48_;
					gint _tmp48__length1;
					guint _tmp49_;
					zcdIConnectedStreamSocket* _tmp50_;
					guint _tmp51_;
					guchar* _tmp52_;
					gint _tmp52__length1;
					gint _tmp53_ = 0;
					guchar* _tmp54_ = NULL;
					guchar* _tmp55_;
					gint _tmp55__length1;
					gint __tmp55__size_;
					guchar* _tmp56_;
					gint _tmp56__length1;
					guchar* _tmp57_;
					gint _tmp57__length1;
					guchar* _tmp58_ = NULL;
					guchar* _tmp82_;
					gint _tmp82__length1;
					guchar* _tmp83_;
					gint _tmp83__length1;
					_tmp48_ = readBuffer;
					_tmp48__length1 = readBuffer_length1;
					_tmp49_ = data_sz;
					if (!(((guint) _tmp48__length1) != _tmp49_)) {
						break;
					}
					_tmp50_ = socket;
					_tmp51_ = data_sz;
					_tmp52_ = readBuffer;
					_tmp52__length1 = readBuffer_length1;
					_tmp54_ = zcd_iconnected_stream_socket_recv (_tmp50_, (gint) (_tmp51_ - _tmp52__length1), &_tmp53_, &_inner_error_);
					_tmp55_ = _tmp54_;
					_tmp55__length1 = _tmp53_;
					__tmp55__size_ = _tmp55__length1;
					if (_inner_error_ != NULL) {
						_g_variant_unref0 (data_hdr);
						tempBuffer = (g_free (tempBuffer), NULL);
						rawPacket = (g_free (rawPacket), NULL);
						_g_variant_unref0 (data_hdr_tmp);
						readBuffer = (g_free (readBuffer), NULL);
						goto __catch1_g_error;
					}
					rawPacket = (g_free (rawPacket), NULL);
					rawPacket = _tmp55_;
					rawPacket_length1 = _tmp55__length1;
					_rawPacket_size_ = rawPacket_length1;
					_tmp56_ = readBuffer;
					_tmp56__length1 = readBuffer_length1;
					_tmp57_ = rawPacket;
					_tmp57__length1 = rawPacket_length1;
					_tmp58_ = g_new0 (guchar, _tmp56__length1 + _tmp57__length1);
					tempBuffer = (g_free (tempBuffer), NULL);
					tempBuffer = _tmp58_;
					tempBuffer_length1 = _tmp56__length1 + _tmp57__length1;
					_tempBuffer_size_ = tempBuffer_length1;
					{
						gboolean _tmp59_;
						i = 0;
						_tmp59_ = TRUE;
						while (TRUE) {
							gboolean _tmp60_;
							gint _tmp62_;
							guchar* _tmp63_;
							gint _tmp63__length1;
							guchar* _tmp64_;
							gint _tmp64__length1;
							gint _tmp65_;
							guchar* _tmp66_;
							gint _tmp66__length1;
							gint _tmp67_;
							guchar _tmp68_;
							guchar _tmp69_;
							_tmp60_ = _tmp59_;
							if (!_tmp60_) {
								gint _tmp61_;
								_tmp61_ = i;
								i = _tmp61_ + 1;
							}
							_tmp59_ = FALSE;
							_tmp62_ = i;
							_tmp63_ = readBuffer;
							_tmp63__length1 = readBuffer_length1;
							if (!(_tmp62_ < _tmp63__length1)) {
								break;
							}
							_tmp64_ = tempBuffer;
							_tmp64__length1 = tempBuffer_length1;
							_tmp65_ = i;
							_tmp66_ = readBuffer;
							_tmp66__length1 = readBuffer_length1;
							_tmp67_ = i;
							_tmp68_ = _tmp66_[_tmp67_];
							_tmp64_[_tmp65_] = _tmp68_;
							_tmp69_ = _tmp64_[_tmp65_];
						}
					}
					{
						gboolean _tmp70_;
						i = 0;
						_tmp70_ = TRUE;
						while (TRUE) {
							gboolean _tmp71_;
							gint _tmp73_;
							guchar* _tmp74_;
							gint _tmp74__length1;
							guchar* _tmp75_;
							gint _tmp75__length1;
							guchar* _tmp76_;
							gint _tmp76__length1;
							gint _tmp77_;
							guchar* _tmp78_;
							gint _tmp78__length1;
							gint _tmp79_;
							guchar _tmp80_;
							guchar _tmp81_;
							_tmp71_ = _tmp70_;
							if (!_tmp71_) {
								gint _tmp72_;
								_tmp72_ = i;
								i = _tmp72_ + 1;
							}
							_tmp70_ = FALSE;
							_tmp73_ = i;
							_tmp74_ = rawPacket;
							_tmp74__length1 = rawPacket_length1;
							if (!(_tmp73_ < _tmp74__length1)) {
								break;
							}
							_tmp75_ = tempBuffer;
							_tmp75__length1 = tempBuffer_length1;
							_tmp76_ = readBuffer;
							_tmp76__length1 = readBuffer_length1;
							_tmp77_ = i;
							_tmp78_ = rawPacket;
							_tmp78__length1 = rawPacket_length1;
							_tmp79_ = i;
							_tmp80_ = _tmp78_[_tmp79_];
							_tmp75_[_tmp76__length1 + _tmp77_] = _tmp80_;
							_tmp81_ = _tmp75_[_tmp76__length1 + _tmp77_];
						}
					}
					_tmp82_ = tempBuffer;
					_tmp82__length1 = tempBuffer_length1;
					_tmp83_ = (_tmp82_ != NULL) ? _vala_array_dup3 (_tmp82_, _tmp82__length1) : ((gpointer) _tmp82_);
					_tmp83__length1 = _tmp82__length1;
					readBuffer = (g_free (readBuffer), NULL);
					readBuffer = _tmp83_;
					readBuffer_length1 = _tmp83__length1;
					_readBuffer_size_ = readBuffer_length1;
				}
				_tmp84_ = readBuffer;
				_tmp84__length1 = readBuffer_length1;
				if (result_length1) {
					*result_length1 = _tmp84__length1;
				}
				result = _tmp84_;
				_g_variant_unref0 (data_hdr);
				tempBuffer = (g_free (tempBuffer), NULL);
				rawPacket = (g_free (rawPacket), NULL);
				_g_variant_unref0 (data_hdr_tmp);
				return result;
			}
			tempBuffer = (g_free (tempBuffer), NULL);
			rawPacket = (g_free (rawPacket), NULL);
		}
		_g_variant_unref0 (data_hdr_tmp);
		readBuffer = (g_free (readBuffer), NULL);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		guchar* _tmp85_ = NULL;
		guchar* _tmp86_;
		gint _tmp86__length1;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp85_ = g_new0 (guchar, 0);
		_tmp86_ = _tmp85_;
		_tmp86__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp86__length1;
		}
		result = _tmp86_;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


zcdCallerInfo* zcd_caller_info_construct (GType object_type, const gchar* caller_ip, const gchar* my_ip, const gchar* dev) {
	zcdCallerInfo * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	self = (zcdCallerInfo*) g_object_new (object_type, NULL);
	_tmp0_ = caller_ip;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->caller_ip);
	self->caller_ip = _tmp1_;
	_tmp2_ = my_ip;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->my_ip);
	self->my_ip = _tmp3_;
	_tmp4_ = dev;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->dev);
	self->dev = _tmp5_;
	return self;
}


zcdCallerInfo* zcd_caller_info_new (const gchar* caller_ip, const gchar* my_ip, const gchar* dev) {
	return zcd_caller_info_construct (ZCD_TYPE_CALLER_INFO, caller_ip, my_ip, dev);
}


static void zcd_caller_info_class_init (zcdCallerInfoClass * klass) {
	zcd_caller_info_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = zcd_caller_info_finalize;
}


static void zcd_caller_info_instance_init (zcdCallerInfo * self) {
}


static void zcd_caller_info_finalize (GObject* obj) {
	zcdCallerInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_CALLER_INFO, zcdCallerInfo);
	_g_free0 (self->caller_ip);
	_g_free0 (self->my_ip);
	_g_free0 (self->dev);
	G_OBJECT_CLASS (zcd_caller_info_parent_class)->finalize (obj);
}


/** Informations about an host that sent us a message.
      * This is useless at the moment in zcd-tcpclient because is used only
      * on server side, but it is present as an argument (nullable) in some
      * methods' signature.
      */
GType zcd_caller_info_get_type (void) {
	static volatile gsize zcd_caller_info_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_caller_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdCallerInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_caller_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdCallerInfo), 0, (GInstanceInitFunc) zcd_caller_info_instance_init, NULL };
		GType zcd_caller_info_type_id;
		zcd_caller_info_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdCallerInfo", &g_define_type_info, 0);
		g_once_init_leave (&zcd_caller_info_type_id__volatile, zcd_caller_info_type_id);
	}
	return zcd_caller_info_type_id__volatile;
}


zcdTCPClient* zcd_tcp_client_construct (GType object_type, const gchar* dest_addr, guint16* dest_port, const gchar* my_addr, gboolean wait_response) {
	zcdTCPClient * self = NULL;
	guint16* _tmp0_;
	const gchar* _tmp2_;
	guint16* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	g_return_val_if_fail (dest_addr != NULL, NULL);
	self = (zcdTCPClient*) g_object_new (object_type, NULL);
	_tmp0_ = dest_port;
	if (_tmp0_ == NULL) {
		guint16 _tmp1_;
		_tmp1_ = (guint16) 269;
		dest_port = &_tmp1_;
	}
	_tmp2_ = dest_addr;
	zcd_tcp_client_set_dest_addr (self, _tmp2_);
	_tmp3_ = dest_port;
	self->dest_port = *_tmp3_;
	_tmp4_ = my_addr;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->priv->my_addr);
	self->priv->my_addr = _tmp5_;
	_tmp6_ = wait_response;
	self->priv->wait_response = _tmp6_;
	_g_object_unref0 (self->priv->socket);
	self->priv->socket = NULL;
	self->priv->connected = FALSE;
	zcd_tcp_client_set_calling (self, FALSE);
	return self;
}


zcdTCPClient* zcd_tcp_client_new (const gchar* dest_addr, guint16* dest_port, const gchar* my_addr, gboolean wait_response) {
	return zcd_tcp_client_construct (ZCD_TYPE_TCP_CLIENT, dest_addr, dest_port, my_addr, wait_response);
}


static zcdISerializable* zcd_tcp_client_real_rmt (zcdFakeRmt* base, zcdRemoteCall* data, GError** error) {
	zcdTCPClient * self;
	zcdISerializable* result = NULL;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	self = (zcdTCPClient*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = self->priv->_calling;
	if (_tmp0_) {
		while (TRUE) {
			gboolean _tmp1_;
			_tmp1_ = self->priv->_calling;
			if (!_tmp1_) {
				break;
			}
			g_usleep ((gulong) 1000);
		}
	}
	{
		gboolean _tmp2_;
		zcdRemoteCall* _tmp3_;
		zcdTCPRequest* _tmp4_;
		zcdTCPRequest* message;
		zcdTCPRequest* _tmp5_;
		gint _tmp6_ = 0;
		guchar* _tmp7_ = NULL;
		guchar* _tmp8_;
		gint _tmp8__length1;
		gboolean _tmp9_;
		zcdSerializableNone* _tmp12_;
		zcd_tcp_client_set_calling (self, TRUE);
		_tmp2_ = self->priv->wait_response;
		_tmp3_ = data;
		_tmp4_ = zcd_tcp_request_new (_tmp2_, _tmp3_);
		message = _tmp4_;
		_tmp5_ = message;
		_tmp7_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp5_, &_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp8__length1 = _tmp6_;
		zcd_tcp_client_rpc_send (self, _tmp8_, _tmp6_, &_inner_error_);
		_tmp8_ = (g_free (_tmp8_), NULL);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (message);
			goto __finally2;
		}
		_tmp9_ = self->priv->wait_response;
		if (_tmp9_) {
			zcdISerializable* _tmp10_ = NULL;
			zcdISerializable* _tmp11_;
			_tmp10_ = zcd_tcp_client_rpc_receive (self, &_inner_error_);
			_tmp11_ = _tmp10_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (message);
				goto __finally2;
			}
			result = _tmp11_;
			_g_object_unref0 (message);
			{
				zcd_tcp_client_set_calling (self, FALSE);
			}
			return result;
		}
		_tmp12_ = zcd_serializable_none_new ();
		result = (zcdISerializable*) _tmp12_;
		_g_object_unref0 (message);
		{
			zcd_tcp_client_set_calling (self, FALSE);
		}
		return result;
	}
	__finally2:
	{
		zcd_tcp_client_set_calling (self, FALSE);
	}
	if (_inner_error_->domain == ZCD_RPC_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void zcd_tcp_client_rpc_send (zcdTCPClient* self, guchar* serdata, int serdata_length1, GError** error) {
	GTimer* _tmp0_;
	GTimer* timeout;
	gint interval;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_timer_new ();
	timeout = _tmp0_;
	interval = 5;
	while (TRUE) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = self->priv->connected;
		if (!(!_tmp1_)) {
			break;
		}
		zcd_tcp_client_connect (self);
		_tmp2_ = self->priv->connected;
		if (!_tmp2_) {
			gboolean _tmp3_ = FALSE;
			gboolean _tmp4_;
			gboolean _tmp7_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			_tmp4_ = self->priv->_retry_connect;
			if (!_tmp4_) {
				_tmp3_ = TRUE;
			} else {
				GTimer* _tmp5_;
				gdouble _tmp6_ = 0.0;
				_tmp5_ = timeout;
				_tmp6_ = g_timer_elapsed (_tmp5_, NULL);
				_tmp3_ = _tmp6_ > ((gdouble) 30);
			}
			_tmp7_ = _tmp3_;
			if (_tmp7_) {
				const gchar* _tmp8_;
				const gchar* _tmp9_ = NULL;
				guint16 _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				GError* _tmp15_;
				GError* _tmp16_;
				_tmp8_ = self->priv->_dest_addr;
				_tmp9_ = string_to_string (_tmp8_);
				_tmp10_ = self->dest_port;
				_tmp11_ = g_strdup_printf ("%hu", _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat ("Failed connecting to (\"", _tmp9_, "\", ", _tmp12_, ")", NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, _tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				_inner_error_ = _tmp16_;
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_timer_destroy0 (timeout);
					return;
				} else {
					_g_timer_destroy0 (timeout);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp17_ = interval;
			g_usleep ((gulong) (_tmp17_ * 1000));
			_tmp18_ = interval;
			interval = _tmp18_ * 2;
			_tmp19_ = interval;
			if (_tmp19_ > 10000) {
				interval = 10000;
			}
		}
	}
	{
		zcdIConnectedStreamSocket* _tmp20_;
		guchar* _tmp21_;
		gint _tmp21__length1;
		gint _tmp22_ = 0;
		guchar* _tmp23_ = NULL;
		guchar* _tmp24_;
		gint _tmp24__length1;
		_tmp20_ = self->priv->socket;
		_tmp21_ = serdata;
		_tmp21__length1 = serdata_length1;
		_tmp23_ = zcd_data_pack (_tmp21_, _tmp21__length1, &_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp24__length1 = _tmp22_;
		zcd_iconnected_stream_socket_send (_tmp20_, _tmp24_, _tmp22_, &_inner_error_);
		_tmp24_ = (g_free (_tmp24_), NULL);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		GError* _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		self->priv->connected = FALSE;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		_tmp27_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, _tmp26_);
		_inner_error_ = _tmp27_;
		_g_error_free0 (e);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_timer_destroy0 (timeout);
			return;
		} else {
			_g_timer_destroy0 (timeout);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_timer_destroy0 (timeout);
}


zcdISerializable* zcd_tcp_client_rpc_receive (zcdTCPClient* self, GError** error) {
	zcdISerializable* result = NULL;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->connected;
	if (_tmp0_) {
		zcdIConnectedStreamSocket* _tmp1_;
		gint _tmp2_ = 0;
		guchar* _tmp3_ = NULL;
		guchar* recv_encoded_data;
		gint recv_encoded_data_length1;
		gint _recv_encoded_data_size_;
		guchar* _tmp4_;
		gint _tmp4__length1;
		zcdISerializable* ret = NULL;
		_tmp1_ = self->priv->socket;
		_tmp3_ = zcd_data_unpack_from_stream (_tmp1_, &_tmp2_);
		recv_encoded_data = _tmp3_;
		recv_encoded_data_length1 = _tmp2_;
		_recv_encoded_data_size_ = recv_encoded_data_length1;
		_tmp4_ = recv_encoded_data;
		_tmp4__length1 = recv_encoded_data_length1;
		if (_tmp4__length1 == 0) {
			GError* _tmp5_;
			self->priv->connected = FALSE;
			_tmp5_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, "Connection closed before reply");
			_inner_error_ = _tmp5_;
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				g_propagate_error (error, _inner_error_);
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				return NULL;
			} else {
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		{
			guchar* _tmp6_;
			gint _tmp6__length1;
			zcdISerializable* _tmp7_ = NULL;
			zcdISerializable* _tmp8_;
			_tmp6_ = recv_encoded_data;
			_tmp6__length1 = recv_encoded_data_length1;
			_tmp7_ = zcd_iserializable_deserialize (_tmp6_, _tmp6__length1, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
					goto __catch4_zcd_serializer_error;
				}
				_g_object_unref0 (ret);
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_g_object_unref0 (ret);
			ret = _tmp8_;
		}
		goto __finally4;
		__catch4_zcd_serializer_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_SERIALIZER_ERROR, "Error deserializing response");
			_inner_error_ = _tmp9_;
			_g_error_free0 (e);
			goto __finally4;
		}
		__finally4:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (ret);
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				return NULL;
			} else {
				_g_object_unref0 (ret);
				recv_encoded_data = (g_free (recv_encoded_data), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = ret;
		recv_encoded_data = (g_free (recv_encoded_data), NULL);
		return result;
	} else {
		GError* _tmp10_;
		_tmp10_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, "Connection closed before reply");
		_inner_error_ = _tmp10_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
}


void zcd_tcp_client_connect (zcdTCPClient* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		const gchar* _tmp0_;
		zcdClientStreamSocket* _tmp1_;
		zcdClientStreamSocket* x;
		zcdClientStreamSocket* _tmp2_;
		const gchar* _tmp3_;
		guint16 _tmp4_;
		zcdIConnectedStreamSocket* _tmp5_ = NULL;
		zcdIConnectedStreamSocket* _tmp6_;
		_tmp0_ = self->priv->my_addr;
		_tmp1_ = zcd_client_stream_socket_new (_tmp0_, &_inner_error_);
		x = _tmp1_;
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
		_tmp2_ = x;
		_tmp3_ = self->priv->_dest_addr;
		_tmp4_ = self->dest_port;
		_tmp5_ = zcd_client_stream_socket_socket_connect (_tmp2_, _tmp3_, _tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (x);
			goto __catch5_g_error;
		}
		_g_object_unref0 (self->priv->socket);
		self->priv->socket = _tmp6_;
		self->priv->connected = TRUE;
		_g_object_unref0 (x);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("TCPClient: socket connect error: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		zcd_log_warn (_tmp11_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void zcd_tcp_client_close (zcdTCPClient* self, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->connected;
	if (_tmp0_) {
		zcdIConnectedStreamSocket* _tmp1_;
		_tmp1_ = self->priv->socket;
		if (_tmp1_ != NULL) {
			{
				zcdIConnectedStreamSocket* _tmp2_;
				_tmp2_ = self->priv->socket;
				zcd_iconnected_stream_socket_close (_tmp2_, &_inner_error_);
				if (_inner_error_ != NULL) {
					goto __catch6_g_error;
				}
			}
			goto __finally6;
			__catch6_g_error:
			{
				GError* e = NULL;
				GError* _tmp3_;
				const gchar* _tmp4_;
				GError* _tmp5_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp3_ = e;
				_tmp4_ = _tmp3_->message;
				_tmp5_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NETWORK_ERROR, _tmp4_);
				_inner_error_ = _tmp5_;
				_g_error_free0 (e);
				goto __finally6;
			}
			__finally6:
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_object_unref0 (self->priv->socket);
			self->priv->socket = NULL;
		}
		self->priv->connected = FALSE;
	}
}


const gchar* zcd_tcp_client_get_dest_addr (zcdTCPClient* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dest_addr;
	result = _tmp0_;
	return result;
}


static void zcd_tcp_client_set_dest_addr (zcdTCPClient* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dest_addr);
	self->priv->_dest_addr = _tmp1_;
	g_object_notify ((GObject *) self, "dest-addr");
}


gboolean zcd_tcp_client_get_calling (zcdTCPClient* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_calling;
	result = _tmp0_;
	return result;
}


static void zcd_tcp_client_set_calling (zcdTCPClient* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_calling = _tmp0_;
	g_object_notify ((GObject *) self, "calling");
}


gboolean zcd_tcp_client_get_retry_connect (zcdTCPClient* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_retry_connect;
	result = _tmp0_;
	return result;
}


void zcd_tcp_client_set_retry_connect (zcdTCPClient* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_retry_connect = _tmp0_;
	g_object_notify ((GObject *) self, "retry-connect");
}


static void zcd_tcp_client_class_init (zcdTCPClientClass * klass) {
	zcd_tcp_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdTCPClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_tcp_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zcd_tcp_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_tcp_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_TCP_CLIENT_DEST_ADDR, g_param_spec_string ("dest-addr", "dest-addr", "dest-addr", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_TCP_CLIENT_CALLING, g_param_spec_boolean ("calling", "calling", "calling", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_TCP_CLIENT_RETRY_CONNECT, g_param_spec_boolean ("retry-connect", "retry-connect", "retry-connect", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void zcd_tcp_client_zcd_fake_rmt_interface_init (zcdFakeRmtIface * iface) {
	zcd_tcp_client_zcd_fake_rmt_parent_iface = g_type_interface_peek_parent (iface);
	iface->rmt = (zcdISerializable* (*)(zcdFakeRmt*, zcdRemoteCall*, GError**)) zcd_tcp_client_real_rmt;
}


static void zcd_tcp_client_instance_init (zcdTCPClient * self) {
	self->priv = ZCD_TCP_CLIENT_GET_PRIVATE (self);
	self->priv->_retry_connect = TRUE;
}


static void zcd_tcp_client_finalize (GObject* obj) {
	zcdTCPClient * self;
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_TCP_CLIENT, zcdTCPClient);
	_tmp0_ = self->priv->connected;
	if (_tmp0_) {
		zcd_tcp_client_close (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
	}
	_g_free0 (self->priv->_dest_addr);
	_g_free0 (self->priv->my_addr);
	_g_object_unref0 (self->priv->socket);
	G_OBJECT_CLASS (zcd_tcp_client_parent_class)->finalize (obj);
}


/** An instance of this class is used when we want to send a message via TCP.
      */
GType zcd_tcp_client_get_type (void) {
	static volatile gsize zcd_tcp_client_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_tcp_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdTCPClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_tcp_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdTCPClient), 0, (GInstanceInitFunc) zcd_tcp_client_instance_init, NULL };
		static const GInterfaceInfo zcd_fake_rmt_info = { (GInterfaceInitFunc) zcd_tcp_client_zcd_fake_rmt_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_tcp_client_type_id;
		zcd_tcp_client_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdTCPClient", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_tcp_client_type_id, ZCD_TYPE_FAKE_RMT, &zcd_fake_rmt_info);
		g_once_init_leave (&zcd_tcp_client_type_id__volatile, zcd_tcp_client_type_id);
	}
	return zcd_tcp_client_type_id__volatile;
}


static void _vala_zcd_tcp_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdTCPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_TCP_CLIENT, zcdTCPClient);
	switch (property_id) {
		case ZCD_TCP_CLIENT_DEST_ADDR:
		g_value_set_string (value, zcd_tcp_client_get_dest_addr (self));
		break;
		case ZCD_TCP_CLIENT_CALLING:
		g_value_set_boolean (value, zcd_tcp_client_get_calling (self));
		break;
		case ZCD_TCP_CLIENT_RETRY_CONNECT:
		g_value_set_boolean (value, zcd_tcp_client_get_retry_connect (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zcd_tcp_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	zcdTCPClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_TCP_CLIENT, zcdTCPClient);
	switch (property_id) {
		case ZCD_TCP_CLIENT_DEST_ADDR:
		zcd_tcp_client_set_dest_addr (self, g_value_get_string (value));
		break;
		case ZCD_TCP_CLIENT_CALLING:
		zcd_tcp_client_set_calling (self, g_value_get_boolean (value));
		break;
		case ZCD_TCP_CLIENT_RETRY_CONNECT:
		zcd_tcp_client_set_retry_connect (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



