/* tcpclient-thread_blocking_sockets.c generated by valac 0.20.1, the Vala compiler
 * generated from tcpclient-thread_blocking_sockets.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define ZCD_TYPE_ICONNECTED_STREAM_SOCKET (zcd_iconnected_stream_socket_get_type ())
#define ZCD_ICONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_ICONNECTED_STREAM_SOCKET, zcdIConnectedStreamSocket))
#define ZCD_IS_ICONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_ICONNECTED_STREAM_SOCKET))
#define ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_ICONNECTED_STREAM_SOCKET, zcdIConnectedStreamSocketIface))

typedef struct _zcdIConnectedStreamSocket zcdIConnectedStreamSocket;
typedef struct _zcdIConnectedStreamSocketIface zcdIConnectedStreamSocketIface;

#define ZCD_TYPE_CLIENT_STREAM_SOCKET (zcd_client_stream_socket_get_type ())
#define ZCD_CLIENT_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocket))
#define ZCD_CLIENT_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocketClass))
#define ZCD_IS_CLIENT_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_CLIENT_STREAM_SOCKET))
#define ZCD_IS_CLIENT_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_CLIENT_STREAM_SOCKET))
#define ZCD_CLIENT_STREAM_SOCKET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocketClass))

typedef struct _zcdClientStreamSocket zcdClientStreamSocket;
typedef struct _zcdClientStreamSocketClass zcdClientStreamSocketClass;
typedef struct _zcdClientStreamSocketPrivate zcdClientStreamSocketPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ZCD_TYPE_CONNECTED_STREAM_SOCKET (zcd_connected_stream_socket_get_type ())
#define ZCD_CONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_CONNECTED_STREAM_SOCKET, zcdConnectedStreamSocket))
#define ZCD_CONNECTED_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_CONNECTED_STREAM_SOCKET, zcdConnectedStreamSocketClass))
#define ZCD_IS_CONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_CONNECTED_STREAM_SOCKET))
#define ZCD_IS_CONNECTED_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_CONNECTED_STREAM_SOCKET))
#define ZCD_CONNECTED_STREAM_SOCKET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_CONNECTED_STREAM_SOCKET, zcdConnectedStreamSocketClass))

typedef struct _zcdConnectedStreamSocket zcdConnectedStreamSocket;
typedef struct _zcdConnectedStreamSocketClass zcdConnectedStreamSocketClass;
typedef struct _zcdConnectedStreamSocketPrivate zcdConnectedStreamSocketPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _zcdIConnectedStreamSocketIface {
	GTypeInterface parent_iface;
	guint16 (*_peer_port_getter) (zcdIConnectedStreamSocket* self);
	const gchar* (*_peer_address_getter) (zcdIConnectedStreamSocket* self);
	guint16 (*_my_port_getter) (zcdIConnectedStreamSocket* self);
	const gchar* (*_my_address_getter) (zcdIConnectedStreamSocket* self);
	gint (*send_part) (zcdIConnectedStreamSocket* self, guchar* data, int data_length1, gint maxlen, GError** error);
	guchar* (*recv) (zcdIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error);
	void (*close) (zcdIConnectedStreamSocket* self, GError** error);
};

struct _zcdClientStreamSocket {
	GObject parent_instance;
	zcdClientStreamSocketPrivate * priv;
};

struct _zcdClientStreamSocketClass {
	GObjectClass parent_class;
};

struct _zcdClientStreamSocketPrivate {
	GSocket* s;
};

struct _zcdConnectedStreamSocket {
	GObject parent_instance;
	zcdConnectedStreamSocketPrivate * priv;
};

struct _zcdConnectedStreamSocketClass {
	GObjectClass parent_class;
};

struct _zcdConnectedStreamSocketPrivate {
	GSocket* s;
	gchar* remote_addr;
	guint16 remote_port;
	gchar* local_addr;
	guint16 local_port;
};


static gpointer zcd_client_stream_socket_parent_class = NULL;
static gpointer zcd_connected_stream_socket_parent_class = NULL;
static zcdIConnectedStreamSocketIface* zcd_connected_stream_socket_zcd_iconnected_stream_socket_parent_iface = NULL;

GType zcd_iconnected_stream_socket_get_type (void) G_GNUC_CONST;
guint16 _zcd_iconnected_stream_socket_peer_port_getter (zcdIConnectedStreamSocket* self);
const gchar* _zcd_iconnected_stream_socket_peer_address_getter (zcdIConnectedStreamSocket* self);
guint16 _zcd_iconnected_stream_socket_my_port_getter (zcdIConnectedStreamSocket* self);
const gchar* _zcd_iconnected_stream_socket_my_address_getter (zcdIConnectedStreamSocket* self);
void zcd_iconnected_stream_socket_send (zcdIConnectedStreamSocket* self, guchar* data, int data_length1, GError** error);
gint zcd_iconnected_stream_socket_send_part (zcdIConnectedStreamSocket* self, guchar* data, int data_length1, gint maxlen, GError** error);
guchar* zcd_iconnected_stream_socket_recv (zcdIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error);
void zcd_iconnected_stream_socket_close (zcdIConnectedStreamSocket* self, GError** error);
guint16 zcd_iconnected_stream_socket_get_peer_port (zcdIConnectedStreamSocket* self);
const gchar* zcd_iconnected_stream_socket_get_peer_address (zcdIConnectedStreamSocket* self);
guint16 zcd_iconnected_stream_socket_get_my_port (zcdIConnectedStreamSocket* self);
const gchar* zcd_iconnected_stream_socket_get_my_address (zcdIConnectedStreamSocket* self);
GType zcd_client_stream_socket_get_type (void) G_GNUC_CONST;
#define ZCD_CLIENT_STREAM_SOCKET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocketPrivate))
enum  {
	ZCD_CLIENT_STREAM_SOCKET_DUMMY_PROPERTY
};
zcdClientStreamSocket* zcd_client_stream_socket_new (const gchar* my_addr, GError** error);
zcdClientStreamSocket* zcd_client_stream_socket_construct (GType object_type, const gchar* my_addr, GError** error);
zcdIConnectedStreamSocket* zcd_client_stream_socket_socket_connect (zcdClientStreamSocket* self, const gchar* addr, guint16 port, GError** error);
zcdConnectedStreamSocket* zcd_connected_stream_socket_new (GSocket* soc, GError** error);
zcdConnectedStreamSocket* zcd_connected_stream_socket_construct (GType object_type, GSocket* soc, GError** error);
GType zcd_connected_stream_socket_get_type (void) G_GNUC_CONST;
static void zcd_client_stream_socket_finalize (GObject* obj);
#define ZCD_CONNECTED_STREAM_SOCKET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_CONNECTED_STREAM_SOCKET, zcdConnectedStreamSocketPrivate))
enum  {
	ZCD_CONNECTED_STREAM_SOCKET_DUMMY_PROPERTY
};
static guint16 zcd_connected_stream_socket_real__peer_port_getter (zcdIConnectedStreamSocket* base);
static const gchar* zcd_connected_stream_socket_real__peer_address_getter (zcdIConnectedStreamSocket* base);
static guint16 zcd_connected_stream_socket_real__my_port_getter (zcdIConnectedStreamSocket* base);
static const gchar* zcd_connected_stream_socket_real__my_address_getter (zcdIConnectedStreamSocket* base);
static gint zcd_connected_stream_socket_real_send_part (zcdIConnectedStreamSocket* base, guchar* data, int data_length1, gint maxlen, GError** error);
static guchar* zcd_connected_stream_socket_real_recv (zcdIConnectedStreamSocket* base, gint maxlen, int* result_length1, GError** error);
static void zcd_connected_stream_socket_real_close (zcdIConnectedStreamSocket* base, GError** error);
static void zcd_connected_stream_socket_finalize (GObject* obj);


guint16 _zcd_iconnected_stream_socket_peer_port_getter (zcdIConnectedStreamSocket* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->_peer_port_getter (self);
}


const gchar* _zcd_iconnected_stream_socket_peer_address_getter (zcdIConnectedStreamSocket* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->_peer_address_getter (self);
}


guint16 _zcd_iconnected_stream_socket_my_port_getter (zcdIConnectedStreamSocket* self) {
	g_return_val_if_fail (self != NULL, 0U);
	return ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->_my_port_getter (self);
}


const gchar* _zcd_iconnected_stream_socket_my_address_getter (zcdIConnectedStreamSocket* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->_my_address_getter (self);
}


/** Sends all the bytes. Returns when all the bytes have been reliably sent.
          */
void zcd_iconnected_stream_socket_send (zcdIConnectedStreamSocket* self, guchar* data, int data_length1, GError** error) {
	guchar* _tmp0_;
	gint _tmp0__length1;
	gint remain;
	GError * _inner_error_ = NULL;
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	remain = _tmp0__length1;
	while (TRUE) {
		gint _tmp1_;
		guchar* _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_;
		gint _tmp4_ = 0;
		gint done;
		gint _tmp5_;
		gint _tmp6_;
		guchar* _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp1_ = remain;
		if (!(_tmp1_ > 0)) {
			break;
		}
		_tmp2_ = data;
		_tmp2__length1 = data_length1;
		_tmp3_ = remain;
		_tmp4_ = zcd_iconnected_stream_socket_send_part (self, _tmp2_, _tmp2__length1, _tmp3_, &_inner_error_);
		done = _tmp4_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp5_ = remain;
		_tmp6_ = done;
		remain = _tmp5_ - _tmp6_;
		_tmp7_ = data;
		_tmp7__length1 = data_length1;
		_tmp8_ = done;
		_tmp9_ = done;
		_tmp10_ = remain;
		data = _tmp7_ + _tmp8_;
		data_length1 = (_tmp9_ + _tmp10_) - _tmp8_;
	}
}


gint zcd_iconnected_stream_socket_send_part (zcdIConnectedStreamSocket* self, guchar* data, int data_length1, gint maxlen, GError** error) {
	g_return_val_if_fail (self != NULL, 0);
	return ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->send_part (self, data, data_length1, maxlen, error);
}


guchar* zcd_iconnected_stream_socket_recv (zcdIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->recv (self, maxlen, result_length1, error);
}


void zcd_iconnected_stream_socket_close (zcdIConnectedStreamSocket* self, GError** error) {
	g_return_if_fail (self != NULL);
	ZCD_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->close (self, error);
}


guint16 zcd_iconnected_stream_socket_get_peer_port (zcdIConnectedStreamSocket* self) {
	guint16 result;
	guint16 _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = _zcd_iconnected_stream_socket_peer_port_getter (self);
	result = _tmp0_;
	return result;
}


const gchar* zcd_iconnected_stream_socket_get_peer_address (zcdIConnectedStreamSocket* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _zcd_iconnected_stream_socket_peer_address_getter (self);
	result = _tmp0_;
	return result;
}


guint16 zcd_iconnected_stream_socket_get_my_port (zcdIConnectedStreamSocket* self) {
	guint16 result;
	guint16 _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = _zcd_iconnected_stream_socket_my_port_getter (self);
	result = _tmp0_;
	return result;
}


const gchar* zcd_iconnected_stream_socket_get_my_address (zcdIConnectedStreamSocket* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _zcd_iconnected_stream_socket_my_address_getter (self);
	result = _tmp0_;
	return result;
}


static void zcd_iconnected_stream_socket_base_init (zcdIConnectedStreamSocketIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/** When you have a socket connected to a server, or when you receive
      *  a connection, you get an obscure object that implements this API.
      */
GType zcd_iconnected_stream_socket_get_type (void) {
	static volatile gsize zcd_iconnected_stream_socket_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_iconnected_stream_socket_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdIConnectedStreamSocketIface), (GBaseInitFunc) zcd_iconnected_stream_socket_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType zcd_iconnected_stream_socket_type_id;
		zcd_iconnected_stream_socket_type_id = g_type_register_static (G_TYPE_INTERFACE, "zcdIConnectedStreamSocket", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (zcd_iconnected_stream_socket_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&zcd_iconnected_stream_socket_type_id__volatile, zcd_iconnected_stream_socket_type_id);
	}
	return zcd_iconnected_stream_socket_type_id__volatile;
}


zcdClientStreamSocket* zcd_client_stream_socket_construct (GType object_type, const gchar* my_addr, GError** error) {
	zcdClientStreamSocket * self = NULL;
	GSocket* _tmp0_;
	GSocket* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (zcdClientStreamSocket*) g_object_new (object_type, NULL);
	_tmp0_ = g_socket_new (G_SOCKET_FAMILY_IPV4, G_SOCKET_TYPE_STREAM, G_SOCKET_PROTOCOL_TCP, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_g_object_unref0 (self->priv->s);
	self->priv->s = _tmp1_;
	_tmp2_ = my_addr;
	if (_tmp2_ != NULL) {
		GSocket* _tmp3_;
		const gchar* _tmp4_;
		GInetAddress* _tmp5_;
		GInetAddress* _tmp6_;
		GInetSocketAddress* _tmp7_;
		GInetSocketAddress* _tmp8_;
		_tmp3_ = self->priv->s;
		_tmp4_ = my_addr;
		_tmp5_ = g_inet_address_new_from_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = (GInetSocketAddress*) g_inet_socket_address_new (_tmp6_, (guint16) 0);
		_tmp8_ = _tmp7_;
		g_socket_bind (_tmp3_, (GSocketAddress*) _tmp8_, FALSE, &_inner_error_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	return self;
}


zcdClientStreamSocket* zcd_client_stream_socket_new (const gchar* my_addr, GError** error) {
	return zcd_client_stream_socket_construct (ZCD_TYPE_CLIENT_STREAM_SOCKET, my_addr, error);
}


/** When the method returns, use the returned object
          *  to carry on the communication. Discard this instance, instead.
          */
zcdIConnectedStreamSocket* zcd_client_stream_socket_socket_connect (zcdClientStreamSocket* self, const gchar* addr, guint16 port, GError** error) {
	zcdIConnectedStreamSocket* result = NULL;
	GSocket* _tmp0_;
	GSocket* _tmp1_;
	const gchar* _tmp2_;
	GInetAddress* _tmp3_;
	GInetAddress* _tmp4_;
	guint16 _tmp5_;
	GInetSocketAddress* _tmp6_;
	GInetSocketAddress* _tmp7_;
	GSocket* _tmp8_;
	zcdConnectedStreamSocket* _tmp9_;
	zcdIConnectedStreamSocket* ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (addr != NULL, NULL);
	_tmp0_ = self->priv->s;
	_vala_assert (_tmp0_ != NULL, "s != null");
	_tmp1_ = self->priv->s;
	_tmp2_ = addr;
	_tmp3_ = g_inet_address_new_from_string (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = port;
	_tmp6_ = (GInetSocketAddress*) g_inet_socket_address_new (_tmp4_, _tmp5_);
	_tmp7_ = _tmp6_;
	g_socket_connect (_tmp1_, (GSocketAddress*) _tmp7_, NULL, &_inner_error_);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp4_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp8_ = self->priv->s;
	_tmp9_ = zcd_connected_stream_socket_new (_tmp8_, &_inner_error_);
	ret = (zcdIConnectedStreamSocket*) _tmp9_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_g_object_unref0 (self->priv->s);
	self->priv->s = NULL;
	result = ret;
	return result;
}


static void zcd_client_stream_socket_class_init (zcdClientStreamSocketClass * klass) {
	zcd_client_stream_socket_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdClientStreamSocketPrivate));
	G_OBJECT_CLASS (klass)->finalize = zcd_client_stream_socket_finalize;
}


static void zcd_client_stream_socket_instance_init (zcdClientStreamSocket * self) {
	self->priv = ZCD_CLIENT_STREAM_SOCKET_GET_PRIVATE (self);
}


static void zcd_client_stream_socket_finalize (GObject* obj) {
	zcdClientStreamSocket * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_CLIENT_STREAM_SOCKET, zcdClientStreamSocket);
	_g_object_unref0 (self->priv->s);
	G_OBJECT_CLASS (zcd_client_stream_socket_parent_class)->finalize (obj);
}


/** Use this class to make a connection to a TCP service.
      * In particular, you can wait for the connect to complete without
      *  blocking the rest of the application.
      */
GType zcd_client_stream_socket_get_type (void) {
	static volatile gsize zcd_client_stream_socket_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_client_stream_socket_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdClientStreamSocketClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_client_stream_socket_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdClientStreamSocket), 0, (GInstanceInitFunc) zcd_client_stream_socket_instance_init, NULL };
		GType zcd_client_stream_socket_type_id;
		zcd_client_stream_socket_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdClientStreamSocket", &g_define_type_info, 0);
		g_once_init_leave (&zcd_client_stream_socket_type_id__volatile, zcd_client_stream_socket_type_id);
	}
	return zcd_client_stream_socket_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


zcdConnectedStreamSocket* zcd_connected_stream_socket_construct (GType object_type, GSocket* soc, GError** error) {
	zcdConnectedStreamSocket * self = NULL;
	GSocket* _tmp0_;
	GSocket* _tmp1_;
	GSocket* _tmp2_;
	GSocketAddress* _tmp3_ = NULL;
	GSocketAddress* _tmp4_;
	GInetSocketAddress* x;
	GInetSocketAddress* _tmp5_;
	GInetAddress* _tmp6_;
	GInetAddress* _tmp7_;
	gchar* _tmp8_ = NULL;
	GInetSocketAddress* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	GSocket* _tmp12_;
	GSocketAddress* _tmp13_ = NULL;
	GSocketAddress* _tmp14_;
	GInetSocketAddress* y;
	GInetSocketAddress* _tmp15_;
	GInetAddress* _tmp16_;
	GInetAddress* _tmp17_;
	gchar* _tmp18_ = NULL;
	GInetSocketAddress* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (soc != NULL, NULL);
	self = (zcdConnectedStreamSocket*) g_object_new (object_type, NULL);
	_tmp0_ = soc;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->s);
	self->priv->s = _tmp1_;
	_tmp2_ = self->priv->s;
	_tmp3_ = g_socket_get_remote_address (_tmp2_, &_inner_error_);
	_tmp4_ = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	x = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_inet_socket_address_get_type (), GInetSocketAddress);
	_tmp5_ = x;
	_tmp6_ = g_inet_socket_address_get_address (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_inet_address_to_string (_tmp7_);
	_g_free0 (self->priv->remote_addr);
	self->priv->remote_addr = _tmp8_;
	_tmp9_ = x;
	_tmp10_ = g_inet_socket_address_get_port (_tmp9_);
	_tmp11_ = _tmp10_;
	self->priv->remote_port = (guint16) _tmp11_;
	_tmp12_ = self->priv->s;
	_tmp13_ = g_socket_get_local_address (_tmp12_, &_inner_error_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (x);
		_g_object_unref0 (self);
		return NULL;
	}
	y = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_inet_socket_address_get_type (), GInetSocketAddress);
	_tmp15_ = y;
	_tmp16_ = g_inet_socket_address_get_address (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_inet_address_to_string (_tmp17_);
	_g_free0 (self->priv->local_addr);
	self->priv->local_addr = _tmp18_;
	_tmp19_ = y;
	_tmp20_ = g_inet_socket_address_get_port (_tmp19_);
	_tmp21_ = _tmp20_;
	self->priv->local_port = (guint16) _tmp21_;
	_g_object_unref0 (y);
	_g_object_unref0 (x);
	return self;
}


zcdConnectedStreamSocket* zcd_connected_stream_socket_new (GSocket* soc, GError** error) {
	return zcd_connected_stream_socket_construct (ZCD_TYPE_CONNECTED_STREAM_SOCKET, soc, error);
}


static guint16 zcd_connected_stream_socket_real__peer_port_getter (zcdIConnectedStreamSocket* base) {
	zcdConnectedStreamSocket * self;
	guint16 result = 0U;
	guint16 _tmp0_;
	self = (zcdConnectedStreamSocket*) base;
	_tmp0_ = self->priv->remote_port;
	result = _tmp0_;
	return result;
}


static const gchar* zcd_connected_stream_socket_real__peer_address_getter (zcdIConnectedStreamSocket* base) {
	zcdConnectedStreamSocket * self;
	const gchar* result = NULL;
	const gchar* _tmp0_;
	self = (zcdConnectedStreamSocket*) base;
	_tmp0_ = self->priv->remote_addr;
	result = _tmp0_;
	return result;
}


static guint16 zcd_connected_stream_socket_real__my_port_getter (zcdIConnectedStreamSocket* base) {
	zcdConnectedStreamSocket * self;
	guint16 result = 0U;
	guint16 _tmp0_;
	self = (zcdConnectedStreamSocket*) base;
	_tmp0_ = self->priv->local_port;
	result = _tmp0_;
	return result;
}


static const gchar* zcd_connected_stream_socket_real__my_address_getter (zcdIConnectedStreamSocket* base) {
	zcdConnectedStreamSocket * self;
	const gchar* result = NULL;
	const gchar* _tmp0_;
	self = (zcdConnectedStreamSocket*) base;
	_tmp0_ = self->priv->local_addr;
	result = _tmp0_;
	return result;
}


static gint zcd_connected_stream_socket_real_send_part (zcdIConnectedStreamSocket* base, guchar* data, int data_length1, gint maxlen, GError** error) {
	zcdConnectedStreamSocket * self;
	gint result = 0;
	gint _tmp0_;
	guint8* _tmp1_ = NULL;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	GSocket* _tmp4_;
	gssize _tmp5_ = 0L;
	gssize _tmp6_;
	gint ret;
	GError * _inner_error_ = NULL;
	self = (zcdConnectedStreamSocket*) base;
	_tmp0_ = maxlen;
	_tmp1_ = g_new0 (guint8, _tmp0_);
	buffer = _tmp1_;
	buffer_length1 = _tmp0_;
	_buffer_size_ = buffer_length1;
	_tmp2_ = data;
	_tmp2__length1 = data_length1;
	_tmp3_ = maxlen;
	memcpy (buffer, _tmp2_, (gsize) _tmp3_);
	_tmp4_ = self->priv->s;
	_tmp5_ = g_socket_send (_tmp4_, buffer, (gsize) buffer_length1, NULL, &_inner_error_);
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		return 0;
	}
	ret = (gint) _tmp6_;
	result = ret;
	buffer = (g_free (buffer), NULL);
	return result;
}


static guchar* zcd_connected_stream_socket_real_recv (zcdIConnectedStreamSocket* base, gint maxlen, int* result_length1, GError** error) {
	zcdConnectedStreamSocket * self;
	guchar* result = NULL;
	gint _tmp0_;
	guint8* _tmp1_ = NULL;
	guint8* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	GSocket* _tmp2_;
	gssize _tmp3_ = 0L;
	gssize len;
	guchar* _tmp4_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
	self = (zcdConnectedStreamSocket*) base;
	_tmp0_ = maxlen;
	_tmp1_ = g_new0 (guint8, _tmp0_);
	buffer = _tmp1_;
	buffer_length1 = _tmp0_;
	_buffer_size_ = buffer_length1;
	_tmp2_ = self->priv->s;
	_tmp3_ = g_socket_receive (_tmp2_, buffer, (gsize) buffer_length1, NULL, &_inner_error_);
	len = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		return NULL;
	}
	_tmp4_ = g_new0 (guchar, len);
	ret = _tmp4_;
	ret_length1 = len;
	_ret_size_ = ret_length1;
	_tmp5_ = ret;
	_tmp5__length1 = ret_length1;
	memcpy (_tmp5_, buffer, (gsize) len);
	_tmp6_ = ret;
	_tmp6__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static void zcd_connected_stream_socket_real_close (zcdIConnectedStreamSocket* base, GError** error) {
	zcdConnectedStreamSocket * self;
	GSocket* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (zcdConnectedStreamSocket*) base;
	_tmp0_ = self->priv->s;
	g_socket_close (_tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void zcd_connected_stream_socket_class_init (zcdConnectedStreamSocketClass * klass) {
	zcd_connected_stream_socket_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdConnectedStreamSocketPrivate));
	G_OBJECT_CLASS (klass)->finalize = zcd_connected_stream_socket_finalize;
}


static void zcd_connected_stream_socket_zcd_iconnected_stream_socket_interface_init (zcdIConnectedStreamSocketIface * iface) {
	zcd_connected_stream_socket_zcd_iconnected_stream_socket_parent_iface = g_type_interface_peek_parent (iface);
	iface->_peer_port_getter = (guint16 (*)(zcdIConnectedStreamSocket*)) zcd_connected_stream_socket_real__peer_port_getter;
	iface->_peer_address_getter = (const gchar* (*)(zcdIConnectedStreamSocket*)) zcd_connected_stream_socket_real__peer_address_getter;
	iface->_my_port_getter = (guint16 (*)(zcdIConnectedStreamSocket*)) zcd_connected_stream_socket_real__my_port_getter;
	iface->_my_address_getter = (const gchar* (*)(zcdIConnectedStreamSocket*)) zcd_connected_stream_socket_real__my_address_getter;
	iface->send_part = (gint (*)(zcdIConnectedStreamSocket*, guchar*, int, gint, GError**)) zcd_connected_stream_socket_real_send_part;
	iface->recv = (guchar* (*)(zcdIConnectedStreamSocket*, gint, int*, GError**)) zcd_connected_stream_socket_real_recv;
	iface->close = (void (*)(zcdIConnectedStreamSocket*, GError**)) zcd_connected_stream_socket_real_close;
}


static void zcd_connected_stream_socket_instance_init (zcdConnectedStreamSocket * self) {
	self->priv = ZCD_CONNECTED_STREAM_SOCKET_GET_PRIVATE (self);
}


static void zcd_connected_stream_socket_finalize (GObject* obj) {
	zcdConnectedStreamSocket * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_CONNECTED_STREAM_SOCKET, zcdConnectedStreamSocket);
	_g_object_unref0 (self->priv->s);
	_g_free0 (self->priv->remote_addr);
	_g_free0 (self->priv->local_addr);
	G_OBJECT_CLASS (zcd_connected_stream_socket_parent_class)->finalize (obj);
}


GType zcd_connected_stream_socket_get_type (void) {
	static volatile gsize zcd_connected_stream_socket_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_connected_stream_socket_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdConnectedStreamSocketClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_connected_stream_socket_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdConnectedStreamSocket), 0, (GInstanceInitFunc) zcd_connected_stream_socket_instance_init, NULL };
		static const GInterfaceInfo zcd_iconnected_stream_socket_info = { (GInterfaceInitFunc) zcd_connected_stream_socket_zcd_iconnected_stream_socket_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_connected_stream_socket_type_id;
		zcd_connected_stream_socket_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdConnectedStreamSocket", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_connected_stream_socket_type_id, ZCD_TYPE_ICONNECTED_STREAM_SOCKET, &zcd_iconnected_stream_socket_info);
		g_once_init_leave (&zcd_connected_stream_socket_type_id__volatile, zcd_connected_stream_socket_type_id);
	}
	return zcd_connected_stream_socket_type_id__volatile;
}



