/* tcpclient-serializer.c generated by valac 0.20.1, the Vala compiler
 * generated from tcpclient-serializer.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */
/** Serializable classes for basic types **/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <arpa/inet.h>


#define ZCD_TYPE_ISERIALIZABLE (zcd_iserializable_get_type ())
#define ZCD_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializable))
#define ZCD_IS_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_ISERIALIZABLE))
#define ZCD_ISERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializableIface))

typedef struct _zcdISerializable zcdISerializable;
typedef struct _zcdISerializableIface zcdISerializableIface;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ZCD_TYPE_BUFFER_OWNER (zcd_buffer_owner_get_type ())
#define ZCD_BUFFER_OWNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_BUFFER_OWNER, zcdBufferOwner))
#define ZCD_BUFFER_OWNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_BUFFER_OWNER, zcdBufferOwnerClass))
#define ZCD_IS_BUFFER_OWNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_BUFFER_OWNER))
#define ZCD_IS_BUFFER_OWNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_BUFFER_OWNER))
#define ZCD_BUFFER_OWNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_BUFFER_OWNER, zcdBufferOwnerClass))

typedef struct _zcdBufferOwner zcdBufferOwner;
typedef struct _zcdBufferOwnerClass zcdBufferOwnerClass;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _zcdBufferOwnerPrivate zcdBufferOwnerPrivate;

#define ZCD_TYPE_SERIALIZABLE_NONE (zcd_serializable_none_get_type ())
#define ZCD_SERIALIZABLE_NONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNone))
#define ZCD_SERIALIZABLE_NONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNoneClass))
#define ZCD_IS_SERIALIZABLE_NONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_NONE))
#define ZCD_IS_SERIALIZABLE_NONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_NONE))
#define ZCD_SERIALIZABLE_NONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNoneClass))

typedef struct _zcdSerializableNone zcdSerializableNone;
typedef struct _zcdSerializableNoneClass zcdSerializableNoneClass;
typedef struct _zcdSerializableNonePrivate zcdSerializableNonePrivate;

#define ZCD_TYPE_SERIALIZABLE_INT (zcd_serializable_int_get_type ())
#define ZCD_SERIALIZABLE_INT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt))
#define ZCD_SERIALIZABLE_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableIntClass))
#define ZCD_IS_SERIALIZABLE_INT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_INT))
#define ZCD_IS_SERIALIZABLE_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_INT))
#define ZCD_SERIALIZABLE_INT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableIntClass))

typedef struct _zcdSerializableInt zcdSerializableInt;
typedef struct _zcdSerializableIntClass zcdSerializableIntClass;
typedef struct _zcdSerializableIntPrivate zcdSerializableIntPrivate;

#define ZCD_TYPE_SERIALIZABLE_BOOL (zcd_serializable_bool_get_type ())
#define ZCD_SERIALIZABLE_BOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool))
#define ZCD_SERIALIZABLE_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBoolClass))
#define ZCD_IS_SERIALIZABLE_BOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_BOOL))
#define ZCD_IS_SERIALIZABLE_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_BOOL))
#define ZCD_SERIALIZABLE_BOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBoolClass))

typedef struct _zcdSerializableBool zcdSerializableBool;
typedef struct _zcdSerializableBoolClass zcdSerializableBoolClass;
typedef struct _zcdSerializableBoolPrivate zcdSerializableBoolPrivate;

#define ZCD_TYPE_SERIALIZABLE_STRING (zcd_serializable_string_get_type ())
#define ZCD_SERIALIZABLE_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString))
#define ZCD_SERIALIZABLE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableStringClass))
#define ZCD_IS_SERIALIZABLE_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_STRING))
#define ZCD_IS_SERIALIZABLE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_STRING))
#define ZCD_SERIALIZABLE_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableStringClass))

typedef struct _zcdSerializableString zcdSerializableString;
typedef struct _zcdSerializableStringClass zcdSerializableStringClass;
typedef struct _zcdSerializableStringPrivate zcdSerializableStringPrivate;

#define ZCD_TYPE_SERIALIZABLE_BUFFER (zcd_serializable_buffer_get_type ())
#define ZCD_SERIALIZABLE_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer))
#define ZCD_SERIALIZABLE_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBufferClass))
#define ZCD_IS_SERIALIZABLE_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_BUFFER))
#define ZCD_IS_SERIALIZABLE_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_BUFFER))
#define ZCD_SERIALIZABLE_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBufferClass))

typedef struct _zcdSerializableBuffer zcdSerializableBuffer;
typedef struct _zcdSerializableBufferClass zcdSerializableBufferClass;
typedef struct _zcdSerializableBufferPrivate zcdSerializableBufferPrivate;

#define ZCD_TYPE_LIST_STRING (zcd_list_string_get_type ())
#define ZCD_LIST_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_LIST_STRING, zcdListString))
#define ZCD_LIST_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_LIST_STRING, zcdListStringClass))
#define ZCD_IS_LIST_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_LIST_STRING))
#define ZCD_IS_LIST_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_LIST_STRING))
#define ZCD_LIST_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_LIST_STRING, zcdListStringClass))

typedef struct _zcdListString zcdListString;
typedef struct _zcdListStringClass zcdListStringClass;
typedef struct _zcdListStringPrivate zcdListStringPrivate;

#define ZCD_TYPE_LIST_ISERIALIZABLE (zcd_list_iserializable_get_type ())
#define ZCD_LIST_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializable))
#define ZCD_LIST_ISERIALIZABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializableClass))
#define ZCD_IS_LIST_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_LIST_ISERIALIZABLE))
#define ZCD_IS_LIST_ISERIALIZABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_LIST_ISERIALIZABLE))
#define ZCD_LIST_ISERIALIZABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializableClass))

typedef struct _zcdListISerializable zcdListISerializable;
typedef struct _zcdListISerializableClass zcdListISerializableClass;
typedef struct _zcdListISerializablePrivate zcdListISerializablePrivate;

#define ZCD_TYPE_REMOTE_CALL (zcd_remote_call_get_type ())
#define ZCD_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCall))
#define ZCD_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))
#define ZCD_IS_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_REMOTE_CALL))
#define ZCD_IS_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_REMOTE_CALL))
#define ZCD_REMOTE_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))

typedef struct _zcdRemoteCall zcdRemoteCall;
typedef struct _zcdRemoteCallClass zcdRemoteCallClass;

#define ZCD_TYPE_REMOTABLE_EXCEPTION (zcd_remotable_exception_get_type ())
#define ZCD_REMOTABLE_EXCEPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_REMOTABLE_EXCEPTION, zcdRemotableException))
#define ZCD_REMOTABLE_EXCEPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_REMOTABLE_EXCEPTION, zcdRemotableExceptionClass))
#define ZCD_IS_REMOTABLE_EXCEPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_REMOTABLE_EXCEPTION))
#define ZCD_IS_REMOTABLE_EXCEPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_REMOTABLE_EXCEPTION))
#define ZCD_REMOTABLE_EXCEPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_REMOTABLE_EXCEPTION, zcdRemotableExceptionClass))

typedef struct _zcdRemotableException zcdRemotableException;
typedef struct _zcdRemotableExceptionClass zcdRemotableExceptionClass;

#define ZCD_TYPE_TCP_REQUEST (zcd_tcp_request_get_type ())
#define ZCD_TCP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_TCP_REQUEST, zcdTCPRequest))
#define ZCD_TCP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_TCP_REQUEST, zcdTCPRequestClass))
#define ZCD_IS_TCP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_TCP_REQUEST))
#define ZCD_IS_TCP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_TCP_REQUEST))
#define ZCD_TCP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_TCP_REQUEST, zcdTCPRequestClass))

typedef struct _zcdTCPRequest zcdTCPRequest;
typedef struct _zcdTCPRequestClass zcdTCPRequestClass;

#define ZCD_TYPE_UDP_MESSAGE (zcd_udp_message_get_type ())
#define ZCD_UDP_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessage))
#define ZCD_UDP_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessageClass))
#define ZCD_IS_UDP_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_UDP_MESSAGE))
#define ZCD_IS_UDP_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_UDP_MESSAGE))
#define ZCD_UDP_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessageClass))

typedef struct _zcdUDPMessage zcdUDPMessage;
typedef struct _zcdUDPMessageClass zcdUDPMessageClass;

#define ZCD_TYPE_UDP_PAYLOAD (zcd_udp_payload_get_type ())
#define ZCD_UDP_PAYLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayload))
#define ZCD_UDP_PAYLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayloadClass))
#define ZCD_IS_UDP_PAYLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_UDP_PAYLOAD))
#define ZCD_IS_UDP_PAYLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_UDP_PAYLOAD))
#define ZCD_UDP_PAYLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayloadClass))

typedef struct _zcdUDPPayload zcdUDPPayload;
typedef struct _zcdUDPPayloadClass zcdUDPPayloadClass;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	ZCD_SERIALIZER_ERROR_GENERIC
} zcdSerializerError;
#define ZCD_SERIALIZER_ERROR zcd_serializer_error_quark ()
struct _zcdISerializableIface {
	GTypeInterface parent_iface;
	GVariant* (*serialize_to_variant) (zcdISerializable* self);
	void (*deserialize_from_variant) (zcdISerializable* self, GVariant* v, GError** error);
};

struct _zcdBufferOwner {
	GObject parent_instance;
	zcdBufferOwnerPrivate * priv;
};

struct _zcdBufferOwnerClass {
	GObjectClass parent_class;
};

struct _zcdBufferOwnerPrivate {
	guchar* _buf;
	gint _buf_length1;
	gint __buf_size_;
};

struct _zcdSerializableNone {
	GObject parent_instance;
	zcdSerializableNonePrivate * priv;
};

struct _zcdSerializableNoneClass {
	GObjectClass parent_class;
};

struct _zcdSerializableInt {
	GObject parent_instance;
	zcdSerializableIntPrivate * priv;
};

struct _zcdSerializableIntClass {
	GObjectClass parent_class;
};

struct _zcdSerializableIntPrivate {
	gint _i;
};

struct _zcdSerializableBool {
	GObject parent_instance;
	zcdSerializableBoolPrivate * priv;
};

struct _zcdSerializableBoolClass {
	GObjectClass parent_class;
};

struct _zcdSerializableBoolPrivate {
	gint _i;
};

struct _zcdSerializableString {
	GObject parent_instance;
	zcdSerializableStringPrivate * priv;
};

struct _zcdSerializableStringClass {
	GObjectClass parent_class;
};

struct _zcdSerializableStringPrivate {
	gchar* _s;
};

struct _zcdSerializableBuffer {
	GObject parent_instance;
	zcdSerializableBufferPrivate * priv;
};

struct _zcdSerializableBufferClass {
	GObjectClass parent_class;
};

struct _zcdSerializableBufferPrivate {
	guint8* _buffer;
	gint _buffer_length1;
	gint __buffer_size_;
};

struct _zcdListString {
	GObject parent_instance;
	zcdListStringPrivate * priv;
	GeeList* backed;
};

struct _zcdListStringClass {
	GObjectClass parent_class;
};

struct _zcdListISerializable {
	GObject parent_instance;
	zcdListISerializablePrivate * priv;
	GeeList* backed;
};

struct _zcdListISerializableClass {
	GObjectClass parent_class;
};


extern gboolean zcd_endianness_network;
gboolean zcd_endianness_network = FALSE;
static gpointer zcd_buffer_owner_parent_class = NULL;
static gpointer zcd_serializable_none_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_none_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_serializable_int_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_int_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_serializable_bool_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_bool_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_serializable_string_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_string_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_serializable_buffer_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_buffer_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_list_string_parent_class = NULL;
static zcdISerializableIface* zcd_list_string_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_list_iserializable_parent_class = NULL;
static zcdISerializableIface* zcd_list_iserializable_zcd_iserializable_parent_iface = NULL;

GQuark zcd_serializer_error_quark (void);
GType zcd_iserializable_get_type (void) G_GNUC_CONST;
GVariant* zcd_iserializable_serialize_to_variant (zcdISerializable* self);
void zcd_iserializable_deserialize_from_variant (zcdISerializable* self, GVariant* v, GError** error);
guchar* zcd_iserializable_serialize (zcdISerializable* self, int* result_length1);
zcdISerializable* zcd_iserializable_deserialize (guchar* ser, int ser_length1, GError** error);
zcdBufferOwner* zcd_buffer_owner_new (guchar* seed, int seed_length1);
zcdBufferOwner* zcd_buffer_owner_construct (GType object_type, guchar* seed, int seed_length1);
GType zcd_buffer_owner_get_type (void) G_GNUC_CONST;
guchar* zcd_buffer_owner_get_buf (zcdBufferOwner* self, int* result_length1);
gboolean zcd_iserializable_is_instance_of (GType t1, guchar* ser, int ser_length1);
gchar* zcd_iserializable_typename (guchar* ser, int ser_length1);
#define ZCD_BUFFER_OWNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_BUFFER_OWNER, zcdBufferOwnerPrivate))
enum  {
	ZCD_BUFFER_OWNER_DUMMY_PROPERTY
};
static void zcd_buffer_owner_finalize (GObject* obj);
static void _vala_zcd_buffer_owner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_serializable_none_get_type (void) G_GNUC_CONST;
enum  {
	ZCD_SERIALIZABLE_NONE_DUMMY_PROPERTY
};
static GVariant* zcd_serializable_none_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_int_to_variant (gint i);
static void zcd_serializable_none_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
zcdSerializableNone* zcd_serializable_none_new (void);
zcdSerializableNone* zcd_serializable_none_construct (GType object_type);
GType zcd_serializable_int_get_type (void) G_GNUC_CONST;
#define ZCD_SERIALIZABLE_INT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableIntPrivate))
enum  {
	ZCD_SERIALIZABLE_INT_DUMMY_PROPERTY,
	ZCD_SERIALIZABLE_INT_I
};
zcdSerializableInt* zcd_serializable_int_new (gint i);
zcdSerializableInt* zcd_serializable_int_construct (GType object_type, gint i);
static GVariant* zcd_serializable_int_real_serialize_to_variant (zcdISerializable* base);
static void zcd_serializable_int_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
gint zcd_serializer_variant_to_int (GVariant* v);
gint zcd_serializable_int_get_i (zcdSerializableInt* self);
static void zcd_serializable_int_finalize (GObject* obj);
static void _vala_zcd_serializable_int_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_serializable_bool_get_type (void) G_GNUC_CONST;
#define ZCD_SERIALIZABLE_BOOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBoolPrivate))
enum  {
	ZCD_SERIALIZABLE_BOOL_DUMMY_PROPERTY,
	ZCD_SERIALIZABLE_BOOL_B
};
zcdSerializableBool* zcd_serializable_bool_new (gboolean b);
zcdSerializableBool* zcd_serializable_bool_construct (GType object_type, gboolean b);
static GVariant* zcd_serializable_bool_real_serialize_to_variant (zcdISerializable* base);
static void zcd_serializable_bool_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
gboolean zcd_serializable_bool_get_b (zcdSerializableBool* self);
static void zcd_serializable_bool_finalize (GObject* obj);
static void _vala_zcd_serializable_bool_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_serializable_string_get_type (void) G_GNUC_CONST;
#define ZCD_SERIALIZABLE_STRING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableStringPrivate))
enum  {
	ZCD_SERIALIZABLE_STRING_DUMMY_PROPERTY,
	ZCD_SERIALIZABLE_STRING_S
};
zcdSerializableString* zcd_serializable_string_new (const gchar* s);
zcdSerializableString* zcd_serializable_string_construct (GType object_type, const gchar* s);
static GVariant* zcd_serializable_string_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_string_to_variant (const gchar* s);
static void zcd_serializable_string_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
gchar* zcd_serializer_variant_to_string (GVariant* v);
const gchar* zcd_serializable_string_get_s (zcdSerializableString* self);
static void zcd_serializable_string_finalize (GObject* obj);
static void _vala_zcd_serializable_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_serializable_buffer_get_type (void) G_GNUC_CONST;
#define ZCD_SERIALIZABLE_BUFFER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBufferPrivate))
enum  {
	ZCD_SERIALIZABLE_BUFFER_DUMMY_PROPERTY
};
zcdSerializableBuffer* zcd_serializable_buffer_new (guint8* buffer, int buffer_length1);
zcdSerializableBuffer* zcd_serializable_buffer_construct (GType object_type, guint8* buffer, int buffer_length1);
static guint8* _vala_array_dup1 (guint8* self, int length);
static GVariant* zcd_serializable_buffer_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_uchar_array_to_variant (guchar* auc, int auc_length1);
static void zcd_serializable_buffer_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
guchar* zcd_serializer_variant_to_uchar_array (GVariant* v, int* result_length1);
guint8* zcd_serializable_buffer_get_buffer (zcdSerializableBuffer* self, int* result_length1);
static void zcd_serializable_buffer_finalize (GObject* obj);
static void _vala_zcd_serializable_buffer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_list_string_get_type (void) G_GNUC_CONST;
enum  {
	ZCD_LIST_STRING_DUMMY_PROPERTY,
	ZCD_LIST_STRING_SIZE
};
zcdListString* zcd_list_string_new (void);
zcdListString* zcd_list_string_construct (GType object_type);
zcdListString* zcd_list_string_new_with_backer (GeeList* backed);
zcdListString* zcd_list_string_construct_with_backer (GType object_type, GeeList* backed);
GeeIterator* zcd_list_string_iterator (zcdListString* self);
void zcd_list_string_add (zcdListString* self, const gchar* el);
guchar* zcd_list_string_hash_for_signature (zcdListString* self, int* result_length1);
static void _vala_array_add1 (guchar** array, int* length, int* size, guchar value);
static GVariant* zcd_list_string_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_string_array_to_variant (gchar** ars, int ars_length1);
static void zcd_list_string_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
gchar** zcd_serializer_variant_to_string_array (GVariant* v, int* result_length1);
gint zcd_list_string_get_size (zcdListString* self);
static void zcd_list_string_finalize (GObject* obj);
static void _vala_zcd_list_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_list_iserializable_get_type (void) G_GNUC_CONST;
enum  {
	ZCD_LIST_ISERIALIZABLE_DUMMY_PROPERTY,
	ZCD_LIST_ISERIALIZABLE_SIZE
};
static gboolean zcd_list_iserializable_not_impl_equal_func (GObject* a, GObject* b);
zcdListISerializable* zcd_list_iserializable_new (void);
zcdListISerializable* zcd_list_iserializable_construct (GType object_type);
zcdListISerializable* zcd_list_iserializable_new_with_backer (GeeList* backed);
zcdListISerializable* zcd_list_iserializable_construct_with_backer (GType object_type, GeeList* backed);
GeeIterator* zcd_list_iserializable_iterator (zcdListISerializable* self);
void zcd_list_iserializable_add (zcdListISerializable* self, zcdISerializable* el);
static GVariant* zcd_list_iserializable_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_variant_array_to_variant (GVariant** av, int av_length1);
GVariant* zcd_serializer_tuple_to_variant (GVariant* v0, GVariant* v1);
static void zcd_list_iserializable_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
void zcd_serializer_variant_to_tuple (GVariant* v, GVariant** v0, GVariant** v1);
GVariant** zcd_serializer_variant_to_variant_array (GVariant* v, int* result_length1);
gint zcd_list_iserializable_get_size (zcdListISerializable* self);
static void zcd_list_iserializable_finalize (GObject* obj);
static void _vala_zcd_list_iserializable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void zcd_serializer_init (void);
GType zcd_remote_call_get_type (void) G_GNUC_CONST;
GType zcd_remotable_exception_get_type (void) G_GNUC_CONST;
GType zcd_tcp_request_get_type (void) G_GNUC_CONST;
GType zcd_udp_message_get_type (void) G_GNUC_CONST;
GType zcd_udp_payload_get_type (void) G_GNUC_CONST;
static GVariant* _variant_new1 (gint value);
static gint _variant_get2 (GVariant* value);
GVariant* zcd_serializer_int64_to_variant (gint64 i);
static GVariant* _variant_new3 (gint64 value);
gint64 zcd_serializer_variant_to_int64 (GVariant* v);
static gint64 _variant_get4 (GVariant* value);
GVariant* zcd_serializer_uchar_to_variant (guchar y);
static GVariant* _variant_new5 (guchar value);
guchar zcd_serializer_variant_to_uchar (GVariant* v);
static guchar _variant_get6 (GVariant* value);
static GVariant* _variant_new7 (const gchar* value);
GVariant* zcd_serializer_int_array_to_variant (gint* ai, int ai_length1);
static GVariant* _variant_new8 (gint* value, gint value_length1);
gint* zcd_serializer_variant_to_int_array (GVariant* v, int* result_length1);
static gint _variant_get9 (GVariant* value);
static void _vala_array_add2 (gint** array, int* length, int* size, gint value);
static GVariant* _variant_new10 (guchar* value, gint value_length1);
static guchar _variant_get11 (GVariant* value);
static void _vala_array_add3 (guchar** array, int* length, int* size, guchar value);
static GVariant* _variant_new12 (gchar** value, gint value_length1);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static GVariant* _variant_new13 (GVariant** value, gint value_length1);
static void _vala_array_add5 (GVariant*** array, int* length, int* size, GVariant* value);
GVariant* zcd_serializer_tuple_to_variant_3 (GVariant* v0, GVariant* v1, GVariant* v2);
void zcd_serializer_variant_to_tuple_3 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2);
GVariant* zcd_serializer_tuple_to_variant_4 (GVariant* v0, GVariant* v1, GVariant* v2, GVariant* v3);
void zcd_serializer_variant_to_tuple_4 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2, GVariant** v3);
GVariant* zcd_serializer_tuple_to_variant_5 (GVariant* v0, GVariant* v1, GVariant* v2, GVariant* v3, GVariant* v4);
void zcd_serializer_variant_to_tuple_5 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2, GVariant** v3, GVariant** v4);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark zcd_serializer_error_quark (void) {
	return g_quark_from_static_string ("zcd_serializer_error-quark");
}


GVariant* zcd_iserializable_serialize_to_variant (zcdISerializable* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ZCD_ISERIALIZABLE_GET_INTERFACE (self)->serialize_to_variant (self);
}


void zcd_iserializable_deserialize_from_variant (zcdISerializable* self, GVariant* v, GError** error) {
	g_return_if_fail (self != NULL);
	ZCD_ISERIALIZABLE_GET_INTERFACE (self)->deserialize_from_variant (self, v, error);
}


guchar* zcd_iserializable_serialize (zcdISerializable* self, int* result_length1) {
	guchar* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* vtuple;
	GType _tmp1_ = 0UL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* s;
	const gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* v1;
	guchar* ser;
	gint ser_length1;
	gint _ser_size_;
	gboolean _tmp7_;
	GVariant* _tmp10_;
	gsize _tmp11_ = 0UL;
	gsize siz;
	guchar* _tmp12_ = NULL;
	GVariant* _tmp13_;
	guchar* _tmp14_;
	gint _tmp14__length1;
	guchar* _tmp15_;
	gint _tmp15__length1;
	_tmp0_ = zcd_iserializable_serialize_to_variant (self);
	vtuple = _tmp0_;
	_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp2_ = g_type_name (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	s = _tmp3_;
	_tmp4_ = s;
	_tmp5_ = vtuple;
	_tmp6_ = g_variant_new ("(sv)", _tmp4_, _tmp5_, NULL);
	g_variant_ref_sink (_tmp6_);
	v1 = _tmp6_;
	ser = NULL;
	ser_length1 = 0;
	_ser_size_ = ser_length1;
	_tmp7_ = zcd_endianness_network;
	if (!_tmp7_) {
		GVariant* _tmp8_;
		GVariant* _tmp9_ = NULL;
		_tmp8_ = v1;
		_tmp9_ = g_variant_byteswap (_tmp8_);
		_g_variant_unref0 (v1);
		v1 = _tmp9_;
	}
	_tmp10_ = v1;
	_tmp11_ = g_variant_get_size (_tmp10_);
	siz = _tmp11_;
	_tmp12_ = g_new0 (guchar, siz);
	ser = (g_free (ser), NULL);
	ser = _tmp12_;
	ser_length1 = siz;
	_ser_size_ = ser_length1;
	_tmp13_ = v1;
	_tmp14_ = ser;
	_tmp14__length1 = ser_length1;
	g_variant_store (_tmp13_, _tmp14_);
	_tmp15_ = ser;
	_tmp15__length1 = ser_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_variant_unref0 (v1);
	_g_free0 (s);
	_g_variant_unref0 (vtuple);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


zcdISerializable* zcd_iserializable_deserialize (guchar* ser, int ser_length1, GError** error) {
	zcdISerializable* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	zcdBufferOwner* _tmp1_;
	zcdBufferOwner* owner;
	GVariantType* _tmp2_;
	GVariantType* vt;
	const GVariantType* _tmp3_;
	zcdBufferOwner* _tmp4_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* _tmp6_;
	gint _tmp6__length1;
	zcdBufferOwner* _tmp7_;
	zcdBufferOwner* _tmp8_;
	GVariant* _tmp9_ = NULL;
	GVariant* v2;
	gboolean _tmp10_;
	gchar* typename = NULL;
	GVariant* vtuple = NULL;
	GVariant* _tmp13_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp17_;
	const gchar* _tmp19_;
	GType _tmp20_ = 0UL;
	GType type;
	GType _tmp21_;
	GType _tmp28_;
	gboolean _tmp29_ = FALSE;
	GType _tmp36_;
	GObject* _tmp37_ = NULL;
	GObject* _tmp38_;
	GObject* obj;
	GObject* _tmp39_;
	zcdISerializable* _tmp40_;
	zcdISerializable* retval;
	zcdISerializable* _tmp41_;
	GVariant* _tmp42_;
	GError * _inner_error_ = NULL;
	_tmp0_ = ser;
	_tmp0__length1 = ser_length1;
	_tmp1_ = zcd_buffer_owner_new (_tmp0_, _tmp0__length1);
	owner = _tmp1_;
	_tmp2_ = g_variant_type_new ("(sv)");
	vt = _tmp2_;
	_tmp3_ = vt;
	_tmp4_ = owner;
	_tmp5_ = zcd_buffer_owner_get_buf (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = owner;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = g_variant_new_from_data (_tmp3_, _tmp6_, _tmp6__length1, FALSE, g_object_unref, _tmp8_);
	g_variant_ref_sink (_tmp9_);
	v2 = _tmp9_;
	_tmp10_ = zcd_endianness_network;
	if (!_tmp10_) {
		GVariant* _tmp11_;
		GVariant* _tmp12_ = NULL;
		_tmp11_ = v2;
		_tmp12_ = g_variant_byteswap (_tmp11_);
		_g_variant_unref0 (v2);
		v2 = _tmp12_;
	}
	_tmp13_ = v2;
	g_variant_get (_tmp13_, "(sv)", &typename, &vtuple, NULL);
	_tmp15_ = typename;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp16_;
		_tmp16_ = typename;
		_tmp14_ = g_strcmp0 (_tmp16_, "") == 0;
	}
	_tmp17_ = _tmp14_;
	if (_tmp17_) {
		GError* _tmp18_;
		_tmp18_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, "Typename not specified.");
		_inner_error_ = _tmp18_;
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (vtuple);
			_g_free0 (typename);
			_g_variant_unref0 (v2);
			_g_variant_type_free0 (vt);
			_g_object_unref0 (owner);
			return NULL;
		} else {
			_g_variant_unref0 (vtuple);
			_g_free0 (typename);
			_g_variant_unref0 (v2);
			_g_variant_type_free0 (vt);
			_g_object_unref0 (owner);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp19_ = typename;
	_tmp20_ = g_type_from_name (_tmp19_);
	type = _tmp20_;
	_tmp21_ = type;
	if (_tmp21_ == ((GType) 0)) {
		const gchar* _tmp22_;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
		_tmp22_ = typename;
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = g_strconcat ("Typename '", _tmp23_, "' is unknown.", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_inner_error_ = _tmp27_;
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (vtuple);
			_g_free0 (typename);
			_g_variant_unref0 (v2);
			_g_variant_type_free0 (vt);
			_g_object_unref0 (owner);
			return NULL;
		} else {
			_g_variant_unref0 (vtuple);
			_g_free0 (typename);
			_g_variant_unref0 (v2);
			_g_variant_type_free0 (vt);
			_g_object_unref0 (owner);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp28_ = type;
	_tmp29_ = g_type_is_a (_tmp28_, ZCD_TYPE_ISERIALIZABLE);
	if (!_tmp29_) {
		const gchar* _tmp30_;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		GError* _tmp34_;
		GError* _tmp35_;
		_tmp30_ = typename;
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = g_strconcat ("Typename '", _tmp31_, "' is not serializable.", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_inner_error_ = _tmp35_;
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (vtuple);
			_g_free0 (typename);
			_g_variant_unref0 (v2);
			_g_variant_type_free0 (vt);
			_g_object_unref0 (owner);
			return NULL;
		} else {
			_g_variant_unref0 (vtuple);
			_g_free0 (typename);
			_g_variant_unref0 (v2);
			_g_variant_type_free0 (vt);
			_g_object_unref0 (owner);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp36_ = type;
	_tmp37_ = g_object_new (_tmp36_, NULL);
	_tmp38_ = G_IS_INITIALLY_UNOWNED (_tmp37_) ? g_object_ref_sink (_tmp37_) : _tmp37_;
	obj = _tmp38_;
	_tmp39_ = obj;
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, ZCD_TYPE_ISERIALIZABLE, zcdISerializable));
	retval = _tmp40_;
	_tmp41_ = retval;
	_tmp42_ = vtuple;
	zcd_iserializable_deserialize_from_variant (_tmp41_, _tmp42_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (retval);
			_g_object_unref0 (obj);
			_g_variant_unref0 (vtuple);
			_g_free0 (typename);
			_g_variant_unref0 (v2);
			_g_variant_type_free0 (vt);
			_g_object_unref0 (owner);
			return NULL;
		} else {
			_g_object_unref0 (retval);
			_g_object_unref0 (obj);
			_g_variant_unref0 (vtuple);
			_g_free0 (typename);
			_g_variant_unref0 (v2);
			_g_variant_type_free0 (vt);
			_g_object_unref0 (owner);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = retval;
	_g_object_unref0 (obj);
	_g_variant_unref0 (vtuple);
	_g_free0 (typename);
	_g_variant_unref0 (v2);
	_g_variant_type_free0 (vt);
	_g_object_unref0 (owner);
	return result;
}


gboolean zcd_iserializable_is_instance_of (GType t1, guchar* ser, int ser_length1) {
	gboolean result = FALSE;
	guchar* _tmp0_;
	gint _tmp0__length1;
	zcdBufferOwner* _tmp1_;
	zcdBufferOwner* owner;
	GVariantType* _tmp2_;
	GVariantType* vt;
	const GVariantType* _tmp3_;
	zcdBufferOwner* _tmp4_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* _tmp6_;
	gint _tmp6__length1;
	zcdBufferOwner* _tmp7_;
	zcdBufferOwner* _tmp8_;
	GVariant* _tmp9_ = NULL;
	GVariant* v2;
	gboolean _tmp10_;
	gchar* typename = NULL;
	GVariant* vtuple = NULL;
	GVariant* _tmp13_;
	GType _tmp14_ = 0UL;
	GType t2;
	GType _tmp15_;
	gboolean _tmp16_ = FALSE;
	_tmp0_ = ser;
	_tmp0__length1 = ser_length1;
	_tmp1_ = zcd_buffer_owner_new (_tmp0_, _tmp0__length1);
	owner = _tmp1_;
	_tmp2_ = g_variant_type_new ("(sv)");
	vt = _tmp2_;
	_tmp3_ = vt;
	_tmp4_ = owner;
	_tmp5_ = zcd_buffer_owner_get_buf (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = owner;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = g_variant_new_from_data (_tmp3_, _tmp6_, _tmp6__length1, FALSE, g_object_unref, _tmp8_);
	g_variant_ref_sink (_tmp9_);
	v2 = _tmp9_;
	_tmp10_ = zcd_endianness_network;
	if (!_tmp10_) {
		GVariant* _tmp11_;
		GVariant* _tmp12_ = NULL;
		_tmp11_ = v2;
		_tmp12_ = g_variant_byteswap (_tmp11_);
		_g_variant_unref0 (v2);
		v2 = _tmp12_;
	}
	_tmp13_ = v2;
	g_variant_get (_tmp13_, "(sv)", &typename, &vtuple, NULL);
	_tmp14_ = g_type_from_name (typename);
	t2 = _tmp14_;
	_tmp15_ = t1;
	_tmp16_ = g_type_is_a (t2, _tmp15_);
	result = _tmp16_;
	_g_variant_unref0 (vtuple);
	_g_free0 (typename);
	_g_variant_unref0 (v2);
	_g_variant_type_free0 (vt);
	_g_object_unref0 (owner);
	return result;
}


gchar* zcd_iserializable_typename (guchar* ser, int ser_length1) {
	gchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	zcdBufferOwner* _tmp1_;
	zcdBufferOwner* owner;
	GVariantType* _tmp2_;
	GVariantType* vt;
	const GVariantType* _tmp3_;
	zcdBufferOwner* _tmp4_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* _tmp6_;
	gint _tmp6__length1;
	zcdBufferOwner* _tmp7_;
	zcdBufferOwner* _tmp8_;
	GVariant* _tmp9_ = NULL;
	GVariant* v2;
	gboolean _tmp10_;
	gchar* typename = NULL;
	GVariant* vtuple = NULL;
	GVariant* _tmp13_;
	_tmp0_ = ser;
	_tmp0__length1 = ser_length1;
	_tmp1_ = zcd_buffer_owner_new (_tmp0_, _tmp0__length1);
	owner = _tmp1_;
	_tmp2_ = g_variant_type_new ("(sv)");
	vt = _tmp2_;
	_tmp3_ = vt;
	_tmp4_ = owner;
	_tmp5_ = zcd_buffer_owner_get_buf (_tmp4_, &_tmp5__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = owner;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = g_variant_new_from_data (_tmp3_, _tmp6_, _tmp6__length1, FALSE, g_object_unref, _tmp8_);
	g_variant_ref_sink (_tmp9_);
	v2 = _tmp9_;
	_tmp10_ = zcd_endianness_network;
	if (!_tmp10_) {
		GVariant* _tmp11_;
		GVariant* _tmp12_ = NULL;
		_tmp11_ = v2;
		_tmp12_ = g_variant_byteswap (_tmp11_);
		_g_variant_unref0 (v2);
		v2 = _tmp12_;
	}
	_tmp13_ = v2;
	g_variant_get (_tmp13_, "(sv)", &typename, &vtuple, NULL);
	result = typename;
	_g_variant_unref0 (vtuple);
	_g_variant_unref0 (v2);
	_g_variant_type_free0 (vt);
	_g_object_unref0 (owner);
	return result;
}


static void zcd_iserializable_base_init (zcdISerializableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/** The interface ISerializable has to be implemented by any
      * class whose instances we want to be able to serialize and
      * transmit over the net.
      * The class that we want to be serializeable needs to know how
      * to put in a Variant its data and retrieve it from a Variant.
      * But the code that wants to serialize an instance of those classes
      * will use the methods serialize and deserialize, which treat
      * simple uchar arrays.
      */
GType zcd_iserializable_get_type (void) {
	static volatile gsize zcd_iserializable_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_iserializable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdISerializableIface), (GBaseInitFunc) zcd_iserializable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType zcd_iserializable_type_id;
		zcd_iserializable_type_id = g_type_register_static (G_TYPE_INTERFACE, "zcdISerializable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (zcd_iserializable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&zcd_iserializable_type_id__volatile, zcd_iserializable_type_id);
	}
	return zcd_iserializable_type_id__volatile;
}


zcdBufferOwner* zcd_buffer_owner_construct (GType object_type, guchar* seed, int seed_length1) {
	zcdBufferOwner * self = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_ = NULL;
	guchar* _tmp2_;
	gint _tmp2__length1;
	guchar* _tmp3_;
	gint _tmp3__length1;
	guchar* _tmp4_;
	gint _tmp4__length1;
	self = (zcdBufferOwner*) g_object_new (object_type, NULL);
	_tmp0_ = seed;
	_tmp0__length1 = seed_length1;
	_tmp1_ = g_new0 (guchar, _tmp0__length1);
	self->priv->_buf = (g_free (self->priv->_buf), NULL);
	self->priv->_buf = _tmp1_;
	self->priv->_buf_length1 = _tmp0__length1;
	self->priv->__buf_size_ = self->priv->_buf_length1;
	_tmp2_ = self->priv->_buf;
	_tmp2__length1 = self->priv->_buf_length1;
	_tmp3_ = seed;
	_tmp3__length1 = seed_length1;
	_tmp4_ = seed;
	_tmp4__length1 = seed_length1;
	memcpy ((void*) _tmp2_, (void*) _tmp3_, ((gsize) _tmp4__length1) * sizeof (guchar));
	return self;
}


zcdBufferOwner* zcd_buffer_owner_new (guchar* seed, int seed_length1) {
	return zcd_buffer_owner_construct (ZCD_TYPE_BUFFER_OWNER, seed, seed_length1);
}


guchar* zcd_buffer_owner_get_buf (zcdBufferOwner* self, int* result_length1) {
	guchar* result;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_buf;
	_tmp0__length1 = self->priv->_buf_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static void zcd_buffer_owner_class_init (zcdBufferOwnerClass * klass) {
	zcd_buffer_owner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdBufferOwnerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_buffer_owner_get_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_buffer_owner_finalize;
}


static void zcd_buffer_owner_instance_init (zcdBufferOwner * self) {
	self->priv = ZCD_BUFFER_OWNER_GET_PRIVATE (self);
}


static void zcd_buffer_owner_finalize (GObject* obj) {
	zcdBufferOwner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_BUFFER_OWNER, zcdBufferOwner);
	self->priv->_buf = (g_free (self->priv->_buf), NULL);
	G_OBJECT_CLASS (zcd_buffer_owner_parent_class)->finalize (obj);
}


GType zcd_buffer_owner_get_type (void) {
	static volatile gsize zcd_buffer_owner_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_buffer_owner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdBufferOwnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_buffer_owner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdBufferOwner), 0, (GInstanceInitFunc) zcd_buffer_owner_instance_init, NULL };
		GType zcd_buffer_owner_type_id;
		zcd_buffer_owner_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdBufferOwner", &g_define_type_info, 0);
		g_once_init_leave (&zcd_buffer_owner_type_id__volatile, zcd_buffer_owner_type_id);
	}
	return zcd_buffer_owner_type_id__volatile;
}


static void _vala_zcd_buffer_owner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdBufferOwner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_BUFFER_OWNER, zcdBufferOwner);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GVariant* zcd_serializable_none_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableNone * self;
	GVariant* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* v;
	self = (zcdSerializableNone*) base;
	_tmp0_ = zcd_serializer_int_to_variant (0);
	v = _tmp0_;
	result = v;
	return result;
}


static void zcd_serializable_none_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableNone * self;
	self = (zcdSerializableNone*) base;
	g_return_if_fail (v != NULL);
}


zcdSerializableNone* zcd_serializable_none_construct (GType object_type) {
	zcdSerializableNone * self = NULL;
	self = (zcdSerializableNone*) g_object_new (object_type, NULL);
	return self;
}


zcdSerializableNone* zcd_serializable_none_new (void) {
	return zcd_serializable_none_construct (ZCD_TYPE_SERIALIZABLE_NONE);
}


static void zcd_serializable_none_class_init (zcdSerializableNoneClass * klass) {
	zcd_serializable_none_parent_class = g_type_class_peek_parent (klass);
}


static void zcd_serializable_none_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	zcd_serializable_none_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_none_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_none_real_deserialize_from_variant;
}


static void zcd_serializable_none_instance_init (zcdSerializableNone * self) {
}


/** Return value for "void"
      */
GType zcd_serializable_none_get_type (void) {
	static volatile gsize zcd_serializable_none_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_none_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableNoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_none_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableNone), 0, (GInstanceInitFunc) zcd_serializable_none_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_none_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_none_type_id;
		zcd_serializable_none_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableNone", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_none_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_none_type_id__volatile, zcd_serializable_none_type_id);
	}
	return zcd_serializable_none_type_id__volatile;
}


zcdSerializableInt* zcd_serializable_int_construct (GType object_type, gint i) {
	zcdSerializableInt * self = NULL;
	gint _tmp0_;
	self = (zcdSerializableInt*) g_object_new (object_type, NULL);
	_tmp0_ = i;
	self->priv->_i = _tmp0_;
	return self;
}


zcdSerializableInt* zcd_serializable_int_new (gint i) {
	return zcd_serializable_int_construct (ZCD_TYPE_SERIALIZABLE_INT, i);
}


static GVariant* zcd_serializable_int_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableInt * self;
	GVariant* result = NULL;
	gint _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* v;
	self = (zcdSerializableInt*) base;
	_tmp0_ = self->priv->_i;
	_tmp1_ = zcd_serializer_int_to_variant (_tmp0_);
	v = _tmp1_;
	result = v;
	return result;
}


static void zcd_serializable_int_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableInt * self;
	GVariant* _tmp0_;
	gint _tmp1_ = 0;
	self = (zcdSerializableInt*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = zcd_serializer_variant_to_int (_tmp0_);
	self->priv->_i = _tmp1_;
}


gint zcd_serializable_int_get_i (zcdSerializableInt* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_i;
	result = _tmp0_;
	return result;
}


static void zcd_serializable_int_class_init (zcdSerializableIntClass * klass) {
	zcd_serializable_int_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdSerializableIntPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_serializable_int_get_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_serializable_int_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_SERIALIZABLE_INT_I, g_param_spec_int ("i", "i", "i", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zcd_serializable_int_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	zcd_serializable_int_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_int_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_int_real_deserialize_from_variant;
}


static void zcd_serializable_int_instance_init (zcdSerializableInt * self) {
	self->priv = ZCD_SERIALIZABLE_INT_GET_PRIVATE (self);
}


static void zcd_serializable_int_finalize (GObject* obj) {
	zcdSerializableInt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt);
	G_OBJECT_CLASS (zcd_serializable_int_parent_class)->finalize (obj);
}


/** Serializable class for int
      */
GType zcd_serializable_int_get_type (void) {
	static volatile gsize zcd_serializable_int_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_int_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableIntClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_int_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableInt), 0, (GInstanceInitFunc) zcd_serializable_int_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_int_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_int_type_id;
		zcd_serializable_int_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableInt", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_int_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_int_type_id__volatile, zcd_serializable_int_type_id);
	}
	return zcd_serializable_int_type_id__volatile;
}


static void _vala_zcd_serializable_int_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdSerializableInt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt);
	switch (property_id) {
		case ZCD_SERIALIZABLE_INT_I:
		g_value_set_int (value, zcd_serializable_int_get_i (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


zcdSerializableBool* zcd_serializable_bool_construct (GType object_type, gboolean b) {
	zcdSerializableBool * self = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	gint _tmp2_;
	self = (zcdSerializableBool*) g_object_new (object_type, NULL);
	_tmp1_ = b;
	if (_tmp1_) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp2_ = _tmp0_;
	self->priv->_i = _tmp2_;
	return self;
}


zcdSerializableBool* zcd_serializable_bool_new (gboolean b) {
	return zcd_serializable_bool_construct (ZCD_TYPE_SERIALIZABLE_BOOL, b);
}


static GVariant* zcd_serializable_bool_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableBool * self;
	GVariant* result = NULL;
	gint _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* v;
	self = (zcdSerializableBool*) base;
	_tmp0_ = self->priv->_i;
	_tmp1_ = zcd_serializer_int_to_variant (_tmp0_);
	v = _tmp1_;
	result = v;
	return result;
}


static void zcd_serializable_bool_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableBool * self;
	GVariant* _tmp0_;
	gint _tmp1_ = 0;
	self = (zcdSerializableBool*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = zcd_serializer_variant_to_int (_tmp0_);
	self->priv->_i = _tmp1_;
}


gboolean zcd_serializable_bool_get_b (zcdSerializableBool* self) {
	gboolean result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_i;
	result = _tmp0_ == 1;
	return result;
}


static void zcd_serializable_bool_class_init (zcdSerializableBoolClass * klass) {
	zcd_serializable_bool_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdSerializableBoolPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_serializable_bool_get_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_serializable_bool_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_SERIALIZABLE_BOOL_B, g_param_spec_boolean ("b", "b", "b", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zcd_serializable_bool_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	zcd_serializable_bool_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_bool_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_bool_real_deserialize_from_variant;
}


static void zcd_serializable_bool_instance_init (zcdSerializableBool * self) {
	self->priv = ZCD_SERIALIZABLE_BOOL_GET_PRIVATE (self);
}


static void zcd_serializable_bool_finalize (GObject* obj) {
	zcdSerializableBool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool);
	G_OBJECT_CLASS (zcd_serializable_bool_parent_class)->finalize (obj);
}


/** Serializable class for bool
      */
GType zcd_serializable_bool_get_type (void) {
	static volatile gsize zcd_serializable_bool_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_bool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableBoolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_bool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableBool), 0, (GInstanceInitFunc) zcd_serializable_bool_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_bool_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_bool_type_id;
		zcd_serializable_bool_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableBool", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_bool_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_bool_type_id__volatile, zcd_serializable_bool_type_id);
	}
	return zcd_serializable_bool_type_id__volatile;
}


static void _vala_zcd_serializable_bool_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdSerializableBool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool);
	switch (property_id) {
		case ZCD_SERIALIZABLE_BOOL_B:
		g_value_set_boolean (value, zcd_serializable_bool_get_b (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


zcdSerializableString* zcd_serializable_string_construct (GType object_type, const gchar* s) {
	zcdSerializableString * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (s != NULL, NULL);
	self = (zcdSerializableString*) g_object_new (object_type, NULL);
	_tmp0_ = s;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_s);
	self->priv->_s = _tmp1_;
	return self;
}


zcdSerializableString* zcd_serializable_string_new (const gchar* s) {
	return zcd_serializable_string_construct (ZCD_TYPE_SERIALIZABLE_STRING, s);
}


static GVariant* zcd_serializable_string_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableString * self;
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* v;
	self = (zcdSerializableString*) base;
	_tmp0_ = self->priv->_s;
	_tmp1_ = zcd_serializer_string_to_variant (_tmp0_);
	v = _tmp1_;
	result = v;
	return result;
}


static void zcd_serializable_string_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableString * self;
	GVariant* _tmp0_;
	gchar* _tmp1_ = NULL;
	self = (zcdSerializableString*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = zcd_serializer_variant_to_string (_tmp0_);
	_g_free0 (self->priv->_s);
	self->priv->_s = _tmp1_;
}


const gchar* zcd_serializable_string_get_s (zcdSerializableString* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_s;
	result = _tmp0_;
	return result;
}


static void zcd_serializable_string_class_init (zcdSerializableStringClass * klass) {
	zcd_serializable_string_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdSerializableStringPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_serializable_string_get_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_serializable_string_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_SERIALIZABLE_STRING_S, g_param_spec_string ("s", "s", "s", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zcd_serializable_string_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	zcd_serializable_string_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_string_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_string_real_deserialize_from_variant;
}


static void zcd_serializable_string_instance_init (zcdSerializableString * self) {
	self->priv = ZCD_SERIALIZABLE_STRING_GET_PRIVATE (self);
}


static void zcd_serializable_string_finalize (GObject* obj) {
	zcdSerializableString * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString);
	_g_free0 (self->priv->_s);
	G_OBJECT_CLASS (zcd_serializable_string_parent_class)->finalize (obj);
}


/** Serializable class for string
      */
GType zcd_serializable_string_get_type (void) {
	static volatile gsize zcd_serializable_string_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_string_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableStringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_string_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableString), 0, (GInstanceInitFunc) zcd_serializable_string_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_string_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_string_type_id;
		zcd_serializable_string_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableString", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_string_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_string_type_id__volatile, zcd_serializable_string_type_id);
	}
	return zcd_serializable_string_type_id__volatile;
}


static void _vala_zcd_serializable_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdSerializableString * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString);
	switch (property_id) {
		case ZCD_SERIALIZABLE_STRING_S:
		g_value_set_string (value, zcd_serializable_string_get_s (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


zcdSerializableBuffer* zcd_serializable_buffer_construct (GType object_type, guint8* buffer, int buffer_length1) {
	zcdSerializableBuffer * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	self = (zcdSerializableBuffer*) g_object_new (object_type, NULL);
	_tmp0_ = buffer;
	_tmp0__length1 = buffer_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_buffer = (g_free (self->priv->_buffer), NULL);
	self->priv->_buffer = _tmp1_;
	self->priv->_buffer_length1 = _tmp1__length1;
	self->priv->__buffer_size_ = self->priv->_buffer_length1;
	return self;
}


zcdSerializableBuffer* zcd_serializable_buffer_new (guint8* buffer, int buffer_length1) {
	return zcd_serializable_buffer_construct (ZCD_TYPE_SERIALIZABLE_BUFFER, buffer, buffer_length1);
}


static GVariant* zcd_serializable_buffer_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableBuffer * self;
	GVariant* result = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp1_ = NULL;
	self = (zcdSerializableBuffer*) base;
	_tmp0_ = self->priv->_buffer;
	_tmp0__length1 = self->priv->_buffer_length1;
	_tmp1_ = zcd_serializer_uchar_array_to_variant ((guchar*) _tmp0_, (_tmp0__length1 * sizeof (guint8)) / sizeof (guchar));
	result = _tmp1_;
	return result;
}


static void zcd_serializable_buffer_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableBuffer * self;
	GVariant* _tmp0_;
	gint _tmp1_ = 0;
	guchar* _tmp2_ = NULL;
	self = (zcdSerializableBuffer*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp2_ = zcd_serializer_variant_to_uchar_array (_tmp0_, &_tmp1_);
	self->priv->_buffer = (g_free (self->priv->_buffer), NULL);
	self->priv->_buffer = (guint8*) _tmp2_;
	self->priv->_buffer_length1 = (_tmp1_ * sizeof (guchar)) / sizeof (guint8);
	self->priv->__buffer_size_ = self->priv->_buffer_length1;
}


guint8* zcd_serializable_buffer_get_buffer (zcdSerializableBuffer* self, int* result_length1) {
	guint8* result;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_buffer;
	_tmp0__length1 = self->priv->_buffer_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static void zcd_serializable_buffer_class_init (zcdSerializableBufferClass * klass) {
	zcd_serializable_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (zcdSerializableBufferPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_serializable_buffer_get_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_serializable_buffer_finalize;
}


static void zcd_serializable_buffer_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	zcd_serializable_buffer_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_buffer_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_buffer_real_deserialize_from_variant;
}


static void zcd_serializable_buffer_instance_init (zcdSerializableBuffer * self) {
	self->priv = ZCD_SERIALIZABLE_BUFFER_GET_PRIVATE (self);
}


static void zcd_serializable_buffer_finalize (GObject* obj) {
	zcdSerializableBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
	self->priv->_buffer = (g_free (self->priv->_buffer), NULL);
	G_OBJECT_CLASS (zcd_serializable_buffer_parent_class)->finalize (obj);
}


/** Serializable class for uint8[]
      */
GType zcd_serializable_buffer_get_type (void) {
	static volatile gsize zcd_serializable_buffer_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_buffer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableBuffer), 0, (GInstanceInitFunc) zcd_serializable_buffer_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_buffer_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_buffer_type_id;
		zcd_serializable_buffer_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableBuffer", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_buffer_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_buffer_type_id__volatile, zcd_serializable_buffer_type_id);
	}
	return zcd_serializable_buffer_type_id__volatile;
}


static void _vala_zcd_serializable_buffer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdSerializableBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


zcdListString* zcd_list_string_construct (GType object_type) {
	zcdListString * self = NULL;
	GeeArrayList* _tmp0_;
	self = (zcdListString*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->backed);
	self->backed = (GeeList*) _tmp0_;
	return self;
}


zcdListString* zcd_list_string_new (void) {
	return zcd_list_string_construct (ZCD_TYPE_LIST_STRING);
}


zcdListString* zcd_list_string_construct_with_backer (GType object_type, GeeList* backed) {
	zcdListString * self = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_val_if_fail (backed != NULL, NULL);
	self = (zcdListString*) g_object_new (object_type, NULL);
	_tmp0_ = backed;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->backed);
	self->backed = _tmp1_;
	return self;
}


zcdListString* zcd_list_string_new_with_backer (GeeList* backed) {
	return zcd_list_string_construct_with_backer (ZCD_TYPE_LIST_STRING, backed);
}


GeeIterator* zcd_list_string_iterator (zcdListString* self) {
	GeeIterator* result = NULL;
	GeeList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->backed;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	result = _tmp1_;
	return result;
}


void zcd_list_string_add (zcdListString* self, const gchar* el) {
	GeeList* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (el != NULL);
	_tmp0_ = self->backed;
	_tmp1_ = el;
	gee_collection_add ((GeeCollection*) _tmp0_, _tmp1_);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void _vala_array_add1 (guchar** array, int* length, int* size, guchar value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guchar, *array, *size);
	}
	(*array)[(*length)++] = value;
}


guchar* zcd_list_string_hash_for_signature (zcdListString* self, int* result_length1) {
	guchar* result = NULL;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guchar* _tmp5_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	guchar* _tmp22_;
	gint _tmp22__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->backed;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		guchar* _tmp3_ = NULL;
		guchar* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (guchar, 1);
		_tmp3_[0] = (guchar) 0;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_new0 (guchar, 1);
	_tmp5_[0] = (guchar) 1;
	ret = _tmp5_;
	ret_length1 = 1;
	_ret_size_ = ret_length1;
	{
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		GeeList* _s_list;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _s_size;
		gint _s_index;
		_tmp6_ = self->backed;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_s_list = _tmp7_;
		_tmp8_ = _s_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_s_size = _tmp10_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			gchar* s;
			const gchar* _tmp17_;
			guint8* _tmp18_;
			gint _tmp18__length1;
			guint8* _tmp19_;
			gint _tmp19__length1;
			_tmp11_ = _s_index;
			_s_index = _tmp11_ + 1;
			_tmp12_ = _s_index;
			_tmp13_ = _s_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _s_list;
			_tmp15_ = _s_index;
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
			s = (gchar*) _tmp16_;
			_tmp17_ = s;
			_tmp18_ = string_get_data (_tmp17_, &_tmp18__length1);
			_tmp19_ = _tmp18_;
			_tmp19__length1 = _tmp18__length1;
			{
				guint8* u_collection = NULL;
				gint u_collection_length1 = 0;
				gint _u_collection_size_ = 0;
				gint u_it = 0;
				u_collection = _tmp19_;
				u_collection_length1 = _tmp19__length1;
				for (u_it = 0; u_it < _tmp19__length1; u_it = u_it + 1) {
					guchar u = '\0';
					u = (guchar) u_collection[u_it];
					{
						guchar* _tmp20_;
						gint _tmp20__length1;
						guchar _tmp21_;
						_tmp20_ = ret;
						_tmp20__length1 = ret_length1;
						_tmp21_ = u;
						_vala_array_add1 (&ret, &ret_length1, &_ret_size_, _tmp21_);
					}
				}
			}
			_g_free0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	_tmp22_ = ret;
	_tmp22__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	return result;
}


static GVariant* zcd_list_string_real_serialize_to_variant (zcdISerializable* base) {
	zcdListString * self;
	GVariant* result = NULL;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** toar;
	gint toar_length1;
	gint _toar_size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	GVariant* _tmp22_ = NULL;
	self = (zcdListString*) base;
	_tmp0_ = self->backed;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		GVariant* _tmp3_ = NULL;
		_tmp3_ = zcd_serializer_int_to_variant (0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->backed;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (gchar*, _tmp6_ + 1);
	toar = _tmp7_;
	toar_length1 = _tmp6_;
	_toar_size_ = toar_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				GeeList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				GeeList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_ = NULL;
				gchar* _tmp20_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = self->backed;
				_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				if (!(_tmp11_ < _tmp14_)) {
					break;
				}
				_tmp15_ = toar;
				_tmp15__length1 = toar_length1;
				_tmp16_ = i;
				_tmp17_ = self->backed;
				_tmp18_ = i;
				_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
				_g_free0 (_tmp15_[_tmp16_]);
				_tmp15_[_tmp16_] = (gchar*) _tmp19_;
				_tmp20_ = _tmp15_[_tmp16_];
			}
		}
	}
	_tmp21_ = toar;
	_tmp21__length1 = toar_length1;
	_tmp22_ = zcd_serializer_string_array_to_variant (_tmp21_, _tmp21__length1);
	result = _tmp22_;
	toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void zcd_list_string_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdListString * self;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* vt;
	GeeArrayList* _tmp3_;
	const gchar* _tmp4_;
	self = (zcdListString*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_get_type_string (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	vt = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->backed);
	self->backed = (GeeList*) _tmp3_;
	_tmp4_ = vt;
	if (g_strcmp0 (_tmp4_, "i") != 0) {
		GVariant* _tmp5_;
		gint _tmp6_ = 0;
		gchar** _tmp7_ = NULL;
		gchar** toar;
		gint toar_length1;
		gint _toar_size_;
		_tmp5_ = v;
		_tmp7_ = zcd_serializer_variant_to_string_array (_tmp5_, &_tmp6_);
		toar = _tmp7_;
		toar_length1 = _tmp6_;
		_toar_size_ = toar_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
					GeeList* _tmp13_;
					gchar** _tmp14_;
					gint _tmp14__length1;
					gint _tmp15_;
					const gchar* _tmp16_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = toar;
					_tmp12__length1 = toar_length1;
					if (!(_tmp11_ < _tmp12__length1)) {
						break;
					}
					_tmp13_ = self->backed;
					_tmp14_ = toar;
					_tmp14__length1 = toar_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					gee_collection_add ((GeeCollection*) _tmp13_, _tmp16_);
				}
			}
		}
		toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (vt);
}


gint zcd_list_string_get_size (zcdListString* self) {
	gint result;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->backed;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void zcd_list_string_class_init (zcdListStringClass * klass) {
	zcd_list_string_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_list_string_get_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_list_string_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_LIST_STRING_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zcd_list_string_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	zcd_list_string_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_list_string_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_list_string_real_deserialize_from_variant;
}


static void zcd_list_string_instance_init (zcdListString * self) {
}


static void zcd_list_string_finalize (GObject* obj) {
	zcdListString * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_LIST_STRING, zcdListString);
	_g_object_unref0 (self->backed);
	G_OBJECT_CLASS (zcd_list_string_parent_class)->finalize (obj);
}


/** Serializable class for List<string>
      */
GType zcd_list_string_get_type (void) {
	static volatile gsize zcd_list_string_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_list_string_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdListStringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_list_string_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdListString), 0, (GInstanceInitFunc) zcd_list_string_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_list_string_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_list_string_type_id;
		zcd_list_string_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdListString", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_list_string_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_list_string_type_id__volatile, zcd_list_string_type_id);
	}
	return zcd_list_string_type_id__volatile;
}


static void _vala_zcd_list_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdListString * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_LIST_STRING, zcdListString);
	switch (property_id) {
		case ZCD_LIST_STRING_SIZE:
		g_value_set_int (value, zcd_list_string_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gboolean zcd_list_iserializable_not_impl_equal_func (GObject* a, GObject* b) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* astr;
	GObject* _tmp1_;
	gchar* _tmp6_;
	gchar* bstr;
	GObject* _tmp7_;
	const gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	_tmp0_ = g_strdup ("null");
	astr = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ != NULL) {
		GObject* _tmp2_;
		GType _tmp3_ = 0UL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp2_ = a;
		_tmp3_ = G_TYPE_FROM_INSTANCE (_tmp2_);
		_tmp4_ = g_type_name (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (astr);
		astr = _tmp5_;
	}
	_tmp6_ = g_strdup ("null");
	bstr = _tmp6_;
	_tmp7_ = b;
	if (_tmp7_ != NULL) {
		GObject* _tmp8_;
		GType _tmp9_ = 0UL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp8_ = b;
		_tmp9_ = G_TYPE_FROM_INSTANCE (_tmp8_);
		_tmp10_ = g_type_name (_tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (bstr);
		bstr = _tmp11_;
	}
	_tmp12_ = astr;
	_tmp13_ = string_to_string (_tmp12_);
	_tmp14_ = bstr;
	_tmp15_ = string_to_string (_tmp14_);
	_tmp16_ = g_strconcat ("equal_func not implemented: compare between ", _tmp13_, " and ", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	g_error ("tcpclient-serializer.vala:323: %s", _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (bstr);
	_g_free0 (astr);
	return result;
}


zcdListISerializable* zcd_list_iserializable_construct (GType object_type) {
	zcdListISerializable * self = NULL;
	GeeArrayList* _tmp0_;
	self = (zcdListISerializable*) g_object_new (object_type, NULL);
	_tmp0_ = gee_array_list_new (ZCD_TYPE_ISERIALIZABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) zcd_list_iserializable_not_impl_equal_func, NULL, NULL);
	_g_object_unref0 (self->backed);
	self->backed = (GeeList*) _tmp0_;
	return self;
}


zcdListISerializable* zcd_list_iserializable_new (void) {
	return zcd_list_iserializable_construct (ZCD_TYPE_LIST_ISERIALIZABLE);
}


zcdListISerializable* zcd_list_iserializable_construct_with_backer (GType object_type, GeeList* backed) {
	zcdListISerializable * self = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	g_return_val_if_fail (backed != NULL, NULL);
	self = (zcdListISerializable*) g_object_new (object_type, NULL);
	_tmp0_ = backed;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->backed);
	self->backed = _tmp1_;
	return self;
}


zcdListISerializable* zcd_list_iserializable_new_with_backer (GeeList* backed) {
	return zcd_list_iserializable_construct_with_backer (ZCD_TYPE_LIST_ISERIALIZABLE, backed);
}


GeeIterator* zcd_list_iserializable_iterator (zcdListISerializable* self) {
	GeeIterator* result = NULL;
	GeeList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->backed;
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
	result = _tmp1_;
	return result;
}


void zcd_list_iserializable_add (zcdListISerializable* self, zcdISerializable* el) {
	GeeList* _tmp0_;
	zcdISerializable* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (el != NULL);
	_tmp0_ = self->backed;
	_tmp1_ = el;
	gee_collection_add ((GeeCollection*) _tmp0_, _tmp1_);
}


static GVariant* zcd_list_iserializable_real_serialize_to_variant (zcdISerializable* base) {
	zcdListISerializable * self;
	GVariant* result = NULL;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GVariant** _tmp7_ = NULL;
	GVariant** toar;
	gint toar_length1;
	gint _toar_size_;
	GVariant** _tmp23_;
	gint _tmp23__length1;
	GVariant* _tmp24_ = NULL;
	GVariant* v0;
	GeeList* _tmp25_;
	gpointer _tmp26_ = NULL;
	zcdISerializable* _tmp27_;
	GType _tmp28_ = 0UL;
	const gchar* _tmp29_ = NULL;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_;
	GVariant* v1;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_ = NULL;
	self = (zcdListISerializable*) base;
	_tmp0_ = self->backed;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		GVariant* _tmp3_ = NULL;
		_tmp3_ = zcd_serializer_int_to_variant (0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = self->backed;
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_new0 (GVariant*, _tmp6_ + 1);
	toar = _tmp7_;
	toar_length1 = _tmp6_;
	_toar_size_ = toar_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				GeeList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GeeList* _tmp15_;
				gint _tmp16_;
				gpointer _tmp17_ = NULL;
				zcdISerializable* el;
				GVariant** _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				zcdISerializable* _tmp20_;
				GVariant* _tmp21_ = NULL;
				GVariant* _tmp22_;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = self->backed;
				_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
				_tmp14_ = _tmp13_;
				if (!(_tmp11_ < _tmp14_)) {
					break;
				}
				_tmp15_ = self->backed;
				_tmp16_ = i;
				_tmp17_ = gee_list_get (_tmp15_, _tmp16_);
				el = G_TYPE_CHECK_INSTANCE_CAST ((zcdISerializable*) _tmp17_, ZCD_TYPE_ISERIALIZABLE, zcdISerializable);
				_tmp18_ = toar;
				_tmp18__length1 = toar_length1;
				_tmp19_ = i;
				_tmp20_ = el;
				_tmp21_ = zcd_iserializable_serialize_to_variant (_tmp20_);
				_g_variant_unref0 (_tmp18_[_tmp19_]);
				_tmp18_[_tmp19_] = _tmp21_;
				_tmp22_ = _tmp18_[_tmp19_];
				_g_object_unref0 (el);
			}
		}
	}
	_tmp23_ = toar;
	_tmp23__length1 = toar_length1;
	_tmp24_ = zcd_serializer_variant_array_to_variant (_tmp23_, _tmp23__length1);
	v0 = _tmp24_;
	_tmp25_ = self->backed;
	_tmp26_ = gee_list_get (_tmp25_, 0);
	_tmp27_ = (zcdISerializable*) _tmp26_;
	_tmp28_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp27_);
	_tmp29_ = g_type_name (_tmp28_);
	_tmp30_ = zcd_serializer_string_to_variant (_tmp29_);
	_tmp31_ = _tmp30_;
	_g_object_unref0 (_tmp27_);
	v1 = _tmp31_;
	_tmp32_ = v0;
	_tmp33_ = v1;
	_tmp34_ = zcd_serializer_tuple_to_variant (_tmp32_, _tmp33_);
	result = _tmp34_;
	_g_variant_unref0 (v1);
	_g_variant_unref0 (v0);
	toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
	return result;
}


static void zcd_list_iserializable_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdListISerializable * self;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* vt;
	GeeArrayList* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (zcdListISerializable*) base;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_get_type_string (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	vt = _tmp2_;
	_tmp3_ = gee_array_list_new (ZCD_TYPE_ISERIALIZABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) zcd_list_iserializable_not_impl_equal_func, NULL, NULL);
	_g_object_unref0 (self->backed);
	self->backed = (GeeList*) _tmp3_;
	_tmp4_ = vt;
	if (g_strcmp0 (_tmp4_, "i") != 0) {
		GVariant* v0 = NULL;
		GVariant* v1 = NULL;
		GVariant* _tmp5_;
		GVariant* _tmp6_ = NULL;
		GVariant* _tmp7_ = NULL;
		GVariant* _tmp8_;
		gint _tmp9_ = 0;
		GVariant** _tmp10_ = NULL;
		GVariant** toar;
		gint toar_length1;
		gint _toar_size_;
		GVariant* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* typename;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gboolean _tmp16_;
		const gchar* _tmp18_;
		GType _tmp19_ = 0UL;
		GType type;
		GType _tmp20_;
		GType _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp5_ = v;
		zcd_serializer_variant_to_tuple (_tmp5_, &_tmp6_, &_tmp7_);
		_g_variant_unref0 (v0);
		v0 = _tmp6_;
		_g_variant_unref0 (v1);
		v1 = _tmp7_;
		_tmp8_ = v0;
		_tmp10_ = zcd_serializer_variant_to_variant_array (_tmp8_, &_tmp9_);
		toar = _tmp10_;
		toar_length1 = _tmp9_;
		_toar_size_ = toar_length1;
		_tmp11_ = v1;
		_tmp12_ = zcd_serializer_variant_to_string (_tmp11_);
		typename = _tmp12_;
		_tmp14_ = typename;
		if (_tmp14_ == NULL) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp15_;
			_tmp15_ = typename;
			_tmp13_ = g_strcmp0 (_tmp15_, "") == 0;
		}
		_tmp16_ = _tmp13_;
		if (_tmp16_) {
			GError* _tmp17_;
			_tmp17_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, "Typename not specified.");
			_inner_error_ = _tmp17_;
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (typename);
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				_g_free0 (vt);
				return;
			} else {
				_g_free0 (typename);
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				_g_free0 (vt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp18_ = typename;
		_tmp19_ = g_type_from_name (_tmp18_);
		type = _tmp19_;
		_tmp20_ = type;
		if (_tmp20_ == ((GType) 0)) {
			const gchar* _tmp21_;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			GError* _tmp25_;
			GError* _tmp26_;
			_tmp21_ = typename;
			_tmp22_ = string_to_string (_tmp21_);
			_tmp23_ = g_strconcat ("Typename '", _tmp22_, "' is unknown.", NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp24_);
			_inner_error_ = _tmp26_;
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (typename);
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				_g_free0 (vt);
				return;
			} else {
				_g_free0 (typename);
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				_g_free0 (vt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp27_ = type;
		_tmp28_ = g_type_is_a (_tmp27_, ZCD_TYPE_ISERIALIZABLE);
		if (!_tmp28_) {
			const gchar* _tmp29_;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			GError* _tmp33_;
			GError* _tmp34_;
			_tmp29_ = typename;
			_tmp30_ = string_to_string (_tmp29_);
			_tmp31_ = g_strconcat ("Typename '", _tmp30_, "' is not serializable.", NULL);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, _tmp32_);
			_tmp34_ = _tmp33_;
			_g_free0 (_tmp32_);
			_inner_error_ = _tmp34_;
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (typename);
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				_g_free0 (vt);
				return;
			} else {
				_g_free0 (typename);
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
				_g_variant_unref0 (v1);
				_g_variant_unref0 (v0);
				_g_free0 (vt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			gint i;
			i = 0;
			{
				gboolean _tmp35_;
				_tmp35_ = TRUE;
				while (TRUE) {
					gboolean _tmp36_;
					gint _tmp38_;
					GVariant** _tmp39_;
					gint _tmp39__length1;
					GType _tmp40_;
					GObject* _tmp41_ = NULL;
					GObject* _tmp42_;
					zcdISerializable* el;
					zcdISerializable* _tmp43_;
					GVariant** _tmp44_;
					gint _tmp44__length1;
					gint _tmp45_;
					GVariant* _tmp46_;
					GeeList* _tmp47_;
					zcdISerializable* _tmp48_;
					_tmp36_ = _tmp35_;
					if (!_tmp36_) {
						gint _tmp37_;
						_tmp37_ = i;
						i = _tmp37_ + 1;
					}
					_tmp35_ = FALSE;
					_tmp38_ = i;
					_tmp39_ = toar;
					_tmp39__length1 = toar_length1;
					if (!(_tmp38_ < _tmp39__length1)) {
						break;
					}
					_tmp40_ = type;
					_tmp41_ = g_object_new (_tmp40_, NULL);
					_tmp42_ = G_IS_INITIALLY_UNOWNED (_tmp41_) ? g_object_ref_sink (_tmp41_) : _tmp41_;
					el = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, ZCD_TYPE_ISERIALIZABLE, zcdISerializable);
					_tmp43_ = el;
					_tmp44_ = toar;
					_tmp44__length1 = toar_length1;
					_tmp45_ = i;
					_tmp46_ = _tmp44_[_tmp45_];
					zcd_iserializable_deserialize_from_variant (_tmp43_, _tmp46_, &_inner_error_);
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (el);
							_g_free0 (typename);
							toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
							_g_variant_unref0 (v1);
							_g_variant_unref0 (v0);
							_g_free0 (vt);
							return;
						} else {
							_g_object_unref0 (el);
							_g_free0 (typename);
							toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
							_g_variant_unref0 (v1);
							_g_variant_unref0 (v0);
							_g_free0 (vt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp47_ = self->backed;
					_tmp48_ = el;
					gee_collection_add ((GeeCollection*) _tmp47_, _tmp48_);
					_g_object_unref0 (el);
				}
			}
		}
		_g_free0 (typename);
		toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_variant_unref0 (v1);
		_g_variant_unref0 (v0);
	}
	_g_free0 (vt);
}


gint zcd_list_iserializable_get_size (zcdListISerializable* self) {
	gint result;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->backed;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void zcd_list_iserializable_class_init (zcdListISerializableClass * klass) {
	zcd_list_iserializable_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_list_iserializable_get_property;
	G_OBJECT_CLASS (klass)->finalize = zcd_list_iserializable_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_LIST_ISERIALIZABLE_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void zcd_list_iserializable_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
	zcd_list_iserializable_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_list_iserializable_real_serialize_to_variant;
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_list_iserializable_real_deserialize_from_variant;
}


static void zcd_list_iserializable_instance_init (zcdListISerializable * self) {
}


static void zcd_list_iserializable_finalize (GObject* obj) {
	zcdListISerializable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializable);
	_g_object_unref0 (self->backed);
	G_OBJECT_CLASS (zcd_list_iserializable_parent_class)->finalize (obj);
}


/** Serializable class for List<ISerializable>
      *
      * This class is used for passing or returning a list of objects, all of the
      *  same type and that implement ISerializable.
      * With this class, the objects contained in the list are serialized when we
      *  call "serialize()" on the list, and are deserialized when we call deserialize()
      *  for the list.
      * A different approach has to be used if we need to
      *   § serialize a list of serializable objects, obtaining a
      *     list of uchar[]
      *   § put the list of uchar[] in a serializable container
      *   § serialize the container
      *   § deserialize the container WITHOUT deserializing the objects
      * This situation is needed for remotable methods in optional peer to peer
      *  services; because we need to pass the arguments to hops that might not
      *  implement the service and might not have knowledge of the classes involved.
      * For this see an example of SerializedList in the serializer_tester_1 module.
      * Such a class is RemoteCall, in module messages.
      */
GType zcd_list_iserializable_get_type (void) {
	static volatile gsize zcd_list_iserializable_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_list_iserializable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdListISerializableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_list_iserializable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdListISerializable), 0, (GInstanceInitFunc) zcd_list_iserializable_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_list_iserializable_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_list_iserializable_type_id;
		zcd_list_iserializable_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdListISerializable", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_list_iserializable_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_list_iserializable_type_id__volatile, zcd_list_iserializable_type_id);
	}
	return zcd_list_iserializable_type_id__volatile;
}


static void _vala_zcd_list_iserializable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdListISerializable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializable);
	switch (property_id) {
		case ZCD_LIST_ISERIALIZABLE_SIZE:
		g_value_set_int (value, zcd_list_iserializable_get_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void zcd_serializer_init (void) {
	guint16 _tmp0_ = 0U;
	_tmp0_ = ntohs ((guint16) 1);
	zcd_endianness_network = ((gint) _tmp0_) == 1;
	g_type_class_peek (ZCD_TYPE_REMOTE_CALL);
	g_type_class_peek (ZCD_TYPE_REMOTABLE_EXCEPTION);
	g_type_class_peek (ZCD_TYPE_TCP_REQUEST);
	g_type_class_peek (ZCD_TYPE_UDP_MESSAGE);
	g_type_class_peek (ZCD_TYPE_UDP_PAYLOAD);
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_NONE);
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_INT);
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_BOOL);
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_STRING);
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_BUFFER);
	g_type_class_peek (ZCD_TYPE_LIST_STRING);
	g_type_class_peek (ZCD_TYPE_LIST_ISERIALIZABLE);
}


static GVariant* _variant_new1 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


GVariant* zcd_serializer_int_to_variant (gint i) {
	GVariant* result = NULL;
	gint _tmp0_;
	GVariant* _tmp1_;
	_tmp0_ = i;
	_tmp1_ = _variant_new1 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint _variant_get2 (GVariant* value) {
	return g_variant_get_int32 (value);
}


gint zcd_serializer_variant_to_int (GVariant* v) {
	gint result = 0;
	GVariant* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (v != NULL, 0);
	_tmp0_ = v;
	_tmp1_ = _variant_get2 (_tmp0_);
	result = _tmp1_;
	return result;
}


static GVariant* _variant_new3 (gint64 value) {
	return g_variant_ref_sink (g_variant_new_int64 (value));
}


GVariant* zcd_serializer_int64_to_variant (gint64 i) {
	GVariant* result = NULL;
	gint64 _tmp0_;
	GVariant* _tmp1_;
	_tmp0_ = i;
	_tmp1_ = _variant_new3 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint64 _variant_get4 (GVariant* value) {
	return g_variant_get_int64 (value);
}


gint64 zcd_serializer_variant_to_int64 (GVariant* v) {
	gint64 result = 0LL;
	GVariant* _tmp0_;
	gint64 _tmp1_;
	g_return_val_if_fail (v != NULL, 0LL);
	_tmp0_ = v;
	_tmp1_ = _variant_get4 (_tmp0_);
	result = _tmp1_;
	return result;
}


static GVariant* _variant_new5 (guchar value) {
	return g_variant_ref_sink (g_variant_new_byte (value));
}


GVariant* zcd_serializer_uchar_to_variant (guchar y) {
	GVariant* result = NULL;
	guchar _tmp0_;
	GVariant* _tmp1_;
	_tmp0_ = y;
	_tmp1_ = _variant_new5 (_tmp0_);
	result = _tmp1_;
	return result;
}


static guchar _variant_get6 (GVariant* value) {
	return g_variant_get_byte (value);
}


guchar zcd_serializer_variant_to_uchar (GVariant* v) {
	guchar result = '\0';
	GVariant* _tmp0_;
	guchar _tmp1_;
	g_return_val_if_fail (v != NULL, '\0');
	_tmp0_ = v;
	_tmp1_ = _variant_get6 (_tmp0_);
	result = _tmp1_;
	return result;
}


static GVariant* _variant_new7 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


GVariant* zcd_serializer_string_to_variant (const gchar* s) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp0_ = s;
	_tmp1_ = _variant_new7 (_tmp0_);
	result = _tmp1_;
	return result;
}


gchar* zcd_serializer_variant_to_string (GVariant* v) {
	gchar* result = NULL;
	gchar* t2 = NULL;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GVariant* _tmp2_;
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_get_type_string (_tmp0_);
	_vala_assert (g_strcmp0 (_tmp1_, "s") == 0, "v.get_type_string() == \"s\"");
	_tmp2_ = v;
	g_variant_get (_tmp2_, "s", &t2, NULL);
	result = t2;
	return result;
}


static GVariant* _variant_new8 (gint* value, gint value_length1) {
	gint* _tmp1_;
	GVariantBuilder _tmp2_;
	int _tmp3_;
	_tmp1_ = value;
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("ai"));
	for (_tmp3_ = 0; _tmp3_ < value_length1; _tmp3_++) {
		g_variant_builder_add_value (&_tmp2_, g_variant_new_int32 (*_tmp1_));
		_tmp1_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp2_));
}


GVariant* zcd_serializer_int_array_to_variant (gint* ai, int ai_length1) {
	GVariant* result = NULL;
	gint* _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp4_;
	_tmp0_ = ai;
	_tmp0__length1 = ai_length1;
	_tmp4_ = _variant_new8 (_tmp0_, _tmp0__length1);
	result = _tmp4_;
	return result;
}


static gint _variant_get9 (GVariant* value) {
	return g_variant_get_int32 (value);
}


static void _vala_array_add2 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


gint* zcd_serializer_variant_to_int_array (GVariant* v, int* result_length1) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint* ret;
	gint ret_length1;
	gint _ret_size_;
	GVariant* _tmp1_;
	GVariantIter* _tmp2_;
	GVariantIter* iter;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* v0;
	gint* _tmp12_;
	gint _tmp12__length1;
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = g_new0 (gint, 0);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	iter = _tmp2_;
	_tmp3_ = iter;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	v0 = _tmp4_;
	while (TRUE) {
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		gint _tmp7_;
		gint i;
		gint* _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		GVariantIter* _tmp10_;
		GVariant* _tmp11_ = NULL;
		_tmp5_ = v0;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = v0;
		_tmp7_ = _variant_get9 (_tmp6_);
		i = _tmp7_;
		_tmp8_ = ret;
		_tmp8__length1 = ret_length1;
		_tmp9_ = i;
		_vala_array_add2 (&ret, &ret_length1, &_ret_size_, _tmp9_);
		_tmp10_ = iter;
		_tmp11_ = g_variant_iter_next_value (_tmp10_);
		_g_variant_unref0 (v0);
		v0 = _tmp11_;
	}
	_tmp12_ = ret;
	_tmp12__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	_g_variant_unref0 (v0);
	_g_variant_iter_free0 (iter);
	return result;
}


static GVariant* _variant_new10 (guchar* value, gint value_length1) {
	guchar* _tmp1_;
	GVariantBuilder _tmp2_;
	int _tmp3_;
	_tmp1_ = value;
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("ay"));
	for (_tmp3_ = 0; _tmp3_ < value_length1; _tmp3_++) {
		g_variant_builder_add_value (&_tmp2_, g_variant_new_byte (*_tmp1_));
		_tmp1_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp2_));
}


GVariant* zcd_serializer_uchar_array_to_variant (guchar* auc, int auc_length1) {
	GVariant* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp4_;
	_tmp0_ = auc;
	_tmp0__length1 = auc_length1;
	_tmp4_ = _variant_new10 (_tmp0_, _tmp0__length1);
	result = _tmp4_;
	return result;
}


static guchar _variant_get11 (GVariant* value) {
	return g_variant_get_byte (value);
}


static void _vala_array_add3 (guchar** array, int* length, int* size, guchar value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guchar, *array, *size);
	}
	(*array)[(*length)++] = value;
}


guchar* zcd_serializer_variant_to_uchar_array (GVariant* v, int* result_length1) {
	guchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	GVariant* _tmp1_;
	GVariantIter* _tmp2_;
	GVariantIter* iter;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* v0;
	guchar* _tmp12_;
	gint _tmp12__length1;
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = g_new0 (guchar, 0);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	iter = _tmp2_;
	_tmp3_ = iter;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	v0 = _tmp4_;
	while (TRUE) {
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		guchar _tmp7_;
		guchar i;
		guchar* _tmp8_;
		gint _tmp8__length1;
		guchar _tmp9_;
		GVariantIter* _tmp10_;
		GVariant* _tmp11_ = NULL;
		_tmp5_ = v0;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = v0;
		_tmp7_ = _variant_get11 (_tmp6_);
		i = _tmp7_;
		_tmp8_ = ret;
		_tmp8__length1 = ret_length1;
		_tmp9_ = i;
		_vala_array_add3 (&ret, &ret_length1, &_ret_size_, _tmp9_);
		_tmp10_ = iter;
		_tmp11_ = g_variant_iter_next_value (_tmp10_);
		_g_variant_unref0 (v0);
		v0 = _tmp11_;
	}
	_tmp12_ = ret;
	_tmp12__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	_g_variant_unref0 (v0);
	_g_variant_iter_free0 (iter);
	return result;
}


static GVariant* _variant_new12 (gchar** value, gint value_length1) {
	gchar** _tmp1_;
	GVariantBuilder _tmp2_;
	int _tmp3_;
	_tmp1_ = value;
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("as"));
	for (_tmp3_ = 0; _tmp3_ < value_length1; _tmp3_++) {
		g_variant_builder_add_value (&_tmp2_, g_variant_new_string (*_tmp1_));
		_tmp1_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp2_));
}


GVariant* zcd_serializer_string_array_to_variant (gchar** ars, int ars_length1) {
	GVariant* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp4_;
	_tmp0_ = ars;
	_tmp0__length1 = ars_length1;
	_tmp4_ = _variant_new12 (_tmp0_, _tmp0__length1);
	result = _tmp4_;
	return result;
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** zcd_serializer_variant_to_string_array (GVariant* v, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** ret;
	gint ret_length1;
	gint _ret_size_;
	GVariant* _tmp1_;
	GVariantIter* _tmp2_;
	GVariantIter* iter;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* v0;
	gchar** _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	iter = _tmp2_;
	_tmp3_ = iter;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	v0 = _tmp4_;
	while (TRUE) {
		GVariant* _tmp5_;
		gchar* s = NULL;
		GVariant* _tmp6_;
		const gchar* _tmp7_ = NULL;
		GVariant* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		GVariantIter* _tmp12_;
		GVariant* _tmp13_ = NULL;
		_tmp5_ = v0;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = v0;
		_tmp7_ = g_variant_get_type_string (_tmp6_);
		_vala_assert (g_strcmp0 (_tmp7_, "s") == 0, "v0.get_type_string() == \"s\"");
		_tmp8_ = v0;
		g_variant_get (_tmp8_, "s", &s, NULL);
		_tmp9_ = ret;
		_tmp9__length1 = ret_length1;
		_tmp10_ = s;
		_tmp11_ = g_strdup (_tmp10_);
		_vala_array_add4 (&ret, &ret_length1, &_ret_size_, _tmp11_);
		_tmp12_ = iter;
		_tmp13_ = g_variant_iter_next_value (_tmp12_);
		_g_variant_unref0 (v0);
		v0 = _tmp13_;
		_g_free0 (s);
	}
	_tmp14_ = ret;
	_tmp14__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	_g_variant_unref0 (v0);
	_g_variant_iter_free0 (iter);
	return result;
}


static GVariant* _variant_new13 (GVariant** value, gint value_length1) {
	GVariant** _tmp1_;
	GVariantBuilder _tmp2_;
	int _tmp3_;
	_tmp1_ = value;
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("av"));
	for (_tmp3_ = 0; _tmp3_ < value_length1; _tmp3_++) {
		g_variant_builder_add_value (&_tmp2_, g_variant_new_variant (*_tmp1_));
		_tmp1_++;
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp2_));
}


GVariant* zcd_serializer_variant_array_to_variant (GVariant** av, int av_length1) {
	GVariant* result = NULL;
	GVariant** _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp4_;
	_tmp0_ = av;
	_tmp0__length1 = av_length1;
	_tmp4_ = _variant_new13 (_tmp0_, _tmp0__length1);
	result = _tmp4_;
	return result;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void _vala_array_add5 (GVariant*** array, int* length, int* size, GVariant* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


GVariant** zcd_serializer_variant_to_variant_array (GVariant* v, int* result_length1) {
	GVariant** result = NULL;
	GVariant** _tmp0_ = NULL;
	GVariant** ret;
	gint ret_length1;
	gint _ret_size_;
	GVariant* _tmp1_;
	GVariantIter* _tmp2_;
	GVariantIter* iter;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* v0;
	GVariant** _tmp13_;
	gint _tmp13__length1;
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = g_new0 (GVariant*, 0 + 1);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = v;
	_tmp2_ = g_variant_iter_new (_tmp1_);
	iter = _tmp2_;
	_tmp3_ = iter;
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
	v0 = _tmp4_;
	while (TRUE) {
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_ = NULL;
		GVariant* v1;
		GVariant** _tmp8_;
		gint _tmp8__length1;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		GVariantIter* _tmp11_;
		GVariant* _tmp12_ = NULL;
		_tmp5_ = v0;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = v0;
		_tmp7_ = g_variant_get_variant (_tmp6_);
		v1 = _tmp7_;
		_tmp8_ = ret;
		_tmp8__length1 = ret_length1;
		_tmp9_ = v1;
		_tmp10_ = _g_variant_ref0 (_tmp9_);
		_vala_array_add5 (&ret, &ret_length1, &_ret_size_, _tmp10_);
		_tmp11_ = iter;
		_tmp12_ = g_variant_iter_next_value (_tmp11_);
		_g_variant_unref0 (v0);
		v0 = _tmp12_;
		_g_variant_unref0 (v1);
	}
	_tmp13_ = ret;
	_tmp13__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	_g_variant_unref0 (v0);
	_g_variant_iter_free0 (iter);
	return result;
}


GVariant* zcd_serializer_tuple_to_variant (GVariant* v0, GVariant* v1) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_val_if_fail (v0 != NULL, NULL);
	g_return_val_if_fail (v1 != NULL, NULL);
	_tmp0_ = v0;
	_tmp1_ = v1;
	_tmp2_ = g_variant_new ("(vv)", _tmp0_, _tmp1_, NULL);
	g_variant_ref_sink (_tmp2_);
	result = _tmp2_;
	return result;
}


void zcd_serializer_variant_to_tuple (GVariant* v, GVariant** v0, GVariant** v1) {
	GVariant* _vala_v0 = NULL;
	GVariant* _vala_v1 = NULL;
	GVariant* _tmp0_;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	g_variant_get (_tmp0_, "(vv)", &_vala_v0, &_vala_v1, NULL);
	if (v0) {
		*v0 = _vala_v0;
	} else {
		_g_variant_unref0 (_vala_v0);
	}
	if (v1) {
		*v1 = _vala_v1;
	} else {
		_g_variant_unref0 (_vala_v1);
	}
}


GVariant* zcd_serializer_tuple_to_variant_3 (GVariant* v0, GVariant* v1, GVariant* v2) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	g_return_val_if_fail (v0 != NULL, NULL);
	g_return_val_if_fail (v1 != NULL, NULL);
	g_return_val_if_fail (v2 != NULL, NULL);
	_tmp0_ = v0;
	_tmp1_ = v1;
	_tmp2_ = v2;
	_tmp3_ = g_variant_new ("(vvv)", _tmp0_, _tmp1_, _tmp2_, NULL);
	g_variant_ref_sink (_tmp3_);
	result = _tmp3_;
	return result;
}


void zcd_serializer_variant_to_tuple_3 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2) {
	GVariant* _vala_v0 = NULL;
	GVariant* _vala_v1 = NULL;
	GVariant* _vala_v2 = NULL;
	GVariant* _tmp0_;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	g_variant_get (_tmp0_, "(vvv)", &_vala_v0, &_vala_v1, &_vala_v2, NULL);
	if (v0) {
		*v0 = _vala_v0;
	} else {
		_g_variant_unref0 (_vala_v0);
	}
	if (v1) {
		*v1 = _vala_v1;
	} else {
		_g_variant_unref0 (_vala_v1);
	}
	if (v2) {
		*v2 = _vala_v2;
	} else {
		_g_variant_unref0 (_vala_v2);
	}
}


GVariant* zcd_serializer_tuple_to_variant_4 (GVariant* v0, GVariant* v1, GVariant* v2, GVariant* v3) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_val_if_fail (v0 != NULL, NULL);
	g_return_val_if_fail (v1 != NULL, NULL);
	g_return_val_if_fail (v2 != NULL, NULL);
	g_return_val_if_fail (v3 != NULL, NULL);
	_tmp0_ = v0;
	_tmp1_ = v1;
	_tmp2_ = v2;
	_tmp3_ = v3;
	_tmp4_ = g_variant_new ("(vvvv)", _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL);
	g_variant_ref_sink (_tmp4_);
	result = _tmp4_;
	return result;
}


void zcd_serializer_variant_to_tuple_4 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2, GVariant** v3) {
	GVariant* _vala_v0 = NULL;
	GVariant* _vala_v1 = NULL;
	GVariant* _vala_v2 = NULL;
	GVariant* _vala_v3 = NULL;
	GVariant* _tmp0_;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	g_variant_get (_tmp0_, "(vvvv)", &_vala_v0, &_vala_v1, &_vala_v2, &_vala_v3, NULL);
	if (v0) {
		*v0 = _vala_v0;
	} else {
		_g_variant_unref0 (_vala_v0);
	}
	if (v1) {
		*v1 = _vala_v1;
	} else {
		_g_variant_unref0 (_vala_v1);
	}
	if (v2) {
		*v2 = _vala_v2;
	} else {
		_g_variant_unref0 (_vala_v2);
	}
	if (v3) {
		*v3 = _vala_v3;
	} else {
		_g_variant_unref0 (_vala_v3);
	}
}


GVariant* zcd_serializer_tuple_to_variant_5 (GVariant* v0, GVariant* v1, GVariant* v2, GVariant* v3, GVariant* v4) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	g_return_val_if_fail (v0 != NULL, NULL);
	g_return_val_if_fail (v1 != NULL, NULL);
	g_return_val_if_fail (v2 != NULL, NULL);
	g_return_val_if_fail (v3 != NULL, NULL);
	g_return_val_if_fail (v4 != NULL, NULL);
	_tmp0_ = v0;
	_tmp1_ = v1;
	_tmp2_ = v2;
	_tmp3_ = v3;
	_tmp4_ = v4;
	_tmp5_ = g_variant_new ("(vvvvv)", _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, NULL);
	g_variant_ref_sink (_tmp5_);
	result = _tmp5_;
	return result;
}


void zcd_serializer_variant_to_tuple_5 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2, GVariant** v3, GVariant** v4) {
	GVariant* _vala_v0 = NULL;
	GVariant* _vala_v1 = NULL;
	GVariant* _vala_v2 = NULL;
	GVariant* _vala_v3 = NULL;
	GVariant* _vala_v4 = NULL;
	GVariant* _tmp0_;
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	g_variant_get (_tmp0_, "(vvvvv)", &_vala_v0, &_vala_v1, &_vala_v2, &_vala_v3, &_vala_v4, NULL);
	if (v0) {
		*v0 = _vala_v0;
	} else {
		_g_variant_unref0 (_vala_v0);
	}
	if (v1) {
		*v1 = _vala_v1;
	} else {
		_g_variant_unref0 (_vala_v1);
	}
	if (v2) {
		*v2 = _vala_v2;
	} else {
		_g_variant_unref0 (_vala_v2);
	}
	if (v3) {
		*v3 = _vala_v3;
	} else {
		_g_variant_unref0 (_vala_v3);
	}
	if (v4) {
		*v4 = _vala_v4;
	} else {
		_g_variant_unref0 (_vala_v4);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



