/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Posix;

void name_to_ip(string hostname)
{
        AddrInfo hints = {};
        hints.ai_family = AF_UNSPEC;
        hints.ai_socktype = SOCK_STREAM;
        hints.ai_protocol = 0;
        AddrInfo *res;
        int r = getaddrinfo(hostname, null, hints, out res);
        if (r == 0)
        {
            AddrInfo *p = res;
            while (p != null)
            {
                if (p->ai_family == AF_INET)
                {
                    SockAddrIn *sa_in = (SockAddrIn *)p->ai_addr;
                    uint32 ipv4addr = sa_in->sin_addr.s_addr;
                    uint8 dest[20];
                    string ipstr = inet_ntop(AF_INET, &ipv4addr, dest);
                    print(@" $(ipstr)\n");
                }
                else print(" IPv6?\n");
                p = p->ai_next;
            }
            freeaddrinfo(res);
        }
        else if (r == EAI_NONAME || r == -5 /*EAI_NODATA is not defined in netdb.h, why?*/)
        {
            print(@"Unknown host $(hostname)\n");
        }
        else
        {
            print(@"Unexpected error: $(r)\n");
        }
}

void ip_to_name(string addr)
{
        SockAddrIn sain = {};
        SockAddrIn *sain_p = &sain;
        sain.sin_family = AF_INET;
        sain.sin_port = 0;
        Posix.inet_pton(Posix.AF_INET, addr, &sain.sin_addr);
        char node[500];
        SockAddr *sa_p = (SockAddr*)sain_p;
        int r = getnameinfo(*sa_p, (socklen_t)sizeof(SockAddrIn), node, null, NI_NAMEREQD);
        if (r == 0)
        {
            string s = "";
            foreach (char c in node)
            {
                if (c == '\0') break;
                s += @"$c";
            }
            print(@" $(s)\n");
        }
        else if (r == EAI_NONAME)
        {
            print(@"Unknown host $(addr)\n");
        }
        else if (r == EAI_AGAIN)
        {
            print(@"Error: try again later.\n");
        }
        else
        {
            print(@"Unexpected error: $(r)\n");
        }
}

int main(string[] args)
{
    if (args.length == 3 && args[1] == "name")
    {
        name_to_ip(args[2]);
    }
    else if (args.length == 3 && args[1] == "addr")
    {
        ip_to_name(args[2]);
    }
    else
    {
        print(@"usage:  $(args[0]) name <hostname>   ||   $(args[0]) addr <ip>\n");
        return 1;
    }
    return 0;
}
