/* libnss_andna.c generated by valac 0.20.1, the Vala compiler
 * generated from libnss_andna.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include "sysconf.h"
#include <nss.h>
#include <errno.h>
#include <netdb.h>
#include <gee.h>
#include "ntkresolv.h"
#include <sys/socket.h>
#include <netinet/in.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	NOT_ANDNA_ERROR_GENERIC
} NotAndnaError;
#define NOT_ANDNA_ERROR not_andna_error_quark ()
typedef enum  {
	NOT_FOUND_ERROR_GENERIC
} NotFoundError;
#define NOT_FOUND_ERROR not_found_error_quark ()
typedef enum  {
	ONLY_ALIASES_ERROR_GENERIC
} OnlyAliasesError;
#define ONLY_ALIASES_ERROR only_aliases_error_quark ()
typedef enum  {
	BUFFER_ERROR_GENERIC
} BufferError;
#define BUFFER_ERROR buffer_error_quark ()

extern gchar* andnaserver;
gchar* andnaserver = NULL;
extern gboolean initialized;
gboolean initialized = FALSE;

#define LOG_LEAD "nss_andna "
void log_info (const gchar* msg);
void log_notice (const gchar* msg);
void log_warn (const gchar* msg);
void log_error (const gchar* msg);
void log_critical (const gchar* msg);
void init (void);
enum nss_status return_unavail_eperm (gint* h_errnop);
enum nss_status return_unavail_esrch (gint* h_errnop);
enum nss_status return_notfound_eperm (gint* h_errnop);
enum nss_status return_unavail_enoent (gint* h_errnop);
enum nss_status return_notfound_enoent (gint* h_errnop);
enum nss_status return_tryagain_erange (gint* h_errnop);
enum nss_status return_tryagain_eagain (gint* h_errnop);
enum nss_status return_success (void);
GQuark not_andna_error_quark (void);
GQuark not_found_error_quark (void);
GQuark only_aliases_error_quark (void);
GQuark buffer_error_quark (void);
void set_success (struct hostent* ret, gchar* buf, const gchar* name, GeeList* ips);
enum nss_status _nss_andna_gethostbyname2_r (const gchar* name, gint af, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop);
enum nss_status _nss_andna_gethostbyname_r (const gchar* name, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop);
GeeArrayList* get_ips (const gchar* origname, GError** error);
gboolean prepare_buffer (GeeList* ips, const gchar* name, guint8* buffer, guint buflen, gchar** h_name, gchar*** h_aliases, gchar*** h_addr_list);
enum nss_status _nss_andna_gethostbyaddr_r (void* addr, socklen_t len, gint type, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop);
void set_host_ent_from_addr (struct in_addr* addr, struct hostent* ret, gchar* buffer, gsize buflen, const gchar* service, NtkresolvNtkAddrInfo* hints, GError** error);
gboolean prepare_buffer_from_addr (GeeList* names, NtkresolvNtkInetAddr* ip, guint8* buffer, guint buflen, gchar** h_name, gchar*** h_aliases, gchar*** h_addr_list);


void log_info (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "INFO ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_INFO, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_notice (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "INFO+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_NOTICE, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_warn (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "INFO++ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_WARNING, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_error (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "ERROR ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_ERR, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_critical (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat (LOG_LEAD "ERROR+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_CRIT, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void init (void) {
	gboolean _tmp0_;
	gchar* _tmp1_;
	gchar* fname;
	GKeyFile* _tmp2_;
	GKeyFile* conf;
	GError * _inner_error_ = NULL;
	_tmp0_ = initialized;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_strdup (SYSCONF_DIR "/ntkresolv/ntkresolv.ini");
	fname = _tmp1_;
	_tmp2_ = g_key_file_new ();
	conf = _tmp2_;
	{
		gboolean file_found;
		gboolean _tmp11_;
		file_found = FALSE;
		{
			GKeyFile* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = conf;
			_tmp4_ = fname;
			g_key_file_load_from_file (_tmp3_, _tmp4_, G_KEY_FILE_NONE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				goto __finally1;
			}
			file_found = TRUE;
		}
		goto __finally1;
		__catch1_g_key_file_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = e;
			if (g_error_matches (_tmp5_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_NOT_FOUND)) {
			} else {
				GError* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp6_ = e;
				_tmp7_ = _tmp6_->message;
				_tmp8_ = string_to_string (_tmp7_);
				_tmp9_ = g_strconcat ("KeyFileError ", _tmp8_, NULL);
				_tmp10_ = _tmp9_;
				log_warn (_tmp10_);
				_g_free0 (_tmp10_);
			}
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp11_ = file_found;
		if (_tmp11_) {
			gboolean _tmp12_ = FALSE;
			GKeyFile* _tmp13_;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp18_;
			_tmp13_ = conf;
			_tmp14_ = g_key_file_has_group (_tmp13_, "NTKRESOLV");
			if (_tmp14_) {
				GKeyFile* _tmp15_;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_;
				_tmp15_ = conf;
				_tmp16_ = g_key_file_has_key (_tmp15_, "NTKRESOLV", "ANDNASERVER", &_inner_error_);
				_tmp17_ = _tmp16_;
				if (_inner_error_ != NULL) {
					goto __catch0_g_error;
				}
				_tmp12_ = _tmp17_;
			} else {
				_tmp12_ = FALSE;
			}
			_tmp18_ = _tmp12_;
			if (_tmp18_) {
				GKeyFile* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				_tmp19_ = conf;
				_tmp20_ = g_key_file_get_string (_tmp19_, "NTKRESOLV", "ANDNASERVER", &_inner_error_);
				_tmp21_ = _tmp20_;
				if (_inner_error_ != NULL) {
					goto __catch0_g_error;
				}
				_g_free0 (andnaserver);
				andnaserver = _tmp21_;
			} else {
				log_warn ("Missing server in ini file.");
			}
		} else {
			log_warn ("Didn't read ini file.");
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = g_strconcat ("Error ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		log_warn (_tmp26_);
		_g_free0 (_tmp26_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (conf);
		_g_free0 (fname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	initialized = TRUE;
	_g_key_file_free0 (conf);
	_g_free0 (fname);
}


enum nss_status return_unavail_eperm (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = EPERM;
	_tmp1_ = *_tmp0_;
	result = NSS_STATUS_UNAVAIL;
	return result;
}


enum nss_status return_unavail_esrch (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = ESRCH;
	_tmp1_ = *_tmp0_;
	result = NSS_STATUS_UNAVAIL;
	return result;
}


enum nss_status return_notfound_eperm (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = EPERM;
	_tmp1_ = *_tmp0_;
	result = NSS_STATUS_NOTFOUND;
	return result;
}


enum nss_status return_unavail_enoent (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = ENOENT;
	_tmp1_ = *_tmp0_;
	result = NSS_STATUS_UNAVAIL;
	return result;
}


enum nss_status return_notfound_enoent (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = ENOENT;
	_tmp1_ = *_tmp0_;
	result = NSS_STATUS_NOTFOUND;
	return result;
}


enum nss_status return_tryagain_erange (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = ERANGE;
	_tmp1_ = *_tmp0_;
	result = NSS_STATUS_TRYAGAIN;
	return result;
}


enum nss_status return_tryagain_eagain (gint* h_errnop) {
	enum nss_status result = 0;
	gint* _tmp0_;
	gint _tmp1_;
	_tmp0_ = h_errnop;
	*_tmp0_ = EAGAIN;
	_tmp1_ = *_tmp0_;
	result = NSS_STATUS_TRYAGAIN;
	return result;
}


enum nss_status return_success (void) {
	enum nss_status result = 0;
	result = NSS_STATUS_SUCCESS;
	return result;
}


GQuark not_andna_error_quark (void) {
	return g_quark_from_static_string ("not_andna_error-quark");
}


GQuark not_found_error_quark (void) {
	return g_quark_from_static_string ("not_found_error-quark");
}


GQuark only_aliases_error_quark (void) {
	return g_quark_from_static_string ("only_aliases_error-quark");
}


GQuark buffer_error_quark (void) {
	return g_quark_from_static_string ("buffer_error-quark");
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void set_success (struct hostent* ret, gchar* buf, const gchar* name, GeeList* ips) {
	struct hostent* _tmp0_;
	struct hostent* _tmp1_;
	gchar* h_name = NULL;
	gchar** h_aliases = NULL;
	gchar** h_addr_list;
	gchar* _tmp2_;
	guint8* buffer;
	gchar** x = NULL;
	gchar* p = NULL;
	guint pos;
	guint* _tmp3_ = NULL;
	guint* pos_ip;
	gint pos_ip_length1;
	gint _pos_ip_size_;
	guint8* _tmp4_;
	guint _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp14_;
	guint _tmp15_;
	guint8 _tmp16_;
	guint8* _tmp17_;
	guint _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	guint _tmp23_;
	guint _tmp24_;
	guint _tmp25_;
	gint ip_count;
	guint8* _tmp63_;
	guint _tmp64_;
	gchar* _tmp65_;
	gchar** _tmp66_;
	gchar* _tmp67_;
	guint _tmp68_;
	struct hostent* _tmp69_;
	gchar* _tmp70_;
	struct hostent* _tmp71_;
	gchar** _tmp72_;
	struct hostent* _tmp73_;
	gchar** _tmp74_;
	g_return_if_fail (name != NULL);
	g_return_if_fail (ips != NULL);
	_tmp0_ = ret;
	(*_tmp0_).h_addrtype = AF_INET;
	_tmp1_ = ret;
	(*_tmp1_).h_length = 4;
	h_addr_list = NULL;
	_tmp2_ = buf;
	buffer = (guint8*) _tmp2_;
	pos = (guint) 0;
	_tmp3_ = g_new0 (guint, 1);
	pos_ip = _tmp3_;
	pos_ip_length1 = 1;
	_pos_ip_size_ = pos_ip_length1;
	_tmp4_ = buffer;
	_tmp5_ = pos;
	p = ((gchar*) _tmp4_) + _tmp5_;
	_tmp6_ = p;
	h_name = _tmp6_;
	_tmp7_ = name;
	_tmp8_ = string_get_data (_tmp7_, &_tmp8__length1);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	{
		guint8* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp9_;
		o_collection_length1 = _tmp9__length1;
		for (o_it = 0; o_it < _tmp9__length1; o_it = o_it + 1) {
			guint8 o = 0U;
			o = o_collection[o_it];
			{
				guint8* _tmp10_;
				guint _tmp11_;
				guint8 _tmp12_;
				guint8 _tmp13_;
				_tmp10_ = buffer;
				_tmp11_ = pos;
				pos = _tmp11_ + 1;
				_tmp12_ = o;
				_tmp10_[_tmp11_] = _tmp12_;
				_tmp13_ = _tmp10_[_tmp11_];
			}
		}
	}
	_tmp14_ = buffer;
	_tmp15_ = pos;
	pos = _tmp15_ + 1;
	_tmp14_[_tmp15_] = (guint8) '\0';
	_tmp16_ = _tmp14_[_tmp15_];
	_tmp17_ = buffer;
	_tmp18_ = pos;
	p = ((gchar*) _tmp17_) + _tmp18_;
	_tmp19_ = p;
	x = (gchar**) _tmp19_;
	_tmp20_ = x;
	*_tmp20_ = NULL;
	_tmp21_ = *_tmp20_;
	_tmp22_ = x;
	h_aliases = _tmp22_;
	_tmp23_ = pos;
	pos = _tmp23_ + ((guint) sizeof (gchar*));
	_tmp24_ = pos;
	_tmp25_ = pos;
	pos = _tmp24_ + (((guint) sizeof (void*)) - (_tmp25_ % ((guint) sizeof (void*))));
	ip_count = 0;
	{
		GeeList* _tmp26_;
		GeeList* _tmp27_;
		GeeList* _ip_list;
		GeeList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _ip_size;
		gint _ip_index;
		_tmp26_ = ips;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		_ip_list = _tmp27_;
		_tmp28_ = _ip_list;
		_tmp29_ = gee_collection_get_size ((GeeCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_ip_size = _tmp30_;
		_ip_index = -1;
		while (TRUE) {
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			GeeList* _tmp34_;
			gint _tmp35_;
			gpointer _tmp36_ = NULL;
			NtkresolvNtkInetAddr* ip;
			guint* _tmp37_;
			gint _tmp37__length1;
			gint _tmp38_;
			guint _tmp39_;
			guint _tmp40_;
			NtkresolvNtkInetAddr* _tmp41_;
			_tmp31_ = _ip_index;
			_ip_index = _tmp31_ + 1;
			_tmp32_ = _ip_index;
			_tmp33_ = _ip_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = _ip_list;
			_tmp35_ = _ip_index;
			_tmp36_ = gee_list_get (_tmp34_, _tmp35_);
			ip = (NtkresolvNtkInetAddr*) _tmp36_;
			_tmp37_ = pos_ip;
			_tmp37__length1 = pos_ip_length1;
			_tmp38_ = ip_count;
			ip_count = _tmp38_ + 1;
			_tmp39_ = pos;
			_tmp37_[_tmp38_] = _tmp39_;
			_tmp40_ = _tmp37_[_tmp38_];
			_tmp41_ = ip;
			{
				guint8* o_collection = NULL;
				gint o_collection_length1 = 0;
				gint _o_collection_size_ = 0;
				gint o_it = 0;
				o_collection = _tmp41_->addr;
				o_collection_length1 = 4;
				for (o_it = 0; o_it < 4; o_it = o_it + 1) {
					guint8 o = 0U;
					o = o_collection[o_it];
					{
						guint8* _tmp42_;
						guint _tmp43_;
						guint8 _tmp44_;
						guint8 _tmp45_;
						_tmp42_ = buffer;
						_tmp43_ = pos;
						pos = _tmp43_ + 1;
						_tmp44_ = o;
						_tmp42_[_tmp43_] = _tmp44_;
						_tmp45_ = _tmp42_[_tmp43_];
					}
				}
			}
			_g_object_unref0 (ip);
		}
		_g_object_unref0 (_ip_list);
	}
	{
		gint ip_num;
		ip_num = 0;
		{
			gboolean _tmp46_;
			_tmp46_ = TRUE;
			while (TRUE) {
				gboolean _tmp47_;
				gint _tmp49_;
				gint _tmp50_;
				guint8* _tmp51_;
				guint _tmp52_;
				gchar* _tmp53_;
				gchar** _tmp54_;
				guint8* _tmp55_;
				guint* _tmp56_;
				gint _tmp56__length1;
				gint _tmp57_;
				guint _tmp58_;
				gchar* _tmp59_;
				gint _tmp60_;
				guint _tmp62_;
				_tmp47_ = _tmp46_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = ip_num;
					ip_num = _tmp48_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp49_ = ip_num;
				_tmp50_ = ip_count;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = buffer;
				_tmp52_ = pos;
				p = ((gchar*) _tmp51_) + _tmp52_;
				_tmp53_ = p;
				x = (gchar**) _tmp53_;
				_tmp54_ = x;
				_tmp55_ = buffer;
				_tmp56_ = pos_ip;
				_tmp56__length1 = pos_ip_length1;
				_tmp57_ = ip_num;
				_tmp58_ = _tmp56_[_tmp57_];
				*_tmp54_ = ((gchar*) _tmp55_) + _tmp58_;
				_tmp59_ = *_tmp54_;
				_tmp60_ = ip_num;
				if (_tmp60_ == 0) {
					gchar** _tmp61_;
					_tmp61_ = x;
					h_addr_list = _tmp61_;
				}
				_tmp62_ = pos;
				pos = _tmp62_ + ((guint) sizeof (gchar*));
			}
		}
	}
	_tmp63_ = buffer;
	_tmp64_ = pos;
	p = ((gchar*) _tmp63_) + _tmp64_;
	_tmp65_ = p;
	x = (gchar**) _tmp65_;
	_tmp66_ = x;
	*_tmp66_ = NULL;
	_tmp67_ = *_tmp66_;
	_tmp68_ = pos;
	pos = _tmp68_ + ((guint) sizeof (gchar*));
	_tmp69_ = ret;
	_tmp70_ = h_name;
	(*_tmp69_).h_name = (const gchar*) _tmp70_;
	_tmp71_ = ret;
	_tmp72_ = h_aliases;
	(*_tmp71_).h_aliases = (gchar**) _tmp72_;
	_tmp73_ = ret;
	_tmp74_ = h_addr_list;
	(*_tmp73_).h_addr_list = (gchar**) _tmp74_;
	pos_ip = (g_free (pos_ip), NULL);
}


enum nss_status _nss_andna_gethostbyname2_r (const gchar* name, gint af, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop) {
	enum nss_status result = 0;
	gint _tmp0_;
	g_return_val_if_fail (name != NULL, 0);
	init ();
	_tmp0_ = af;
	if (_tmp0_ == AF_INET) {
		const gchar* _tmp1_;
		struct hostent* _tmp2_;
		gchar* _tmp3_;
		gsize _tmp4_;
		struct hostent** _tmp5_;
		gint* _tmp6_;
		enum nss_status _tmp7_ = 0;
		_tmp1_ = name;
		_tmp2_ = ret;
		_tmp3_ = buffer;
		_tmp4_ = buflen;
		_tmp5_ = _result_;
		_tmp6_ = h_errnop;
		_tmp7_ = _nss_andna_gethostbyname_r (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
		result = _tmp7_;
		return result;
	} else {
		gint _tmp8_;
		_tmp8_ = af;
		if (_tmp8_ == AF_INET6) {
			gint* _tmp9_;
			enum nss_status _tmp10_ = 0;
			_tmp9_ = h_errnop;
			_tmp10_ = return_unavail_esrch (_tmp9_);
			result = _tmp10_;
			return result;
		} else {
			gint* _tmp11_;
			enum nss_status _tmp12_ = 0;
			_tmp11_ = h_errnop;
			_tmp12_ = return_unavail_esrch (_tmp11_);
			result = _tmp12_;
			return result;
		}
	}
}


enum nss_status _nss_andna_gethostbyname_r (const gchar* name, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop) {
	enum nss_status result = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, 0);
	init ();
	{
		const gchar* _tmp0_;
		GeeArrayList* _tmp1_ = NULL;
		GeeArrayList* ips;
		guint ipsize;
		gsize _tmp2_;
		guint _tmp3_;
		GeeArrayList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		struct hostent* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		GeeArrayList* _tmp12_;
		enum nss_status _tmp13_ = 0;
		_tmp0_ = name;
		_tmp1_ = get_ips (_tmp0_, &_inner_error_);
		ips = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NOT_ANDNA_ERROR) {
				goto __catch2_not_andna_error;
			}
			if (_inner_error_->domain == NOT_FOUND_ERROR) {
				goto __catch2_not_found_error;
			}
			if (_inner_error_->domain == ONLY_ALIASES_ERROR) {
				goto __catch2_only_aliases_error;
			}
			if (_inner_error_->domain == BUFFER_ERROR) {
				goto __catch2_buffer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		ipsize = ((guint) sizeof (guint8)) * 4;
		_tmp2_ = buflen;
		_tmp3_ = ipsize;
		_tmp4_ = ips;
		_tmp5_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp2_ < ((gsize) (256 + ((_tmp3_ + ((guint) sizeof (gchar*))) * _tmp6_)))) {
			gint* _tmp7_;
			enum nss_status _tmp8_ = 0;
			_tmp7_ = h_errnop;
			_tmp8_ = return_tryagain_erange (_tmp7_);
			result = _tmp8_;
			_g_object_unref0 (ips);
			return result;
		}
		_tmp9_ = ret;
		_tmp10_ = buffer;
		_tmp11_ = name;
		_tmp12_ = ips;
		set_success (_tmp9_, _tmp10_, _tmp11_, (GeeList*) _tmp12_);
		_tmp13_ = return_success ();
		result = _tmp13_;
		_g_object_unref0 (ips);
		return result;
	}
	goto __finally2;
	__catch2_not_andna_error:
	{
		GError* e = NULL;
		gint* _tmp14_;
		enum nss_status _tmp15_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = h_errnop;
		_tmp15_ = return_unavail_eperm (_tmp14_);
		result = _tmp15_;
		_g_error_free0 (e);
		return result;
	}
	goto __finally2;
	__catch2_not_found_error:
	{
		GError* e = NULL;
		gint* _tmp16_;
		enum nss_status _tmp17_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = h_errnop;
		_tmp17_ = return_notfound_eperm (_tmp16_);
		result = _tmp17_;
		_g_error_free0 (e);
		return result;
	}
	goto __finally2;
	__catch2_only_aliases_error:
	{
		GError* e = NULL;
		gint* _tmp18_;
		enum nss_status _tmp19_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = h_errnop;
		_tmp19_ = return_notfound_eperm (_tmp18_);
		result = _tmp19_;
		_g_error_free0 (e);
		return result;
	}
	goto __finally2;
	__catch2_buffer_error:
	{
		GError* e = NULL;
		gint* _tmp20_;
		enum nss_status _tmp21_ = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = h_errnop;
		_tmp21_ = return_tryagain_erange (_tmp20_);
		result = _tmp21_;
		_g_error_free0 (e);
		return result;
	}
	__finally2:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return 0;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


GeeArrayList* get_ips (const gchar* origname, GError** error) {
	GeeArrayList* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* name;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_;
	const gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gboolean _tmp30_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gchar* _tmp36_ = NULL;
	GeeArrayList* _tmp37_;
	GeeArrayList* ips;
	GeeList* resp = NULL;
	GeeList* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GeeArrayList* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (origname != NULL, NULL);
	_tmp0_ = origname;
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ < 5) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (NOT_ANDNA_ERROR, NOT_ANDNA_ERROR_GENERIC, "not for ANDNA");
		_inner_error_ = _tmp5_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = name;
	_tmp7_ = name;
	_tmp8_ = strlen (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = string_substring (_tmp6_, (glong) (_tmp9_ - 1), (glong) (-1));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp11_, ".") == 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp13_ = name;
		_tmp14_ = name;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = string_substring (_tmp13_, (glong) 0, (glong) (_tmp16_ - 1));
		_g_free0 (name);
		name = _tmp17_;
	}
	_tmp18_ = name;
	_tmp19_ = strlen (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ < 5) {
		GError* _tmp21_;
		_tmp21_ = g_error_new_literal (NOT_ANDNA_ERROR, NOT_ANDNA_ERROR_GENERIC, "not for ANDNA");
		_inner_error_ = _tmp21_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = name;
	_tmp23_ = name;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = string_substring (_tmp22_, (glong) (_tmp25_ - 4), (glong) (-1));
	_tmp27_ = _tmp26_;
	_tmp28_ = g_utf8_strup (_tmp27_, (gssize) (-1));
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strcmp0 (_tmp29_, ".NTK") != 0;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	if (_tmp30_) {
		GError* _tmp31_;
		_tmp31_ = g_error_new_literal (NOT_ANDNA_ERROR, NOT_ANDNA_ERROR_GENERIC, "not for ANDNA");
		_inner_error_ = _tmp31_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (name);
			return NULL;
		} else {
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp32_ = name;
	_tmp33_ = name;
	_tmp34_ = strlen (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = string_substring (_tmp32_, (glong) 0, (glong) (_tmp35_ - 4));
	_g_free0 (name);
	name = _tmp36_;
	_tmp37_ = gee_array_list_new (NTKRESOLV_TYPE_NTK_INET_ADDR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ips = _tmp37_;
	{
		const gchar* _tmp38_;
		_tmp38_ = andnaserver;
		if (_tmp38_ == NULL) {
			const gchar* _tmp39_;
			GeeList* _tmp40_ = NULL;
			GeeList* _tmp41_;
			_tmp39_ = name;
			_tmp40_ = ntkresolv_resolv (_tmp39_, NULL, NULL, "127.0.0.1", &_inner_error_);
			_tmp41_ = _tmp40_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_g_object_unref0 (resp);
			resp = _tmp41_;
		} else {
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			GeeList* _tmp44_ = NULL;
			GeeList* _tmp45_;
			_tmp42_ = name;
			_tmp43_ = andnaserver;
			_tmp44_ = ntkresolv_resolv (_tmp42_, NULL, NULL, _tmp43_, &_inner_error_);
			_tmp45_ = _tmp44_;
			if (_inner_error_ != NULL) {
				goto __catch3_g_error;
			}
			_g_object_unref0 (resp);
			resp = _tmp45_;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp46_;
		const gchar* _tmp47_;
		GError* _tmp48_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp46_ = e;
		_tmp47_ = _tmp46_->message;
		_tmp48_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, _tmp47_);
		_inner_error_ = _tmp48_;
		_g_error_free0 (e);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			return NULL;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp49_ = resp;
	_tmp50_ = gee_collection_get_size ((GeeCollection*) _tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_ == 0) {
		const gchar* _tmp52_;
		const gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_;
		GError* _tmp56_;
		GError* _tmp57_;
		_tmp52_ = name;
		_tmp53_ = string_to_string (_tmp52_);
		_tmp54_ = g_strconcat (_tmp53_, " not found.", NULL);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, _tmp55_);
		_tmp57_ = _tmp56_;
		_g_free0 (_tmp55_);
		_inner_error_ = _tmp57_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			return NULL;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		GeeList* _tmp58_;
		GeeList* _tmp59_;
		GeeList* _ainfo_list;
		GeeList* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		gint _ainfo_size;
		gint _ainfo_index;
		_tmp58_ = resp;
		_tmp59_ = _g_object_ref0 (_tmp58_);
		_ainfo_list = _tmp59_;
		_tmp60_ = _ainfo_list;
		_tmp61_ = gee_collection_get_size ((GeeCollection*) _tmp60_);
		_tmp62_ = _tmp61_;
		_ainfo_size = _tmp62_;
		_ainfo_index = -1;
		while (TRUE) {
			gint _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			GeeList* _tmp66_;
			gint _tmp67_;
			gpointer _tmp68_ = NULL;
			NtkresolvNtkAddrInfo* ainfo;
			NtkresolvNtkAddrInfo* _tmp69_;
			NtkresolvNtkAddr* _tmp70_;
			NtkresolvNtkInetAddr* _tmp71_;
			NtkresolvNtkInetAddr* addr;
			NtkresolvNtkInetAddr* _tmp72_;
			_tmp63_ = _ainfo_index;
			_ainfo_index = _tmp63_ + 1;
			_tmp64_ = _ainfo_index;
			_tmp65_ = _ainfo_size;
			if (!(_tmp64_ < _tmp65_)) {
				break;
			}
			_tmp66_ = _ainfo_list;
			_tmp67_ = _ainfo_index;
			_tmp68_ = gee_list_get (_tmp66_, _tmp67_);
			ainfo = (NtkresolvNtkAddrInfo*) _tmp68_;
			_tmp69_ = ainfo;
			_tmp70_ = _tmp69_->address;
			_tmp71_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp70_, NTKRESOLV_TYPE_NTK_INET_ADDR) ? ((NtkresolvNtkInetAddr*) _tmp70_) : NULL);
			addr = _tmp71_;
			_tmp72_ = addr;
			if (_tmp72_ == NULL) {
			} else {
				GeeArrayList* _tmp73_;
				NtkresolvNtkInetAddr* _tmp74_;
				_tmp73_ = ips;
				_tmp74_ = addr;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp73_, _tmp74_);
			}
			_g_object_unref0 (addr);
			_g_object_unref0 (ainfo);
		}
		_g_object_unref0 (_ainfo_list);
	}
	_tmp75_ = ips;
	_tmp76_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp75_);
	_tmp77_ = _tmp76_;
	if (_tmp77_ == 0) {
		GError* _tmp78_;
		_tmp78_ = g_error_new_literal (ONLY_ALIASES_ERROR, ONLY_ALIASES_ERROR_GENERIC, "No IPv4 addresses.");
		_inner_error_ = _tmp78_;
		if ((((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == ONLY_ALIASES_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			return NULL;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ips);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = ips;
	_g_object_unref0 (resp);
	_g_free0 (name);
	return result;
}


gboolean prepare_buffer (GeeList* ips, const gchar* name, guint8* buffer, guint buflen, gchar** h_name, gchar*** h_aliases, gchar*** h_addr_list) {
	gchar* _vala_h_name = NULL;
	gchar** _vala_h_aliases = NULL;
	gchar** _vala_h_addr_list = NULL;
	gboolean result = FALSE;
	guint ipsize;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint minima;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	GeeList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	gchar** x = NULL;
	gchar* p = NULL;
	guint pos;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	guint* _tmp17_ = NULL;
	guint* pos_ip;
	gint pos_ip_length1;
	gint _pos_ip_size_;
	guint8* _tmp18_;
	guint _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	guint8* _tmp23_;
	gint _tmp23__length1;
	guint8* _tmp28_;
	guint _tmp29_;
	guint8 _tmp30_;
	guint8* _tmp31_;
	guint _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	guint _tmp37_;
	guint _tmp38_;
	guint _tmp39_;
	gint ip_count;
	guint8* _tmp77_;
	guint _tmp78_;
	gchar* _tmp79_;
	gchar** _tmp80_;
	gchar* _tmp81_;
	guint _tmp82_;
	g_return_val_if_fail (ips != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	ipsize = ((guint) sizeof (guint8)) * 4;
	_tmp0_ = name;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	minima = (guint) _tmp2_;
	_tmp3_ = minima;
	minima = _tmp3_ + 1;
	_tmp4_ = minima;
	minima = _tmp4_ + ((guint) sizeof (gchar*));
	_tmp5_ = minima;
	minima = _tmp5_ + ((guint) sizeof (guint32));
	_tmp6_ = minima;
	_tmp7_ = ipsize;
	_tmp8_ = ips;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	minima = _tmp6_ + ((_tmp7_ + ((guint) sizeof (gchar*))) * _tmp10_);
	_tmp11_ = minima;
	minima = _tmp11_ + ((guint) sizeof (gchar*));
	_tmp12_ = buflen;
	_tmp13_ = minima;
	if (_tmp12_ < _tmp13_) {
		result = FALSE;
		if (h_name) {
			*h_name = _vala_h_name;
		}
		if (h_aliases) {
			*h_aliases = _vala_h_aliases;
		}
		if (h_addr_list) {
			*h_addr_list = _vala_h_addr_list;
		}
		return result;
	}
	pos = (guint) 0;
	_tmp14_ = ips;
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_new0 (guint, _tmp16_);
	pos_ip = _tmp17_;
	pos_ip_length1 = _tmp16_;
	_pos_ip_size_ = pos_ip_length1;
	_tmp18_ = buffer;
	_tmp19_ = pos;
	p = ((gchar*) _tmp18_) + _tmp19_;
	_tmp20_ = p;
	_vala_h_name = _tmp20_;
	_tmp21_ = name;
	_tmp22_ = string_get_data (_tmp21_, &_tmp22__length1);
	_tmp23_ = _tmp22_;
	_tmp23__length1 = _tmp22__length1;
	{
		guint8* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp23_;
		o_collection_length1 = _tmp23__length1;
		for (o_it = 0; o_it < _tmp23__length1; o_it = o_it + 1) {
			guint8 o = 0U;
			o = o_collection[o_it];
			{
				guint8* _tmp24_;
				guint _tmp25_;
				guint8 _tmp26_;
				guint8 _tmp27_;
				_tmp24_ = buffer;
				_tmp25_ = pos;
				pos = _tmp25_ + 1;
				_tmp26_ = o;
				_tmp24_[_tmp25_] = _tmp26_;
				_tmp27_ = _tmp24_[_tmp25_];
			}
		}
	}
	_tmp28_ = buffer;
	_tmp29_ = pos;
	pos = _tmp29_ + 1;
	_tmp28_[_tmp29_] = (guint8) '\0';
	_tmp30_ = _tmp28_[_tmp29_];
	_tmp31_ = buffer;
	_tmp32_ = pos;
	p = ((gchar*) _tmp31_) + _tmp32_;
	_tmp33_ = p;
	x = (gchar**) _tmp33_;
	_tmp34_ = x;
	*_tmp34_ = NULL;
	_tmp35_ = *_tmp34_;
	_tmp36_ = x;
	_vala_h_aliases = _tmp36_;
	_tmp37_ = pos;
	pos = _tmp37_ + ((guint) sizeof (gchar*));
	_tmp38_ = pos;
	_tmp39_ = pos;
	pos = _tmp38_ + (((guint) sizeof (void*)) - (_tmp39_ % ((guint) sizeof (void*))));
	ip_count = 0;
	{
		GeeList* _tmp40_;
		GeeList* _tmp41_;
		GeeList* _ip_list;
		GeeList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _ip_size;
		gint _ip_index;
		_tmp40_ = ips;
		_tmp41_ = _g_object_ref0 (_tmp40_);
		_ip_list = _tmp41_;
		_tmp42_ = _ip_list;
		_tmp43_ = gee_collection_get_size ((GeeCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_ip_size = _tmp44_;
		_ip_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			GeeList* _tmp48_;
			gint _tmp49_;
			gpointer _tmp50_ = NULL;
			NtkresolvNtkInetAddr* ip;
			guint* _tmp51_;
			gint _tmp51__length1;
			gint _tmp52_;
			guint _tmp53_;
			guint _tmp54_;
			NtkresolvNtkInetAddr* _tmp55_;
			_tmp45_ = _ip_index;
			_ip_index = _tmp45_ + 1;
			_tmp46_ = _ip_index;
			_tmp47_ = _ip_size;
			if (!(_tmp46_ < _tmp47_)) {
				break;
			}
			_tmp48_ = _ip_list;
			_tmp49_ = _ip_index;
			_tmp50_ = gee_list_get (_tmp48_, _tmp49_);
			ip = (NtkresolvNtkInetAddr*) _tmp50_;
			_tmp51_ = pos_ip;
			_tmp51__length1 = pos_ip_length1;
			_tmp52_ = ip_count;
			ip_count = _tmp52_ + 1;
			_tmp53_ = pos;
			_tmp51_[_tmp52_] = _tmp53_;
			_tmp54_ = _tmp51_[_tmp52_];
			_tmp55_ = ip;
			{
				guint8* o_collection = NULL;
				gint o_collection_length1 = 0;
				gint _o_collection_size_ = 0;
				gint o_it = 0;
				o_collection = _tmp55_->addr;
				o_collection_length1 = 4;
				for (o_it = 0; o_it < 4; o_it = o_it + 1) {
					guint8 o = 0U;
					o = o_collection[o_it];
					{
						guint8* _tmp56_;
						guint _tmp57_;
						guint8 _tmp58_;
						guint8 _tmp59_;
						_tmp56_ = buffer;
						_tmp57_ = pos;
						pos = _tmp57_ + 1;
						_tmp58_ = o;
						_tmp56_[_tmp57_] = _tmp58_;
						_tmp59_ = _tmp56_[_tmp57_];
					}
				}
			}
			_g_object_unref0 (ip);
		}
		_g_object_unref0 (_ip_list);
	}
	{
		gint ip_num;
		ip_num = 0;
		{
			gboolean _tmp60_;
			_tmp60_ = TRUE;
			while (TRUE) {
				gboolean _tmp61_;
				gint _tmp63_;
				gint _tmp64_;
				guint8* _tmp65_;
				guint _tmp66_;
				gchar* _tmp67_;
				gchar** _tmp68_;
				guint8* _tmp69_;
				guint* _tmp70_;
				gint _tmp70__length1;
				gint _tmp71_;
				guint _tmp72_;
				gchar* _tmp73_;
				gint _tmp74_;
				guint _tmp76_;
				_tmp61_ = _tmp60_;
				if (!_tmp61_) {
					gint _tmp62_;
					_tmp62_ = ip_num;
					ip_num = _tmp62_ + 1;
				}
				_tmp60_ = FALSE;
				_tmp63_ = ip_num;
				_tmp64_ = ip_count;
				if (!(_tmp63_ < _tmp64_)) {
					break;
				}
				_tmp65_ = buffer;
				_tmp66_ = pos;
				p = ((gchar*) _tmp65_) + _tmp66_;
				_tmp67_ = p;
				x = (gchar**) _tmp67_;
				_tmp68_ = x;
				_tmp69_ = buffer;
				_tmp70_ = pos_ip;
				_tmp70__length1 = pos_ip_length1;
				_tmp71_ = ip_num;
				_tmp72_ = _tmp70_[_tmp71_];
				*_tmp68_ = ((gchar*) _tmp69_) + _tmp72_;
				_tmp73_ = *_tmp68_;
				_tmp74_ = ip_num;
				if (_tmp74_ == 0) {
					gchar** _tmp75_;
					_tmp75_ = x;
					_vala_h_addr_list = _tmp75_;
				}
				_tmp76_ = pos;
				pos = _tmp76_ + ((guint) sizeof (gchar*));
			}
		}
	}
	_tmp77_ = buffer;
	_tmp78_ = pos;
	p = ((gchar*) _tmp77_) + _tmp78_;
	_tmp79_ = p;
	x = (gchar**) _tmp79_;
	_tmp80_ = x;
	*_tmp80_ = NULL;
	_tmp81_ = *_tmp80_;
	_tmp82_ = pos;
	pos = _tmp82_ + ((guint) sizeof (gchar*));
	result = TRUE;
	pos_ip = (g_free (pos_ip), NULL);
	if (h_name) {
		*h_name = _vala_h_name;
	}
	if (h_aliases) {
		*h_aliases = _vala_h_aliases;
	}
	if (h_addr_list) {
		*h_addr_list = _vala_h_addr_list;
	}
	return result;
}


enum nss_status _nss_andna_gethostbyaddr_r (void* addr, socklen_t len, gint type, struct hostent* ret, gchar* buffer, gsize buflen, struct hostent** _result_, gint* h_errnop) {
	enum nss_status result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_;
	GError * _inner_error_ = NULL;
	init ();
	_tmp1_ = type;
	if (_tmp1_ == AF_INET) {
		socklen_t _tmp2_;
		_tmp2_ = len;
		_tmp0_ = ((gulong) _tmp2_) == sizeof (struct in_addr);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		{
			void* _tmp4_;
			struct in_addr* in_addr;
			struct in_addr* _tmp5_;
			struct hostent* _tmp6_;
			gchar* _tmp7_;
			gsize _tmp8_;
			struct hostent** _tmp9_;
			struct hostent* _tmp10_;
			struct hostent* _tmp11_;
			enum nss_status _tmp12_ = 0;
			_tmp4_ = addr;
			in_addr = _tmp4_;
			_tmp5_ = in_addr;
			_tmp6_ = ret;
			_tmp7_ = buffer;
			_tmp8_ = buflen;
			set_host_ent_from_addr (_tmp5_, _tmp6_, _tmp7_, _tmp8_, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == NOT_ANDNA_ERROR) {
					goto __catch4_not_andna_error;
				}
				if (_inner_error_->domain == NOT_FOUND_ERROR) {
					goto __catch4_not_found_error;
				}
				if (_inner_error_->domain == BUFFER_ERROR) {
					goto __catch4_buffer_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_tmp9_ = _result_;
			_tmp10_ = ret;
			*_tmp9_ = _tmp10_;
			_tmp11_ = *_tmp9_;
			_tmp12_ = return_success ();
			result = _tmp12_;
			return result;
		}
		goto __finally4;
		__catch4_not_andna_error:
		{
			GError* e = NULL;
			gint* _tmp13_;
			enum nss_status _tmp14_ = 0;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp13_ = h_errnop;
			_tmp14_ = return_unavail_eperm (_tmp13_);
			result = _tmp14_;
			_g_error_free0 (e);
			return result;
		}
		goto __finally4;
		__catch4_not_found_error:
		{
			GError* e = NULL;
			gint* _tmp15_;
			enum nss_status _tmp16_ = 0;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp15_ = h_errnop;
			_tmp16_ = return_notfound_eperm (_tmp15_);
			result = _tmp16_;
			_g_error_free0 (e);
			return result;
		}
		goto __finally4;
		__catch4_buffer_error:
		{
			GError* e = NULL;
			gint* _tmp17_;
			enum nss_status _tmp18_ = 0;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp17_ = h_errnop;
			_tmp18_ = return_tryagain_erange (_tmp17_);
			result = _tmp18_;
			_g_error_free0 (e);
			return result;
		}
		__finally4:
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	} else {
		gint* _tmp19_;
		enum nss_status _tmp20_ = 0;
		_tmp19_ = h_errnop;
		_tmp20_ = return_unavail_esrch (_tmp19_);
		result = _tmp20_;
		return result;
	}
}


void set_host_ent_from_addr (struct in_addr* addr, struct hostent* ret, gchar* buffer, gsize buflen, const gchar* service, NtkresolvNtkAddrInfo* hints, GError** error) {
	struct in_addr* _tmp0_;
	guint32* s_addr_p;
	guint8* addr_bytes;
	guint8 _tmp1_;
	struct hostent* _tmp3_;
	struct hostent* _tmp4_;
	NtkresolvNtkInetAddr* _tmp5_;
	NtkresolvNtkInetAddr* ntk_addr;
	GeeList* resp = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	guint8 _tmp9_;
	gboolean _tmp11_;
	gboolean _tmp13_;
	gboolean _tmp15_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	guint8 _tmp20_;
	gboolean _tmp22_;
	gboolean _tmp24_;
	gboolean _tmp26_;
	gchar* h_name = NULL;
	gchar** h_aliases = NULL;
	gchar** h_addr_list = NULL;
	GeeList* _tmp59_;
	NtkresolvNtkInetAddr* _tmp60_;
	gchar* _tmp61_;
	gsize _tmp62_;
	gchar* _tmp63_ = NULL;
	gchar** _tmp64_ = NULL;
	gchar** _tmp65_ = NULL;
	gboolean _tmp66_ = FALSE;
	struct hostent* _tmp68_;
	gchar* _tmp69_;
	struct hostent* _tmp70_;
	gchar** _tmp71_;
	struct hostent* _tmp72_;
	gchar** _tmp73_;
	GError * _inner_error_ = NULL;
	_tmp0_ = addr;
	s_addr_p = &(*_tmp0_).s_addr;
	addr_bytes = (guint8*) s_addr_p;
	_tmp1_ = addr_bytes[0];
	if (((gint) _tmp1_) != 10) {
		GError* _tmp2_;
		_tmp2_ = g_error_new_literal (NOT_ANDNA_ERROR, NOT_ANDNA_ERROR_GENERIC, "not for ANDNA");
		_inner_error_ = _tmp2_;
		if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = ret;
	(*_tmp3_).h_addrtype = AF_INET;
	_tmp4_ = ret;
	(*_tmp4_).h_length = 4;
	_tmp5_ = ntkresolv_ntk_inet_addr_new_from_pointer (addr_bytes, (guint16) 0);
	ntk_addr = _tmp5_;
	_tmp9_ = addr_bytes[0];
	if (((gint) _tmp9_) == 10) {
		guint8 _tmp10_;
		_tmp10_ = addr_bytes[1];
		_tmp8_ = ((gint) _tmp10_) == 0;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp11_ = _tmp8_;
	if (_tmp11_) {
		guint8 _tmp12_;
		_tmp12_ = addr_bytes[2];
		_tmp7_ = ((gint) _tmp12_) == 0;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp13_ = _tmp7_;
	if (_tmp13_) {
		guint8 _tmp14_;
		_tmp14_ = addr_bytes[3];
		_tmp6_ = ((gint) _tmp14_) == 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp15_ = _tmp6_;
	if (_tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, "IP address not found.");
		_inner_error_ = _tmp16_;
		if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ntk_addr);
			return;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ntk_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp20_ = addr_bytes[0];
	if (((gint) _tmp20_) == 10) {
		guint8 _tmp21_;
		_tmp21_ = addr_bytes[1];
		_tmp19_ = ((gint) _tmp21_) == 1;
	} else {
		_tmp19_ = FALSE;
	}
	_tmp22_ = _tmp19_;
	if (_tmp22_) {
		guint8 _tmp23_;
		_tmp23_ = addr_bytes[2];
		_tmp18_ = ((gint) _tmp23_) == 1;
	} else {
		_tmp18_ = FALSE;
	}
	_tmp24_ = _tmp18_;
	if (_tmp24_) {
		guint8 _tmp25_;
		_tmp25_ = addr_bytes[3];
		_tmp17_ = ((gint) _tmp25_) == 1;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp26_ = _tmp17_;
	if (_tmp26_) {
		GeeArrayList* _tmp27_;
		GeeList* _tmp28_;
		_tmp27_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (resp);
		resp = (GeeList*) _tmp27_;
		_tmp28_ = resp;
		gee_collection_add ((GeeCollection*) _tmp28_, "presente");
	} else {
		GeeList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		{
			const gchar* _tmp29_;
			_tmp29_ = andnaserver;
			if (_tmp29_ == NULL) {
				NtkresolvNtkInetAddr* _tmp30_;
				GeeList* _tmp31_ = NULL;
				GeeList* _tmp32_;
				_tmp30_ = ntk_addr;
				_tmp31_ = ntkresolv_inverse (NTKRESOLV_IP_FAMILY_IPV4, (NtkresolvNtkAddr*) _tmp30_, "127.0.0.1", &_inner_error_);
				_tmp32_ = _tmp31_;
				if (_inner_error_ != NULL) {
					goto __catch5_g_error;
				}
				_g_object_unref0 (resp);
				resp = _tmp32_;
			} else {
				NtkresolvNtkInetAddr* _tmp33_;
				const gchar* _tmp34_;
				GeeList* _tmp35_ = NULL;
				GeeList* _tmp36_;
				_tmp33_ = ntk_addr;
				_tmp34_ = andnaserver;
				_tmp35_ = ntkresolv_inverse (NTKRESOLV_IP_FAMILY_IPV4, (NtkresolvNtkAddr*) _tmp33_, _tmp34_, &_inner_error_);
				_tmp36_ = _tmp35_;
				if (_inner_error_ != NULL) {
					goto __catch5_g_error;
				}
				_g_object_unref0 (resp);
				resp = _tmp36_;
			}
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			GError* _tmp37_;
			const gchar* _tmp38_;
			GError* _tmp39_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp37_ = e;
			_tmp38_ = _tmp37_->message;
			_tmp39_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, _tmp38_);
			_inner_error_ = _tmp39_;
			_g_error_free0 (e);
			goto __finally5;
		}
		__finally5:
		if (_inner_error_ != NULL) {
			if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (resp);
				_g_object_unref0 (ntk_addr);
				return;
			} else {
				_g_object_unref0 (resp);
				_g_object_unref0 (ntk_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp40_ = resp;
		_tmp41_ = gee_collection_get_size ((GeeCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		if (_tmp42_ == 0) {
			GError* _tmp43_;
			_tmp43_ = g_error_new_literal (NOT_FOUND_ERROR, NOT_FOUND_ERROR_GENERIC, "IP address not found.");
			_inner_error_ = _tmp43_;
			if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (resp);
				_g_object_unref0 (ntk_addr);
				return;
			} else {
				_g_object_unref0 (resp);
				_g_object_unref0 (ntk_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp44_;
			_tmp44_ = TRUE;
			while (TRUE) {
				gboolean _tmp45_;
				gint _tmp47_;
				GeeList* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				GeeList* _tmp51_;
				gint _tmp52_;
				GeeList* _tmp53_;
				gint _tmp54_;
				gpointer _tmp55_ = NULL;
				gchar* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				_tmp45_ = _tmp44_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = i;
					i = _tmp46_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp47_ = i;
				_tmp48_ = resp;
				_tmp49_ = gee_collection_get_size ((GeeCollection*) _tmp48_);
				_tmp50_ = _tmp49_;
				if (!(_tmp47_ < _tmp50_)) {
					break;
				}
				_tmp51_ = resp;
				_tmp52_ = i;
				_tmp53_ = resp;
				_tmp54_ = i;
				_tmp55_ = gee_list_get (_tmp53_, _tmp54_);
				_tmp56_ = (gchar*) _tmp55_;
				_tmp57_ = g_strconcat (_tmp56_, ".NTK", NULL);
				_tmp58_ = _tmp57_;
				gee_list_set (_tmp51_, _tmp52_, _tmp58_);
				_g_free0 (_tmp58_);
				_g_free0 (_tmp56_);
			}
		}
	}
	_tmp59_ = resp;
	_tmp60_ = ntk_addr;
	_tmp61_ = buffer;
	_tmp62_ = buflen;
	_tmp66_ = prepare_buffer_from_addr (_tmp59_, _tmp60_, (guint8*) _tmp61_, (guint) _tmp62_, &_tmp63_, &_tmp64_, &_tmp65_);
	h_name = _tmp63_;
	h_aliases = _tmp64_;
	h_addr_list = _tmp65_;
	if (!_tmp66_) {
		GError* _tmp67_;
		_tmp67_ = g_error_new_literal (BUFFER_ERROR, BUFFER_ERROR_GENERIC, "Not enough space.");
		_inner_error_ = _tmp67_;
		if (((_inner_error_->domain == NOT_ANDNA_ERROR) || (_inner_error_->domain == NOT_FOUND_ERROR)) || (_inner_error_->domain == BUFFER_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (ntk_addr);
			return;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (ntk_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp68_ = ret;
	_tmp69_ = h_name;
	(*_tmp68_).h_name = (const gchar*) _tmp69_;
	_tmp70_ = ret;
	_tmp71_ = h_aliases;
	(*_tmp70_).h_aliases = (gchar**) _tmp71_;
	_tmp72_ = ret;
	_tmp73_ = h_addr_list;
	(*_tmp72_).h_addr_list = (gchar**) _tmp73_;
	_g_object_unref0 (resp);
	_g_object_unref0 (ntk_addr);
}


gboolean prepare_buffer_from_addr (GeeList* names, NtkresolvNtkInetAddr* ip, guint8* buffer, guint buflen, gchar** h_name, gchar*** h_aliases, gchar*** h_addr_list) {
	gchar* _vala_h_name = NULL;
	gchar** _vala_h_aliases = NULL;
	gchar** _vala_h_addr_list = NULL;
	gboolean result = FALSE;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint ipsize;
	GeeList* _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	guint _tmp15_;
	guint minima;
	guint _tmp16_;
	guint _tmp33_;
	guint _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	guint _tmp38_;
	guint _tmp39_;
	gchar** x = NULL;
	gchar* p = NULL;
	guint pos;
	GeeList* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	guint* _tmp43_ = NULL;
	guint* pos_alias;
	gint pos_alias_length1;
	gint _pos_alias_size_;
	guint8* _tmp44_;
	guint _tmp45_;
	gchar* _tmp46_;
	GeeList* _tmp47_;
	gpointer _tmp48_ = NULL;
	gchar* canonical_name;
	const gchar* _tmp49_;
	guint8* _tmp50_;
	gint _tmp50__length1;
	guint8* _tmp51_;
	gint _tmp51__length1;
	guint8* _tmp56_;
	guint _tmp57_;
	guint8 _tmp58_;
	guint8* _tmp102_;
	guint _tmp103_;
	gchar* _tmp104_;
	gchar** _tmp105_;
	gchar* _tmp106_;
	gchar** _tmp107_;
	guint _tmp108_;
	guint _tmp109_;
	guint _tmp110_;
	guint _tmp111_;
	guint pos_ip;
	NtkresolvNtkInetAddr* _tmp112_;
	guint8* _tmp117_;
	guint _tmp118_;
	gchar* _tmp119_;
	gchar** _tmp120_;
	guint8* _tmp121_;
	guint _tmp122_;
	gchar* _tmp123_;
	guint _tmp124_;
	guint8* _tmp125_;
	guint _tmp126_;
	gchar* _tmp127_;
	gchar** _tmp128_;
	gchar* _tmp129_;
	guint _tmp130_;
	g_return_val_if_fail (names != NULL, FALSE);
	g_return_val_if_fail (ip != NULL, FALSE);
	_tmp0_ = names;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_vala_assert (_tmp2_ > 0, "names.size > 0");
	{
		guint i;
		i = (guint) 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				guint _tmp6_;
				guint8* _tmp7_;
				guint _tmp8_;
				guint8 _tmp9_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					guint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < ((guint) 1024))) {
					break;
				}
				_tmp7_ = buffer;
				_tmp8_ = i;
				_tmp7_[_tmp8_] = (guint8) ' ';
				_tmp9_ = _tmp7_[_tmp8_];
			}
		}
	}
	ipsize = ((guint) sizeof (guint8)) * 4;
	_tmp10_ = names;
	_tmp11_ = gee_list_get (_tmp10_, 0);
	_tmp12_ = (gchar*) _tmp11_;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = (guint) _tmp14_;
	_g_free0 (_tmp12_);
	minima = _tmp15_;
	_tmp16_ = minima;
	minima = _tmp16_ + 1;
	{
		gint i;
		i = 1;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				GeeList* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				guint _tmp24_;
				GeeList* _tmp25_;
				gint _tmp26_;
				gpointer _tmp27_ = NULL;
				gchar* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				guint _tmp31_;
				guint _tmp32_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = i;
				_tmp21_ = names;
				_tmp22_ = gee_collection_get_size ((GeeCollection*) _tmp21_);
				_tmp23_ = _tmp22_;
				if (!(_tmp20_ < _tmp23_)) {
					break;
				}
				_tmp24_ = minima;
				_tmp25_ = names;
				_tmp26_ = i;
				_tmp27_ = gee_list_get (_tmp25_, _tmp26_);
				_tmp28_ = (gchar*) _tmp27_;
				_tmp29_ = strlen (_tmp28_);
				_tmp30_ = _tmp29_;
				minima = _tmp24_ + _tmp30_;
				_g_free0 (_tmp28_);
				_tmp31_ = minima;
				minima = _tmp31_ + 1;
				_tmp32_ = minima;
				minima = _tmp32_ + ((guint) sizeof (gchar*));
			}
		}
	}
	_tmp33_ = minima;
	minima = _tmp33_ + ((guint) sizeof (gchar*));
	_tmp34_ = minima;
	minima = _tmp34_ + ((guint) sizeof (guint32));
	_tmp35_ = minima;
	_tmp36_ = ipsize;
	minima = _tmp35_ + (_tmp36_ + ((guint) sizeof (gchar*)));
	_tmp37_ = minima;
	minima = _tmp37_ + ((guint) sizeof (gchar*));
	_tmp38_ = buflen;
	_tmp39_ = minima;
	if (_tmp38_ < _tmp39_) {
		result = FALSE;
		if (h_name) {
			*h_name = _vala_h_name;
		}
		if (h_aliases) {
			*h_aliases = _vala_h_aliases;
		}
		if (h_addr_list) {
			*h_addr_list = _vala_h_addr_list;
		}
		return result;
	}
	pos = (guint) 0;
	_tmp40_ = names;
	_tmp41_ = gee_collection_get_size ((GeeCollection*) _tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_new0 (guint, _tmp42_ - 1);
	pos_alias = _tmp43_;
	pos_alias_length1 = _tmp42_ - 1;
	_pos_alias_size_ = pos_alias_length1;
	_tmp44_ = buffer;
	_tmp45_ = pos;
	p = ((gchar*) _tmp44_) + _tmp45_;
	_tmp46_ = p;
	_vala_h_name = _tmp46_;
	_tmp47_ = names;
	_tmp48_ = gee_list_get (_tmp47_, 0);
	canonical_name = (gchar*) _tmp48_;
	_tmp49_ = canonical_name;
	_tmp50_ = string_get_data (_tmp49_, &_tmp50__length1);
	_tmp51_ = _tmp50_;
	_tmp51__length1 = _tmp50__length1;
	{
		guint8* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp51_;
		o_collection_length1 = _tmp51__length1;
		for (o_it = 0; o_it < _tmp51__length1; o_it = o_it + 1) {
			guint8 o = 0U;
			o = o_collection[o_it];
			{
				guint8* _tmp52_;
				guint _tmp53_;
				guint8 _tmp54_;
				guint8 _tmp55_;
				_tmp52_ = buffer;
				_tmp53_ = pos;
				pos = _tmp53_ + 1;
				_tmp54_ = o;
				_tmp52_[_tmp53_] = _tmp54_;
				_tmp55_ = _tmp52_[_tmp53_];
			}
		}
	}
	_tmp56_ = buffer;
	_tmp57_ = pos;
	pos = _tmp57_ + 1;
	_tmp56_[_tmp57_] = (guint8) '\0';
	_tmp58_ = _tmp56_[_tmp57_];
	{
		gint i;
		i = 1;
		{
			gboolean _tmp59_;
			_tmp59_ = TRUE;
			while (TRUE) {
				gboolean _tmp60_;
				gint _tmp62_;
				GeeList* _tmp63_;
				gint _tmp64_;
				gint _tmp65_;
				GeeList* _tmp66_;
				gint _tmp67_;
				gpointer _tmp68_ = NULL;
				gchar* alias_name;
				guint* _tmp69_;
				gint _tmp69__length1;
				gint _tmp70_;
				guint _tmp71_;
				guint _tmp72_;
				const gchar* _tmp73_;
				guint8* _tmp74_;
				gint _tmp74__length1;
				guint8* _tmp75_;
				gint _tmp75__length1;
				guint8* _tmp80_;
				guint _tmp81_;
				guint8 _tmp82_;
				_tmp60_ = _tmp59_;
				if (!_tmp60_) {
					gint _tmp61_;
					_tmp61_ = i;
					i = _tmp61_ + 1;
				}
				_tmp59_ = FALSE;
				_tmp62_ = i;
				_tmp63_ = names;
				_tmp64_ = gee_collection_get_size ((GeeCollection*) _tmp63_);
				_tmp65_ = _tmp64_;
				if (!(_tmp62_ < _tmp65_)) {
					break;
				}
				_tmp66_ = names;
				_tmp67_ = i;
				_tmp68_ = gee_list_get (_tmp66_, _tmp67_);
				alias_name = (gchar*) _tmp68_;
				_tmp69_ = pos_alias;
				_tmp69__length1 = pos_alias_length1;
				_tmp70_ = i;
				_tmp71_ = pos;
				_tmp69_[_tmp70_ - 1] = _tmp71_;
				_tmp72_ = _tmp69_[_tmp70_ - 1];
				_tmp73_ = alias_name;
				_tmp74_ = string_get_data (_tmp73_, &_tmp74__length1);
				_tmp75_ = _tmp74_;
				_tmp75__length1 = _tmp74__length1;
				{
					guint8* o_collection = NULL;
					gint o_collection_length1 = 0;
					gint _o_collection_size_ = 0;
					gint o_it = 0;
					o_collection = _tmp75_;
					o_collection_length1 = _tmp75__length1;
					for (o_it = 0; o_it < _tmp75__length1; o_it = o_it + 1) {
						guint8 o = 0U;
						o = o_collection[o_it];
						{
							guint8* _tmp76_;
							guint _tmp77_;
							guint8 _tmp78_;
							guint8 _tmp79_;
							_tmp76_ = buffer;
							_tmp77_ = pos;
							pos = _tmp77_ + 1;
							_tmp78_ = o;
							_tmp76_[_tmp77_] = _tmp78_;
							_tmp79_ = _tmp76_[_tmp77_];
						}
					}
				}
				_tmp80_ = buffer;
				_tmp81_ = pos;
				pos = _tmp81_ + 1;
				_tmp80_[_tmp81_] = (guint8) '\0';
				_tmp82_ = _tmp80_[_tmp81_];
				_g_free0 (alias_name);
			}
		}
	}
	{
		gint i;
		i = 1;
		{
			gboolean _tmp83_;
			_tmp83_ = TRUE;
			while (TRUE) {
				gboolean _tmp84_;
				gint _tmp86_;
				GeeList* _tmp87_;
				gint _tmp88_;
				gint _tmp89_;
				guint8* _tmp90_;
				guint _tmp91_;
				gchar* _tmp92_;
				gchar** _tmp93_;
				guint8* _tmp94_;
				guint* _tmp95_;
				gint _tmp95__length1;
				gint _tmp96_;
				guint _tmp97_;
				gchar* _tmp98_;
				gint _tmp99_;
				guint _tmp101_;
				_tmp84_ = _tmp83_;
				if (!_tmp84_) {
					gint _tmp85_;
					_tmp85_ = i;
					i = _tmp85_ + 1;
				}
				_tmp83_ = FALSE;
				_tmp86_ = i;
				_tmp87_ = names;
				_tmp88_ = gee_collection_get_size ((GeeCollection*) _tmp87_);
				_tmp89_ = _tmp88_;
				if (!(_tmp86_ < _tmp89_)) {
					break;
				}
				_tmp90_ = buffer;
				_tmp91_ = pos;
				p = ((gchar*) _tmp90_) + _tmp91_;
				_tmp92_ = p;
				x = (gchar**) _tmp92_;
				_tmp93_ = x;
				_tmp94_ = buffer;
				_tmp95_ = pos_alias;
				_tmp95__length1 = pos_alias_length1;
				_tmp96_ = i;
				_tmp97_ = _tmp95_[_tmp96_ - 1];
				*_tmp93_ = ((gchar*) _tmp94_) + _tmp97_;
				_tmp98_ = *_tmp93_;
				_tmp99_ = i;
				if (_tmp99_ == 1) {
					gchar** _tmp100_;
					_tmp100_ = x;
					_vala_h_addr_list = _tmp100_;
				}
				_tmp101_ = pos;
				pos = _tmp101_ + ((guint) sizeof (gchar*));
			}
		}
	}
	_tmp102_ = buffer;
	_tmp103_ = pos;
	p = ((gchar*) _tmp102_) + _tmp103_;
	_tmp104_ = p;
	x = (gchar**) _tmp104_;
	_tmp105_ = x;
	*_tmp105_ = NULL;
	_tmp106_ = *_tmp105_;
	_tmp107_ = x;
	_vala_h_aliases = _tmp107_;
	_tmp108_ = pos;
	pos = _tmp108_ + ((guint) sizeof (gchar*));
	_tmp109_ = pos;
	_tmp110_ = pos;
	pos = _tmp109_ + (((guint) sizeof (void*)) - (_tmp110_ % ((guint) sizeof (void*))));
	_tmp111_ = pos;
	pos_ip = _tmp111_;
	_tmp112_ = ip;
	{
		guint8* o_collection = NULL;
		gint o_collection_length1 = 0;
		gint _o_collection_size_ = 0;
		gint o_it = 0;
		o_collection = _tmp112_->addr;
		o_collection_length1 = 4;
		for (o_it = 0; o_it < 4; o_it = o_it + 1) {
			guint8 o = 0U;
			o = o_collection[o_it];
			{
				guint8* _tmp113_;
				guint _tmp114_;
				guint8 _tmp115_;
				guint8 _tmp116_;
				_tmp113_ = buffer;
				_tmp114_ = pos;
				pos = _tmp114_ + 1;
				_tmp115_ = o;
				_tmp113_[_tmp114_] = _tmp115_;
				_tmp116_ = _tmp113_[_tmp114_];
			}
		}
	}
	_tmp117_ = buffer;
	_tmp118_ = pos;
	p = ((gchar*) _tmp117_) + _tmp118_;
	_tmp119_ = p;
	x = (gchar**) _tmp119_;
	_tmp120_ = x;
	_tmp121_ = buffer;
	_tmp122_ = pos_ip;
	*_tmp120_ = ((gchar*) _tmp121_) + _tmp122_;
	_tmp123_ = *_tmp120_;
	_tmp124_ = pos;
	pos = _tmp124_ + ((guint) sizeof (gchar*));
	_tmp125_ = buffer;
	_tmp126_ = pos;
	p = ((gchar*) _tmp125_) + _tmp126_;
	_tmp127_ = p;
	x = (gchar**) _tmp127_;
	_tmp128_ = x;
	*_tmp128_ = NULL;
	_tmp129_ = *_tmp128_;
	_tmp130_ = pos;
	pos = _tmp130_ + ((guint) sizeof (gchar*));
	result = TRUE;
	_g_free0 (canonical_name);
	pos_alias = (g_free (pos_alias), NULL);
	if (h_name) {
		*h_name = _vala_h_name;
	}
	if (h_aliases) {
		*h_aliases = _vala_h_aliases;
	}
	if (h_addr_list) {
		*h_addr_list = _vala_h_addr_list;
	}
	return result;
}



