/* dns-to-andna.c generated by valac 0.20.1, the Vala compiler
 * generated from dns-to-andna.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <syslog.h>
#include <gio/gio.h>
#include "ntkresolv.h"
#include "ntkutils.h"
#include <glib/gstdio.h>
#include "sysconf.h"


#define DNS_TYPE_OPERATION_CODE (dns_operation_code_get_type ())

#define DNS_TYPE_RESPONSE_CODE (dns_response_code_get_type ())

#define DNS_TYPE_RR_TYPE (dns_rr_type_get_type ())

#define DNS_TYPE_RR_CLASS (dns_rr_class_get_type ())

#define DNS_TYPE_QUESTION_RECORD (dns_question_record_get_type ())
#define DNS_QUESTION_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DNS_TYPE_QUESTION_RECORD, DnsQuestionRecord))
#define DNS_QUESTION_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DNS_TYPE_QUESTION_RECORD, DnsQuestionRecordClass))
#define DNS_IS_QUESTION_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DNS_TYPE_QUESTION_RECORD))
#define DNS_IS_QUESTION_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DNS_TYPE_QUESTION_RECORD))
#define DNS_QUESTION_RECORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DNS_TYPE_QUESTION_RECORD, DnsQuestionRecordClass))

typedef struct _DnsQuestionRecord DnsQuestionRecord;
typedef struct _DnsQuestionRecordClass DnsQuestionRecordClass;
typedef struct _DnsQuestionRecordPrivate DnsQuestionRecordPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DNS_TYPE_RES_RECORD (dns_res_record_get_type ())
#define DNS_RES_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DNS_TYPE_RES_RECORD, DnsResRecord))
#define DNS_RES_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DNS_TYPE_RES_RECORD, DnsResRecordClass))
#define DNS_IS_RES_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DNS_TYPE_RES_RECORD))
#define DNS_IS_RES_RECORD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DNS_TYPE_RES_RECORD))
#define DNS_RES_RECORD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DNS_TYPE_RES_RECORD, DnsResRecordClass))

typedef struct _DnsResRecord DnsResRecord;
typedef struct _DnsResRecordClass DnsResRecordClass;
typedef struct _DnsResRecordPrivate DnsResRecordPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DNS_TYPE_MESSAGE (dns_message_get_type ())
#define DNS_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DNS_TYPE_MESSAGE, DnsMessage))
#define DNS_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DNS_TYPE_MESSAGE, DnsMessageClass))
#define DNS_IS_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DNS_TYPE_MESSAGE))
#define DNS_IS_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DNS_TYPE_MESSAGE))
#define DNS_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DNS_TYPE_MESSAGE, DnsMessageClass))

typedef struct _DnsMessage DnsMessage;
typedef struct _DnsMessageClass DnsMessageClass;
typedef struct _DnsMessagePrivate DnsMessagePrivate;

#define TYPE_CLEANUP_SERVING_ID_ARG (cleanup_serving_id_arg_get_type ())
#define CLEANUP_SERVING_ID_ARG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEANUP_SERVING_ID_ARG, CleanupServingIdArg))
#define CLEANUP_SERVING_ID_ARG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEANUP_SERVING_ID_ARG, CleanupServingIdArgClass))
#define IS_CLEANUP_SERVING_ID_ARG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEANUP_SERVING_ID_ARG))
#define IS_CLEANUP_SERVING_ID_ARG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEANUP_SERVING_ID_ARG))
#define CLEANUP_SERVING_ID_ARG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEANUP_SERVING_ID_ARG, CleanupServingIdArgClass))

typedef struct _CleanupServingIdArg CleanupServingIdArg;
typedef struct _CleanupServingIdArgClass CleanupServingIdArgClass;
typedef struct _CleanupServingIdArgPrivate CleanupServingIdArgPrivate;

#define TYPE_FORWARD_DNS_ARG (forward_dns_arg_get_type ())
#define FORWARD_DNS_ARG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORWARD_DNS_ARG, ForwardDnsArg))
#define FORWARD_DNS_ARG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORWARD_DNS_ARG, ForwardDnsArgClass))
#define IS_FORWARD_DNS_ARG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORWARD_DNS_ARG))
#define IS_FORWARD_DNS_ARG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORWARD_DNS_ARG))
#define FORWARD_DNS_ARG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORWARD_DNS_ARG, ForwardDnsArgClass))

typedef struct _ForwardDnsArg ForwardDnsArg;
typedef struct _ForwardDnsArgClass ForwardDnsArgClass;
typedef struct _ForwardDnsArgPrivate ForwardDnsArgPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_HANDLE_REQUEST_ARG (handle_request_arg_get_type ())
#define HANDLE_REQUEST_ARG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HANDLE_REQUEST_ARG, HandleRequestArg))
#define HANDLE_REQUEST_ARG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HANDLE_REQUEST_ARG, HandleRequestArgClass))
#define IS_HANDLE_REQUEST_ARG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HANDLE_REQUEST_ARG))
#define IS_HANDLE_REQUEST_ARG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HANDLE_REQUEST_ARG))
#define HANDLE_REQUEST_ARG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HANDLE_REQUEST_ARG, HandleRequestArgClass))

typedef struct _HandleRequestArg HandleRequestArg;
typedef struct _HandleRequestArgClass HandleRequestArgClass;
typedef struct _HandleRequestArgPrivate HandleRequestArgPrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	DNS_OPERATION_CODE_NAME_TO_IP = 0,
	DNS_OPERATION_CODE_IP_TO_NAME = 1,
	DNS_OPERATION_CODE_STATUS = 2
} DnsOperationCode;

typedef enum  {
	DNS_RESPONSE_CODE_NO_ERROR = 0,
	DNS_RESPONSE_CODE_BADFORMAT = 1,
	DNS_RESPONSE_CODE_SERVFAIL = 2,
	DNS_RESPONSE_CODE_NOTFOUND = 3,
	DNS_RESPONSE_CODE_NOTIMPL = 4,
	DNS_RESPONSE_CODE_REFUSE = 5
} DnsResponseCode;

typedef enum  {
	DNS_RR_TYPE_A = 1,
	DNS_RR_TYPE_PTR = 12,
	DNS_RR_TYPE_OPT = 41,
	DNS_RR_TYPE_QR_ALL = 255
} DnsRRType;

typedef enum  {
	DNS_RR_CLASS_IN = 1,
	DNS_RR_CLASS_QR_ANY = 255
} DnsRRClass;

typedef enum  {
	DNS_MESSAGE_ERROR_MALFORMED_MESSAGE,
	DNS_MESSAGE_ERROR_UNSUPPORTED_MESSAGE
} DnsMessageError;
#define DNS_MESSAGE_ERROR dns_message_error_quark ()
struct _DnsQuestionRecord {
	GObject parent_instance;
	DnsQuestionRecordPrivate * priv;
};

struct _DnsQuestionRecordClass {
	GObjectClass parent_class;
};

struct _DnsQuestionRecordPrivate {
	gchar* _name;
	DnsRRType _rrtype;
	DnsRRClass _rrclass;
};

struct _DnsResRecord {
	GObject parent_instance;
	DnsResRecordPrivate * priv;
};

struct _DnsResRecordClass {
	GObjectClass parent_class;
};

struct _DnsResRecordPrivate {
	gchar* _name;
	DnsRRType _rrtype;
	DnsRRClass _rrclass;
	gint32 _ttl;
	guint8* _data;
	gint _data_length1;
	gint __data_size_;
};

struct _DnsMessage {
	GObject parent_instance;
	DnsMessagePrivate * priv;
	guint16 id;
	gboolean question;
	DnsOperationCode opcode;
	gboolean authoritative_answer;
	gboolean truncation;
	gboolean recursion_desired;
	gboolean recursion_available;
	DnsResponseCode rcode;
	GeeArrayList* question_recs;
	GeeArrayList* answer_recs;
	GeeArrayList* authority_recs;
	GeeArrayList* additional_recs;
};

struct _DnsMessageClass {
	GObjectClass parent_class;
};

struct _CleanupServingIdArg {
	GObject parent_instance;
	CleanupServingIdArgPrivate * priv;
	guint16 id;
};

struct _CleanupServingIdArgClass {
	GObjectClass parent_class;
};

struct _ForwardDnsArg {
	GObject parent_instance;
	ForwardDnsArgPrivate * priv;
	GSocketAddress* client_address;
	guint8* buffer;
	gint buffer_length1;
	GSocketAddress* dns_server;
};

struct _ForwardDnsArgClass {
	GObjectClass parent_class;
};

struct _ForwardDnsArgPrivate {
	guint8* dns_response;
	gint dns_response_length1;
	gint _dns_response_size_;
};

struct _HandleRequestArg {
	GObject parent_instance;
	HandleRequestArgPrivate * priv;
	GSocketAddress* client_address;
	guint8* buffer;
	gint buffer_length1;
};

struct _HandleRequestArgClass {
	GObjectClass parent_class;
};


static gpointer dns_question_record_parent_class = NULL;
static gpointer dns_res_record_parent_class = NULL;
static gpointer dns_message_parent_class = NULL;
extern GeeArrayList* serving_ids;
GeeArrayList* serving_ids = NULL;
extern GSocket* listening_socket;
GSocket* listening_socket = NULL;
extern GeeArrayList* dns_list;
GeeArrayList* dns_list = NULL;
static gpointer cleanup_serving_id_arg_parent_class = NULL;
static gpointer forward_dns_arg_parent_class = NULL;
static gpointer handle_request_arg_parent_class = NULL;

GType dns_operation_code_get_type (void) G_GNUC_CONST;
GType dns_response_code_get_type (void) G_GNUC_CONST;
GType dns_rr_type_get_type (void) G_GNUC_CONST;
GType dns_rr_class_get_type (void) G_GNUC_CONST;
GQuark dns_message_error_quark (void);
GType dns_question_record_get_type (void) G_GNUC_CONST;
#define DNS_QUESTION_RECORD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DNS_TYPE_QUESTION_RECORD, DnsQuestionRecordPrivate))
enum  {
	DNS_QUESTION_RECORD_DUMMY_PROPERTY,
	DNS_QUESTION_RECORD_NAME,
	DNS_QUESTION_RECORD_RRTYPE,
	DNS_QUESTION_RECORD_RRCLASS
};
DnsQuestionRecord* dns_question_record_new (const gchar* name, DnsRRType rrtype, DnsRRClass rrclass);
DnsQuestionRecord* dns_question_record_construct (GType object_type, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass);
static void dns_question_record_set_name (DnsQuestionRecord* self, const gchar* value);
static void dns_question_record_set_rrtype (DnsQuestionRecord* self, DnsRRType value);
static void dns_question_record_set_rrclass (DnsQuestionRecord* self, DnsRRClass value);
const gchar* dns_question_record_get_name (DnsQuestionRecord* self);
DnsRRType dns_question_record_get_rrtype (DnsQuestionRecord* self);
DnsRRClass dns_question_record_get_rrclass (DnsQuestionRecord* self);
static void dns_question_record_finalize (GObject* obj);
static void _vala_dns_question_record_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dns_question_record_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dns_res_record_get_type (void) G_GNUC_CONST;
#define DNS_RES_RECORD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DNS_TYPE_RES_RECORD, DnsResRecordPrivate))
enum  {
	DNS_RES_RECORD_DUMMY_PROPERTY,
	DNS_RES_RECORD_NAME,
	DNS_RES_RECORD_RRTYPE,
	DNS_RES_RECORD_RRCLASS,
	DNS_RES_RECORD_TTL
};
DnsResRecord* dns_res_record_new_from_data (const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, guint8* data, int data_length1);
DnsResRecord* dns_res_record_construct_from_data (GType object_type, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, guint8* data, int data_length1);
static void dns_res_record_set_name (DnsResRecord* self, const gchar* value);
static void dns_res_record_set_rrtype (DnsResRecord* self, DnsRRType value);
static void dns_res_record_set_rrclass (DnsResRecord* self, DnsRRClass value);
static void dns_res_record_set_ttl (DnsResRecord* self, gint32 value);
static void dns_res_record_set_data (DnsResRecord* self, guint8* value, int value_length1);
guint8* dns_res_record_get_data (DnsResRecord* self, int* result_length1);
DnsResRecord* dns_res_record_new_inetaddr (const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, guint8* data, int data_length1);
DnsResRecord* dns_res_record_construct_inetaddr (GType object_type, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, guint8* data, int data_length1);
DnsResRecord* dns_res_record_new_ptr (const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, const gchar* ptr, GError** error);
DnsResRecord* dns_res_record_construct_ptr (GType object_type, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, const gchar* ptr, GError** error);
guint8* dns_name_dotted_to_octets (const gchar* name, int* result_length1, GError** error);
DnsResRecord* dns_res_record_new (void);
DnsResRecord* dns_res_record_construct (GType object_type);
const gchar* dns_res_record_get_name (DnsResRecord* self);
DnsRRType dns_res_record_get_rrtype (DnsResRecord* self);
DnsRRClass dns_res_record_get_rrclass (DnsResRecord* self);
gint32 dns_res_record_get_ttl (DnsResRecord* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static void dns_res_record_finalize (GObject* obj);
static void _vala_dns_res_record_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dns_res_record_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dns_message_get_type (void) G_GNUC_CONST;
enum  {
	DNS_MESSAGE_DUMMY_PROPERTY
};
DnsMessage* dns_message_new_from_wire (guint8* message, int message_length1, gsize message_length, GError** error);
DnsMessage* dns_message_construct_from_wire (GType object_type, guint8* message, int message_length1, gsize message_length, GError** error);
static void dns_message_name_type_class (DnsMessage* self, guint8* message, gsize message_length, gsize* pos, gchar** name, DnsRRType* rrtype, DnsRRClass* rrclass, GError** error);
static void dns_message_res_record (DnsMessage* self, guint8* message, gsize message_length, gsize* pos, DnsResRecord** rr, GError** error);
DnsMessage* dns_message_make_response (DnsMessage* self);
static DnsMessage* dns_message_new_response (DnsMessage* q);
static DnsMessage* dns_message_construct_response (GType object_type, DnsMessage* q);
guint8* dns_message_to_wire (DnsMessage* self, int* result_length1);
static void dns_message_add_uint16 (DnsMessage* self, guint16 i, guint8* o0, guint8* o1);
static void _vala_array_add1 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add2 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add3 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add4 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add5 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add6 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add7 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add8 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add9 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add10 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add11 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add12 (guint8** array, int* length, int* size, guint8 value);
static void dns_message_output_name_type_class (DnsMessage* self, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, guint8** buf, int* buf_length1, GError** error);
static void _vala_array_add13 (guint8** array, int* length, int* size, guint8 value);
static void dns_message_output_res_record (DnsMessage* self, DnsResRecord* rr, guint8** buf, int* buf_length1, GError** error);
static void _vala_array_add14 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add15 (guint8** array, int* length, int* size, guint8 value);
static void _vala_array_add16 (guint8** array, int* length, int* size, guint8 value);
static void dns_message_add_uint32 (DnsMessage* self, guint32 i, guint8* o0, guint8* o1, guint8* o2, guint8* o3);
DnsMessage* dns_message_new (void);
DnsMessage* dns_message_construct (GType object_type);
static void dns_message_finalize (GObject* obj);
void log_info (const gchar* msg);
void log_notice (const gchar* msg);
void log_warn (const gchar* msg);
void log_error (const gchar* msg);
void log_critical (const gchar* msg);
gchar* hex_dump (guint8* buf, int buf_length1, gsize length);
GType cleanup_serving_id_arg_get_type (void) G_GNUC_CONST;
enum  {
	CLEANUP_SERVING_ID_ARG_DUMMY_PROPERTY
};
CleanupServingIdArg* cleanup_serving_id_arg_new (guint16 id);
CleanupServingIdArg* cleanup_serving_id_arg_construct (GType object_type, guint16 id);
gint cleanup_serving_id_arg_cleanup_serving_id (CleanupServingIdArg* self);
static void cleanup_serving_id_arg_finalize (GObject* obj);
GType forward_dns_arg_get_type (void) G_GNUC_CONST;
#define FORWARD_DNS_ARG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FORWARD_DNS_ARG, ForwardDnsArgPrivate))
enum  {
	FORWARD_DNS_ARG_DUMMY_PROPERTY
};
ForwardDnsArg* forward_dns_arg_new (GSocketAddress* client_address, guint8* buffer, int buffer_length1, GSocketAddress* dns_server);
ForwardDnsArg* forward_dns_arg_construct (GType object_type, GSocketAddress* client_address, guint8* buffer, int buffer_length1, GSocketAddress* dns_server);
static guint8* _vala_array_dup2 (guint8* self, int length);
gint forward_dns_arg_forward_dns (ForwardDnsArg* self);
static void forward_dns_arg_finalize (GObject* obj);
GType handle_request_arg_get_type (void) G_GNUC_CONST;
enum  {
	HANDLE_REQUEST_ARG_DUMMY_PROPERTY
};
HandleRequestArg* handle_request_arg_new (GSocketAddress* client_address, guint8* buffer, int buffer_length1);
HandleRequestArg* handle_request_arg_construct (GType object_type, GSocketAddress* client_address, guint8* buffer, int buffer_length1);
static guint8* _vala_array_dup3 (guint8* self, int length);
gint handle_request_arg_handle_request (HandleRequestArg* self);
static gboolean handle_request_arg_check_forward_to_dns (HandleRequestArg* self, DnsMessage* query);
static gpointer _forward_dns_arg_forward_dns_gthread_func (gpointer self);
static gpointer _cleanup_serving_id_arg_cleanup_serving_id_gthread_func (gpointer self);
static GeeList* handle_request_arg_std_qry (HandleRequestArg* self, DnsQuestionRecord* q);
static GeeList* handle_request_arg_inv_qry (HandleRequestArg* self, DnsQuestionRecord* q);
static guint8* _vala_array_dup4 (guint8* self, int length);
static void handle_request_arg_finalize (GObject* obj);
gchar** read_file (const gchar* path, int* result_length1);
void _vala_main (gchar** argv, int argv_length1);
static gpointer _handle_request_arg_handle_request_gthread_func (gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType dns_operation_code_get_type (void) {
	static volatile gsize dns_operation_code_type_id__volatile = 0;
	if (g_once_init_enter (&dns_operation_code_type_id__volatile)) {
		static const GEnumValue values[] = {{DNS_OPERATION_CODE_NAME_TO_IP, "DNS_OPERATION_CODE_NAME_TO_IP", "name-to-ip"}, {DNS_OPERATION_CODE_IP_TO_NAME, "DNS_OPERATION_CODE_IP_TO_NAME", "ip-to-name"}, {DNS_OPERATION_CODE_STATUS, "DNS_OPERATION_CODE_STATUS", "status"}, {0, NULL, NULL}};
		GType dns_operation_code_type_id;
		dns_operation_code_type_id = g_enum_register_static ("DnsOperationCode", values);
		g_once_init_leave (&dns_operation_code_type_id__volatile, dns_operation_code_type_id);
	}
	return dns_operation_code_type_id__volatile;
}


GType dns_response_code_get_type (void) {
	static volatile gsize dns_response_code_type_id__volatile = 0;
	if (g_once_init_enter (&dns_response_code_type_id__volatile)) {
		static const GEnumValue values[] = {{DNS_RESPONSE_CODE_NO_ERROR, "DNS_RESPONSE_CODE_NO_ERROR", "no-error"}, {DNS_RESPONSE_CODE_BADFORMAT, "DNS_RESPONSE_CODE_BADFORMAT", "badformat"}, {DNS_RESPONSE_CODE_SERVFAIL, "DNS_RESPONSE_CODE_SERVFAIL", "servfail"}, {DNS_RESPONSE_CODE_NOTFOUND, "DNS_RESPONSE_CODE_NOTFOUND", "notfound"}, {DNS_RESPONSE_CODE_NOTIMPL, "DNS_RESPONSE_CODE_NOTIMPL", "notimpl"}, {DNS_RESPONSE_CODE_REFUSE, "DNS_RESPONSE_CODE_REFUSE", "refuse"}, {0, NULL, NULL}};
		GType dns_response_code_type_id;
		dns_response_code_type_id = g_enum_register_static ("DnsResponseCode", values);
		g_once_init_leave (&dns_response_code_type_id__volatile, dns_response_code_type_id);
	}
	return dns_response_code_type_id__volatile;
}


GType dns_rr_type_get_type (void) {
	static volatile gsize dns_rr_type_type_id__volatile = 0;
	if (g_once_init_enter (&dns_rr_type_type_id__volatile)) {
		static const GEnumValue values[] = {{DNS_RR_TYPE_A, "DNS_RR_TYPE_A", "a"}, {DNS_RR_TYPE_PTR, "DNS_RR_TYPE_PTR", "ptr"}, {DNS_RR_TYPE_OPT, "DNS_RR_TYPE_OPT", "opt"}, {DNS_RR_TYPE_QR_ALL, "DNS_RR_TYPE_QR_ALL", "qr-all"}, {0, NULL, NULL}};
		GType dns_rr_type_type_id;
		dns_rr_type_type_id = g_enum_register_static ("DnsRRType", values);
		g_once_init_leave (&dns_rr_type_type_id__volatile, dns_rr_type_type_id);
	}
	return dns_rr_type_type_id__volatile;
}


GType dns_rr_class_get_type (void) {
	static volatile gsize dns_rr_class_type_id__volatile = 0;
	if (g_once_init_enter (&dns_rr_class_type_id__volatile)) {
		static const GEnumValue values[] = {{DNS_RR_CLASS_IN, "DNS_RR_CLASS_IN", "in"}, {DNS_RR_CLASS_QR_ANY, "DNS_RR_CLASS_QR_ANY", "qr-any"}, {0, NULL, NULL}};
		GType dns_rr_class_type_id;
		dns_rr_class_type_id = g_enum_register_static ("DnsRRClass", values);
		g_once_init_leave (&dns_rr_class_type_id__volatile, dns_rr_class_type_id);
	}
	return dns_rr_class_type_id__volatile;
}


GQuark dns_message_error_quark (void) {
	return g_quark_from_static_string ("dns_message_error-quark");
}


DnsQuestionRecord* dns_question_record_construct (GType object_type, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass) {
	DnsQuestionRecord * self = NULL;
	const gchar* _tmp0_;
	DnsRRType _tmp1_;
	DnsRRClass _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (DnsQuestionRecord*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	dns_question_record_set_name (self, _tmp0_);
	_tmp1_ = rrtype;
	dns_question_record_set_rrtype (self, _tmp1_);
	_tmp2_ = rrclass;
	dns_question_record_set_rrclass (self, _tmp2_);
	return self;
}


DnsQuestionRecord* dns_question_record_new (const gchar* name, DnsRRType rrtype, DnsRRClass rrclass) {
	return dns_question_record_construct (DNS_TYPE_QUESTION_RECORD, name, rrtype, rrclass);
}


const gchar* dns_question_record_get_name (DnsQuestionRecord* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void dns_question_record_set_name (DnsQuestionRecord* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


DnsRRType dns_question_record_get_rrtype (DnsQuestionRecord* self) {
	DnsRRType result;
	DnsRRType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rrtype;
	result = _tmp0_;
	return result;
}


static void dns_question_record_set_rrtype (DnsQuestionRecord* self, DnsRRType value) {
	DnsRRType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rrtype = _tmp0_;
	g_object_notify ((GObject *) self, "rrtype");
}


DnsRRClass dns_question_record_get_rrclass (DnsQuestionRecord* self) {
	DnsRRClass result;
	DnsRRClass _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rrclass;
	result = _tmp0_;
	return result;
}


static void dns_question_record_set_rrclass (DnsQuestionRecord* self, DnsRRClass value) {
	DnsRRClass _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rrclass = _tmp0_;
	g_object_notify ((GObject *) self, "rrclass");
}


static void dns_question_record_class_init (DnsQuestionRecordClass * klass) {
	dns_question_record_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DnsQuestionRecordPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dns_question_record_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dns_question_record_set_property;
	G_OBJECT_CLASS (klass)->finalize = dns_question_record_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DNS_QUESTION_RECORD_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DNS_QUESTION_RECORD_RRTYPE, g_param_spec_enum ("rrtype", "rrtype", "rrtype", DNS_TYPE_RR_TYPE, DNS_RR_TYPE_A, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DNS_QUESTION_RECORD_RRCLASS, g_param_spec_enum ("rrclass", "rrclass", "rrclass", DNS_TYPE_RR_CLASS, DNS_RR_CLASS_IN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void dns_question_record_instance_init (DnsQuestionRecord * self) {
	self->priv = DNS_QUESTION_RECORD_GET_PRIVATE (self);
	self->priv->_rrtype = DNS_RR_TYPE_A;
	self->priv->_rrclass = DNS_RR_CLASS_IN;
}


static void dns_question_record_finalize (GObject* obj) {
	DnsQuestionRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DNS_TYPE_QUESTION_RECORD, DnsQuestionRecord);
	_g_free0 (self->priv->_name);
	G_OBJECT_CLASS (dns_question_record_parent_class)->finalize (obj);
}


GType dns_question_record_get_type (void) {
	static volatile gsize dns_question_record_type_id__volatile = 0;
	if (g_once_init_enter (&dns_question_record_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DnsQuestionRecordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dns_question_record_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DnsQuestionRecord), 0, (GInstanceInitFunc) dns_question_record_instance_init, NULL };
		GType dns_question_record_type_id;
		dns_question_record_type_id = g_type_register_static (G_TYPE_OBJECT, "DnsQuestionRecord", &g_define_type_info, 0);
		g_once_init_leave (&dns_question_record_type_id__volatile, dns_question_record_type_id);
	}
	return dns_question_record_type_id__volatile;
}


static void _vala_dns_question_record_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DnsQuestionRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DNS_TYPE_QUESTION_RECORD, DnsQuestionRecord);
	switch (property_id) {
		case DNS_QUESTION_RECORD_NAME:
		g_value_set_string (value, dns_question_record_get_name (self));
		break;
		case DNS_QUESTION_RECORD_RRTYPE:
		g_value_set_enum (value, dns_question_record_get_rrtype (self));
		break;
		case DNS_QUESTION_RECORD_RRCLASS:
		g_value_set_enum (value, dns_question_record_get_rrclass (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dns_question_record_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DnsQuestionRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DNS_TYPE_QUESTION_RECORD, DnsQuestionRecord);
	switch (property_id) {
		case DNS_QUESTION_RECORD_NAME:
		dns_question_record_set_name (self, g_value_get_string (value));
		break;
		case DNS_QUESTION_RECORD_RRTYPE:
		dns_question_record_set_rrtype (self, g_value_get_enum (value));
		break;
		case DNS_QUESTION_RECORD_RRCLASS:
		dns_question_record_set_rrclass (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


DnsResRecord* dns_res_record_construct_from_data (GType object_type, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, guint8* data, int data_length1) {
	DnsResRecord * self = NULL;
	const gchar* _tmp0_;
	DnsRRType _tmp1_;
	DnsRRClass _tmp2_;
	gint32 _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_ = NULL;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint pos;
	guint8* _tmp7_;
	gint _tmp7__length1;
	g_return_val_if_fail (name != NULL, NULL);
	self = (DnsResRecord*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	dns_res_record_set_name (self, _tmp0_);
	_tmp1_ = rrtype;
	dns_res_record_set_rrtype (self, _tmp1_);
	_tmp2_ = rrclass;
	dns_res_record_set_rrclass (self, _tmp2_);
	_tmp3_ = ttl;
	dns_res_record_set_ttl (self, _tmp3_);
	_tmp4_ = data;
	_tmp4__length1 = data_length1;
	_tmp5_ = g_new0 (guint8, _tmp4__length1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4__length1;
	dns_res_record_set_data (self, _tmp6_, _tmp4__length1);
	_tmp6_ = (g_free (_tmp6_), NULL);
	pos = 0;
	_tmp7_ = data;
	_tmp7__length1 = data_length1;
	{
		guint8* b_collection = NULL;
		gint b_collection_length1 = 0;
		gint _b_collection_size_ = 0;
		gint b_it = 0;
		b_collection = _tmp7_;
		b_collection_length1 = _tmp7__length1;
		for (b_it = 0; b_it < _tmp7__length1; b_it = b_it + 1) {
			guint8 b = 0U;
			b = b_collection[b_it];
			{
				guint8* _tmp8_;
				gint _tmp8__length1;
				guint8* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				guint8 _tmp11_;
				guint8 _tmp12_;
				_tmp8_ = dns_res_record_get_data (self, &_tmp8__length1);
				_tmp9_ = _tmp8_;
				_tmp9__length1 = _tmp8__length1;
				_tmp10_ = pos;
				pos = _tmp10_ + 1;
				_tmp11_ = b;
				_tmp9_[_tmp10_] = _tmp11_;
				_tmp12_ = _tmp9_[_tmp10_];
			}
		}
	}
	return self;
}


DnsResRecord* dns_res_record_new_from_data (const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, guint8* data, int data_length1) {
	return dns_res_record_construct_from_data (DNS_TYPE_RES_RECORD, name, rrtype, rrclass, ttl, data, data_length1);
}


DnsResRecord* dns_res_record_construct_inetaddr (GType object_type, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, guint8* data, int data_length1) {
	DnsResRecord * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	DnsRRType _tmp2_;
	DnsRRClass _tmp3_;
	gint32 _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = data;
	_tmp0__length1 = data_length1;
	_vala_assert (_tmp0__length1 == 4, "data.length == 4");
	_tmp1_ = name;
	_tmp2_ = rrtype;
	_tmp3_ = rrclass;
	_tmp4_ = ttl;
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	self = (DnsResRecord*) dns_res_record_construct_from_data (object_type, _tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp5__length1);
	return self;
}


DnsResRecord* dns_res_record_new_inetaddr (const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, guint8* data, int data_length1) {
	return dns_res_record_construct_inetaddr (DNS_TYPE_RES_RECORD, name, rrtype, rrclass, ttl, data, data_length1);
}


DnsResRecord* dns_res_record_construct_ptr (GType object_type, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, const gchar* ptr, GError** error) {
	DnsResRecord * self = NULL;
	const gchar* _tmp0_;
	DnsRRType _tmp1_;
	DnsRRClass _tmp2_;
	gint32 _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	guint8* _tmp6_ = NULL;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gint __tmp7__size_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (ptr != NULL, NULL);
	self = (DnsResRecord*) g_object_new (object_type, NULL);
	_tmp0_ = name;
	dns_res_record_set_name (self, _tmp0_);
	_tmp1_ = rrtype;
	dns_res_record_set_rrtype (self, _tmp1_);
	_tmp2_ = rrclass;
	dns_res_record_set_rrclass (self, _tmp2_);
	_tmp3_ = ttl;
	dns_res_record_set_ttl (self, _tmp3_);
	_tmp4_ = ptr;
	_tmp6_ = dns_name_dotted_to_octets (_tmp4_, &_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	__tmp7__size_ = _tmp7__length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	dns_res_record_set_data (self, _tmp8_, _tmp7__length1);
	_tmp8_ = (g_free (_tmp8_), NULL);
	return self;
}


DnsResRecord* dns_res_record_new_ptr (const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, gint32 ttl, const gchar* ptr, GError** error) {
	return dns_res_record_construct_ptr (DNS_TYPE_RES_RECORD, name, rrtype, rrclass, ttl, ptr, error);
}


DnsResRecord* dns_res_record_construct (GType object_type) {
	DnsResRecord * self = NULL;
	self = (DnsResRecord*) g_object_new (object_type, NULL);
	return self;
}


DnsResRecord* dns_res_record_new (void) {
	return dns_res_record_construct (DNS_TYPE_RES_RECORD);
}


const gchar* dns_res_record_get_name (DnsResRecord* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void dns_res_record_set_name (DnsResRecord* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


DnsRRType dns_res_record_get_rrtype (DnsResRecord* self) {
	DnsRRType result;
	DnsRRType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rrtype;
	result = _tmp0_;
	return result;
}


static void dns_res_record_set_rrtype (DnsResRecord* self, DnsRRType value) {
	DnsRRType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rrtype = _tmp0_;
	g_object_notify ((GObject *) self, "rrtype");
}


DnsRRClass dns_res_record_get_rrclass (DnsResRecord* self) {
	DnsRRClass result;
	DnsRRClass _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rrclass;
	result = _tmp0_;
	return result;
}


static void dns_res_record_set_rrclass (DnsResRecord* self, DnsRRClass value) {
	DnsRRClass _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rrclass = _tmp0_;
	g_object_notify ((GObject *) self, "rrclass");
}


gint32 dns_res_record_get_ttl (DnsResRecord* self) {
	gint32 result;
	gint32 _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_ttl;
	result = _tmp0_;
	return result;
}


static void dns_res_record_set_ttl (DnsResRecord* self, gint32 value) {
	gint32 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ttl = _tmp0_;
	g_object_notify ((GObject *) self, "ttl");
}


guint8* dns_res_record_get_data (DnsResRecord* self, int* result_length1) {
	guint8* result;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data;
	_tmp0__length1 = self->priv->_data_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static void dns_res_record_set_data (DnsResRecord* self, guint8* value, int value_length1) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_data = (g_free (self->priv->_data), NULL);
	self->priv->_data = _tmp1_;
	self->priv->_data_length1 = _tmp1__length1;
	self->priv->__data_size_ = self->priv->_data_length1;
}


static void dns_res_record_class_init (DnsResRecordClass * klass) {
	dns_res_record_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DnsResRecordPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dns_res_record_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dns_res_record_set_property;
	G_OBJECT_CLASS (klass)->finalize = dns_res_record_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DNS_RES_RECORD_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DNS_RES_RECORD_RRTYPE, g_param_spec_enum ("rrtype", "rrtype", "rrtype", DNS_TYPE_RR_TYPE, DNS_RR_TYPE_A, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DNS_RES_RECORD_RRCLASS, g_param_spec_enum ("rrclass", "rrclass", "rrclass", DNS_TYPE_RR_CLASS, DNS_RR_CLASS_IN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DNS_RES_RECORD_TTL, g_param_spec_int ("ttl", "ttl", "ttl", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void dns_res_record_instance_init (DnsResRecord * self) {
	self->priv = DNS_RES_RECORD_GET_PRIVATE (self);
	self->priv->_rrtype = DNS_RR_TYPE_A;
	self->priv->_rrclass = DNS_RR_CLASS_IN;
}


static void dns_res_record_finalize (GObject* obj) {
	DnsResRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DNS_TYPE_RES_RECORD, DnsResRecord);
	_g_free0 (self->priv->_name);
	self->priv->_data = (g_free (self->priv->_data), NULL);
	G_OBJECT_CLASS (dns_res_record_parent_class)->finalize (obj);
}


GType dns_res_record_get_type (void) {
	static volatile gsize dns_res_record_type_id__volatile = 0;
	if (g_once_init_enter (&dns_res_record_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DnsResRecordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dns_res_record_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DnsResRecord), 0, (GInstanceInitFunc) dns_res_record_instance_init, NULL };
		GType dns_res_record_type_id;
		dns_res_record_type_id = g_type_register_static (G_TYPE_OBJECT, "DnsResRecord", &g_define_type_info, 0);
		g_once_init_leave (&dns_res_record_type_id__volatile, dns_res_record_type_id);
	}
	return dns_res_record_type_id__volatile;
}


static void _vala_dns_res_record_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DnsResRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DNS_TYPE_RES_RECORD, DnsResRecord);
	switch (property_id) {
		case DNS_RES_RECORD_NAME:
		g_value_set_string (value, dns_res_record_get_name (self));
		break;
		case DNS_RES_RECORD_RRTYPE:
		g_value_set_enum (value, dns_res_record_get_rrtype (self));
		break;
		case DNS_RES_RECORD_RRCLASS:
		g_value_set_enum (value, dns_res_record_get_rrclass (self));
		break;
		case DNS_RES_RECORD_TTL:
		g_value_set_int (value, dns_res_record_get_ttl (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dns_res_record_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DnsResRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DNS_TYPE_RES_RECORD, DnsResRecord);
	switch (property_id) {
		case DNS_RES_RECORD_NAME:
		dns_res_record_set_name (self, g_value_get_string (value));
		break;
		case DNS_RES_RECORD_RRTYPE:
		dns_res_record_set_rrtype (self, g_value_get_enum (value));
		break;
		case DNS_RES_RECORD_RRCLASS:
		dns_res_record_set_rrclass (self, g_value_get_enum (value));
		break;
		case DNS_RES_RECORD_TTL:
		dns_res_record_set_ttl (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


guint8* dns_name_dotted_to_octets (const gchar* name, int* result_length1, GError** error) {
	guint8* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_ = NULL;
	guint8* buf;
	gint buf_length1;
	gint _buf_size_;
	gint pos;
	const gchar* _tmp4_;
	guint8* _tmp39_;
	gint _tmp39__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (guint8, _tmp2_ + 1);
	buf = _tmp3_;
	buf_length1 = _tmp2_ + 1;
	_buf_size_ = buf_length1;
	pos = 0;
	_tmp4_ = name;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		guint8* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_;
		guint8 _tmp7_;
		_tmp5_ = buf;
		_tmp5__length1 = buf_length1;
		_tmp6_ = pos;
		pos = _tmp6_ + 1;
		_tmp5_[_tmp6_] = (guint8) 0;
		_tmp7_ = _tmp5_[_tmp6_];
	} else {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gboolean _tmp14_;
		const gchar* _tmp16_;
		gchar** _tmp17_;
		gchar** _tmp18_ = NULL;
		gchar** parts;
		gint parts_length1;
		gint _parts_size_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		_tmp8_ = name;
		_tmp9_ = name;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_substring (_tmp8_, (glong) (_tmp11_ - 1), (glong) (-1));
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strcmp0 (_tmp13_, ".") != 0;
		_g_free0 (_tmp13_);
		if (_tmp14_) {
			GError* _tmp15_;
			_tmp15_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "missing trail dot");
			_inner_error_ = _tmp15_;
			if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
				g_propagate_error (error, _inner_error_);
				buf = (g_free (buf), NULL);
				return NULL;
			} else {
				buf = (g_free (buf), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp16_ = name;
		_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, ".", 0);
		parts = _tmp18_;
		parts_length1 = _vala_array_length (_tmp17_);
		_parts_size_ = parts_length1;
		_tmp19_ = parts;
		_tmp19__length1 = parts_length1;
		{
			gchar** part_collection = NULL;
			gint part_collection_length1 = 0;
			gint _part_collection_size_ = 0;
			gint part_it = 0;
			part_collection = _tmp19_;
			part_collection_length1 = _tmp19__length1;
			for (part_it = 0; part_it < _tmp19__length1; part_it = part_it + 1) {
				gchar* _tmp20_;
				gchar* part = NULL;
				_tmp20_ = g_strdup (part_collection[part_it]);
				part = _tmp20_;
				{
					const gchar* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					const gchar* _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					guint8 b;
					guint8* _tmp28_;
					gint _tmp28__length1;
					gint _tmp29_;
					guint8 _tmp30_;
					guint8 _tmp31_;
					const gchar* _tmp32_;
					guint8* _tmp33_;
					gint _tmp33__length1;
					guint8* _tmp34_;
					gint _tmp34__length1;
					_tmp21_ = part;
					_tmp22_ = strlen (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp23_ > 255) {
						GError* _tmp24_;
						_tmp24_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "name part too long");
						_inner_error_ = _tmp24_;
						if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_g_free0 (part);
							parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
							buf = (g_free (buf), NULL);
							return NULL;
						} else {
							_g_free0 (part);
							parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
							buf = (g_free (buf), NULL);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return NULL;
						}
					}
					_tmp25_ = part;
					_tmp26_ = strlen (_tmp25_);
					_tmp27_ = _tmp26_;
					b = (guint8) _tmp27_;
					_tmp28_ = buf;
					_tmp28__length1 = buf_length1;
					_tmp29_ = pos;
					pos = _tmp29_ + 1;
					_tmp30_ = b;
					_tmp28_[_tmp29_] = _tmp30_;
					_tmp31_ = _tmp28_[_tmp29_];
					_tmp32_ = part;
					_tmp33_ = string_get_data (_tmp32_, &_tmp33__length1);
					_tmp34_ = _tmp33_;
					_tmp34__length1 = _tmp33__length1;
					{
						guint8* c_collection = NULL;
						gint c_collection_length1 = 0;
						gint _c_collection_size_ = 0;
						gint c_it = 0;
						c_collection = _tmp34_;
						c_collection_length1 = _tmp34__length1;
						for (c_it = 0; c_it < _tmp34__length1; c_it = c_it + 1) {
							guint8 c = 0U;
							c = c_collection[c_it];
							{
								guint8* _tmp35_;
								gint _tmp35__length1;
								gint _tmp36_;
								guint8 _tmp37_;
								guint8 _tmp38_;
								_tmp35_ = buf;
								_tmp35__length1 = buf_length1;
								_tmp36_ = pos;
								pos = _tmp36_ + 1;
								_tmp37_ = c;
								_tmp35_[_tmp36_] = _tmp37_;
								_tmp38_ = _tmp35_[_tmp36_];
							}
						}
					}
					_g_free0 (part);
				}
			}
		}
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp39_ = buf;
	_tmp39__length1 = buf_length1;
	if (result_length1) {
		*result_length1 = _tmp39__length1;
	}
	result = _tmp39_;
	return result;
}


DnsMessage* dns_message_construct_from_wire (GType object_type, guint8* message, int message_length1, gsize message_length, GError** error) {
	DnsMessage * self = NULL;
	gsize _tmp0_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	gsize _tmp6_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8 _tmp9_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	guint8 _tmp11_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	guint8 _tmp13_;
	guint8 m2;
	guint8 _tmp14_;
	guint8 _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8 _tmp17_;
	guint8 _tmp18_;
	guint8 _tmp19_;
	guint8 _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8 _tmp22_;
	guint8 _tmp23_;
	guint8 _tmp24_;
	guint8* _tmp25_;
	gint _tmp25__length1;
	guint8 _tmp26_;
	guint8 _tmp27_;
	guint8 _tmp28_;
	guint8* _tmp29_;
	gint _tmp29__length1;
	guint8 _tmp30_;
	guint8 _tmp31_;
	guint8 _tmp32_;
	guint8* _tmp33_;
	gint _tmp33__length1;
	guint8 _tmp34_;
	guint8 m3;
	guint8 _tmp35_;
	guint8 _tmp36_;
	guint8* _tmp37_;
	gint _tmp37__length1;
	guint8 _tmp38_;
	guint8 _tmp39_;
	guint8 _tmp40_;
	guint8* _tmp41_;
	gint _tmp41__length1;
	guint8 _tmp42_;
	guint8* _tmp43_;
	gint _tmp43__length1;
	guint8 _tmp44_;
	guint16 qdCount;
	guint8* _tmp45_;
	gint _tmp45__length1;
	guint8 _tmp46_;
	guint8* _tmp47_;
	gint _tmp47__length1;
	guint8 _tmp48_;
	guint16 anCount;
	guint8* _tmp49_;
	gint _tmp49__length1;
	guint8 _tmp50_;
	guint8* _tmp51_;
	gint _tmp51__length1;
	guint8 _tmp52_;
	guint16 nsCount;
	guint8* _tmp53_;
	gint _tmp53__length1;
	guint8 _tmp54_;
	guint8* _tmp55_;
	gint _tmp55__length1;
	guint8 _tmp56_;
	guint16 arCount;
	gsize pos;
	GError * _inner_error_ = NULL;
	self = (DnsMessage*) g_object_new (object_type, NULL);
	_tmp0_ = message_length;
	if (_tmp0_ == ((gsize) 0)) {
		guint8* _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = message;
		_tmp1__length1 = message_length1;
		message_length = (gsize) _tmp1__length1;
	}
	_tmp2_ = gee_array_list_new (DNS_TYPE_QUESTION_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->question_recs);
	self->question_recs = _tmp2_;
	_tmp3_ = gee_array_list_new (DNS_TYPE_RES_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->answer_recs);
	self->answer_recs = _tmp3_;
	_tmp4_ = gee_array_list_new (DNS_TYPE_RES_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->authority_recs);
	self->authority_recs = _tmp4_;
	_tmp5_ = gee_array_list_new (DNS_TYPE_RES_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->additional_recs);
	self->additional_recs = _tmp5_;
	_tmp6_ = message_length;
	if (_tmp6_ < ((gsize) 12)) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "Few bytes");
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = message;
	_tmp8__length1 = message_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = message;
	_tmp10__length1 = message_length1;
	_tmp11_ = _tmp10_[1];
	self->id = (guint16) ((_tmp9_ * 256) + _tmp11_);
	_tmp12_ = message;
	_tmp12__length1 = message_length1;
	_tmp13_ = _tmp12_[2];
	m2 = _tmp13_;
	_tmp14_ = m2;
	m2 = _tmp14_ & 128;
	_tmp15_ = m2;
	self->question = ((gint) _tmp15_) == 0;
	_tmp16_ = message;
	_tmp16__length1 = message_length1;
	_tmp17_ = _tmp16_[2];
	m2 = _tmp17_;
	_tmp18_ = m2;
	m2 = _tmp18_ & (((8 + 16) + 32) + 64);
	_tmp19_ = m2;
	m2 = (guint8) (_tmp19_ >> 3);
	_tmp20_ = m2;
	self->opcode = (DnsOperationCode) _tmp20_;
	_tmp21_ = message;
	_tmp21__length1 = message_length1;
	_tmp22_ = _tmp21_[2];
	m2 = _tmp22_;
	_tmp23_ = m2;
	m2 = _tmp23_ & 4;
	_tmp24_ = m2;
	self->authoritative_answer = ((gint) _tmp24_) > 0;
	_tmp25_ = message;
	_tmp25__length1 = message_length1;
	_tmp26_ = _tmp25_[2];
	m2 = _tmp26_;
	_tmp27_ = m2;
	m2 = _tmp27_ & 2;
	_tmp28_ = m2;
	self->truncation = ((gint) _tmp28_) > 0;
	_tmp29_ = message;
	_tmp29__length1 = message_length1;
	_tmp30_ = _tmp29_[2];
	m2 = _tmp30_;
	_tmp31_ = m2;
	m2 = _tmp31_ & 1;
	_tmp32_ = m2;
	self->recursion_desired = ((gint) _tmp32_) > 0;
	_tmp33_ = message;
	_tmp33__length1 = message_length1;
	_tmp34_ = _tmp33_[3];
	m3 = _tmp34_;
	_tmp35_ = m3;
	m3 = _tmp35_ & 128;
	_tmp36_ = m3;
	self->recursion_available = ((gint) _tmp36_) > 0;
	_tmp37_ = message;
	_tmp37__length1 = message_length1;
	_tmp38_ = _tmp37_[3];
	m3 = _tmp38_;
	_tmp39_ = m3;
	m3 = _tmp39_ & 15;
	_tmp40_ = m3;
	self->rcode = (DnsResponseCode) _tmp40_;
	_tmp41_ = message;
	_tmp41__length1 = message_length1;
	_tmp42_ = _tmp41_[4];
	_tmp43_ = message;
	_tmp43__length1 = message_length1;
	_tmp44_ = _tmp43_[5];
	qdCount = (guint16) ((_tmp42_ * 256) + _tmp44_);
	_tmp45_ = message;
	_tmp45__length1 = message_length1;
	_tmp46_ = _tmp45_[6];
	_tmp47_ = message;
	_tmp47__length1 = message_length1;
	_tmp48_ = _tmp47_[7];
	anCount = (guint16) ((_tmp46_ * 256) + _tmp48_);
	_tmp49_ = message;
	_tmp49__length1 = message_length1;
	_tmp50_ = _tmp49_[8];
	_tmp51_ = message;
	_tmp51__length1 = message_length1;
	_tmp52_ = _tmp51_[9];
	nsCount = (guint16) ((_tmp50_ * 256) + _tmp52_);
	_tmp53_ = message;
	_tmp53__length1 = message_length1;
	_tmp54_ = _tmp53_[10];
	_tmp55_ = message;
	_tmp55__length1 = message_length1;
	_tmp56_ = _tmp55_[11];
	arCount = (guint16) ((_tmp54_ * 256) + _tmp56_);
	pos = (gsize) 12;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp57_;
			_tmp57_ = TRUE;
			while (TRUE) {
				gboolean _tmp58_;
				gint _tmp60_;
				guint16 _tmp61_;
				gchar* qname = NULL;
				DnsRRType rrtype = 0;
				DnsRRClass rrclass = 0;
				guint8* _tmp62_;
				gint _tmp62__length1;
				gsize _tmp63_;
				gchar* _tmp64_ = NULL;
				DnsRRType _tmp65_ = 0;
				DnsRRClass _tmp66_ = 0;
				const gchar* _tmp67_;
				DnsRRType _tmp68_;
				DnsRRClass _tmp69_;
				DnsQuestionRecord* _tmp70_;
				DnsQuestionRecord* qr;
				GeeArrayList* _tmp71_;
				DnsQuestionRecord* _tmp72_;
				_tmp58_ = _tmp57_;
				if (!_tmp58_) {
					gint _tmp59_;
					_tmp59_ = i;
					i = _tmp59_ + 1;
				}
				_tmp57_ = FALSE;
				_tmp60_ = i;
				_tmp61_ = qdCount;
				if (!(_tmp60_ < ((gint) _tmp61_))) {
					break;
				}
				_tmp62_ = message;
				_tmp62__length1 = message_length1;
				_tmp63_ = message_length;
				dns_message_name_type_class (self, _tmp62_, _tmp63_, &pos, &_tmp64_, &_tmp65_, &_tmp66_, &_inner_error_);
				_g_free0 (qname);
				qname = _tmp64_;
				rrtype = _tmp65_;
				rrclass = _tmp66_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (qname);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_free0 (qname);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp67_ = qname;
				_tmp68_ = rrtype;
				_tmp69_ = rrclass;
				_tmp70_ = dns_question_record_new (_tmp67_, _tmp68_, _tmp69_);
				qr = _tmp70_;
				_tmp71_ = self->question_recs;
				_tmp72_ = qr;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp71_, _tmp72_);
				_g_object_unref0 (qr);
				_g_free0 (qname);
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp73_;
			_tmp73_ = TRUE;
			while (TRUE) {
				gboolean _tmp74_;
				gint _tmp76_;
				guint16 _tmp77_;
				DnsResRecord* rr = NULL;
				guint8* _tmp78_;
				gint _tmp78__length1;
				gsize _tmp79_;
				DnsResRecord* _tmp80_ = NULL;
				GeeArrayList* _tmp81_;
				DnsResRecord* _tmp82_;
				_tmp74_ = _tmp73_;
				if (!_tmp74_) {
					gint _tmp75_;
					_tmp75_ = i;
					i = _tmp75_ + 1;
				}
				_tmp73_ = FALSE;
				_tmp76_ = i;
				_tmp77_ = anCount;
				if (!(_tmp76_ < ((gint) _tmp77_))) {
					break;
				}
				_tmp78_ = message;
				_tmp78__length1 = message_length1;
				_tmp79_ = message_length;
				dns_message_res_record (self, _tmp78_, _tmp79_, &pos, &_tmp80_, &_inner_error_);
				_g_object_unref0 (rr);
				rr = _tmp80_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (rr);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_object_unref0 (rr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp81_ = self->answer_recs;
				_tmp82_ = rr;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp81_, _tmp82_);
				_g_object_unref0 (rr);
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp83_;
			_tmp83_ = TRUE;
			while (TRUE) {
				gboolean _tmp84_;
				gint _tmp86_;
				guint16 _tmp87_;
				DnsResRecord* rr = NULL;
				guint8* _tmp88_;
				gint _tmp88__length1;
				gsize _tmp89_;
				DnsResRecord* _tmp90_ = NULL;
				GeeArrayList* _tmp91_;
				DnsResRecord* _tmp92_;
				_tmp84_ = _tmp83_;
				if (!_tmp84_) {
					gint _tmp85_;
					_tmp85_ = i;
					i = _tmp85_ + 1;
				}
				_tmp83_ = FALSE;
				_tmp86_ = i;
				_tmp87_ = nsCount;
				if (!(_tmp86_ < ((gint) _tmp87_))) {
					break;
				}
				_tmp88_ = message;
				_tmp88__length1 = message_length1;
				_tmp89_ = message_length;
				dns_message_res_record (self, _tmp88_, _tmp89_, &pos, &_tmp90_, &_inner_error_);
				_g_object_unref0 (rr);
				rr = _tmp90_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (rr);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_object_unref0 (rr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp91_ = self->authority_recs;
				_tmp92_ = rr;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp91_, _tmp92_);
				_g_object_unref0 (rr);
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp93_;
			_tmp93_ = TRUE;
			while (TRUE) {
				gboolean _tmp94_;
				gint _tmp96_;
				guint16 _tmp97_;
				DnsResRecord* rr = NULL;
				guint8* _tmp98_;
				gint _tmp98__length1;
				gsize _tmp99_;
				DnsResRecord* _tmp100_ = NULL;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_;
				gboolean _tmp106_;
				GeeArrayList* _tmp107_;
				DnsResRecord* _tmp108_;
				_tmp94_ = _tmp93_;
				if (!_tmp94_) {
					gint _tmp95_;
					_tmp95_ = i;
					i = _tmp95_ + 1;
				}
				_tmp93_ = FALSE;
				_tmp96_ = i;
				_tmp97_ = arCount;
				if (!(_tmp96_ < ((gint) _tmp97_))) {
					break;
				}
				_tmp98_ = message;
				_tmp98__length1 = message_length1;
				_tmp99_ = message_length;
				dns_message_res_record (self, _tmp98_, _tmp99_, &pos, &_tmp100_, &_inner_error_);
				_g_object_unref0 (rr);
				rr = _tmp100_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (rr);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_object_unref0 (rr);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp102_ = self->question;
				if (_tmp102_) {
					DnsResRecord* _tmp103_;
					DnsRRType _tmp104_;
					DnsRRType _tmp105_;
					_tmp103_ = rr;
					_tmp104_ = dns_res_record_get_rrtype (_tmp103_);
					_tmp105_ = _tmp104_;
					_tmp101_ = _tmp105_ == DNS_RR_TYPE_OPT;
				} else {
					_tmp101_ = FALSE;
				}
				_tmp106_ = _tmp101_;
				if (_tmp106_) {
				}
				_tmp107_ = self->additional_recs;
				_tmp108_ = rr;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp107_, _tmp108_);
				_g_object_unref0 (rr);
			}
		}
	}
	return self;
}


DnsMessage* dns_message_new_from_wire (guint8* message, int message_length1, gsize message_length, GError** error) {
	return dns_message_construct_from_wire (DNS_TYPE_MESSAGE, message, message_length1, message_length, error);
}


static void dns_message_name_type_class (DnsMessage* self, guint8* message, gsize message_length, gsize* pos, gchar** name, DnsRRType* rrtype, DnsRRClass* rrclass, GError** error) {
	gchar* _vala_name = NULL;
	DnsRRType _vala_rrtype = 0;
	DnsRRClass _vala_rrclass = 0;
	gchar* _tmp0_;
	gsize _tmp37_;
	gsize _tmp38_;
	gsize _tmp39_;
	guint8* _tmp41_;
	gsize _tmp42_;
	guint8 _tmp43_;
	guint8* _tmp44_;
	gsize _tmp45_;
	guint8 _tmp46_;
	guint8* _tmp47_;
	gsize _tmp48_;
	guint8 _tmp49_;
	guint8* _tmp50_;
	gsize _tmp51_;
	guint8 _tmp52_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_name);
	_vala_name = _tmp0_;
	while (TRUE) {
		gsize _tmp1_;
		gsize _tmp2_;
		guint8* _tmp4_;
		gsize _tmp5_;
		guint8 _tmp6_;
		gsize len;
		gsize _tmp7_;
		gsize _tmp8_;
		gsize _tmp10_;
		gsize _tmp11_;
		gsize _tmp12_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gsize _tmp35_;
		gsize _tmp36_;
		_tmp1_ = message_length;
		_tmp2_ = *pos;
		if (_tmp1_ < (_tmp2_ + 1)) {
			GError* _tmp3_;
			_tmp3_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "Few bytes");
			_inner_error_ = _tmp3_;
			if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp4_ = message;
		_tmp5_ = *pos;
		_tmp6_ = _tmp4_[_tmp5_];
		len = (gsize) _tmp6_;
		_tmp7_ = len;
		if (_tmp7_ == ((gsize) 0)) {
			break;
		}
		_tmp8_ = len;
		if (_tmp8_ >= ((gsize) 192)) {
			GError* _tmp9_;
			_tmp9_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_UNSUPPORTED_MESSAGE, "compression mechanism not supported yet");
			_inner_error_ = _tmp9_;
			if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp10_ = message_length;
		_tmp11_ = *pos;
		_tmp12_ = len;
		if (_tmp10_ < ((_tmp11_ + _tmp12_) + 1)) {
			GError* _tmp13_;
			_tmp13_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "Few bytes");
			_inner_error_ = _tmp13_;
			if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			gsize _tmp14_;
			gsize j;
			_tmp14_ = *pos;
			j = _tmp14_ + 1;
			{
				gboolean _tmp15_;
				_tmp15_ = TRUE;
				while (TRUE) {
					gboolean _tmp16_;
					gsize _tmp18_;
					gsize _tmp19_;
					gsize _tmp20_;
					guint8* _tmp21_;
					gsize _tmp22_;
					guint8 _tmp23_;
					guint8* _tmp25_;
					gsize _tmp26_;
					guint8 _tmp27_;
					gchar c;
					const gchar* _tmp28_;
					gchar _tmp29_;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					gchar* _tmp32_;
					_tmp16_ = _tmp15_;
					if (!_tmp16_) {
						gsize _tmp17_;
						_tmp17_ = j;
						j = _tmp17_ + 1;
					}
					_tmp15_ = FALSE;
					_tmp18_ = j;
					_tmp19_ = *pos;
					_tmp20_ = len;
					if (!(_tmp18_ < ((_tmp19_ + _tmp20_) + 1))) {
						break;
					}
					_tmp21_ = message;
					_tmp22_ = j;
					_tmp23_ = _tmp21_[_tmp22_];
					if (((gint) _tmp23_) == 0) {
						GError* _tmp24_;
						_tmp24_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "\\0 in name");
						_inner_error_ = _tmp24_;
						if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
							g_propagate_error (error, _inner_error_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp25_ = message;
					_tmp26_ = j;
					_tmp27_ = _tmp25_[_tmp26_];
					c = (gchar) _tmp27_;
					_tmp28_ = _vala_name;
					_tmp29_ = c;
					_tmp30_ = g_strdup_printf ("%c", _tmp29_);
					_tmp31_ = _tmp30_;
					_tmp32_ = g_strconcat (_tmp28_, _tmp31_, NULL);
					_g_free0 (_vala_name);
					_vala_name = _tmp32_;
					_g_free0 (_tmp31_);
				}
			}
		}
		_tmp33_ = _vala_name;
		_tmp34_ = g_strconcat (_tmp33_, ".", NULL);
		_g_free0 (_vala_name);
		_vala_name = _tmp34_;
		_tmp35_ = *pos;
		_tmp36_ = len;
		*pos = _tmp35_ + (_tmp36_ + 1);
	}
	_tmp37_ = *pos;
	*pos = _tmp37_ + 1;
	_tmp38_ = message_length;
	_tmp39_ = *pos;
	if (_tmp38_ < (_tmp39_ + 4)) {
		GError* _tmp40_;
		_tmp40_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "Few bytes");
		_inner_error_ = _tmp40_;
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp41_ = message;
	_tmp42_ = *pos;
	*pos = _tmp42_ + 1;
	_tmp43_ = _tmp41_[_tmp42_];
	_tmp44_ = message;
	_tmp45_ = *pos;
	*pos = _tmp45_ + 1;
	_tmp46_ = _tmp44_[_tmp45_];
	_vala_rrtype = (DnsRRType) ((_tmp43_ * 256) + _tmp46_);
	_tmp47_ = message;
	_tmp48_ = *pos;
	*pos = _tmp48_ + 1;
	_tmp49_ = _tmp47_[_tmp48_];
	_tmp50_ = message;
	_tmp51_ = *pos;
	*pos = _tmp51_ + 1;
	_tmp52_ = _tmp50_[_tmp51_];
	_vala_rrclass = (DnsRRClass) ((_tmp49_ * 256) + _tmp52_);
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	if (rrtype) {
		*rrtype = _vala_rrtype;
	}
	if (rrclass) {
		*rrclass = _vala_rrclass;
	}
}


static void dns_message_res_record (DnsMessage* self, guint8* message, gsize message_length, gsize* pos, DnsResRecord** rr, GError** error) {
	DnsResRecord* _vala_rr = NULL;
	gchar* rname = NULL;
	DnsRRType rrtype = 0;
	DnsRRClass rrclass = 0;
	guint8* _tmp0_;
	gsize _tmp1_;
	gchar* _tmp2_ = NULL;
	DnsRRType _tmp3_ = 0;
	DnsRRClass _tmp4_ = 0;
	gsize _tmp5_;
	gsize _tmp6_;
	gint32 ttl;
	gint32 _tmp8_;
	gint32 _tmp9_;
	guint8* _tmp10_;
	gsize _tmp11_;
	guint8 _tmp12_;
	gint32 _tmp13_;
	gint32 _tmp14_;
	guint8* _tmp15_;
	gsize _tmp16_;
	guint8 _tmp17_;
	gint32 _tmp18_;
	gint32 _tmp19_;
	guint8* _tmp20_;
	gsize _tmp21_;
	guint8 _tmp22_;
	gint32 _tmp23_;
	gint32 _tmp24_;
	guint8* _tmp25_;
	gsize _tmp26_;
	guint8 _tmp27_;
	gsize _tmp28_;
	gsize _tmp29_;
	guint8* _tmp31_;
	gsize _tmp32_;
	guint8 _tmp33_;
	guint8* _tmp34_;
	gsize _tmp35_;
	guint8 _tmp36_;
	guint16 rdlen;
	gsize _tmp37_;
	gsize _tmp38_;
	guint16 _tmp39_;
	guint16 _tmp41_;
	guint8* _tmp42_ = NULL;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	const gchar* _tmp54_;
	DnsRRType _tmp55_;
	DnsRRClass _tmp56_;
	gint32 _tmp57_;
	guint8* _tmp58_;
	gint _tmp58__length1;
	DnsResRecord* _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = message;
	_tmp1_ = message_length;
	dns_message_name_type_class (self, _tmp0_, _tmp1_, pos, &_tmp2_, &_tmp3_, &_tmp4_, &_inner_error_);
	_g_free0 (rname);
	rname = _tmp2_;
	rrtype = _tmp3_;
	rrclass = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (rname);
			return;
		} else {
			_g_free0 (rname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp5_ = message_length;
	_tmp6_ = *pos;
	if (_tmp5_ < (_tmp6_ + 4)) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "Few bytes");
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (rname);
			return;
		} else {
			_g_free0 (rname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	ttl = (gint32) 0;
	_tmp8_ = ttl;
	ttl = _tmp8_ * 256;
	_tmp9_ = ttl;
	_tmp10_ = message;
	_tmp11_ = *pos;
	*pos = _tmp11_ + 1;
	_tmp12_ = _tmp10_[_tmp11_];
	ttl = _tmp9_ + _tmp12_;
	_tmp13_ = ttl;
	ttl = _tmp13_ * 256;
	_tmp14_ = ttl;
	_tmp15_ = message;
	_tmp16_ = *pos;
	*pos = _tmp16_ + 1;
	_tmp17_ = _tmp15_[_tmp16_];
	ttl = _tmp14_ + _tmp17_;
	_tmp18_ = ttl;
	ttl = _tmp18_ * 256;
	_tmp19_ = ttl;
	_tmp20_ = message;
	_tmp21_ = *pos;
	*pos = _tmp21_ + 1;
	_tmp22_ = _tmp20_[_tmp21_];
	ttl = _tmp19_ + _tmp22_;
	_tmp23_ = ttl;
	ttl = _tmp23_ * 256;
	_tmp24_ = ttl;
	_tmp25_ = message;
	_tmp26_ = *pos;
	*pos = _tmp26_ + 1;
	_tmp27_ = _tmp25_[_tmp26_];
	ttl = _tmp24_ + _tmp27_;
	_tmp28_ = message_length;
	_tmp29_ = *pos;
	if (_tmp28_ < (_tmp29_ + 2)) {
		GError* _tmp30_;
		_tmp30_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "Few bytes");
		_inner_error_ = _tmp30_;
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (rname);
			return;
		} else {
			_g_free0 (rname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp31_ = message;
	_tmp32_ = *pos;
	*pos = _tmp32_ + 1;
	_tmp33_ = _tmp31_[_tmp32_];
	_tmp34_ = message;
	_tmp35_ = *pos;
	*pos = _tmp35_ + 1;
	_tmp36_ = _tmp34_[_tmp35_];
	rdlen = (guint16) ((_tmp33_ * 256) + _tmp36_);
	_tmp37_ = message_length;
	_tmp38_ = *pos;
	_tmp39_ = rdlen;
	if (_tmp37_ < (_tmp38_ + _tmp39_)) {
		GError* _tmp40_;
		_tmp40_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "Few bytes");
		_inner_error_ = _tmp40_;
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (rname);
			return;
		} else {
			_g_free0 (rname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp41_ = rdlen;
	_tmp42_ = g_new0 (guint8, _tmp41_);
	data = _tmp42_;
	data_length1 = _tmp41_;
	_data_size_ = data_length1;
	{
		guint16 i;
		i = (guint16) 0;
		{
			gboolean _tmp43_;
			_tmp43_ = TRUE;
			while (TRUE) {
				gboolean _tmp44_;
				guint16 _tmp46_;
				guint16 _tmp47_;
				guint8* _tmp48_;
				gint _tmp48__length1;
				guint16 _tmp49_;
				guint8* _tmp50_;
				gsize _tmp51_;
				guint8 _tmp52_;
				guint8 _tmp53_;
				_tmp44_ = _tmp43_;
				if (!_tmp44_) {
					guint16 _tmp45_;
					_tmp45_ = i;
					i = _tmp45_ + 1;
				}
				_tmp43_ = FALSE;
				_tmp46_ = i;
				_tmp47_ = rdlen;
				if (!(_tmp46_ < _tmp47_)) {
					break;
				}
				_tmp48_ = data;
				_tmp48__length1 = data_length1;
				_tmp49_ = i;
				_tmp50_ = message;
				_tmp51_ = *pos;
				*pos = _tmp51_ + 1;
				_tmp52_ = _tmp50_[_tmp51_];
				_tmp48_[_tmp49_] = _tmp52_;
				_tmp53_ = _tmp48_[_tmp49_];
			}
		}
	}
	_tmp54_ = rname;
	_tmp55_ = rrtype;
	_tmp56_ = rrclass;
	_tmp57_ = ttl;
	_tmp58_ = data;
	_tmp58__length1 = data_length1;
	_tmp59_ = dns_res_record_new_from_data (_tmp54_, _tmp55_, _tmp56_, _tmp57_, _tmp58_, _tmp58__length1);
	_g_object_unref0 (_vala_rr);
	_vala_rr = _tmp59_;
	data = (g_free (data), NULL);
	_g_free0 (rname);
	if (rr) {
		*rr = _vala_rr;
	} else {
		_g_object_unref0 (_vala_rr);
	}
}


DnsMessage* dns_message_make_response (DnsMessage* self) {
	DnsMessage* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->question;
	if (_tmp0_) {
		DnsMessage* _tmp1_;
		_tmp1_ = dns_message_new_response (self);
		result = _tmp1_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static DnsMessage* dns_message_construct_response (GType object_type, DnsMessage* q) {
	DnsMessage * self = NULL;
	DnsMessage* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (q != NULL, NULL);
	self = (DnsMessage*) g_object_new (object_type, NULL);
	_tmp0_ = q;
	_tmp1_ = _tmp0_->question;
	if (_tmp1_) {
		DnsMessage* _tmp2_;
		guint16 _tmp3_;
		DnsMessage* _tmp4_;
		DnsOperationCode _tmp5_;
		DnsMessage* _tmp6_;
		gboolean _tmp7_;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		guint8* _tmp26_ = NULL;
		guint8* _tmp27_;
		gint _tmp27__length1;
		DnsResRecord* _tmp28_;
		DnsResRecord* _tmp29_;
		DnsResRecord* optrr;
		GeeArrayList* _tmp30_;
		DnsResRecord* _tmp31_;
		self->question = FALSE;
		_tmp2_ = q;
		_tmp3_ = _tmp2_->id;
		self->id = _tmp3_;
		_tmp4_ = q;
		_tmp5_ = _tmp4_->opcode;
		self->opcode = _tmp5_;
		self->authoritative_answer = TRUE;
		self->truncation = FALSE;
		_tmp6_ = q;
		_tmp7_ = _tmp6_->recursion_desired;
		self->recursion_desired = _tmp7_;
		self->recursion_available = TRUE;
		self->rcode = DNS_RESPONSE_CODE_NO_ERROR;
		_tmp8_ = gee_array_list_new (DNS_TYPE_QUESTION_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->question_recs);
		self->question_recs = _tmp8_;
		_tmp9_ = gee_array_list_new (DNS_TYPE_RES_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->answer_recs);
		self->answer_recs = _tmp9_;
		_tmp10_ = gee_array_list_new (DNS_TYPE_RES_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->authority_recs);
		self->authority_recs = _tmp10_;
		_tmp11_ = gee_array_list_new (DNS_TYPE_RES_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		_g_object_unref0 (self->additional_recs);
		self->additional_recs = _tmp11_;
		{
			DnsMessage* _tmp12_;
			GeeArrayList* _tmp13_;
			GeeArrayList* _tmp14_;
			GeeArrayList* _qs_list;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _qs_size;
			gint _qs_index;
			_tmp12_ = q;
			_tmp13_ = _tmp12_->question_recs;
			_tmp14_ = _g_object_ref0 (_tmp13_);
			_qs_list = _tmp14_;
			_tmp15_ = _qs_list;
			_tmp16_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_qs_size = _tmp17_;
			_qs_index = -1;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				GeeArrayList* _tmp21_;
				gint _tmp22_;
				gpointer _tmp23_ = NULL;
				DnsQuestionRecord* qs;
				GeeArrayList* _tmp24_;
				DnsQuestionRecord* _tmp25_;
				_tmp18_ = _qs_index;
				_qs_index = _tmp18_ + 1;
				_tmp19_ = _qs_index;
				_tmp20_ = _qs_size;
				if (!(_tmp19_ < _tmp20_)) {
					break;
				}
				_tmp21_ = _qs_list;
				_tmp22_ = _qs_index;
				_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp22_);
				qs = (DnsQuestionRecord*) _tmp23_;
				_tmp24_ = self->question_recs;
				_tmp25_ = qs;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
				_g_object_unref0 (qs);
			}
			_g_object_unref0 (_qs_list);
		}
		_tmp26_ = g_new0 (guint8, 0);
		_tmp27_ = _tmp26_;
		_tmp27__length1 = 0;
		_tmp28_ = dns_res_record_new_from_data ("", DNS_RR_TYPE_OPT, (DnsRRClass) 512, (gint32) 0, _tmp27_, 0);
		_tmp29_ = _tmp28_;
		_tmp27_ = (g_free (_tmp27_), NULL);
		optrr = _tmp29_;
		_tmp30_ = self->additional_recs;
		_tmp31_ = optrr;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, _tmp31_);
		_g_object_unref0 (optrr);
	}
	return self;
}


static DnsMessage* dns_message_new_response (DnsMessage* q) {
	return dns_message_construct_response (DNS_TYPE_MESSAGE, q);
}


static void _vala_array_add1 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add2 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add3 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add4 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add5 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add6 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add7 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add8 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add9 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add10 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add11 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add12 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add13 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add14 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add15 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _vala_array_add16 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


guint8* dns_message_to_wire (DnsMessage* self, int* result_length1) {
	guint8* result = NULL;
	guint8* _tmp0_ = NULL;
	guint8* ret;
	gint ret_length1;
	gint _ret_size_;
	guint8 o0 = 0U;
	guint8 o1 = 0U;
	guint8 o2 = 0U;
	guint8 o3 = 0U;
	guint16 _tmp1_;
	guint8 _tmp2_ = 0U;
	guint8 _tmp3_ = 0U;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8 _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8 _tmp7_;
	DnsOperationCode _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp11_;
	gboolean _tmp13_;
	gboolean _tmp15_;
	guint8* _tmp17_;
	gint _tmp17__length1;
	guint8 _tmp18_;
	DnsResponseCode _tmp19_;
	gboolean _tmp20_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	guint8 _tmp23_;
	GeeArrayList* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	guint16 qdcount;
	guint16 _tmp27_;
	guint8 _tmp28_ = 0U;
	guint8 _tmp29_ = 0U;
	guint8* _tmp30_;
	gint _tmp30__length1;
	guint8 _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	guint8 _tmp33_;
	GeeArrayList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	guint16 ancount;
	guint16 _tmp37_;
	guint8 _tmp38_ = 0U;
	guint8 _tmp39_ = 0U;
	guint8* _tmp40_;
	gint _tmp40__length1;
	guint8 _tmp41_;
	guint8* _tmp42_;
	gint _tmp42__length1;
	guint8 _tmp43_;
	GeeArrayList* _tmp44_;
	gint _tmp45_;
	gint _tmp46_;
	guint16 nscount;
	guint16 _tmp47_;
	guint8 _tmp48_ = 0U;
	guint8 _tmp49_ = 0U;
	guint8* _tmp50_;
	gint _tmp50__length1;
	guint8 _tmp51_;
	guint8* _tmp52_;
	gint _tmp52__length1;
	guint8 _tmp53_;
	GeeArrayList* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	guint16 arcount;
	guint16 _tmp57_;
	guint8 _tmp58_ = 0U;
	guint8 _tmp59_ = 0U;
	guint8* _tmp60_;
	gint _tmp60__length1;
	guint8 _tmp61_;
	guint8* _tmp62_;
	gint _tmp62__length1;
	guint8 _tmp63_;
	guint8* _tmp140_;
	gint _tmp140__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (guint8, 0);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = self->id;
	dns_message_add_uint16 (self, _tmp1_, &_tmp2_, &_tmp3_);
	o0 = _tmp2_;
	o1 = _tmp3_;
	_tmp4_ = ret;
	_tmp4__length1 = ret_length1;
	_tmp5_ = o0;
	_vala_array_add1 (&ret, &ret_length1, &_ret_size_, _tmp5_);
	_tmp6_ = ret;
	_tmp6__length1 = ret_length1;
	_tmp7_ = o1;
	_vala_array_add2 (&ret, &ret_length1, &_ret_size_, _tmp7_);
	_tmp8_ = self->opcode;
	o0 = (guint8) (((gint) _tmp8_) * 8);
	_tmp9_ = self->question;
	if (!_tmp9_) {
		guint8 _tmp10_;
		_tmp10_ = o0;
		o0 = (guint8) (_tmp10_ + 128);
	}
	_tmp11_ = self->authoritative_answer;
	if (_tmp11_) {
		guint8 _tmp12_;
		_tmp12_ = o0;
		o0 = (guint8) (_tmp12_ + 4);
	}
	_tmp13_ = self->truncation;
	if (_tmp13_) {
		guint8 _tmp14_;
		_tmp14_ = o0;
		o0 = (guint8) (_tmp14_ + 2);
	}
	_tmp15_ = self->recursion_desired;
	if (_tmp15_) {
		guint8 _tmp16_;
		_tmp16_ = o0;
		o0 = (guint8) (_tmp16_ + 1);
	}
	_tmp17_ = ret;
	_tmp17__length1 = ret_length1;
	_tmp18_ = o0;
	_vala_array_add3 (&ret, &ret_length1, &_ret_size_, _tmp18_);
	_tmp19_ = self->rcode;
	o0 = (guint8) _tmp19_;
	_tmp20_ = self->recursion_available;
	if (_tmp20_) {
		guint8 _tmp21_;
		_tmp21_ = o0;
		o0 = (guint8) (_tmp21_ + 128);
	}
	_tmp22_ = ret;
	_tmp22__length1 = ret_length1;
	_tmp23_ = o0;
	_vala_array_add4 (&ret, &ret_length1, &_ret_size_, _tmp23_);
	_tmp24_ = self->question_recs;
	_tmp25_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp24_);
	_tmp26_ = _tmp25_;
	qdcount = (guint16) _tmp26_;
	_tmp27_ = qdcount;
	dns_message_add_uint16 (self, _tmp27_, &_tmp28_, &_tmp29_);
	o0 = _tmp28_;
	o1 = _tmp29_;
	_tmp30_ = ret;
	_tmp30__length1 = ret_length1;
	_tmp31_ = o0;
	_vala_array_add5 (&ret, &ret_length1, &_ret_size_, _tmp31_);
	_tmp32_ = ret;
	_tmp32__length1 = ret_length1;
	_tmp33_ = o1;
	_vala_array_add6 (&ret, &ret_length1, &_ret_size_, _tmp33_);
	_tmp34_ = self->answer_recs;
	_tmp35_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	ancount = (guint16) _tmp36_;
	_tmp37_ = ancount;
	dns_message_add_uint16 (self, _tmp37_, &_tmp38_, &_tmp39_);
	o0 = _tmp38_;
	o1 = _tmp39_;
	_tmp40_ = ret;
	_tmp40__length1 = ret_length1;
	_tmp41_ = o0;
	_vala_array_add7 (&ret, &ret_length1, &_ret_size_, _tmp41_);
	_tmp42_ = ret;
	_tmp42__length1 = ret_length1;
	_tmp43_ = o1;
	_vala_array_add8 (&ret, &ret_length1, &_ret_size_, _tmp43_);
	_tmp44_ = self->authority_recs;
	_tmp45_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp44_);
	_tmp46_ = _tmp45_;
	nscount = (guint16) _tmp46_;
	_tmp47_ = nscount;
	dns_message_add_uint16 (self, _tmp47_, &_tmp48_, &_tmp49_);
	o0 = _tmp48_;
	o1 = _tmp49_;
	_tmp50_ = ret;
	_tmp50__length1 = ret_length1;
	_tmp51_ = o0;
	_vala_array_add9 (&ret, &ret_length1, &_ret_size_, _tmp51_);
	_tmp52_ = ret;
	_tmp52__length1 = ret_length1;
	_tmp53_ = o1;
	_vala_array_add10 (&ret, &ret_length1, &_ret_size_, _tmp53_);
	_tmp54_ = self->additional_recs;
	_tmp55_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp54_);
	_tmp56_ = _tmp55_;
	arcount = (guint16) _tmp56_;
	_tmp57_ = arcount;
	dns_message_add_uint16 (self, _tmp57_, &_tmp58_, &_tmp59_);
	o0 = _tmp58_;
	o1 = _tmp59_;
	_tmp60_ = ret;
	_tmp60__length1 = ret_length1;
	_tmp61_ = o0;
	_vala_array_add11 (&ret, &ret_length1, &_ret_size_, _tmp61_);
	_tmp62_ = ret;
	_tmp62__length1 = ret_length1;
	_tmp63_ = o1;
	_vala_array_add12 (&ret, &ret_length1, &_ret_size_, _tmp63_);
	{
		GeeArrayList* _tmp64_;
		GeeArrayList* _tmp65_;
		GeeArrayList* _rec_list;
		GeeArrayList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _rec_size;
		gint _rec_index;
		_tmp64_ = self->question_recs;
		_tmp65_ = _g_object_ref0 (_tmp64_);
		_rec_list = _tmp65_;
		_tmp66_ = _rec_list;
		_tmp67_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_rec_size = _tmp68_;
		_rec_index = -1;
		while (TRUE) {
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			GeeArrayList* _tmp72_;
			gint _tmp73_;
			gpointer _tmp74_ = NULL;
			DnsQuestionRecord* rec;
			guint8* buf = NULL;
			gint buf_length1 = 0;
			gint _buf_size_ = 0;
			DnsQuestionRecord* _tmp75_;
			const gchar* _tmp76_;
			const gchar* _tmp77_;
			DnsQuestionRecord* _tmp78_;
			DnsRRType _tmp79_;
			DnsRRType _tmp80_;
			DnsQuestionRecord* _tmp81_;
			DnsRRClass _tmp82_;
			DnsRRClass _tmp83_;
			guint8* _tmp84_ = NULL;
			gint _tmp85_ = 0;
			guint8* _tmp86_;
			gint _tmp86__length1;
			_tmp69_ = _rec_index;
			_rec_index = _tmp69_ + 1;
			_tmp70_ = _rec_index;
			_tmp71_ = _rec_size;
			if (!(_tmp70_ < _tmp71_)) {
				break;
			}
			_tmp72_ = _rec_list;
			_tmp73_ = _rec_index;
			_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp72_, _tmp73_);
			rec = (DnsQuestionRecord*) _tmp74_;
			_tmp75_ = rec;
			_tmp76_ = dns_question_record_get_name (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = rec;
			_tmp79_ = dns_question_record_get_rrtype (_tmp78_);
			_tmp80_ = _tmp79_;
			_tmp81_ = rec;
			_tmp82_ = dns_question_record_get_rrclass (_tmp81_);
			_tmp83_ = _tmp82_;
			dns_message_output_name_type_class (self, _tmp77_, _tmp80_, _tmp83_, &_tmp84_, &_tmp85_, &_inner_error_);
			buf = (g_free (buf), NULL);
			buf = _tmp84_;
			buf_length1 = _tmp85_;
			_buf_size_ = buf_length1;
			if (_inner_error_ != NULL) {
				buf = (g_free (buf), NULL);
				_g_object_unref0 (rec);
				_g_object_unref0 (_rec_list);
				ret = (g_free (ret), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp86_ = buf;
			_tmp86__length1 = buf_length1;
			{
				guint8* b_collection = NULL;
				gint b_collection_length1 = 0;
				gint _b_collection_size_ = 0;
				gint b_it = 0;
				b_collection = _tmp86_;
				b_collection_length1 = _tmp86__length1;
				for (b_it = 0; b_it < _tmp86__length1; b_it = b_it + 1) {
					guint8 b = 0U;
					b = b_collection[b_it];
					{
						guint8* _tmp87_;
						gint _tmp87__length1;
						guint8 _tmp88_;
						_tmp87_ = ret;
						_tmp87__length1 = ret_length1;
						_tmp88_ = b;
						_vala_array_add13 (&ret, &ret_length1, &_ret_size_, _tmp88_);
					}
				}
			}
			buf = (g_free (buf), NULL);
			_g_object_unref0 (rec);
		}
		_g_object_unref0 (_rec_list);
	}
	{
		GeeArrayList* _tmp89_;
		GeeArrayList* _tmp90_;
		GeeArrayList* _rec_list;
		GeeArrayList* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gint _rec_size;
		gint _rec_index;
		_tmp89_ = self->answer_recs;
		_tmp90_ = _g_object_ref0 (_tmp89_);
		_rec_list = _tmp90_;
		_tmp91_ = _rec_list;
		_tmp92_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		_rec_size = _tmp93_;
		_rec_index = -1;
		while (TRUE) {
			gint _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			GeeArrayList* _tmp97_;
			gint _tmp98_;
			gpointer _tmp99_ = NULL;
			DnsResRecord* rec;
			guint8* buf = NULL;
			gint buf_length1 = 0;
			gint _buf_size_ = 0;
			DnsResRecord* _tmp100_;
			guint8* _tmp101_ = NULL;
			gint _tmp102_ = 0;
			guint8* _tmp103_;
			gint _tmp103__length1;
			_tmp94_ = _rec_index;
			_rec_index = _tmp94_ + 1;
			_tmp95_ = _rec_index;
			_tmp96_ = _rec_size;
			if (!(_tmp95_ < _tmp96_)) {
				break;
			}
			_tmp97_ = _rec_list;
			_tmp98_ = _rec_index;
			_tmp99_ = gee_abstract_list_get ((GeeAbstractList*) _tmp97_, _tmp98_);
			rec = (DnsResRecord*) _tmp99_;
			_tmp100_ = rec;
			dns_message_output_res_record (self, _tmp100_, &_tmp101_, &_tmp102_, &_inner_error_);
			buf = (g_free (buf), NULL);
			buf = _tmp101_;
			buf_length1 = _tmp102_;
			_buf_size_ = buf_length1;
			if (_inner_error_ != NULL) {
				buf = (g_free (buf), NULL);
				_g_object_unref0 (rec);
				_g_object_unref0 (_rec_list);
				ret = (g_free (ret), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp103_ = buf;
			_tmp103__length1 = buf_length1;
			{
				guint8* b_collection = NULL;
				gint b_collection_length1 = 0;
				gint _b_collection_size_ = 0;
				gint b_it = 0;
				b_collection = _tmp103_;
				b_collection_length1 = _tmp103__length1;
				for (b_it = 0; b_it < _tmp103__length1; b_it = b_it + 1) {
					guint8 b = 0U;
					b = b_collection[b_it];
					{
						guint8* _tmp104_;
						gint _tmp104__length1;
						guint8 _tmp105_;
						_tmp104_ = ret;
						_tmp104__length1 = ret_length1;
						_tmp105_ = b;
						_vala_array_add14 (&ret, &ret_length1, &_ret_size_, _tmp105_);
					}
				}
			}
			buf = (g_free (buf), NULL);
			_g_object_unref0 (rec);
		}
		_g_object_unref0 (_rec_list);
	}
	{
		GeeArrayList* _tmp106_;
		GeeArrayList* _tmp107_;
		GeeArrayList* _rec_list;
		GeeArrayList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		gint _rec_size;
		gint _rec_index;
		_tmp106_ = self->authority_recs;
		_tmp107_ = _g_object_ref0 (_tmp106_);
		_rec_list = _tmp107_;
		_tmp108_ = _rec_list;
		_tmp109_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		_rec_size = _tmp110_;
		_rec_index = -1;
		while (TRUE) {
			gint _tmp111_;
			gint _tmp112_;
			gint _tmp113_;
			GeeArrayList* _tmp114_;
			gint _tmp115_;
			gpointer _tmp116_ = NULL;
			DnsResRecord* rec;
			guint8* buf = NULL;
			gint buf_length1 = 0;
			gint _buf_size_ = 0;
			DnsResRecord* _tmp117_;
			guint8* _tmp118_ = NULL;
			gint _tmp119_ = 0;
			guint8* _tmp120_;
			gint _tmp120__length1;
			_tmp111_ = _rec_index;
			_rec_index = _tmp111_ + 1;
			_tmp112_ = _rec_index;
			_tmp113_ = _rec_size;
			if (!(_tmp112_ < _tmp113_)) {
				break;
			}
			_tmp114_ = _rec_list;
			_tmp115_ = _rec_index;
			_tmp116_ = gee_abstract_list_get ((GeeAbstractList*) _tmp114_, _tmp115_);
			rec = (DnsResRecord*) _tmp116_;
			_tmp117_ = rec;
			dns_message_output_res_record (self, _tmp117_, &_tmp118_, &_tmp119_, &_inner_error_);
			buf = (g_free (buf), NULL);
			buf = _tmp118_;
			buf_length1 = _tmp119_;
			_buf_size_ = buf_length1;
			if (_inner_error_ != NULL) {
				buf = (g_free (buf), NULL);
				_g_object_unref0 (rec);
				_g_object_unref0 (_rec_list);
				ret = (g_free (ret), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp120_ = buf;
			_tmp120__length1 = buf_length1;
			{
				guint8* b_collection = NULL;
				gint b_collection_length1 = 0;
				gint _b_collection_size_ = 0;
				gint b_it = 0;
				b_collection = _tmp120_;
				b_collection_length1 = _tmp120__length1;
				for (b_it = 0; b_it < _tmp120__length1; b_it = b_it + 1) {
					guint8 b = 0U;
					b = b_collection[b_it];
					{
						guint8* _tmp121_;
						gint _tmp121__length1;
						guint8 _tmp122_;
						_tmp121_ = ret;
						_tmp121__length1 = ret_length1;
						_tmp122_ = b;
						_vala_array_add15 (&ret, &ret_length1, &_ret_size_, _tmp122_);
					}
				}
			}
			buf = (g_free (buf), NULL);
			_g_object_unref0 (rec);
		}
		_g_object_unref0 (_rec_list);
	}
	{
		GeeArrayList* _tmp123_;
		GeeArrayList* _tmp124_;
		GeeArrayList* _rec_list;
		GeeArrayList* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gint _rec_size;
		gint _rec_index;
		_tmp123_ = self->additional_recs;
		_tmp124_ = _g_object_ref0 (_tmp123_);
		_rec_list = _tmp124_;
		_tmp125_ = _rec_list;
		_tmp126_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp125_);
		_tmp127_ = _tmp126_;
		_rec_size = _tmp127_;
		_rec_index = -1;
		while (TRUE) {
			gint _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			GeeArrayList* _tmp131_;
			gint _tmp132_;
			gpointer _tmp133_ = NULL;
			DnsResRecord* rec;
			guint8* buf = NULL;
			gint buf_length1 = 0;
			gint _buf_size_ = 0;
			DnsResRecord* _tmp134_;
			guint8* _tmp135_ = NULL;
			gint _tmp136_ = 0;
			guint8* _tmp137_;
			gint _tmp137__length1;
			_tmp128_ = _rec_index;
			_rec_index = _tmp128_ + 1;
			_tmp129_ = _rec_index;
			_tmp130_ = _rec_size;
			if (!(_tmp129_ < _tmp130_)) {
				break;
			}
			_tmp131_ = _rec_list;
			_tmp132_ = _rec_index;
			_tmp133_ = gee_abstract_list_get ((GeeAbstractList*) _tmp131_, _tmp132_);
			rec = (DnsResRecord*) _tmp133_;
			_tmp134_ = rec;
			dns_message_output_res_record (self, _tmp134_, &_tmp135_, &_tmp136_, &_inner_error_);
			buf = (g_free (buf), NULL);
			buf = _tmp135_;
			buf_length1 = _tmp136_;
			_buf_size_ = buf_length1;
			if (_inner_error_ != NULL) {
				buf = (g_free (buf), NULL);
				_g_object_unref0 (rec);
				_g_object_unref0 (_rec_list);
				ret = (g_free (ret), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp137_ = buf;
			_tmp137__length1 = buf_length1;
			{
				guint8* b_collection = NULL;
				gint b_collection_length1 = 0;
				gint _b_collection_size_ = 0;
				gint b_it = 0;
				b_collection = _tmp137_;
				b_collection_length1 = _tmp137__length1;
				for (b_it = 0; b_it < _tmp137__length1; b_it = b_it + 1) {
					guint8 b = 0U;
					b = b_collection[b_it];
					{
						guint8* _tmp138_;
						gint _tmp138__length1;
						guint8 _tmp139_;
						_tmp138_ = ret;
						_tmp138__length1 = ret_length1;
						_tmp139_ = b;
						_vala_array_add16 (&ret, &ret_length1, &_ret_size_, _tmp139_);
					}
				}
			}
			buf = (g_free (buf), NULL);
			_g_object_unref0 (rec);
		}
		_g_object_unref0 (_rec_list);
	}
	_tmp140_ = ret;
	_tmp140__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp140__length1;
	}
	result = _tmp140_;
	return result;
}


static void dns_message_add_uint16 (DnsMessage* self, guint16 i, guint8* o0, guint8* o1) {
	guint8 _vala_o0 = 0U;
	guint8 _vala_o1 = 0U;
	guint16 _tmp0_;
	guint16 _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = i;
	_vala_o0 = (guint8) (_tmp0_ / 256);
	_tmp1_ = i;
	_vala_o1 = (guint8) (_tmp1_ - (_vala_o0 * 256));
	if (o0) {
		*o0 = _vala_o0;
	}
	if (o1) {
		*o1 = _vala_o1;
	}
}


static void dns_message_add_uint32 (DnsMessage* self, guint32 i, guint8* o0, guint8* o1, guint8* o2, guint8* o3) {
	guint8 _vala_o0 = 0U;
	guint8 _vala_o1 = 0U;
	guint8 _vala_o2 = 0U;
	guint8 _vala_o3 = 0U;
	guint32 _tmp0_;
	guint32 remainder;
	guint32 _tmp1_;
	guint32 _tmp2_;
	guint32 _tmp3_;
	guint32 _tmp4_;
	guint32 _tmp5_;
	guint32 _tmp6_;
	guint32 _tmp7_;
	guint32 _tmp8_;
	guint32 _tmp9_;
	guint32 _tmp10_;
	guint32 _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = i;
	remainder = _tmp0_ / 256;
	_tmp1_ = i;
	_tmp2_ = remainder;
	_vala_o3 = (guint8) (_tmp1_ - (_tmp2_ * 256));
	_tmp3_ = remainder;
	i = _tmp3_;
	_tmp4_ = i;
	remainder = _tmp4_ / 256;
	_tmp5_ = i;
	_tmp6_ = remainder;
	_vala_o2 = (guint8) (_tmp5_ - (_tmp6_ * 256));
	_tmp7_ = remainder;
	i = _tmp7_;
	_tmp8_ = i;
	remainder = _tmp8_ / 256;
	_tmp9_ = i;
	_tmp10_ = remainder;
	_vala_o1 = (guint8) (_tmp9_ - (_tmp10_ * 256));
	_tmp11_ = remainder;
	_vala_o0 = (guint8) _tmp11_;
	if (o0) {
		*o0 = _vala_o0;
	}
	if (o1) {
		*o1 = _vala_o1;
	}
	if (o2) {
		*o2 = _vala_o2;
	}
	if (o3) {
		*o3 = _vala_o3;
	}
}


static void dns_message_output_name_type_class (DnsMessage* self, const gchar* name, DnsRRType rrtype, DnsRRClass rrclass, guint8** buf, int* buf_length1, GError** error) {
	guint8* _vala_buf = NULL;
	int _vala_buf_length1 = 0;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	guint8* _tmp2_ = NULL;
	guint8* buf_start;
	gint buf_start_length1;
	gint _buf_start_size_;
	guint8* _tmp3_ = NULL;
	gint pos;
	guint8 o0 = 0U;
	guint8 o1 = 0U;
	DnsRRType _tmp8_;
	guint16 itype;
	guint16 _tmp9_;
	guint8 _tmp10_ = 0U;
	guint8 _tmp11_ = 0U;
	guint8* _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	guint8 _tmp14_;
	guint8 _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	gint _tmp17_;
	guint8 _tmp18_;
	guint8 _tmp19_;
	DnsRRClass _tmp20_;
	guint16 iclass;
	guint16 _tmp21_;
	guint8 _tmp22_ = 0U;
	guint8 _tmp23_ = 0U;
	guint8* _tmp24_;
	gint _tmp24__length1;
	gint _tmp25_;
	guint8 _tmp26_;
	guint8 _tmp27_;
	guint8* _tmp28_;
	gint _tmp28__length1;
	gint _tmp29_;
	guint8 _tmp30_;
	guint8 _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp2_ = dns_name_dotted_to_octets (_tmp0_, &_tmp1_, &_inner_error_);
	buf_start = _tmp2_;
	buf_start_length1 = _tmp1_;
	_buf_start_size_ = buf_start_length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = g_new0 (guint8, buf_start_length1 + 4);
	_vala_buf = (g_free (_vala_buf), NULL);
	_vala_buf = _tmp3_;
	_vala_buf_length1 = buf_start_length1 + 4;
	pos = 0;
	{
		guint8* b_collection = NULL;
		gint b_collection_length1 = 0;
		gint _b_collection_size_ = 0;
		gint b_it = 0;
		b_collection = buf_start;
		b_collection_length1 = buf_start_length1;
		for (b_it = 0; b_it < buf_start_length1; b_it = b_it + 1) {
			guint8 b = 0U;
			b = b_collection[b_it];
			{
				guint8* _tmp4_;
				gint _tmp4__length1;
				gint _tmp5_;
				guint8 _tmp6_;
				guint8 _tmp7_;
				_tmp4_ = _vala_buf;
				_tmp4__length1 = _vala_buf_length1;
				_tmp5_ = pos;
				pos = _tmp5_ + 1;
				_tmp6_ = b;
				_tmp4_[_tmp5_] = _tmp6_;
				_tmp7_ = _tmp4_[_tmp5_];
			}
		}
	}
	_tmp8_ = rrtype;
	itype = (guint16) _tmp8_;
	_tmp9_ = itype;
	dns_message_add_uint16 (self, _tmp9_, &_tmp10_, &_tmp11_);
	o0 = _tmp10_;
	o1 = _tmp11_;
	_tmp12_ = _vala_buf;
	_tmp12__length1 = _vala_buf_length1;
	_tmp13_ = pos;
	pos = _tmp13_ + 1;
	_tmp14_ = o0;
	_tmp12_[_tmp13_] = _tmp14_;
	_tmp15_ = _tmp12_[_tmp13_];
	_tmp16_ = _vala_buf;
	_tmp16__length1 = _vala_buf_length1;
	_tmp17_ = pos;
	pos = _tmp17_ + 1;
	_tmp18_ = o1;
	_tmp16_[_tmp17_] = _tmp18_;
	_tmp19_ = _tmp16_[_tmp17_];
	_tmp20_ = rrclass;
	iclass = (guint16) _tmp20_;
	_tmp21_ = iclass;
	dns_message_add_uint16 (self, _tmp21_, &_tmp22_, &_tmp23_);
	o0 = _tmp22_;
	o1 = _tmp23_;
	_tmp24_ = _vala_buf;
	_tmp24__length1 = _vala_buf_length1;
	_tmp25_ = pos;
	pos = _tmp25_ + 1;
	_tmp26_ = o0;
	_tmp24_[_tmp25_] = _tmp26_;
	_tmp27_ = _tmp24_[_tmp25_];
	_tmp28_ = _vala_buf;
	_tmp28__length1 = _vala_buf_length1;
	_tmp29_ = pos;
	pos = _tmp29_ + 1;
	_tmp30_ = o1;
	_tmp28_[_tmp29_] = _tmp30_;
	_tmp31_ = _tmp28_[_tmp29_];
	buf_start = (g_free (buf_start), NULL);
	if (buf) {
		*buf = _vala_buf;
	} else {
		_vala_buf = (g_free (_vala_buf), NULL);
	}
	if (buf_length1) {
		*buf_length1 = _vala_buf_length1;
	}
}


static void dns_message_output_res_record (DnsMessage* self, DnsResRecord* rr, guint8** buf, int* buf_length1, GError** error) {
	guint8* _vala_buf = NULL;
	int _vala_buf_length1 = 0;
	DnsResRecord* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* buf_start = NULL;
	gint buf_start_length1 = 0;
	gint _buf_start_size_ = 0;
	DnsResRecord* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	DnsResRecord* _tmp7_;
	DnsRRType _tmp8_;
	DnsRRType _tmp9_;
	DnsResRecord* _tmp10_;
	DnsRRClass _tmp11_;
	DnsRRClass _tmp12_;
	guint8* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	DnsResRecord* _tmp15_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	guint8* _tmp17_;
	gint _tmp17__length1;
	guint8* _tmp18_ = NULL;
	gint pos;
	guint8 o0 = 0U;
	guint8 o1 = 0U;
	guint8 o2 = 0U;
	guint8 o3 = 0U;
	DnsResRecord* _tmp23_;
	gint32 _tmp24_;
	gint32 _tmp25_;
	guint8 _tmp26_ = 0U;
	guint8 _tmp27_ = 0U;
	guint8 _tmp28_ = 0U;
	guint8 _tmp29_ = 0U;
	guint8* _tmp30_;
	gint _tmp30__length1;
	gint _tmp31_;
	guint8 _tmp32_;
	guint8 _tmp33_;
	guint8* _tmp34_;
	gint _tmp34__length1;
	gint _tmp35_;
	guint8 _tmp36_;
	guint8 _tmp37_;
	guint8* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_;
	guint8 _tmp40_;
	guint8 _tmp41_;
	guint8* _tmp42_;
	gint _tmp42__length1;
	gint _tmp43_;
	guint8 _tmp44_;
	guint8 _tmp45_;
	DnsResRecord* _tmp46_;
	guint8* _tmp47_;
	gint _tmp47__length1;
	guint8* _tmp48_;
	gint _tmp48__length1;
	guint8 _tmp49_ = 0U;
	guint8 _tmp50_ = 0U;
	guint8* _tmp51_;
	gint _tmp51__length1;
	gint _tmp52_;
	guint8 _tmp53_;
	guint8 _tmp54_;
	guint8* _tmp55_;
	gint _tmp55__length1;
	gint _tmp56_;
	guint8 _tmp57_;
	guint8 _tmp58_;
	DnsResRecord* _tmp59_;
	guint8* _tmp60_;
	gint _tmp60__length1;
	guint8* _tmp61_;
	gint _tmp61__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rr != NULL);
	_tmp0_ = rr;
	_tmp1_ = dns_res_record_get_data (_tmp0_, &_tmp1__length1);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (_tmp2__length1 > 65535) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (DNS_MESSAGE_ERROR, DNS_MESSAGE_ERROR_MALFORMED_MESSAGE, "data too long");
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = rr;
	_tmp5_ = dns_res_record_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = rr;
	_tmp8_ = dns_res_record_get_rrtype (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = rr;
	_tmp11_ = dns_res_record_get_rrclass (_tmp10_);
	_tmp12_ = _tmp11_;
	dns_message_output_name_type_class (self, _tmp6_, _tmp9_, _tmp12_, &_tmp13_, &_tmp14_, &_inner_error_);
	buf_start = (g_free (buf_start), NULL);
	buf_start = _tmp13_;
	buf_start_length1 = _tmp14_;
	_buf_start_size_ = buf_start_length1;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DNS_MESSAGE_ERROR) {
			g_propagate_error (error, _inner_error_);
			buf_start = (g_free (buf_start), NULL);
			return;
		} else {
			buf_start = (g_free (buf_start), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = rr;
	_tmp16_ = dns_res_record_get_data (_tmp15_, &_tmp16__length1);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _tmp16__length1;
	_tmp18_ = g_new0 (guint8, (buf_start_length1 + 6) + _tmp17__length1);
	_vala_buf = (g_free (_vala_buf), NULL);
	_vala_buf = _tmp18_;
	_vala_buf_length1 = (buf_start_length1 + 6) + _tmp17__length1;
	pos = 0;
	{
		guint8* b_collection = NULL;
		gint b_collection_length1 = 0;
		gint _b_collection_size_ = 0;
		gint b_it = 0;
		b_collection = buf_start;
		b_collection_length1 = buf_start_length1;
		for (b_it = 0; b_it < buf_start_length1; b_it = b_it + 1) {
			guint8 b = 0U;
			b = b_collection[b_it];
			{
				guint8* _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				guint8 _tmp21_;
				guint8 _tmp22_;
				_tmp19_ = _vala_buf;
				_tmp19__length1 = _vala_buf_length1;
				_tmp20_ = pos;
				pos = _tmp20_ + 1;
				_tmp21_ = b;
				_tmp19_[_tmp20_] = _tmp21_;
				_tmp22_ = _tmp19_[_tmp20_];
			}
		}
	}
	_tmp23_ = rr;
	_tmp24_ = dns_res_record_get_ttl (_tmp23_);
	_tmp25_ = _tmp24_;
	dns_message_add_uint32 (self, (guint32) _tmp25_, &_tmp26_, &_tmp27_, &_tmp28_, &_tmp29_);
	o0 = _tmp26_;
	o1 = _tmp27_;
	o2 = _tmp28_;
	o3 = _tmp29_;
	_tmp30_ = _vala_buf;
	_tmp30__length1 = _vala_buf_length1;
	_tmp31_ = pos;
	pos = _tmp31_ + 1;
	_tmp32_ = o0;
	_tmp30_[_tmp31_] = _tmp32_;
	_tmp33_ = _tmp30_[_tmp31_];
	_tmp34_ = _vala_buf;
	_tmp34__length1 = _vala_buf_length1;
	_tmp35_ = pos;
	pos = _tmp35_ + 1;
	_tmp36_ = o1;
	_tmp34_[_tmp35_] = _tmp36_;
	_tmp37_ = _tmp34_[_tmp35_];
	_tmp38_ = _vala_buf;
	_tmp38__length1 = _vala_buf_length1;
	_tmp39_ = pos;
	pos = _tmp39_ + 1;
	_tmp40_ = o2;
	_tmp38_[_tmp39_] = _tmp40_;
	_tmp41_ = _tmp38_[_tmp39_];
	_tmp42_ = _vala_buf;
	_tmp42__length1 = _vala_buf_length1;
	_tmp43_ = pos;
	pos = _tmp43_ + 1;
	_tmp44_ = o3;
	_tmp42_[_tmp43_] = _tmp44_;
	_tmp45_ = _tmp42_[_tmp43_];
	_tmp46_ = rr;
	_tmp47_ = dns_res_record_get_data (_tmp46_, &_tmp47__length1);
	_tmp48_ = _tmp47_;
	_tmp48__length1 = _tmp47__length1;
	dns_message_add_uint16 (self, (guint16) _tmp48__length1, &_tmp49_, &_tmp50_);
	o0 = _tmp49_;
	o1 = _tmp50_;
	_tmp51_ = _vala_buf;
	_tmp51__length1 = _vala_buf_length1;
	_tmp52_ = pos;
	pos = _tmp52_ + 1;
	_tmp53_ = o0;
	_tmp51_[_tmp52_] = _tmp53_;
	_tmp54_ = _tmp51_[_tmp52_];
	_tmp55_ = _vala_buf;
	_tmp55__length1 = _vala_buf_length1;
	_tmp56_ = pos;
	pos = _tmp56_ + 1;
	_tmp57_ = o1;
	_tmp55_[_tmp56_] = _tmp57_;
	_tmp58_ = _tmp55_[_tmp56_];
	_tmp59_ = rr;
	_tmp60_ = dns_res_record_get_data (_tmp59_, &_tmp60__length1);
	_tmp61_ = _tmp60_;
	_tmp61__length1 = _tmp60__length1;
	{
		guint8* b_collection = NULL;
		gint b_collection_length1 = 0;
		gint _b_collection_size_ = 0;
		gint b_it = 0;
		b_collection = _tmp61_;
		b_collection_length1 = _tmp61__length1;
		for (b_it = 0; b_it < _tmp61__length1; b_it = b_it + 1) {
			guint8 b = 0U;
			b = b_collection[b_it];
			{
				guint8* _tmp62_;
				gint _tmp62__length1;
				gint _tmp63_;
				guint8 _tmp64_;
				guint8 _tmp65_;
				_tmp62_ = _vala_buf;
				_tmp62__length1 = _vala_buf_length1;
				_tmp63_ = pos;
				pos = _tmp63_ + 1;
				_tmp64_ = b;
				_tmp62_[_tmp63_] = _tmp64_;
				_tmp65_ = _tmp62_[_tmp63_];
			}
		}
	}
	buf_start = (g_free (buf_start), NULL);
	if (buf) {
		*buf = _vala_buf;
	} else {
		_vala_buf = (g_free (_vala_buf), NULL);
	}
	if (buf_length1) {
		*buf_length1 = _vala_buf_length1;
	}
}


DnsMessage* dns_message_construct (GType object_type) {
	DnsMessage * self = NULL;
	self = (DnsMessage*) g_object_new (object_type, NULL);
	return self;
}


DnsMessage* dns_message_new (void) {
	return dns_message_construct (DNS_TYPE_MESSAGE);
}


static void dns_message_class_init (DnsMessageClass * klass) {
	dns_message_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = dns_message_finalize;
}


static void dns_message_instance_init (DnsMessage * self) {
}


static void dns_message_finalize (GObject* obj) {
	DnsMessage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DNS_TYPE_MESSAGE, DnsMessage);
	_g_object_unref0 (self->question_recs);
	_g_object_unref0 (self->answer_recs);
	_g_object_unref0 (self->authority_recs);
	_g_object_unref0 (self->additional_recs);
	G_OBJECT_CLASS (dns_message_parent_class)->finalize (obj);
}


GType dns_message_get_type (void) {
	static volatile gsize dns_message_type_id__volatile = 0;
	if (g_once_init_enter (&dns_message_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DnsMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dns_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DnsMessage), 0, (GInstanceInitFunc) dns_message_instance_init, NULL };
		GType dns_message_type_id;
		dns_message_type_id = g_type_register_static (G_TYPE_OBJECT, "DnsMessage", &g_define_type_info, 0);
		g_once_init_leave (&dns_message_type_id__volatile, dns_message_type_id);
	}
	return dns_message_type_id__volatile;
}


void log_info (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("INFO ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_INFO, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_notice (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("INFO+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_NOTICE, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_warn (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("INFO++ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_WARNING, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_error (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("ERROR ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_ERR, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void log_critical (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("ERROR+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_CRIT, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	gunichar _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* hex_dump (guint8* buf, int buf_length1, gsize length) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guchar* p;
	gchar* _tmp2_;
	gchar* addrstr;
	gchar* _tmp3_;
	gchar* hexstr;
	gchar* _tmp4_;
	gchar* charstr;
	gsize _tmp5_;
	const gchar* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	_tmp1_ = buf;
	_tmp1__length1 = buf_length1;
	p = _tmp1_;
	_tmp2_ = g_strdup ("");
	addrstr = _tmp2_;
	_tmp3_ = g_strdup ("");
	hexstr = _tmp3_;
	_tmp4_ = g_strdup ("");
	charstr = _tmp4_;
	_tmp5_ = length;
	if (_tmp5_ == ((gsize) 0)) {
		guint8* _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = buf;
		_tmp6__length1 = buf_length1;
		length = (gsize) _tmp6__length1;
	}
	{
		gint n;
		n = 1;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				gsize _tmp11_;
				gint _tmp12_;
				guchar* _tmp16_;
				guchar c;
				gboolean _tmp17_ = FALSE;
				guchar _tmp18_;
				gboolean _tmp21_;
				const gchar* _tmp22_;
				guchar* _tmp23_;
				gchar* _tmp24_ = NULL;
				gchar* _tmp25_;
				gchar* _tmp26_;
				const gchar* _tmp27_;
				guchar _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gint _tmp32_;
				guchar* _tmp47_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = n;
					n = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = n;
				_tmp11_ = length;
				if (!(((gsize) _tmp10_) <= _tmp11_)) {
					break;
				}
				_tmp12_ = n;
				if ((_tmp12_ % 16) == 1) {
					guchar* _tmp13_;
					guint8* _tmp14_;
					gint _tmp14__length1;
					gchar* _tmp15_ = NULL;
					_tmp13_ = p;
					_tmp14_ = buf;
					_tmp14__length1 = buf_length1;
					_tmp15_ = g_strdup_printf ("%.4x", ((guint) _tmp13_) - ((guint) _tmp14_));
					_g_free0 (addrstr);
					addrstr = _tmp15_;
				}
				_tmp16_ = p;
				c = *_tmp16_;
				_tmp18_ = c;
				if (_tmp18_ == ((guchar) '\0')) {
					_tmp17_ = TRUE;
				} else {
					guchar _tmp19_;
					gint _tmp20_ = 0;
					_tmp19_ = c;
					_tmp20_ = string_index_of_char ("( ):-_qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM1234567890", (gunichar) _tmp19_, 0);
					_tmp17_ = _tmp20_ < 0;
				}
				_tmp21_ = _tmp17_;
				if (_tmp21_) {
					c = (guchar) '.';
				}
				_tmp22_ = hexstr;
				_tmp23_ = p;
				_tmp24_ = g_strdup_printf ("%02X ", (guint) (*_tmp23_));
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strconcat (_tmp22_, _tmp25_, NULL);
				_g_free0 (hexstr);
				hexstr = _tmp26_;
				_g_free0 (_tmp25_);
				_tmp27_ = charstr;
				_tmp28_ = c;
				_tmp29_ = g_strdup_printf ("%c", (gint) _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp27_, _tmp30_, NULL);
				_g_free0 (charstr);
				charstr = _tmp31_;
				_g_free0 (_tmp30_);
				_tmp32_ = n;
				if ((_tmp32_ % 16) == 0) {
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					gchar* _tmp37_ = NULL;
					gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					_tmp33_ = ret;
					_tmp34_ = addrstr;
					_tmp35_ = hexstr;
					_tmp36_ = charstr;
					_tmp37_ = g_strdup_printf ("[%4.4s]   %-50.50s  %s\n", _tmp34_, _tmp35_, _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = g_strconcat (_tmp33_, _tmp38_, NULL);
					_g_free0 (ret);
					ret = _tmp39_;
					_g_free0 (_tmp38_);
					_tmp40_ = g_strdup ("");
					_g_free0 (hexstr);
					hexstr = _tmp40_;
					_tmp41_ = g_strdup ("");
					_g_free0 (charstr);
					charstr = _tmp41_;
				} else {
					gint _tmp42_;
					_tmp42_ = n;
					if ((_tmp42_ % 16) == 8) {
						const gchar* _tmp43_;
						gchar* _tmp44_;
						const gchar* _tmp45_;
						gchar* _tmp46_;
						_tmp43_ = hexstr;
						_tmp44_ = g_strconcat (_tmp43_, "  ", NULL);
						_g_free0 (hexstr);
						hexstr = _tmp44_;
						_tmp45_ = charstr;
						_tmp46_ = g_strconcat (_tmp45_, " ", NULL);
						_g_free0 (charstr);
						charstr = _tmp46_;
					}
				}
				_tmp47_ = p;
				p = _tmp47_ + 1;
			}
		}
	}
	_tmp48_ = hexstr;
	_tmp49_ = strlen (_tmp48_);
	_tmp50_ = _tmp49_;
	if (_tmp50_ > 0) {
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_;
		gchar* _tmp57_;
		_tmp51_ = ret;
		_tmp52_ = addrstr;
		_tmp53_ = hexstr;
		_tmp54_ = charstr;
		_tmp55_ = g_strdup_printf ("[%4.4s]   %-50.50s  %s\n", _tmp52_, _tmp53_, _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = g_strconcat (_tmp51_, _tmp56_, NULL);
		_g_free0 (ret);
		ret = _tmp57_;
		_g_free0 (_tmp56_);
	}
	result = ret;
	_g_free0 (charstr);
	_g_free0 (hexstr);
	_g_free0 (addrstr);
	return result;
}


CleanupServingIdArg* cleanup_serving_id_arg_construct (GType object_type, guint16 id) {
	CleanupServingIdArg * self = NULL;
	guint16 _tmp0_;
	self = (CleanupServingIdArg*) g_object_new (object_type, NULL);
	_tmp0_ = id;
	self->id = _tmp0_;
	return self;
}


CleanupServingIdArg* cleanup_serving_id_arg_new (guint16 id) {
	return cleanup_serving_id_arg_construct (TYPE_CLEANUP_SERVING_ID_ARG, id);
}


gint cleanup_serving_id_arg_cleanup_serving_id (CleanupServingIdArg* self) {
	gint result = 0;
	GeeArrayList* _tmp0_;
	guint16 _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_usleep ((gulong) 20000000);
	_tmp0_ = serving_ids;
	_tmp1_ = self->id;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, (gpointer) ((guintptr) _tmp1_));
	result = 0;
	return result;
}


static void cleanup_serving_id_arg_class_init (CleanupServingIdArgClass * klass) {
	cleanup_serving_id_arg_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = cleanup_serving_id_arg_finalize;
}


static void cleanup_serving_id_arg_instance_init (CleanupServingIdArg * self) {
}


static void cleanup_serving_id_arg_finalize (GObject* obj) {
	CleanupServingIdArg * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLEANUP_SERVING_ID_ARG, CleanupServingIdArg);
	G_OBJECT_CLASS (cleanup_serving_id_arg_parent_class)->finalize (obj);
}


GType cleanup_serving_id_arg_get_type (void) {
	static volatile gsize cleanup_serving_id_arg_type_id__volatile = 0;
	if (g_once_init_enter (&cleanup_serving_id_arg_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CleanupServingIdArgClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cleanup_serving_id_arg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CleanupServingIdArg), 0, (GInstanceInitFunc) cleanup_serving_id_arg_instance_init, NULL };
		GType cleanup_serving_id_arg_type_id;
		cleanup_serving_id_arg_type_id = g_type_register_static (G_TYPE_OBJECT, "CleanupServingIdArg", &g_define_type_info, 0);
		g_once_init_leave (&cleanup_serving_id_arg_type_id__volatile, cleanup_serving_id_arg_type_id);
	}
	return cleanup_serving_id_arg_type_id__volatile;
}


static guint8* _vala_array_dup2 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


ForwardDnsArg* forward_dns_arg_construct (GType object_type, GSocketAddress* client_address, guint8* buffer, int buffer_length1, GSocketAddress* dns_server) {
	ForwardDnsArg * self = NULL;
	GSocketAddress* _tmp0_;
	GSocketAddress* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GSocketAddress* _tmp4_;
	GSocketAddress* _tmp5_;
	g_return_val_if_fail (client_address != NULL, NULL);
	g_return_val_if_fail (dns_server != NULL, NULL);
	self = (ForwardDnsArg*) g_object_new (object_type, NULL);
	_tmp0_ = client_address;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->client_address);
	self->client_address = _tmp1_;
	_tmp2_ = buffer;
	_tmp2__length1 = buffer_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->buffer = (g_free (self->buffer), NULL);
	self->buffer = _tmp3_;
	self->buffer_length1 = _tmp3__length1;
	_tmp4_ = dns_server;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->dns_server);
	self->dns_server = _tmp5_;
	self->priv->dns_response = (g_free (self->priv->dns_response), NULL);
	self->priv->dns_response = NULL;
	self->priv->dns_response_length1 = 0;
	self->priv->_dns_response_size_ = self->priv->dns_response_length1;
	return self;
}


ForwardDnsArg* forward_dns_arg_new (GSocketAddress* client_address, guint8* buffer, int buffer_length1, GSocketAddress* dns_server) {
	return forward_dns_arg_construct (TYPE_FORWARD_DNS_ARG, client_address, buffer, buffer_length1, dns_server);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


gint forward_dns_arg_forward_dns (ForwardDnsArg* self) {
	gint result = 0;
	GSocket* _tmp0_;
	GSocket* s0;
	GSocket* _tmp1_;
	guint8* _tmp23_;
	gint _tmp23__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_socket_new (G_SOCKET_FAMILY_IPV4, G_SOCKET_TYPE_DATAGRAM, G_SOCKET_PROTOCOL_UDP, &_inner_error_);
	s0 = _tmp0_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp1_ = s0;
	g_socket_set_timeout (_tmp1_, (guint) 60);
	{
		GSocket* _tmp2_;
		GSocketAddress* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		GSocketAddress* respaddr = NULL;
		guint8 respbuf[4096] = {0};
		GSocket* _tmp5_;
		GSocketAddress* _tmp6_ = NULL;
		gssize _tmp7_ = 0L;
		gssize buflen;
		gssize _tmp8_;
		guint8* _tmp9_ = NULL;
		_tmp2_ = s0;
		_tmp3_ = self->dns_server;
		_tmp4_ = self->buffer;
		_tmp4__length1 = self->buffer_length1;
		g_socket_send_to (_tmp2_, _tmp3_, _tmp4_, (gsize) _tmp4__length1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __finally0;
		}
		_tmp5_ = s0;
		_tmp7_ = g_socket_receive_from (_tmp5_, &_tmp6_, respbuf, (gsize) 4096, NULL, &_inner_error_);
		_g_object_unref0 (respaddr);
		respaddr = _tmp6_;
		buflen = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (respaddr);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			goto __finally0;
		}
		_tmp8_ = buflen;
		_tmp9_ = g_new0 (guint8, _tmp8_);
		self->priv->dns_response = (g_free (self->priv->dns_response), NULL);
		self->priv->dns_response = _tmp9_;
		self->priv->dns_response_length1 = _tmp8_;
		self->priv->_dns_response_size_ = self->priv->dns_response_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp10_;
				_tmp10_ = TRUE;
				while (TRUE) {
					gboolean _tmp11_;
					gint _tmp13_;
					gssize _tmp14_;
					guint8* _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					gint _tmp17_;
					guint8 _tmp18_;
					guint8 _tmp19_;
					_tmp11_ = _tmp10_;
					if (!_tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						i = _tmp12_ + 1;
					}
					_tmp10_ = FALSE;
					_tmp13_ = i;
					_tmp14_ = buflen;
					if (!(((gssize) _tmp13_) < _tmp14_)) {
						break;
					}
					_tmp15_ = self->priv->dns_response;
					_tmp15__length1 = self->priv->dns_response_length1;
					_tmp16_ = i;
					_tmp17_ = i;
					_tmp18_ = respbuf[_tmp17_];
					_tmp15_[_tmp16_] = _tmp18_;
					_tmp19_ = _tmp15_[_tmp16_];
				}
			}
		}
		_g_object_unref0 (respaddr);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		if (g_error_matches (_tmp20_, G_IO_ERROR, G_IO_ERROR_TIMED_OUT)) {
		} else {
			GError* _tmp21_;
			GError* _tmp22_;
			_tmp21_ = e;
			_tmp22_ = _g_error_copy0 (_tmp21_);
			_inner_error_ = _tmp22_;
			_g_error_free0 (e);
			goto __finally0;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (s0);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp23_ = self->priv->dns_response;
	_tmp23__length1 = self->priv->dns_response_length1;
	if (_tmp23_ != NULL) {
		GSocket* _tmp24_;
		GSocketAddress* _tmp25_;
		guint8* _tmp26_;
		gint _tmp26__length1;
		_tmp24_ = listening_socket;
		_tmp25_ = self->client_address;
		_tmp26_ = self->priv->dns_response;
		_tmp26__length1 = self->priv->dns_response_length1;
		g_socket_send_to (_tmp24_, _tmp25_, _tmp26_, (gsize) _tmp26__length1, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (s0);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = 0;
	_g_object_unref0 (s0);
	return result;
}


static void forward_dns_arg_class_init (ForwardDnsArgClass * klass) {
	forward_dns_arg_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ForwardDnsArgPrivate));
	G_OBJECT_CLASS (klass)->finalize = forward_dns_arg_finalize;
}


static void forward_dns_arg_instance_init (ForwardDnsArg * self) {
	self->priv = FORWARD_DNS_ARG_GET_PRIVATE (self);
}


static void forward_dns_arg_finalize (GObject* obj) {
	ForwardDnsArg * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FORWARD_DNS_ARG, ForwardDnsArg);
	_g_object_unref0 (self->client_address);
	self->buffer = (g_free (self->buffer), NULL);
	_g_object_unref0 (self->dns_server);
	self->priv->dns_response = (g_free (self->priv->dns_response), NULL);
	G_OBJECT_CLASS (forward_dns_arg_parent_class)->finalize (obj);
}


/** This class is associated to a thread that executes its method forward_dns().
  * Its duty is to forward a dns request to one of the nameservers that this host
  * is configured to use. If it receives a response it will send it back to the
  * client.
  */
GType forward_dns_arg_get_type (void) {
	static volatile gsize forward_dns_arg_type_id__volatile = 0;
	if (g_once_init_enter (&forward_dns_arg_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ForwardDnsArgClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) forward_dns_arg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ForwardDnsArg), 0, (GInstanceInitFunc) forward_dns_arg_instance_init, NULL };
		GType forward_dns_arg_type_id;
		forward_dns_arg_type_id = g_type_register_static (G_TYPE_OBJECT, "ForwardDnsArg", &g_define_type_info, 0);
		g_once_init_leave (&forward_dns_arg_type_id__volatile, forward_dns_arg_type_id);
	}
	return forward_dns_arg_type_id__volatile;
}


static guint8* _vala_array_dup3 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


HandleRequestArg* handle_request_arg_construct (GType object_type, GSocketAddress* client_address, guint8* buffer, int buffer_length1) {
	HandleRequestArg * self = NULL;
	GSocketAddress* _tmp0_;
	GSocketAddress* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (client_address != NULL, NULL);
	self = (HandleRequestArg*) g_object_new (object_type, NULL);
	_tmp0_ = client_address;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->client_address);
	self->client_address = _tmp1_;
	_tmp2_ = buffer;
	_tmp2__length1 = buffer_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup3 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	self->buffer = (g_free (self->buffer), NULL);
	self->buffer = _tmp3_;
	self->buffer_length1 = _tmp3__length1;
	return self;
}


HandleRequestArg* handle_request_arg_new (GSocketAddress* client_address, guint8* buffer, int buffer_length1) {
	return handle_request_arg_construct (TYPE_HANDLE_REQUEST_ARG, client_address, buffer, buffer_length1);
}


static gpointer _forward_dns_arg_forward_dns_gthread_func (gpointer self) {
	gpointer result;
	result = forward_dns_arg_forward_dns (self);
	g_object_unref (self);
	return result;
}


static gpointer _cleanup_serving_id_arg_cleanup_serving_id_gthread_func (gpointer self) {
	gpointer result;
	result = cleanup_serving_id_arg_cleanup_serving_id (self);
	g_object_unref (self);
	return result;
}


gint handle_request_arg_handle_request (HandleRequestArg* self) {
	gint result = 0;
	guint8* _tmp0_;
	gint _tmp0__length1;
	DnsMessage* _tmp1_;
	DnsMessage* query;
	DnsMessage* _tmp2_;
	gboolean _tmp3_;
	DnsMessage* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->buffer;
	_tmp0__length1 = self->buffer_length1;
	_tmp1_ = dns_message_new_from_wire (_tmp0_, _tmp0__length1, (gsize) 0, &_inner_error_);
	query = _tmp1_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp2_ = query;
	_tmp3_ = _tmp2_->question;
	if (!_tmp3_) {
		result = 0;
		_g_object_unref0 (query);
		return result;
	}
	_tmp4_ = query;
	_tmp5_ = handle_request_arg_check_forward_to_dns (self, _tmp4_);
	if (_tmp5_) {
		{
			GeeArrayList* _tmp6_;
			GeeArrayList* _tmp7_;
			GeeArrayList* _dns_server_list;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _dns_server_size;
			gint _dns_server_index;
			_tmp6_ = dns_list;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_dns_server_list = _tmp7_;
			_tmp8_ = _dns_server_list;
			_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp8_);
			_tmp10_ = _tmp9_;
			_dns_server_size = _tmp10_;
			_dns_server_index = -1;
			while (TRUE) {
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				GeeArrayList* _tmp14_;
				gint _tmp15_;
				gpointer _tmp16_ = NULL;
				GSocketAddress* dns_server;
				GSocketAddress* _tmp17_;
				guint8* _tmp18_;
				gint _tmp18__length1;
				GSocketAddress* _tmp19_;
				ForwardDnsArg* _tmp20_;
				ForwardDnsArg* a;
				ForwardDnsArg* _tmp21_;
				GThread* _tmp22_;
				GThread* thread;
				_tmp11_ = _dns_server_index;
				_dns_server_index = _tmp11_ + 1;
				_tmp12_ = _dns_server_index;
				_tmp13_ = _dns_server_size;
				if (!(_tmp12_ < _tmp13_)) {
					break;
				}
				_tmp14_ = _dns_server_list;
				_tmp15_ = _dns_server_index;
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
				dns_server = (GSocketAddress*) _tmp16_;
				_tmp17_ = self->client_address;
				_tmp18_ = self->buffer;
				_tmp18__length1 = self->buffer_length1;
				_tmp19_ = dns_server;
				_tmp20_ = forward_dns_arg_new (_tmp17_, _tmp18_, _tmp18__length1, _tmp19_);
				a = _tmp20_;
				_tmp21_ = a;
				_tmp22_ = g_thread_try_new ("forward_dns", _forward_dns_arg_forward_dns_gthread_func, g_object_ref (_tmp21_), &_inner_error_);
				thread = _tmp22_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (a);
					_g_object_unref0 (dns_server);
					_g_object_unref0 (_dns_server_list);
					_g_object_unref0 (query);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
				_g_thread_unref0 (thread);
				_g_object_unref0 (a);
				_g_object_unref0 (dns_server);
			}
			_g_object_unref0 (_dns_server_list);
		}
	} else {
		GeeArrayList* _tmp23_;
		DnsMessage* _tmp24_;
		guint16 _tmp25_;
		gboolean _tmp26_ = FALSE;
		_tmp23_ = serving_ids;
		_tmp24_ = query;
		_tmp25_ = _tmp24_->id;
		_tmp26_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp23_, (gpointer) ((guintptr) _tmp25_));
		if (!_tmp26_) {
			GeeArrayList* _tmp27_;
			DnsMessage* _tmp28_;
			guint16 _tmp29_;
			DnsMessage* _tmp30_;
			guint16 _tmp31_;
			CleanupServingIdArg* _tmp32_;
			CleanupServingIdArg* a;
			CleanupServingIdArg* _tmp33_;
			GThread* _tmp34_;
			GThread* thread;
			_tmp27_ = serving_ids;
			_tmp28_ = query;
			_tmp29_ = _tmp28_->id;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, (gpointer) ((guintptr) _tmp29_));
			_tmp30_ = query;
			_tmp31_ = _tmp30_->id;
			_tmp32_ = cleanup_serving_id_arg_new (_tmp31_);
			a = _tmp32_;
			_tmp33_ = a;
			_tmp34_ = g_thread_try_new ("cleanup_serving_id", _cleanup_serving_id_arg_cleanup_serving_id_gthread_func, g_object_ref (_tmp33_), &_inner_error_);
			thread = _tmp34_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (a);
				_g_object_unref0 (query);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			{
				DnsMessage* _tmp35_;
				DnsOperationCode _tmp36_;
				_tmp35_ = query;
				_tmp36_ = _tmp35_->opcode;
				if (_tmp36_ == DNS_OPERATION_CODE_NAME_TO_IP) {
					DnsMessage* _tmp37_;
					GeeArrayList* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
					_tmp37_ = query;
					_tmp38_ = _tmp37_->question_recs;
					_tmp39_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp38_);
					_tmp40_ = _tmp39_;
					if (_tmp40_ > 0) {
						DnsMessage* _tmp41_;
						GeeArrayList* _tmp42_;
						gpointer _tmp43_ = NULL;
						DnsQuestionRecord* q;
						gboolean _tmp44_ = FALSE;
						DnsQuestionRecord* _tmp45_;
						DnsRRClass _tmp46_;
						DnsRRClass _tmp47_;
						gboolean _tmp51_;
						_tmp41_ = query;
						_tmp42_ = _tmp41_->question_recs;
						_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, 0);
						q = (DnsQuestionRecord*) _tmp43_;
						_tmp45_ = q;
						_tmp46_ = dns_question_record_get_rrclass (_tmp45_);
						_tmp47_ = _tmp46_;
						if (_tmp47_ == DNS_RR_CLASS_IN) {
							DnsQuestionRecord* _tmp48_;
							DnsRRType _tmp49_;
							DnsRRType _tmp50_;
							_tmp48_ = q;
							_tmp49_ = dns_question_record_get_rrtype (_tmp48_);
							_tmp50_ = _tmp49_;
							_tmp44_ = _tmp50_ == DNS_RR_TYPE_A;
						} else {
							_tmp44_ = FALSE;
						}
						_tmp51_ = _tmp44_;
						if (_tmp51_) {
							DnsQuestionRecord* _tmp52_;
							GeeList* _tmp53_ = NULL;
							GeeList* r;
							DnsMessage* _tmp54_;
							DnsMessage* _tmp55_ = NULL;
							DnsMessage* resp;
							GeeList* _tmp56_;
							gboolean _tmp57_;
							gboolean _tmp58_;
							DnsMessage* _tmp63_;
							gint _tmp64_ = 0;
							guint8* _tmp65_ = NULL;
							guint8* dns_resp;
							gint dns_resp_length1;
							gint _dns_resp_size_;
							GSocket* _tmp66_;
							GSocketAddress* _tmp67_;
							guint8* _tmp68_;
							gint _tmp68__length1;
							_tmp52_ = q;
							_tmp53_ = handle_request_arg_std_qry (self, _tmp52_);
							r = _tmp53_;
							_tmp54_ = query;
							_tmp55_ = dns_message_make_response (_tmp54_);
							resp = _tmp55_;
							_tmp56_ = r;
							_tmp57_ = gee_collection_get_is_empty ((GeeCollection*) _tmp56_);
							_tmp58_ = _tmp57_;
							if (_tmp58_) {
								DnsMessage* _tmp59_;
								_tmp59_ = resp;
								_tmp59_->rcode = DNS_RESPONSE_CODE_NOTFOUND;
							} else {
								DnsMessage* _tmp60_;
								GeeArrayList* _tmp61_;
								GeeList* _tmp62_;
								_tmp60_ = resp;
								_tmp61_ = _tmp60_->answer_recs;
								_tmp62_ = r;
								gee_array_list_add_all (_tmp61_, (GeeCollection*) _tmp62_);
							}
							_tmp63_ = resp;
							_tmp65_ = dns_message_to_wire (_tmp63_, &_tmp64_);
							dns_resp = _tmp65_;
							dns_resp_length1 = _tmp64_;
							_dns_resp_size_ = dns_resp_length1;
							_tmp66_ = listening_socket;
							_tmp67_ = self->client_address;
							_tmp68_ = dns_resp;
							_tmp68__length1 = dns_resp_length1;
							g_socket_send_to (_tmp66_, _tmp67_, _tmp68_, (gsize) _tmp68__length1, NULL, &_inner_error_);
							if (_inner_error_ != NULL) {
								dns_resp = (g_free (dns_resp), NULL);
								_g_object_unref0 (resp);
								_g_object_unref0 (r);
								_g_object_unref0 (q);
								goto __finally1;
							}
							dns_resp = (g_free (dns_resp), NULL);
							_g_object_unref0 (resp);
							_g_object_unref0 (r);
						} else {
							gboolean _tmp69_ = FALSE;
							gboolean _tmp70_ = FALSE;
							gboolean _tmp71_ = FALSE;
							gboolean _tmp72_ = FALSE;
							DnsQuestionRecord* _tmp73_;
							DnsRRClass _tmp74_;
							DnsRRClass _tmp75_;
							gboolean _tmp79_;
							gboolean _tmp83_;
							gboolean _tmp89_;
							gboolean _tmp102_;
							_tmp73_ = q;
							_tmp74_ = dns_question_record_get_rrclass (_tmp73_);
							_tmp75_ = _tmp74_;
							if (_tmp75_ == DNS_RR_CLASS_IN) {
								_tmp72_ = TRUE;
							} else {
								DnsQuestionRecord* _tmp76_;
								DnsRRClass _tmp77_;
								DnsRRClass _tmp78_;
								_tmp76_ = q;
								_tmp77_ = dns_question_record_get_rrclass (_tmp76_);
								_tmp78_ = _tmp77_;
								_tmp72_ = _tmp78_ == DNS_RR_CLASS_QR_ANY;
							}
							_tmp79_ = _tmp72_;
							if (_tmp79_) {
								DnsQuestionRecord* _tmp80_;
								DnsRRType _tmp81_;
								DnsRRType _tmp82_;
								_tmp80_ = q;
								_tmp81_ = dns_question_record_get_rrtype (_tmp80_);
								_tmp82_ = _tmp81_;
								_tmp71_ = _tmp82_ == DNS_RR_TYPE_PTR;
							} else {
								_tmp71_ = FALSE;
							}
							_tmp83_ = _tmp71_;
							if (_tmp83_) {
								DnsQuestionRecord* _tmp84_;
								const gchar* _tmp85_;
								const gchar* _tmp86_;
								gint _tmp87_;
								gint _tmp88_;
								_tmp84_ = q;
								_tmp85_ = dns_question_record_get_name (_tmp84_);
								_tmp86_ = _tmp85_;
								_tmp87_ = strlen (_tmp86_);
								_tmp88_ = _tmp87_;
								_tmp70_ = _tmp88_ > 14;
							} else {
								_tmp70_ = FALSE;
							}
							_tmp89_ = _tmp70_;
							if (_tmp89_) {
								DnsQuestionRecord* _tmp90_;
								const gchar* _tmp91_;
								const gchar* _tmp92_;
								DnsQuestionRecord* _tmp93_;
								const gchar* _tmp94_;
								const gchar* _tmp95_;
								gint _tmp96_;
								gint _tmp97_;
								gchar* _tmp98_ = NULL;
								gchar* _tmp99_;
								gchar* _tmp100_ = NULL;
								gchar* _tmp101_;
								_tmp90_ = q;
								_tmp91_ = dns_question_record_get_name (_tmp90_);
								_tmp92_ = _tmp91_;
								_tmp93_ = q;
								_tmp94_ = dns_question_record_get_name (_tmp93_);
								_tmp95_ = _tmp94_;
								_tmp96_ = strlen (_tmp95_);
								_tmp97_ = _tmp96_;
								_tmp98_ = string_substring (_tmp92_, (glong) (_tmp97_ - 14), (glong) (-1));
								_tmp99_ = _tmp98_;
								_tmp100_ = g_utf8_strup (_tmp99_, (gssize) (-1));
								_tmp101_ = _tmp100_;
								_tmp69_ = g_strcmp0 (_tmp101_, ".IN-ADDR.ARPA.") == 0;
								_g_free0 (_tmp101_);
								_g_free0 (_tmp99_);
							} else {
								_tmp69_ = FALSE;
							}
							_tmp102_ = _tmp69_;
							if (_tmp102_) {
								DnsQuestionRecord* _tmp103_;
								GeeList* _tmp104_ = NULL;
								GeeList* r;
								DnsMessage* _tmp105_;
								DnsMessage* _tmp106_ = NULL;
								DnsMessage* resp;
								GeeList* _tmp107_;
								gboolean _tmp108_;
								gboolean _tmp109_;
								DnsMessage* _tmp114_;
								gint _tmp115_ = 0;
								guint8* _tmp116_ = NULL;
								guint8* dns_resp;
								gint dns_resp_length1;
								gint _dns_resp_size_;
								GSocket* _tmp117_;
								GSocketAddress* _tmp118_;
								guint8* _tmp119_;
								gint _tmp119__length1;
								_tmp103_ = q;
								_tmp104_ = handle_request_arg_inv_qry (self, _tmp103_);
								r = _tmp104_;
								_tmp105_ = query;
								_tmp106_ = dns_message_make_response (_tmp105_);
								resp = _tmp106_;
								_tmp107_ = r;
								_tmp108_ = gee_collection_get_is_empty ((GeeCollection*) _tmp107_);
								_tmp109_ = _tmp108_;
								if (_tmp109_) {
									DnsMessage* _tmp110_;
									_tmp110_ = resp;
									_tmp110_->rcode = DNS_RESPONSE_CODE_NOTFOUND;
								} else {
									DnsMessage* _tmp111_;
									GeeArrayList* _tmp112_;
									GeeList* _tmp113_;
									_tmp111_ = resp;
									_tmp112_ = _tmp111_->answer_recs;
									_tmp113_ = r;
									gee_array_list_add_all (_tmp112_, (GeeCollection*) _tmp113_);
								}
								_tmp114_ = resp;
								_tmp116_ = dns_message_to_wire (_tmp114_, &_tmp115_);
								dns_resp = _tmp116_;
								dns_resp_length1 = _tmp115_;
								_dns_resp_size_ = dns_resp_length1;
								_tmp117_ = listening_socket;
								_tmp118_ = self->client_address;
								_tmp119_ = dns_resp;
								_tmp119__length1 = dns_resp_length1;
								g_socket_send_to (_tmp117_, _tmp118_, _tmp119_, (gsize) _tmp119__length1, NULL, &_inner_error_);
								if (_inner_error_ != NULL) {
									dns_resp = (g_free (dns_resp), NULL);
									_g_object_unref0 (resp);
									_g_object_unref0 (r);
									_g_object_unref0 (q);
									goto __finally1;
								}
								dns_resp = (g_free (dns_resp), NULL);
								_g_object_unref0 (resp);
								_g_object_unref0 (r);
							}
						}
						_g_object_unref0 (q);
					}
				}
			}
			__finally1:
			{
				GeeArrayList* _tmp120_;
				DnsMessage* _tmp121_;
				guint16 _tmp122_;
				gboolean _tmp123_ = FALSE;
				_tmp120_ = serving_ids;
				_tmp121_ = query;
				_tmp122_ = _tmp121_->id;
				_tmp123_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp120_, (gpointer) ((guintptr) _tmp122_));
				if (_tmp123_) {
					GeeArrayList* _tmp124_;
					DnsMessage* _tmp125_;
					guint16 _tmp126_;
					_tmp124_ = serving_ids;
					_tmp125_ = query;
					_tmp126_ = _tmp125_->id;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp124_, (gpointer) ((guintptr) _tmp126_));
				}
			}
			if (_inner_error_ != NULL) {
				_g_thread_unref0 (thread);
				_g_object_unref0 (a);
				_g_object_unref0 (query);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			_g_thread_unref0 (thread);
			_g_object_unref0 (a);
		}
	}
	result = 0;
	_g_object_unref0 (query);
	return result;
}


static gboolean handle_request_arg_check_forward_to_dns (HandleRequestArg* self, DnsMessage* query) {
	gboolean result = FALSE;
	gboolean dns;
	DnsMessage* _tmp0_;
	DnsOperationCode _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (query != NULL, FALSE);
	dns = TRUE;
	_tmp0_ = query;
	_tmp1_ = _tmp0_->opcode;
	if (_tmp1_ == DNS_OPERATION_CODE_IP_TO_NAME) {
		log_info ("Got obsolete DNS request of type IP_TO_NAME");
	} else {
		DnsMessage* _tmp2_;
		DnsOperationCode _tmp3_;
		_tmp2_ = query;
		_tmp3_ = _tmp2_->opcode;
		if (_tmp3_ == DNS_OPERATION_CODE_NAME_TO_IP) {
			DnsMessage* _tmp4_;
			GeeArrayList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp4_ = query;
			_tmp5_ = _tmp4_->question_recs;
			_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ > 0) {
				DnsMessage* _tmp8_;
				GeeArrayList* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				DnsMessage* _tmp20_;
				GeeArrayList* _tmp21_;
				gpointer _tmp22_ = NULL;
				DnsQuestionRecord* q;
				gboolean _tmp23_ = FALSE;
				DnsQuestionRecord* _tmp24_;
				DnsRRClass _tmp25_;
				DnsRRClass _tmp26_;
				gboolean _tmp30_;
				_tmp8_ = query;
				_tmp9_ = _tmp8_->question_recs;
				_tmp10_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp9_);
				_tmp11_ = _tmp10_;
				if (_tmp11_ > 1) {
					DnsMessage* _tmp12_;
					GeeArrayList* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					_tmp12_ = query;
					_tmp13_ = _tmp12_->question_recs;
					_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_strdup_printf ("%i", _tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strconcat ("Got ", _tmp17_, " questions in a message. Only first one will be examined.", NULL);
					_tmp19_ = _tmp18_;
					log_warn (_tmp19_);
					_g_free0 (_tmp19_);
					_g_free0 (_tmp17_);
				}
				_tmp20_ = query;
				_tmp21_ = _tmp20_->question_recs;
				_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, 0);
				q = (DnsQuestionRecord*) _tmp22_;
				_tmp24_ = q;
				_tmp25_ = dns_question_record_get_rrclass (_tmp24_);
				_tmp26_ = _tmp25_;
				if (_tmp26_ == DNS_RR_CLASS_IN) {
					DnsQuestionRecord* _tmp27_;
					DnsRRType _tmp28_;
					DnsRRType _tmp29_;
					_tmp27_ = q;
					_tmp28_ = dns_question_record_get_rrtype (_tmp27_);
					_tmp29_ = _tmp28_;
					_tmp23_ = _tmp29_ == DNS_RR_TYPE_A;
				} else {
					_tmp23_ = FALSE;
				}
				_tmp30_ = _tmp23_;
				if (_tmp30_) {
					gboolean _tmp31_ = FALSE;
					DnsQuestionRecord* _tmp32_;
					const gchar* _tmp33_;
					const gchar* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					gboolean _tmp49_;
					_tmp32_ = q;
					_tmp33_ = dns_question_record_get_name (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = strlen (_tmp34_);
					_tmp36_ = _tmp35_;
					if (_tmp36_ < 5) {
						_tmp31_ = TRUE;
					} else {
						DnsQuestionRecord* _tmp37_;
						const gchar* _tmp38_;
						const gchar* _tmp39_;
						DnsQuestionRecord* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						gint _tmp43_;
						gint _tmp44_;
						gchar* _tmp45_ = NULL;
						gchar* _tmp46_;
						gchar* _tmp47_ = NULL;
						gchar* _tmp48_;
						_tmp37_ = q;
						_tmp38_ = dns_question_record_get_name (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = q;
						_tmp41_ = dns_question_record_get_name (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = strlen (_tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = string_substring (_tmp39_, (glong) (_tmp44_ - 5), (glong) (-1));
						_tmp46_ = _tmp45_;
						_tmp47_ = g_utf8_strup (_tmp46_, (gssize) (-1));
						_tmp48_ = _tmp47_;
						_tmp31_ = g_strcmp0 (_tmp48_, ".NTK.") != 0;
						_g_free0 (_tmp48_);
						_g_free0 (_tmp46_);
					}
					_tmp49_ = _tmp31_;
					dns = _tmp49_;
				} else {
					gboolean _tmp50_ = FALSE;
					gboolean _tmp51_ = FALSE;
					gboolean _tmp52_ = FALSE;
					gboolean _tmp53_ = FALSE;
					DnsQuestionRecord* _tmp54_;
					DnsRRClass _tmp55_;
					DnsRRClass _tmp56_;
					gboolean _tmp60_;
					gboolean _tmp64_;
					gboolean _tmp70_;
					gboolean _tmp83_;
					_tmp54_ = q;
					_tmp55_ = dns_question_record_get_rrclass (_tmp54_);
					_tmp56_ = _tmp55_;
					if (_tmp56_ == DNS_RR_CLASS_IN) {
						_tmp53_ = TRUE;
					} else {
						DnsQuestionRecord* _tmp57_;
						DnsRRClass _tmp58_;
						DnsRRClass _tmp59_;
						_tmp57_ = q;
						_tmp58_ = dns_question_record_get_rrclass (_tmp57_);
						_tmp59_ = _tmp58_;
						_tmp53_ = _tmp59_ == DNS_RR_CLASS_QR_ANY;
					}
					_tmp60_ = _tmp53_;
					if (_tmp60_) {
						DnsQuestionRecord* _tmp61_;
						DnsRRType _tmp62_;
						DnsRRType _tmp63_;
						_tmp61_ = q;
						_tmp62_ = dns_question_record_get_rrtype (_tmp61_);
						_tmp63_ = _tmp62_;
						_tmp52_ = _tmp63_ == DNS_RR_TYPE_PTR;
					} else {
						_tmp52_ = FALSE;
					}
					_tmp64_ = _tmp52_;
					if (_tmp64_) {
						DnsQuestionRecord* _tmp65_;
						const gchar* _tmp66_;
						const gchar* _tmp67_;
						gint _tmp68_;
						gint _tmp69_;
						_tmp65_ = q;
						_tmp66_ = dns_question_record_get_name (_tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = strlen (_tmp67_);
						_tmp69_ = _tmp68_;
						_tmp51_ = _tmp69_ > 20;
					} else {
						_tmp51_ = FALSE;
					}
					_tmp70_ = _tmp51_;
					if (_tmp70_) {
						DnsQuestionRecord* _tmp71_;
						const gchar* _tmp72_;
						const gchar* _tmp73_;
						DnsQuestionRecord* _tmp74_;
						const gchar* _tmp75_;
						const gchar* _tmp76_;
						gint _tmp77_;
						gint _tmp78_;
						gchar* _tmp79_ = NULL;
						gchar* _tmp80_;
						gchar* _tmp81_ = NULL;
						gchar* _tmp82_;
						_tmp71_ = q;
						_tmp72_ = dns_question_record_get_name (_tmp71_);
						_tmp73_ = _tmp72_;
						_tmp74_ = q;
						_tmp75_ = dns_question_record_get_name (_tmp74_);
						_tmp76_ = _tmp75_;
						_tmp77_ = strlen (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = string_substring (_tmp73_, (glong) (_tmp78_ - 14), (glong) (-1));
						_tmp80_ = _tmp79_;
						_tmp81_ = g_utf8_strup (_tmp80_, (gssize) (-1));
						_tmp82_ = _tmp81_;
						_tmp50_ = g_strcmp0 (_tmp82_, ".IN-ADDR.ARPA.") == 0;
						_g_free0 (_tmp82_);
						_g_free0 (_tmp80_);
					} else {
						_tmp50_ = FALSE;
					}
					_tmp83_ = _tmp50_;
					if (_tmp83_) {
						DnsQuestionRecord* _tmp84_;
						const gchar* _tmp85_;
						const gchar* _tmp86_;
						DnsQuestionRecord* _tmp87_;
						const gchar* _tmp88_;
						const gchar* _tmp89_;
						gint _tmp90_;
						gint _tmp91_;
						gchar* _tmp92_ = NULL;
						gchar* _tmp93_;
						gchar* _tmp94_ = NULL;
						gchar* _tmp95_;
						_tmp84_ = q;
						_tmp85_ = dns_question_record_get_name (_tmp84_);
						_tmp86_ = _tmp85_;
						_tmp87_ = q;
						_tmp88_ = dns_question_record_get_name (_tmp87_);
						_tmp89_ = _tmp88_;
						_tmp90_ = strlen (_tmp89_);
						_tmp91_ = _tmp90_;
						_tmp92_ = string_substring (_tmp86_, (glong) (_tmp91_ - 17), (glong) (-1));
						_tmp93_ = _tmp92_;
						_tmp94_ = g_utf8_strup (_tmp93_, (gssize) (-1));
						_tmp95_ = _tmp94_;
						dns = g_strcmp0 (_tmp95_, ".10.IN-ADDR.ARPA.") != 0;
						_g_free0 (_tmp95_);
						_g_free0 (_tmp93_);
					}
				}
				_g_object_unref0 (q);
			}
		} else {
			log_info ("Got unsupported type of DNS request");
		}
	}
	result = dns;
	return result;
}


static guint8* _vala_array_dup4 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static GeeList* handle_request_arg_std_qry (HandleRequestArg* self, DnsQuestionRecord* q) {
	GeeList* result = NULL;
	DnsQuestionRecord* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	DnsQuestionRecord* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* name;
	GeeList* _tmp9_ = NULL;
	GeeList* resp;
	GeeArrayList* _tmp10_;
	GeeArrayList* ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (q != NULL, NULL);
	_tmp0_ = q;
	_tmp1_ = dns_question_record_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = q;
	_tmp4_ = dns_question_record_get_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_substring (_tmp2_, (glong) 0, (glong) (_tmp7_ - 5));
	name = _tmp8_;
	_tmp9_ = ntkresolv_resolv (name, NULL, NULL, "127.0.0.1", &_inner_error_);
	resp = _tmp9_;
	if (_inner_error_ != NULL) {
		_g_free0 (name);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp10_ = gee_array_list_new (DNS_TYPE_RES_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ret = _tmp10_;
	{
		GeeList* _tmp11_;
		GeeList* _addrinfo_list;
		GeeList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _addrinfo_size;
		gint _addrinfo_index;
		_tmp11_ = _g_object_ref0 (resp);
		_addrinfo_list = _tmp11_;
		_tmp12_ = _addrinfo_list;
		_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_addrinfo_size = _tmp14_;
		_addrinfo_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			GeeList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_ = NULL;
			NtkresolvNtkAddrInfo* addrinfo;
			NtkresolvNtkAddrInfo* _tmp21_;
			NtkresolvNtkAddr* _tmp22_;
			guint8* _tmp23_;
			gint _tmp23__length1;
			guint8* addr;
			gint addr_length1;
			gint _addr_size_;
			DnsQuestionRecord* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			guint8* _tmp27_;
			gint _tmp27__length1;
			DnsResRecord* _tmp28_;
			DnsResRecord* r;
			GeeArrayList* _tmp29_;
			DnsResRecord* _tmp30_;
			_tmp15_ = _addrinfo_index;
			_addrinfo_index = _tmp15_ + 1;
			_tmp16_ = _addrinfo_index;
			_tmp17_ = _addrinfo_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _addrinfo_list;
			_tmp19_ = _addrinfo_index;
			_tmp20_ = gee_list_get (_tmp18_, _tmp19_);
			addrinfo = (NtkresolvNtkAddrInfo*) _tmp20_;
			_tmp21_ = addrinfo;
			_tmp22_ = _tmp21_->address;
			_tmp23_ = ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, NTKRESOLV_TYPE_NTK_INET_ADDR) ? ((NtkresolvNtkInetAddr*) _tmp22_) : NULL)->addr != NULL) ? _vala_array_dup4 ((G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, NTKRESOLV_TYPE_NTK_INET_ADDR) ? ((NtkresolvNtkInetAddr*) _tmp22_) : NULL)->addr, 4) : ((gpointer) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, NTKRESOLV_TYPE_NTK_INET_ADDR) ? ((NtkresolvNtkInetAddr*) _tmp22_) : NULL)->addr);
			_tmp23__length1 = 4;
			addr = _tmp23_;
			addr_length1 = _tmp23__length1;
			_addr_size_ = addr_length1;
			_tmp24_ = q;
			_tmp25_ = dns_question_record_get_name (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = addr;
			_tmp27__length1 = addr_length1;
			_tmp28_ = dns_res_record_new_inetaddr (_tmp26_, DNS_RR_TYPE_A, DNS_RR_CLASS_IN, (gint32) 300, _tmp27_, _tmp27__length1);
			r = _tmp28_;
			_tmp29_ = ret;
			_tmp30_ = r;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp30_);
			_g_object_unref0 (r);
			addr = (g_free (addr), NULL);
			_g_object_unref0 (addrinfo);
		}
		_g_object_unref0 (_addrinfo_list);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (resp);
	_g_free0 (name);
	return result;
}


static GeeList* handle_request_arg_inv_qry (HandleRequestArg* self, DnsQuestionRecord* q) {
	GeeList* result = NULL;
	DnsQuestionRecord* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	DnsQuestionRecord* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* ipstr;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp13_ = NULL;
	gchar** rev;
	gint rev_length1;
	gint _rev_size_;
	gint j;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_ = NULL;
	guint8 addr_bytes[4] = {0};
	const gchar* _tmp28_;
	NtkresolvNtkInetAddr* _tmp29_;
	NtkresolvNtkAddr* addr;
	NtkresolvNtkAddr* _tmp30_;
	GeeList* _tmp31_ = NULL;
	GeeList* resp;
	GeeArrayList* _tmp32_;
	GeeArrayList* ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (q != NULL, NULL);
	_tmp0_ = q;
	_tmp1_ = dns_question_record_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = q;
	_tmp4_ = dns_question_record_get_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_substring (_tmp2_, (glong) 0, (glong) (_tmp7_ - 14));
	ipstr = _tmp8_;
	_tmp9_ = ipstr;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ".", 0);
	parts = _tmp11_;
	parts_length1 = _vala_array_length (_tmp10_);
	_parts_size_ = parts_length1;
	_tmp12_ = parts;
	_tmp12__length1 = parts_length1;
	_tmp13_ = g_new0 (gchar*, _tmp12__length1 + 1);
	rev = _tmp13_;
	rev_length1 = _tmp12__length1;
	_rev_size_ = rev_length1;
	j = 0;
	{
		gchar** _tmp14_;
		gint _tmp14__length1;
		gint i;
		_tmp14_ = parts;
		_tmp14__length1 = parts_length1;
		i = _tmp14__length1 - 1;
		{
			gboolean _tmp15_;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp16_;
				gint _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				gint _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				_tmp16_ = _tmp15_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = i;
					i = _tmp17_ - 1;
				}
				_tmp15_ = FALSE;
				_tmp18_ = i;
				if (!(_tmp18_ >= 0)) {
					break;
				}
				_tmp19_ = rev;
				_tmp19__length1 = rev_length1;
				_tmp20_ = j;
				j = _tmp20_ + 1;
				_tmp21_ = parts;
				_tmp21__length1 = parts_length1;
				_tmp22_ = i;
				_tmp23_ = _tmp21_[_tmp22_];
				_tmp24_ = g_strdup (_tmp23_);
				_g_free0 (_tmp19_[_tmp20_]);
				_tmp19_[_tmp20_] = _tmp24_;
				_tmp25_ = _tmp19_[_tmp20_];
			}
		}
	}
	_tmp26_ = rev;
	_tmp26__length1 = rev_length1;
	_tmp27_ = g_strjoinv (".", _tmp26_);
	_g_free0 (ipstr);
	ipstr = _tmp27_;
	_tmp28_ = ipstr;
	netsukuku_inet_utils_address_v4_str_to_bytes (_tmp28_, addr_bytes);
	_tmp29_ = ntkresolv_ntk_inet_addr_new (addr_bytes, 4, (guint16) 0);
	addr = (NtkresolvNtkAddr*) _tmp29_;
	_tmp30_ = addr;
	_tmp31_ = ntkresolv_inverse (NTKRESOLV_IP_FAMILY_IPV4, _tmp30_, "127.0.0.1", &_inner_error_);
	resp = _tmp31_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (addr);
		rev = (_vala_array_free (rev, rev_length1, (GDestroyNotify) g_free), NULL);
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (ipstr);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp32_ = gee_array_list_new (DNS_TYPE_RES_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ret = _tmp32_;
	{
		GeeList* _tmp33_;
		GeeList* _tmp34_;
		GeeList* _ptr_list;
		GeeList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _ptr_size;
		gint _ptr_index;
		_tmp33_ = resp;
		_tmp34_ = _g_object_ref0 (_tmp33_);
		_ptr_list = _tmp34_;
		_tmp35_ = _ptr_list;
		_tmp36_ = gee_collection_get_size ((GeeCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_ptr_size = _tmp37_;
		_ptr_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			GeeList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_ = NULL;
			gchar* ptr;
			DnsQuestionRecord* _tmp44_;
			const gchar* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			DnsResRecord* _tmp50_;
			DnsResRecord* _tmp51_;
			DnsResRecord* r;
			GeeArrayList* _tmp52_;
			DnsResRecord* _tmp53_;
			_tmp38_ = _ptr_index;
			_ptr_index = _tmp38_ + 1;
			_tmp39_ = _ptr_index;
			_tmp40_ = _ptr_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _ptr_list;
			_tmp42_ = _ptr_index;
			_tmp43_ = gee_list_get (_tmp41_, _tmp42_);
			ptr = (gchar*) _tmp43_;
			_tmp44_ = q;
			_tmp45_ = dns_question_record_get_name (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = ptr;
			_tmp48_ = g_strconcat (_tmp47_, ".NTK.", NULL);
			_tmp49_ = _tmp48_;
			_tmp50_ = dns_res_record_new_ptr (_tmp46_, DNS_RR_TYPE_PTR, DNS_RR_CLASS_IN, (gint32) 300, _tmp49_, &_inner_error_);
			_tmp51_ = _tmp50_;
			_g_free0 (_tmp49_);
			r = _tmp51_;
			if (_inner_error_ != NULL) {
				_g_free0 (ptr);
				_g_object_unref0 (_ptr_list);
				_g_object_unref0 (ret);
				_g_object_unref0 (resp);
				_g_object_unref0 (addr);
				rev = (_vala_array_free (rev, rev_length1, (GDestroyNotify) g_free), NULL);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (ipstr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp52_ = ret;
			_tmp53_ = r;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp53_);
			_g_object_unref0 (r);
			_g_free0 (ptr);
		}
		_g_object_unref0 (_ptr_list);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (resp);
	_g_object_unref0 (addr);
	rev = (_vala_array_free (rev, rev_length1, (GDestroyNotify) g_free), NULL);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ipstr);
	return result;
}


static void handle_request_arg_class_init (HandleRequestArgClass * klass) {
	handle_request_arg_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = handle_request_arg_finalize;
}


static void handle_request_arg_instance_init (HandleRequestArg * self) {
}


static void handle_request_arg_finalize (GObject* obj) {
	HandleRequestArg * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HANDLE_REQUEST_ARG, HandleRequestArg);
	_g_object_unref0 (self->client_address);
	self->buffer = (g_free (self->buffer), NULL);
	G_OBJECT_CLASS (handle_request_arg_parent_class)->finalize (obj);
}


/** This class is associated to a thread that executes its method handle_request().
  * Its duty is to handle a dns request from a client.
  */
GType handle_request_arg_get_type (void) {
	static volatile gsize handle_request_arg_type_id__volatile = 0;
	if (g_once_init_enter (&handle_request_arg_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HandleRequestArgClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) handle_request_arg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HandleRequestArg), 0, (GInstanceInitFunc) handle_request_arg_instance_init, NULL };
		GType handle_request_arg_type_id;
		handle_request_arg_type_id = g_type_register_static (G_TYPE_OBJECT, "HandleRequestArg", &g_define_type_info, 0);
		g_once_init_leave (&handle_request_arg_type_id__volatile, handle_request_arg_type_id);
	}
	return handle_request_arg_type_id__volatile;
}


gchar** read_file (const gchar* path, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** ret;
	gint ret_length1;
	gint _ret_size_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	ret = _tmp0_;
	ret_length1 = 0;
	_ret_size_ = ret_length1;
	_tmp1_ = path;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_EXISTS);
	if (_tmp2_) {
		{
			gchar* contents = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			const gchar* _tmp7_;
			gchar** _tmp8_;
			gchar** _tmp9_ = NULL;
			_tmp3_ = path;
			_tmp5_ = g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error_);
			_g_free0 (contents);
			contents = _tmp4_;
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				_g_free0 (contents);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch2_g_file_error;
				}
				_g_free0 (contents);
				ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_vala_assert (_tmp6_, "FileUtils.get_contents(path, out contents)");
			_tmp7_ = contents;
			_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "\n", 0);
			ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) g_free), NULL);
			ret = _tmp9_;
			ret_length1 = _vala_array_length (_tmp8_);
			_ret_size_ = ret_length1;
			_g_free0 (contents);
		}
		goto __finally2;
		__catch2_g_file_error:
		{
			GError* e = NULL;
			GQuark _tmp10_;
			const gchar* _tmp11_ = NULL;
			gint _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp10_ = e->domain;
			_tmp11_ = g_quark_to_string (_tmp10_);
			_tmp12_ = e->code;
			_tmp13_ = e->message;
			_tmp14_ = g_strdup_printf ("%s: %d: %s", _tmp11_, _tmp12_, _tmp13_);
			_tmp15_ = _tmp14_;
			g_error ("dns-to-andna.vala:869: %s", _tmp15_);
			_g_free0 (_tmp15_);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp16_ = ret;
	_tmp16__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	return result;
}


static gpointer _handle_request_arg_handle_request_gthread_func (gpointer self) {
	gpointer result;
	result = handle_request_arg_handle_request (self);
	return result;
}


void _vala_main (gchar** argv, int argv_length1) {
	GeeArrayList* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gchar** lines;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GeeArrayList* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	GKeyFile* _tmp24_;
	GKeyFile* conf;
	gboolean _tmp27_ = FALSE;
	GKeyFile* _tmp28_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp33_;
	GKeyFile* _tmp34_;
	gchar* _tmp35_ = NULL;
	gchar* dns_to_andna_address;
	const gchar* _tmp36_;
	GInetAddress* _tmp37_;
	GInetAddress* _tmp38_;
	GInetSocketAddress* _tmp39_;
	GInetSocketAddress* _tmp40_;
	GInetSocketAddress* bind_address;
	GSocket* _tmp41_;
	GSocket* _tmp42_;
	GSocket* _tmp43_;
	GInetSocketAddress* _tmp44_;
	GeeArrayList* _tmp45_;
	GError * _inner_error_ = NULL;
	_tmp0_ = gee_array_list_new (g_socket_address_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (dns_list);
	dns_list = _tmp0_;
	_tmp2_ = read_file (SYSCONF_DIR "/resolv.conf", &_tmp1_);
	lines = _tmp2_;
	lines_length1 = _tmp1_;
	_lines_size_ = lines_length1;
	_tmp3_ = lines;
	_tmp3__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp3_;
		line_collection_length1 = _tmp3__length1;
		for (line_it = 0; line_it < _tmp3__length1; line_it = line_it + 1) {
			gchar* _tmp4_;
			gchar* line = NULL;
			_tmp4_ = g_strdup (line_collection[line_it]);
			line = _tmp4_;
			{
				const gchar* _tmp5_;
				gboolean _tmp6_ = FALSE;
				_tmp5_ = line;
				_tmp6_ = g_regex_match_simple ("^\\s*nameserver\\s+", _tmp5_, 0, 0);
				if (_tmp6_) {
					GMatchInfo* m = NULL;
					GRegex* _tmp7_;
					GRegex* r;
					GRegex* _tmp8_;
					const gchar* _tmp9_;
					GMatchInfo* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
					GMatchInfo* _tmp12_;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_;
					GInetAddress* _tmp15_;
					GInetAddress* _tmp16_;
					GInetSocketAddress* _tmp17_;
					GInetSocketAddress* _tmp18_;
					GInetSocketAddress* dns_address;
					GeeArrayList* _tmp19_;
					GInetSocketAddress* _tmp20_;
					_tmp7_ = g_regex_new ("[0-9.]+", 0, 0, &_inner_error_);
					r = _tmp7_;
					if (_inner_error_ != NULL) {
						_g_match_info_free0 (m);
						_g_free0 (line);
						lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp8_ = r;
					_tmp9_ = line;
					_tmp11_ = g_regex_match (_tmp8_, _tmp9_, 0, &_tmp10_);
					_g_match_info_free0 (m);
					m = _tmp10_;
					if (!_tmp11_) {
						_g_regex_unref0 (r);
						_g_match_info_free0 (m);
						_g_free0 (line);
						continue;
					}
					_tmp12_ = m;
					_tmp13_ = g_match_info_fetch (_tmp12_, 0);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_inet_address_new_from_string (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = (GInetSocketAddress*) g_inet_socket_address_new (_tmp16_, (guint16) 53);
					_tmp18_ = _tmp17_;
					_g_object_unref0 (_tmp16_);
					_g_free0 (_tmp14_);
					dns_address = _tmp18_;
					_tmp19_ = dns_list;
					_tmp20_ = dns_address;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (GSocketAddress*) _tmp20_);
					_g_object_unref0 (dns_address);
					_g_regex_unref0 (r);
					_g_match_info_free0 (m);
				}
				_g_free0 (line);
			}
		}
	}
	_tmp21_ = dns_list;
	_tmp22_ = gee_collection_get_is_empty ((GeeCollection*) _tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_) {
		g_error ("dns-to-andna.vala:892: Error reading resolv.conf: no IPv4 nameserver f" \
"ound");
	}
	_tmp24_ = g_key_file_new ();
	conf = _tmp24_;
	{
		GKeyFile* _tmp25_;
		_tmp25_ = conf;
		g_key_file_load_from_file (_tmp25_, SYSCONF_DIR "/ntkresolv/ntkresolv.ini", G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch3_g_key_file_error;
			}
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError* e = NULL;
		const gchar* _tmp26_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e->message;
		g_error ("dns-to-andna.vala:903: %s", _tmp26_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_key_file_unref0 (conf);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp28_ = conf;
	_tmp29_ = g_key_file_has_group (_tmp28_, "NTKRESOLV");
	if (!_tmp29_) {
		_tmp27_ = TRUE;
	} else {
		GKeyFile* _tmp30_;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_;
		_tmp30_ = conf;
		_tmp31_ = g_key_file_has_key (_tmp30_, "NTKRESOLV", "DNS_TO_ANDNA", &_inner_error_);
		_tmp32_ = _tmp31_;
		if (_inner_error_ != NULL) {
			_g_key_file_unref0 (conf);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp27_ = !_tmp32_;
	}
	_tmp33_ = _tmp27_;
	if (_tmp33_) {
		g_error ("dns-to-andna.vala:907: Missing key DNS_TO_ANDNA in section [NTKRESOLV]" \
" of file ntkresolv.ini");
	}
	_tmp34_ = conf;
	_tmp35_ = g_key_file_get_string (_tmp34_, "NTKRESOLV", "DNS_TO_ANDNA", &_inner_error_);
	dns_to_andna_address = _tmp35_;
	if (_inner_error_ != NULL) {
		_g_key_file_unref0 (conf);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp36_ = dns_to_andna_address;
	_tmp37_ = g_inet_address_new_from_string (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = (GInetSocketAddress*) g_inet_socket_address_new (_tmp38_, (guint16) 53);
	_tmp40_ = _tmp39_;
	_g_object_unref0 (_tmp38_);
	bind_address = _tmp40_;
	_tmp41_ = g_socket_new (G_SOCKET_FAMILY_IPV4, G_SOCKET_TYPE_DATAGRAM, G_SOCKET_PROTOCOL_UDP, &_inner_error_);
	_tmp42_ = _tmp41_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (bind_address);
		_g_free0 (dns_to_andna_address);
		_g_key_file_unref0 (conf);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (listening_socket);
	listening_socket = _tmp42_;
	_tmp43_ = listening_socket;
	_tmp44_ = bind_address;
	g_socket_bind (_tmp43_, (GSocketAddress*) _tmp44_, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (bind_address);
		_g_free0 (dns_to_andna_address);
		_g_key_file_unref0 (conf);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp45_ = gee_array_list_new (G_TYPE_INVALID, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (serving_ids);
	serving_ids = _tmp45_;
	while (TRUE) {
		GSocketAddress* client_address = NULL;
		guint8 buffer[1024] = {0};
		GSocket* _tmp46_;
		GSocketAddress* _tmp47_ = NULL;
		gssize _tmp48_ = 0L;
		gssize rec_size;
		gssize _tmp49_;
		guint8* _tmp50_ = NULL;
		guint8* buf;
		gint buf_length1;
		gint _buf_size_;
		GSocketAddress* _tmp61_;
		guint8* _tmp62_;
		gint _tmp62__length1;
		HandleRequestArg* _tmp63_;
		HandleRequestArg* a;
		HandleRequestArg* _tmp64_;
		GThread* _tmp65_;
		GThread* thread;
		_tmp46_ = listening_socket;
		_tmp48_ = g_socket_receive_from (_tmp46_, &_tmp47_, buffer, (gsize) 1024, NULL, &_inner_error_);
		_g_object_unref0 (client_address);
		client_address = _tmp47_;
		rec_size = _tmp48_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (client_address);
			_g_object_unref0 (bind_address);
			_g_free0 (dns_to_andna_address);
			_g_key_file_unref0 (conf);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp49_ = rec_size;
		_tmp50_ = g_new0 (guint8, _tmp49_);
		buf = _tmp50_;
		buf_length1 = _tmp49_;
		_buf_size_ = buf_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp51_;
				_tmp51_ = TRUE;
				while (TRUE) {
					gboolean _tmp52_;
					gint _tmp54_;
					gssize _tmp55_;
					guint8* _tmp56_;
					gint _tmp56__length1;
					gint _tmp57_;
					gint _tmp58_;
					guint8 _tmp59_;
					guint8 _tmp60_;
					_tmp52_ = _tmp51_;
					if (!_tmp52_) {
						gint _tmp53_;
						_tmp53_ = i;
						i = _tmp53_ + 1;
					}
					_tmp51_ = FALSE;
					_tmp54_ = i;
					_tmp55_ = rec_size;
					if (!(((gssize) _tmp54_) < _tmp55_)) {
						break;
					}
					_tmp56_ = buf;
					_tmp56__length1 = buf_length1;
					_tmp57_ = i;
					_tmp58_ = i;
					_tmp59_ = buffer[_tmp58_];
					_tmp56_[_tmp57_] = _tmp59_;
					_tmp60_ = _tmp56_[_tmp57_];
				}
			}
		}
		_tmp61_ = client_address;
		_tmp62_ = buf;
		_tmp62__length1 = buf_length1;
		_tmp63_ = handle_request_arg_new (_tmp61_, _tmp62_, _tmp62__length1);
		a = _tmp63_;
		_tmp64_ = a;
		_tmp65_ = g_thread_try_new ("handle_request", _handle_request_arg_handle_request_gthread_func, g_object_ref (_tmp64_), &_inner_error_);
		thread = _tmp65_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (a);
			buf = (g_free (buf), NULL);
			_g_object_unref0 (client_address);
			_g_object_unref0 (bind_address);
			_g_free0 (dns_to_andna_address);
			_g_key_file_unref0 (conf);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_thread_unref0 (thread);
		_g_object_unref0 (a);
		buf = (g_free (buf), NULL);
		_g_object_unref0 (client_address);
	}
	_g_object_unref0 (bind_address);
	_g_free0 (dns_to_andna_address);
	_g_key_file_unref0 (conf);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


int main (int argc, char ** argv) {
	g_type_init ();
	_vala_main (argv, argc);
	return 0;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



