/* testnssmodule.c generated by valac 0.20.1, the Vala compiler
 * generated from testnssmodule.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include "nssandna.h"
#include <sys/socket.h>
#include <nss.h>
#include <errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>


#define NSS_TEST_TYPE_NSS_TESTER (nss_test_nss_tester_get_type ())
#define NSS_TEST_NSS_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NSS_TEST_TYPE_NSS_TESTER, NssTestNssTester))
#define NSS_TEST_NSS_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NSS_TEST_TYPE_NSS_TESTER, NssTestNssTesterClass))
#define NSS_TEST_IS_NSS_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NSS_TEST_TYPE_NSS_TESTER))
#define NSS_TEST_IS_NSS_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NSS_TEST_TYPE_NSS_TESTER))
#define NSS_TEST_NSS_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NSS_TEST_TYPE_NSS_TESTER, NssTestNssTesterClass))

typedef struct _NssTestNssTester NssTestNssTester;
typedef struct _NssTestNssTesterClass NssTestNssTesterClass;
typedef struct _NssTestNssTesterPrivate NssTestNssTesterPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NssTestNssTester {
	GObject parent_instance;
	NssTestNssTesterPrivate * priv;
};

struct _NssTestNssTesterClass {
	GObjectClass parent_class;
};


extern gchar* nss_test_logger;
gchar* nss_test_logger = NULL;
static gpointer nss_test_nss_tester_parent_class = NULL;

#define NSS_TEST_output FALSE
void nss_test_print_out (const gchar* s);
GType nss_test_nss_tester_get_type (void) G_GNUC_CONST;
enum  {
	NSS_TEST_NSS_TESTER_DUMMY_PROPERTY
};
void nss_test_nss_tester_set_up (NssTestNssTester* self);
void nss_test_nss_tester_tear_down (NssTestNssTester* self);
void nss_test_nss_tester_test_name_no_ntk (NssTestNssTester* self);
void nss_test_nss_tester_test_name_ipv6 (NssTestNssTester* self);
void nss_test_nss_tester_test_addr_no_class10 (NssTestNssTester* self);
void nss_test_nss_tester_test_addr_ipv6 (NssTestNssTester* self);
gint nss_test_nss_tester_main (gchar** args, int args_length1);
static void __lambda2_ (void);
NssTestNssTester* nss_test_nss_tester_new (void);
NssTestNssTester* nss_test_nss_tester_construct (GType object_type);
static void ___lambda2__gcallback (void);
static void __lambda3_ (void);
static void ___lambda3__gcallback (void);
static void __lambda4_ (void);
static void ___lambda4__gcallback (void);
static void __lambda5_ (void);
static void ___lambda5__gcallback (void);


void nss_test_print_out (const gchar* s) {
	g_return_if_fail (s != NULL);
	if (NSS_TEST_output) {
		const gchar* _tmp0_;
		_tmp0_ = s;
		g_print ("%s", _tmp0_);
	}
}


void nss_test_nss_tester_set_up (NssTestNssTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (nss_test_logger);
	nss_test_logger = _tmp0_;
}


void nss_test_nss_tester_tear_down (NssTestNssTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (nss_test_logger);
	nss_test_logger = _tmp0_;
}


void nss_test_nss_tester_test_name_no_ntk (NssTestNssTester* self) {
	struct hostent ret = {0};
	struct hostent* _result_ = NULL;
	gint myerrno;
	gchar buffer[4096] = {0};
	enum nss_status _tmp0_ = 0;
	enum nss_status risp;
	g_return_if_fail (self != NULL);
	myerrno = 0;
	_tmp0_ = _nss_andna_gethostbyname2_r ("name.com", AF_INET, &ret, buffer, (gsize) 4096, &_result_, &myerrno);
	risp = _tmp0_;
	_vala_assert (risp == NSS_STATUS_UNAVAIL, "risp == Nss.Status.Unavailable");
	_vala_assert (myerrno == EPERM, "myerrno == Posix.EPERM");
}


void nss_test_nss_tester_test_name_ipv6 (NssTestNssTester* self) {
	struct hostent ret = {0};
	struct hostent* _result_ = NULL;
	gint myerrno;
	gchar buffer[4096] = {0};
	enum nss_status _tmp0_ = 0;
	enum nss_status risp;
	g_return_if_fail (self != NULL);
	myerrno = 0;
	_tmp0_ = _nss_andna_gethostbyname2_r ("name.com", AF_INET6, &ret, buffer, (gsize) 4096, &_result_, &myerrno);
	risp = _tmp0_;
	_vala_assert (risp == NSS_STATUS_UNAVAIL, "risp == Nss.Status.Unavailable");
	_vala_assert (myerrno == ESRCH, "myerrno == Posix.ESRCH");
}


void nss_test_nss_tester_test_addr_no_class10 (NssTestNssTester* self) {
	struct hostent ret = {0};
	struct hostent* _result_ = NULL;
	gint myerrno;
	gchar buffer[4096] = {0};
	struct in_addr _tmp0_ = {0};
	struct in_addr addr;
	guint32 _tmp1_ = 0U;
	void* addr_p;
	socklen_t addr_len;
	enum nss_status _tmp2_ = 0;
	enum nss_status risp;
	g_return_if_fail (self != NULL);
	myerrno = 0;
	addr = _tmp0_;
	_tmp1_ = inet_addr ("192.168.2.2");
	addr.s_addr = _tmp1_;
	addr_p = &addr;
	addr_len = (socklen_t) sizeof (struct in_addr);
	_tmp2_ = _nss_andna_gethostbyaddr_r (addr_p, addr_len, AF_INET, &ret, buffer, (gsize) 4096, &_result_, &myerrno);
	risp = _tmp2_;
	_vala_assert (risp == NSS_STATUS_UNAVAIL, "risp == Nss.Status.Unavailable");
	_vala_assert (myerrno == EPERM, "myerrno == Posix.EPERM");
	 (addr);
}


void nss_test_nss_tester_test_addr_ipv6 (NssTestNssTester* self) {
	struct hostent ret = {0};
	struct hostent* _result_ = NULL;
	gint myerrno;
	gchar buffer[4096] = {0};
	struct in6_addr _tmp0_ = {0};
	struct in6_addr addr;
	void* addr_p;
	socklen_t addr_len;
	enum nss_status _tmp1_ = 0;
	enum nss_status risp;
	g_return_if_fail (self != NULL);
	myerrno = 0;
	addr = _tmp0_;
	addr_p = &addr;
	addr_len = (socklen_t) sizeof (struct in6_addr);
	_tmp1_ = _nss_andna_gethostbyaddr_r (addr_p, addr_len, AF_INET6, &ret, buffer, (gsize) 4096, &_result_, &myerrno);
	risp = _tmp1_;
	_vala_assert (risp == NSS_STATUS_UNAVAIL, "risp == Nss.Status.Unavailable");
	_vala_assert (myerrno == ESRCH, "myerrno == Posix.ESRCH");
	 (&addr);
}


static void __lambda2_ (void) {
	NssTestNssTester* _tmp0_;
	NssTestNssTester* x;
	_tmp0_ = nss_test_nss_tester_new ();
	x = _tmp0_;
	nss_test_nss_tester_set_up (x);
	nss_test_nss_tester_test_name_no_ntk (x);
	nss_test_nss_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda2__gcallback (void) {
	__lambda2_ ();
}


static void __lambda3_ (void) {
	NssTestNssTester* _tmp0_;
	NssTestNssTester* x;
	_tmp0_ = nss_test_nss_tester_new ();
	x = _tmp0_;
	nss_test_nss_tester_set_up (x);
	nss_test_nss_tester_test_name_ipv6 (x);
	nss_test_nss_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda3__gcallback (void) {
	__lambda3_ ();
}


static void __lambda4_ (void) {
	NssTestNssTester* _tmp0_;
	NssTestNssTester* x;
	_tmp0_ = nss_test_nss_tester_new ();
	x = _tmp0_;
	nss_test_nss_tester_set_up (x);
	nss_test_nss_tester_test_addr_no_class10 (x);
	nss_test_nss_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda4__gcallback (void) {
	__lambda4_ ();
}


static void __lambda5_ (void) {
	NssTestNssTester* _tmp0_;
	NssTestNssTester* x;
	_tmp0_ = nss_test_nss_tester_new ();
	x = _tmp0_;
	nss_test_nss_tester_set_up (x);
	nss_test_nss_tester_test_addr_ipv6 (x);
	nss_test_nss_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda5__gcallback (void) {
	__lambda5_ ();
}


gint nss_test_nss_tester_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/NssModule/NameNotNtk", ___lambda2__gcallback);
	g_test_add_func ("/NssModule/NameIPv6", ___lambda3__gcallback);
	g_test_add_func ("/NssModule/AddrNot10", ___lambda4__gcallback);
	g_test_add_func ("/NssModule/AddrIPv6", ___lambda5__gcallback);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return nss_test_nss_tester_main (argv, argc);
}


NssTestNssTester* nss_test_nss_tester_construct (GType object_type) {
	NssTestNssTester * self = NULL;
	self = (NssTestNssTester*) g_object_new (object_type, NULL);
	return self;
}


NssTestNssTester* nss_test_nss_tester_new (void) {
	return nss_test_nss_tester_construct (NSS_TEST_TYPE_NSS_TESTER);
}


static void nss_test_nss_tester_class_init (NssTestNssTesterClass * klass) {
	nss_test_nss_tester_parent_class = g_type_class_peek_parent (klass);
}


static void nss_test_nss_tester_instance_init (NssTestNssTester * self) {
}


GType nss_test_nss_tester_get_type (void) {
	static volatile gsize nss_test_nss_tester_type_id__volatile = 0;
	if (g_once_init_enter (&nss_test_nss_tester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NssTestNssTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nss_test_nss_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NssTestNssTester), 0, (GInstanceInitFunc) nss_test_nss_tester_instance_init, NULL };
		GType nss_test_nss_tester_type_id;
		nss_test_nss_tester_type_id = g_type_register_static (G_TYPE_OBJECT, "NssTestNssTester", &g_define_type_info, 0);
		g_once_init_leave (&nss_test_nss_tester_type_id__volatile, nss_test_nss_tester_type_id);
	}
	return nss_test_nss_tester_type_id__volatile;
}



