/* ntk-resolv.c generated by valac 0.20.1, the Vala compiler
 * generated from ntk-resolv.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include "ntkresolv.h"
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



#define LOG_LEAD ""
gchar* get_andnaserver (void);
gint _vala_main (gchar** args, int args_length1);


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


gchar* get_andnaserver (void) {
	gchar* result = NULL;
	gchar* ret;
	gchar* _tmp0_;
	gchar* fname;
	GKeyFile* _tmp1_;
	GKeyFile* conf;
	GError * _inner_error_ = NULL;
	ret = NULL;
	_tmp0_ = g_strdup ("/etc/ntkresolv/ntkresolv.ini");
	fname = _tmp0_;
	_tmp1_ = g_key_file_new ();
	conf = _tmp1_;
	{
		gboolean file_found;
		gboolean _tmp12_;
		file_found = FALSE;
		{
			GKeyFile* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = conf;
			_tmp3_ = fname;
			g_key_file_load_from_file (_tmp2_, _tmp3_, G_KEY_FILE_NONE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_KEY_FILE_ERROR) {
					goto __catch1_g_key_file_error;
				}
				goto __finally1;
			}
			file_found = TRUE;
		}
		goto __finally1;
		__catch1_g_key_file_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = e;
			if (g_error_matches (_tmp4_, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_NOT_FOUND)) {
			} else {
				GError* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp5_ = e;
				_tmp6_ = _tmp5_->message;
				_tmp7_ = string_to_string (_tmp6_);
				_tmp8_ = g_strconcat ("KeyFileError ", _tmp7_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = g_strconcat (LOG_LEAD, _tmp9_, NULL);
				_tmp11_ = _tmp10_;
				syslog (LOG_WARNING, _tmp11_, NULL);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp9_);
			}
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_tmp12_ = file_found;
		if (_tmp12_) {
			gboolean _tmp13_ = FALSE;
			GKeyFile* _tmp14_;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp19_;
			_tmp14_ = conf;
			_tmp15_ = g_key_file_has_group (_tmp14_, "NTKRESOLV");
			if (_tmp15_) {
				GKeyFile* _tmp16_;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_;
				_tmp16_ = conf;
				_tmp17_ = g_key_file_has_key (_tmp16_, "NTKRESOLV", "ANDNASERVER", &_inner_error_);
				_tmp18_ = _tmp17_;
				if (_inner_error_ != NULL) {
					goto __catch0_g_error;
				}
				_tmp13_ = _tmp18_;
			} else {
				_tmp13_ = FALSE;
			}
			_tmp19_ = _tmp13_;
			if (_tmp19_) {
				GKeyFile* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				_tmp20_ = conf;
				_tmp21_ = g_key_file_get_string (_tmp20_, "NTKRESOLV", "ANDNASERVER", &_inner_error_);
				_tmp22_ = _tmp21_;
				if (_inner_error_ != NULL) {
					goto __catch0_g_error;
				}
				_g_free0 (ret);
				ret = _tmp22_;
			} else {
				syslog (LOG_WARNING, LOG_LEAD "Missing server in ini file.", NULL);
			}
		} else {
			syslog (LOG_WARNING, LOG_LEAD "Didn't read ini file.", NULL);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Error ", _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (LOG_LEAD, _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		syslog (LOG_WARNING, _tmp29_, NULL);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (conf);
		_g_free0 (fname);
		_g_free0 (ret);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = ret;
	_g_key_file_free0 (conf);
	_g_free0 (fname);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* _tmp0_;
	GOptionContext* oc;
	GOptionEntry* _tmp1_ = NULL;
	GOptionEntry* entries;
	gint entries_length1;
	gint _entries_size_;
	gboolean reverse;
	gboolean ipv6;
	gint index;
	GOptionEntry* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	GOptionEntry _tmp4_ = {0};
	GOptionEntry _tmp5_;
	GOptionEntry* _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_;
	GOptionEntry _tmp8_ = {0};
	GOptionEntry _tmp9_;
	GOptionEntry* _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	GOptionEntry _tmp12_ = {0};
	GOptionEntry _tmp13_;
	GOptionContext* _tmp14_;
	GOptionEntry* _tmp15_;
	gint _tmp15__length1;
	gboolean _tmp22_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new ("- ANDNA Resolve tool");
	oc = _tmp0_;
	_tmp1_ = g_new0 (GOptionEntry, 3);
	entries = _tmp1_;
	entries_length1 = 3;
	_entries_size_ = entries_length1;
	reverse = FALSE;
	ipv6 = FALSE;
	index = 0;
	_tmp2_ = entries;
	_tmp2__length1 = entries_length1;
	_tmp3_ = index;
	index = _tmp3_ + 1;
	_tmp4_.long_name = "inverse";
	_tmp4_.short_name = 'x';
	_tmp4_.flags = 0;
	_tmp4_.arg = G_OPTION_ARG_NONE;
	_tmp4_.arg_data = &reverse;
	_tmp4_.description = "Inverse resolution";
	_tmp4_.arg_description = NULL;
	_tmp2_[_tmp3_] = _tmp4_;
	_tmp5_ = _tmp2_[_tmp3_];
	_tmp6_ = entries;
	_tmp6__length1 = entries_length1;
	_tmp7_ = index;
	index = _tmp7_ + 1;
	_tmp8_.long_name = "ipv6";
	_tmp8_.short_name = '6';
	_tmp8_.flags = 0;
	_tmp8_.arg = G_OPTION_ARG_NONE;
	_tmp8_.arg_data = &ipv6;
	_tmp8_.description = "Use IPv6";
	_tmp8_.arg_description = NULL;
	_tmp6_[_tmp7_] = _tmp8_;
	_tmp9_ = _tmp6_[_tmp7_];
	_tmp10_ = entries;
	_tmp10__length1 = entries_length1;
	_tmp11_ = index;
	index = _tmp11_ + 1;
	_tmp12_.long_name = NULL;
	_tmp10_[_tmp11_] = _tmp12_;
	_tmp13_ = _tmp10_[_tmp11_];
	_tmp14_ = oc;
	_tmp15_ = entries;
	_tmp15__length1 = entries_length1;
	g_option_context_add_main_entries (_tmp14_, _tmp15_, NULL);
	{
		GOptionContext* _tmp16_;
		_tmp16_ = oc;
		g_option_context_parse (_tmp16_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			entries = (g_free (entries), NULL);
			_g_option_context_free0 (oc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = g_strconcat ("Error parsing options: ", _tmp19_, "\n", NULL);
		_tmp21_ = _tmp20_;
		g_print ("%s", _tmp21_);
		_g_free0 (_tmp21_);
		result = 1;
		_g_error_free0 (e);
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		return result;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		entries = (g_free (entries), NULL);
		_g_option_context_free0 (oc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp22_ = reverse;
	if (!_tmp22_) {
		gboolean _tmp23_ = FALSE;
		gchar** _tmp24_;
		gint _tmp24__length1;
		gboolean _tmp26_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* node;
		gchar* service;
		NtkresolvNtkAddrInfo* hints;
		gchar* tcpaddress;
		gchar** _tmp35_;
		gint _tmp35__length1;
		GeeList* resp = NULL;
		_tmp24_ = args;
		_tmp24__length1 = args_length1;
		if (_tmp24__length1 != 2) {
			gchar** _tmp25_;
			gint _tmp25__length1;
			_tmp25_ = args;
			_tmp25__length1 = args_length1;
			_tmp23_ = _tmp25__length1 != 3;
		} else {
			_tmp23_ = FALSE;
		}
		_tmp26_ = _tmp23_;
		if (_tmp26_) {
			gchar** _tmp27_;
			gint _tmp27__length1;
			const gchar* _tmp28_;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			_tmp27_ = args;
			_tmp27__length1 = args_length1;
			_tmp28_ = _tmp27_[0];
			_tmp29_ = string_to_string (_tmp28_);
			_tmp30_ = g_strconcat ("Usage: ", _tmp29_, " hostname [ip_of_andna_server]\n", NULL);
			_tmp31_ = _tmp30_;
			g_print ("%s", _tmp31_);
			_g_free0 (_tmp31_);
			result = 1;
			entries = (g_free (entries), NULL);
			_g_option_context_free0 (oc);
			return result;
		}
		_tmp32_ = args;
		_tmp32__length1 = args_length1;
		_tmp33_ = _tmp32_[1];
		_tmp34_ = g_strdup (_tmp33_);
		node = _tmp34_;
		service = NULL;
		hints = NULL;
		tcpaddress = NULL;
		_tmp35_ = args;
		_tmp35__length1 = args_length1;
		if (_tmp35__length1 == 3) {
			gchar** _tmp36_;
			gint _tmp36__length1;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp36_ = args;
			_tmp36__length1 = args_length1;
			_tmp37_ = _tmp36_[2];
			_tmp38_ = g_strdup (_tmp37_);
			_g_free0 (tcpaddress);
			tcpaddress = _tmp38_;
		} else {
			gchar* _tmp39_ = NULL;
			_tmp39_ = get_andnaserver ();
			_g_free0 (tcpaddress);
			tcpaddress = _tmp39_;
		}
		{
			const gchar* _tmp40_;
			GeeList* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			_tmp40_ = tcpaddress;
			if (_tmp40_ == NULL) {
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				NtkresolvNtkAddrInfo* _tmp43_;
				GeeList* _tmp44_ = NULL;
				GeeList* _tmp45_;
				_tmp41_ = node;
				_tmp42_ = service;
				_tmp43_ = hints;
				_tmp44_ = ntkresolv_resolv (_tmp41_, _tmp42_, _tmp43_, "127.0.0.1", &_inner_error_);
				_tmp45_ = _tmp44_;
				if (_inner_error_ != NULL) {
					goto __catch3_g_error;
				}
				_g_object_unref0 (resp);
				resp = _tmp45_;
			} else {
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				NtkresolvNtkAddrInfo* _tmp48_;
				const gchar* _tmp49_;
				GeeList* _tmp50_ = NULL;
				GeeList* _tmp51_;
				_tmp46_ = node;
				_tmp47_ = service;
				_tmp48_ = hints;
				_tmp49_ = tcpaddress;
				_tmp50_ = ntkresolv_resolv (_tmp46_, _tmp47_, _tmp48_, _tmp49_, &_inner_error_);
				_tmp51_ = _tmp50_;
				if (_inner_error_ != NULL) {
					goto __catch3_g_error;
				}
				_g_object_unref0 (resp);
				resp = _tmp51_;
			}
			_tmp52_ = resp;
			_tmp53_ = gee_collection_get_size ((GeeCollection*) _tmp52_);
			_tmp54_ = _tmp53_;
			if (_tmp54_ == 0) {
				g_print (" No such domain.\n");
			} else {
				{
					GeeList* _tmp55_;
					GeeList* _tmp56_;
					GeeList* _ainfo_list;
					GeeList* _tmp57_;
					gint _tmp58_;
					gint _tmp59_;
					gint _ainfo_size;
					gint _ainfo_index;
					_tmp55_ = resp;
					_tmp56_ = _g_object_ref0 (_tmp55_);
					_ainfo_list = _tmp56_;
					_tmp57_ = _ainfo_list;
					_tmp58_ = gee_collection_get_size ((GeeCollection*) _tmp57_);
					_tmp59_ = _tmp58_;
					_ainfo_size = _tmp59_;
					_ainfo_index = -1;
					while (TRUE) {
						gint _tmp60_;
						gint _tmp61_;
						gint _tmp62_;
						GeeList* _tmp63_;
						gint _tmp64_;
						gpointer _tmp65_ = NULL;
						NtkresolvNtkAddrInfo* ainfo;
						NtkresolvNtkAddrInfo* _tmp66_;
						NtkresolvNtkAddr* _tmp67_;
						NtkresolvNtkInetAddr* _tmp68_;
						NtkresolvNtkInetAddr* addr;
						NtkresolvNtkInetAddr* _tmp69_;
						_tmp60_ = _ainfo_index;
						_ainfo_index = _tmp60_ + 1;
						_tmp61_ = _ainfo_index;
						_tmp62_ = _ainfo_size;
						if (!(_tmp61_ < _tmp62_)) {
							break;
						}
						_tmp63_ = _ainfo_list;
						_tmp64_ = _ainfo_index;
						_tmp65_ = gee_list_get (_tmp63_, _tmp64_);
						ainfo = (NtkresolvNtkAddrInfo*) _tmp65_;
						_tmp66_ = ainfo;
						_tmp67_ = _tmp66_->address;
						_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, NTKRESOLV_TYPE_NTK_INET_ADDR) ? ((NtkresolvNtkInetAddr*) _tmp67_) : NULL);
						addr = _tmp68_;
						_tmp69_ = addr;
						if (_tmp69_ == NULL) {
							g_print (" * Not supported address.\n");
						} else {
							NtkresolvNtkInetAddr* _tmp70_;
							gchar* _tmp71_ = NULL;
							gchar* ipstr;
							const gchar* _tmp72_;
							const gchar* _tmp73_ = NULL;
							NtkresolvNtkInetAddr* _tmp74_;
							guint16 _tmp75_;
							gchar* _tmp76_ = NULL;
							gchar* _tmp77_;
							gchar* _tmp78_ = NULL;
							gchar* _tmp79_;
							_tmp70_ = addr;
							_tmp71_ = netsukuku_inet_utils_address_v4_bytes_to_str (_tmp70_->addr, 4);
							ipstr = _tmp71_;
							_tmp72_ = ipstr;
							_tmp73_ = string_to_string (_tmp72_);
							_tmp74_ = addr;
							_tmp75_ = _tmp74_->port;
							_tmp76_ = g_strdup_printf ("%hu", _tmp75_);
							_tmp77_ = _tmp76_;
							_tmp78_ = g_strconcat (" * ", _tmp73_, ":", _tmp77_, "\n", NULL);
							_tmp79_ = _tmp78_;
							g_print ("%s", _tmp79_);
							_g_free0 (_tmp79_);
							_g_free0 (_tmp77_);
							_g_free0 (ipstr);
						}
						_g_object_unref0 (addr);
						_g_object_unref0 (ainfo);
					}
					_g_object_unref0 (_ainfo_list);
				}
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			gchar** _tmp80_;
			gint _tmp80__length1;
			const gchar* _tmp81_;
			const gchar* _tmp82_ = NULL;
			GError* _tmp83_;
			const gchar* _tmp84_;
			const gchar* _tmp85_ = NULL;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp80_ = args;
			_tmp80__length1 = args_length1;
			_tmp81_ = _tmp80_[0];
			_tmp82_ = string_to_string (_tmp81_);
			_tmp83_ = e;
			_tmp84_ = _tmp83_->message;
			_tmp85_ = string_to_string (_tmp84_);
			_tmp86_ = g_strconcat (_tmp82_, ": ", _tmp85_, "\n", NULL);
			_tmp87_ = _tmp86_;
			g_print ("%s", _tmp87_);
			_g_free0 (_tmp87_);
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (resp);
			_g_free0 (tcpaddress);
			_g_object_unref0 (hints);
			_g_free0 (service);
			_g_free0 (node);
			entries = (g_free (entries), NULL);
			_g_option_context_free0 (oc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_object_unref0 (resp);
		_g_free0 (tcpaddress);
		_g_object_unref0 (hints);
		_g_free0 (service);
		_g_free0 (node);
	} else {
		gboolean _tmp88_ = FALSE;
		gchar** _tmp89_;
		gint _tmp89__length1;
		gboolean _tmp91_;
		NtkresolvIpFamily family;
		guint8 addr_bytes[4] = {0};
		gchar** _tmp97_;
		gint _tmp97__length1;
		const gchar* _tmp98_;
		NtkresolvNtkInetAddr* _tmp99_;
		NtkresolvNtkAddr* addr;
		gchar* tcpaddress;
		gchar** _tmp100_;
		gint _tmp100__length1;
		GeeList* resp = NULL;
		_tmp89_ = args;
		_tmp89__length1 = args_length1;
		if (_tmp89__length1 != 2) {
			gchar** _tmp90_;
			gint _tmp90__length1;
			_tmp90_ = args;
			_tmp90__length1 = args_length1;
			_tmp88_ = _tmp90__length1 != 3;
		} else {
			_tmp88_ = FALSE;
		}
		_tmp91_ = _tmp88_;
		if (_tmp91_) {
			gchar** _tmp92_;
			gint _tmp92__length1;
			const gchar* _tmp93_;
			const gchar* _tmp94_ = NULL;
			gchar* _tmp95_ = NULL;
			gchar* _tmp96_;
			_tmp92_ = args;
			_tmp92__length1 = args_length1;
			_tmp93_ = _tmp92_[0];
			_tmp94_ = string_to_string (_tmp93_);
			_tmp95_ = g_strconcat ("Usage: ", _tmp94_, " -x addr [ip_of_andna_server]\n", NULL);
			_tmp96_ = _tmp95_;
			g_print ("%s", _tmp96_);
			_g_free0 (_tmp96_);
			result = 1;
			entries = (g_free (entries), NULL);
			_g_option_context_free0 (oc);
			return result;
		}
		family = NTKRESOLV_IP_FAMILY_IPV4;
		_tmp97_ = args;
		_tmp97__length1 = args_length1;
		_tmp98_ = _tmp97_[1];
		netsukuku_inet_utils_address_v4_str_to_bytes (_tmp98_, addr_bytes);
		_tmp99_ = ntkresolv_ntk_inet_addr_new (addr_bytes, 4, (guint16) 0);
		addr = (NtkresolvNtkAddr*) _tmp99_;
		tcpaddress = NULL;
		_tmp100_ = args;
		_tmp100__length1 = args_length1;
		if (_tmp100__length1 == 3) {
			gchar** _tmp101_;
			gint _tmp101__length1;
			const gchar* _tmp102_;
			gchar* _tmp103_;
			_tmp101_ = args;
			_tmp101__length1 = args_length1;
			_tmp102_ = _tmp101_[2];
			_tmp103_ = g_strdup (_tmp102_);
			_g_free0 (tcpaddress);
			tcpaddress = _tmp103_;
		} else {
			gchar* _tmp104_ = NULL;
			_tmp104_ = get_andnaserver ();
			_g_free0 (tcpaddress);
			tcpaddress = _tmp104_;
		}
		{
			const gchar* _tmp105_;
			GeeList* _tmp115_;
			gint _tmp116_;
			gint _tmp117_;
			_tmp105_ = tcpaddress;
			if (_tmp105_ == NULL) {
				NtkresolvIpFamily _tmp106_;
				NtkresolvNtkAddr* _tmp107_;
				GeeList* _tmp108_ = NULL;
				GeeList* _tmp109_;
				_tmp106_ = family;
				_tmp107_ = addr;
				_tmp108_ = ntkresolv_inverse (_tmp106_, _tmp107_, "127.0.0.1", &_inner_error_);
				_tmp109_ = _tmp108_;
				if (_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
				_g_object_unref0 (resp);
				resp = _tmp109_;
			} else {
				NtkresolvIpFamily _tmp110_;
				NtkresolvNtkAddr* _tmp111_;
				const gchar* _tmp112_;
				GeeList* _tmp113_ = NULL;
				GeeList* _tmp114_;
				_tmp110_ = family;
				_tmp111_ = addr;
				_tmp112_ = tcpaddress;
				_tmp113_ = ntkresolv_inverse (_tmp110_, _tmp111_, _tmp112_, &_inner_error_);
				_tmp114_ = _tmp113_;
				if (_inner_error_ != NULL) {
					goto __catch4_g_error;
				}
				_g_object_unref0 (resp);
				resp = _tmp114_;
			}
			_tmp115_ = resp;
			_tmp116_ = gee_collection_get_size ((GeeCollection*) _tmp115_);
			_tmp117_ = _tmp116_;
			if (_tmp117_ == 0) {
				g_print (" No hostnames.\n");
			} else {
				{
					GeeList* _tmp118_;
					GeeList* _tmp119_;
					GeeList* _hname_list;
					GeeList* _tmp120_;
					gint _tmp121_;
					gint _tmp122_;
					gint _hname_size;
					gint _hname_index;
					_tmp118_ = resp;
					_tmp119_ = _g_object_ref0 (_tmp118_);
					_hname_list = _tmp119_;
					_tmp120_ = _hname_list;
					_tmp121_ = gee_collection_get_size ((GeeCollection*) _tmp120_);
					_tmp122_ = _tmp121_;
					_hname_size = _tmp122_;
					_hname_index = -1;
					while (TRUE) {
						gint _tmp123_;
						gint _tmp124_;
						gint _tmp125_;
						GeeList* _tmp126_;
						gint _tmp127_;
						gpointer _tmp128_ = NULL;
						gchar* hname;
						const gchar* _tmp129_;
						const gchar* _tmp130_ = NULL;
						gchar* _tmp131_ = NULL;
						gchar* _tmp132_;
						_tmp123_ = _hname_index;
						_hname_index = _tmp123_ + 1;
						_tmp124_ = _hname_index;
						_tmp125_ = _hname_size;
						if (!(_tmp124_ < _tmp125_)) {
							break;
						}
						_tmp126_ = _hname_list;
						_tmp127_ = _hname_index;
						_tmp128_ = gee_list_get (_tmp126_, _tmp127_);
						hname = (gchar*) _tmp128_;
						_tmp129_ = hname;
						_tmp130_ = string_to_string (_tmp129_);
						_tmp131_ = g_strconcat (" * ", _tmp130_, "\n", NULL);
						_tmp132_ = _tmp131_;
						g_print ("%s", _tmp132_);
						_g_free0 (_tmp132_);
						_g_free0 (hname);
					}
					_g_object_unref0 (_hname_list);
				}
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			gchar** _tmp133_;
			gint _tmp133__length1;
			const gchar* _tmp134_;
			const gchar* _tmp135_ = NULL;
			GError* _tmp136_;
			const gchar* _tmp137_;
			const gchar* _tmp138_ = NULL;
			gchar* _tmp139_ = NULL;
			gchar* _tmp140_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp133_ = args;
			_tmp133__length1 = args_length1;
			_tmp134_ = _tmp133_[0];
			_tmp135_ = string_to_string (_tmp134_);
			_tmp136_ = e;
			_tmp137_ = _tmp136_->message;
			_tmp138_ = string_to_string (_tmp137_);
			_tmp139_ = g_strconcat (_tmp135_, ": ", _tmp138_, "\n", NULL);
			_tmp140_ = _tmp139_;
			g_print ("%s", _tmp140_);
			_g_free0 (_tmp140_);
			_g_error_free0 (e);
		}
		__finally4:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (resp);
			_g_free0 (tcpaddress);
			_g_object_unref0 (addr);
			entries = (g_free (entries), NULL);
			_g_option_context_free0 (oc);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
		_g_object_unref0 (resp);
		_g_free0 (tcpaddress);
		_g_object_unref0 (addr);
	}
	result = 0;
	entries = (g_free (entries), NULL);
	_g_option_context_free0 (oc);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



